/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.BondClassifier;
import chemaxon.core.calculations.RingClassifier;
import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.enumeration.supergraph.SupergraphException;
import chemaxon.enumeration.supergraph.util.SupergraphBondClassifier;
import chemaxon.sss.search.MolComparator;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.util.Arrays;
import java.util.Stack;
import java.util.Vector;

public class ReducedGraph
extends Supergraph {
    private boolean mixedHetero = true;
    public static final int TARGET = 0;
    public static final int QUERY_FP = 1;
    public static final int QUERY_ABAS = 2;
    private int reducedType = 0;
    private static final String INDEX_BEFORE_MERGE = "Index before merge";
    public static final String C = "C";
    public static final String Z = "Z";
    public static final String RC = "RC";
    public static final String RZ = "RZ";
    private Molecule original = null;
    private int maxID = 0;
    private RgMolecule reduced = null;
    private MoleculeGraph union = null;
    private RingClassifier bClass = null;
    private static final String[] aliases = new String[]{"C", "Z", "RC", "RZ"};
    private static final int[] atNums = new int[]{6, 7, 8, 9};
    boolean sgMerge = false;

    @Override
    public void setMolecule(Molecule mol) throws SupergraphException {
        this.original = mol;
        this.init();
        this.preMerge();
        this.mergeOnMarkush();
        super.setMolecule(this.reduced);
        this.mergeOnSupergraph();
    }

    public void setMolecule(Molecule mol, int query) throws SupergraphException {
        this.reducedType = query;
        this.setMolecule(mol);
    }

    private void init() {
        HomologyConversionUtil hcu = new HomologyConversionUtil(this.original);
        this.original = hcu.getConvertedMol();
        if (this.original instanceof RgMolecule) {
            this.reduced = (RgMolecule)this.original.cloneMolecule();
        } else {
            this.reduced = new RgMolecule();
            this.reduced.setRoot(this.original.cloneMolecule());
        }
        this.expandUngroupSgroups();
        this.union = this.reduced.getGraphUnion();
        this.sgMerge = false;
        for (int i = this.union.getAtomCount() - 1; i >= 0; --i) {
            if (i >= this.union.getAtomCount()) continue;
            MolAtom atom = this.union.getAtom(i);
            switch (atom.getAtno()) {
                case 130: {
                    this.reduced.removeAtom(atom);
                    break;
                }
                case 1: {
                    if (this.reducedType == 0 || atom.getAttach() == 0) {
                        this.reduced.removeAtom(atom);
                        break;
                    }
                    int rgID = this.reduced.rgroupIdOf(atom);
                    this.removeRgr(rgID);
                    break;
                }
                case 128: {
                    this.reduceAtomLists(atom);
                    break;
                }
                case 136: {
                    this.classifyHomologyAtom(atom);
                    break;
                }
            }
            if (!atom.isLinkNode()) continue;
            int repetitions = this.reducedType != 0 ? atom.getMinRepetitions() : atom.getMaxRepetitions();
            ExpansionUtil.insertLinkPart((Molecule)atom.getParent(), atom, repetitions);
        }
        this.bClass = null;
    }

    private void reduceAtomLists(MolAtom atom) {
        int[] list = atom.getList();
        if (this.reducedType != 0 && ArrayTools.foundInArray(list, 1)) {
            this.reduced.removeAtom(atom);
            return;
        }
        if (list.length == 1) {
            atom.setAtno(list[0]);
            return;
        }
        if (!ArrayTools.foundInArray(list, 6)) {
            atom.setAtno(7);
            return;
        }
        if (list.length == 2 && ArrayTools.foundInArray(list, 1) && ArrayTools.foundInArray(list, 6)) {
            atom.setAtno(6);
            return;
        }
        list = new int[]{6, 7};
        atom.setList(list);
    }

    private void expandUngroupSgroups() {
        this.reduced.expandSgroups();
        for (int i = this.reduced.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sg = this.reduced.getSgroup(i);
            if (sg instanceof MulticenterSgroup) continue;
            MolAtom atom1 = null;
            MolAtom atom2 = null;
            if (sg.getParentMolecule().getAtomCount() == sg.getAtomCount()) {
                for (int j = sg.getAtomCount() - 1; j >= 0; --j) {
                    if ((sg.getAtom(j).getAttach() & 1) != 0) {
                        atom1 = sg.getAtom(j);
                    }
                    if ((sg.getAtom(j).getAttach() & 2) == 0) continue;
                    atom2 = sg.getAtom(j);
                }
            }
            this.reduced.ungroupSgroup(sg);
            if (atom1 != null) {
                atom1.setAttach(1);
            }
            if (atom2 == null) continue;
            atom2.setAttach(atom2.getAttach() | 2);
        }
    }

    private void removeRgr(int rgID) {
        for (int i = this.union.getAtomCount() - 1; i >= 0; ++i) {
            MolAtom atom;
            if (i >= this.union.getAtomCount() || (atom = this.union.getAtom(i)).getRgroup() != rgID) continue;
            if (atom.getAttach() != 0 && this.reducedType == 1) {
                int containingRgID = this.reduced.rgroupIdOf(atom);
                if (containingRgID == -1) continue;
                this.removeRgr(containingRgID);
                continue;
            }
            this.reduced.removeAtom(atom);
        }
        int rgIndex = this.reduced.findRgroupIndex(rgID);
        for (int i = this.reduced.getRgroupMemberCount(rgIndex) - 1; i >= 0; --i) {
            Molecule rgm = this.reduced.getRgroupMember(rgIndex, i);
            for (int j = rgm.getAtomCount() - 1; j >= 0; --j) {
                this.reduced.removeAtom(rgm.getAtom(j));
            }
        }
    }

    private void preMerge() {
        Stack<MolAtom> toCheck = new Stack<MolAtom>();
        this.union = this.reduced.getGraphUnion();
        int nodeCount = this.union.getAtomCount();
        for (int i = 0; i < nodeCount; ++i) {
            MolAtom atom = this.union.getAtom(i);
            if (!this.canPreClassifyAsTree(atom)) continue;
            this.classify(atom, true);
            for (int j = 0; j < atom.getBondCount(); ++j) {
                toCheck.push(atom.getBond(j).getOtherAtom(atom));
            }
        }
        while (toCheck.size() > 0) {
            MolAtom atom = (MolAtom)toCheck.pop();
            if (!this.canPreClassifyAsTree(atom)) continue;
            this.classify(atom, true);
            for (int j = 0; j < atom.getBondCount(); ++j) {
                toCheck.push(atom.getBond(j).getOtherAtom(atom));
            }
        }
        this.mergeUnionAtoms();
    }

    private void classifyHomologyAtom(MolAtom atom) {
        if (!atom.isPseudo()) {
            return;
        }
        String name = atom.getAliasstr();
        if (!HomologyConstants.isHandledHomology(name)) {
            return;
        }
        String aliasStr = null;
        aliasStr = name.equalsIgnoreCase("alkyl") || name.equalsIgnoreCase("alkenyl") || name.equalsIgnoreCase("alkynyl") ? C : (name.equalsIgnoreCase("aryl") || name.equalsIgnoreCase("cycloalkyl") ? RC : (name.equalsIgnoreCase("heteroAryl") || name.equalsIgnoreCase("heterocycle") || name.equalsIgnoreCase("fusedhetero") ? RZ : Z));
        atom.setAliasstr(aliasStr);
    }

    private boolean canPreClassifyAsTree(MolAtom atom) {
        if (atom.getAtno() > 109) {
            return false;
        }
        if (atom.getBondCount() + atom.getAttach() < 2) {
            return true;
        }
        int numOfUnC = 0;
        if (atom.getAttach() != 0) {
            numOfUnC = atom.getAttach() == 3 ? 2 : 1;
        }
        for (int i = 0; i < atom.getBondCount() && numOfUnC < 2; ++i) {
            MolAtom neigh = atom.getBond(i).getOtherAtom(atom);
            if (this.isTreePseudo(neigh) || neigh.getBondCount() + neigh.getAttach() <= 1) continue;
            ++numOfUnC;
        }
        return numOfUnC < 2;
    }

    private void classify(MolAtom atom, boolean isTree) {
        boolean isCarbo = atom.getAtno() == 6;
        String aliasStr = null;
        aliasStr = isCarbo ? (isTree ? C : RC) : (isTree ? Z : RZ);
        atom.setAtno(136);
        atom.setAliasstr(aliasStr);
    }

    private void mergeOnMarkush() throws SupergraphException {
        this.dupplicateDefinitions();
        this.mergeMarkushPart(this.reduced.getRoot(), -1);
        for (int i = 0; i < this.reduced.getRgroupCount(); ++i) {
            for (int j = 0; j < this.reduced.getRgroupMemberCount(i); ++j) {
                this.mergeMarkushPart(this.reduced.getRgroupMember(i, j), i);
            }
        }
        this.reduced.valenceCheck();
        do {
            this.mergeSubStructureRgDefs();
            this.clearEmptyRgrMembers();
        } while (this.checkDeletableMarkush());
        this.clearOneCOnRings();
    }

    private void clearEmptyRgrMembers() {
        RgMolecule mol = (RgMolecule)this.reduced.newInstance();
        int rgCount = this.reduced.getRgroupCount();
        for (int i = 0; i < rgCount; ++i) {
            int rgid = this.reduced.getRgroupId(i);
            int count = this.reduced.getRgroupMemberCount(i);
            for (int j = 0; j < count; ++j) {
                Molecule m = this.reduced.getRgroupMember(i, j);
                if (m.getAtomCount() <= 0) continue;
                mol.addRgroup(rgid, m);
            }
        }
        mol.fuse(this.reduced.getRoot(), false);
        this.reduced = mol;
    }

    private void clearOneCOnRings() {
        int j;
        int i;
        this.union = this.reduced.getGraphUnion();
        Vector<MolAtom> inMSG = new Vector<MolAtom>();
        for (i = 0; i < this.reduced.getSgroupCount(); ++i) {
            Sgroup sg = this.reduced.getSgroup(i);
            if (!(sg instanceof MulticenterSgroup)) continue;
            for (j = 0; j < sg.getAtomCount(); ++j) {
                inMSG.add(sg.getAtom(j));
            }
        }
        for (i = this.union.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = this.union.getAtom(i);
            if (!this.isRingPseudo(atom)) continue;
            for (j = 0; j < atom.getBondCount(); ++j) {
                MolAtom other = atom.getBond(j).getOtherAtom(atom);
                if (other.getBondCount() != 1 || other.getAttach() != 0 || !other.isPseudo() || !other.getAliasstr().equalsIgnoreCase(C) || inMSG.contains(other) && this.reducedType == 0) continue;
                if (this.union.indexOf(other) < i) {
                    --i;
                }
                this.reduced.removeAtom(other);
            }
        }
    }

    private boolean checkDeletableMarkush() {
        int i;
        boolean hasDeletable = false;
        this.union = this.reduced.getGraphUnion();
        for (int i2 = this.union.getAtomCount() - 1; i2 >= 0; --i2) {
            MulticenterSgroup msg;
            MolAtom atom = this.union.getAtom(i2);
            if (atom.getAtno() != 137 || (msg = this.reduced.findContainingMulticenterSgroup(atom)).getAtomCount() != 1 || atom.getBondCount() != 1) continue;
            MolAtom varSideAtom = msg.getAtom(0);
            MolAtom fixAtom = atom.getBond(0).getOtherAtom(atom);
            MolBond newBond = new MolBond(varSideAtom, fixAtom, atom.getBond(0).getType());
            this.reduced.add(newBond);
            this.reduced.removeBond(atom.getBond(0));
            this.reduced.ungroupSgroup(msg);
        }
        this.union = this.reduced.getGraphUnion();
        IntVector rgrIdToReplace = new IntVector();
        for (i = 0; i < this.reduced.getRgroupCount(); ++i) {
            if (this.reduced.getRgroupMemberCount(i) > 1) continue;
            rgrIdToReplace.add(this.reduced.getRgroupId(i));
        }
        if (rgrIdToReplace.size() > 0) {
            for (i = this.union.getAtomCount() - 1; i >= 0; --i) {
                int rgId;
                MolAtom atom = this.union.getAtom(i);
                if (atom.getAtno() != 134 || !rgrIdToReplace.contains(rgId = atom.getRgroup())) continue;
                hasDeletable = true;
                int rgInd = this.reduced.findRgroupIndex(rgId);
                Molecule parent = (Molecule)atom.getParent();
                MolAtom[] helperAtoms = this.addHelperAtoms(parent, atom);
                ExpansionUtil.insertRgroupMember(parent, atom, this.reduced.getRgroupMember(rgInd, 0).cloneMolecule(), true);
                this.removeHelperAtoms(parent, atom, helperAtoms);
                this.union = parent;
                this.mergeUnionAtoms();
                this.union = this.reduced.getGraphUnion();
            }
        }
        if (hasDeletable) {
            this.reduced = (RgMolecule)ExpansionUtil.fixRgroupDefs(this.reduced);
        }
        return hasDeletable;
    }

    private void removeHelperAtoms(Molecule parent, MolAtom rAtom, MolAtom[] helperAtoms) {
        for (int i = 0; i < 2; ++i) {
            if (helperAtoms[i] == null) continue;
            MolAtom neigh = helperAtoms[i].getBond(0).getOtherAtom(helperAtoms[i]);
            if (i == 0) {
                neigh.setAttach(1);
            } else {
                int att = neigh.getAttach() | 2;
                neigh.setAttach(att);
            }
            parent.removeAtom(helperAtoms[i]);
        }
    }

    private MolAtom[] addHelperAtoms(Molecule parent, MolAtom rAtom) {
        MolAtom[] helperAtoms = new MolAtom[2];
        for (int i = 0; i < 2; ++i) {
            helperAtoms[i] = null;
        }
        int att = rAtom.getAttach();
        if ((att & 1) != 0) {
            helperAtoms[0] = new MolAtom(6);
            parent.add(helperAtoms[0]);
            parent.add(new MolBond(rAtom, helperAtoms[0]));
        }
        if ((att & 2) != 0) {
            helperAtoms[1] = new MolAtom(6);
            parent.add(helperAtoms[1]);
            parent.add(new MolBond(rAtom, helperAtoms[1]));
        }
        rAtom.setAttach(0);
        return helperAtoms;
    }

    private void mergeSubStructureRgDefs() throws SupergraphException {
        MolSearch ms = new MolSearch();
        ms.getSearchOptions().setKeepQueryOrder(true);
        ms.getSearchOptions().setExactBondMatching(true);
        ms.getSearchOptions().setExactQueryAtomMatching(true);
        AttachRgrComparator attC = new AttachRgrComparator();
        ms.addComparator(attC);
        for (int i = 0; i < this.reduced.getRgroupCount(); ++i) {
            try {
                for (int j = 0; j < this.reduced.getRgroupMemberCount(i); ++j) {
                    Molecule target = this.reduced.getRgroupMember(i, j).cloneMolecule();
                    if (target.getAtomCount() == 0) continue;
                    ms.setTarget(target);
                    attC.setTargetData(target);
                    for (int k = 0; k < this.reduced.getRgroupMemberCount(i); ++k) {
                        Molecule query;
                        if (k == j || (query = this.reduced.getRgroupMember(i, k)).getAtomCount() > target.getAtomCount() || query.getAtomCount() == 0) continue;
                        ms.setQuery(query);
                        attC.setQueryData(query);
                        if (!ms.isMatching()) continue;
                        for (int u = query.getAtomCount() - 1; u >= 0; --u) {
                            query.removeAtom(u);
                        }
                    }
                }
                continue;
            }
            catch (SearchException e) {
                throw new SupergraphException("Error during merging of Rgroup " + i + e.getMessage());
            }
        }
    }

    private void dupplicateDefinitions() {
        int i;
        if (this.reduced.getRgroupCount() == 0) {
            return;
        }
        this.maxID = 1;
        for (i = 0; i < this.reduced.getRgroupCount(); ++i) {
            int id = this.reduced.getRgroupId(i);
            this.maxID = this.maxID < id ? id : this.maxID;
        }
        for (i = this.reduced.getRgroupCount() - 1; i >= 0; --i) {
            if (this.reduced.getRgroupMemberCount(i) <= 0 || this.numOfAttach(this.reduced.getRgroupMember(i, 0)) != 2) continue;
            int newID = this.tree2RingID(this.reduced.getRgroupId(i));
            for (int j = 0; j < this.reduced.getRgroupMemberCount(i); ++j) {
                this.reduced.addRgroup(newID, this.reduced.getRgroupMember(i, j).cloneMolecule());
            }
        }
    }

    private int tree2RingID(int rgroupId) {
        return rgroupId <= this.maxID ? rgroupId + this.maxID + 1 : rgroupId;
    }

    private void mergeMarkushPart(Molecule mol, int rgInd) {
        this.union = mol.getGraphUnion();
        MolBond twoAttachRgrBond = rgInd >= 0 ? this.bindTwoAttachRgrInRing(mol, rgInd) : null;
        this.doClassification(mol);
        if (twoAttachRgrBond != null) {
            mol.removeBond(twoAttachRgrBond);
        }
        this.mergeUnionAtoms();
    }

    private void doClassification(Molecule mol) {
        int atNum = mol.getAtomCount();
        this.bClass = mol instanceof Supergraph ? new SupergraphBondClassifier() : new BondClassifier();
        this.bClass.classify(mol);
        for (int i = 0; i < atNum; ++i) {
            MolAtom atom = mol.getAtom(i);
            if (atom.getAtno() <= 109) {
                this.classify(atom, !this.bClass.isRingAtom(i));
            } else if (atom.getAtno() == 134 && atom.getBondCount() == 2 && this.bClass.isRingAtom(i)) {
                atom.setRgroup(this.tree2RingID(atom.getRgroup()));
            }
            for (int j = 0; j < atom.getBondCount(); ++j) {
                int otherAtom;
                MolBond bond = atom.getBond(j);
                if (this.isRingBond(bond) || (otherAtom = mol.indexOf(bond.getOtherAtom(atom))) <= i) continue;
                this.setBondType(bond, this.bClass.isRingBond(i, otherAtom));
            }
        }
    }

    private void setBondType(MolBond bond, boolean isRing) {
        if (isRing) {
            bond.setFlags(1024, 3072);
        } else {
            bond.setFlags(2048, 3072);
        }
    }

    private boolean isRingBond(MolBond bond) {
        return (bond.getFlags() & 0xC00) == 1024;
    }

    /*
     * Enabled aggressive block sorting
     */
    private MolBond bindTwoAttachRgrInRing(Molecule mol, int rgInd) {
        int id;
        if (this.numOfAttach(mol) != 2 || mol.getAtomCount() == 0) {
            return null;
        }
        int n = id = rgInd >= 0 ? this.reduced.getRgroupId(rgInd) : -1;
        if (id != this.tree2RingID(id)) {
            return null;
        }
        MolAtom atom1 = null;
        MolAtom atom2 = null;
        block6: for (int i = 0; i < mol.getAtomCount(); ++i) {
            int att = mol.getAtom(i).getAttach();
            switch (att) {
                case 0: {
                    break;
                }
                case 1: {
                    atom1 = mol.getAtom(i);
                    break;
                }
                case 2: {
                    atom2 = mol.getAtom(i);
                    break;
                }
                case 3: {
                    atom2 = atom1 = mol.getAtom(i);
                    break block6;
                }
            }
        }
        if (atom1 == null || atom2 == null) {
            return null;
        }
        if (atom1 == atom2) {
            if (atom1.getAtno() < 109) {
                this.classify(atom1, false);
            }
            return null;
        }
        if (!atom1.isBoundTo(atom2)) {
            MolBond ret = new MolBond(atom1, atom2);
            mol.add(ret);
            return ret;
        }
        if (atom1.getAtno() < 109) {
            this.classify(atom1, false);
        }
        if (atom2.getAtno() < 109) {
            this.classify(atom2, false);
        }
        this.setBondType(atom1.getBondTo(atom2), true);
        return null;
    }

    private void mergeUnionAtoms() {
        boolean didMerge = true;
        while (didMerge) {
            didMerge = false;
            block1: for (int i = 0; i < this.union.getAtomCount(); ++i) {
                MolAtom atom1 = this.union.getAtom(i);
                for (int j = 0; j < atom1.getBondCount(); ++j) {
                    MolAtom atom2 = atom1.getBond(j).getOtherAtom(atom1);
                    int merging = this.areMergeableTypes(atom1, atom2, atom1.getBond(j));
                    if (merging == 0) continue;
                    didMerge = true;
                    if (merging == 1) {
                        this.myMergeAtoms(atom1, atom2);
                        i = this.union.indexOf(atom2) - 1;
                        continue block1;
                    }
                    this.myMergeAtoms(atom2, atom1);
                    i = this.union.indexOf(atom1) - 1;
                    continue block1;
                }
            }
        }
    }

    private int numOfAttach(Molecule mol) {
        int num = 0;
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            int attach = mol.getAtom(i).getAttach();
            if (attach == 0) continue;
            num += attach == 3 ? 2 : 1;
        }
        return num;
    }

    private int areMergeableTypes(MolAtom atom1, MolAtom atom2, MolBond molBond) {
        if (atom1.getAtno() == 134 || atom2.getAtno() == 134) {
            return 0;
        }
        int atNo1 = atom1.getAtno();
        int atNo2 = atom2.getAtno();
        if (atNo1 <= 109 && atNo2 <= 109 && atom1.getBondCount() == 2 && atom2.getBondCount() == 2 && this.inTriangle(atom1, atom2) == -1) {
            boolean isCarbo2;
            boolean isCarbo1 = atNo1 == 6;
            boolean bl = isCarbo2 = atNo2 == 6;
            if (this.mixedHetero || isCarbo1 && isCarbo2 || !isCarbo1 && !isCarbo2) {
                if (this.mixedHetero) {
                    if (isCarbo1 == isCarbo2) {
                        return 3;
                    }
                    return isCarbo1 ? 1 : 2;
                }
                return 3;
            }
        }
        if (atNo1 == 136 && atNo2 == 136) {
            int triangleBondindex;
            int n = triangleBondindex = this.sgMerge ? -1 : this.inTriangle(atom1, atom2);
            if (this.isRingPseudo(atom1) && this.isRingPseudo(atom2) && this.isRingBond(molBond) && (triangleBondindex == -1 || atom1.getBond(triangleBondindex).getOtherAtom(atom1).getAtno() != 134)) {
                if (atom1.getAliasstr().equalsIgnoreCase(atom2.getAliasstr())) {
                    return 3;
                }
                return this.isHeteroPseudo(atom1) ? 2 : 1;
            }
            if (this.isTreePseudo(atom1) && this.isTreePseudo(atom2)) {
                if (this.mixedHetero) {
                    if (atom1.getAliasstr().equalsIgnoreCase(atom2.getAliasstr())) {
                        return 3;
                    }
                    return this.isHeteroPseudo(atom1) ? 2 : 1;
                }
                return atom1.getAliasstr().equalsIgnoreCase(atom2.getAliasstr()) ? 3 : 0;
            }
            return 0;
        }
        return 0;
    }

    private int inTriangle(MolAtom atom1, MolAtom atom2) {
        for (int i = atom1.getBondCount() - 1; i >= 0; --i) {
            for (int j = atom2.getBondCount() - 1; j >= 0; --j) {
                if (atom1.getBond(i).getOtherAtom(atom1) != atom2.getBond(j).getOtherAtom(atom2)) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean isRingPseudo(MolAtom atom) {
        String alias = atom.getAliasstr();
        if (alias == null) {
            return false;
        }
        return alias.equalsIgnoreCase(RC) || alias.equalsIgnoreCase(RZ);
    }

    private boolean isHeteroPseudo(MolAtom atom) {
        String alias = atom.getAliasstr();
        if (alias == null) {
            return false;
        }
        return alias.equalsIgnoreCase(Z) || alias.equalsIgnoreCase(RZ);
    }

    private boolean isTreePseudo(MolAtom atom) {
        String alias = atom.getAliasstr();
        if (alias == null) {
            return false;
        }
        return alias.equalsIgnoreCase(C) || alias.equalsIgnoreCase(Z);
    }

    private void myMergeAtoms(MolAtom fromA, MolAtom toA) {
        MoleculeGraph parent = fromA.getParent();
        boolean v = parent.isValenceCheckEnabled();
        parent.setValenceCheckEnabled(false);
        for (int i = fromA.getBondCount() - 1; i >= 0; --i) {
            MolBond b = fromA.getBond(i);
            MolAtom bondOtherEnd = b.getOtherAtom(fromA);
            if (bondOtherEnd == toA || toA.isBoundTo(bondOtherEnd)) {
                if (this.sgMerge) {
                    this.isolate(b);
                    continue;
                }
                parent.removeBond(b);
                continue;
            }
            MolBond newBond = new MolBond(bondOtherEnd, toA, b.getFlags());
            if (this.sgMerge) {
                this.add(newBond);
                this.isolate(b);
                continue;
            }
            parent.removeBond(b);
            parent.add(newBond);
        }
        int attF = fromA.getAttach();
        if (attF != 0) {
            int attT = toA.getAttach();
            if (attF != 0 && attT != 0) {
                toA.setAttach(3);
            } else if (attT == 0) {
                toA.setAttach(attF);
            }
        }
        if (fromA.getParent() instanceof Molecule) {
            Sgroup[] sgV = ((Molecule)fromA.getParent()).findAllSgroupContaining(fromA);
            for (int i = 0; i < sgV.length; ++i) {
                if (!(sgV[i] instanceof MulticenterSgroup) || !sgV[i].hasAtom(fromA)) continue;
                if (!sgV[i].hasAtom(toA)) {
                    sgV[i].add(toA);
                }
                sgV[i].removeAtom(fromA);
            }
        }
        if (this.sgMerge) {
            for (int i = 0; i < fromA.getBondCount(); ++i) {
                this.isolate(fromA.getBond(i));
            }
        } else {
            parent.removeAtom(fromA);
        }
        parent.setValenceCheckEnabled(v);
    }

    private boolean areNeighbours(MolAtom toA, MolAtom bondOtherEnd) {
        for (int i = 0; i < toA.getBondCount(); ++i) {
        }
        return false;
    }

    public Molecule getReduced() {
        return this.reduced;
    }

    public void setMixedHetero(boolean mixedH) {
        this.mixedHetero = mixedH;
    }

    private void mergeOnSupergraph() {
        this.sgMerge = true;
        this.doClassification(this);
        this.mergeRingsOnSg();
        this.mergeChainsOnSg();
        this.removeIsolatedAtoms();
        this.removeIsolatedBonds();
    }

    private void mergeRingsOnSg() {
        for (int i = this.getAtomCount() - 1; i >= 0; --i) {
            int[] ringAtoms;
            MolAtom atom = this.getAtom(i);
            if (atom == null || !this.isRingPseudo(atom) || (ringAtoms = this.getAtomsRingSystem(atom)).length == 1) continue;
            boolean[] isHetero = this.getSgAtomType(ringAtoms);
            IntVector merge2RZ = new IntVector();
            IntVector merge2RC = new IntVector();
            int both = this.hasBoth(isHetero);
            switch (both) {
                case 1: {
                    merge2RC = new IntVector(ringAtoms);
                    break;
                }
                case 2: {
                    merge2RZ = new IntVector(ringAtoms);
                    break;
                }
                case 3: {
                    boolean[] mergeableToRZ = new boolean[ringAtoms.length];
                    Arrays.fill(mergeableToRZ, false);
                    boolean[] hasNoInCompRC = new boolean[ringAtoms.length];
                    ArrayTools.fillBooleanArray(hasNoInCompRC, isHetero);
                    block10: for (int r = 0; r < ringAtoms.length; ++r) {
                        if (isHetero[r]) {
                            merge2RZ.add(ringAtoms[r]);
                            continue;
                        }
                        IntVector rzWithIncompRC = new IntVector();
                        block11: for (int k = 0; k < ringAtoms.length; ++k) {
                            if (!isHetero[k]) continue;
                            int comp = this.checkCompatibility(ringAtoms[k], ringAtoms[r]);
                            switch (comp) {
                                case 0: {
                                    rzWithIncompRC.add(k);
                                    continue block11;
                                }
                                case 1: 
                                case 3: {
                                    mergeableToRZ[r] = true;
                                    continue block10;
                                }
                                default: {
                                    mergeableToRZ[r] = true;
                                }
                            }
                        }
                        merge2RC.add(ringAtoms[r]);
                        while (rzWithIncompRC.size() > 0) {
                            hasNoInCompRC[rzWithIncompRC.removeLast()] = false;
                        }
                    }
                    if (this.hasBoth(hasNoInCompRC) != 1 || merge2RC.size() == 0) {
                        merge2RC.clear();
                        merge2RZ = new IntVector(ringAtoms);
                        break;
                    }
                    for (int k = 0; k < mergeableToRZ.length; ++k) {
                        if (!mergeableToRZ[k]) continue;
                        merge2RZ.add(ringAtoms[k]);
                    }
                    break;
                }
            }
            this.doSgRingMerge(merge2RC, merge2RZ, ringAtoms);
        }
    }

    private void doSgRingMerge(IntVector merge2RC, IntVector merge2RZ, int[] ringAtoms) {
        int j;
        int i;
        boolean hasRC = merge2RC.size() > 0;
        boolean hasRZ = merge2RZ.size() > 0;
        int[] rcMergingInd = new int[merge2RC.size()];
        int[] rzMergingInd = new int[merge2RZ.size()];
        int[] rzTargets = this.getMergingInd(merge2RZ, rzMergingInd, true);
        int[] rcTargets = this.getMergingInd(merge2RC, rcMergingInd, false);
        if (hasRZ) {
            for (i = 0; i < merge2RZ.size(); ++i) {
                if (rzMergingInd[i] == -1) continue;
                for (j = 0; j < rzTargets.length; ++j) {
                    this.switchBonds(merge2RZ.get(i), rzTargets[j], true, null);
                }
            }
        }
        if (hasRC) {
            for (i = 0; i < merge2RC.size(); ++i) {
                if (rcMergingInd[i] == -1) continue;
                for (j = 0; j < rcTargets.length; ++j) {
                    this.switchBonds(merge2RC.get(i), rcTargets[j], true, null);
                }
            }
        }
        for (i = 0; i < ringAtoms.length; ++i) {
            int j2;
            MolAtom atom;
            if (!ArrayTools.foundInArray(rcTargets, ringAtoms[i]) && !ArrayTools.foundInArray(rzTargets, ringAtoms[i])) {
                atom = this.getAtom(ringAtoms[i]);
                for (j2 = atom.getBondCount() - 1; j2 >= 0; --j2) {
                    this.isolate(atom.getBond(j2));
                }
                continue;
            }
            atom = this.getAtom(ringAtoms[i]);
            for (j2 = atom.getBondCount() - 1; j2 >= 0; --j2) {
                MolBond bond = atom.getBond(j2);
                if (!this.isRingBond(bond)) continue;
                this.isolate(bond);
            }
        }
    }

    private int[] getMergingInd(IntVector merge2R, int[] mergingInd, boolean hetero) {
        int i;
        boolean[] hasTreeLigand = new boolean[merge2R.size()];
        ArrayTools.fillBooleanArray(hasTreeLigand, false);
        block0: for (int i2 = 0; i2 < merge2R.size(); ++i2) {
            MolAtom atom = this.getAtom(merge2R.get(i2));
            for (int j = 0; j < atom.getBondCount(); ++j) {
                if (this.isRingBond(atom.getBond(j))) continue;
                hasTreeLigand[i2] = true;
                continue block0;
            }
        }
        ArrayTools.initArrayAndFill(mergingInd, merge2R.size(), -1);
        IntVector targets = new IntVector();
        block2: for (i = 0; i < merge2R.size(); ++i) {
            int j;
            if (!hasTreeLigand[i]) continue;
            int atomInd = merge2R.get(i);
            MolAtom atom = this.getAtom(atomInd);
            int targetInd = -1;
            for (j = 0; j < targets.size() && targetInd == -1; ++j) {
                if (this.checkCompatibility(atomInd, targets.get(j)) == 0) continue;
                targetInd = targets.get(j);
            }
            if (targetInd != -1) {
                mergingInd[i] = targetInd;
                continue;
            }
            if (!hetero || this.isHeteroPseudo(atom)) {
                targets.add(atomInd);
                mergingInd[i] = atomInd;
                continue;
            }
            for (j = 0; j < merge2R.size(); ++j) {
                int ind = merge2R.get(j);
                if (!this.isHeteroPseudo(this.getAtom(ind)) || this.checkCompatibility(atomInd, ind) == 0) continue;
                targets.add(ind);
                mergingInd[i] = ind;
                continue block2;
            }
        }
        if (targets.size() == 0) {
            for (i = 0; i < merge2R.size() && targets.size() == 0; ++i) {
                int ind = merge2R.get(i);
                if (hetero && !this.isHeteroPseudo(this.getAtom(ind))) continue;
                mergingInd[i] = ind;
                targets.add(ind);
            }
        }
        return targets.toArray();
    }

    private void switchBonds(int fromSgInd, int toSgInd, boolean ringSwitch, IntVector newNeighbours) {
        if (fromSgInd == toSgInd || toSgInd == -1) {
            return;
        }
        MolAtom fromA = this.getAtom(fromSgInd);
        MolAtom toA = this.getAtom(toSgInd);
        for (int i = 0; i < fromA.getBondCount(); ++i) {
            boolean canSwitch;
            MolBond bond = fromA.getBond(i);
            MolAtom other = bond.getOtherAtom(fromA);
            int otherInd = this.indexOf(other);
            boolean bl = ringSwitch ? !this.isRingBond(bond) && !toA.isBoundTo(other) : (canSwitch = !toA.isBoundTo(other) && this.isCompatible(toSgInd, otherInd) && toA != other);
            if (newNeighbours != null) {
                canSwitch &= !newNeighbours.contains(otherInd);
            }
            if (!canSwitch) continue;
            MolBond newB = new MolBond(other, toA, bond.getFlags());
            this.add(newB);
            if (newNeighbours == null) continue;
            newNeighbours.add(otherInd);
        }
    }

    private int checkCompatibility(int idx1, int idx2) {
        int c1 = this.getID(idx1);
        int c2 = this.getID(idx2);
        int p1 = this.getParentIDByID(c1);
        int p2 = this.getParentIDByID(c2);
        boolean inFirstSubBranch = true;
        boolean inSecondSubBranch = true;
        while (p1 != p2) {
            if (p1 < p2) {
                c2 = p2;
                if (this.getChildrenIDs(p2).length > 1) {
                    inSecondSubBranch = false;
                }
                p2 = this.getParentIDByID(p2);
                continue;
            }
            c1 = p1;
            if (this.getChildrenIDs(p1).length > 1) {
                inFirstSubBranch = false;
            }
            p1 = this.getParentIDByID(p1);
        }
        if (this.getGroupByID(c1) != this.getGroupByID(c2)) {
            return 0;
        }
        if (!inFirstSubBranch && !inSecondSubBranch) {
            return 4;
        }
        if (inFirstSubBranch && !inSecondSubBranch) {
            return 1;
        }
        if (!inFirstSubBranch && inSecondSubBranch) {
            return 2;
        }
        return 3;
    }

    private int hasBoth(boolean[] isHetero) {
        int res = 0;
        for (int i = 0; i < isHetero.length && res != 3; ++i) {
            if (isHetero[i]) {
                res |= 2;
                continue;
            }
            res |= 1;
        }
        return res;
    }

    private boolean[] getSgAtomType(int[] ringAtoms) {
        boolean[] res = new boolean[ringAtoms.length];
        for (int i = 0; i < ringAtoms.length; ++i) {
            res[i] = this.isHeteroPseudo(this.getAtom(ringAtoms[i]));
        }
        return res;
    }

    private int[] getAtomsRingSystem(MolAtom atom) {
        IntVector res = new IntVector();
        IntVector toProcess = new IntVector();
        toProcess.add(this.indexOf(atom));
        while (toProcess.size() > 0) {
            int currIdx = toProcess.removeLast();
            MolAtom current = this.getAtom(currIdx);
            for (int i = 0; i < current.getBondCount(); ++i) {
                MolBond bond = current.getBond(i);
                int otherIdx = this.indexOf(bond.getOtherAtom(current));
                if (!this.isRingBond(bond) || res.contains(otherIdx) || toProcess.contains(otherIdx)) continue;
                toProcess.add(otherIdx);
            }
            res.add(currIdx);
        }
        return res.toArray();
    }

    private void mergeChainsOnSg() {
        boolean didMerge = true;
        int runNum = 0;
        while (didMerge || runNum < 2) {
            didMerge = false;
            ++runNum;
            block1: for (int i = 0; i < this.getAtomCount(); ++i) {
                MolAtom atom = this.getAtom(i);
                IntVector newNeighbours = new IntVector();
                if (atom == null || this.isRingPseudo(atom)) continue;
                for (int j = 0; j < atom.getBondCount(); ++j) {
                    MolAtom atom2;
                    int merging;
                    MolBond bond = atom.getBond(j);
                    if (bond == null || (merging = this.areMergeableTypes(atom, atom2 = bond.getOtherAtom(atom), bond)) == 0) continue;
                    int i2 = this.indexOf(atom2);
                    int comp = this.checkCompatibility(i, i2);
                    if (comp == 0) {
                        this.isolate(bond);
                        continue;
                    }
                    if ((comp == 1 && merging != 1 || comp == 2 && merging != 2) && runNum == 1) {
                        MolAtom upper = comp == 1 ? atom : atom2;
                        MolAtom lower = comp == 1 ? atom2 : atom;
                        this.myMergeAtoms(lower, upper);
                        didMerge = true;
                        if (comp == 2) continue block1;
                        --j;
                        continue;
                    }
                    if (runNum == 1 || merging == 1) continue;
                    this.switchBonds(i2, i, false, newNeighbours);
                    this.isolate(bond);
                    --j;
                    didMerge = true;
                }
            }
        }
    }

    public static void aliases2AtNum(Molecule imp) {
        MoleculeGraph union = imp.getGraphUnion();
        for (int i = 0; i < union.getAtomCount(); ++i) {
            MolAtom atom = union.getAtom(i);
            if (atom.getAtno() == 136) {
                String alias = atom.getAliasstr();
                int pos = ArrayTools.indexInArray(aliases, alias);
                if (pos == -1) continue;
                atom.setAliasstr(null);
                atom.setAtno(atNums[pos]);
                continue;
            }
            --i;
        }
    }

    public static void atNum2aliases(Molecule imp) {
        MoleculeGraph union = imp.getGraphUnion();
        for (int i = 0; i < union.getAtomCount(); ++i) {
            MolAtom atom = union.getAtom(i);
            int pos = ArrayTools.indexInArray(atNums, atom.getAtno());
            if (pos == -1) continue;
            atom.setAliasstr(aliases[pos]);
            atom.setAtno(136);
        }
    }

    public static void removeRingAtoms(Molecule m) {
        boolean sgMerge = m instanceof Supergraph;
        RingClassifier rc = sgMerge ? new SupergraphBondClassifier() : new BondClassifier();
        boolean v = m.isValenceCheckEnabled();
        m.setValenceCheckEnabled(false);
        rc.classify(m);
        for (int i = m.getAtomCount() - 1; i >= 0; --i) {
            if (!rc.isRingAtom(i)) continue;
            m.removeAtom(i);
        }
        m.setValenceCheckEnabled(v);
    }

    private class AttachRgrComparator
    extends MolComparator {
        int[] attQ = null;
        int[] attT = null;
        int[] rgrQ = null;
        int[] rgrT = null;

        private AttachRgrComparator() {
        }

        public void setQueryData(Molecule q) {
            int atNum = q.getAtomCount();
            this.attQ = new int[atNum];
            this.rgrQ = new int[atNum];
            for (int i = 0; i < atNum; ++i) {
                MolAtom atom = q.getAtom(i);
                this.attQ[i] = atom.getAttach();
                this.rgrQ[i] = atom.getRgroup();
            }
        }

        public void setTargetData(Molecule t) {
            int atNum = t.getAtomCount();
            this.attT = new int[atNum];
            this.rgrT = new int[atNum];
            for (int i = 0; i < atNum; ++i) {
                MolAtom atom = t.getAtom(i);
                this.attT[i] = atom.getAttach();
                this.rgrT[i] = atom.getRgroup();
            }
        }

        @Override
        public boolean compareAtoms(int a1, int a2) {
            if (a1 >= this.attQ.length || a2 >= this.attT.length) {
                return true;
            }
            if (this.attQ[a1] != this.attT[a2]) {
                return false;
            }
            return this.rgrQ[a1] == this.rgrT[a2];
        }
    }
}

