/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.composite;

import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.marvin.util.MulticenterTransform;
import chemaxon.sss.screen.options.ScreenOptions;
import chemaxon.sss.screen.util.AtomTypeClassifier;
import chemaxon.sss.screen.util.RingMembershipUtil;
import chemaxon.sss.screen.util.TernaryBoolean;
import chemaxon.sss.search.options.AtomPropertyMatchingOption;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;

public class CompositeScreenGenerator {
    private static final int ATOMTYPE_EXIST_BYTE_COUNT = 2;
    private static final int CHARGE_EXIST_BYTE_COUNT = 2;
    private static final int ISOTOPE_EXIST_BYTE_COUNT = 1;
    private static final int RADICAL_EXIST_BYTE_COUNT = 1;
    static final int FP_BYTE_COUNT = 6;
    private static final int RING_INFO_STAT_BYTE_COUNT = 2;
    static final int STAT_BYTE_COUNT = 2;
    static final int LENGTH_IN_BYTES = 8;
    private static final byte HEAVY_ATOM_BITMASK = 1;
    private static final byte HETERO_BITMASK = 3;
    private static final byte METAL_BITMASK = 7;
    private static final byte HALOGEN_BITMASK = 11;
    private static final byte S_BITMASK = 19;
    private static final byte N_BITMASK = 35;
    private static final byte O_BITMASK = 67;
    private static final byte C_BITMASK = -127;
    private static final byte H_BITMASK_FOR_ISOTOPE = 4;

    static byte[] generateDescriptor(Molecule mol, boolean queryMode, ScreenOptions screenOptions) {
        boolean ignoreRadicalBits;
        boolean ignoreIsotopeBits;
        boolean ignoreChargeBits;
        byte[] data = new byte[8];
        int pos = 0;
        MulticenterTransform mct = new MulticenterTransform();
        mct.transformMulticenters(mol);
        Molecule correctedMol = CompositeScreenGenerator.takeMustFragmentForQuery(mol, queryMode);
        MolAtom[] atoms = correctedMol.getAtomArray();
        RingMembershipUtil ringInfo = new RingMembershipUtil(correctedMol);
        data[pos] = CompositeScreenGenerator.getTotalAtomBits(atoms, queryMode);
        data[pos + 1] = CompositeScreenGenerator.getCyclicAtomBits(atoms, queryMode, ringInfo);
        pos += 2;
        boolean bl = ignoreChargeBits = queryMode && screenOptions.getChargeMatchingOption() == AtomPropertyMatchingOption.IGNORE;
        if (!ignoreChargeBits) {
            data[pos] = CompositeScreenGenerator.getPosChargeBits(atoms, queryMode);
            data[pos + 1] = CompositeScreenGenerator.getNegChargeBits(atoms, queryMode);
        }
        pos += 2;
        boolean bl2 = ignoreIsotopeBits = queryMode && screenOptions.getIsotopeMatchingOption() == AtomPropertyMatchingOption.IGNORE;
        if (!ignoreIsotopeBits) {
            data[pos] = CompositeScreenGenerator.getIsotopeBits(atoms, queryMode);
        }
        ++pos;
        boolean bl3 = ignoreRadicalBits = queryMode && screenOptions.getRadicalMatchingOption() == AtomPropertyMatchingOption.IGNORE;
        if (!ignoreRadicalBits) {
            data[pos] = CompositeScreenGenerator.getRadicalBits(atoms, queryMode);
        }
        CompositeScreenGenerator.computeRingStat(atoms, ringInfo, queryMode, data, ++pos);
        mct.restoreMulticenters(mol);
        return data;
    }

    private static Molecule takeMustFragmentForQuery(Molecule mol, boolean queryMode) {
        return queryMode && mol instanceof RgMolecule ? ((RgMolecule)mol).getRoot() : mol;
    }

    private static byte getTotalAtomBits(MolAtom[] atoms, boolean queryMode) {
        byte value = 0;
        for (MolAtom atom : atoms) {
            value = (byte)(value | CompositeScreenGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getCyclicAtomBits(MolAtom[] atoms, boolean queryMode, RingMembershipUtil ringInfo) {
        byte value = 0;
        for (int i = 0; i < atoms.length; ++i) {
            MolAtom atom = atoms[i];
            TernaryBoolean tb = ringInfo.isRingAtom(atom, i, queryMode);
            if (tb != TernaryBoolean.TRUE && (tb != TernaryBoolean.UNKNOWN || queryMode)) continue;
            value = (byte)(value | CompositeScreenGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getPosChargeBits(MolAtom[] atoms, boolean queryMode) {
        byte value = 0;
        for (MolAtom atom : atoms) {
            if (atom.getCharge() <= 0) continue;
            value = (byte)(value | CompositeScreenGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getNegChargeBits(MolAtom[] atoms, boolean queryMode) {
        byte value = 0;
        for (MolAtom atom : atoms) {
            if (atom.getCharge() >= 0) continue;
            value = (byte)(value | CompositeScreenGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getIsotopeBits(MolAtom[] atoms, boolean queryMode) {
        byte value = 0;
        for (MolAtom atom : atoms) {
            if (atom.getMassno() == 0) continue;
            TernaryBoolean tb = AtomTypeClassifier.isHydrogen(atom);
            if (tb == TernaryBoolean.TRUE || tb == TernaryBoolean.UNKNOWN && !queryMode) {
                value = (byte)(value | 4);
            }
            value = (byte)(value | CompositeScreenGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getRadicalBits(MolAtom[] atoms, boolean queryMode) {
        byte value = 0;
        for (MolAtom atom : atoms) {
            if (atom.getRadicalCount() == 0) continue;
            value = (byte)(value | CompositeScreenGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getAtomBitMask(MolAtom atom, boolean queryMode) {
        TernaryBoolean tb = AtomTypeClassifier.isHydrogen(atom);
        if (tb == TernaryBoolean.TRUE) {
            return 0;
        }
        if (queryMode && tb == TernaryBoolean.UNKNOWN) {
            return 0;
        }
        byte value = 1;
        tb = AtomTypeClassifier.isChemicalAtom(atom, 6);
        if (tb == TernaryBoolean.TRUE) {
            return -127;
        }
        if (tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 0xFFFFFF81);
        }
        if ((tb = AtomTypeClassifier.isChemicalAtom(atom, 7)) == TernaryBoolean.TRUE) {
            return 35;
        }
        if (tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 0x23);
        }
        if ((tb = AtomTypeClassifier.isChemicalAtom(atom, 8)) == TernaryBoolean.TRUE) {
            return 67;
        }
        if (tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 0x43);
        }
        if ((tb = AtomTypeClassifier.isChemicalAtom(atom, 16)) == TernaryBoolean.TRUE) {
            return 19;
        }
        if (tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 0x13);
        }
        if ((tb = AtomTypeClassifier.isHalogen(atom)) == TernaryBoolean.TRUE) {
            return 11;
        }
        if (tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 0xB);
        }
        if ((tb = AtomTypeClassifier.isMetal(atom)) == TernaryBoolean.TRUE) {
            return 7;
        }
        if (tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 7);
        }
        if ((tb = AtomTypeClassifier.isHetero(atom)) == TernaryBoolean.TRUE) {
            return 3;
        }
        if (tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 3);
        }
        return value;
    }

    private static boolean canRepresentMoreAtoms(MolAtom atom, boolean queryMode) {
        return atom.getAtno() == 134 || HomologyConstants.isHomology(atom.getAliasstr());
    }

    private static void computeRingStat(MolAtom[] atoms, RingMembershipUtil ringInfo, boolean queryMode, byte[] data, int start) {
        int ringAtomCount = 0;
        int multiConnRingAtomCount = 0;
        for (int i = 0; i < atoms.length; ++i) {
            MolAtom atom = atoms[i];
            TernaryBoolean isRingAtom = ringInfo.isRingAtom(atom, i, queryMode);
            int ringBondCount = ringInfo.getNumberOfRingBonds(atom, i, queryMode);
            if (isRingAtom != TernaryBoolean.TRUE && (isRingAtom != TernaryBoolean.UNKNOWN || queryMode) && ringBondCount <= 0) continue;
            ++ringAtomCount;
            if (ringBondCount < 3 || CompositeScreenGenerator.canRepresentMoreAtoms(atom, queryMode)) continue;
            ++multiConnRingAtomCount;
        }
        data[start] = (byte)Math.min(ringAtomCount, 127);
        data[start + 1] = (byte)Math.min(multiConnRingAtomCount, 127);
    }
}

