/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.composite;

import chemaxon.sss.screen.composite.CompositeScreenGenerator;
import chemaxon.sss.screen.handler.ScreenHandlerBytes;
import chemaxon.sss.screen.handler.UnsupportedMoleculeException;
import chemaxon.sss.screen.options.ScreenOptions;
import chemaxon.sss.screen.util.ScreenUtil;
import chemaxon.struc.Molecule;

public class CompositeScreenHandlerBytes
implements ScreenHandlerBytes {
    @Override
    public byte[] generateTargetDescriptor(Molecule targetMol) throws UnsupportedMoleculeException {
        return CompositeScreenGenerator.generateDescriptor(targetMol, false, null);
    }

    @Override
    public byte[] generateQueryDescriptor(Molecule queryMol, ScreenOptions screenOptions) throws UnsupportedMoleculeException {
        return CompositeScreenGenerator.generateDescriptor(queryMol, true, screenOptions);
    }

    @Override
    public boolean accept(byte[] queryDescr, byte[] targetDescr, ScreenOptions screenOptions) throws IllegalArgumentException {
        if (queryDescr.length != 8) {
            throw new IllegalArgumentException(String.format("Query descriptor length mismatch. Expected: %d, actual: %d", 8, queryDescr.length));
        }
        if (targetDescr.length != 8) {
            throw new IllegalArgumentException(String.format("Target descriptor length mismatch. Expected: %d, actual: %d", 8, targetDescr.length));
        }
        return this.accept(queryDescr, targetDescr, 0, screenOptions);
    }

    @Override
    public boolean accept(byte[] queryDescr, byte[] targetDescrArray, int start, int length, ScreenOptions screenOptions) throws IllegalArgumentException {
        if (queryDescr.length != 8) {
            throw new IllegalArgumentException(String.format("Query descriptor length mismatch. Expected: %d, actual: %d", 8, queryDescr.length));
        }
        if (length != 8) {
            throw new IllegalArgumentException(String.format("Target descriptor length mismatch. Expected: %d, actual: %d", 8, length));
        }
        return this.accept(queryDescr, targetDescrArray, start, screenOptions);
    }

    public boolean accept(byte[] queryDescr, byte[] targetDescrArray, int start, ScreenOptions screenOptions) {
        int fpLength = 6;
        int totalLength = 8;
        int qPos = 0;
        int tPos = start;
        while (qPos < 6) {
            byte qByte = queryDescr[qPos];
            if ((targetDescrArray[tPos] & qByte) != qByte) {
                return false;
            }
            ++qPos;
            ++tPos;
        }
        while (qPos < 8) {
            if (queryDescr[qPos] > targetDescrArray[tPos]) {
                return false;
            }
            ++qPos;
            ++tPos;
        }
        return true;
    }

    @Override
    public void intersect(byte[] descr1, byte[] descr2) throws UnsupportedOperationException, IllegalArgumentException {
        if (descr1.length != 8 || descr2.length != 8) {
            throw new IllegalArgumentException("Descriptor length mismatch");
        }
        ScreenUtil.intersectAnd(descr1, descr2, 0, 6);
        ScreenUtil.intersectMin(descr1, descr2, 6, 2);
    }
}

