/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.composite.parts.maccs;

import chemaxon.formats.MolImporter;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import java.util.Arrays;

class MaccsGenerator {
    public static int DESC_LENGTH = 30;
    private static final int LENGTH = 200;
    private static Molecule[] bits = new Molecule[200];
    private static int[] count = new int[200];
    MolSearch ms = new MolSearch();

    public MaccsGenerator() {
        try {
            Arrays.fill(count, 1);
            MaccsGenerator.bits[1] = MolImporter.importMol("[!0]");
            MaccsGenerator.bits[8] = MolImporter.importMol("[!#6R!#1]1@*@*@*~1");
            MaccsGenerator.bits[11] = MolImporter.importMol("[R]1@*@*@*~1");
            MaccsGenerator.bits[13] = MolImporter.importMol("[#8]~[#7](~[#6])~[#6]");
            MaccsGenerator.bits[14] = MolImporter.importMol("[#16]-[#16]");
            MaccsGenerator.bits[15] = MolImporter.importMol("[#8]~[#6](~[#8])~[#8]");
            MaccsGenerator.bits[16] = MolImporter.importMol("[!#6R!#1]1@*@*~1");
            MaccsGenerator.bits[17] = MolImporter.importMol("[#6]#[#6]");
            MaccsGenerator.bits[19] = MolImporter.importMol("[R]1@*@*@*@*@*@*~1");
            MaccsGenerator.bits[21] = MolImporter.importMol("[#6]=[#6](~[!#6!#1])~[!#6!#1]");
            MaccsGenerator.bits[22] = MolImporter.importMol("[R]1@*@*~1");
            MaccsGenerator.bits[23] = MolImporter.importMol("[#7]~[#6](~[#8])~[#8]");
            MaccsGenerator.bits[24] = MolImporter.importMol("[#7]-[#8]");
            MaccsGenerator.bits[25] = MolImporter.importMol("[#7]~[#6](~[#7])~[#7]");
            MaccsGenerator.bits[26] = MolImporter.importMol("[#6]@=[#6](@*)@*");
            MaccsGenerator.bits[28] = MolImporter.importMol("[!#6!#1]~[CH2]~[!#6!#1]");
            MaccsGenerator.bits[30] = MolImporter.importMol("[#6]~[!#6](~[#6])(~[#6])~*");
            MaccsGenerator.bits[31] = MolImporter.importMol("[!#6!#1]~[Cl,F,Br,I]");
            MaccsGenerator.bits[32] = MolImporter.importMol("[#6]~[#16]~[#7]");
            MaccsGenerator.bits[33] = MolImporter.importMol("[#7]~[#16]");
            MaccsGenerator.bits[34] = MolImporter.importMol("[CH2]=*");
            MaccsGenerator.bits[36] = MolImporter.importMol("[#16R]");
            MaccsGenerator.bits[37] = MolImporter.importMol("[#7]~[#6](~[#8])~[#7]");
            MaccsGenerator.bits[38] = MolImporter.importMol("[#7]~[#6](~[#6])~[#7]");
            MaccsGenerator.bits[39] = MolImporter.importMol("[#8]~[#16](~[#8])~[#8]");
            MaccsGenerator.bits[40] = MolImporter.importMol("[#16]-[#8]");
            MaccsGenerator.bits[41] = MolImporter.importMol("[#7]#[#6]");
            MaccsGenerator.bits[43] = MolImporter.importMol("[!#6!#1!H0]~*~[!#6!#1!H0]");
            MaccsGenerator.bits[45] = MolImporter.importMol("[#6]=[#6]~[#7]");
            MaccsGenerator.bits[47] = MolImporter.importMol("[#16]~*~[#7]");
            MaccsGenerator.bits[48] = MolImporter.importMol("[#8]~[!#6!#1](~[#8])~[#8]");
            MaccsGenerator.bits[49] = MolImporter.importMol("[!+0]");
            MaccsGenerator.bits[50] = MolImporter.importMol("[#6]=[#6](~[#6])~[#6]");
            MaccsGenerator.bits[51] = MolImporter.importMol("[#8]~[#16]~[#6]");
            MaccsGenerator.bits[52] = MolImporter.importMol("[#7]~[#7]");
            MaccsGenerator.bits[53] = MolImporter.importMol("[!#6!#1!H0]~*~*~*~[!#6!#1!H0]");
            MaccsGenerator.bits[54] = MolImporter.importMol("[!#6!#1!H0]~*~*~[!#6!#1!H0]");
            MaccsGenerator.bits[55] = MolImporter.importMol("[#8]~[#16]~[#8]");
            MaccsGenerator.bits[56] = MolImporter.importMol("[#8]~[#7](~[#8])~[#6]");
            MaccsGenerator.bits[57] = MolImporter.importMol("[#8R]");
            MaccsGenerator.bits[58] = MolImporter.importMol("[!#6!#1]~[#16]~[!#6!#1]");
            MaccsGenerator.bits[59] = MolImporter.importMol("[#16]!:*:*");
            MaccsGenerator.bits[60] = MolImporter.importMol("[#16]=[#8]");
            MaccsGenerator.bits[61] = MolImporter.importMol("[#16!D0!D1!D2]");
            MaccsGenerator.bits[62] = MolImporter.importMol("[R]!@[R]");
            MaccsGenerator.bits[63] = MolImporter.importMol("[#7]=[#8]");
            MaccsGenerator.bits[64] = MolImporter.importMol("[#16]!@[R]");
            MaccsGenerator.bits[65] = MolImporter.importMol("n:[#6]");
            MaccsGenerator.bits[66] = MolImporter.importMol("[#6]~[#6](~[#6])(~[#6])~*");
            MaccsGenerator.bits[67] = MolImporter.importMol("[#16]~[!#6!#1]");
            MaccsGenerator.bits[68] = MolImporter.importMol("[!#6!#1!H0]~[!#6!#1!H0]");
            MaccsGenerator.bits[69] = MolImporter.importMol("[!#6!#1]~[!#6!#1!H0]");
            MaccsGenerator.bits[70] = MolImporter.importMol("[!#6!#1]~[#7]~[!#6!#1]");
            MaccsGenerator.bits[71] = MolImporter.importMol("[#7]~[#8]");
            MaccsGenerator.bits[72] = MolImporter.importMol("[#8]~*~*~[#8]");
            MaccsGenerator.bits[73] = MolImporter.importMol("[#16]=*");
            MaccsGenerator.bits[74] = MolImporter.importMol("[#6H3]~*~[#6H3]");
            MaccsGenerator.bits[75] = MolImporter.importMol("[#7R]!@*");
            MaccsGenerator.bits[76] = MolImporter.importMol("[#6]=[#6](~*)~*");
            MaccsGenerator.bits[77] = MolImporter.importMol("[#7]~*~[#7]");
            MaccsGenerator.bits[78] = MolImporter.importMol("[#7]=[#6]");
            MaccsGenerator.bits[79] = MolImporter.importMol("[#7]~*~*~[#7]");
            MaccsGenerator.bits[80] = MolImporter.importMol("[#7]~*~*~*~[#7]");
            MaccsGenerator.bits[81] = MolImporter.importMol("[#16]~[!D0!D1!D2]");
            MaccsGenerator.bits[82] = MolImporter.importMol("[#6H2](~[!#6!#1!H0])~*");
            MaccsGenerator.bits[83] = MolImporter.importMol("[!#6R!#1]1@*@*@*@*~1");
            MaccsGenerator.bits[84] = MolImporter.importMol("[#7!H0!H1]");
            MaccsGenerator.bits[85] = MolImporter.importMol("[#7](~[#6])(~[#6])~[#6]");
            MaccsGenerator.bits[86] = MolImporter.importMol("[#6H2]~[!#6!#1]~[#6H2]");
            MaccsGenerator.bits[87] = MolImporter.importMol("[Cl,F,Br,I]!@[R]");
            MaccsGenerator.bits[89] = MolImporter.importMol("[#8]~*~*~*~[#8]");
            MaccsGenerator.bits[90] = MolImporter.importMol("[#6H2](~*)~*~*~[!#6!#1!H0]");
            MaccsGenerator.bits[91] = MolImporter.importMol("[#6H2](~*)~*~*~*~[!#6!#1!H0]");
            MaccsGenerator.bits[92] = MolImporter.importMol("[#8]~[#6](~[#7])~[#6]");
            MaccsGenerator.bits[93] = MolImporter.importMol("[#6H3]~[!#6!#1]");
            MaccsGenerator.bits[94] = MolImporter.importMol("[#7]~[!#6!#1]");
            MaccsGenerator.bits[95] = MolImporter.importMol("[#7]~*~*~[#8]");
            MaccsGenerator.bits[96] = MolImporter.importMol("[R]1@*@*@*@*~1");
            MaccsGenerator.bits[97] = MolImporter.importMol("[#7]~*~*~*~[#8]");
            MaccsGenerator.bits[98] = MolImporter.importMol("[!#6R!#1]1@*@*@*@*@*~1");
            MaccsGenerator.bits[99] = MolImporter.importMol("[#6]=[#6]");
            MaccsGenerator.bits[100] = MolImporter.importMol("[#7]~[#6H2]~*");
            MaccsGenerator.bits[101] = MolImporter.importMol("[R]1@*@*@*@*@*@*@*~1");
            MaccsGenerator.bits[102] = MolImporter.importMol("[#8]~[!#6!#1]");
            MaccsGenerator.bits[104] = MolImporter.importMol("[#6H2](~*)~*~[!#6!#1!H0]");
            MaccsGenerator.bits[105] = MolImporter.importMol("[R](@*)(@*)@*");
            MaccsGenerator.bits[106] = MolImporter.importMol("[!#6!#1]~*(~[!#6!#1])~[!#6!#1]");
            MaccsGenerator.bits[107] = MolImporter.importMol("[Cl,F,Br,I]~[!D0!D1!D2]");
            MaccsGenerator.bits[108] = MolImporter.importMol("[#6H3]~*~*~*~[#6H2]~*");
            MaccsGenerator.bits[109] = MolImporter.importMol("[#8]~[#6H2]~*");
            MaccsGenerator.bits[110] = MolImporter.importMol("[#7]~[#6]~[#8]");
            MaccsGenerator.bits[111] = MolImporter.importMol("[#7]~*~[#6H2]~*");
            MaccsGenerator.bits[112] = MolImporter.importMol("[!D0!D1!D2!D3]");
            MaccsGenerator.bits[113] = MolImporter.importMol("[#8]!:a");
            MaccsGenerator.bits[114] = MolImporter.importMol("[#6H3]~[#6H2]~*");
            MaccsGenerator.bits[115] = MolImporter.importMol("[#6H3]~*~[#6H2]~*");
            MaccsGenerator.bits[116] = MolImporter.importMol("[#6H3]~*~*~[#6H2]~*");
            MaccsGenerator.bits[117] = MolImporter.importMol("[#7]~*~[#8]");
            MaccsGenerator.bits[118] = MolImporter.importMol("[#6H2]([#6H2]*)*");
            MaccsGenerator.bits[119] = MolImporter.importMol("[#7]=*");
            MaccsGenerator.bits[120] = MolImporter.importMol("[!#6R]");
            MaccsGenerator.bits[121] = MolImporter.importMol("[#7R]");
            MaccsGenerator.bits[122] = MolImporter.importMol("[#7!D0!D1!D2]");
            MaccsGenerator.bits[123] = MolImporter.importMol("[#8]~[#6]~[#8]");
            MaccsGenerator.bits[124] = MolImporter.importMol("[!#6!#1]~[!#6!#1]");
            MaccsGenerator.bits[126] = MolImporter.importMol("[#8](!@*)!@*");
            MaccsGenerator.bits[127] = MolImporter.importMol("[#8]!@[R]");
            MaccsGenerator.bits[128] = MolImporter.importMol("[#6H2](~*~*~*~[#6H2]~*)~*");
            MaccsGenerator.bits[129] = MolImporter.importMol("[#6H2](~*~*~[#6H2]~*)~*");
            MaccsGenerator.bits[131] = MolImporter.importMol("[!#6!#1!H0]");
            MaccsGenerator.bits[132] = MolImporter.importMol("[#8]~*~[#6H2]~*");
            MaccsGenerator.bits[133] = MolImporter.importMol("[#7]!@[R]");
            MaccsGenerator.bits[135] = MolImporter.importMol("[#7]!:a");
            MaccsGenerator.bits[136] = MolImporter.importMol("[#8]=*");
            MaccsGenerator.bits[138] = MolImporter.importMol("[#6H2](~[!#6!#1])~*");
            MaccsGenerator.bits[139] = MolImporter.importMol("[#8!H0]");
            MaccsGenerator.bits[140] = MolImporter.importMol("[#8]");
            MaccsGenerator.bits[141] = MolImporter.importMol("[#6H3]");
            MaccsGenerator.bits[142] = MolImporter.importMol("[#7]");
            MaccsGenerator.bits[144] = MolImporter.importMol("a(!:*):a!:*");
            MaccsGenerator.bits[147] = MolImporter.importMol("[#6H2](~[#6H2]~*)~*");
            MaccsGenerator.bits[148] = MolImporter.importMol("[!#6!#1!D0!D1!D2]");
            MaccsGenerator.bits[149] = MolImporter.importMol("[#6;H3,H4]");
            MaccsGenerator.bits[150] = MolImporter.importMol("[R](!@*)@*!@*");
            MaccsGenerator.bits[151] = MolImporter.importMol("[#7!H0]");
            MaccsGenerator.bits[152] = MolImporter.importMol("[#8](~[#6])(~[#6])~[#6]");
            MaccsGenerator.bits[154] = MolImporter.importMol("[#8]=[#6]");
            MaccsGenerator.bits[155] = MolImporter.importMol("[#6H2](!@*)!@*");
            MaccsGenerator.bits[156] = MolImporter.importMol("[#7]~[!D0!D1!D2]");
            MaccsGenerator.bits[157] = MolImporter.importMol("[#8]-[#6]");
            MaccsGenerator.bits[158] = MolImporter.importMol("[#7]-[#6]");
            MaccsGenerator.bits[162] = MolImporter.importMol("a");
            MaccsGenerator.bits[163] = MolImporter.importMol("[R]1@*@*@*@*@*~1");
            MaccsGenerator.bits[165] = MolImporter.importMol("[R]");
            MaccsGenerator.bits[166] = MolImporter.importMol("(*).(*)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void set(byte[] data, int pos) {
        int n = pos / 7;
        data[n] = (byte)(data[n] | 1 << pos % 7);
    }

    private boolean matches(Molecule query, boolean forQuery) {
        try {
            this.ms.setQuery(query);
            return this.ms.isMatching();
        }
        catch (SearchException e) {
            return !forQuery;
        }
    }

    private int countMatches(Molecule query, int max, boolean forQuery) {
        try {
            this.ms.setQuery(query);
            int count = 0;
            if (this.ms.findFirst() != null) {
                do {
                    ++count;
                } while (this.ms.findNext() != null);
            }
            return count;
        }
        catch (SearchException e) {
            return forQuery ? 0 : Integer.MAX_VALUE;
        }
    }

    public byte[] generate(Molecule molecule, boolean forQuery) {
        int i;
        int atomCount = molecule.getAtomCount();
        byte[] data = new byte[25];
        int[][][] arings = molecule.getAromaticAndAliphaticRings(1, true, true, 6, 0);
        if (arings[0].length >= 2) {
            this.set(data, 124);
        }
        block20: for (i = 0; i < atomCount; ++i) {
            switch (molecule.getAtom(i).getAtno()) {
                case 3: 
                case 11: 
                case 19: 
                case 37: 
                case 55: 
                case 87: {
                    this.set(data, 34);
                    continue block20;
                }
                case 4: 
                case 12: 
                case 20: 
                case 38: 
                case 56: 
                case 88: {
                    this.set(data, 9);
                    continue block20;
                }
                case 5: 
                case 13: 
                case 31: 
                case 49: {
                    this.set(data, 17);
                    continue block20;
                }
                case 9: {
                    this.set(data, 41);
                    this.set(data, 133);
                    continue block20;
                }
                case 14: {
                    this.set(data, 19);
                    continue block20;
                }
                case 15: {
                    this.set(data, 28);
                    continue block20;
                }
                case 16: {
                    this.set(data, 87);
                    continue block20;
                }
                case 17: {
                    this.set(data, 102);
                    this.set(data, 133);
                    continue block20;
                }
                case 21: 
                case 22: 
                case 39: 
                case 40: 
                case 72: {
                    this.set(data, 4);
                    continue block20;
                }
                case 23: 
                case 24: 
                case 25: 
                case 41: 
                case 42: 
                case 43: 
                case 73: 
                case 74: 
                case 75: {
                    this.set(data, 6);
                    continue block20;
                }
                case 26: 
                case 27: 
                case 28: 
                case 44: 
                case 45: 
                case 46: 
                case 76: 
                case 77: 
                case 78: {
                    this.set(data, 8);
                    continue block20;
                }
                case 29: 
                case 30: 
                case 47: 
                case 48: 
                case 79: 
                case 80: {
                    this.set(data, 11);
                    continue block20;
                }
                case 32: 
                case 33: 
                case 34: 
                case 50: 
                case 51: 
                case 52: 
                case 82: 
                case 83: {
                    this.set(data, 2);
                    continue block20;
                }
                case 35: {
                    this.set(data, 45);
                    this.set(data, 133);
                    continue block20;
                }
                case 53: {
                    this.set(data, 26);
                    this.set(data, 133);
                    continue block20;
                }
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: {
                    this.set(data, 5);
                    continue block20;
                }
                case 81: {
                    this.set(data, 2);
                    this.set(data, 17);
                    continue block20;
                }
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: {
                    this.set(data, 3);
                }
            }
        }
        this.ms.setTarget(molecule);
        for (i = 0; i < bits.length; ++i) {
            if (bits[i] == null || !this.matches(bits[i], forQuery)) continue;
            this.set(data, i - 1);
        }
        int count = this.countMatches(bits[120], 2, forQuery);
        if (count > 1) {
            this.set(data, 119);
        }
        if (count > 0) {
            this.set(data, 136);
        }
        if (this.matches(bits[121], forQuery)) {
            this.set(data, 120);
        }
        if (this.matches(bits[122], forQuery)) {
            this.set(data, 121);
        }
        if (this.matches(bits[123], forQuery)) {
            this.set(data, 122);
        }
        if ((count = this.countMatches(bits[124], 2, forQuery)) > 0) {
            this.set(data, 123);
        }
        if (count > 1) {
            this.set(data, 129);
        }
        if (this.matches(bits[126], forQuery)) {
            this.set(data, 125);
        }
        if ((count = this.countMatches(bits[127], 2, forQuery)) > 1) {
            this.set(data, 126);
        }
        if (count > 0) {
            this.set(data, 142);
        }
        if (this.matches(bits[128], forQuery)) {
            this.set(data, 127);
        }
        if (this.matches(bits[129], forQuery)) {
            this.set(data, 128);
        }
        if (this.countMatches(bits[131], 2, forQuery) > 1) {
            this.set(data, 130);
        }
        if (this.matches(bits[132], forQuery)) {
            this.set(data, 131);
        }
        if (this.matches(bits[133], forQuery)) {
            this.set(data, 132);
        }
        if (this.matches(bits[135], forQuery)) {
            this.set(data, 134);
        }
        if (this.countMatches(bits[136], 2, forQuery) > 1) {
            this.set(data, 135);
        }
        if ((count = this.countMatches(bits[138], 2, forQuery)) > 1) {
            this.set(data, 137);
        }
        if (count > 0) {
            this.set(data, 152);
        }
        if (this.matches(bits[139], forQuery)) {
            this.set(data, 138);
        }
        if ((count = this.countMatches(bits[140], 4, forQuery)) > 3) {
            this.set(data, 139);
        }
        if (count > 2) {
            this.set(data, 145);
        }
        if (count > 1) {
            this.set(data, 158);
        }
        if (count > 0) {
            this.set(data, 163);
        }
        if (this.countMatches(bits[141], 3, forQuery) > 2) {
            this.set(data, 140);
        }
        if ((count = this.countMatches(bits[142], 2, forQuery)) > 1) {
            this.set(data, 141);
        }
        if (count > 0) {
            this.set(data, 160);
        }
        if (this.matches(bits[144], forQuery)) {
            this.set(data, 143);
        }
        if (this.matches(bits[147], forQuery)) {
            this.set(data, 146);
        }
        if (this.matches(bits[148], forQuery)) {
            this.set(data, 147);
        }
        if ((count = this.countMatches(bits[149], 2, forQuery)) > 1) {
            this.set(data, 148);
        }
        if (count > 0) {
            this.set(data, 159);
        }
        for (i = 150; i <= 166; ++i) {
            if (bits[i] == null || !this.matches(bits[i], forQuery)) continue;
            this.set(data, i - 1);
        }
        count = 0;
        int[][] sssr = molecule.getSSSR();
        for (int r = 0; r < sssr.length; ++r) {
            if (sssr[r].length != 6) continue;
            if (count == 1) {
                this.set(data, 144);
                break;
            }
            ++count;
        }
        return data;
    }
}

