/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.composite.parts.mixedstat;

import chemaxon.sss.screen.composite.parts.mixedstat.MixedStatUtil;
import chemaxon.sss.screen.composite.parts.ring.RingScreenHandlerBytes;
import chemaxon.sss.screen.composite.parts.simplefp.SimpleFpHandler;
import chemaxon.sss.screen.handler.ScreenHandlerBytes;
import chemaxon.sss.screen.handler.UnsupportedMoleculeException;
import chemaxon.sss.screen.options.ScreenOptions;
import chemaxon.sss.screen.util.ScreenUtil;
import chemaxon.sss.search.options.AtomPropertyMatchingOption;
import chemaxon.struc.Molecule;

public class MixedStatSHBytes
implements ScreenHandlerBytes {
    @Override
    public byte[] generateQueryDescriptor(Molecule query, ScreenOptions screenOptions) throws IllegalArgumentException, UnsupportedMoleculeException {
        byte[] result = new byte[37];
        if (screenOptions.getIsotopeMatchingOption() != AtomPropertyMatchingOption.IGNORE) {
            result[0] = MixedStatUtil.getIsotopeByte(query);
        }
        if (screenOptions.getChargeMatchingOption() != AtomPropertyMatchingOption.IGNORE) {
            result[1] = MixedStatUtil.getChargeByte(query);
        }
        if (screenOptions.getRadicalMatchingOption() != AtomPropertyMatchingOption.IGNORE) {
            result[2] = MixedStatUtil.getRadicalByte(query);
        }
        result[3] = MixedStatUtil.getNeighborByte(query, true);
        System.arraycopy(MixedStatUtil.getConnectionBytes(query, true), 0, result, 20, 15);
        RingScreenHandlerBytes ringScreenHandlerBytes = new RingScreenHandlerBytes();
        byte[] queryDescriptor = ringScreenHandlerBytes.generateQueryDescriptor(query, screenOptions);
        System.arraycopy(queryDescriptor, 0, result, 35, 2);
        SimpleFpHandler sfph = new SimpleFpHandler();
        byte[] compositeFp = sfph.generateQueryDescriptor(query, screenOptions);
        System.arraycopy(compositeFp, 0, result, 4, 16);
        return result;
    }

    @Override
    public byte[] generateTargetDescriptor(Molecule target) throws UnsupportedMoleculeException {
        byte[] result = new byte[37];
        result[0] = MixedStatUtil.getIsotopeByte(target);
        result[1] = MixedStatUtil.getChargeByte(target);
        result[2] = MixedStatUtil.getRadicalByte(target);
        result[3] = MixedStatUtil.getNeighborByte(target, false);
        System.arraycopy(MixedStatUtil.getConnectionBytes(target, false), 0, result, 20, 15);
        RingScreenHandlerBytes ringScreenHandlerBytes = new RingScreenHandlerBytes();
        byte[] targetDescriptor = ringScreenHandlerBytes.generateTargetDescriptor(target);
        System.arraycopy(targetDescriptor, 0, result, 35, 2);
        SimpleFpHandler sfph = new SimpleFpHandler();
        byte[] compositeFp = sfph.generateTargetDescriptor(target);
        System.arraycopy(compositeFp, 0, result, 4, 16);
        return result;
    }

    @Override
    public boolean accept(byte[] queryDescr, byte[] targetDescr, ScreenOptions screenOptions) {
        return this.accept(queryDescr, targetDescr, 0, screenOptions);
    }

    private boolean accept(byte[] queryDescr, byte[] targetDescr, int startIndex, ScreenOptions screenOptions) {
        for (int i = 0; i < 20; ++i) {
            if ((queryDescr[i] & targetDescr[startIndex + i]) == queryDescr[i]) continue;
            return false;
        }
        int length = 17;
        int end = 37;
        for (int i = 20; i < 37; ++i) {
            if (queryDescr[i] <= targetDescr[startIndex + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(byte[] queryDescr, byte[] targetDescr, int pos, int length, ScreenOptions screenOptions) {
        if (length != 37) {
            throw new IllegalArgumentException(String.format("Descriptor length differs from expected length: %d <> %d", length, 37));
        }
        return this.accept(queryDescr, targetDescr, pos, screenOptions);
    }

    @Override
    public void intersect(byte[] descr1, byte[] descr2) throws IllegalArgumentException {
        if (descr1.length != descr2.length) {
            throw new IllegalArgumentException("Different descriptor lengths for intersection");
        }
        ScreenUtil.intersectAnd(descr1, descr2, 0, 20);
        ScreenUtil.intersectMin(descr1, descr2, 20, 17);
    }
}

