/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.composite.parts.mixedstat;

import chemaxon.common.util.IntArrayIntSet;
import chemaxon.core.util.BondTable;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

class MixedStatUtil {
    static final boolean INCLUDE_RINGATOM_COUNT = true;
    static final boolean INCLUDE_COMPOSITE_KEY = true;
    static final boolean INCLUDE_COMPOSITE_COUNT = false;
    public static final int ISOTOPE_BYTE = 0;
    public static final int CHARGE_BYTE = 1;
    public static final int RADICAL_BYTE = 2;
    private static final byte CARBON_BIT_INDEX = 1;
    private static final byte OXYGEN_BIT_INDEX = 2;
    private static final byte NITROGEN_BIT_INDEX = 4;
    private static final byte HALOGEN_BIT_INDEX = 8;
    private static final byte OTHER_BIT_INDEX = 16;
    private static final byte EXIST_BIT_INDEX = 64;
    public static final int NEIGHBOR_BYTE = 3;
    private static final int NEIGHBOR_3_DIFFERENT = 1;
    private static final int NEIGHBOR_3_3 = 0;
    private static final int NEIGHBOR_3_2 = 1;
    private static final int NEIGHBOR_3_1 = 2;
    public static final int SIMPLE_KEY_DATA_LENGTH = 4;
    public static final int COMPOSITE_KEY_DATA_START = 4;
    public static final int COMPARE_DATA_START = 20;
    public static final int CONNECTION_DATA_LENGTH = 15;
    public static final int COMPARE_DATA_LENGTH = 17;
    public static final int RING_DATA_START = 35;
    public static final int COMPOSITE_COUNT_START = 37;
    private static final int BOND4_OR_MORE = 3;
    private static final int BOND3 = 4;
    private static final int BOND2 = 5;
    private static final int BOND1 = 6;
    private static final int BOND_DOUBLE2 = 7;
    private static final int BOND_DOUBLE_OTHER2 = 8;
    private static final int BOND_DOUBLE_OTHER1 = 9;
    private static final int BOND_DOUBLE = 10;
    private static final int BOND_AROM4_OR_MORE = 11;
    private static final int BOND_AROM3 = 12;
    private static final int BOND_AROM2 = 13;
    private static final int BOND_AROM1 = 14;
    public static final int DESC_LENGTH = 37;

    MixedStatUtil() {
    }

    public static byte getIsotopeByte(Molecule molecule) {
        MolAtom[] atoms;
        byte value = 0;
        for (MolAtom atom : atoms = molecule.getAtomArray()) {
            if (atom.getMassno() == 0) continue;
            value = (byte)(value | 0x40);
            int atNo = atom.getAtno();
            value = (byte)(value | MixedStatUtil.updateAtomByte(atNo));
        }
        return value;
    }

    public static byte getChargeByte(Molecule molecule) {
        MolAtom[] atoms;
        byte value = 0;
        for (MolAtom atom : atoms = molecule.getAtomArray()) {
            if (atom.getCharge() == 0) continue;
            value = (byte)(value | 0x40);
            int atNo = atom.getAtno();
            value = (byte)(value | MixedStatUtil.updateAtomByte(atNo));
        }
        return value;
    }

    public static byte getRadicalByte(Molecule molecule) {
        MolAtom[] atoms;
        byte value = 0;
        for (MolAtom atom : atoms = molecule.getAtomArray()) {
            if (atom.getRadicalCount() == 0) continue;
            value = (byte)(value | 0x40);
            int atNo = atom.getAtno();
            value = (byte)(value | MixedStatUtil.updateAtomByte(atNo));
        }
        return value;
    }

    public static byte getNeighborByte(Molecule molecule, boolean isQuery) {
        int i;
        byte value = 0;
        MolAtom[] atoms = molecule.getAtomArray();
        boolean[] canBeH = MixedStatUtil.canBeH(atoms);
        boolean[] canBeNonH = MixedStatUtil.canBeNonH(atoms);
        int[][] ctab = molecule.getCtab();
        int[] neighbors = new int[ctab.length];
        for (i = 0; i < ctab.length; ++i) {
            if (isQuery && canBeH[i]) continue;
            int bond = 0;
            for (int j = 0; j < ctab[i].length; ++j) {
                if (isQuery) {
                    if (canBeH[ctab[i][j]]) continue;
                    ++bond;
                    continue;
                }
                if (!canBeNonH[ctab[i][j]]) continue;
                ++bond;
            }
            neighbors[i] = bond;
        }
        for (i = 0; i < neighbors.length; ++i) {
            if (canBeH[i] || neighbors[i] < 3) continue;
            IntArrayIntSet iSet = new IntArrayIntSet(ctab[i].length);
            for (int j = 0; j < ctab[i].length; ++j) {
                int atNo = atoms[ctab[i][j]].getAtno();
                if (atNo > 109 || atNo == 1) continue;
                iSet.add(atNo);
            }
            if (iSet.size() < 3) continue;
            value = (byte)(value | 1);
        }
        return value;
    }

    public static byte[] getConnectionBytes(Molecule molecule, boolean isQuery) {
        byte[] result = new byte[15];
        MolAtom[] atoms = molecule.getAtomArray();
        boolean[] canBeH = MixedStatUtil.canBeH(atoms);
        boolean[] canBeNonH = MixedStatUtil.canBeNonH(atoms);
        int[][] ctab = molecule.getCtab();
        BondTable bt = molecule.getBondTable();
        int[] neighbors = new int[ctab.length];
        for (int i = 0; i < ctab.length; ++i) {
            int j;
            if (isQuery && canBeH[i]) continue;
            int aromBond = 0;
            int otherBond = 0;
            int doubleBond = 0;
            int singleBond = 0;
            for (j = 0; j < ctab[i].length; ++j) {
                int bondType;
                int bondIndex;
                if (isQuery) {
                    if (canBeH[ctab[i][j]] || (bondIndex = bt.getBondIndex(i, ctab[i][j])) == -1) continue;
                    bondType = molecule.getBond(bondIndex).getType();
                    if (bondType == 1) {
                        ++singleBond;
                        continue;
                    }
                    if (bondType == 2) {
                        ++doubleBond;
                        continue;
                    }
                    if (bondType == 4) {
                        ++aromBond;
                        continue;
                    }
                    ++otherBond;
                    continue;
                }
                if (!canBeNonH[ctab[i][j]] || (bondIndex = bt.getBondIndex(i, ctab[i][j])) == -1) continue;
                bondType = molecule.getBond(bondIndex).getType();
                if (bondType == 1) {
                    ++singleBond;
                    continue;
                }
                if (bondType == 2) {
                    ++doubleBond;
                    continue;
                }
                if (bondType == 4) {
                    ++aromBond;
                    continue;
                }
                ++otherBond;
            }
            neighbors[i] = singleBond + doubleBond + (otherBond += aromBond);
            MixedStatUtil.setDoubleBondRelated(result, singleBond, doubleBond, otherBond);
            MixedStatUtil.setTotalBondRelated(result, neighbors[i]);
            MixedStatUtil.setAromBondRelated(result, aromBond);
            for (j = 0; j < 15; ++j) {
                if (result[j] >= 0) continue;
                result[j] = 127;
            }
        }
        for (int i = 0; i < neighbors.length; ++i) {
            if (canBeH[i] || neighbors[i] < 3) continue;
            for (int j = 0; j < ctab[i].length; ++j) {
                int nCount = neighbors[ctab[i][j]];
                switch (nCount) {
                    default: {
                        result[0] = (byte)(result[0] + 1);
                    }
                    case 2: {
                        result[1] = (byte)(result[1] + 1);
                    }
                    case 1: {
                        result[2] = (byte)(result[2] + 1);
                    }
                    case 0: 
                }
                for (int k = 0; k <= 2; ++k) {
                    if (result[k] >= 0) continue;
                    result[k] = 127;
                }
            }
        }
        return result;
    }

    private static void setAromBondRelated(byte[] result, int aromBond) {
        switch (aromBond) {
            default: {
                result[11] = (byte)(result[11] + 1);
            }
            case 3: {
                result[12] = (byte)(result[12] + 1);
            }
            case 2: {
                result[13] = (byte)(result[13] + 1);
            }
            case 1: {
                result[14] = (byte)(result[14] + 1);
            }
            case 0: 
        }
    }

    private static void setTotalBondRelated(byte[] result, int totalBond) {
        switch (totalBond) {
            default: {
                result[3] = (byte)(result[3] + 1);
            }
            case 3: {
                result[4] = (byte)(result[4] + 1);
            }
            case 2: {
                result[5] = (byte)(result[5] + 1);
            }
            case 1: {
                result[6] = (byte)(result[6] + 1);
            }
            case 0: 
        }
    }

    private static void setDoubleBondRelated(byte[] result, int singleBond, int doubleBond, int otherBond) {
        if (doubleBond > 0) {
            result[10] = (byte)(result[10] + 1);
            if (doubleBond > 1) {
                result[7] = (byte)(result[7] + 1);
            }
            if (singleBond + otherBond > 0 || doubleBond > 1) {
                result[9] = (byte)(result[9] + 1);
                if (singleBond + otherBond + doubleBond > 2) {
                    result[8] = (byte)(result[8] + 1);
                }
            }
        }
    }

    private static boolean[] canBeH(MolAtom[] atoms) {
        boolean[] result = new boolean[atoms.length];
        for (int i = 0; i < atoms.length; ++i) {
            result[i] = MixedStatUtil.canBeH(atoms[i]);
        }
        return result;
    }

    private static boolean canBeH(MolAtom atom) {
        int atNo = atom.getAtno();
        if (atNo <= 109 && atNo != 1) {
            return false;
        }
        switch (atNo) {
            case 128: {
                int[] atNos;
                for (int i : atNos = atom.getList()) {
                    if (i != 1) continue;
                    return true;
                }
                return false;
            }
            case 131: 
            case 132: {
                return false;
            }
            case 136: {
                if ("Q".equalsIgnoreCase(atom.getAliasstr())) {
                    return false;
                }
                if ("A".equalsIgnoreCase(atom.getAliasstr())) {
                    return false;
                }
                if ("M".equalsIgnoreCase(atom.getAliasstr())) {
                    return false;
                }
                if ("X".equalsIgnoreCase(atom.getAliasstr())) {
                    return false;
                }
                if (atom.getAliasstr().toUpperCase().equals("G1")) break;
                return false;
            }
        }
        return true;
    }

    private static boolean[] canBeNonH(MolAtom[] atoms) {
        boolean[] result = new boolean[atoms.length];
        for (int i = 0; i < atoms.length; ++i) {
            result[i] = MixedStatUtil.canBeNonH(atoms[i]);
        }
        return result;
    }

    private static boolean canBeNonH(MolAtom atom) {
        int atNo = atom.getAtno();
        switch (atNo) {
            case 1: {
                return false;
            }
            case 128: {
                int[] atNos;
                for (int i : atNos = atom.getList()) {
                    if (i == 1) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private static byte updateAtomByte(int atNo) {
        switch (atNo) {
            case 6: {
                return 1;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 2;
            }
            case 9: 
            case 17: 
            case 35: 
            case 53: 
            case 85: {
                return 8;
            }
        }
        if (atNo < 109) {
            return 16;
        }
        return 0;
    }
}

