/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.composite.parts.simplefp;

import chemaxon.sss.screen.composite.parts.simplefp.SimpleFpGenerator;
import chemaxon.sss.screen.options.ScreenOptions;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class SimpleFpCountGenerator {
    public static final int LENGTH_IN_BYTES = 8;

    public static byte[] generateDescriptor(Molecule mol, boolean queryMode, ScreenOptions screenOptions) {
        MolAtom[] atomArray;
        byte[] res = new byte[8];
        Molecule correctedMol = SimpleFpGenerator.takeMustFragmentForQuery(mol, queryMode);
        for (MolAtom atom : atomArray = correctedMol.getAtomArray()) {
            byte atomBits = SimpleFpGenerator.getAtomBitMask(atom, queryMode);
            for (int i = 0; i < 8; ++i) {
                if ((atomBits & 1 << i) == 0) continue;
                int n = i;
                res[n] = (byte)(res[n] + 1);
            }
        }
        return res;
    }
}

