/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.composite.parts.simplefp;

import chemaxon.core.calculations.BondClassifier;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.sss.screen.options.ScreenOptions;
import chemaxon.sss.screen.util.AtomTypeClassifier;
import chemaxon.sss.screen.util.TernaryBoolean;
import chemaxon.sss.search.options.AtomPropertyMatchingOption;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;

public class SimpleFpGenerator {
    public static final int LENGTH_IN_BYTES = 16;
    private static final byte ANY_BITMASK = -128;
    private static final byte HETERO_BITMASK = 64;
    private static final byte C_BITMASK = -127;
    private static final byte N_BITMASK = -62;
    private static final byte O_BITMASK = -60;
    private static final byte S_BITMASK = -56;
    private static final byte HALOGEN_BITMASK = -48;
    private static final byte METAL_BITMASK = -32;

    static byte[] generateDescriptor(Molecule mol, boolean queryMode, ScreenOptions screenOptions) {
        boolean ignoreRadicals;
        boolean ignoreIsotopes;
        boolean ignoreCharges;
        byte[] fp = new byte[16];
        int pos = 0;
        Molecule correctedMol = SimpleFpGenerator.takeMustFragmentForQuery(mol, queryMode);
        BondClassifier classifier = new BondClassifier();
        classifier.classify(correctedMol);
        MolAtom[] atoms = correctedMol.getAtomArray();
        fp[pos++] = queryMode ? SimpleFpGenerator.getAcyclicBits(atoms, queryMode, screenOptions, classifier) : SimpleFpGenerator.getAtomBits(atoms, queryMode, screenOptions);
        fp[pos++] = SimpleFpGenerator.getCyclicBits(atoms, queryMode, screenOptions, classifier);
        boolean bl = ignoreCharges = queryMode && screenOptions.getChargeMatchingOption() == AtomPropertyMatchingOption.IGNORE;
        if (!ignoreCharges) {
            if (queryMode) {
                fp[pos++] = SimpleFpGenerator.getPosChargeAcyclicBits(atoms, queryMode, screenOptions, classifier);
                fp[pos++] = SimpleFpGenerator.getNegChargeAcyclicBits(atoms, queryMode, screenOptions, classifier);
            } else {
                fp[pos++] = SimpleFpGenerator.getPosChargeBits(atoms, queryMode, screenOptions);
                fp[pos++] = SimpleFpGenerator.getNegChargeBits(atoms, queryMode, screenOptions);
            }
            fp[pos++] = SimpleFpGenerator.getPosChargeCyclicBits(atoms, queryMode, screenOptions, classifier);
            fp[pos++] = SimpleFpGenerator.getNegChargeCyclicBits(atoms, queryMode, screenOptions, classifier);
        } else {
            pos += 4;
        }
        boolean bl2 = ignoreIsotopes = queryMode && screenOptions.getIsotopeMatchingOption() == AtomPropertyMatchingOption.IGNORE;
        if (!ignoreIsotopes) {
            fp[pos++] = SimpleFpGenerator.getIsotopeBits(atoms, queryMode, screenOptions);
        } else {
            ++pos;
        }
        boolean bl3 = ignoreRadicals = queryMode && screenOptions.getRadicalMatchingOption() == AtomPropertyMatchingOption.IGNORE;
        if (!ignoreRadicals) {
            fp[pos++] = SimpleFpGenerator.getRadicalBits(atoms, queryMode, screenOptions);
        }
        int n = ++pos;
        fp[n] = SimpleFpGenerator.getAtomWithBondBits(atoms, queryMode, screenOptions, 2);
        int n2 = ++pos;
        fp[n2] = SimpleFpGenerator.getAtomWithBondBits(atoms, queryMode, screenOptions, 3);
        int n3 = ++pos;
        fp[n3] = SimpleFpGenerator.getAtomWithBondBits(atoms, queryMode, screenOptions, 4);
        int n4 = ++pos;
        fp[n4] = SimpleFpGenerator.getAtomWithMinBondBits(atoms, queryMode, screenOptions, 2);
        int n5 = ++pos;
        fp[n5] = SimpleFpGenerator.getAtomWithMinBondBits(atoms, queryMode, screenOptions, 3);
        int n6 = ++pos;
        fp[n6] = SimpleFpGenerator.getAtomWithMinBondBits(atoms, queryMode, screenOptions, 4);
        int n7 = ++pos;
        fp[n7] = SimpleFpGenerator.getAtomWithMinRingBondBits(correctedMol, queryMode, screenOptions, classifier, 3);
        int n8 = ++pos;
        ++pos;
        fp[n8] = SimpleFpGenerator.getAtomWithMinRingBondBits(correctedMol, queryMode, screenOptions, classifier, 4);
        return fp;
    }

    static Molecule takeMustFragmentForQuery(Molecule mol, boolean queryMode) {
        return queryMode && mol instanceof RgMolecule ? ((RgMolecule)mol).getRoot() : mol;
    }

    private static byte getAtomBits(MolAtom[] atoms, boolean queryMode, ScreenOptions screenOptions) {
        byte value = 0;
        for (int i = 0; i < atoms.length; ++i) {
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atoms[i], queryMode));
        }
        return value;
    }

    private static byte getAcyclicBits(MolAtom[] atoms, boolean queryMode, ScreenOptions screenOptions, BondClassifier classifier) {
        byte value = 0;
        for (int i = 0; i < atoms.length; ++i) {
            MolAtom atom = atoms[i];
            if (SimpleFpGenerator.isRingAtom(classifier, queryMode, atom, i)) continue;
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getCyclicBits(MolAtom[] atoms, boolean queryMode, ScreenOptions screenOptions, BondClassifier classifier) {
        byte value = 0;
        for (int i = 0; i < atoms.length; ++i) {
            MolAtom atom = atoms[i];
            if (!SimpleFpGenerator.isRingAtom(classifier, queryMode, atom, i)) continue;
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getPosChargeBits(MolAtom[] atoms, boolean queryMode, ScreenOptions screenOptions) {
        byte value = 0;
        for (MolAtom atom : atoms) {
            if (atom.getCharge() <= 0) continue;
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getNegChargeBits(MolAtom[] atoms, boolean queryMode, ScreenOptions screenOptions) {
        byte value = 0;
        for (MolAtom atom : atoms) {
            if (atom.getCharge() >= 0) continue;
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getPosChargeAcyclicBits(MolAtom[] atoms, boolean queryMode, ScreenOptions screenOptions, BondClassifier classifier) {
        byte value = 0;
        for (int i = 0; i < atoms.length; ++i) {
            MolAtom atom = atoms[i];
            if (atom.getCharge() <= 0 || SimpleFpGenerator.isRingAtom(classifier, queryMode, atom, i)) continue;
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getPosChargeCyclicBits(MolAtom[] atoms, boolean queryMode, ScreenOptions screenOptions, BondClassifier classifier) {
        byte value = 0;
        for (int i = 0; i < atoms.length; ++i) {
            MolAtom atom = atoms[i];
            if (atom.getCharge() <= 0 || !SimpleFpGenerator.isRingAtom(classifier, queryMode, atom, i)) continue;
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getNegChargeAcyclicBits(MolAtom[] atoms, boolean queryMode, ScreenOptions screenOptions, BondClassifier classifier) {
        byte value = 0;
        for (int i = 0; i < atoms.length; ++i) {
            MolAtom atom = atoms[i];
            if (atom.getCharge() >= 0 || SimpleFpGenerator.isRingAtom(classifier, queryMode, atom, i)) continue;
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getNegChargeCyclicBits(MolAtom[] atoms, boolean queryMode, ScreenOptions screenOptions, BondClassifier classifier) {
        byte value = 0;
        for (int i = 0; i < atoms.length; ++i) {
            MolAtom atom = atoms[i];
            if (atom.getCharge() >= 0 || !SimpleFpGenerator.isRingAtom(classifier, queryMode, atom, i)) continue;
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getIsotopeBits(MolAtom[] atoms, boolean queryMode, ScreenOptions screenOptions) {
        byte value = 0;
        for (MolAtom atom : atoms) {
            if (atom.getMassno() == 0) continue;
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getRadicalBits(MolAtom[] atoms, boolean queryMode, ScreenOptions screenOptions) {
        byte value = 0;
        for (MolAtom atom : atoms) {
            if (atom.getRadicalCount() == 0) continue;
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getAtomWithMinBondBits(MolAtom[] atoms, boolean queryMode, ScreenOptions screenOptions, int minHeavyNeighborCount) {
        byte value = 0;
        for (MolAtom atom : atoms) {
            if (SimpleFpGenerator.canMatchOnSeveralAtoms(atom, queryMode)) continue;
            int heavyNeighborCount = 0;
            for (int j = 0; j < atom.getBondCount(); ++j) {
                boolean ignore;
                TernaryBoolean isH = AtomTypeClassifier.isHydrogen(atom.getLigand(j));
                boolean bl = ignore = isH == TernaryBoolean.TRUE || isH == TernaryBoolean.UNKNOWN && queryMode;
                if (ignore) continue;
                ++heavyNeighborCount;
            }
            if (heavyNeighborCount < minHeavyNeighborCount) continue;
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static boolean canMatchOnSeveralAtoms(MolAtom atom, boolean queryMode) {
        if (!queryMode) {
            return false;
        }
        return atom.getAtno() == 134 || HomologyConstants.isHomology(atom.getAliasstr());
    }

    private static byte getAtomWithMinRingBondBits(Molecule mol, boolean queryMode, ScreenOptions screenOptions, BondClassifier classifier, int minRingBondCount) {
        byte value = 0;
        int[][] ctab = mol.getCtab();
        int atomCount = mol.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            MolAtom atom = mol.getAtom(i);
            if (SimpleFpGenerator.canMatchOnSeveralAtoms(atom, queryMode)) continue;
            int ringBondCount = 0;
            for (int j = 0; j < ctab[i].length; ++j) {
                boolean ignore;
                TernaryBoolean isH = AtomTypeClassifier.isHydrogen(atom.getLigand(j));
                boolean bl = ignore = isH == TernaryBoolean.TRUE || isH == TernaryBoolean.UNKNOWN && queryMode;
                if (ignore) continue;
                if (classifier.isRingBond(i, ctab[i][j])) {
                    ++ringBondCount;
                    continue;
                }
                if (!queryMode || (atom.getBond(j).getFlags() & 0xC00) != 1024) continue;
                ++ringBondCount;
            }
            if (ringBondCount < minRingBondCount) continue;
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    private static byte getAtomWithBondBits(MolAtom[] atoms, boolean queryMode, ScreenOptions screenOptions, int bondType) {
        byte value = 0;
        for (MolAtom atom : atoms) {
            boolean found = false;
            for (int j = 0; j < atom.getBondCount(); ++j) {
                boolean ignore;
                TernaryBoolean isH = AtomTypeClassifier.isHydrogen(atom.getLigand(j));
                boolean bl = ignore = isH == TernaryBoolean.TRUE || isH == TernaryBoolean.UNKNOWN && queryMode;
                if (ignore) continue;
                int bt = atom.getBond(j).getType();
                if (bt == bondType) {
                    found = true;
                    break;
                }
                if (queryMode || bt == 1 || bt == 2 || bt == 3 || bt == 4) continue;
                found = true;
            }
            if (!found) continue;
            value = (byte)(value | 0xFFFFFF80);
            value = (byte)(value | SimpleFpGenerator.getAtomBitMask(atom, queryMode));
        }
        return value;
    }

    static byte getAtomBitMask(MolAtom atom, boolean queryMode) {
        byte value = 0;
        TernaryBoolean tb = AtomTypeClassifier.isChemicalAtom(atom, 6);
        if (tb == TernaryBoolean.TRUE) {
            return -127;
        }
        if (tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 0xFFFFFF81);
        }
        if ((tb = AtomTypeClassifier.isChemicalAtom(atom, 7)) == TernaryBoolean.TRUE) {
            return -62;
        }
        if (tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 0xFFFFFFC2);
        }
        if ((tb = AtomTypeClassifier.isChemicalAtom(atom, 8)) == TernaryBoolean.TRUE) {
            return -60;
        }
        if (tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 0xFFFFFFC4);
        }
        if ((tb = AtomTypeClassifier.isChemicalAtom(atom, 16)) == TernaryBoolean.TRUE) {
            return -56;
        }
        if (tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 0xFFFFFFC8);
        }
        if ((tb = AtomTypeClassifier.isHalogen(atom)) == TernaryBoolean.TRUE) {
            return -48;
        }
        if (tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 0xFFFFFFD0);
        }
        if ((tb = AtomTypeClassifier.isMetal(atom)) == TernaryBoolean.TRUE) {
            return -32;
        }
        if (tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 0xFFFFFFE0);
        }
        if ((tb = AtomTypeClassifier.isHetero(atom)) == TernaryBoolean.TRUE || tb == TernaryBoolean.UNKNOWN && !queryMode) {
            value = (byte)(value | 0x40);
        }
        return value;
    }

    private static boolean isRingAtom(BondClassifier classifier, boolean queryMode, MolAtom atom, int i) {
        if (classifier.isRingAtom(i)) {
            return true;
        }
        if (queryMode) {
            if (atom.getQPropAsInt("rb") > 0 || atom.getQPropAsInt("R") > 0 || atom.getQPropAsInt("r") > 2) {
                return true;
            }
            for (int k = 0; k < atom.getBondCount(); ++k) {
                MolBond bond = atom.getBond(k);
                if ((bond.getFlags() & 0xC00) != 1024) continue;
                return true;
            }
        }
        return false;
    }
}

