/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.options;

public enum ScreenSearchType {
    SUBSTRUCTURE(2),
    FULL_STRUCTURE(4),
    FULL_FRAGMENT(7);

    private final int typeId;

    private ScreenSearchType(int typeId) {
        this.typeId = typeId;
    }

    public static ScreenSearchType valueOf(int type) throws IllegalArgumentException {
        for (ScreenSearchType st : ScreenSearchType.values()) {
            if (st.typeId != type) continue;
            return st;
        }
        throw new IllegalArgumentException("Search type " + type + " is not supported");
    }

    public int getSearchTypeConstant() {
        return this.typeId;
    }
}

