/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.util;

import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.sss.screen.util.GenericQueryAtom;
import chemaxon.sss.screen.util.GenericQueryAtomHandler;
import chemaxon.sss.screen.util.TernaryBoolean;
import chemaxon.struc.MolAtom;
import chemaxon.struc.PeriodicSystem;

public class AtomTypeClassifier {
    private static String[] HALOGEN_GROUPS = new String[]{"G17"};
    private static String[] NON_HALOGEN_GROUPS = new String[]{"G1", "G2", "G3", "G4", "G5", "G6", "G7", "G8", "G9", "G10", "G11", "G12", "G13", "G14", "G15", "G16", "G18"};
    private static String[] METAL_GROUPS = new String[]{"G2", "G3", "G4", "G5", "G6", "G7", "G8", "G9", "G10", "G11", "G12"};
    private static String[] NON_METAL_GROUPS = new String[]{"G16", "G17", "G18"};

    public static TernaryBoolean isChemicalAtom(MolAtom atom, int chemType) {
        int atNo = atom.getAtno();
        if (atNo >= 1 && atNo <= 109) {
            return TernaryBoolean.valueOf(atNo == chemType);
        }
        switch (atNo) {
            case 128: {
                int[] list = atom.getList();
                boolean found = false;
                boolean all = true;
                for (int t : list) {
                    if (t == chemType) {
                        found = true;
                        continue;
                    }
                    all = false;
                }
                if (!found) {
                    return TernaryBoolean.FALSE;
                }
                if (all) {
                    return TernaryBoolean.TRUE;
                }
                return TernaryBoolean.UNKNOWN;
            }
            case 129: {
                int[] notList;
                for (int t : notList = atom.getList()) {
                    if (t != chemType) continue;
                    return TernaryBoolean.FALSE;
                }
                return TernaryBoolean.UNKNOWN;
            }
            case 131: 
            case 132: 
            case 136: {
                GenericQueryAtom qa = GenericQueryAtomHandler.fromSymbol(atom.getSymbol());
                if (qa != null && !qa.isRepresentedAtomType(chemType)) {
                    return TernaryBoolean.FALSE;
                }
                String aliasStr = atom.getAliasstr();
                if ((HomologyConstants.isAlkyl(aliasStr) || HomologyConstants.isAlkenyl(aliasStr) || HomologyConstants.isAlkynyl(aliasStr) || HomologyConstants.isCarbonTree(aliasStr) || HomologyConstants.isCycloAlkyl(aliasStr) || HomologyConstants.isAryl(aliasStr)) && chemType != 6 && chemType != 1) {
                    return TernaryBoolean.FALSE;
                }
                return TernaryBoolean.UNKNOWN;
            }
        }
        return TernaryBoolean.UNKNOWN;
    }

    public static TernaryBoolean isHydrogen(MolAtom atom) {
        return AtomTypeClassifier.isChemicalAtom(atom, 1);
    }

    public static TernaryBoolean isCarbon(MolAtom atom) {
        return AtomTypeClassifier.isChemicalAtom(atom, 6);
    }

    public static TernaryBoolean isHetero(MolAtom atom) {
        return TernaryBoolean.not(TernaryBoolean.or(AtomTypeClassifier.isCarbon(atom), AtomTypeClassifier.isHydrogen(atom)));
    }

    public static TernaryBoolean isHalogen(MolAtom atom) {
        int atNo = atom.getAtno();
        if (atNo >= 1 && atNo <= 109) {
            return TernaryBoolean.valueOf(PeriodicSystem.isHalogen(atNo));
        }
        switch (atNo) {
            case 128: {
                int[] list = atom.getList();
                boolean found = false;
                boolean all = true;
                for (int t : list) {
                    if (PeriodicSystem.isHalogen(t)) {
                        found = true;
                        continue;
                    }
                    all = false;
                }
                if (!found) {
                    return TernaryBoolean.FALSE;
                }
                if (all) {
                    return TernaryBoolean.TRUE;
                }
                return TernaryBoolean.UNKNOWN;
            }
            case 129: {
                return TernaryBoolean.UNKNOWN;
            }
            case 131: 
            case 132: 
            case 136: {
                String symbol = atom.getSymbol();
                if ("X".equalsIgnoreCase(symbol)) {
                    return TernaryBoolean.TRUE;
                }
                if ("M".equalsIgnoreCase(symbol)) {
                    return TernaryBoolean.FALSE;
                }
                if ("MH".equalsIgnoreCase(symbol)) {
                    return TernaryBoolean.FALSE;
                }
                String aliasStr = atom.getAliasstr();
                for (String groupStr : HALOGEN_GROUPS) {
                    if (!groupStr.equalsIgnoreCase(aliasStr)) continue;
                    return TernaryBoolean.TRUE;
                }
                for (String groupStr : NON_HALOGEN_GROUPS) {
                    if (!groupStr.equalsIgnoreCase(aliasStr)) continue;
                    return TernaryBoolean.FALSE;
                }
                if (HomologyConstants.isAlkyl(aliasStr) || HomologyConstants.isAlkenyl(aliasStr) || HomologyConstants.isAlkynyl(aliasStr) || HomologyConstants.isCarbonTree(aliasStr) || HomologyConstants.isCycloAlkyl(aliasStr) || HomologyConstants.isAryl(aliasStr)) {
                    return TernaryBoolean.FALSE;
                }
                if (HomologyConstants.isMetallicHomology(aliasStr)) {
                    return TernaryBoolean.FALSE;
                }
                return TernaryBoolean.UNKNOWN;
            }
        }
        return TernaryBoolean.UNKNOWN;
    }

    public static TernaryBoolean isMetal(MolAtom atom) {
        int atNo = atom.getAtno();
        if (atNo >= 1 && atNo <= 109) {
            return TernaryBoolean.valueOf(PeriodicSystem.isMetal(atNo));
        }
        switch (atNo) {
            case 128: {
                int[] list = atom.getList();
                boolean found = false;
                boolean all = true;
                for (int t : list) {
                    if (PeriodicSystem.isMetal(t)) {
                        found = true;
                        continue;
                    }
                    all = false;
                }
                if (!found) {
                    return TernaryBoolean.FALSE;
                }
                if (all) {
                    return TernaryBoolean.TRUE;
                }
                return TernaryBoolean.UNKNOWN;
            }
            case 129: {
                return TernaryBoolean.UNKNOWN;
            }
            case 131: 
            case 132: 
            case 136: {
                String symbol = atom.getSymbol();
                if ("M".equalsIgnoreCase(symbol)) {
                    return TernaryBoolean.TRUE;
                }
                if ("X".equalsIgnoreCase(symbol)) {
                    return TernaryBoolean.FALSE;
                }
                if ("XH".equalsIgnoreCase(symbol)) {
                    return TernaryBoolean.FALSE;
                }
                String aliasStr = atom.getAliasstr();
                for (String groupStr : METAL_GROUPS) {
                    if (!groupStr.equalsIgnoreCase(aliasStr)) continue;
                    return TernaryBoolean.TRUE;
                }
                for (String groupStr : NON_METAL_GROUPS) {
                    if (!groupStr.equalsIgnoreCase(aliasStr)) continue;
                    return TernaryBoolean.FALSE;
                }
                if (HomologyConstants.isMetallicHomology(aliasStr)) {
                    return TernaryBoolean.TRUE;
                }
                if (HomologyConstants.isAlkyl(aliasStr) || HomologyConstants.isAlkenyl(aliasStr) || HomologyConstants.isAlkynyl(aliasStr) || HomologyConstants.isCarbonTree(aliasStr) || HomologyConstants.isCycloAlkyl(aliasStr) || HomologyConstants.isAryl(aliasStr)) {
                    return TernaryBoolean.FALSE;
                }
                return TernaryBoolean.UNKNOWN;
            }
        }
        return TernaryBoolean.UNKNOWN;
    }
}

