/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.util;

import chemaxon.sss.screen.util.TernaryBoolean;
import chemaxon.struc.MolBond;

public class BondTypeClassifier {
    private boolean anyIncludeAromatic;

    public BondTypeClassifier(boolean anyIncludeAromatic) {
        this.anyIncludeAromatic = anyIncludeAromatic;
    }

    public TernaryBoolean isSingle(MolBond bond) {
        return this.isChemicalBond(bond, 1);
    }

    public TernaryBoolean isDouble(MolBond bond) {
        return this.isChemicalBond(bond, 2);
    }

    public TernaryBoolean isTriple(MolBond bond) {
        return this.isChemicalBond(bond, 3);
    }

    public TernaryBoolean isAromatic(MolBond bond) {
        return this.isChemicalBond(bond, 4);
    }

    private TernaryBoolean isChemicalBond(MolBond bond, int chemType) {
        int bondType = bond.getType();
        switch (bondType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return TernaryBoolean.valueOf(bondType == chemType);
            }
            case 5: {
                if (chemType == 1 || chemType == 2) {
                    return TernaryBoolean.UNKNOWN;
                }
                return TernaryBoolean.FALSE;
            }
            case 6: {
                if (chemType == 1 || chemType == 4) {
                    return TernaryBoolean.UNKNOWN;
                }
                return TernaryBoolean.FALSE;
            }
            case 7: {
                if (chemType == 2 || chemType == 4) {
                    return TernaryBoolean.UNKNOWN;
                }
                return TernaryBoolean.FALSE;
            }
            case 0: {
                if (chemType == 4) {
                    return this.anyIncludeAromatic ? TernaryBoolean.UNKNOWN : TernaryBoolean.FALSE;
                }
                return TernaryBoolean.UNKNOWN;
            }
            case 8: {
                return TernaryBoolean.FALSE;
            }
            case 9: {
                return TernaryBoolean.FALSE;
            }
        }
        return TernaryBoolean.UNKNOWN;
    }
}

