/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.util;

import chemaxon.core.calculations.BondClassifier;
import chemaxon.core.calculations.RingClassifier;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.sss.screen.util.TernaryBoolean;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.RgMoleculeBondClassifier;

public class RingMembershipUtil {
    private RingClassifier classifier;
    private int[][] ctab;

    public RingMembershipUtil(Molecule mol) {
        this.classifier = mol instanceof RgMolecule ? new RgMoleculeBondClassifier() : new BondClassifier();
        this.classifier.classify(mol);
        this.ctab = mol.getCtab();
    }

    public TernaryBoolean isRingAtom(MolAtom atom, int atomIdx, boolean checkQueryProperties) {
        TernaryBoolean result = this.isRingAtomByTopology(atom, atomIdx);
        if (checkQueryProperties) {
            result = this.checkQueryProperties(result, atom);
        }
        result = this.checkHomologies(result, atom.getAliasstr());
        return result;
    }

    public TernaryBoolean isRingBond(MolBond bond, int atomIdx1, int atomIdx2, boolean checkQueryProperties) {
        TernaryBoolean result = this.isRingBondByTopology(bond, atomIdx1, atomIdx2);
        if (checkQueryProperties && (bond.getFlags() & 0xC00) == 1024) {
            result = TernaryBoolean.TRUE;
        }
        return result;
    }

    public int getNumberOfRingBonds(MolAtom atom, int atomIdx, boolean checkQueryProperties) {
        int ringBondCountTopology = this.getRingBondCountTopology(atom, atomIdx, checkQueryProperties);
        int ringBondCountAtomic = 0;
        if (checkQueryProperties) {
            ringBondCountAtomic = this.getRingAtomCountFromProperties(atom);
        }
        return Math.max(ringBondCountTopology, ringBondCountAtomic);
    }

    private TernaryBoolean isRingAtomByTopology(MolAtom atom, int origIdx) {
        if (this.classifier instanceof RgMoleculeBondClassifier) {
            switch (((RgMoleculeBondClassifier)this.classifier).getRingmembershipOfAtom(origIdx)) {
                case IN_RING: {
                    return TernaryBoolean.TRUE;
                }
                case NOT_RING: {
                    return TernaryBoolean.FALSE;
                }
            }
            return TernaryBoolean.UNKNOWN;
        }
        return TernaryBoolean.valueOf(this.classifier.isRingAtom(origIdx));
    }

    private TernaryBoolean checkQueryProperties(TernaryBoolean cyclic, MolAtom atom) {
        if (cyclic != TernaryBoolean.TRUE) {
            if (atom.getQPropAsInt("R") > 0 || atom.getQPropAsInt("rb") > 0 || atom.getQPropAsInt("r") > 2) {
                return TernaryBoolean.TRUE;
            }
            for (int k = 0; k < atom.getBondCount(); ++k) {
                if ((atom.getBond(k).getFlags() & 0xC00) != 1024) continue;
                return TernaryBoolean.TRUE;
            }
        }
        return cyclic;
    }

    private TernaryBoolean checkHomologies(TernaryBoolean cyclic, String aliasStr) {
        if (aliasStr != null && aliasStr.length() > 0) {
            if (HomologyConstants.isCyclicHomology(aliasStr)) {
                return TernaryBoolean.TRUE;
            }
            if (HomologyConstants.isUnknown(aliasStr)) {
                return TernaryBoolean.UNKNOWN;
            }
            if (cyclic == TernaryBoolean.TRUE && (HomologyConstants.isAlkyl(aliasStr) || HomologyConstants.isAlkenyl(aliasStr) || HomologyConstants.isAlkynyl(aliasStr) || HomologyConstants.isCarbonTree(aliasStr))) {
                return TernaryBoolean.UNKNOWN;
            }
        }
        return cyclic;
    }

    private TernaryBoolean isRingBondByTopology(MolBond bond, int atomIdx1, int atomIdx2) {
        if (this.classifier instanceof RgMoleculeBondClassifier) {
            switch (((RgMoleculeBondClassifier)this.classifier).getRingmembershipOfBond(atomIdx1, atomIdx2)) {
                case IN_RING: {
                    return TernaryBoolean.TRUE;
                }
                case NOT_RING: {
                    return TernaryBoolean.FALSE;
                }
            }
            return TernaryBoolean.UNKNOWN;
        }
        return TernaryBoolean.valueOf(this.classifier.isRingBond(atomIdx1, atomIdx2));
    }

    private int getRingBondCountTopology(MolAtom atom, int atomIdx, boolean checkQueryProperties) {
        int ringBondCount = 0;
        for (int k = 0; k < this.ctab[atomIdx].length; ++k) {
            int neighborIdx;
            MolBond bond = atom.getBond(k);
            if (this.isRingBond(bond, atomIdx, neighborIdx = this.ctab[atomIdx][k], checkQueryProperties) != TernaryBoolean.TRUE) continue;
            ++ringBondCount;
        }
        return ringBondCount;
    }

    private int getRingAtomCountFromProperties(MolAtom atom) {
        int rb = atom.getQPropAsInt("rb");
        if (rb > -1) {
            return rb;
        }
        int R = atom.getQPropAsInt("R");
        if (R > -1) {
            return R > 0 ? 2 : 0;
        }
        int r = atom.getQPropAsInt("r");
        if (r > 2) {
            return 2;
        }
        return 0;
    }
}

