/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.util;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceUtil {
    private static final Log log = LogFactory.getLog(ServiceUtil.class);

    public static <S> S loadService(Class<S> service) throws ServiceConfigurationError {
        ServiceLoader<S> loader;
        Iterator<S> it;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load service for " + service.getName()));
        }
        if (!(it = (loader = ServiceLoader.load(service)).iterator()).hasNext()) {
            if (log.isErrorEnabled()) {
                log.error((Object)("No service found for " + service.getName()));
            }
            throw new ServiceConfigurationError("No service found for " + service.getName());
        }
        S ret = it.next();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service found: " + ret.getClass().getName()));
        }
        return ret;
    }

    public static <S> boolean isServiceAvailable(Class<S> service) throws ServiceConfigurationError {
        ServiceLoader<S> loader;
        Iterator<S> it;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Check service: " + service.getName()));
        }
        if ((it = (loader = ServiceLoader.load(service)).iterator()).hasNext()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Sevice found");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Service not found");
        }
        return false;
    }
}

