/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.sss.search.MolComparator;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class DataSgroupComparator
extends MolComparator {
    private static final int IGNORE = 0;
    private static final int GENERAL = 1;
    private static final int EXACT = 2;
    private static final char[] escapedChars = new char[]{'\\', '(', ')', '[', ']', '{', '}', '^', '-', '$', '|', '?', '*', '+', '.'};
    private boolean dirtyPrefixes = true;
    private boolean dirtyQuery = true;
    private boolean dirtyTarget = true;
    private int sgqno;
    private int sgtno;
    private boolean isComparingNeeded = true;
    private boolean[] foundQuerySgroupInTarget;
    private boolean exactNameMatching = false;
    private int mode = 0;
    private String[] prefixesToCheck = null;
    ArrayList<DataSgroup> qComparedDataSgroups;
    ArrayList<DataSgroup> tComparedDataSgroups;
    ArrayList<ArrayList<Integer>> qDataSgroupsForAtoms;
    ArrayList<ArrayList<Integer>> tDataSgroupsForAtoms;

    public DataSgroupComparator() {
    }

    public DataSgroupComparator(int matchMode, String sgNamePrefixes) {
        this.setCheckMode(matchMode);
        this.setPrefixes(sgNamePrefixes);
    }

    public DataSgroupComparator(int matchMode, String sgNamePrefixes, boolean exactNameMatching) {
        this.setCheckMode(matchMode);
        this.setPrefixes(sgNamePrefixes);
        this.exactNameMatching = exactNameMatching;
    }

    public DataSgroupComparator(String sgNamePrefixes) {
        this.setPrefixes(sgNamePrefixes);
    }

    public void setCheckMode(int value) {
        if (value != 0 && value != 1 && value != 2) {
            throw new IllegalArgumentException("Illegal value of data sgroup comparison mode: " + value);
        }
        this.mode = value;
    }

    public void setPrefixes(String prefixes) {
        this.prefixesToCheck = prefixes == null || prefixes.equals("") ? null : prefixes.split(",");
        this.dirtyPrefixes = true;
    }

    @Override
    public void setQuery(Molecule q) {
        super.setQuery(q);
        this.dirtyQuery = true;
        this.isComparingNeeded = true;
    }

    @Override
    public void setTarget(Molecule t) {
        super.setTarget(t);
        this.dirtyTarget = true;
        this.isComparingNeeded = true;
    }

    public static boolean areCompatibleLists(ArrayList<DataSgroup> queryList, ArrayList<DataSgroup> targetList, boolean isExactComparison) {
        return DataSgroupComparator.isMatching(null, null, queryList, targetList, isExactComparison ? 2 : 1, null);
    }

    @Override
    public boolean compareAtoms(int a1, int a2) {
        int t;
        int q;
        if (!this.isComparingNeeded) {
            return true;
        }
        if (this.mode == 0) {
            return true;
        }
        if (this.dirtyPrefixes || this.dirtyQuery || this.dirtyTarget) {
            this.initialiseSgroups();
            this.dirtyPrefixes = false;
            this.dirtyQuery = false;
            this.dirtyTarget = false;
        }
        if ((q = this.getOrigQueryAtom(a1)) < 0) {
            q = this.getOrigQueryNeighbour(a1);
        }
        if ((t = this.getOrigTargetAtom(a2)) < 0) {
            t = this.getOrigTargetNeighbour(a2);
        }
        return DataSgroupComparator.isMatching(this.qDataSgroupsForAtoms.get(q), this.tDataSgroupsForAtoms.get(t), this.qComparedDataSgroups, this.tComparedDataSgroups, this.mode, this.foundQuerySgroupInTarget);
    }

    private static boolean isMatching(ArrayList<Integer> qsg, ArrayList<Integer> tsg, ArrayList<DataSgroup> qdg, ArrayList<DataSgroup> tdg, int compareMode, boolean[] queryExistsInTarget) {
        int j;
        boolean match;
        int i;
        boolean compareWholeLists = qsg == null || tsg == null;
        int qsize = compareWholeLists ? qdg.size() : qsg.size();
        int tsize = compareWholeLists ? tdg.size() : tsg.size();
        ArrayList<Integer> matchedTarget = new ArrayList<Integer>();
        for (i = 0; i < qsize; ++i) {
            if (!compareWholeLists && !queryExistsInTarget[i]) {
                return false;
            }
            match = false;
            for (j = 0; j < tsize; ++j) {
                if (!(compareWholeLists ? DataSgroupComparator.checkMatch(qdg.get(i), tdg.get(j), compareMode) : DataSgroupComparator.checkMatch(qdg.get(qsg.get(i)), tdg.get(tsg.get(j)), compareMode))) continue;
                matchedTarget.add(j);
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        if (compareMode == 1) {
            return true;
        }
        for (i = 0; i < tsize; ++i) {
            if (matchedTarget.contains(i)) continue;
            match = false;
            for (j = 0; j < qsize; ++j) {
                if (!(compareWholeLists ? DataSgroupComparator.checkMatch(qdg.get(j), tdg.get(i), compareMode) : DataSgroupComparator.checkMatch(qdg.get(qsg.get(j)), tdg.get(tsg.get(i)), compareMode))) continue;
                matchedTarget.add(j);
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    private static boolean checkMatch(DataSgroup q, DataSgroup t, int compareMode) {
        if (!q.getFieldName().equalsIgnoreCase(t.getFieldName())) {
            return false;
        }
        String qdata = q.getData();
        String tdata = t.getData();
        String qop = q.getQueryOp();
        String top = t.getQueryOp();
        qop = qop == null || qop.equals("") ? "=" : qop;
        top = top == null || top.equals("") ? "=" : top;
        switch (compareMode) {
            case 2: {
                return (qdata == null ? tdata == null : tdata != null && qdata.equalsIgnoreCase(tdata)) && (qop == null ? top == null : top != null && qop.equalsIgnoreCase(top));
            }
            case 1: {
                if (qop == null || qop.equalsIgnoreCase("=")) {
                    return qdata.equalsIgnoreCase(tdata);
                }
                if (qop.equalsIgnoreCase("contains")) {
                    return tdata.contains(qdata);
                }
                if (qop.equalsIgnoreCase("like")) {
                    return Pattern.matches(DataSgroupComparator.likeConversion(qdata), tdata);
                }
                if (qop.equalsIgnoreCase("between")) {
                    double td;
                    double qd2;
                    double qd1;
                    String[] qd = qdata.trim().split("\\s");
                    try {
                        qd1 = Double.parseDouble(qd[0]);
                        qd2 = Double.parseDouble(qd[1]);
                        td = Double.parseDouble(tdata.trim());
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return qd1 <= td && qd2 >= td;
                }
                double qd = 0.0;
                double td = 0.0;
                try {
                    qd = Double.parseDouble(qdata.trim());
                    td = Double.parseDouble(tdata.trim());
                }
                catch (Exception e) {
                    return false;
                }
                if (qop.equalsIgnoreCase("<")) {
                    return td < qd;
                }
                if (qop.equalsIgnoreCase(">")) {
                    return td > qd;
                }
                if (qop.equalsIgnoreCase("<=")) {
                    return td <= qd;
                }
                if (qop.equalsIgnoreCase(">=")) {
                    return td >= qd;
                }
                if (!qop.equalsIgnoreCase("<>")) break;
                return Math.abs(qd - td) > 1.0E-18;
            }
        }
        return false;
    }

    private void initialiseSgroups() {
        int j;
        int i;
        this.isComparingNeeded = true;
        int qac = this.query.getAtomCount();
        int tac = this.target.getAtomCount();
        if (this.dirtyPrefixes || this.dirtyQuery) {
            this.qComparedDataSgroups = new ArrayList();
            this.qDataSgroupsForAtoms = new ArrayList();
            this.initArrayArrayList(qac, this.qDataSgroupsForAtoms);
            this.sgqno = this.collectSgroupsToCompare(this.query, this.qComparedDataSgroups);
            for (i = 0; i < this.qComparedDataSgroups.size(); ++i) {
                for (j = 0; j < qac; ++j) {
                    if (!this.qComparedDataSgroups.get(i).hasAtom(this.query.getAtom(j))) continue;
                    this.qDataSgroupsForAtoms.get(j).add(i);
                }
            }
        }
        if (this.dirtyPrefixes || this.dirtyTarget) {
            this.tComparedDataSgroups = new ArrayList();
            this.tDataSgroupsForAtoms = new ArrayList();
            this.initArrayArrayList(tac, this.tDataSgroupsForAtoms);
            this.sgtno = this.collectSgroupsToCompare(this.target, this.tComparedDataSgroups);
            for (i = 0; i < this.tComparedDataSgroups.size(); ++i) {
                for (j = 0; j < tac; ++j) {
                    if (!this.tComparedDataSgroups.get(i).hasAtom(this.target.getAtom(j))) continue;
                    this.tDataSgroupsForAtoms.get(j).add(i);
                }
            }
        }
        if (this.sgqno == 0 && this.sgtno == 0) {
            this.isComparingNeeded = false;
            return;
        }
        this.foundQuerySgroupInTarget = new boolean[this.sgqno];
        block4: for (i = 0; i < this.sgqno; ++i) {
            for (j = 0; j < this.sgtno; ++j) {
                if (!this.qComparedDataSgroups.get(i).getFieldName().equalsIgnoreCase(this.tComparedDataSgroups.get(j).getFieldName())) continue;
                this.foundQuerySgroupInTarget[i] = true;
                continue block4;
            }
        }
    }

    private int collectSgroupsToCompare(Molecule mol, ArrayList<DataSgroup> al) {
        int counter = 0;
        int sgc = mol.getSgroupCount();
        for (int i = 0; i < sgc; ++i) {
            Sgroup sg = mol.getSgroup(i);
            if (sg.getType() != 10 || !this.isPrefixOK(((DataSgroup)sg).getFieldName())) continue;
            al.add((DataSgroup)sg);
            ++counter;
        }
        return counter;
    }

    private void initArrayArrayList(int n, ArrayList<ArrayList<Integer>> aal) {
        for (int i = 0; i < n; ++i) {
            aal.add(new ArrayList());
        }
    }

    private boolean isPrefixOK(String fieldName) {
        if (this.prefixesToCheck == null) {
            return true;
        }
        for (int i = 0; i < this.prefixesToCheck.length; ++i) {
            if (!(this.exactNameMatching ? fieldName.toLowerCase().equals(this.prefixesToCheck[i].toLowerCase()) : fieldName.toLowerCase().startsWith(this.prefixesToCheck[i].toLowerCase()))) continue;
            return true;
        }
        return false;
    }

    private static String likeConversion(String in) {
        String ret = DataSgroupComparator.escape(in);
        if (!ret.startsWith("%")) {
            ret = "^" + ret;
        }
        if (!ret.endsWith("%")) {
            ret = ret + "$";
        }
        return ret.replace("%", ".*").replace("_", ".");
    }

    private static String escape(String in) {
        for (int i = 0; i < escapedChars.length; ++i) {
            in = DataSgroupComparator.escape0(in, escapedChars[i]);
        }
        return in;
    }

    private static String escape0(String in, char what) {
        int where = in.indexOf(what);
        if (where >= 0) {
            return in.substring(0, where) + "\\" + what + DataSgroupComparator.escape0(in.substring(where + 1), what);
        }
        return in;
    }
}

