/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.BondClassifier;
import chemaxon.core.calculations.RingClassifier;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.homology.HomologyRingClassifier;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.sss.search.MarkushSGSearch;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.StructureSearch;
import chemaxon.sss.search.homology.HomologyMatcher;
import chemaxon.sss.search.options.HomologyTranslationOption;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HomologySGSearch
extends MarkushSGSearch {
    private RingClassifier ringClassifier = null;
    protected int[] ringBondCount;
    public HomologyRingClassifier homologyRingClassifier = null;
    protected HomologyMatcher[] homologyMatchers = null;
    private StructureSearch other;
    protected int[] implHCountQ = null;
    private HomologySGSearch homologySub = null;
    private int[] otherHomologyType;
    private int[] homologyType;
    private int[] homologyMAtomIndexes;
    private static final int HOMOLOGY_TYPE_NON_INIT = -2;
    private static final Logger logger = Logger.getLogger(HomologySGSearch.class.getName());

    public HomologySGSearch(boolean isQuery) {
        this.isQueryHomologyMode = isQuery;
    }

    public HomologySGSearch() {
    }

    @Override
    protected void createSub(Molecule query) {
        if (HomologyConstants.containsHomology(query) && this.searchOptions.getHomologyNarrowTranslation() == HomologyTranslationOption.ALL) {
            logger.fine("Query side searcher created.");
            this.homologySub = new HomologySGSearch();
            this.sub = this.homologySub;
            this.homologySub.setOther(this);
            this.isAllowedForQHomology();
        } else {
            this.homologySub = null;
            super.createSub(query);
        }
        this.setOther(this.sub);
    }

    @Override
    protected void createHomologyMatchers() {
        if (!this._IAmTheQuery && this.sub instanceof HomologySGSearch) {
            logger.fine("Creating query-side matchers:");
            this.homologySub.createHomologyMatchers();
            this.isAllowedForQHomology();
            logger.fine("Creating target-side matchers:");
        }
        this.homologyMatchers = new HomologyMatcher[this.atomIdxInAtomsArrayLength];
        IntVector homologyAtomIndexesVector = new IntVector();
        for (int i = 0; i < this.atomsLength; ++i) {
            if (!(this.idxAtomInMatomArray[i] >= 0 & this.atoms[i].isPseudo())) continue;
            int hgIndex = this.idxAtomInMatomArray[i];
            this.homologyMatchers[hgIndex] = HomologyMatcher.createMatcher(this.atoms[i], hgIndex, this);
            if (this.homologyMatchers[hgIndex] == null) continue;
            logger.fine("Matcher created for atom: " + i);
            this.homologyMatchers[hgIndex].setCompleteHG(this.searchOptions.getCompleteHG() || this._IAmTheQuery);
            homologyAtomIndexesVector.add(hgIndex);
        }
        this.homologyMAtomIndexes = homologyAtomIndexesVector.toArray();
        this.uninitializeHSGS();
    }

    private void uninitializeHSGS() {
        this.homologyRingClassifier = new HomologyRingClassifier(this.other.molecule);
        this.ringClassifier = null;
        this.implHCountQ = null;
        this.ringBondCount = null;
        this.homologyType = null;
        this.otherHomologyType = null;
    }

    private void isAllowedForQHomology() {
        boolean checkConvertedHomologies;
        boolean bl = checkConvertedHomologies = this.searchOptions.getHomologyBroadTranslation() == HomologyTranslationOption.ALL;
        if (this.molecule instanceof Supergraph && this.searchOptions.getHomologyNarrowTranslation() == HomologyTranslationOption.ALL && ((Supergraph)this.molecule).hasExpandedMarkushFeature(checkConvertedHomologies)) {
            throw new IllegalArgumentException("Query side homology is not allowed with markush targets, if narrow translation is allowed.");
        }
    }

    private void setOther(StructureSearch searcher) {
        this.other = searcher;
    }

    @Override
    protected boolean compareAtomTypes(int queryAtom, int targetAtom) {
        boolean isTHom = this.isHomologyAtom(targetAtom);
        boolean isQHom = this.isOtherAtomHomology(queryAtom);
        if (!isTHom && !isQHom) {
            return super.compareAtomTypes(queryAtom, targetAtom);
        }
        if (this.searchOptions.isExactQueryAtomMatching()) {
            return super.compareAtomTypes(queryAtom, targetAtom);
        }
        switch (this.sub.matom[queryAtom]) {
            case 128: {
                return super.compareAtomTypes(queryAtom, targetAtom);
            }
            case 129: {
                return super.compareAtomTypes(queryAtom, targetAtom);
            }
            case 134: {
                return true;
            }
            case 136: {
                if (!isQHom) {
                    if (this.isSpecialPseudoMatchingOnHomology(queryAtom, targetAtom)) {
                        return true;
                    }
                    return super.compareAtomTypes(queryAtom, targetAtom);
                }
                int origIdx = this.atomIdxInAtomsArray[targetAtom];
                return this.homologySub.homologyMatchers[queryAtom].isInitialAtom(this.matom[targetAtom], targetAtom, origIdx >= 0 ? this.atoms[origIdx] : null);
            }
        }
        if (this.sub.matom[queryAtom] != this.matom[targetAtom]) {
            if (isTHom) {
                if (!this.homologyMatchers[targetAtom].isInitialAtom(this.sub.matom[queryAtom], queryAtom, null)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isSpecialPseudoMatchingOnHomology(int queryAtom, int targetAtom) {
        boolean isTNotPseudo;
        boolean isQNotPseudo;
        int qmi = this.sub.atomIdxInAtomsArray[queryAtom];
        boolean bl = isQNotPseudo = qmi == -1 || this.sub.atoms[qmi] == null || !this.sub.atoms[qmi].isPseudo();
        if (isQNotPseudo) {
            return false;
        }
        String qAlias = this.sub.atoms[qmi].getAliasstr().toUpperCase();
        int tmi = this.atomIdxInAtomsArray[targetAtom];
        boolean bl2 = isTNotPseudo = tmi == -1 || this.atoms[tmi] == null || !this.atoms[tmi].isPseudo();
        if (isTNotPseudo) {
            return false;
        }
        String tAlias = this.atoms[tmi].getAliasstr().toUpperCase();
        return qAlias.equalsIgnoreCase("M") && HomologyConstants.isMetallicHomology(tAlias);
    }

    @Override
    protected boolean compareAtoms(int queryAtom, int targetAtom) throws SearchException {
        boolean isQHomology;
        int tHomologyIndex = this.getCachedHomologyType(targetAtom, false);
        int qHomologyIndex = this.getCachedHomologyType(queryAtom, true);
        boolean isTHomology = tHomologyIndex != -1;
        boolean bl = isQHomology = qHomologyIndex != -1;
        if (!isTHomology && !isQHomology) {
            return super.compareAtoms(queryAtom, targetAtom);
        }
        if (isTHomology && isQHomology && HomologyMatcher.areHomologyTypeIndexesMatching(this.searchOptions.getHomologyBroadTranslation(), this.searchOptions.getHomologyNarrowTranslation(), tHomologyIndex, qHomologyIndex)) {
            return true;
        }
        if (this.searchOptions.getHomologyBroadTranslation() != HomologyTranslationOption.ALL && isTHomology || this.searchOptions.getHomologyNarrowTranslation() != HomologyTranslationOption.ALL && isQHomology) {
            return false;
        }
        if (!this.compareAtomTypes(queryAtom, targetAtom)) {
            return false;
        }
        return this.compareAromaticity(queryAtom, targetAtom);
    }

    public int getCachedHomologyType(int matomIndex, boolean otherSearcher) {
        if (otherSearcher) {
            if (this.otherHomologyType == null) {
                this.otherHomologyType = new int[this.other.matomLength];
                Arrays.fill(this.otherHomologyType, -2);
            }
            if (this.otherHomologyType[matomIndex] == -2) {
                this.otherHomologyType[matomIndex] = this.calculateHomologyType(matomIndex, otherSearcher);
            }
            return this.otherHomologyType[matomIndex];
        }
        if (this.homologyType == null) {
            this.homologyType = new int[this.matomLength];
            Arrays.fill(this.homologyType, -2);
        }
        if (this.homologyType[matomIndex] == -2) {
            this.homologyType[matomIndex] = this.calculateHomologyType(matomIndex, otherSearcher);
        }
        return this.homologyType[matomIndex];
    }

    private int calculateHomologyType(int matomIndex, boolean otherSearcher) {
        int atomIndex;
        StructureSearch searcher;
        StructureSearch structureSearch = searcher = otherSearcher ? this.other : this;
        if (searcher instanceof HomologySGSearch) {
            StructureSearch HSGSsearcher = searcher;
            HomologyMatcher matcher = HSGSsearcher.homologyMatchers[matomIndex];
            if (matcher != null) {
                return matcher.getHomologyType();
            }
        }
        if (searcher.matom[matomIndex] == 136 && (atomIndex = searcher.atomIdxInAtomsArray[matomIndex]) >= 0) {
            return HomologyConstants.getHomologyTypeIndex(searcher.atoms[atomIndex].getAliasstr());
        }
        return -1;
    }

    @Override
    protected boolean compareAromaticity(int queryAtom, int targetAtom) {
        if (!this.isHomologyAtom(targetAtom) && !this.isOtherAtomHomology(queryAtom)) {
            return super.compareAromaticity(queryAtom, targetAtom);
        }
        return true;
    }

    public int countRingBonds(int othersAtom) {
        this.initRingClassifier();
        if (this.ringBondCount[othersAtom] == -1) {
            this.ringBondCount[othersAtom] = 0;
            int atomidx = this.other.atomIdxInAtomsArray[othersAtom];
            if (atomidx >= 0) {
                for (int l2 = 0; l2 < this.other.abonds[othersAtom]; ++l2) {
                    int neighidx = this.other.atomIdxInAtomsArray[this.other.bto[this.other.bondidx[othersAtom] + l2]];
                    if (neighidx < 0 || !this.ringClassifier.isRingBond(atomidx, neighidx)) continue;
                    int n = othersAtom;
                    this.ringBondCount[n] = this.ringBondCount[n] + 1;
                }
            }
        }
        return this.ringBondCount[othersAtom];
    }

    private void initRingClassifier() {
        if (this.ringClassifier == null) {
            this.ringClassifier = new BondClassifier();
            if (this.polymerSU != null) {
                // empty if block
            }
            this.ringClassifier.classify(this.other.molecule);
            this.ringBondCount = ArrayTools.initArrayAndFill(this.ringBondCount, this.other.matomLength, -1);
        }
    }

    public boolean isRingBond(int atom1, int atom2) {
        this.initRingClassifier();
        int atomidx1 = this.other.atomIdxInAtomsArray[atom1];
        int atomidx2 = this.other.atomIdxInAtomsArray[atom2];
        if (atomidx1 >= 0 && atomidx2 >= 0) {
            return this.ringClassifier.isRingBond(atomidx1, atomidx2);
        }
        return false;
    }

    @Override
    protected boolean compareHydrogens(int queryAtom, int targetAtom) {
        if (this.isHomologyAtom(targetAtom) || this.isOtherAtomHomology(queryAtom)) {
            return true;
        }
        return super.compareHydrogens(queryAtom, targetAtom);
    }

    @Override
    protected boolean compareChiralities(int q, int t) {
        if (!this.isHomologyAtom(t)) {
            super.compareChiralities(q, t);
        }
        return true;
    }

    @Override
    protected boolean canSkipCTChecking(int ta1, int ta2, int ta3, int ta4) {
        return this.isHomologyAtom(ta2) || this.isHomologyAtom(ta3);
    }

    @Override
    protected boolean statCheck() {
        return true;
    }

    @Override
    protected int getMatchingQuery(int[] hit, int t) {
        if (this.homologySub == null) {
            return super.getMatchingQuery(hit, t);
        }
        for (int q = 0; q < this.qryAtoms; ++q) {
            if (!this.map.getMap(q, t)) continue;
            return q;
        }
        return -1;
    }

    @Override
    protected boolean testNode(int i, int j) throws SearchException {
        boolean mapHasChanged = false;
        if (this.isOtherAtomHomology(i) && !this.isHomologyAtom(j)) {
            return false;
        }
        if (!this.isHomologyAtom(j)) {
            return super.testNode(i, j);
        }
        int qi = this.sub.bondidx[i];
        int si = this.bondidx[j];
        int hashCode = this.abonds[j] < 16 ? this.sub.abonds[i] * 16 + this.abonds[j] : -1;
        switch (hashCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
            case 17: {
                if (this.areCompatibleBondsAndMapped(qi, si) || this.map.getMap(this.sub.bto[qi], j)) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            case 18: {
                if (this.areCompatibleBondsAndMapped(qi, si) || this.areCompatibleBondsAndMapped(qi, si + 1) || this.map.getMap(this.sub.bto[qi], j)) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            case 19: {
                if (this.areCompatibleBondsAndMapped(qi, si) || this.areCompatibleBondsAndMapped(qi, si + 1) || this.areCompatibleBondsAndMapped(qi, si + 2) || this.map.getMap(this.sub.bto[qi], j)) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            case 20: {
                if (this.areCompatibleBondsAndMapped(qi, si) || this.areCompatibleBondsAndMapped(qi, si + 1) || this.areCompatibleBondsAndMapped(qi, si + 2) || this.areCompatibleBondsAndMapped(qi, si + 3) || this.map.getMap(this.sub.bto[qi], j)) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            case 34: {
                if (this.areCompatibleBondsAndMapped(qi, si) && this.areCompatibleBondsAndMapped(qi + 1, si + 1) && this.areCompatibleAtoms(this.bto[si], this.bto[si + 1]) || this.areCompatibleBondsAndMapped(qi, si + 1) && this.areCompatibleBondsAndMapped(qi + 1, si) && this.areCompatibleAtoms(this.bto[si], this.bto[si + 1]) || this.map.getMap(this.sub.bto[qi], j) && (this.areCompatibleBondsAndMapped(qi + 1, si) || this.areCompatibleBondsAndMapped(qi + 1, si + 1)) || this.map.getMap(this.sub.bto[qi + 1], j) && (this.areCompatibleBondsAndMapped(qi, si) || this.areCompatibleBondsAndMapped(qi, si + 1) || this.map.getMap(this.sub.bto[qi], j))) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            default: {
                int dep = 0;
                boolean notFinishedBacktrack = true;
                Arrays.fill(this.sub.ind, 0);
                Arrays.fill(this.usd, 0, this.usdLength, false);
                boolean found = false;
                while (notFinishedBacktrack) {
                    if (dep < this.sub.abonds[i]) {
                        if (this.sub.ind[dep] < this.usdLength) {
                            if (this.map.getMap(this.sub.bto[qi + dep], j)) {
                                this.sub.ind[dep] = this.usdLength;
                                found = true;
                            } else {
                                found = false;
                                while (!found && this.sub.ind[dep] < this.abonds[j]) {
                                    found = !this.usd[this.sub.ind[dep]] && this.areCompatibleBondsAndMapped(qi + dep, si + this.sub.ind[dep]) && this.isCompatibleWithTheRest(dep, si, this.bto[si + this.sub.ind[dep]]);
                                    int n = dep;
                                    this.sub.ind[n] = this.sub.ind[n] + 1;
                                }
                            }
                        }
                        if (found) {
                            int n = dep;
                            this.sub.ind[n] = this.sub.ind[n] - 1;
                            this.usd[this.sub.ind[dep]] = true;
                            ++dep;
                            continue;
                        }
                        this.sub.ind[dep] = 0;
                        if (--dep >= 0) {
                            this.usd[this.sub.ind[dep]] = false;
                            int n = dep;
                            this.sub.ind[n] = this.sub.ind[n] + 1;
                            continue;
                        }
                        this.map.clearMap(i, j);
                        mapHasChanged = true;
                        notFinishedBacktrack = false;
                        continue;
                    }
                    notFinishedBacktrack = false;
                }
                break block0;
            }
        }
        if (!this.map.getMap(i, j)) {
            this.homologyMatchers[j].prohibitMatching(i);
        }
        return mapHasChanged;
    }

    final boolean isHomologyAtom(int i) {
        if (i >= this.homologyMatchers.length || i < 0) {
            return false;
        }
        return this.homologyMatchers[i] != null;
    }

    @Override
    protected void clearRowColumn(int qAtom, int tAtom) {
        boolean targetHg = this.isHomologyAtom(tAtom);
        boolean queryHg = this.isOtherAtomHomology(qAtom);
        if (!queryHg) {
            this.map.clearRowExcept(qAtom, tAtom);
        }
        if (!targetHg) {
            this.map.clearColumnExcept(qAtom, tAtom);
        }
    }

    @Override
    protected boolean isCompatibleWithTheRest(int dep, int si, int newAtom) {
        for (int i = 0; i < dep; ++i) {
            int oldAtom;
            if (this.sub.ind[i] >= this.usdLength - 1 || this.areCompatibleAtoms(oldAtom = this.bto[si + this.sub.ind[i]], newAtom)) continue;
            return false;
        }
        return true;
    }

    private boolean isCompatibleWithTheRest2(int dep, int[] bInd) {
        int newAtom = this.bto[bInd[this.sub.ind[dep]]];
        for (int i = 0; i < dep; ++i) {
            int oldAtom;
            if (this.sub.ind[i] >= this.usdLength - 1 || this.areCompatibleAtoms(oldAtom = this.bto[bInd[this.sub.ind[i]]], newAtom)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void initHomology() {
        logger.fine("Initializing matchers.");
        for (int h : this.homologyMAtomIndexes) {
            this.homologyMatchers[h].buildUpStructures();
        }
        if (this.homologySub != null) {
            this.homologySub.initHomology();
        }
    }

    @Override
    protected void addToHit(int q, int t) {
        super.addToHit(q, t);
        this.updateHomologyMatcherMaps(q, t);
        if (this.homologySub != null) {
            this.homologySub.updateHomologyMatcherMaps(t, q);
            this.refineNeighboursMap(q, t);
        }
    }

    @Override
    protected boolean refineForHomologies() throws SearchException {
        boolean mapHasChanged = false;
        if (!this.checkMapOfMatched()) {
            return mapHasChanged;
        }
        if (this.homologySub == null) {
            return mapHasChanged;
        }
        this.foundZeroLineInMap = false;
        for (int i = 0; i < this.homologySub.homologyMatchers.length; ++i) {
            HomologyMatcher qHgMatcher = this.homologySub.homologyMatchers[i];
            if (qHgMatcher == null || this.depth <= this.getMaxNeighbour(i, true)) continue;
            for (int c = 0; c < qHgMatcher.getNumberOfCriticalParts(); ++c) {
                int[][] borderNeigh = qHgMatcher.getPossibleBorderAtoms(c);
                if (borderNeigh == null || borderNeigh[0].length > 0 && this.isHomologyAtom(borderNeigh[0][0])) continue;
                if (this.sub.abonds[i] > borderNeigh[0].length || !this.isSubstCountOK(i, -1, borderNeigh[0].length)) {
                    qHgMatcher.prohibitMatching(qHgMatcher.getCriticalAtom(c, 0));
                    mapHasChanged = true;
                    continue;
                }
                int[] bInd = new int[borderNeigh[0].length];
                block2: for (int b = 0; b < bInd.length; ++b) {
                    int[] neighBours = this.getNeighbours(borderNeigh[0][b], false);
                    for (int j = 0; j < neighBours.length; ++j) {
                        if (neighBours[j] != borderNeigh[1][b]) continue;
                        bInd[b] = this.bondidx[borderNeigh[0][b]] + j;
                        continue block2;
                    }
                }
                int dep = 0;
                boolean notFinishedBacktrack = true;
                int extBondNum = bInd.length;
                if (this.ind.length < extBondNum) {
                    this.initBacktrackArrays(extBondNum);
                }
                Arrays.fill(this.sub.ind, 0);
                Arrays.fill(this.usd, 0, this.usdLength, false);
                boolean found = false;
                int qi = this.sub.bondidx[i];
                while (notFinishedBacktrack) {
                    if (dep < this.sub.abonds[i]) {
                        found = false;
                        while (!found && this.sub.ind[dep] < borderNeigh[0].length) {
                            found = !this.usd[this.sub.ind[dep]] && this.areCompatibleBondsAndMapped(qi + dep, bInd[this.sub.ind[dep]]) && this.isCompatibleWithTheRest2(dep, bInd);
                            int n = dep;
                            this.sub.ind[n] = this.sub.ind[n] + 1;
                        }
                        if (found) {
                            int n = dep;
                            this.sub.ind[n] = this.sub.ind[n] - 1;
                            this.usd[this.sub.ind[dep]] = true;
                            ++dep;
                            continue;
                        }
                        this.sub.ind[dep] = 0;
                        if (--dep >= 0) {
                            this.usd[this.sub.ind[dep]] = false;
                            int n = dep;
                            this.sub.ind[n] = this.sub.ind[n] + 1;
                            continue;
                        }
                        qHgMatcher.prohibitMatching(qHgMatcher.getCriticalAtom(c, 0));
                        mapHasChanged = true;
                        notFinishedBacktrack = false;
                        continue;
                    }
                    notFinishedBacktrack = false;
                }
            }
            this.foundZeroLineInMap |= this.checkZeroLine(i);
            if (!this.foundZeroLineInMap || !this.isZeroLineProhibited) continue;
            mapHasChanged = false;
            return mapHasChanged;
        }
        return mapHasChanged;
    }

    protected boolean checkMapOfMatched() {
        for (int i = 0; i < this.depth; ++i) {
            if (this.map.getMap(i, this.idx[i] - 1)) continue;
            this.foundZeroLineInMap = true;
            return false;
        }
        return true;
    }

    @Override
    protected void clearAmbiguousHits() {
        if (this.homologySub == null) {
            return;
        }
        IntVector ambigHom = new IntVector();
        block0: for (int i = 0; i < this.qryAtoms; ++i) {
            int[] neighbV;
            if (!this.homologySub.isHomologyAtom(i)) continue;
            for (int neigh : neighbV = this.getNeighbours(i, true)) {
                if (!this.homologySub.isHomologyAtom(neigh)) continue;
                ambigHom.add(i);
                continue block0;
            }
        }
        if (ambigHom.size() == 0) {
            return;
        }
        int[] ambigHomV = ambigHom.toArray();
        for (int t = 0; t < this.strAtoms; ++t) {
            if (this.isHomologyAtom(t)) continue;
            int firstQInd = -1;
            for (int q : ambigHomV) {
                if (!this.map.getMap(q, t)) continue;
                if (firstQInd == -1) {
                    firstQInd = q;
                    continue;
                }
                this.homologySub.homologyMatchers[q].prohibitMatching(t);
            }
        }
    }

    private boolean checkZeroLine(int i) {
        logger.finest("Checking Zero line for atom:" + i);
        if (this.homologySub != null && this.homologySub.isHomologyAtom(i) && i < this.depth && !this.map.getMap(i, this.idx[i] - 1)) {
            return true;
        }
        for (int j = 0; j < this.strAtoms; ++j) {
            if (!this.map.getMap(i, j)) continue;
            return false;
        }
        return true;
    }

    private void refineNeighboursMap(int q, int t) {
        if (this.homologySub == null && !this.isHomologyAtom(t)) {
            return;
        }
        if (this.isHomologyAtom(t)) {
            return;
        }
        int[] qNeighbours = this.getNeighbours(q, true);
        int[] tNeighbours = this.getNeighbours(t, false);
        for (int i = 0; i < this.homologySub.matomLength; ++i) {
            if (i == q || !this.homologySub.isHomologyAtom(i) || ArrayTools.foundInArray(qNeighbours, i)) continue;
            for (int tNeigh : tNeighbours) {
                this.homologySub.homologyMatchers[i].prohibitMatching(tNeigh);
            }
        }
    }

    private void updateHomologyMatcherMaps(int matchingInd, int hgSideInd) {
        for (int h : this.homologyMAtomIndexes) {
            if (!this.getMapToHomology(matchingInd, h)) continue;
            if (h == hgSideInd) {
                this.homologyMatchers[h].add(matchingInd);
                continue;
            }
            this.homologyMatchers[h].prohibitMatching(matchingInd);
        }
    }

    @Override
    protected void removeFromHit(int q, int t, boolean afterHit) {
        super.removeFromHit(q, t, afterHit);
        if (this.isHomologyAtom(t)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Removing from hit: " + q + "  homology:" + t);
            }
            this.homologyMatchers[t].removeFromHit(q);
        }
        if (this.homologySub != null && this.homologySub.isHomologyAtom(q)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Removing from hit: homology:" + q + "  " + t);
            }
            this.homologySub.homologyMatchers[q].removeFromHit(t);
            this.homologySub.homologyMatchers[q].prohibitMatching(t);
            if (afterHit && this.lastIdxAt2DHit != null) {
                for (int i : this.lastIdxAt2DHit[q]) {
                    this.homologySub.homologyMatchers[q].prohibitMatching(i);
                }
            }
            this.pushMap(this.depth);
        }
    }

    @Override
    protected boolean isValidHit(SearchHit hit) throws SearchException {
        int[][] hit2D = hit.getGroupHit();
        if (this.homologySub != null && this.hits.size() > 0) {
            for (SearchHit prevHit : this.hits) {
                int[][] prev2DHit = prevHit.getGroupHit();
                boolean isSubsetOfPrev = true;
                for (int q = 0; q < hit2D.length; ++q) {
                    int[] atomhit;
                    int[] arr$ = atomhit = hit2D[q];
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        int[] prevAtomHit = prev2DHit[q];
                        int t = arr$[i$];
                        if (ArrayTools.foundInArray(prevAtomHit, t)) continue;
                        isSubsetOfPrev = false;
                        break;
                    }
                    if (!isSubsetOfPrev) break;
                }
                if (!isSubsetOfPrev) continue;
                return false;
            }
        }
        return super.isValidHit(hit);
    }

    @Override
    protected boolean isValidFullFragmentHit(int[] hit) {
        if (!this.searchOptions.isFullFragment()) {
            return true;
        }
        int[] singleHDef = this.getSingleHDefMatomIndexes(hit);
        for (int i = 0; i < this.matomLength; ++i) {
            int[] neighBV;
            int q;
            int origAtomIdx = this.atomIdxInAtomsArray[i];
            if (origAtomIdx < 0 || this.matom[i] == 1 || (q = this.getMatchingQuery(hit, i)) == -1 || !this.isHomologyAtom(i) && (this.homologySub == null || !this.homologySub.isHomologyAtom(q))) continue;
            for (int n : neighBV = this.getNeighbours(i, false)) {
                int origAtomIdxN = this.atomIdxInAtomsArray[n];
                if (origAtomIdxN < 0 || this.matom[n] == 1 || !this.isCompatibleWithAll(origAtomIdxN, singleHDef) || this.getMatchingQuery(hit, n) != -1 || !this.isCompatibleWithAll(origAtomIdxN, hit)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isValidHitInner(SearchHit hit) throws SearchException {
        if (!this.isValidFullFragmentHit(hit.getSingleHit())) {
            logger.fine("isValidFullFragmentHit() fails");
            return false;
        }
        for (HomologyMatcher m : this.homologyMatchers) {
            if (m == null || m.finalCheck()) continue;
            return false;
        }
        if (this.homologySub != null) {
            for (HomologyMatcher m : this.homologySub.homologyMatchers) {
                if (m == null || m.finalCheck()) continue;
                return false;
            }
        }
        return super.isValidHitInner(hit);
    }

    public boolean isQuerySide() {
        return this._IAmTheQuery;
    }

    public int getBondCount(int atomIdx, boolean otherSide) {
        StructureSearch searcher = otherSide ? this.other : this;
        return searcher.abonds[atomIdx];
    }

    public int getMarkushBondCount(int matomIdx) {
        int atomIdx = this.atomIdxInAtomsArray[matomIdx];
        int markushAtomIdx = this.sg.getHomologyConvertedIndex(atomIdx);
        MolAtom atom = this.markushDiagram.getAtom(markushAtomIdx);
        return MolImportUtil.countBondsAndAttachments(atom) - atom.getExplicitHcount();
    }

    public int getAtomCount(boolean otherSide) {
        StructureSearch searcher = otherSide ? this.other : this;
        return searcher.matomLength;
    }

    public int getAtomCountMatched() {
        return this.other.matomLength;
    }

    public boolean isOtherAtomHomology(int i) {
        return this.other instanceof HomologySGSearch && ((HomologySGSearch)this.other).isHomologyAtom(i);
    }

    public int getRingIndex(int i) {
        int origAtomIdx = this.other.atomIdxInAtomsArray[i];
        return origAtomIdx < 0 ? -1 : this.homologyRingClassifier.getRingIndex(origAtomIdx);
    }

    public int[] getRing(int ringIndex) {
        int[] atomIdx = this.homologyRingClassifier.getRing(ringIndex);
        IntVector matomV = new IntVector();
        for (int i = 0; i < atomIdx.length; ++i) {
            int matomIdx = this.other.idxAtomInMatomArray[atomIdx[i]];
            if (matomIdx < 0) continue;
            matomV.add(matomIdx);
        }
        return matomV.toArray();
    }

    public int getImplHCountQ(int matomIdx) {
        if (this.implHCountQ == null) {
            this.implHCountQ = ArrayTools.initArray(this.implHCountQ, this.getAtomCountMatched(), -1);
        }
        if (this.implHCountQ[matomIdx] == -1) {
            int origAtomIdx = this.other.atomIdxInAtomsArray[matomIdx];
            this.implHCountQ[matomIdx] = origAtomIdx < 0 ? 0 : this.other.atoms[origAtomIdx].getImplicitHcount();
        }
        return this.implHCountQ[matomIdx];
    }

    public int getBTypeBetweenAtomsMatched(int fro, int to) {
        int bondOffset;
        int bondNum = this.other.abonds[fro];
        for (int b = bondOffset = this.other.bondidx[fro]; b < bondOffset + bondNum; ++b) {
            if (this.other.bto[b] != to) continue;
            return this.other.btyp[b];
        }
        return -1;
    }

    public int getAtomTypeMatched(int q, boolean otherSide) {
        StructureSearch searcher = otherSide ? this.other : this;
        return searcher.matom[q];
    }

    public int getIsotopeMatched(int q, boolean otherSide) {
        StructureSearch searcher;
        StructureSearch structureSearch = searcher = otherSide ? this.other : this;
        if (searcher.isotope == null) {
            return 0;
        }
        return searcher.isotope[q];
    }

    public int getBondType(int atomIdx, int bIdx, boolean otherSide) {
        StructureSearch searcher = otherSide ? this.other : this;
        int bondOffset = searcher.bondidx[atomIdx];
        return searcher.btyp[bondOffset + bIdx];
    }

    public int getNeighAtomMatched(int atomIdx, int bIdx) {
        int bondOffset = this.other.bondidx[atomIdx];
        return this.other.bto[bondOffset + bIdx];
    }

    public int[] getNeighbours(int a, boolean otherSide) {
        int bondOffset;
        StructureSearch searcher = otherSide ? this.other : this;
        int bondNum = searcher.abonds[a];
        int[] ret = new int[bondNum];
        for (int bondInd = bondOffset = searcher.bondidx[a]; bondInd < bondOffset + bondNum; ++bondInd) {
            ret[bondInd - bondOffset] = searcher.bto[bondInd];
        }
        return ret;
    }

    public int getMaxNeighbour(int a, boolean otherSide) {
        int[] neigh = this.getNeighbours(a, otherSide);
        if (neigh == null || neigh.length == 0) {
            return -1;
        }
        int max = neigh[0];
        for (int i : neigh) {
            max = max < i ? i : max;
        }
        return max;
    }

    public void clearMapToHomology(int otherInd, int hgInd) {
        if (this._IAmTheQuery) {
            this.other.map.clearMap(hgInd, otherInd);
        } else {
            this.map.clearMap(otherInd, hgInd);
        }
    }

    public boolean getMapToHomology(int otherInd, int hgInd) {
        if (this._IAmTheQuery) {
            return this.other.map.getMap(hgInd, otherInd);
        }
        return this.map.getMap(otherInd, hgInd);
    }

    @Override
    protected int[] getQHomologyHits(int hgInd, int firstHit) {
        if (this.homologySub == null || !this.homologySub.isHomologyAtom(hgInd)) {
            return super.getQHomologyHits(hgInd, firstHit);
        }
        IntVector mappableAtoms = new IntVector();
        for (int i = 0; i < this.strAtoms; ++i) {
            if (!this.map.getMap(hgInd, i)) continue;
            mappableAtoms.add(i);
        }
        return mappableAtoms.toArray();
    }

    public HomologyMatcher getOthersHomologyMatcher(int i) {
        if (this.isOtherAtomHomology(i)) {
            return ((HomologySGSearch)this.other).homologyMatchers[i];
        }
        return null;
    }

    public final boolean isAtomAlreadyMatched(int atomInd) {
        if (!this._IAmTheQuery) {
            return atomInd < this.depth;
        }
        for (int i = 0; i < this.depth; ++i) {
            if (this.idx[i] - 1 != atomInd) continue;
            return true;
        }
        return false;
    }

    public boolean canBeNonMapped(int currAtom) {
        return false;
    }
}

