/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.ArrayTools;
import chemaxon.sss.search.MolComparator;
import chemaxon.sss.search.StructureSearch;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import java.util.Arrays;

public class MDLComponentComparator
extends MolComparator {
    int[] qCom;
    boolean isQInitialized = false;
    int[] tCom;
    boolean isTInitialized = false;

    boolean isUseful(Molecule q, Molecule t, StructureSearch s) {
        return this.hasComponentSgroup(q) || this.hasComponentSgroup(t);
    }

    private boolean hasComponentSgroup(Molecule m) {
        int nSg = m.getSgroupCount();
        for (int i = 0; i < nSg; ++i) {
            Sgroup sg = m.getSgroup(i);
            if (sg.getType() != 13) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setQuery(Molecule q) {
        super.setQuery(q);
        this.isQInitialized = false;
    }

    @Override
    public void setTarget(Molecule t) {
        super.setTarget(t);
        this.isTInitialized = false;
    }

    final void initialize() {
        if (!this.isQInitialized) {
            this.qCom = this.initCom(this.query, this.qCom);
            this.isQInitialized = true;
        }
        if (!this.isTInitialized) {
            this.tCom = this.initCom(this.target, this.tCom);
            this.isTInitialized = true;
        }
    }

    private int[] initCom(Molecule m, int[] com) {
        int[] com1 = com;
        int na = m.getAtomCount();
        com1 = ArrayTools.initArray(com1, na);
        Arrays.fill(com1, 0, na, 0);
        int nsg = m.getSgroupCount();
        for (int j = 0; j < nsg; ++j) {
            Sgroup sg = m.getSgroup(j);
            if (sg.getType() != 13) continue;
            int c = this.getComNumber(m, sg, j);
            int sac = sg.getAtomCount();
            for (int i = 0; i < sac; ++i) {
                MolAtom atom = sg.getAtom(i);
                int idx = m.indexOf(atom);
                com1[idx] = c;
            }
        }
        return com1;
    }

    private int getComNumber(Molecule m, Sgroup sg, int sgIndex) {
        boolean isInFor = false;
        for (Sgroup parentSgroup = sg.getParentSgroup(); parentSgroup != null; parentSgroup = parentSgroup.getParentSgroup()) {
            int pType = parentSgroup.getType();
            if (pType != 9) continue;
            isInFor = true;
        }
        int cno = 0;
        if (isInFor) {
            if (sg.isOrderedComponentSgroup()) {
                String s = sg.getSubscript();
                String noString = s == null ? null : s.substring(1);
                try {
                    cno = Integer.parseInt(noString);
                }
                catch (NumberFormatException e) {
                    cno = 0;
                }
            }
        } else {
            cno = -(sgIndex + 1);
        }
        return cno;
    }

    @Override
    public boolean compareAtoms(int a1, int a2) {
        this.initialize();
        int oaq1 = this.getOrigQueryAtomOrNeighbour(a1);
        int oat1 = this.getOrigTargetAtomOrNeighbour(a2);
        if (oaq1 == -1 || oat1 == -1) {
            return true;
        }
        int cq1 = this.qCom[oaq1];
        int ct1 = this.tCom[oat1];
        return cq1 <= 0 || ct1 > 0;
    }

    private int getOrigTargetAtomOrNeighbour(int a2) {
        int oat1 = this.getOrigTargetAtom(a2);
        if (oat1 == -1) {
            oat1 = this.getOrigTargetNeighbour(a2);
        }
        return oat1;
    }

    private int getOrigQueryAtomOrNeighbour(int a1) {
        int oaq1 = this.getOrigQueryAtom(a1);
        if (oaq1 == -1) {
            oaq1 = this.getOrigQueryNeighbour(a1);
        }
        return oaq1;
    }

    @Override
    public boolean compareHit(int[] internalHit, int internalHitLength) {
        this.initialize();
        int lqii = internalHitLength - 1;
        int ltii = internalHit[internalHitLength - 1] - 1;
        int lqmi = this.getOrigQueryAtomOrNeighbour(lqii);
        int ltmi = this.getOrigTargetAtomOrNeighbour(ltii);
        if (lqmi == -1 || ltmi == -1) {
            return true;
        }
        int lqc = this.qCom[lqmi];
        int ltc = this.tCom[ltmi];
        if (lqc > 0) {
            return this.checkFORQueryMatching(lqc, ltc, internalHit, internalHitLength);
        }
        return this.checkMIXQueryMatching(lqc, ltc, internalHit, internalHitLength);
    }

    private boolean checkMIXQueryMatching(int lqc, int ltc, int[] internalHit, int internalHitLength) {
        for (int i = 0; i < internalHitLength - 1; ++i) {
            int ctii = internalHit[i] - 1;
            int cqmi = this.getOrigQueryAtomOrNeighbour(i);
            int ctmi = this.getOrigTargetAtomOrNeighbour(ctii);
            if (cqmi == -1 || ctmi == -1) continue;
            int cqc = this.qCom[cqmi];
            int ctc = this.tCom[ctmi];
            if (cqc == lqc) {
                return ctc == ltc;
            }
            if (ctc != ltc) continue;
            return false;
        }
        return true;
    }

    private boolean checkFORQueryMatching(int lqc, int ltc, int[] internalHit, int internalHitLength) {
        for (int i = 0; i < internalHitLength - 1; ++i) {
            int ctii = internalHit[i] - 1;
            int cqmi = this.getOrigQueryAtomOrNeighbour(i);
            int ctmi = this.getOrigTargetAtomOrNeighbour(ctii);
            if (cqmi == -1 || ctmi == -1) continue;
            int cqc = this.qCom[cqmi];
            int ctc = this.tCom[ctmi];
            if (cqc == lqc) {
                return ctc == ltc;
            }
            if (!(cqc <= 0 ? ctc == ltc : (cqc > lqc ? ctc <= ltc : cqc < lqc && ctc >= ltc))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int isUsefulForQuery() {
        if (this.hasComponentSgroup(this.query)) {
            return 0;
        }
        return 1;
    }

    @Override
    public int isUsefulForTarget() {
        if (this.hasComponentSgroup(this.target)) {
            return 0;
        }
        return 2;
    }
}

