/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import java.io.Serializable;
import java.util.Arrays;

public class MarkushFeature
implements Serializable {
    static final long serialVersionUID = 8770437891053649928L;
    public static final int RGROUP = 6;
    public static final int LINKNODE = 3;
    public static final int REPUNIT = 5;
    public static final int ATOMLIST = 1;
    public static final int BONDLIST = 2;
    public static final int MULTIBOND = 4;
    private int type;
    private int[] data;
    private int hashCode;

    public MarkushFeature(int type, int[] data) {
        this.type = type;
        this.data = data;
        int[] hash = new int[data.length + 1];
        hash[0] = type;
        System.arraycopy(data, 0, hash, 1, data.length);
        this.hashCode = Arrays.hashCode(hash);
    }

    public MarkushFeature(int ... args) {
        this.type = args[0];
        this.data = new int[args.length - 1];
        System.arraycopy(args, 1, this.data, 0, this.data.length);
        this.hashCode = Arrays.hashCode(args);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MarkushFeature)) {
            return false;
        }
        MarkushFeature mf = (MarkushFeature)o;
        if (this.type != mf.type) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == mf.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int getType() {
        return this.type;
    }

    public int[] getData() {
        return this.data;
    }

    private static String getTypeString(int type) {
        switch (type) {
            case 6: {
                return "RG";
            }
            case 3: {
                return "LN";
            }
            case 5: {
                return "RU";
            }
            case 1: {
                return "AL";
            }
            case 2: {
                return "BL";
            }
            case 4: {
                return "MB";
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(MarkushFeature.getTypeString(this.type));
        buffer.append(":");
        for (int i = 0; i < this.data.length; ++i) {
            buffer.append("" + (this.data[i] + 1));
            buffer.append(";");
        }
        return buffer.toString();
    }
}

