/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.enumeration.bracket.PolymerUtil;
import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.sss.search.InitializationIndicator;
import chemaxon.sss.search.MolComparator;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.MoleculeMatcher;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.StructureSearch;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

class MarkushPerfectSearch
extends StructureSearch {
    private Molecule targetMarkushDiagram = null;
    private Molecule targetMarkushDiagramNonConv = null;
    private MoleculeGraph targetOrigUnion;
    private Molecule queryMarkushDiagram = null;
    private Molecule queryMarkushDiagramNonConv = null;
    private MoleculeGraph queryOrigUnion;
    Logger logger = Logger.getLogger(MarkushPerfectSearch.class.getName());
    final String MULTIPOS_PSEUDO = "multipos_multicenter";

    MarkushPerfectSearch() {
    }

    @Override
    public void setTarget(Molecule mol) {
        if (mol != null) {
            HomologyConversionUtil.deconvertHomologies(mol, true);
        }
        this.targetMarkushDiagram = mol;
        this.convertMultipositionBonds(false);
        if (mol != null) {
            this.targetMarkushDiagram.ungroupSgroups(0);
            this.targetOrigUnion = mol.getGraphUnion();
            super.setTarget(this.makeMolecule(this.targetOrigUnion));
        } else {
            super.setTarget(null);
        }
    }

    private Molecule makeMolecule(MoleculeGraph oldUnion) {
        Molecule newUnion = new Molecule();
        oldUnion.clonecopy(newUnion);
        return newUnion;
    }

    @Override
    public void setTarget(Molecule mol, int[] exclude) {
        this.setTarget(mol);
    }

    @Override
    public void setQuery(Molecule mol) {
        if (mol != null) {
            HomologyConversionUtil.deconvertHomologies(mol, true);
        }
        this.queryMarkushDiagram = mol;
        this.convertMultipositionBonds(true);
        this.queryMarkushDiagram.ungroupSgroups(0);
        this.queryOrigUnion = mol.getGraphUnion();
        super.setQuery(this.makeMolecule(this.queryOrigUnion));
    }

    @Override
    protected void selectInitMode() {
        int im = 0;
        this.setInitMode(im);
        InitializationIndicator save_ti = this.sub.targetInit;
        this.sub.targetInit = null;
        this.sub.setInitMode(im);
        this.sub.targetInit = save_ti;
    }

    @Override
    protected void selectStereoModel() {
        MolSearchOptions mso = this.getSearchOptions();
        if (mso.getStereoModel() == 3) {
            mso.setStereoModel(0);
        }
    }

    @Override
    protected void createMolComparators() {
        super.createMolComparators();
        this.addComparator(new MarkushPerfectComparator());
    }

    @Override
    protected void initSearch() throws SearchException {
        this.searchOptions.setKeepQueryOrder(true);
        super.initSearch();
    }

    private void convertMultipositionBonds(boolean processQuery) {
        if (processQuery) {
            this.queryMarkushDiagramNonConv = this.queryMarkushDiagram.cloneMolecule();
        } else {
            if (this.targetMarkushDiagram == null) {
                this.targetMarkushDiagramNonConv = null;
                return;
            }
            this.targetMarkushDiagramNonConv = this.targetMarkushDiagram.cloneMolecule();
        }
        Molecule molToProc = processQuery ? this.queryMarkushDiagram : this.targetMarkushDiagram;
        boolean hasChanged = false;
        if (molToProc instanceof RgMolecule) {
            RgMolecule rgMol = (RgMolecule)molToProc;
            hasChanged |= this.convertMultiposInMol(rgMol.getRoot());
            for (int r = 0; r < rgMol.getRgroupCount(); ++r) {
                for (int rM = 0; rM < rgMol.getRgroupMemberCount(r); ++rM) {
                    hasChanged |= this.convertMultiposInMol(rgMol.getRgroupMember(r, rM));
                }
            }
        } else {
            hasChanged |= this.convertMultiposInMol(molToProc);
        }
        if (!hasChanged) {
            if (processQuery) {
                this.queryMarkushDiagramNonConv = this.queryMarkushDiagram;
            } else {
                this.targetMarkushDiagramNonConv = this.targetMarkushDiagram;
            }
        }
    }

    private boolean convertMultiposInMol(Molecule molToProc) {
        boolean hasMultipos = false;
        for (int i = 0; i < molToProc.getAtomCount(); ++i) {
            MolAtom multiCenterA = molToProc.getAtom(i);
            if (multiCenterA.getAtno() != 137) continue;
            int bondType = 1;
            hasMultipos = true;
            multiCenterA.setAtno(136);
            multiCenterA.setAliasstr("multipos_multicenter");
            boolean isCoord = false;
            MolAtom bondOtherEnd = multiCenterA;
            for (int b = 0; b < multiCenterA.getBondCount(); ++b) {
                if (multiCenterA.getBond(b).getType() != 9) continue;
                isCoord = true;
                bondOtherEnd = multiCenterA.getBond(b).getOtherAtom(multiCenterA);
                bondType = 9;
            }
            MulticenterSgroup msg = molToProc.findContainingMulticenterSgroup(multiCenterA);
            for (int msgI = 0; msgI < msg.getAtomCount(); ++msgI) {
                MolAtom msgA = msg.getAtom(msgI);
                MolBond bond = new MolBond(bondOtherEnd, msgA, bondType);
                molToProc.add(bond);
            }
            if (!isCoord) continue;
            molToProc.removeAtom(multiCenterA);
        }
        return hasMultipos;
    }

    @Override
    protected SearchHit findFirst0() throws SearchException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Markush duplicate search started.");
        }
        if (this.isLargeSearch()) {
            return this.findLargeHit();
        }
        return super.findFirst0();
    }

    private SearchHit findLargeHit() throws SearchException {
        MolSearch largeSearcher = this.initLargeSearcher();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Large search started.");
        }
        RgMolecule qRgMol = null;
        RgMolecule tRgMol = null;
        if (!(this.queryMarkushDiagram instanceof RgMolecule) || !(this.targetMarkushDiagram instanceof RgMolecule)) {
            throw new IllegalArgumentException("Search can not handle non Rgroup molecules above size: 1000");
        }
        qRgMol = (RgMolecule)this.queryMarkushDiagram;
        tRgMol = (RgMolecule)this.targetMarkushDiagram;
        if (!this.haveSameNumberOfRgroups(qRgMol, tRgMol)) {
            return null;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Checking root hit.");
        }
        largeSearcher.setQuery(qRgMol.getRoot());
        largeSearcher.setTarget(tRgMol.getRoot());
        SearchHit rootHit = largeSearcher.findFirstHit();
        if (rootHit == null) {
            return null;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Root has been hit.");
        }
        int rgNum = qRgMol.getRgroupCount();
        for (int i = 0; i < rgNum; ++i) {
            int rgMemNum = qRgMol.getRgroupMemberCount(i);
            for (int j = 0; j < rgMemNum; ++j) {
                largeSearcher.setQuery(qRgMol.getRgroupMember(i, j));
                largeSearcher.setTarget(tRgMol.getRgroupMember(i, j));
                SearchHit memberHit = largeSearcher.findFirstHit();
                if (memberHit == null) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("rgInd: " + i + " memberInd: " + j + " is not matching.");
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest("Query\n: " + qRgMol.getRgroupMember(i, j).toFormat("mrv"));
                            this.logger.finest("Target\n: " + tRgMol.getRgroupMember(i, j).toFormat("mrv"));
                        }
                    }
                    return null;
                }
                if (!this.logger.isLoggable(Level.FINEST)) continue;
                this.logger.finest("rgInd: " + i + " memberInd: " + j + " is matching.");
            }
        }
        return rootHit;
    }

    private boolean haveSameNumberOfRgroups(RgMolecule qRgMol, RgMolecule tRgMol) {
        if (qRgMol.getRgroupCount() != tRgMol.getRgroupCount()) {
            return false;
        }
        int n = qRgMol.getRgroupCount();
        for (int i = 0; i < n; ++i) {
            if (qRgMol.getRgroupMemberCount(i) == tRgMol.getRgroupMemberCount(i) && qRgMol.getRgroupId(i) == tRgMol.getRgroupId(i)) continue;
            return false;
        }
        return true;
    }

    private MolSearch initLargeSearcher() {
        MolSearch ms = new MolSearch();
        ms.setSearchOptions(this.getSearchOptions());
        ms.getSearchOptions().setMarkushEnabled(false);
        return ms;
    }

    private boolean isLargeSearch() {
        if (!(this.targetMarkushDiagram instanceof RgMolecule) || !(this.queryMarkushDiagram instanceof RgMolecule)) {
            return false;
        }
        if (((RgMolecule)this.targetMarkushDiagram).getRgroupCount() == 0 || ((RgMolecule)this.queryMarkushDiagram).getRgroupCount() == 0) {
            return false;
        }
        return this.targetOrigUnion.isLargeMolecule() || this.queryOrigUnion.isLargeMolecule();
    }

    @Override
    protected void createMoleculeMatchers() {
        this.moleculeMatchers = new MoleculeMatcher[0];
    }

    private class MarkushPerfectComparator
    extends MolComparator {
        int[] qRgNo = null;
        int[] tRgNo = null;
        String[] qSg = null;
        String[] tSg = null;
        int[][] qAtt = null;
        int[][] tAtt = null;

        private MarkushPerfectComparator() {
        }

        @Override
        public boolean compareAtoms(int ai1, int ai2) {
            int a2;
            int trgno;
            int a1 = this.getOrigQueryAtom(ai1);
            int qrgno = this.qRgNo[a1];
            if (qrgno != (trgno = this.tRgNo[a2 = this.getOrigTargetAtom(ai2)])) {
                return false;
            }
            if (!this.qSg[a1].equalsIgnoreCase(this.tSg[a2])) {
                return false;
            }
            MolAtom ma1 = MarkushPerfectSearch.this.sub.atoms[a1];
            MolAtom ma2 = MarkushPerfectSearch.this.atoms[a2];
            if (ma1.getMaxRepetitions() != ma2.getMaxRepetitions()) {
                return false;
            }
            return this.compareAttachments(a1, a2);
        }

        private boolean compareAttachments(int q, int t) {
            if (this.qAtt == null || this.tAtt == null) {
                return this.qAtt == this.tAtt;
            }
            int[] qA = this.qAtt[q];
            int[] tA = this.tAtt[t];
            if (qA.length != tA.length) {
                return false;
            }
            for (int i = 0; i < qA.length; ++i) {
                if (qA[i] == tA[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public void setQuery(Molecule q) {
            super.setQuery(q);
            this.qRgNo = this.getRgroupNumbers(MarkushPerfectSearch.this.queryMarkushDiagram, q.getAtomCount());
            this.qSg = this.getSgroupProperties(MarkushPerfectSearch.this.queryMarkushDiagramNonConv, q.getAtomCount());
            this.qAtt = this.getAttachmentNumbers(MarkushPerfectSearch.this.queryMarkushDiagram, q.getAtomCount());
        }

        @Override
        public void setTarget(Molecule t) {
            super.setTarget(t);
            if (t != null) {
                this.tRgNo = this.getRgroupNumbers(MarkushPerfectSearch.this.targetMarkushDiagram, t.getAtomCount());
                this.tSg = this.getSgroupProperties(MarkushPerfectSearch.this.targetMarkushDiagramNonConv, t.getAtomCount());
                this.tAtt = this.getAttachmentNumbers(MarkushPerfectSearch.this.targetMarkushDiagram, t.getAtomCount());
            }
        }

        private int[][] getAttachmentNumbers(Molecule targetMarkushDiagram, int atomCount) {
            int[][] att = new int[atomCount][];
            for (int i = 0; i < atomCount; ++i) {
                att[i] = MolImportUtil.getAttachmentOrders(targetMarkushDiagram.getAtom(i));
            }
            return att;
        }

        private int[] getRgroupNumbers(Molecule m, int atomCount) {
            int[] rgNums = new int[atomCount];
            int ac = 0;
            Molecule root = m instanceof RgMolecule ? ((RgMolecule)m).getRoot() : m;
            ac += this.setMolRno(rgNums, root, 0, -2);
            if (m instanceof RgMolecule) {
                RgMolecule rgm = (RgMolecule)m;
                int rgroupCount = rgm.getRgroupCount();
                for (int i = 0; i < rgroupCount; ++i) {
                    int id = rgm.getRgroupId(i);
                    int rgroupMemberCount = rgm.getRgroupMemberCount(i);
                    for (int j = 0; j < rgroupMemberCount; ++j) {
                        Molecule rdef = rgm.getRgroupMember(i, j);
                        ac += this.setMolRno(rgNums, rdef, ac, id);
                    }
                }
            }
            return rgNums;
        }

        private int setMolRno(int[] rgNums, Molecule m, int startIdx, int rgNo) {
            int ac = m.getAtomCount();
            for (int j = 0; j < ac; ++j) {
                rgNums[startIdx + j] = rgNo;
            }
            return ac;
        }

        private String[] getSgroupProperties(Molecule m, int aCount) {
            String[] ret = new String[aCount];
            ArrayList<Sgroup> sgl = new ArrayList<Sgroup>();
            for (int i = 0; i < m.getSgroupCount(); ++i) {
                Sgroup sg = m.getSgroup(i);
                if (!(sg instanceof RepeatingUnitSgroup) || PolymerUtil.isPolymerSgroup(sg)) continue;
                sgl.add(m.getSgroup(i));
            }
            Sgroup[] sg = new Sgroup[sgl.size()];
            sgl.toArray(sg);
            for (int j = 0; j < aCount; ++j) {
                int i;
                MolAtom ma = m.getAtom(j);
                ArrayList<String> al = new ArrayList<String>();
                for (i = 0; i < sg.length; ++i) {
                    if (!sg[i].hasAtom(ma)) continue;
                    al.add(sg[i].getSubscript() + sg[i].getConnectivity());
                }
                ret[j] = "";
                if (al.size() <= 0) continue;
                Collections.sort(al);
                for (i = 0; i < al.size(); ++i) {
                    int n = j;
                    ret[n] = ret[n] + (String)al.get(i);
                }
                int n = j;
                ret[n] = ret[n] + al.size();
            }
            return ret;
        }
    }
}

