/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntArrayIntSet;
import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.RingClassifier;
import chemaxon.enumeration.AromUtil;
import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.supergraph.MarkushAromata;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.enumeration.supergraph.SupergraphException;
import chemaxon.enumeration.supergraph.util.SupergraphBondClassifier;
import chemaxon.license.Licensable;
import chemaxon.marvin.modules.smarts.ParseException;
import chemaxon.marvin.modules.smarts.SimpleNode;
import chemaxon.marvin.modules.smarts.SmartsAtomTreeParser;
import chemaxon.marvin.modules.smarts.SmartsAtomTreeParserTreeConstants;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.sss.search.ConvertibleHomologyEqualTranslationMatcher;
import chemaxon.sss.search.InitializationIndicator;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MoleculeMatcher;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.SearchUtil;
import chemaxon.sss.search.StructureSearch;
import chemaxon.sss.search.options.HomologyTranslationOption;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.util.Dumper;
import chemaxon.util.HitColoringAndAlignmentOptions;
import chemaxon.util.HitDisplayUtil;
import chemaxon.util.MolHandler;
import chemaxon.util.RgMoleculeBondClassifier;
import chemaxon.util.RingMembership;
import chemaxon.util.ShortestPath;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

class MarkushSGSearch
extends StructureSearch
implements SmartsAtomTreeParserTreeConstants,
Licensable {
    private static final int CAN_BE_H = 1;
    private static final int CAN_BE_NON_H = 2;
    private static final int CAN_BE_H_MASK = 3;
    protected Molecule markushDiagram = null;
    Supergraph sg = null;
    MoleculeGraph union = null;
    private Hashtable<Integer, Integer> currentHitParentsGrCounts = null;
    private int[] numAtomAttach = null;
    private int[] queryAtomAttachNo = null;
    private int[] numPosVar = null;
    private int[] numOfPossiblyHLigands = null;
    private String licenseEnvironment = "";
    int[][] lastIdxAt2DHit;
    boolean isQueryHomologyMode = false;
    int[][] rings = null;
    int[] markushRings = null;
    int[] mringCount = null;
    HashMap<MoleculeGraph, ShortestPath> molSPaths;
    int[] ringSize = null;
    int[] markushRingSize = null;
    int[] unsaturated;
    MoleculeGraph unionCopy;
    int[] explConnectionLow;
    int[] explConnectionHigh;
    int[] connectionLow;
    int[] connectionHigh;
    int[] hydrogenLow;
    int[] hydrogenHigh;
    RgMoleculeBondClassifier bondClassifier;
    int[] mringBondCount;
    IntArrayIntSet[] neighbors;
    int[][] walks;
    BitSet canBeH;
    BitSet canBeNonH;
    private static final Logger logger = Logger.getLogger(MarkushSGSearch.class.getName());
    private static String[] supportedQueryFeatures = new String[]{"a", "A", "R", "rb", "s", "D", "u", "X", "H", "c"};
    private IntVector largerUserDefinitions;

    MarkushSGSearch() {
    }

    @Override
    public void setTarget(Molecule mol) {
        if (mol == null) {
            this.molecule = null;
            this.markushDiagram = null;
            this.sg = null;
            super.setTarget(mol);
        }
        if (mol instanceof Supergraph) {
            super.setTarget(mol);
            this.markushDiagram = ((Supergraph)mol).getMolecule();
        } else {
            this.markushDiagram = mol;
            this.molecule = null;
        }
        this.isMarkushSearch = true;
        this.clearArrays();
    }

    @Override
    public void setTarget(Molecule mol, int[] exclude) {
        this.setTarget(mol);
    }

    @Override
    protected SearchHit findFirst0() throws SearchException {
        this.currentHitParentsGrCounts = new Hashtable();
        if (this.sub instanceof MarkushSGSearch) {
            ((MarkushSGSearch)this.sub).createSupergraphIfNeeded();
        }
        this.createSupergraphIfNeeded();
        return super.findFirst0();
    }

    private void logSGMarkushMap() {
        StringBuilder sb = new StringBuilder();
        sb.append("Supergraph -> markush index map, 0-based:\n");
        for (int i = 0; i < this.matomLength; ++i) {
            sb.append(i);
            sb.append("-");
            if (this.atomIdxInAtomsArray[i] > -1) {
                sb.append(this.sg.getOrigAtomIndex(this.atomIdxInAtomsArray[i]));
            } else {
                sb.append(this.atomIdxInAtomsArray[i]);
            }
            sb.append("  ");
        }
        logger.fine(sb.toString());
    }

    private void createSupergraphIfNeeded() throws SearchException {
        if (this.molecule == null && this.markushDiagram != null) {
            if (!this._IAmTheQuery && !ExpansionUtil.isSearchable(this.markushDiagram)) {
                logger.warning("Target is not searchable.");
                throw new SearchException("Target is not searchable.");
            }
            try {
                this.molecule = new Supergraph();
                MolImportUtil.convertRgroupAttachments(this.markushDiagram);
                ((Supergraph)this.molecule).setMolecule(this.markushDiagram, !this._IAmTheQuery);
                this.markushDiagram = ((Supergraph)this.molecule).getMolecule();
            }
            catch (SupergraphException e) {
                throw new SearchException("Error during supergraph creation:" + e, e);
            }
        }
        this.unInitialize();
        this.sg = (Supergraph)this.molecule;
        this.union = this.markushDiagram.getGraphUnion();
    }

    @Override
    protected void transformPolymers(boolean transformQuery) throws SearchException {
        boolean queryPolymerMSGS;
        boolean bl = queryPolymerMSGS = transformQuery && this.sub instanceof MarkushSGSearch;
        if (queryPolymerMSGS) {
            MarkushSGSearch msgsSub = (MarkushSGSearch)this.sub;
            this.sub.molecule = msgsSub.markushDiagram;
            super.transformPolymers(transformQuery);
            msgsSub.markushDiagram = this.sub.molecule;
            this.sub.molecule = null;
            Molecule tmp = msgsSub.markushDiagram;
            msgsSub.createSupergraphIfNeeded();
            msgsSub.markushDiagram = tmp;
        }
        if (!transformQuery) {
            this.molecule = this.markushDiagram;
            super.transformPolymers(transformQuery);
            this.markushDiagram = this.molecule;
            this.molecule = null;
            Molecule tmp = this.markushDiagram;
            this.createSupergraphIfNeeded();
            this.markushDiagram = tmp;
        }
    }

    @Override
    protected boolean isCompatibleIdx(int d) {
        if (!super.isCompatibleIdx(d)) {
            return false;
        }
        return this.checkDBSInTheMiddle(d);
    }

    @Override
    protected SearchHit restoreHitIndexes(SearchHit actHit) {
        this.restoreRearranged2DHits(actHit);
        return super.restoreHitIndexes(actHit);
    }

    @Override
    protected SearchHit restoreRearrangedHitIndices(SearchHit searchHit) {
        SearchHit rearrangedHit = super.restoreRearrangedHitIndices(searchHit);
        if (!this.isHitArrayNeeded || this.searchOptions.getHitIndexType() == 1) {
            return rearrangedHit;
        }
        int[] singleHit = rearrangedHit.getSingleHit();
        rearrangedHit.setSingleHit(this.sgInd2MarkushInd(singleHit));
        return rearrangedHit;
    }

    private int[] sgInd2MarkushInd(int[] hit) {
        IntVector outV = new IntVector();
        for (int h : hit) {
            if (h < -this.sg.getAtomCount()) {
                outV.add(h);
                continue;
            }
            outV.add(h < 0 ? -this.sg.getOrigAtomIndex(-h - 1) - 1 : this.sg.getOrigAtomIndex(h));
        }
        return outV.toArray();
    }

    private void restoreRearranged2DHits(SearchHit searchHit) {
        int[] rearr;
        int[] column;
        int i;
        this.clearAmbiguousHits();
        int[] actHit = searchHit.getSingleHit();
        Object hit2D = new int[actHit.length][];
        for (int i2 = 0; i2 < actHit.length; ++i2) {
            hit2D[i2] = this.getQHomologyHits(i2, actHit[i2]);
        }
        this.lastIdxAt2DHit = hit2D;
        ArrayList<int[]> columnVList = this.gloveArray2ColumnList((int[][])hit2D);
        for (i = 0; i < columnVList.size(); ++i) {
            column = columnVList.get(i);
            rearr = this.restoreSingleHitIndexes(column);
            rearr = this.restoreRearrangedSingleHitIndices(rearr);
            columnVList.set(i, rearr);
        }
        hit2D = this.columnList2GloveArray(columnVList);
        if (this.searchOptions.getHitIndexType() == 0) {
            for (i = 0; i < ((int[][])hit2D).length; ++i) {
                int[] temp = (int[])hit2D[i].clone();
                hit2D[i] = this.sgInd2MarkushInd(hit2D[i]);
                hit2D[i] = this.eliminateImplHHits(hit2D[i]);
                hit2D[i] = this.getRgParents(hit2D[i], temp);
            }
        }
        columnVList = this.gloveArray2ColumnList((int[][])hit2D);
        for (i = 0; i < columnVList.size(); ++i) {
            column = columnVList.get(i);
            rearr = super.restorePolymerTransformation(column);
            columnVList.set(i, rearr);
        }
        hit2D = this.columnList2GloveArray(columnVList);
        searchHit.setGroupHit((int[][])hit2D);
    }

    private int[] eliminateImplHHits(int[] hit) {
        IntVector hitV = new IntVector();
        for (int i = 0; i < hit.length; ++i) {
            if (i != 0 && hit[i] <= 0) continue;
            hitV.add(hit[i]);
        }
        return hitV.toArray();
    }

    private int[] getRgParents(int[] markushIndV, int[] sgIndV) {
        if (this.markushDiagram instanceof RgMolecule && markushIndV.length > 0) {
            IntVector rgParentIndexes = new IntVector();
            for (int j = 0; j < markushIndV.length; ++j) {
                rgParentIndexes.add(markushIndV[j]);
            }
            for (int i = 0; i < sgIndV.length; ++i) {
                if (sgIndV[i] < -this.sg.getAtomCount() || sgIndV[i] >= this.sg.getAtomCount()) continue;
                int sgInd = sgIndV[i] < 0 ? -sgIndV[i] - 1 : sgIndV[i];
                int currAtom = this.sg.getID(sgInd);
                while ((currAtom = this.sg.getParentIDByID(currAtom)) != -1) {
                    int atomInd = this.sg.getOrigAtomIndexByID(currAtom);
                    if (atomInd == -1 || this.markushDiagram.getAtom(atomInd).getAtno() != 134 || rgParentIndexes.contains(atomInd)) continue;
                    rgParentIndexes.add(atomInd);
                }
            }
            return rgParentIndexes.toArray();
        }
        return markushIndV;
    }

    private int[][] columnList2GloveArray(ArrayList<int[]> columnVList) {
        int[][] ret = new int[columnVList.get(0).length][];
        for (int i = 0; i < ret.length; ++i) {
            IntVector row = new IntVector();
            int firstElement = columnVList.get(0)[i];
            for (int colI = 0; colI < columnVList.size(); ++colI) {
                int currElement = columnVList.get(colI)[i];
                if (colI != 0 && currElement == firstElement) break;
                row.add(currElement);
            }
            ret[i] = row.toArray();
        }
        return ret;
    }

    private ArrayList<int[]> gloveArray2ColumnList(int[][] int2D) {
        ArrayList<int[]> columnVList = new ArrayList<int[]>();
        boolean indexOverLongest = false;
        int colInd = 0;
        while (!indexOverLongest) {
            indexOverLongest = true;
            int[] column = new int[int2D.length];
            for (int i = 0; i < int2D.length; ++i) {
                if (int2D[i].length > colInd) {
                    column[i] = int2D[i][colInd];
                    if (int2D[i].length <= colInd + 1) continue;
                    indexOverLongest = false;
                    continue;
                }
                column[i] = int2D[i][0];
            }
            columnVList.add(column);
            ++colInd;
        }
        return columnVList;
    }

    protected int[] getQHomologyHits(int hgInd, int firstHit) {
        int[] ret = new int[]{firstHit};
        return ret;
    }

    @Override
    protected void selectInitMode() {
        int im = 1;
        if (this.molecule instanceof Supergraph && !((Supergraph)this.molecule).hasExpandedMarkushFeature(true)) {
            super.selectInitMode();
            return;
        }
        this.setInitMode(im);
        InitializationIndicator save_ti = this.sub.targetInit;
        this.sub.targetInit = null;
        if (!this.isQueryHomologyMode && this.searchOptions.getImplicitHMatching() != 2) {
            this.sub.setInitMode(0);
        } else {
            this.sub.setInitMode(im);
        }
        this.sub.targetInit = save_ti;
    }

    @Override
    protected boolean preCheck() {
        return true;
    }

    @Override
    protected void selectStereoModel() {
        SearchUtil.selectStereoModel(this.getSearchOptions(), this.getSearchOptions(), null, true);
    }

    @Override
    protected boolean areCompatibleAtoms(int i, int i1) {
        int iMol = this.atomIdxInAtomsArray[i];
        int i1Mol = this.atomIdxInAtomsArray[i1];
        if (iMol < 0 || i1Mol < 0) {
            return true;
        }
        return this.sg.isCompatible(iMol, i1Mol);
    }

    @Override
    protected boolean isCompatibleWithTheRest(int dep, int si, int newAtom) {
        for (int i = 0; i < dep; ++i) {
            int oldAtom = this.bto[si + this.sub.ind[i]];
            if (this.areCompatibleAtoms(oldAtom, newAtom)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isValidHitInner(SearchHit searchHit) throws SearchException {
        int[] hit = searchHit.getSingleHit();
        if (!this.searchOptions.isSubgraphSearch()) {
            int[] singleHDefMatomIndexes = this.getSingleHDefMatomIndexes(hit);
            for (int i = 0; i < this.matomLength; ++i) {
                int origAtomIdx = this.atomIdxInAtomsArray[i];
                if (origAtomIdx < 0 || this.matom[i] == 1 || this.getMatchingQuery(hit, i) != -1 || !this.isCompatibleWithAll(origAtomIdx, hit) || !this.isCompatibleWithAll(origAtomIdx, singleHDefMatomIndexes)) continue;
                if (this.isVerbose()) {
                    System.err.println("FULL: Atom " + origAtomIdx + " should be in hit, but is missing.\n" + "  So rejecting hit(inner repr.):" + Dumper.dumpIntArray(hit));
                }
                return false;
            }
        }
        if (!this.isValidUserDefHgHit(hit)) {
            logger.fine("isValidUserDefHgHit() fails");
            return false;
        }
        if (this.needCheckingAmbigArom()) {
            return this.checkAmbigAromaticityByEnumeration(hit);
        }
        if (this.sub.explConnectionLength > 0 && !this.isQueryHomologyMode && !this.isValidHitInnerDProperty(hit)) {
            logger.fine("isValidHitInnerDProperty fails");
            return false;
        }
        if (this.sub.hasUnSaturatedFlag && !this.isQueryHomologyMode && !this.isValidHitInnerUProperty(hit)) {
            logger.fine("isValidHitInnerUProperty fails");
            return false;
        }
        if (this.sub.connectionLength > 0 && !this.isQueryHomologyMode && !this.isValidHitInnerXProperty(hit)) {
            logger.fine("isValidHitInnerXProperty fails");
            return false;
        }
        if (this.sub.hydrogenLength > 0 && !this.isQueryHomologyMode && !this.isValidHitInnerHProperty(hit)) {
            logger.fine("isValidHitInnerHProperty fails");
            return false;
        }
        return true;
    }

    private boolean isValidHitInnerHProperty(int[] hit) {
        if (this.unionCopy == null) {
            this.unionCopy = this.getUnionCopy();
        }
        for (int subAtomIndex = 0; subAtomIndex < this.sub.hydrogenLength; ++subAtomIndex) {
            Sgroup[] sgroups;
            int[] highLow;
            int high;
            int queryIndex = this.sub.atomIdxInAtomsArray[subAtomIndex];
            int subHydrogen = this.sub.hydrogen[subAtomIndex];
            if (subHydrogen == -1) continue;
            MolAtom atom = this.sub.atoms[queryIndex];
            int targetAtomIndex = hit[subAtomIndex];
            int unionIndex = this.sg.getOrigAtomIndex(targetAtomIndex);
            MolAtom unionAtom = this.unionCopy.getAtom(unionIndex);
            if (HomologyConstants.isHomology(unionAtom.getAliasstr())) continue;
            unionAtom.setAtno(this.sg.getAtom(this.atomIdxInAtomsArray[targetAtomIndex]).getAtno());
            int low = high = unionAtom.getImplicitHcount();
            HashSet<Integer> neighbor = new HashSet<Integer>();
            for (int l : this.neighbors[targetAtomIndex].toArray()) {
                neighbor.add(l);
            }
            for (int ligandIndex = 0; ligandIndex < this.sub.matomLength; ++ligandIndex) {
                int[] highLow2;
                MolAtom ligand = this.sub.atoms[this.sub.atomIdxInAtomsArray[ligandIndex]];
                MolBond bond = atom.getBondTo(ligand);
                if (bond == null) continue;
                if (ligand.getAtno() == 1) {
                    ++low;
                    ++high;
                }
                int[] walk = this.walks[hit[ligandIndex]];
                for (int i = 0; i < walk.length; ++i) {
                    if (neighbor.remove(walk[i] + 1)) continue;
                    neighbor.remove(-walk[i] - 1);
                }
                int[] subHighLow = this.getConnectionUsageValues(bond.getType());
                if (this.atomIdxInAtomsArray[targetAtomIndex] >= 0 && this.atomIdxInAtomsArray[hit[ligandIndex]] >= 0) {
                    MolAtom tatom = this.sg.getAtom(this.atomIdxInAtomsArray[targetAtomIndex]);
                    MolAtom tligand = this.sg.getAtom(this.atomIdxInAtomsArray[hit[ligandIndex]]);
                    bond = tatom.getBondTo(tligand);
                } else {
                    bond = null;
                }
                int[] nArray = highLow2 = bond == null ? subHighLow : this.getConnectionUsageValues(bond.getType());
                if (subHighLow[0] > highLow2[0]) {
                    highLow2[0] = subHighLow[0];
                }
                if (subHighLow[1] < highLow2[1]) {
                    highLow2[1] = subHighLow[1];
                }
                low -= highLow2[1];
                high -= highLow2[0];
            }
            if (neighbor.size() > 0) {
                int[] walk = this.walks[targetAtomIndex];
                for (int walkIndex = walk.length - 1; walkIndex >= 0; --walkIndex) {
                    unionAtom = this.union.getAtom(walk[walkIndex]);
                    Iterator i$ = neighbor.iterator();
                    while (i$.hasNext()) {
                        int ligandIndex = (Integer)i$.next();
                        MolAtom ligand = this.union.getAtom(ligandIndex = Math.abs(ligandIndex) - 1);
                        MolBond bond = unionAtom.getBondTo(ligand);
                        if (bond == null) continue;
                        highLow = this.getConnectionUsageValues(bond.getType());
                        low -= highLow[1];
                        high -= highLow[0];
                        if (!this.canBeH.get(ligandIndex)) continue;
                        ++high;
                        if (this.canBeNonH.get(ligandIndex)) continue;
                        ++low;
                    }
                }
            }
            for (Sgroup sgroup : sgroups = this.markushDiagram.findAllSgroupContaining(this.markushDiagram.getAtom(unionIndex))) {
                if (!(sgroup instanceof MulticenterSgroup)) continue;
                MulticenterSgroup mgroup = (MulticenterSgroup)sgroup;
                highLow = this.getConnectionUsageValues(mgroup.getCentralAtom().getBond(0).getType());
                low -= highLow[1] + 1;
                high -= highLow[0] + 1;
                int ligandIndex = this.markushDiagram.indexOf(mgroup.getCentralAtom().getLigand(0));
                if (!this.canBeH.get(ligandIndex)) continue;
                ++high;
                if (this.canBeNonH.get(ligandIndex)) continue;
                ++low;
            }
            if ((this.sub.hydrogenGreaterRelation[subAtomIndex] != 61 || this.sub.hydrogen[subAtomIndex] >= low && this.sub.hydrogen[subAtomIndex] <= high) && (this.sub.hydrogenGreaterRelation[subAtomIndex] != 62 || this.sub.hydrogen[subAtomIndex] <= high)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidHitInnerXProperty(int[] hit) {
        if (this.unionCopy == null) {
            this.unionCopy = this.getUnionCopy();
        }
        for (int subAtomIndex = 0; subAtomIndex < this.sub.connectionLength; ++subAtomIndex) {
            Sgroup[] sgroups;
            int[] highLow;
            int high;
            int subConnection = this.sub.connection[subAtomIndex];
            if (subConnection == -1) continue;
            MolAtom atom = this.sub.atoms[this.sub.atomIdxInAtomsArray[subAtomIndex]];
            int targetAtomIndex = hit[subAtomIndex];
            int unionIndex = this.sg.getOrigAtomIndex(this.atomIdxInAtomsArray[targetAtomIndex]);
            MolAtom unionAtom = this.unionCopy.getAtom(unionIndex);
            if (HomologyConstants.isHomology(unionAtom.getAliasstr())) continue;
            unionAtom.setAtno(this.sg.getAtom(this.atomIdxInAtomsArray[targetAtomIndex]).getAtno());
            int low = high = unionAtom.getImplicitHcount() + unionAtom.getBondCount();
            HashSet<Integer> neighbor = new HashSet<Integer>();
            for (int l : this.neighbors[targetAtomIndex].toArray()) {
                neighbor.add(l);
            }
            for (int ligandIndex = 0; ligandIndex < this.sub.matomLength; ++ligandIndex) {
                int[] highLow2;
                MolAtom ligand = this.sub.atoms[this.sub.atomIdxInAtomsArray[ligandIndex]];
                MolBond bond = atom.getBondTo(ligand);
                if (bond == null) continue;
                int[] walk = this.walks[hit[ligandIndex]];
                for (int i = 0; i < walk.length; ++i) {
                    if (neighbor.remove(walk[i] + 1)) continue;
                    neighbor.remove(-walk[i] - 1);
                }
                int[] subHighLow = this.getConnectionUsageValues(bond.getType());
                if (this.atomIdxInAtomsArray[targetAtomIndex] >= 0 && this.atomIdxInAtomsArray[hit[ligandIndex]] >= 0) {
                    MolAtom tatom = this.sg.getAtom(this.atomIdxInAtomsArray[targetAtomIndex]);
                    MolAtom tligand = this.sg.getAtom(this.atomIdxInAtomsArray[hit[ligandIndex]]);
                    bond = tatom.getBondTo(tligand);
                } else {
                    bond = null;
                }
                int[] nArray = highLow2 = bond == null ? subHighLow : this.getConnectionUsageValues(bond.getType());
                if (subHighLow[0] > highLow2[0]) {
                    highLow2[0] = subHighLow[0];
                }
                if (subHighLow[1] < highLow2[1]) {
                    highLow2[1] = subHighLow[1];
                }
                low -= highLow2[1];
                high -= highLow2[0];
            }
            if (neighbor.size() > 0) {
                int[] walk = this.walks[targetAtomIndex];
                for (int walkIndex = walk.length - 1; walkIndex >= 0; --walkIndex) {
                    unionAtom = this.union.getAtom(walk[walkIndex]);
                    Iterator i$ = neighbor.iterator();
                    while (i$.hasNext()) {
                        int ligandIndex = (Integer)i$.next();
                        MolAtom ligand = this.union.getAtom(ligandIndex = Math.abs(ligandIndex) - 1);
                        MolBond bond = unionAtom.getBondTo(ligand);
                        if (bond == null) continue;
                        highLow = this.getConnectionUsageValues(unionAtom.getBondTo(ligand).getType());
                        low -= highLow[1];
                        high -= highLow[0];
                    }
                }
            }
            for (Sgroup sgroup : sgroups = this.markushDiagram.findAllSgroupContaining(this.markushDiagram.getAtom(unionIndex))) {
                if (!(sgroup instanceof MulticenterSgroup)) continue;
                MulticenterSgroup mgroup = (MulticenterSgroup)sgroup;
                highLow = this.getConnectionUsageValues(mgroup.getCentralAtom().getBond(0).getType());
                low -= highLow[1];
                high -= highLow[0];
                int ligandIndex = this.markushDiagram.indexOf(mgroup.getCentralAtom().getLigand(0));
                if (!this.canBeH.get(ligandIndex)) continue;
                ++high;
                if (this.canBeNonH.get(ligandIndex)) continue;
                ++low;
            }
            if (subConnection >= low && subConnection <= high) continue;
            return false;
        }
        return true;
    }

    private boolean isValidHitInnerUProperty(int[] hit) {
        for (int subAtomIndex = 0; subAtomIndex < this.sub.atomsLength; ++subAtomIndex) {
            MolAtom tligand;
            MolAtom atom = this.sub.atoms[subAtomIndex];
            int targetAtomIndex = hit[subAtomIndex];
            if (atom.getQPropAsInt("u") != 1 || this.unsaturated[targetAtomIndex] != 2) continue;
            HashSet<Integer> neighbor = new HashSet<Integer>();
            for (int l : this.neighbors[targetAtomIndex].toArray()) {
                neighbor.add(l);
            }
            boolean us = false;
            for (int ligandIndex = 0; ligandIndex < this.sub.matomLength && !us; ++ligandIndex) {
                MolAtom ligand = this.sub.atoms[this.sub.atomIdxInAtomsArray[ligandIndex]];
                MolBond bond = atom.getBondTo(ligand);
                if (bond == null) continue;
                int[] walk = this.walks[hit[ligandIndex]];
                for (int i = 0; i < walk.length; ++i) {
                    if (neighbor.remove(walk[i] + 1)) continue;
                    neighbor.remove(-walk[i] - 1);
                }
                int uV = this.getUnsaturatedValue(bond.getType());
                if (uV == 1) {
                    us = true;
                    continue;
                }
                if (uV != 2) continue;
                if (this.atomIdxInAtomsArray[targetAtomIndex] >= 0 && this.atomIdxInAtomsArray[hit[ligandIndex]] >= 0) {
                    MolAtom tatom = this.sg.getAtom(this.atomIdxInAtomsArray[targetAtomIndex]);
                    tligand = this.sg.getAtom(this.atomIdxInAtomsArray[hit[ligandIndex]]);
                    bond = tatom.getBondTo(tligand);
                } else {
                    bond = null;
                }
                if (bond == null || this.getUnsaturatedValue(bond.getType()) == 0) continue;
                us = true;
            }
            if (!us && neighbor.size() > 0) {
                int bondNum = this.abonds[targetAtomIndex];
                int bondOffset = this.bondidx[targetAtomIndex];
                MolAtom tatom = this.sg.getAtom(targetAtomIndex);
                for (int bondIndex = bondOffset; bondIndex < bondOffset + bondNum && !us; ++bondIndex) {
                    MolBond tbond;
                    int walkIndex;
                    int[] walk = this.walks[this.bto[bondIndex]];
                    if (walk == null || walk.length == 0) continue;
                    for (walkIndex = 0; walkIndex < walk.length && !neighbor.contains(walk[walkIndex] + 1); ++walkIndex) {
                    }
                    if (walkIndex >= walk.length || !neighbor.contains(walk[walkIndex] + 1) || (tbond = tatom.getBondTo(tligand = this.sg.getAtom(this.atomIdxInAtomsArray[this.bto[bondIndex]]))) == null || this.getUnsaturatedValue(tbond.getType()) == 0) continue;
                    us = true;
                }
            }
            if (us) continue;
            return false;
        }
        return true;
    }

    private boolean isValidHitInnerDProperty(int[] hit) {
        for (int subAtomIndex = 0; subAtomIndex < this.sub.explConnectionLength; ++subAtomIndex) {
            Sgroup[] sgroups;
            int high;
            int queryIndex = this.sub.atomIdxInAtomsArray[subAtomIndex];
            int explConn = this.sub.explConnection[subAtomIndex];
            if (explConn == -1) continue;
            MolAtom atom = this.sub.atoms[queryIndex];
            int targetAtomIndex = hit[subAtomIndex];
            int unionIndex = this.sg.getOrigAtomIndex(targetAtomIndex);
            MolAtom unionAtom = this.union.getAtom(unionIndex);
            if (HomologyConstants.isHomology(unionAtom.getAliasstr())) continue;
            unionAtom.setAtno(this.sg.getAtom(this.atomIdxInAtomsArray[targetAtomIndex]).getAtno());
            int low = high = unionAtom.getBondCount();
            HashSet<Integer> neighbor = new HashSet<Integer>();
            for (int l : this.neighbors[targetAtomIndex].toArray()) {
                neighbor.add(l);
            }
            for (int ligandIndex = 0; ligandIndex < this.sub.matomLength; ++ligandIndex) {
                MolAtom ligand = this.sub.atoms[this.sub.atomIdxInAtomsArray[ligandIndex]];
                MolBond bond = atom.getBondTo(ligand);
                if (bond == null) continue;
                if (ligand.getAtno() == 1) {
                    --low;
                    --high;
                }
                int[] walk = this.walks[hit[ligandIndex]];
                for (int i = 0; i < walk.length; ++i) {
                    if (neighbor.remove(walk[i] + 1)) continue;
                    neighbor.remove(-walk[i] - 1);
                }
            }
            if (neighbor.size() > 0) {
                Iterator i$ = neighbor.iterator();
                while (i$.hasNext()) {
                    int ligandIndex = (Integer)i$.next();
                    if (!this.canBeH.get(ligandIndex = Math.abs(ligandIndex) - 1)) continue;
                    --low;
                    if (this.canBeNonH.get(ligandIndex)) continue;
                    --high;
                }
            }
            for (Sgroup sgroup : sgroups = this.markushDiagram.findAllSgroupContaining(this.markushDiagram.getAtom(unionIndex))) {
                MulticenterSgroup mgroup;
                int ligandIndex;
                if (!(sgroup instanceof MulticenterSgroup) || !this.canBeH.get(ligandIndex = this.markushDiagram.indexOf((mgroup = (MulticenterSgroup)sgroup).getCentralAtom().getLigand(0)))) continue;
                --low;
                if (this.canBeNonH.get(ligandIndex)) continue;
                --high;
            }
            if (explConn >= low && explConn <= high) continue;
            return false;
        }
        return true;
    }

    int[] getSingleHDefMatomIndexes(int[] hit) {
        if (!(this.markushDiagram instanceof RgMolecule)) {
            return new int[0];
        }
        RgMolecule rgm = (RgMolecule)this.markushDiagram;
        IntVector markushSingleHDefAtoms = new IntVector();
        int n = rgm.getRgroupCount();
        for (int i = 0; i < n; ++i) {
            int m = rgm.getRgroupMemberCount(i);
            for (int j = 0; j < m; ++j) {
                if (!this.isSingleHDefinition(rgm.getRgroupMember(i, j))) continue;
                Molecule def = rgm.getRgroupMember(i, j);
                MolAtom hAtom = def.getAtom(0).getAtno() == 1 ? def.getAtom(0) : def.getAtom(1);
                int markushAtomIndex = this.markushDiagram.indexOf(hAtom);
                markushSingleHDefAtoms.add(markushAtomIndex);
            }
        }
        IntVector singleHDefMatomIndexes = new IntVector();
        for (int matomInd = 0; matomInd < this.matomLength; ++matomInd) {
            int sgIndex;
            int markushIndex;
            if (this.atomIdxInAtomsArray[matomInd] < 0 || !markushSingleHDefAtoms.contains(markushIndex = this.sg.getOrigAtomIndex(sgIndex = this.atomIdxInAtomsArray[matomInd])) || ArrayTools.contains(hit, matomInd) || !this.isCompatibleWithAll(sgIndex, hit)) continue;
            singleHDefMatomIndexes.add(matomInd);
        }
        return singleHDefMatomIndexes.toArray();
    }

    @Override
    protected boolean refine() throws SearchException {
        boolean res = super.refine();
        return res || this.checkUserDefinedCompleteness();
    }

    private boolean checkUserDefinedCompleteness() {
        if (!this.searchOptions.getCompleteHG()) {
            return false;
        }
        if (this.largerUserDefinitions == null) {
            this.largerUserDefinitions = this.getAtomsInLargerUserDefintions();
        }
        if (this.largerUserDefinitions.size() == 0) {
            return false;
        }
        boolean[] checked = new boolean[this.matomLength];
        checked = ArrayTools.initBooleanArrayAndFill(checked, this.matomLength, false);
        boolean clearedSomeCol = false;
        int parent = 0;
        for (int definitionInd = 0; definitionInd < this.largerUserDefinitions.size(); ++definitionInd) {
            int atomIndex = this.largerUserDefinitions.get(definitionInd);
            if (checked[atomIndex] || (parent = this.getUserDefParent(atomIndex)) == -1 || !this.isMappable(atomIndex)) continue;
            int[] reachables = this.getUserDefHomDefinition(atomIndex, parent);
            int[] walk = this.getGraphUnionWalk(atomIndex);
            int parentOfNonMappable = -1;
            for (int rInd : reachables) {
                int[] walkRInd = this.getGraphUnionWalk(rInd);
                int parentRInd = walkRInd[walkRInd.length - 2];
                if (walkRInd.length <= 1 || !ArrayTools.foundInArray(walk, parentRInd)) continue;
                checked[rInd] = true;
                if (this.isMappable(rInd)) continue;
                parentOfNonMappable = parentRInd;
                logger.finest("Non mappable: " + rInd);
                break;
            }
            if (parentOfNonMappable == -1) continue;
            for (int rInd : reachables) {
                if (!ArrayTools.foundInArray(this.getGraphUnionWalk(rInd), parentOfNonMappable)) continue;
                for (int c = 0; c < this.sub.matomLength; ++c) {
                    this.map.clearMap(c, rInd);
                }
                checked[rInd] = true;
                clearedSomeCol = true;
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("Clearing map for: " + rInd);
            }
        }
        return clearedSomeCol;
    }

    private IntVector getAtomsInLargerUserDefintions() {
        IntVector definitions = new IntVector();
        boolean[] checked = new boolean[this.matomLength];
        checked = ArrayTools.initBooleanArrayAndFill(checked, this.matomLength, false);
        int parent = 0;
        for (int i = 0; i < this.matomLength; ++i) {
            int[] reachables;
            if (checked[i] || (parent = this.getUserDefParent(i)) == -1 || !this.isMappable(i) || (reachables = this.getUserDefHomDefinition(i, parent)).length < 2) continue;
            for (int rInd : reachables) {
                checked[rInd] = true;
                definitions.add(rInd);
            }
        }
        return definitions;
    }

    private int[] getGraphUnionWalk(int i) {
        int sgInd = this.atomIdxInAtomsArray[i];
        if (sgInd == -1) {
            return new int[0];
        }
        return this.sg.getGraphUnionWalk(sgInd);
    }

    protected boolean isValidUserDefHgHit(int[] hit) {
        if (!this.searchOptions.getCompleteHG()) {
            return true;
        }
        IntVector hitsToCheck = new IntVector(hit);
        for (int i = 0; i < hitsToCheck.size(); ++i) {
            int t = hitsToCheck.get(i);
            int parent = this.getUserDefParent(t);
            if (parent == -1) continue;
            int[] reachables = this.getUserDefHomDefinition(t, parent);
            IntVector hitsWithHGparentV = new IntVector();
            int n = hitsToCheck.size();
            for (int h = 0; h < n; ++h) {
                if (this.getUserDefParent(hitsToCheck.get(h)) != parent) continue;
                hitsWithHGparentV.add(hitsToCheck.get(h));
            }
            int[] hitsWithHGparent = hitsWithHGparentV.toArray();
            for (int reachAtom : reachables) {
                int reachAtom_sg = this.atomIdxInAtomsArray[reachAtom];
                if (reachAtom_sg < 0 || !this.isCompatibleWithAll(reachAtom_sg, hitsWithHGparent) || hitsWithHGparentV.contains(reachAtom)) continue;
                return false;
            }
            for (int r : reachables) {
                while (hitsToCheck.removeElement(r)) {
                }
            }
            hitsToCheck.add(i, t);
        }
        return true;
    }

    private int[] getUserDefHomDefinition(int t, int parent) {
        IntVector reachables = new IntVector();
        reachables.add(t);
        int nextReach = 0;
        while (reachables.size() > nextReach) {
            int[] neigh;
            int curr = reachables.get(nextReach++);
            for (int n : neigh = this.getNeighbours(curr)) {
                if (this.getUserDefParent(n) != parent || !this.areCompatibleAtoms(t, n) || reachables.contains(n)) continue;
                reachables.add(n);
            }
        }
        return reachables.toArray();
    }

    protected int getUserDefParent(int t) {
        int t_sg = this.atomIdxInAtomsArray[t];
        if (t_sg < 0) {
            return -1;
        }
        return this.sg.getUserDefParentID(t_sg);
    }

    protected boolean isValidFullFragmentHit(int[] hit) {
        return true;
    }

    protected int getMatchingQuery(int[] hit, int i) {
        return ArrayTools.indexInArray(hit, i);
    }

    private boolean needCheckingAmbigArom() {
        return this.hasAmbigArom && this.searchOptions.getMarkushArom() != 1;
    }

    @Override
    protected boolean isAromaticityNeededInTarget() {
        if (this.searchOptions.getMarkushArom() == 2) {
            return super.isAromaticityNeededInTarget();
        }
        return true;
    }

    private boolean checkAmbigAromaticityByEnumeration(int[] hit) throws SearchException {
        this.isHitArrayNeeded = true;
        int[] sgHitAtoms = this.restoreSingleHitIndexes(hit);
        if (!this.isHitOverlappingWithAmbig(sgHitAtoms)) {
            return true;
        }
        if (!this.isEnumUseful(sgHitAtoms)) {
            return true;
        }
        if (logger.isLoggable(Level.FINER)) {
            int[] unionHits = new int[sgHitAtoms.length];
            for (int i = 0; i < sgHitAtoms.length; ++i) {
                unionHits[i] = this.getUnionIndex(sgHitAtoms[i]);
            }
            logger.finer("Ambig arom checking, Hits: " + Dumper.dumpIntArray(hit) + "\n\tHits, union indexes: " + Dumper.dumpIntArray(unionHits));
            HitColoringAndAlignmentOptions hco = new HitColoringAndAlignmentOptions();
            hco.coloring = true;
            HitDisplayUtil.color(this.sub.molecule, this.markushDiagram, unionHits, hco);
            logger.finest("Colored markush: \n" + this.markushDiagram.toFormat("mrv"));
        }
        Molecule enTarget = this.createEnumeratedTarget(sgHitAtoms);
        MolSearch ms = new MolSearch();
        ms.setLicenseEnvironment(this.licenseEnvironment);
        ms.setQuery(this.getQuery());
        ms.setTarget(enTarget);
        ms.setSearchOptions(this.searchOptions);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Ambig arom checking: Query: " + ms.getQuery().toFormat("smarts"));
            logger.finest("Ambig arom checking: Target:\n" + enTarget.toFormat("mrv"));
        }
        for (int i = 0; i < sgHitAtoms.length; ++i) {
            if (sgHitAtoms[i] < 0) continue;
            ms.addMatch(i, sgHitAtoms[i]);
        }
        if (this.isVerbose()) {
            System.err.println("Checking ambiguous aromatic solution.");
        }
        ms.searchOptions.setMarkushArom(1);
        ms.getSearchOptions().setStereoSearchType(1);
        boolean res = ms.isMatching();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Ambig arom checking result: " + res);
        }
        return res;
    }

    private boolean isHitOverlappingWithAmbig(int[] sgHitAtoms) {
        for (int i : sgHitAtoms) {
            if (i < 0 || !this.sg.isAmbiguousAromaticAtom(i)) continue;
            return true;
        }
        return false;
    }

    private Molecule createEnumeratedTarget(int[] sgHitAtoms) throws SearchException {
        Molecule enTarget;
        Molecule expanded;
        try {
            boolean expandHomology = true;
            boolean deconvertHomologies = false;
            expanded = this.sg.expand(null, sgHitAtoms, null, expandHomology, deconvertHomologies);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Expanded markush: " + expanded.toFormat("mrv"));
            }
        }
        catch (SupergraphException e) {
            throw new SearchException(e.getMessage(), e);
        }
        if (Supergraph.isMarkushMolecule(expanded)) {
            MarkushAromata ma = new MarkushAromata();
            ma.aromatize(expanded);
            try {
                enTarget = new Supergraph(expanded);
            }
            catch (SupergraphException e) {
                throw new SearchException(e.toString(), e);
            }
            for (int i = 0; i < sgHitAtoms.length; ++i) {
                if (sgHitAtoms[i] < 0) continue;
                sgHitAtoms[i] = ((Supergraph)enTarget).getAtomIndex(sgHitAtoms[i]);
            }
        } else {
            expanded.aromatize();
            enTarget = expanded;
        }
        return enTarget;
    }

    private boolean isEnumUseful(int[] sgHitAtoms) {
        for (int i = 0; i < sgHitAtoms.length; ++i) {
            int sgHitAtom = sgHitAtoms[i];
            if (sgHitAtom < 0 || this.sg.getParentID(sgHitAtom) == -1) continue;
            return true;
        }
        return false;
    }

    boolean isCompatibleWithAll(int i, int[] hit) {
        for (int j = 0; j < hit.length; ++j) {
            int origAtomIdx = this.atomIdxInAtomsArray[hit[j]];
            if (origAtomIdx < 0 || this.sg.isCompatible(i, origAtomIdx)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean compareHydrogens(int queryAtom, int targetAtom) {
        if (this.isQueryHomologyMode) {
            return super.compareHydrogens(queryAtom, targetAtom);
        }
        int qaIndex = this.sub.atomIdxInAtomsArray[queryAtom];
        if (qaIndex == -1) {
            return true;
        }
        int qAttachments = this.queryAtomAttachNo[qaIndex];
        if (this.atomIdxInAtomsArray[targetAtom] < 0) {
            return true;
        }
        int tMarkushIdx = this.sg.getOrigAtomIndex(this.atomIdxInAtomsArray[targetAtom]);
        int tAttachments = this.numAtomAttach[targetAtom];
        int tPossibleHLigand = this.numOfPossiblyHLigands[targetAtom];
        int posVarNum = this.numPosVar[tMarkushIdx];
        return !(this.searchOptions.isFullFragment() ? qAttachments < tAttachments - tPossibleHLigand || qAttachments > tAttachments + posVarNum : qAttachments > tAttachments + posVarNum);
    }

    @Override
    protected boolean compareAtomTypes(int queryAtom, int targetAtom) {
        int targetAtomIndex = this.atomIdxInAtomsArray[targetAtom];
        int queryAtomIndex = this.sub.atomIdxInAtomsArray[queryAtom];
        if (!this.optIsExactQueryAtomMatching && this.isPseudo(targetAtomIndex) && !this.sub.isPseudo(queryAtomIndex)) {
            String tAlias = this.atoms[targetAtomIndex].getAliasstr().toUpperCase();
            if (this.isExactPseudoMatchingNeeded(tAlias)) {
                return super.compareAtomTypes(queryAtom, targetAtom);
            }
            int tPseudoIdx = MarkushSGSearch.getSpecialPseudoIndex(tAlias);
            int qAtomType = this.sub.matom[queryAtom];
            return MarkushSGSearch.areCompatiblePseudoAndSpecific(tPseudoIdx, qAtomType);
        }
        return super.compareAtomTypes(queryAtom, targetAtom);
    }

    @Override
    protected boolean statCheck() {
        if (this.union != null && SearchUtil.hasMarkushQueryAtom(this.union)) {
            return true;
        }
        return super.statCheck();
    }

    @Override
    protected boolean isPseudoMatching(int queryAtom, int targetAtom) {
        if (this.areMatchingHomologyPseudoAtoms(queryAtom, targetAtom)) {
            return true;
        }
        return super.isPseudoMatching(queryAtom, targetAtom);
    }

    @Override
    protected boolean isSpecialPseudoMatching(int queryAtom, int targetAtom) {
        if (this.areMatchingHomologyPseudoAtoms(queryAtom, targetAtom)) {
            return true;
        }
        return super.isSpecialPseudoMatching(queryAtom, targetAtom);
    }

    private boolean areMatchingHomologyPseudoAtoms(int queryAtom, int targetAtom) {
        if (this.sub.matom[queryAtom] == 136 && this.matom[targetAtom] == 136) {
            String standardTName;
            String standardQName;
            int qAtomIndex = this.sub.atomIdxInAtomsArray[queryAtom];
            int tAtomIndex = this.atomIdxInAtomsArray[targetAtom];
            if (qAtomIndex != -1 && tAtomIndex != -1 && (standardQName = HomologyConstants.getStandardHomologyName(this.sub.atoms[qAtomIndex].getAliasstr())).equals(standardTName = HomologyConstants.getStandardHomologyName(this.atoms[tAtomIndex].getAliasstr()))) {
                return true;
            }
        }
        return false;
    }

    private void getPossiblyHLigands() {
        int atomNum = this.union.getAtomCount();
        this.numOfPossiblyHLigands = new int[atomNum];
        RgMolecule markushRgMol = null;
        if (!(this.markushDiagram instanceof RgMolecule)) {
            return;
        }
        markushRgMol = (RgMolecule)this.markushDiagram;
        block0: for (int i = 0; i < atomNum; ++i) {
            int rgrIndex;
            MolAtom atom = this.union.getAtom(i);
            if (atom.getAtno() != 134 || atom.getBondCount() != 1 || (rgrIndex = markushRgMol.findRgroupIndex(markushRgMol.getAtom(i).getRgroup())) == -1) continue;
            int n = markushRgMol.getRgroupMemberCount(rgrIndex);
            for (int j = 0; j < n; ++j) {
                Molecule def = markushRgMol.getRgroupMember(rgrIndex, j);
                if (!this.isSingleHDefinition(def)) continue;
                MolAtom rAtomLigand = atom.getLigand(0);
                int ligandInd = this.union.indexOf(rAtomLigand);
                if (ligandInd == -1) continue block0;
                int n2 = this.union.indexOf(rAtomLigand);
                this.numOfPossiblyHLigands[n2] = this.numOfPossiblyHLigands[n2] + 1;
                continue block0;
            }
        }
    }

    private boolean isSingleHDefinition(Molecule def) {
        if (def.getAtomCount() == 1 && def.getAtom(0).getAtno() == 1) {
            return true;
        }
        if (def.getAtomCount() == 2 && def.getAtom(0).getAtno() == 1 && def.getAtom(1).getAtno() == 138) {
            return true;
        }
        return def.getAtomCount() == 2 && def.getAtom(1).getAtno() == 1 && def.getAtom(0).getAtno() == 138;
    }

    @Override
    int getSubstitutionCount(int atomIndex, MolAtom atom) throws SearchException {
        if (this.isQueryHomologyMode) {
            return super.getSubstitutionCount(atomIndex, atom);
        }
        return -1;
    }

    @Override
    protected boolean isSubstCountOK(int qInd, int tInd, int tCount) {
        if (this.isQueryHomologyMode || tCount > -1 || this.substCountLength > 0 && this.substCount[tInd] != -1) {
            return super.isSubstCountOK(qInd, tInd, tCount);
        }
        if (!(this.optIsExactQueryAtomMatching || this.sub.substCountLength > 0 && this.sub.substCount[qInd] != -1)) {
            return true;
        }
        if (HomologyConstants.isHomology(this.sg.getAtom(this.atomIdxInAtomsArray[tInd]).getAliasstr())) {
            return true;
        }
        int tSubstCount = -1;
        if (this.optIsExactQueryAtomMatching) {
            int qSubstCount = -1;
            if (this.sub.substCountLength > 0) {
                qSubstCount = this.sub.substCount[qInd];
            }
            if (this.substCountLength > 0 && tInd != -1) {
                tSubstCount = this.numAtomAttach[tInd];
            }
            return qSubstCount == -1 || qSubstCount == tSubstCount;
        }
        if (this.sub.substCountLength > 0 && this.sub.substCount[qInd] != -1) {
            if (HomologyConstants.isHomology(this.sg.getAtom(this.atomIdxInAtomsArray[tInd]).getAliasstr())) {
                return true;
            }
            tSubstCount = tInd != -1 ? this.numAtomAttach[tInd] : tSubstCount;
            int tMarkushIdx = this.getUnionIndex(tInd);
            if (this.sub.substCount[qInd] >= 1000000) {
                int value = this.sub.substCount[qInd] - 1000000;
                int qSubst = value / 1000;
                int qCanBeH = value % 1000;
                return Math.max(qSubst - qCanBeH, tSubstCount - this.numOfPossiblyHLigands[tInd]) <= Math.min(qSubst, tSubstCount + this.numPosVar[tMarkushIdx]);
            }
            int qSubst = this.sub.substCount[qInd];
            if (qSubst == 6) {
                return tSubstCount >= 6;
            }
            return tSubstCount - this.numOfPossiblyHLigands[tInd] <= qSubst && qSubst <= tSubstCount + this.numPosVar[tMarkushIdx];
        }
        return true;
    }

    @Override
    protected boolean isExplConnectionCountOk(int queryAtom, int targetAtom) {
        if (this.isQueryHomologyMode) {
            return super.isConnectionOK(queryAtom, targetAtom);
        }
        if (this.sub.explConnection[queryAtom] == -1) {
            return true;
        }
        if (HomologyConstants.isHomology(this.sg.getAtom(this.atomIdxInAtomsArray[targetAtom]).getAliasstr())) {
            return true;
        }
        if (this.explConnectionLow == null) {
            this.explConnectionLow = ArrayTools.initArray(this.explConnectionLow, this.matomLength, -1);
            this.explConnectionHigh = ArrayTools.initArray(this.explConnectionHigh, this.matomLength, -1);
        }
        if (this.explConnectionLow[targetAtom] == -1) {
            Sgroup[] sgroups;
            int unionIndex = this.sg.getOrigAtomIndex(this.atomIdxInAtomsArray[targetAtom]);
            MolAtom unionAtom = this.union.getAtom(unionIndex);
            unionAtom.setAtno(this.sg.getAtom(this.atomIdxInAtomsArray[targetAtom]).getAtno());
            unionAtom.valenceCheck();
            this.explConnectionLow[targetAtom] = this.explConnectionHigh[targetAtom] = unionAtom.getBondCount();
            for (int neighbor : this.neighbors[targetAtom].toArray()) {
                if (!this.canBeH.get(neighbor = Math.abs(neighbor) - 1)) continue;
                int n = targetAtom;
                this.explConnectionLow[n] = this.explConnectionLow[n] - 1;
                if (this.canBeNonH.get(neighbor)) continue;
                int n2 = targetAtom;
                this.explConnectionHigh[n2] = this.explConnectionHigh[n2] - 1;
            }
            for (Sgroup sgroup : sgroups = this.markushDiagram.findAllSgroupContaining(this.markushDiagram.getAtom(unionIndex))) {
                MulticenterSgroup mgroup;
                int ligandIndex;
                if (!(sgroup instanceof MulticenterSgroup) || !this.canBeH.get(ligandIndex = this.idxAtomInMatomArray[this.markushDiagram.indexOf((mgroup = (MulticenterSgroup)sgroup).getCentralAtom().getLigand(0))])) continue;
                int n = targetAtom;
                this.explConnectionLow[n] = this.explConnectionLow[n] - 1;
                if (this.canBeNonH.get(ligandIndex)) continue;
                int n3 = targetAtom;
                this.explConnectionHigh[n3] = this.explConnectionHigh[n3] - 1;
            }
        }
        return this.explConnectionLow[targetAtom] <= this.sub.explConnection[queryAtom] && this.sub.explConnection[queryAtom] <= this.explConnectionHigh[targetAtom];
    }

    @Override
    protected boolean isConnectionOK(int queryAtom, int targetAtom) {
        if (this.isQueryHomologyMode) {
            return super.isConnectionOK(queryAtom, targetAtom);
        }
        if (this.sub.connection[queryAtom] == -1) {
            return true;
        }
        if (HomologyConstants.isHomology(this.sg.getAtom(this.atomIdxInAtomsArray[targetAtom]).getAliasstr())) {
            return true;
        }
        if (this.connectionLow == null) {
            this.connectionLow = ArrayTools.initArray(this.connectionLow, this.matomLength, -1);
            this.connectionHigh = ArrayTools.initArray(this.connectionHigh, this.matomLength, -1);
        }
        if (this.unionCopy == null) {
            this.unionCopy = this.getUnionCopy();
        }
        if (this.connectionLow[targetAtom] == -1) {
            Sgroup[] sgroups;
            int unionIndex = this.sg.getOrigAtomIndex(this.atomIdxInAtomsArray[targetAtom]);
            MolAtom unionAtom = this.unionCopy.getAtom(unionIndex);
            if (HomologyConstants.isHomology(unionAtom.getAliasstr())) {
                return true;
            }
            unionAtom.setAtno(this.sg.getAtom(this.atomIdxInAtomsArray[targetAtom]).getAtno());
            unionAtom.valenceCheck();
            this.connectionLow[targetAtom] = this.connectionHigh[targetAtom] = unionAtom.getImplicitHcount() + unionAtom.getBondCount();
            unionAtom = this.union.getAtom(unionIndex);
            int bondCount = unionAtom.getBondCount();
            for (int bondIndex = 0; bondIndex < bondCount; ++bondIndex) {
                int[] highLow = this.getConnectionUsageValues(unionAtom.getBond(bondIndex).getType());
                int n = targetAtom;
                this.connectionLow[n] = this.connectionLow[n] - highLow[1];
                int n2 = targetAtom;
                this.connectionHigh[n2] = this.connectionHigh[n2] - highLow[0];
            }
            for (Sgroup sgroup : sgroups = this.markushDiagram.findAllSgroupContaining(this.markushDiagram.getAtom(unionIndex))) {
                if (!(sgroup instanceof MulticenterSgroup)) continue;
                MulticenterSgroup mgroup = (MulticenterSgroup)sgroup;
                int[] highLow = this.getConnectionUsageValues(mgroup.getCentralAtom().getBond(0).getType());
                int n = targetAtom;
                this.connectionLow[n] = this.connectionLow[n] - highLow[1];
                int n3 = targetAtom;
                this.connectionHigh[n3] = this.connectionHigh[n3] - highLow[0];
            }
        }
        return this.connectionLow[targetAtom] <= this.sub.connection[queryAtom] && this.sub.connection[queryAtom] <= this.connectionHigh[targetAtom];
    }

    @Override
    protected boolean isHydrogenOK(int queryAtom, int targetAtom) {
        if (this.isQueryHomologyMode) {
            return super.isHydrogenOK(queryAtom, targetAtom);
        }
        if (this.sub.hydrogen[queryAtom] == -1) {
            return true;
        }
        if (HomologyConstants.isHomology(this.sg.getAtom(this.atomIdxInAtomsArray[targetAtom]).getAliasstr())) {
            return true;
        }
        if (this.hydrogenLow == null) {
            this.hydrogenLow = ArrayTools.initArray(this.hydrogenLow, this.matomLength, -1);
            this.hydrogenHigh = ArrayTools.initArray(this.hydrogenHigh, this.matomLength, -1);
        }
        if (this.unionCopy == null) {
            this.unionCopy = this.getUnionCopy();
        }
        if (this.hydrogenLow[targetAtom] == -1) {
            Sgroup[] sgroups;
            int unionIndex = this.sg.getOrigAtomIndex(this.atomIdxInAtomsArray[targetAtom]);
            MolAtom unionAtom = this.unionCopy.getAtom(unionIndex);
            unionAtom.setAtno(this.sg.getAtom(this.atomIdxInAtomsArray[targetAtom]).getAtno());
            unionAtom.valenceCheck();
            this.hydrogenLow[targetAtom] = this.hydrogenHigh[targetAtom] = unionAtom.getImplicitHcount();
            unionAtom = this.union.getAtom(unionIndex);
            int bondCount = unionAtom.getBondCount();
            for (int bondIndex = 0; bondIndex < bondCount; ++bondIndex) {
                int[] highLow = this.getConnectionUsageValues(unionAtom.getBond(bondIndex).getType());
                int n = targetAtom;
                this.hydrogenLow[n] = this.hydrogenLow[n] - highLow[1];
                int n2 = targetAtom;
                this.hydrogenHigh[n2] = this.hydrogenHigh[n2] - highLow[0];
            }
            for (int neighbor : this.neighbors[targetAtom].toArray()) {
                if (!this.canBeH.get(neighbor = Math.abs(neighbor) - 1)) continue;
                int n = targetAtom;
                this.hydrogenHigh[n] = this.hydrogenHigh[n] + 1;
                if (this.canBeNonH.get(neighbor)) continue;
                int n3 = targetAtom;
                this.hydrogenLow[n3] = this.hydrogenLow[n3] + 1;
            }
            for (Sgroup sgroup : sgroups = this.markushDiagram.findAllSgroupContaining(this.markushDiagram.getAtom(unionIndex))) {
                if (!(sgroup instanceof MulticenterSgroup)) continue;
                MulticenterSgroup mgroup = (MulticenterSgroup)sgroup;
                int[] highLow = this.getConnectionUsageValues(mgroup.getCentralAtom().getBond(0).getType());
                int n = targetAtom;
                this.hydrogenLow[n] = this.hydrogenLow[n] - (highLow[1] + 1);
                int n4 = targetAtom;
                this.hydrogenHigh[n4] = this.hydrogenHigh[n4] - (highLow[0] + 1);
                int ligandIndex = this.idxAtomInMatomArray[this.markushDiagram.indexOf(mgroup.getCentralAtom().getLigand(0))];
                if (!this.canBeH.get(ligandIndex)) continue;
                int n5 = targetAtom;
                this.hydrogenHigh[n5] = this.hydrogenHigh[n5] + 1;
                if (this.canBeNonH.get(ligandIndex)) continue;
                int n6 = targetAtom;
                this.hydrogenLow[n6] = this.hydrogenLow[n6] + 1;
            }
        }
        return this.sub.hydrogenGreaterRelation[queryAtom] == 61 && this.sub.hydrogen[queryAtom] >= this.hydrogenLow[targetAtom] && this.sub.hydrogen[queryAtom] <= this.hydrogenHigh[targetAtom] || this.sub.hydrogenGreaterRelation[queryAtom] == 62 && this.sub.hydrogen[queryAtom] <= this.hydrogenHigh[targetAtom];
    }

    @Override
    protected boolean isRingBondCountOk(int queryAtom, int targetAtom) {
        if (this.isQueryHomologyMode) {
            return super.isRingBondCountOk(queryAtom, targetAtom);
        }
        if (this.sub.ringBondCount[queryAtom] == -1) {
            return true;
        }
        if (HomologyConstants.isHomology(this.sg.getAtom(this.atomIdxInAtomsArray[targetAtom]).getAliasstr())) {
            return true;
        }
        if (this.mringBondCount == null) {
            this.mringBondCount = ArrayTools.initArray(this.mringBondCount, this.matomLength, -1);
            this.bondClassifier = new RgMoleculeBondClassifier();
            this.bondClassifier.classify(this.markushDiagram);
        }
        if (this.mringBondCount[targetAtom] == -1) {
            this.mringBondCount[targetAtom] = 0;
            int unionIndex = this.sg.getOrigAtomIndex(this.atomIdxInAtomsArray[targetAtom]);
            for (int ligand : this.neighbors[targetAtom].toArray()) {
                if (this.bondClassifier.getRingmembershipOfBond(unionIndex, Math.abs(ligand) - 1, this.walks[targetAtom]) != RingMembership.IN_RING) continue;
                int n = targetAtom;
                this.mringBondCount[n] = this.mringBondCount[n] + 1;
            }
        }
        int rbQ = this.sub.ringBondCount[queryAtom];
        int rbT = this.mringBondCount[targetAtom];
        if (rbQ >= 1000) {
            return (rbQ -= 1000) == rbT;
        }
        if (rbQ > 4) {
            rbQ = 4;
        }
        return rbQ == 4 && rbT >= 4 || rbQ == rbT;
    }

    @Override
    protected boolean isRingCountOk(int queryAtom, int targetAtom) {
        if (this.isQueryHomologyMode) {
            return super.isRingCountOk(queryAtom, targetAtom);
        }
        if (this.sub.ringCount[queryAtom] == -1) {
            return true;
        }
        if (HomologyConstants.isHomology(this.sg.getAtom(this.atomIdxInAtomsArray[targetAtom]).getAliasstr())) {
            return true;
        }
        if (this.mringCount == null) {
            this.mringCount = ArrayTools.initArray(this.mringCount, this.matomLength, -1);
            this.markushRings = ArrayTools.initArray(this.markushRings, this.union.getAtomCount(), 0);
            if (this.rings == null) {
                this.rings = this.getSSR(this.union);
            }
            for (int ringIndex = 0; ringIndex < this.rings.length; ++ringIndex) {
                for (int memberIndex = 0; memberIndex < this.rings[ringIndex].length; ++memberIndex) {
                    int n = this.rings[ringIndex][memberIndex];
                    this.markushRings[n] = this.markushRings[n] + 1;
                }
            }
            this.molSPaths = new HashMap();
        }
        if (this.mringCount[targetAtom] == -1) {
            this.mringCount[targetAtom] = 0;
            int[] walk = this.walks[targetAtom];
            ShortestPath sp = null;
            MolAtom parentAtom = null;
            MolAtom atom = null;
            boolean onShortestPath = true;
            for (int walkIndex = walk.length - 2; walkIndex >= 0 && onShortestPath; --walkIndex) {
                onShortestPath = false;
                parentAtom = this.markushDiagram.getAtom(walk[walkIndex]);
                if (parentAtom.getAtno() != 134) continue;
                MoleculeGraph mg = parentAtom.getParent();
                if (this.molSPaths.containsKey(mg)) {
                    sp = this.molSPaths.get(mg);
                } else {
                    sp = new ShortestPath();
                    sp.calculate(mg);
                    this.molSPaths.put(mg, sp);
                }
                MolAtom[] matoms = mg.getAtomArray();
                int[] path = new int[matoms.length];
                int pathLength = 0;
                for (int i = 0; i < matoms.length; ++i) {
                    if (matoms[i].getAtno() != 138) continue;
                    for (int j = i + 1; j < matoms.length; ++j) {
                        if (matoms[j].getAtno() != 138) continue;
                        pathLength = sp.getPath(i, j, path);
                        for (int pathIndex = 0; pathIndex < pathLength; ++pathIndex) {
                            if (mg.getAtom(path[pathIndex]) != parentAtom) continue;
                            onShortestPath = true;
                        }
                    }
                }
                atom = this.markushDiagram.getAtom(walk[walkIndex + 1]);
                mg = atom.getParent();
                matoms = mg.getAtomArray();
                if (this.molSPaths.containsKey(mg)) {
                    sp = this.molSPaths.get(mg);
                } else {
                    sp = new ShortestPath();
                    sp.calculate(mg);
                    this.molSPaths.put(mg, sp);
                }
                for (int ringIndex = 0; ringIndex < this.rings.length; ++ringIndex) {
                    if (!ArrayTools.contains(this.rings[ringIndex], walk[walkIndex])) continue;
                    MolAtom[] atoms = parentAtom.getLigands();
                    for (int i = 0; i < atoms.length; ++i) {
                        for (int j = i + 1; j < atoms.length; ++j) {
                            if (!ArrayTools.contains(this.rings[ringIndex], this.markushDiagram.indexOf(atoms[i])) || !ArrayTools.contains(this.rings[ringIndex], this.markushDiagram.indexOf(atoms[j]))) continue;
                            int att1 = parentAtom.getLigandOrder(atoms[i]);
                            int att2 = parentAtom.getLigandOrder(atoms[j]);
                            int ma1 = 0;
                            int ma2 = 0;
                            for (MolAtom a : matoms) {
                                if (a.getAtno() != 138) continue;
                                if (a.getRgroupAttachmentPointOrder() == att1) {
                                    ma1 = mg.indexOf(a);
                                }
                                if (a.getRgroupAttachmentPointOrder() != att2) continue;
                                ma2 = mg.indexOf(a);
                            }
                            path = new int[matoms.length];
                            pathLength = sp.getPath(ma1, ma2, path);
                            for (int pathIndex = 0; pathIndex < pathLength; ++pathIndex) {
                                if (mg.getAtom(path[pathIndex]) != atom) continue;
                                int n = targetAtom;
                                this.mringCount[n] = this.mringCount[n] + 1;
                            }
                        }
                    }
                }
            }
        }
        return this.sub.ringCount[queryAtom] == this.mringCount[targetAtom] + this.markushRings[this.sg.getOrigAtomIndex(this.atomIdxInAtomsArray[targetAtom])];
    }

    @Override
    protected boolean isSmallestRingSizeOk(int queryAtom, int targetAtom) {
        if (this.isQueryHomologyMode) {
            return super.isSmallestRingSizeOk(queryAtom, targetAtom);
        }
        if (this.sub.smallestRingSize[queryAtom] == -1) {
            return true;
        }
        if (HomologyConstants.isHomology(this.sg.getAtom(this.atomIdxInAtomsArray[targetAtom]).getAliasstr())) {
            return true;
        }
        if (this.ringSize == null) {
            this.ringSize = ArrayTools.initArray(this.ringSize, this.matomLength, -1);
            if (this.rings == null) {
                this.rings = this.getSSR(this.union);
            }
            this.markushRingSize = ArrayTools.initArray(this.markushRingSize, this.union.getAtomCount(), 0);
            for (int ringIndex = 0; ringIndex < this.rings.length; ++ringIndex) {
                for (int memberIndex = 0; memberIndex < this.rings[ringIndex].length; ++memberIndex) {
                    if (this.markushRingSize[this.rings[ringIndex][memberIndex]] != 0 && this.markushRingSize[this.rings[ringIndex][memberIndex]] <= this.rings[ringIndex].length) continue;
                    this.markushRingSize[this.rings[ringIndex][memberIndex]] = this.rings[ringIndex].length;
                }
            }
            this.molSPaths = new HashMap();
        }
        if (this.ringSize[targetAtom] == -1) {
            int[] walk = this.walks[targetAtom];
            this.ringSize[targetAtom] = this.markushRingSize[walk[walk.length - 1]];
            ShortestPath sp = null;
            MolAtom parentAtom = null;
            MolAtom atom = null;
            boolean onShortestPath = true;
            int[][] act = new int[10][10];
            for (int walkIndex = walk.length - 2; walkIndex >= 0 && onShortestPath; --walkIndex) {
                int[][] prev = act;
                act = new int[10][10];
                onShortestPath = false;
                parentAtom = this.markushDiagram.getAtom(walk[walkIndex]);
                if (parentAtom.getAtno() != 134) continue;
                MoleculeGraph mg = parentAtom.getParent();
                if (this.molSPaths.containsKey(mg)) {
                    sp = this.molSPaths.get(mg);
                } else {
                    sp = new ShortestPath();
                    sp.calculate(mg);
                    this.molSPaths.put(mg, sp);
                }
                MolAtom[] matoms = mg.getAtomArray();
                int[] path = new int[matoms.length];
                int pathLength = 0;
                for (int i = 0; i < matoms.length; ++i) {
                    if (matoms[i].getAtno() != 138) continue;
                    for (int j = i + 1; j < matoms.length; ++j) {
                        if (matoms[j].getAtno() != 138) continue;
                        pathLength = sp.getPath(i, j, path);
                        for (int pathIndex = 0; pathIndex < pathLength; ++pathIndex) {
                            if (mg.getAtom(path[pathIndex]) != parentAtom) continue;
                            act[i][j] = prev[i][j] + pathLength - 2;
                            act[j][i] = prev[j][i] + pathLength - 2;
                            onShortestPath = true;
                        }
                    }
                }
                atom = this.markushDiagram.getAtom(walk[walkIndex + 1]);
                mg = atom.getParent();
                matoms = mg.getAtomArray();
                if (this.molSPaths.containsKey(mg)) {
                    sp = this.molSPaths.get(mg);
                } else {
                    sp = new ShortestPath();
                    sp.calculate(mg);
                    this.molSPaths.put(mg, sp);
                }
                for (int ringIndex = 0; ringIndex < this.rings.length; ++ringIndex) {
                    if (!ArrayTools.contains(this.rings[ringIndex], walk[walkIndex])) continue;
                    MolAtom[] atoms = parentAtom.getLigands();
                    for (int i = 0; i < atoms.length; ++i) {
                        for (int j = i + 1; j < atoms.length; ++j) {
                            if (!ArrayTools.contains(this.rings[ringIndex], this.markushDiagram.indexOf(atoms[i])) || !ArrayTools.contains(this.rings[ringIndex], this.markushDiagram.indexOf(atoms[j]))) continue;
                            int att1 = parentAtom.getLigandOrder(atoms[i]);
                            int att2 = parentAtom.getLigandOrder(atoms[j]);
                            int ma1 = 0;
                            int ma2 = 0;
                            for (MolAtom a : matoms) {
                                if (a.getAtno() != 138) continue;
                                if (a.getRgroupAttachmentPointOrder() == att1) {
                                    ma1 = mg.indexOf(a);
                                }
                                if (a.getRgroupAttachmentPointOrder() != att2) continue;
                                ma2 = mg.indexOf(a);
                            }
                            path = new int[matoms.length];
                            pathLength = sp.getPath(ma1, ma2, path);
                            for (int pathIndex = 0; pathIndex < pathLength; ++pathIndex) {
                                if (mg.getAtom(path[pathIndex]) != atom) continue;
                                int size = this.rings[ringIndex].length - 1 + act[att1][att2] + pathLength - 2;
                                if (this.ringSize[targetAtom] != 0 && this.ringSize[targetAtom] <= size) continue;
                                this.ringSize[targetAtom] = size;
                            }
                        }
                    }
                }
            }
        }
        return this.sub.smallestRingSize[queryAtom] == this.ringSize[targetAtom];
    }

    @Override
    protected int[][] getSSR() {
        if (this.isQueryHomologyMode) {
            return super.getSSR();
        }
        return null;
    }

    private int[][] getSSR(MoleculeGraph mg) {
        switch (this.searchOptions.getSSRType()) {
            case CSSR: {
                return mg.getCSSR();
            }
            case SSSR: {
                return mg.getSSSR();
            }
        }
        return mg.getSSSR();
    }

    private MoleculeGraph getUnionCopy() {
        MolBond[] bonds;
        MoleculeGraph unionCopy = new MoleculeGraph();
        this.union.clonecopy(unionCopy);
        for (MolBond bond : bonds = unionCopy.getBondArray()) {
            bond.setType(1);
        }
        return unionCopy;
    }

    private int getAtomAttachNo(MolAtom qma, boolean isQuery) {
        int bondCount = qma.getBondCount();
        int attNo = isQuery ? bondCount : MolImportUtil.countBondsAndAttachments(qma);
        for (int i = 0; i < bondCount; ++i) {
            MolAtom neighbour = qma.getLigand(i);
            int atno = neighbour.getAtno();
            if ((atno != 1 || !MolHandler.isPlainH(neighbour)) && atno != 130) continue;
            --attNo;
        }
        return attNo;
    }

    private int getAtomAttachNo2(int matomIndex, boolean isQuery) {
        MolAtom atom = this.sg.getAtom(matomIndex);
        int attNo = isQuery ? atom.getBondCount() : this.neighbors[matomIndex].size();
        int[] arr$ = this.neighbors[matomIndex].toArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer neighborIndex = arr$[i$];
            MolAtom ligand = this.union.getAtom((neighborIndex = Integer.valueOf(Math.abs(neighborIndex))) - 1);
            int atno = ligand.getAtno();
            if (atno != 130) continue;
            --attNo;
        }
        return attNo;
    }

    @Override
    protected int[] getFragIds() {
        int[] ctab = new int[this.matomLength];
        int compIndex = 0;
        for (int matomIndex = 0; matomIndex < this.matomLength; ++matomIndex) {
            if (ctab[matomIndex] != 0) continue;
            ctab[matomIndex] = ++compIndex;
            LinkedList<Integer> q = new LinkedList<Integer>();
            q.add(matomIndex);
            while (!q.isEmpty()) {
                int bondOffset;
                int mIndex = (Integer)q.remove();
                int bondNum = this.abonds[mIndex];
                for (int bondIndex = bondOffset = this.bondidx[mIndex]; bondIndex < bondOffset + bondNum; ++bondIndex) {
                    if (ctab[this.bto[bondIndex]] != 0) continue;
                    ctab[this.bto[bondIndex]] = compIndex;
                    q.add(this.bto[bondIndex]);
                }
            }
        }
        return ctab;
    }

    @Override
    protected boolean setChiralNeighbors(int i) {
        boolean success = false;
        int chAtomIdx = this.idx[i] - 1;
        int unionIdx = this.getUnionIndex(chAtomIdx);
        if (unionIdx < 0) {
            return true;
        }
        MolAtom origChAtom = this.union.getAtom(unionIdx);
        boolean implH = false;
        int nSet = 0;
        try {
            success = super.setChiralNeighboursFromMolecule(i);
        }
        catch (StructureSearch.ParityCannotBeEvaluatedYetException e) {
            nSet = Integer.parseInt(e.getMessage());
            implH = true;
            success = true;
        }
        if (!success) {
            return false;
        }
        block4: for (int j = 0; j < (implH ? 3 : 4); ++j) {
            if (this.chneib[j] == Integer.MAX_VALUE) continue;
            int[] origAtoms = this.sg.getGraphUnionWalk(this.chneib[j]);
            for (int k = 0; k < origAtoms.length; ++k) {
                int origIdx = origAtoms[k];
                MolAtom ma = this.union.getAtom(origIdx);
                if (!ma.isBoundTo(origChAtom)) continue;
                this.chneib[j] = origIdx;
                continue block4;
            }
            throw new RuntimeException("Could not assign neighbour " + j + " of Markush atom " + chAtomIdx + " matching to " + "query atom " + i);
        }
        if (implH) {
            try {
                this.addImplHChiralNeighbours(nSet, origChAtom, this.union);
            }
            catch (StructureSearch.ParityCannotBeEvaluatedYetException e1) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void initDBStereo(boolean isDaylightFormat) {
        if (this._IAmTheQuery) {
            super.initDBStereo(isDaylightFormat);
            return;
        }
        this.sub.initDBSWaitsFor();
    }

    @Override
    protected boolean compareCT(int queryBond, int targetBond) {
        return true;
    }

    private boolean checkDBSInTheMiddle(int d) {
        if (this.searchOptions.getStereoSearchType() == 1 || !this.sub.hasDoubleBondStereo && this.searchOptions.getStereoSearchType() != 2 || this.searchOptions.getDoubleBondStereoMatchingMode() == 2) {
            return true;
        }
        int index = ArrayTools.binarySearchForFirst(this.sub.dBSWaitsFor, d, 0, this.sub.ctiRecordsLength - 1);
        if (index >= 0) {
            int n = this.depth;
            this.idx[n] = this.idx[n] + 1;
            while (index < this.sub.ctiRecordsLength && this.sub.dBSWaitsFor[index] == d) {
                int dbRecord = this.sub.dBSRecord[index];
                if (!this.checkCTUsingIdx(dbRecord)) {
                    int n2 = this.depth;
                    this.idx[n2] = this.idx[n2] - 1;
                    return false;
                }
                ++index;
            }
            int n3 = this.depth;
            this.idx[n3] = this.idx[n3] - 1;
        }
        return true;
    }

    private boolean checkCTUsingIdx(int dbRecordIdx) {
        int ta4;
        int ta3;
        int ta2;
        int ta1;
        int qDBIdx = this.sub.ctiRecords[dbRecordIdx * 4 + 0];
        int a1 = this.sub.ctiRecords[dbRecordIdx * 4 + 1];
        int a2 = this.sub.bFrom[qDBIdx];
        int a3 = this.sub.bto[qDBIdx];
        int a4 = this.sub.ctiRecords[dbRecordIdx * 4 + 2];
        int qct = this.sub.ctiRecords[dbRecordIdx * 4 + 3];
        if (!this.isConnectedInQ(a1, a2)) {
            int t = a2;
            a2 = a3;
            a3 = t;
        }
        if (this.canSkipCTChecking(ta1 = this.idx[a1] - 1, ta2 = this.idx[a2] - 1, ta3 = this.idx[a3] - 1, ta4 = this.idx[a4] - 1)) {
            return true;
        }
        int sga1 = this.atomIdxInAtomsArray[ta1];
        int sga2 = this.atomIdxInAtomsArray[ta2];
        int sga3 = this.atomIdxInAtomsArray[ta3];
        int sga4 = this.atomIdxInAtomsArray[ta4];
        int tct = this.sg.getStereo2(sga1, sga2, sga3, sga4);
        if (this.checkBondInMarkush(ta2, ta3)) {
            return true;
        }
        return this.areMatchingCTITypes(qct, tct);
    }

    private boolean checkBondInMarkush(int ta2, int ta3) {
        int[] rgParents2 = new int[]{this.getUnionIndex(ta2)};
        int[] rgParents3 = new int[]{this.getUnionIndex(ta3)};
        int[] sgInd2 = new int[]{ta2};
        int[] sgInd3 = new int[]{ta3};
        rgParents2 = this.getRgParents(rgParents2, sgInd2);
        rgParents3 = this.getRgParents(rgParents3, sgInd3);
        for (int at2 : rgParents2) {
            for (int at3 : rgParents3) {
                MolAtom atom3;
                MolAtom atom2 = this.markushDiagram.getAtom(at2);
                MolBond bond = atom2.getBondTo(atom3 = this.markushDiagram.getAtom(at3));
                if (bond == null) continue;
                return bond.getType() != 2;
            }
        }
        return false;
    }

    protected boolean canSkipCTChecking(int ta1, int ta2, int ta3, int ta4) {
        return false;
    }

    private boolean isConnectedInQ(int a1, int a2) {
        int bi = this.sub.bondidx[a1];
        for (int i = 0; i < this.sub.abonds[a1]; ++i) {
            if (this.sub.bto[bi + i] != a2) continue;
            return true;
        }
        return false;
    }

    private final int getUnionIndex(int atom) {
        if (atom < 0) {
            return atom;
        }
        if (this.atomIdxInAtomsArray[atom] < 0) {
            return this.atomIdxInAtomsArray[atom];
        }
        int atom_sg = this.atomIdxInAtomsArray[atom];
        return this.sg.getHomologyConvertedIndex(atom_sg);
    }

    @Override
    int getExplicitBondCount(int targetAtom) {
        int edgeCount;
        int sgAtomsIdx = this.atomIdxInAtomsArray[targetAtom];
        if (sgAtomsIdx < 0) {
            edgeCount = 0;
        } else {
            int atomIdx = this.getUnionIndex(targetAtom);
            MolAtom ma = this.union.getAtom(atomIdx);
            edgeCount = MolImportUtil.countBondsAndAttachments(ma);
        }
        return edgeCount;
    }

    @Override
    protected RingClassifier getTargetRingClassifier() {
        return new SupergraphBondClassifier();
    }

    @Override
    protected int getTargetAromaticity(int atomIdx) {
        int sgAtom = this.atomIdxInAtomsArray[atomIdx];
        if (sgAtom >= 0 && this.sg.isAmbiguousAromaticAtom(sgAtom)) {
            this.hasAmbigArom = true;
            return 3;
        }
        return super.getTargetAromaticity(atomIdx);
    }

    @Override
    protected boolean compareBondType(int queryBond, int targetBond) {
        if (super.compareBondType(queryBond, targetBond)) {
            return true;
        }
        if (this.searchOptions.getMarkushArom() != 2) {
            int ta2;
            int ta1;
            int qbt = this.sub.btyp[queryBond];
            int tbt = this.btyp[targetBond];
            if (tbt != 4 && this.isQueryAromaticType(qbt) && this.sg.isAmbiguousAromaticBond(ta1 = this.atomIdxInAtomsArray[this.bFrom[targetBond]], ta2 = this.atomIdxInAtomsArray[this.bto[targetBond]])) {
                return true;
            }
        }
        return false;
    }

    private boolean isQueryAromaticType(int qbt) {
        return qbt == 4 || qbt == 6 || qbt == 7;
    }

    @Override
    protected boolean statBondCheck() {
        boolean r = true;
        for (int i = 1; i <= 3; ++i) {
            if (this.sub.stat_bondTypeCounts[i] <= this.stat_bondTypeCounts[i]) continue;
            r = false;
        }
        return r;
    }

    @Override
    protected Molecule getTargetToPrint() {
        return this.addAmbig(super.getTargetToPrint());
    }

    private Molecule addAmbig(Molecule queryToPrint) {
        if (!this.hasAmbigArom) {
            return queryToPrint;
        }
        Molecule m = (Molecule)queryToPrint.clone();
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom ma = m.getAtom(i);
            String k = AromUtil.getFirstAmbigAromRingMarker(ma);
            if (k == null) continue;
            ma.setQProp("R", AromUtil.getAmbigAromRingMarkerIndex(k));
        }
        return m;
    }

    @Override
    protected void addToHit(int q, int t) {
        int g;
        int tID;
        if (logger.isLoggable(Level.FINE) && this.sub.queryRearrangedToOrig != null && this.sub.atomIdxInAtomsArray[q] > -1 && this.atomIdxInAtomsArray[t] > -1) {
            logger.fine("Added to hit: non-rearr q -" + (this.sub.queryRearrangedToOrig[this.sub.atomIdxInAtomsArray[q]] + 1) + " markush t-" + (this.sg.getOrigAtomIndex(this.atomIdxInAtomsArray[t]) + 1));
        }
        super.addToHit(q, t);
        if (t >= this.atomIdxInAtomsArrayLength) {
            return;
        }
        int sgT = this.atomIdxInAtomsArray[t];
        if (sgT == -1) {
            return;
        }
        int c = tID = this.sg.getID(sgT);
        int p = this.sg.getParentIDByID(c);
        while (p != -1 && this.addParentAndGroup(p, g = this.sg.getGroupByID(c)) <= 1) {
            this.removeSiblings(p, g);
            c = p;
            p = this.sg.getParentIDByID(c);
        }
    }

    private final void removeSiblings(int p, int g) {
        int[] childrenIDs = this.sg.getChildrenIDs(p);
        for (int i = 0; i < childrenIDs.length; ++i) {
            int childID = childrenIDs[i];
            int cG = this.sg.getGroupByID(childID);
            if (cG == g) continue;
            this.removeDescendants(childID);
        }
    }

    private final void removeDescendants(int p) {
        IntVector descV = new IntVector();
        descV.add(p);
        while (!descV.isEmpty()) {
            int desc = descV.removeLast();
            int[] childrenIDs = this.sg.getChildrenIDs(desc);
            if (childrenIDs.length == 0) {
                int tAtom = this.idxAtomInMatomArray[this.sg.getAtomIndex(desc)];
                if (tAtom == -1) continue;
                this.clearColumn(tAtom);
                continue;
            }
            for (int i = 0; i < childrenIDs.length; ++i) {
                int childrenID = childrenIDs[i];
                descV.add(childrenID);
            }
        }
    }

    private int addParentAndGroup(int tP, int tG) {
        Integer tPI = tP;
        Integer o = this.currentHitParentsGrCounts.get(tPI);
        if (o == null) {
            this.currentHitParentsGrCounts.put(tPI, 1);
            return 1;
        }
        int c = o;
        this.currentHitParentsGrCounts.put(tPI, ++c);
        return c;
    }

    private int removeParentAndGroup(int tP, int tG) {
        int c = -1;
        Integer tPI = tP;
        Integer o = this.currentHitParentsGrCounts.get(tPI);
        if (o != null) {
            c = o;
            if (--c == 0) {
                this.currentHitParentsGrCounts.remove(tPI);
            } else {
                this.currentHitParentsGrCounts.put(tPI, c);
            }
        }
        return c;
    }

    @Override
    protected void removeFromHit(int q, int t, boolean afterHit) {
        super.removeFromHit(q, t, afterHit);
        if (t >= this.atomIdxInAtomsArrayLength) {
            return;
        }
        int sgT = this.atomIdxInAtomsArray[t];
        if (sgT == -1) {
            return;
        }
        int c = this.sg.getID(sgT);
        int p = this.sg.getParentIDByID(c);
        while (p != -1) {
            int g = this.sg.getGroupByID(c);
            this.removeParentAndGroup(p, g);
            c = p;
            p = this.sg.getParentIDByID(c);
        }
    }

    @Override
    public void setQuery(Molecule mol) {
        String error;
        String string = error = this.isQueryHomologyMode ? null : this.checkQueryFeatures(mol);
        if (error != null) {
            if ("R-group query".equals(error)) {
                error = error + " with R-logic, nested R-groups or more then 100 enumerates";
            }
            throw new IllegalArgumentException("Markush search error:" + error + " is not supported.");
        }
        if (!this.isQueryHomologyMode && this.searchOptions.getImplicitHMatching() != 2) {
            super.setQuery(mol);
            this.sub.convertExplHToHCount = true;
        } else {
            super.setQuery(mol);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String checkSmartsAtomTree(SimpleNode node) {
        switch (node.getId()) {
            case 8: {
                return "unsupported SMARTS atom";
            }
            case 5: {
                switch (node.getValue().charAt(0)) {
                    case 'D': 
                    case 'H': 
                    case 'S': 
                    case 'X': 
                    case 'c': 
                    case 'h': 
                    case 'r': 
                    case 'u': 
                    case 'v': {
                        return "unsupported SMARTS atom: " + node.getValue().charAt(0);
                    }
                    case 'R': {
                        int num;
                        if (node.getValue().length() <= 1 || (num = Integer.parseInt(node.getValue().substring(1))) <= 0) break;
                        return "unsupported SMARTS atom " + node.getValue().charAt(0);
                    }
                }
                break;
            }
        }
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            if (this.checkSmartsAtomTree((SimpleNode)node.jjtGetChild(i)) != null) {
                return "unsupported SMARTS atom";
            }
            ++i;
        }
        return null;
    }

    private String checkQueryFeatures(Molecule mol) {
        Molecule smol = mol.getSimplifiedMolecule();
        if (smol instanceof RgMolecule) {
            RgMolecule rgSmol = (RgMolecule)smol;
            int enumCount = 1;
            HashSet rgroupsFound = new HashSet();
            for (int a = rgSmol.getAtomCount() - 1; a >= 0; --a) {
                if (rgSmol.getAtom(a).getAtno() != 134) continue;
                int enumNodeCount = 0;
                for (int r = rgSmol.getRgroupCount() - 1; r >= 0; --r) {
                    int rgIndex = rgSmol.getRgroupIndex(r);
                    if (rgroupsFound.contains(rgIndex) || !">0".equals(rgSmol.getRlogicRange(rgIndex)) || rgSmol.getRlogic(rgIndex) != rgSmol.getRgroupId(rgIndex)) {
                        return "R-group query";
                    }
                    for (int memberIndex = rgSmol.getRgroupMemberCount(rgIndex) - 1; memberIndex >= 0; --memberIndex) {
                        ++enumNodeCount;
                        Molecule member = rgSmol.getRgroupMember(r, memberIndex);
                        for (int atomIndex = member.getAtomCount() - 1; atomIndex >= 0; --atomIndex) {
                            if (member.getAtom(atomIndex).getAtno() != 134) continue;
                            return "R-group query";
                        }
                    }
                }
                enumCount *= Math.max(1, enumNodeCount);
            }
            if (enumCount > 100) {
                return "R-group query";
            }
        }
        if (smol instanceof RxnMolecule) {
            return "Reaction query";
        }
        int atomCount = mol.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            MolAtom ma = mol.getAtom(i);
            if (ma.getAtno() == 130) {
                return "Explicit lone pair";
            }
            if (ma.getQuerystr() != null) {
                String queryStr = ma.getQuerystr();
                StringReader sr = new StringReader(queryStr);
                SmartsAtomTreeParser parser = new SmartsAtomTreeParser(sr);
                try {
                    SimpleNode smartsAtomTree = parser.parseSmartsAtomExpression();
                    String treeCheckResult = this.checkSmartsAtomTree(smartsAtomTree);
                    if (treeCheckResult != null) {
                        return treeCheckResult;
                    }
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            String[] qPropNames = ma.getQPropNames();
            for (int j = 0; j < qPropNames.length; ++j) {
                String qProp = qPropNames[j];
                if (qProp.startsWith("VMN") || qProp.startsWith("rgsearch") || ArrayTools.indexInArray(supportedQueryFeatures, supportedQueryFeatures.length, qProp) != -1) continue;
                return "Query property " + qProp + ma.getQPropAsInt(qProp);
            }
        }
        return null;
    }

    @Override
    protected boolean isMultivalent(int targetAtom, boolean isTetrahedral) {
        int unionIdx = this.getUnionIndex(targetAtom);
        if (unionIdx < 0) {
            return false;
        }
        MolAtom origAtom = this.union.getAtom(unionIdx);
        int bNum = origAtom.getBondCount();
        if (bNum == 0) {
            bNum += MolImportUtil.countSingleAtomAttachments(origAtom);
        }
        return isTetrahedral ? bNum > 4 : (bNum += origAtom.getImplicitHcount()) > 3;
    }

    @Override
    protected void initMolecule() throws SearchException {
        super.initMolecule();
        if (!this._IAmTheQuery) {
            this.queryAtomAttachNo = new int[this.sub.atomsLength];
            for (int i = 0; i < this.sub.atomsLength; ++i) {
                this.queryAtomAttachNo[i] = this.getAtomAttachNo(this.sub.atoms[i], true);
            }
        }
        this.clearArrays();
        this.initNeighbors();
        this.initAtomAttachNo();
        this.initPossiblyHLigands();
        this.initPosVarNum();
        this.correctAtomAttachNo();
        if (!this._IAmTheQuery && logger.isLoggable(Level.FINE)) {
            this.logSGMarkushMap();
        }
    }

    private void clearArrays() {
        this.neighbors = null;
        this.unsaturated = null;
        this.unionCopy = null;
        this.explConnectionLow = null;
        this.explConnectionHigh = null;
        this.connectionLow = null;
        this.connectionHigh = null;
        this.hydrogenLow = null;
        this.hydrogenHigh = null;
        this.mringBondCount = null;
        this.bondClassifier = null;
        this.mringCount = null;
        this.rings = null;
        this.markushRings = null;
        this.molSPaths = null;
        this.ringSize = null;
        this.markushRingSize = null;
        this.canBeH = null;
        this.canBeNonH = null;
        this.largerUserDefinitions = null;
    }

    private void initNeighbors() {
        int atomIndex;
        this.neighbors = new IntArrayIntSet[this.matomLength];
        this.walks = new int[this.matomLength][];
        for (int matomIndex = 0; matomIndex < this.matomLength; ++matomIndex) {
            atomIndex = this.atomIdxInAtomsArray[matomIndex];
            this.walks[matomIndex] = atomIndex != -1 ? this.sg.getGraphUnionWalk(atomIndex) : new int[0];
        }
        MolAtom[] atoms = this.markushDiagram.getAtomArray();
        Sgroup[] sgroups = this.markushDiagram.getSgroupArray();
        HashMap<Integer, BitSet> atomSgroups = new HashMap<Integer, BitSet>();
        for (int sgroupIndex = 0; sgroupIndex < sgroups.length; ++sgroupIndex) {
            MolAtom[] sgroupatoms;
            for (MolAtom atom : sgroupatoms = sgroups[sgroupIndex].getAtomArray()) {
                atomIndex = this.markushDiagram.indexOf(atom);
                if (!atomSgroups.containsKey(atomIndex)) {
                    atomSgroups.put(atomIndex, new BitSet(sgroups.length));
                }
                ((BitSet)atomSgroups.get(atomIndex)).set(sgroupIndex, true);
            }
        }
        for (int matomIndex = 0; matomIndex < this.matomLength; ++matomIndex) {
            int bondNum = this.abonds[matomIndex];
            int bondOffset = this.bondidx[matomIndex];
            this.neighbors[matomIndex] = new IntArrayIntSet(bondNum);
            if (this.walks[matomIndex] == null || this.walks[matomIndex].length == 0) continue;
            for (int bondIndex = bondOffset; bondIndex < bondOffset + bondNum; ++bondIndex) {
                int walkIndex;
                int[] walk = this.walks[this.bto[bondIndex]];
                if (walk == null || walk.length == 0) continue;
                for (walkIndex = 0; walkIndex < Math.min(this.walks[matomIndex].length, walk.length) && this.walks[matomIndex][walkIndex] == walk[walkIndex]; ++walkIndex) {
                }
                if (walkIndex < walk.length) {
                    if (this.neighbors[matomIndex].contains(walk[walkIndex] + 1)) {
                        int atomIndex2;
                        int atomIndex1 = walk[walkIndex];
                        int n = atomIndex2 = this.walks[matomIndex].length > walkIndex ? this.walks[matomIndex][walkIndex] : this.walks[matomIndex][this.walks[matomIndex].length - 1];
                        if (atoms[atomIndex1].getBondTo(atoms[atomIndex2]) == null) continue;
                        BitSet bitset1 = (BitSet)atomSgroups.get(atomIndex1);
                        BitSet bitset2 = (BitSet)atomSgroups.get(atomIndex2);
                        if (bitset1 == null || bitset2 == null || !bitset1.intersects(bitset2)) continue;
                        this.neighbors[matomIndex].add(-walk[walkIndex] - 1);
                        continue;
                    }
                    this.neighbors[matomIndex].add(walk[walkIndex] + 1);
                    continue;
                }
                if (walkIndex != walk.length) continue;
                if (this.neighbors[matomIndex].contains(walk[walkIndex - 1] + 1)) {
                    if (this.walks[matomIndex][walkIndex - 1] != walk[walkIndex - 1]) continue;
                    this.neighbors[matomIndex].add(-walk[walkIndex - 1] - 1);
                    continue;
                }
                this.neighbors[matomIndex].add(walk[walkIndex - 1] + 1);
            }
            this.neighbors[matomIndex].compact();
        }
        atomSgroups.clear();
        atomSgroups = null;
    }

    private void initAtomAttachNo() {
        this.numAtomAttach = new int[this.matomLength];
        for (int matomIndex = 0; matomIndex < this.matomLength; ++matomIndex) {
            int atomIndex = this.atomIdxInAtomsArray[matomIndex];
            if (atomIndex == -1) continue;
            int n = matomIndex;
            this.numAtomAttach[n] = this.numAtomAttach[n] + this.getAtomAttachNo2(matomIndex, false);
        }
    }

    private void initPossiblyHLigands() {
        this.numOfPossiblyHLigands = new int[this.matomLength];
        int ac = this.union.getAtomCount();
        this.canBeH = new BitSet(ac);
        this.canBeNonH = new BitSet(ac);
        for (int ai = 0; ai < ac; ++ai) {
            int type = this.getCanBeHNonH(ai);
            this.canBeH.set(ai, (type & 1) > 0);
            this.canBeNonH.set(ai, (type & 2) > 0);
        }
        for (int matomIndex = 0; matomIndex < this.matomLength; ++matomIndex) {
            int atomIndex = this.atomIdxInAtomsArray[matomIndex];
            if (atomIndex == -1) continue;
            boolean canBe = false;
            boolean canNotBe = false;
            int[] arr$ = this.neighbors[matomIndex].toArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer neighborIndex = arr$[i$];
                Integer n = neighborIndex = Integer.valueOf(Math.abs(neighborIndex));
                Integer n2 = neighborIndex = Integer.valueOf(neighborIndex - 1);
                canBe = this.canBeH.get(neighborIndex);
                canNotBe = this.canBeNonH.get(neighborIndex);
                if (canBe && !canNotBe) {
                    int n3 = matomIndex;
                    this.numAtomAttach[n3] = this.numAtomAttach[n3] - 1;
                }
                if (!canBe || !canNotBe) continue;
                int n4 = matomIndex;
                this.numOfPossiblyHLigands[n4] = this.numOfPossiblyHLigands[n4] + 1;
            }
        }
    }

    private int getCanBeHNonH(int atomIndex) {
        MolAtom atom = this.union.getAtom(atomIndex);
        return this.getCanBeHNonH(atom);
    }

    private int getCanBeHNonH(MolAtom atom) {
        int atno = atom.getAtno();
        int type = 0;
        switch (atno) {
            case 1: {
                return 1;
            }
            case 128: {
                int[] list = atom.getList();
                for (int listIndex = 0; listIndex < list.length && type != 3; ++listIndex) {
                    if (list[listIndex] == 1) {
                        type |= 1;
                        continue;
                    }
                    type |= 2;
                }
                return type;
            }
            case 134: {
                if (atom.getBondCount() == 1) {
                    RgMolecule markushRgMol = (RgMolecule)this.markushDiagram;
                    int rgIndex = markushRgMol.findRgroupIndex(atom.getRgroup());
                    if (rgIndex != -1) {
                        int memberCount = markushRgMol.getRgroupMemberCount(rgIndex);
                        for (int memberIndex = 0; memberIndex < memberCount && type != 3; ++memberIndex) {
                            Molecule member = markushRgMol.getRgroupMember(rgIndex, memberIndex);
                            if (this.isSingleHDefinition(member)) {
                                type |= 1;
                                continue;
                            }
                            type |= 2;
                        }
                    }
                    return type;
                }
                return 2;
            }
        }
        return 2;
    }

    private void initPosVarNum() {
        this.numPosVar = new int[this.union.getAtomCount()];
        Sgroup[] sgroups = this.markushDiagram.getSgroupArray();
        for (int sgi = 0; sgi < sgroups.length; ++sgi) {
            MolAtom atom;
            if (!(sgroups[sgi] instanceof MulticenterSgroup)) continue;
            MulticenterSgroup mcsgroup = (MulticenterSgroup)sgroups[sgi];
            MolAtom centr = mcsgroup.getCentralAtom();
            if (!mcsgroup.hasNonCoordinateBond() || centr.getBondCount() != 1 || (atom = centr.getBond(0).getOtherAtom(centr)).getAtno() == 1) continue;
            MolAtom[] sgatoms = mcsgroup.getAtomArray();
            for (int i = 0; i < sgatoms.length; ++i) {
                int n = this.markushDiagram.indexOf(sgatoms[i]);
                this.numPosVar[n] = this.numPosVar[n] + 1;
            }
        }
    }

    private void correctAtomAttachNo() {
        for (int matomIndex = 0; matomIndex < this.matomLength; ++matomIndex) {
            int atomIndex = this.atomIdxInAtomsArray[matomIndex];
            if (atomIndex <= -1) continue;
            int n = matomIndex;
            this.numAtomAttach[n] = this.numAtomAttach[n] - this.numPosVar[this.sg.getOrigAtomIndex(atomIndex)];
        }
    }

    @Override
    protected boolean isUnsaturatedAtom(int targetAtom) {
        if (this.isQueryHomologyMode) {
            return super.isUnsaturatedAtom(targetAtom);
        }
        if (HomologyConstants.isHomology(this.sg.getAtom(this.atomIdxInAtomsArray[targetAtom]).getAliasstr())) {
            return true;
        }
        if (this.unsaturated == null) {
            this.unsaturated = ArrayTools.initArray(this.unsaturated, this.matomLength, -1);
        }
        if (this.unsaturated[targetAtom] == -1) {
            Sgroup[] sgroups;
            int atomIndex = this.walks[targetAtom][this.walks[targetAtom].length - 1];
            MolAtom atom = this.markushDiagram.getAtom(atomIndex);
            int bondCount = atom.getBondCount();
            int us = 0;
            for (int bondIndex = 0; bondIndex < bondCount && us != 1; ++bondIndex) {
                MolBond bond = atom.getBond(bondIndex);
                int lus = this.getUnsaturatedValue(bond.getType());
                us = lus == 1 ? 1 : Math.max(us, lus);
            }
            for (Sgroup sgroup : sgroups = this.markushDiagram.findAllSgroupContaining(atom)) {
                if (us == 1 || !(sgroup instanceof MulticenterSgroup)) continue;
                MulticenterSgroup mgroup = (MulticenterSgroup)sgroup;
                int lus = this.getUnsaturatedValue(mgroup.getCentralAtom().getBond(0).getType());
                us = lus == 1 ? 1 : Math.max(us, lus);
            }
            this.unsaturated[targetAtom] = us;
        }
        return this.unsaturated[targetAtom] != 0;
    }

    private int getUnsaturatedValue(int bondType) {
        switch (bondType) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 64: 
            case 128: {
                return 1;
            }
            case 0: 
            case 5: 
            case 6: {
                return 2;
            }
        }
        return 0;
    }

    private int[] getConnectionUsageValues(int bondType) {
        switch (bondType) {
            case 2: {
                return new int[]{1, 1};
            }
            case 3: {
                return new int[]{2, 2};
            }
            case 4: 
            case 7: {
                return new int[]{0, 1};
            }
            case 64: 
            case 128: {
                return new int[]{1, 1};
            }
            case 5: 
            case 6: {
                return new int[]{0, 1};
            }
            case 0: {
                return new int[]{0, 2};
            }
        }
        return new int[]{0, 0};
    }

    @Override
    protected void createMoleculeMatchers() {
        ArrayList<ConvertibleHomologyEqualTranslationMatcher> matchers = new ArrayList<ConvertibleHomologyEqualTranslationMatcher>();
        if (this.searchOptions.getHomologyBroadTranslation() != HomologyTranslationOption.ALL) {
            matchers.add(new ConvertibleHomologyEqualTranslationMatcher());
        }
        for (MoleculeMatcher moleculeMatcher : this.moleculeMatchers = matchers.toArray(new MoleculeMatcher[0])) {
            moleculeMatcher.setSearcher(this);
        }
    }

    @Override
    public boolean isLicensed() {
        return true;
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }
}

