/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.Base64InputStream;
import chemaxon.common.util.Base64OutputStream;
import chemaxon.common.util.ByteVector;
import chemaxon.common.util.IntVector;
import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.bracket.PolymerUtil;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.supergraph.ExpansionRecord;
import chemaxon.enumeration.supergraph.MarkushAromata;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.enumeration.supergraph.SupergraphException;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.sss.search.DuplicateCheck;
import chemaxon.sss.search.MarkushFeature;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.StandardizedMolSearch;
import chemaxon.sss.search.options.HomologyTranslationOption;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import chemaxon.util.IntRange;
import chemaxon.util.StringUtil;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MarkushTagger {
    private static final Logger logger = Logger.getLogger(MarkushTagger.class.getName());
    private static final String ATTACHMENT = "ATTACHMENT";
    private static final String RLIGAND = "RLIGAND";
    private static final String NEIGHBOURS = "NEIGHBOURS";
    public static final int COLORING_NONE = 0;
    public static final int COLORING_SOLID = 1;
    public static final int COLORING_GRADUAL = 2;
    private static final int SETSEQ_MAX = Math.min(63, 63);
    private int coloringStyle = 0;
    private Color color = Color.RED;
    private Molecule markush = null;
    private Molecule[] queries = null;
    private MolSearch search = new StandardizedMolSearch();
    private boolean allHits = false;
    private boolean expandHomology = true;
    private MarkushAromata aromata = new MarkushAromata();
    private Hashtable<MarkushFeature, int[]> featureTable = null;
    private Hashtable<MarkushFeature, int[]> featureCoverageTable = null;
    private DuplicateCheck duplicateChecker = null;

    public static void setLoggingLevel(Level level) {
        logger.setLevel(level);
    }

    public static Level getLoggingLevel() {
        return logger.getLevel();
    }

    public MarkushTagger() {
        this.getSearchOptions().setMarkushEnabled(true);
        this.getSearchOptions().setHitIndexType(1);
        this.getSearchOptions().setHomologyBroadTranslation(HomologyTranslationOption.ALL);
        this.getSearchOptions().setHomologyNarrowTranslation(HomologyTranslationOption.ALL);
    }

    public void setMarkush(Molecule markush) {
        this.markush = markush.cloneMolecule();
        this.featureTable = null;
    }

    public void setQueries(Molecule[] queries) {
        this.queries = queries;
    }

    public void setSearchOptions(MolSearchOptions options) {
        this.search.setSearchOptions(options);
    }

    public MolSearchOptions getSearchOptions() {
        return this.search.getSearchOptions();
    }

    public void setAllHits(boolean allHits) {
        this.allHits = allHits;
    }

    public void setExpandHomology(boolean expandHomology) {
        this.expandHomology = expandHomology;
    }

    public void setColoringStyle(int coloringStyle) {
        this.coloringStyle = coloringStyle;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Molecule getMarkush() {
        return this.markush;
    }

    public Hashtable<MarkushFeature, int[]> getFeatureTable() {
        return this.featureTable;
    }

    public Hashtable<MarkushFeature, int[]> getFeatureCoverageTable() {
        return this.featureCoverageTable;
    }

    private void createFeatureTable() {
        int[] values;
        int i;
        Hashtable<MarkushFeature, int[]> table = new Hashtable<MarkushFeature, int[]>();
        RgMolecule rgmol = this.markush instanceof RgMolecule ? (RgMolecule)this.markush : null;
        MoleculeGraph union = this.markush.getGraphUnion();
        int count = union.getAtomCount();
        for (i = 0; i < count; ++i) {
            MolAtom atom = union.getAtom(i);
            int atno = atom.getAtno();
            if (atno == 134) {
                int rgindex;
                if (rgmol != null && (rgindex = rgmol.findRgroupIndex(atom.getRgroup())) != -1) {
                    MarkushFeature feature = new MarkushFeature(6, i, rgindex);
                    values = new int[rgmol.getRgroupMemberCount(rgindex)];
                    for (int k = 0; k < values.length; ++k) {
                        values[k] = k;
                    }
                    table.put(feature, values);
                }
            } else if (atno == 128) {
                MarkushFeature feature = new MarkushFeature(1, i);
                int[] values2 = atom.getList();
                table.put(feature, values2);
            }
            if (!atom.isLinkNode()) continue;
            MarkushFeature feature = new MarkushFeature(3, i);
            int min = atom.getMinRepetitions();
            int max = atom.getMaxRepetitions();
            int[] values3 = new int[max - min + 1];
            for (int k = 0; k < values3.length; ++k) {
                values3[k] = min + k;
            }
            table.put(feature, values3);
        }
        count = union.getBondCount();
        for (i = 0; i < count; ++i) {
            MolBond bond = union.getBond(i);
            int[] types = ExpansionUtil.BOND_TYPES[bond.getType()];
            if (types.length <= 1) continue;
            MarkushFeature feature = new MarkushFeature(2, i);
            int[] values4 = (int[])types.clone();
            table.put(feature, values4);
        }
        count = this.markush.getSgroupCount();
        for (i = 0; i < count; ++i) {
            Sgroup sgroup = this.markush.getSgroup(i);
            if (sgroup instanceof RepeatingUnitSgroup && !PolymerUtil.isPolymerSgroup(sgroup)) {
                int x = sgroup.findCrossingBonds().length;
                if (x == 1 || x > 4) continue;
                MarkushFeature feature = new MarkushFeature(5, i);
                IntRange range = new IntRange(sgroup.getSubscript());
                range.setMaxCount(10);
                values = range.toArray();
                table.put(feature, values);
                continue;
            }
            if (!(sgroup instanceof MulticenterSgroup)) continue;
            MulticenterSgroup multicenter = (MulticenterSgroup)sgroup;
            MolAtom ca = multicenter.getCentralAtom();
            for (int j = ca.getBondCount() - 1; j >= 0; --j) {
                MolAtom oa;
                MolBond mb = ca.getBond(j);
                if (mb.getType() == 9 || (oa = mb.getOtherAtom(ca)).getAtno() == 137) continue;
                MarkushFeature feature = new MarkushFeature(4, union.indexOf(mb), i);
                SelectionMolecule graph = multicenter.getSgroupGraph();
                int[] values5 = new int[graph.getAtomCount()];
                for (int k = 0; k < values5.length; ++k) {
                    values5[k] = this.markush.indexOf(graph.getAtom(k));
                }
                table.put(feature, values5);
            }
        }
        this.featureTable = table;
    }

    public static String store(Hashtable<MarkushFeature, int[]> table) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(table);
        oos.close();
        ByteArrayOutputStream out64 = new ByteArrayOutputStream();
        Base64OutputStream base64os = new Base64OutputStream(out64);
        base64os.write(baos.toByteArray());
        base64os.close();
        return out64.toString();
    }

    public static Hashtable<MarkushFeature, int[]> restore(String tableString) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in64 = new ByteArrayInputStream(tableString.getBytes());
        Base64InputStream base64in = new Base64InputStream(in64);
        ByteVector bytes = new ByteVector();
        int b = -1;
        while ((b = base64in.read()) != -1) {
            bytes.addElement((byte)b);
        }
        base64in.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes.toArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object obj = ois.readObject();
        ois.close();
        return (Hashtable)obj;
    }

    public void tag() throws SearchException, SupergraphException {
        if (this.markush == null || this.queries == null) {
            return;
        }
        if (this.expandHomology) {
            this.extendMarkushWithHomologyMatchings();
        }
        this.initColoring();
        ArrayList<ExpansionRecord> records = new ArrayList<ExpansionRecord>();
        Molecule m = this.markush.cloneMolecule();
        this.aromata.aromatize(m);
        Supergraph sg = new Supergraph(m);
        this.search.setTarget(sg);
        for (int i = 0; i < this.queries.length; ++i) {
            this.search.setQuery(this.queries[i]);
            int[] hit = this.search.findFirst();
            if (hit == null) {
                logger.warning("Query " + (i + 1) + " does not match the Markush target.");
                continue;
            }
            do {
                this.colorAtoms(MarkushTagger.getMarkushHit(sg, hit));
                sg.expand(records, hit, null, this.expandHomology, true);
            } while ((hit = this.allHits ? this.search.findNext() : null) != null);
        }
        this.createFeatureTable();
        this.featureCoverageTable = new Hashtable();
        for (ExpansionRecord record : records) {
            int index;
            MarkushFeature feature = record.getFeature();
            int value = record.getValue();
            int[] values = this.featureTable.get(feature);
            if (values == null) {
                System.err.println(feature);
            }
            if ((index = MarkushTagger.findInArray(value, values)) >= 0) {
                this.colorFeature(feature, value);
                int[] data = this.featureCoverageTable.get(feature);
                if (data == null) {
                    data = new int[values.length];
                    this.featureCoverageTable.put(feature, data);
                }
                int n = index;
                data[n] = data[n] + 1;
                continue;
            }
            if (!logger.isLoggable(Level.SEVERE)) continue;
            logger.severe("Feature (" + feature + ") value: " + value + " not found in value range: " + StringUtil.arrayToString(values, ","));
        }
        for (int i = this.markush.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sgroup = this.markush.getSgroup(i);
            if (sgroup.getType() != 0) continue;
            SgroupAtom superAtom = ((SuperatomSgroup)sgroup).getSuperAtom();
            superAtom.setSetSeq(sgroup.getAtom(0).getSetSeq());
        }
    }

    private void initColoring() {
        if (this.coloringStyle == 0) {
            return;
        }
        MDocument mdoc = this.markush.getDocument();
        if (mdoc == null) {
            mdoc = new MDocument(this.markush);
        }
        mdoc.setAtomSetColorMode(0, 1);
        mdoc.setAtomSetRGB(0, Color.BLACK.getRGB());
        if (this.coloringStyle == 1) {
            mdoc.setAtomSetColorMode(1, 1);
            mdoc.setBondSetColorMode(1, 1);
            int rgb = this.color.getRGB();
            mdoc.setAtomSetRGB(1, rgb);
            mdoc.setBondSetRGB(1, rgb);
        } else {
            Color c = this.color;
            for (int i = 1; i <= SETSEQ_MAX; ++i) {
                mdoc.setAtomSetColorMode(i, 1);
                mdoc.setBondSetColorMode(i, 1);
                int rgb = c.getRGB();
                mdoc.setAtomSetRGB(i, rgb);
                mdoc.setBondSetRGB(i, rgb);
                c = this.incColor(c);
            }
        }
    }

    private Color incColor(Color c) {
        if (c == null || c.equals(Color.BLACK)) {
            return this.color;
        }
        return c.brighter();
    }

    private void colorAtoms(MoleculeGraph graph) {
        for (int i = graph.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = graph.getAtom(i);
            if (MarkushTagger.isExpandable(atom)) continue;
            this.color(atom);
        }
    }

    private void colorAtoms(int[] indexes) {
        if (this.coloringStyle == 0) {
            return;
        }
        for (int x : indexes) {
            MolAtom atom;
            if (x < 0 || MarkushTagger.isExpandable(atom = this.markush.getAtom(x))) continue;
            this.color(atom);
        }
    }

    private void colorFeature(MarkushFeature feature, int value) {
        if (this.coloringStyle == 0) {
            return;
        }
        switch (feature.getType()) {
            case 1: 
            case 3: 
            case 6: {
                this.color(this.markush.getAtom(feature.getData()[0]));
                break;
            }
            case 5: {
                Sgroup sgroup = this.markush.getSgroup(feature.getData()[0]);
                ArrayList<MBracket> brackets = sgroup.getBrackets();
                for (MBracket bracket : brackets) {
                    this.color(bracket);
                }
                break;
            }
            case 4: {
                this.color(this.markush.getAtom(value));
            }
            case 2: {
                this.color(this.markush.getBond(feature.getData()[0]));
            }
        }
    }

    private void color(MObject bracket) {
        switch (this.coloringStyle) {
            case 1: {
                bracket.setColor(this.color);
                break;
            }
            case 2: {
                bracket.setColor(this.incColor(bracket.getColor()));
            }
        }
    }

    private void color(MolAtom atom) {
        switch (this.coloringStyle) {
            case 1: {
                atom.setSetSeq(1);
                break;
            }
            case 2: {
                MarkushTagger.incSetSeq(atom);
            }
        }
    }

    private static void incSetSeq(MolAtom atom) {
        int seq = atom.getSetSeq();
        seq = Math.min(seq + 1, SETSEQ_MAX);
        atom.setSetSeq(seq);
    }

    private void color(MolBond bond) {
        switch (this.coloringStyle) {
            case 1: {
                bond.setSetSeq(1);
                break;
            }
            case 2: {
                MarkushTagger.incSetSeq(bond);
            }
        }
    }

    private static void incSetSeq(MolBond bond) {
        int seq = bond.getSetSeq();
        seq = Math.min(seq + 1, SETSEQ_MAX);
        bond.setSetSeq(seq);
    }

    private void extendMarkushWithHomologyMatchings() throws SearchException, SupergraphException {
        if (!HomologyConstants.containsHomology(this.markush)) {
            return;
        }
        RgMolecule extendedMarkush = null;
        Molecule m = this.markush.cloneMolecule();
        if (m instanceof RgMolecule) {
            extendedMarkush = (RgMolecule)m;
        } else {
            extendedMarkush = new RgMolecule();
            extendedMarkush.setRoot(m);
        }
        if (extendedMarkush.getDim() != 2) {
            extendedMarkush.clean(2, null);
        }
        Molecule mm = this.markush.cloneMolecule();
        this.aromata.aromatize(mm);
        Supergraph sg = new Supergraph(mm);
        this.search.setTarget(sg);
        for (int i = 0; i < this.queries.length; ++i) {
            this.search.setQuery(this.queries[i]);
            int[] hit = this.search.findFirst();
            if (hit == null) {
                logger.warning("Query " + (i + 1) + " does not match the Markush target.");
                continue;
            }
            do {
                this.extendMarkushWithHomologyMatchings(extendedMarkush, this.queries[i], MarkushTagger.getMarkushHit(sg, hit));
            } while ((hit = this.allHits ? this.search.findNext() : null) != null);
        }
        this.markush = extendedMarkush;
        CleanUtil.arrangeComponents(this.markush);
    }

    private void extendMarkushWithHomologyMatchings(RgMolecule extendedMarkush, Molecule query, int[] markushHit) throws SearchException {
        MoleculeGraph union = this.markush.getGraphUnion();
        int count = union.getAtomCount();
        for (int i = 0; i < count; ++i) {
            int[] homologyMatchingIndexes;
            MolAtom atom = this.markush.getAtom(i);
            if (atom.getAtno() != 136 || !HomologyConstants.isHomology(atom.getAliasstr()) || (homologyMatchingIndexes = MarkushTagger.getMatchingIndexes(markushHit, i)).length <= 0) continue;
            MolAtom extendedAtom = extendedMarkush.getAtom(i);
            this.extendMarkushWithHomologyMatching(extendedMarkush, query, markushHit, atom, extendedAtom, homologyMatchingIndexes);
        }
        MarkushTagger.clearRLigandProperties(extendedMarkush);
    }

    private void extendMarkushWithHomologyMatching(RgMolecule extendedMarkush, Molecule query, int[] markushHit, MolAtom homologyAtom, MolAtom extendedHomologyAtom, int[] homologyMatchingIndexes) throws SearchException {
        int[] homologyAtomNeighbours = (int[])extendedHomologyAtom.getProperty(NEIGHBOURS);
        if (homologyAtomNeighbours == null) {
            homologyAtomNeighbours = this.findNeighbours(extendedMarkush, extendedHomologyAtom);
            extendedHomologyAtom.putProperty(NEIGHBOURS, homologyAtomNeighbours);
        }
        int[][] homologyMatchingAttachments = MarkushTagger.getAttachments(query, homologyMatchingIndexes);
        int[] attachmentMap = this.findAttachmentMap(extendedMarkush, markushHit, homologyMatchingAttachments, homologyAtomNeighbours);
        this.setAttachmentProperties(query, homologyAtom, homologyMatchingIndexes, homologyMatchingAttachments, attachmentMap, homologyAtomNeighbours.length);
        Molecule homologyMatching = new Molecule();
        query.clonecopy(homologyMatchingIndexes, homologyMatching);
        MarkushTagger.clearAttachmentProperties(query, homologyMatchingIndexes);
        MarkushTagger.setRAtom(extendedMarkush, extendedHomologyAtom);
        this.addRgroupDefinitionMember(extendedMarkush, extendedHomologyAtom, homologyAtomNeighbours, homologyMatching);
    }

    private int[] findAttachmentMap(RgMolecule rgmol, int[] markushHit, int[][] homologyMatchingAttachments, int[] homologyAtomNeighbours) {
        int[] map = new int[homologyMatchingAttachments.length];
        for (int i = 0; i < map.length; ++i) {
            boolean lookUp;
            int markushIndex = markushHit[homologyMatchingAttachments[i][1]];
            if (markushIndex < 0) {
                map[i] = -1;
                continue;
            }
            int k = this.findInHomologyNeighbours(rgmol, markushIndex, homologyAtomNeighbours);
            boolean bl = lookUp = k == -1;
            while (lookUp) {
                MolAtom ratom;
                int rid;
                lookUp = false;
                if (rgmol == null || (rid = rgmol.rgroupIdOf(rgmol.getAtom(markushIndex))) == -1 || (ratom = MolImportUtil.findRAtom(rgmol, rid)) == null) continue;
                markushIndex = rgmol.indexOf(ratom);
                k = MarkushTagger.findInArray(markushIndex, homologyAtomNeighbours);
                lookUp = k == -1;
            }
            map[i] = k;
        }
        return map;
    }

    private void setAttachmentProperties(Molecule query, MolAtom homologyAtom, int[] homologyMatchingIndexes, int[][] homologyMatchingAttachments, int[] attachmentMap, int orderCount) {
        int i;
        IntVector free = new IntVector();
        boolean[] orders = new boolean[orderCount];
        for (i = 0; i < homologyMatchingAttachments.length; ++i) {
            if (attachmentMap[i] >= 0) {
                MarkushTagger.putAttachmentProperty(query.getAtom(homologyMatchingAttachments[i][0]), attachmentMap[i] + 1);
                orders[attachmentMap[i]] = true;
                continue;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Attachment problem for homology atom: " + (this.markush.indexOf(homologyAtom) + 1) + " (" + homologyAtom.getAliasstr() + ")");
                logger.info("Query attachment: " + (homologyMatchingAttachments[i][0] + 1) + "-" + (homologyMatchingAttachments[i][1] + 1) + " has no matching R-atom neighbour");
            }
            free.add(homologyMatchingAttachments[i][0]);
        }
        block1: for (i = 0; i < orders.length; ++i) {
            if (orders[i]) continue;
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Attachment problem for homology atom: " + (this.markush.indexOf(homologyAtom) + 1) + " (" + homologyAtom.getAliasstr() + ")");
                logger.info("R-atom neighbour with order number " + (i + 1) + " has no matching attachment in query," + " setting attachment arbitrarily.");
            }
            if (!free.isEmpty()) {
                int k = free.remove(free.size() - 1);
                MarkushTagger.putAttachmentProperty(query.getAtom(k), i + 1);
                continue;
            }
            for (int j = 0; j < homologyMatchingIndexes.length; ++j) {
                int attachmentCount;
                MolAtom atom = query.getAtom(homologyMatchingIndexes[j]);
                IntVector attachments = (IntVector)atom.getProperty(ATTACHMENT);
                int n = attachmentCount = attachments != null ? attachments.size() : 0;
                if (j != homologyMatchingIndexes.length - 1 && atom.getImplicitHcount() - attachmentCount <= 0) continue;
                MarkushTagger.putAttachmentProperty(atom, i + 1);
                continue block1;
            }
        }
    }

    private static void putAttachmentProperty(MolAtom atom, int value) {
        IntVector v = (IntVector)atom.getProperty(ATTACHMENT);
        if (v == null) {
            v = new IntVector();
            atom.putProperty(ATTACHMENT, v);
        }
        v.add(value);
    }

    private static void clearAttachmentProperties(Molecule query, int[] homologyMatchingIndexes) {
        for (int i = 0; i < homologyMatchingIndexes.length; ++i) {
            query.getAtom(homologyMatchingIndexes[i]).removeProperty(ATTACHMENT);
        }
    }

    private static void setRAtom(RgMolecule extendedMarkush, MolAtom extendedHomologyAtom) {
        if (extendedHomologyAtom.getAtno() == 134) {
            return;
        }
        extendedHomologyAtom.setAtno(134);
        String homologyName = extendedHomologyAtom.getAliasstr();
        int rid = MarkushTagger.getFreeRgroupID(extendedMarkush);
        extendedHomologyAtom.setRgroup(rid);
        extendedHomologyAtom.setAliasstr(HomologyConstants.getAliasStr(homologyName, rid));
    }

    private static int getFreeRgroupID(RgMolecule rgmol) {
        int rid = 0;
        for (int i = rgmol.getRgroupCount() - 1; i >= 0; --i) {
            rid = Math.max(rgmol.getRgroupId(i), rid);
        }
        return ++rid;
    }

    private void addRgroupDefinitionMember(RgMolecule extendedMarkush, MolAtom extendedHomologyAtom, int[] homologyAtomNeighbours, Molecule rgroup) throws SearchException {
        int rid;
        Molecule containedRgroup;
        MolAtom[] rligands = new MolAtom[homologyAtomNeighbours.length];
        for (int i = rgroup.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = rgroup.getAtom(i);
            IntVector attachments = (IntVector)atom.getProperty(ATTACHMENT);
            if (attachments == null) continue;
            atom.removeProperty(ATTACHMENT);
            int size = attachments.size();
            for (int j = 0; j < size; ++j) {
                int order = attachments.get(j);
                MolAtom neighbour = extendedMarkush.getAtom(homologyAtomNeighbours[order - 1]);
                MolAtom attachment = MolImportUtil.addCleanedRgroupAttachmentPoint(atom, order, 1);
                MolAtom ligand = this.getConnection(extendedHomologyAtom, neighbour);
                assert (ligand != null) : "" + extendedHomologyAtom + " R" + extendedHomologyAtom.getRgroup() + " : " + neighbour;
                rligands[order - 1] = ligand;
            }
        }
        boolean success = MolImportUtil.setLigandOrders(extendedHomologyAtom, rligands);
        assert (success);
        if (this.duplicateChecker == null) {
            this.duplicateChecker = new DuplicateCheck();
        }
        if ((containedRgroup = this.duplicateChecker.getRgroupMember(extendedMarkush, rid = extendedHomologyAtom.getRgroup(), rgroup)) == null) {
            if (rgroup.getDim() == 0) {
                rgroup.clean(2, null);
            }
            extendedMarkush.addRgroup(rid, rgroup);
            this.colorAtoms(rgroup);
        } else {
            this.colorAtoms(containedRgroup);
        }
    }

    private static void clearRLigandProperties(Molecule mol) {
        MoleculeGraph union = mol.getGraphUnion();
        for (int i = union.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = union.getAtom(i);
            int atno = atom.getAtno();
            if (atno == 138) {
                atom.removeProperty(RLIGAND);
                continue;
            }
            if (atno != 134) continue;
            atom.removeProperty(NEIGHBOURS);
        }
    }

    private MolAtom getConnection(MolAtom atom, MolAtom rligand) {
        MolBond bond = atom.getBondTo(rligand);
        if (bond != null) {
            return rligand;
        }
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            MolAtom ligand = atom.getLigand(i);
            if (ligand.getAtno() != 138 || ligand.getProperty(RLIGAND) != rligand) continue;
            return ligand;
        }
        return null;
    }

    private static int[] getMarkushHit(Supergraph sg, int[] hit) {
        int[] markushHit = new int[hit.length];
        for (int i = 0; i < hit.length; ++i) {
            markushHit[i] = hit[i] < 0 ? hit[i] : sg.getMarkushUnionIndex(hit[i]);
        }
        return markushHit;
    }

    private static int[][] getAttachments(Molecule mol, int[] group) {
        ArrayList<int[]> attachments = new ArrayList<int[]>();
        for (int i : group) {
            MolAtom atom = mol.getAtom(i);
            for (int k = atom.getBondCount() - 1; k >= 0; --k) {
                MolAtom ligand = atom.getLigand(k);
                int j = mol.indexOf(ligand);
                if (MarkushTagger.findInArray(j, group) != -1) continue;
                attachments.add(new int[]{i, j});
            }
        }
        return (int[][])attachments.toArray((T[])new int[attachments.size()][]);
    }

    private int[] findNeighbours(RgMolecule rgmol, MolAtom atom) {
        MolAtom patom = MarkushTagger.getRealParentRAtom(rgmol, atom);
        if (patom == null) {
            return new int[0];
        }
        MarkushTagger.setMissingAttachmentPoints(rgmol, atom, patom);
        int[] neighbours = new int[atom.getBondCount()];
        MolAtom ratom = null;
        for (int i = 0; i < neighbours.length; ++i) {
            MolAtom ligand = atom.getLigand(i);
            if (ligand.getAtno() == 138) {
                if (ratom == null) {
                    ratom = MolImportUtil.findParentRAtom(rgmol, atom);
                }
                if (ratom != null) {
                    MolAtom realLigand = (MolAtom)ligand.getProperty(RLIGAND);
                    if (realLigand == null) {
                        realLigand = MarkushTagger.findRealRAtomLigand(rgmol, ratom, ligand.getRgroupAttachmentPointOrder());
                        assert (realLigand != null);
                        ligand.putProperty(RLIGAND, realLigand);
                    }
                    ligand = realLigand;
                }
            }
            neighbours[i] = rgmol.indexOf(ligand);
        }
        return neighbours;
    }

    private static MolAtom getRealParentRAtom(RgMolecule rgmol, MolAtom atom) {
        while (atom.getBondCount() == 0) {
            if ((atom = MolImportUtil.findParentRAtom(rgmol, atom)) != null) continue;
            return null;
        }
        return atom;
    }

    private static void setMissingAttachmentPoints(RgMolecule rgmol, MolAtom atom, MolAtom patom) {
        while (atom != patom) {
            MolAtom[] rligands = new MolAtom[patom.getBondCount()];
            for (int i = rligands.length - 1; i >= 0; --i) {
                rligands[i] = MolImportUtil.addCleanedRgroupAttachmentPoint(atom, i + 1, 1);
            }
            MolImportUtil.setLigandOrders(atom, rligands);
            atom = MolImportUtil.findParentRAtom(rgmol, atom);
        }
    }

    private static MolAtom findRealRAtomLigand(RgMolecule rgmol, MolAtom ratom, int order) {
        MolAtom ligand = MolImportUtil.getLigandByOrder(ratom, order);
        if (ligand == null) {
            return null;
        }
        while (ligand.getAtno() == 138) {
            ratom = MolImportUtil.findParentRAtom(rgmol, ratom);
            order = ligand.getRgroupAttachmentPointOrder();
            ligand = MarkushTagger.findRealRAtomLigand(rgmol, ratom, order);
        }
        return ligand;
    }

    private static int[] getMatchingIndexes(int[] hit, int value) {
        IntVector matchingIndexes = new IntVector();
        for (int i = 0; i < hit.length; ++i) {
            if (hit[i] != value) continue;
            matchingIndexes.add(i);
        }
        return matchingIndexes.toArray();
    }

    private int findInHomologyNeighbours(RgMolecule rgmol, int markushIndex, int[] homologyAtomNeighbours) {
        MolAtom ca;
        MulticenterSgroup msg;
        int k = MarkushTagger.findInArray(markushIndex, homologyAtomNeighbours);
        if (k == -1 && (msg = this.getContainingMulticenter(rgmol, markushIndex)) != null && (ca = msg.getCentralAtom()) != null) {
            k = MarkushTagger.findInArray(rgmol.indexOf(ca), homologyAtomNeighbours);
        }
        return k;
    }

    private MulticenterSgroup getContainingMulticenter(RgMolecule rgmol, int markushIndex) {
        MolAtom atom = rgmol.getAtom(markushIndex);
        for (int i = rgmol.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sg = rgmol.getSgroup(i);
            if (sg.getType() != 14 || !sg.hasAtom(atom)) continue;
            return (MulticenterSgroup)sg;
        }
        return null;
    }

    private static int findInArray(int value, int[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != value) continue;
            return i;
        }
        return -1;
    }

    private static boolean isExpandable(MolAtom atom) {
        int atno = atom.getAtno();
        return atno == 134 || atno == 128 || atom.isLinkNode();
    }
}

