/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.sss.search.StructureSearch;
import chemaxon.struc.Molecule;

public class MolComparator {
    protected Molecule query;
    protected Molecule target;
    protected StructureSearch searcher;
    public static final int USEFUL = 0;
    public static final int MAYBE_USEFUL = 1;
    public static final int NOT_USEFUL = 2;

    public void setQuery(Molecule q) {
        this.query = q;
    }

    public void setTarget(Molecule t) {
        this.target = t;
    }

    public void setSearcher(StructureSearch s) {
        this.searcher = s;
    }

    public void initAll(Molecule q, Molecule t, StructureSearch s) {
        this.setQuery(q);
        this.setTarget(t);
        this.setSearcher(s);
    }

    public boolean compareAtoms(int a1, int a2) {
        return true;
    }

    public boolean compareBonds(int b1, int b2) {
        return true;
    }

    public int getOrigTargetAtom(int a1) {
        return this.searcher.atomIdxInAtomsArray[a1];
    }

    public int getOrigQueryAtom(int a1) {
        return this.searcher.sub.atomIdxInAtomsArray[a1];
    }

    public int getOrigTargetNeighbour(int a) {
        if (this.searcher.bondidx[a] == -1) {
            return -1;
        }
        int nextAtom = this.searcher.bto[this.searcher.bondidx[a]];
        return this.getOrigTargetAtom(nextAtom);
    }

    public int getOrigQueryNeighbour(int a) {
        if (this.searcher.sub.bondidx[a] == -1) {
            return -1;
        }
        int nextAtom = this.searcher.sub.bto[this.searcher.sub.bondidx[a]];
        return this.getOrigQueryAtom(nextAtom);
    }

    public boolean compareHit(int[] internalHit, int internalHitLength) {
        return true;
    }

    public int isUsefulForQuery() {
        return 0;
    }

    public int isUsefulForTarget() {
        return 0;
    }

    public int getOrigQueryAtom1(int bi) {
        return this.getOrigQueryAtom(this.searcher.sub.bFrom[bi]);
    }

    public int getOrigQueryAtom2(int bi) {
        return this.getOrigQueryAtom(this.searcher.sub.bto[bi]);
    }

    public int getOrigTargetAtom1(int bi) {
        return this.getOrigTargetAtom(this.searcher.bFrom[bi]);
    }

    public int getOrigTargetAtom2(int bi) {
        return this.getOrigTargetAtom(this.searcher.bto[bi]);
    }

    public int getOrigQueryBond(int bi) {
        int a1 = this.getOrigQueryAtom1(bi);
        int a2 = this.getOrigQueryAtom2(bi);
        if (a1 == -1 || a2 == -1) {
            return -1;
        }
        return this.query.getBondTable().getBondIndex(a1, a2);
    }

    public int getOrigTargetBond(int bi) {
        int a1 = this.getOrigTargetAtom1(bi);
        int a2 = this.getOrigTargetAtom2(bi);
        if (a1 == -1 || a2 == -1) {
            return -1;
        }
        return this.target.getBondTable().getBondIndex(a1, a2);
    }
}

