/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.sss.SearchConstants;
import chemaxon.sss.search.SearchOptions;
import java.util.ArrayList;

public class MolSearchOptions
extends SearchOptions
implements SearchConstants,
Cloneable {
    private static final String[] optionNames = new String[]{"queryAbsoluteStereo", "targetAbsoluteStereo", "markush", "hitIndexType", "distinctFirstAtomMatching", "switchOffAllProtectsForTDF"};
    IntVector ignoreChiralityForAtoms = null;
    private boolean hitIncludesRNodes = true;
    private boolean queryAbsoluteStereo = true;
    private boolean targetAbsoluteStereo = true;
    private int hitIndexType = 0;
    private boolean markushEnabled = false;
    private boolean recursiveSMARTSMode = false;
    private boolean switchOffAllProtectsForTDF = false;
    private int markushArom = 0;

    @Deprecated
    public MolSearchOptions() {
        super(2);
    }

    public MolSearchOptions(int searchType) {
        super(searchType);
    }

    public boolean isQueryAbsoluteStereo() {
        return this.queryAbsoluteStereo;
    }

    public void setQueryAbsoluteStereo(boolean value) {
        if (this.queryAbsoluteStereo != value) {
            this.queryAbsoluteStereo = value;
            this.dirty = true;
        }
    }

    public boolean isTargetAbsoluteStereo() {
        return this.targetAbsoluteStereo;
    }

    public void setTargetAbsoluteStereo(boolean value) {
        if (this.targetAbsoluteStereo != value) {
            this.targetAbsoluteStereo = value;
            this.dirty = true;
        }
    }

    public boolean isHitIncludesRNodes() {
        return this.hitIncludesRNodes;
    }

    public void setHitIncludesRNodes(boolean value) {
        if (this.hitIncludesRNodes != value) {
            this.hitIncludesRNodes = value;
            this.dirty = true;
        }
    }

    @Override
    public boolean isSubgraphSearch() {
        return super.isSubgraphSearch();
    }

    @Override
    public void setSubgraphSearch(boolean value) {
        super.setSubgraphSearch(value);
    }

    public int getHitIndexType() {
        return this.hitIndexType;
    }

    public void setHitIndexType(int value) {
        if (this.hitIndexType != value) {
            this.hitIndexType = value;
            this.setDirty(true);
        }
    }

    public boolean isMarkushEnabled() {
        return this.markushEnabled;
    }

    public void setMarkushEnabled(boolean value) {
        if (this.markushEnabled != value) {
            this.markushEnabled = value;
            this.setDirty(true);
        }
    }

    public int getMarkushArom() {
        return this.markushArom;
    }

    public void setMarkushArom(int value) {
        if (value == 0 || value == 1 || value == 2) {
            if (this.markushArom != value) {
                this.markushArom = value;
                this.setDirty(true);
            }
        } else {
            throw new IllegalArgumentException("Invalid option for setMarkushArom(): " + value);
        }
    }

    public void setDistinctFirstAtomMatching(boolean b) {
        if (this.recursiveSMARTSMode != b) {
            this.recursiveSMARTSMode = b;
            if (b) {
                this.setKeepQueryOrder(true);
            }
        }
    }

    public boolean isDistinctFirstAtomMatching() {
        return this.recursiveSMARTSMode;
    }

    public void setSwitchOffAllProtectsForTDF(boolean value) {
        if (this.switchOffAllProtectsForTDF != value) {
            this.switchOffAllProtectsForTDF = value;
            this.setDirty(true);
        }
    }

    public final boolean isSwitchOffAllProtectsForTDF() {
        return this.switchOffAllProtectsForTDF;
    }

    @Override
    public void setOption(String name, String value) {
        if ("queryAbsoluteStereo".equalsIgnoreCase(name)) {
            this.setQueryAbsoluteStereo(MolSearchOptions.getBoolean(value));
        } else if ("targetAbsoluteStereo".equalsIgnoreCase(name)) {
            this.setTargetAbsoluteStereo(MolSearchOptions.getBoolean(value));
        } else if ("markush".equalsIgnoreCase(name)) {
            this.setMarkushEnabled(MolSearchOptions.getBoolean(value));
        } else if ("markushHitSupergraph".equalsIgnoreCase(name)) {
            this.setHitIndexType(MolSearchOptions.getBoolean(value) ? 1 : 0);
        } else if ("hitIndexType".equalsIgnoreCase(name)) {
            if ("m".equalsIgnoreCase(value)) {
                this.setHitIndexType(0);
            } else if ("i".equalsIgnoreCase(value)) {
                this.setHitIndexType(1);
            }
        } else if ("distinctFirstAtomMatching".equalsIgnoreCase(name)) {
            this.setDistinctFirstAtomMatching(MolSearchOptions.getBoolean(value));
        } else if ("switchOffAllProtectsForTDF".equalsIgnoreCase(name)) {
            this.setSwitchOffAllProtectsForTDF(MolSearchOptions.getBoolean(value));
        } else {
            super.setOption(name, value);
        }
    }

    @Override
    public String getOption(String name) {
        if ("queryAbsoluteStereo".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isQueryAbsoluteStereo());
        }
        if ("targetAbsoluteStereo".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isTargetAbsoluteStereo());
        }
        if ("markush".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isMarkushEnabled());
        }
        if ("hitIndexType".equalsIgnoreCase(name)) {
            switch (this.hitIndexType) {
                case 0: {
                    return "m";
                }
                case 1: {
                    return "i";
                }
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("distinctFirstAtomMatching".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isDistinctFirstAtomMatching());
        }
        if ("switchOffAllProtectsForTDF".equalsIgnoreCase(name)) {
            if (this.isSwitchOffAllProtectsForTDF()) {
                return "y";
            }
            return "n";
        }
        return super.getOption(name);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MolSearchOptions so = (MolSearchOptions)super.clone();
        this.clonecopy(so);
        return so;
    }

    @Override
    public void clonecopy(SearchOptions other) {
        super.clonecopy(other);
        this.copyOptions(other);
    }

    @Override
    public void clonecopyOptions(SearchOptions other) {
        super.clonecopyOptions(other);
        this.copyOptions(other);
    }

    private void copyOptions(SearchOptions other) {
        if (other instanceof MolSearchOptions) {
            MolSearchOptions mso = (MolSearchOptions)other;
            mso.hitIncludesRNodes = this.hitIncludesRNodes;
            mso.queryAbsoluteStereo = this.queryAbsoluteStereo;
            mso.targetAbsoluteStereo = this.targetAbsoluteStereo;
            mso.markushArom = this.markushArom;
            mso.markushEnabled = this.markushEnabled;
            mso.hitIndexType = this.hitIndexType;
            mso.recursiveSMARTSMode = this.recursiveSMARTSMode;
            mso.switchOffAllProtectsForTDF = this.switchOffAllProtectsForTDF;
            mso.ignoreChiralityForAtoms = this.ignoreChiralityForAtoms == null ? null : (IntVector)this.ignoreChiralityForAtoms.clone();
        }
    }

    @Override
    public ArrayList<String> toList() {
        ArrayList<String> ret = new ArrayList<String>();
        MolSearchOptions mso = new MolSearchOptions(2);
        String searchType = this.getOption("t");
        if (!searchType.equalsIgnoreCase(mso.getOption("t"))) {
            ret.add("t:" + searchType);
            mso.setOption("t", searchType);
        }
        this.fillOptionList(ret, mso);
        return ret;
    }

    @Override
    protected String[] getOptionNames() {
        return ArrayTools.concatArrays(super.getOptionNames(), optionNames);
    }
}

