/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.IntVector;
import chemaxon.enumeration.ExpansionUtil;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.sss.search.Decomposition;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchUtil;
import chemaxon.sss.search.StandardizedMolSearch;
import chemaxon.sss.search.ratom.LigandHandler;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.QueryBond;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class RGroupDecomposition
extends StandardizedMolSearch
implements Licensable {
    private String licenseEnvironment = "";
    public static final int COL_MOLECULE = 1;
    public static final int COL_SCAFFOLD = 2;
    public static final int HEADER_NONE = 0;
    public static final int HEADER_RGROUP = 1;
    public static final int HEADER_MAP = 2;
    public static final String SEPARATOR = ";";
    public static final int ATTACHMENT_NONE = 0;
    public static final int ATTACHMENT_POINT = 1;
    public static final int ATTACHMENT_MAP = 2;
    public static final int ATTACHMENT_LABEL = 3;
    public static final int ATTACHMENT_RLABEL = 5;
    public static final int ATTACHMENT_ATOM = 4;
    private int[] ratomToColumn = null;
    private int[] columnToRID = null;
    private boolean markushQuery = false;
    private LigandHandler ligandHandler = new LigandHandler();
    private Molecule origQuery = null;

    public RGroupDecomposition() {
        this.setAttachmentType(1);
    }

    public void setAttachmentType(int type) {
        this.ligandHandler.setAttachmentType(type);
    }

    public void setSameRGroupSameStructure(boolean sameRGroupSameStructure) {
        this.getSearchOptions().setRLigandEqualityCheck(sameRGroupSameStructure);
    }

    public static void addHydrogens(Molecule query) {
        query.valenceCheck();
        query.hydrogenize(true);
    }

    public static void addRGroups(Molecule query) {
        RGroupDecomposition.addRGroups(query, 0);
    }

    public static void addRGroups(Molecule query, int bondType) {
        query.valenceCheck();
        Molecule skeleton = query.isQuery() ? RGroupDecomposition.generateSkeleton(query) : query;
        int rgindex = 0;
        for (int i = query.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = query.getAtom(i);
            if (atom.getAtno() != 134) continue;
            rgindex = Math.max(atom.getRgroup(), rgindex);
        }
        ArrayList atoms = null;
        int dim = query.getDim();
        if (dim == 2) {
            atoms = new ArrayList();
            Collections.addAll(atoms, query.getAtomArray());
        }
        for (int i = query.getAtomCount() - 1; i >= 0; --i) {
            MolAtom satom = skeleton.getAtom(i);
            MolAtom atom = query.getAtom(i);
            for (int j = RGroupDecomposition.getImplHReplacementCount(satom, bondType) - 1; j >= 0; --j) {
                MolAtom rgatom = new MolAtom(134);
                rgatom.setRgroup(++rgindex);
                MolBond rgbond = new MolBond(rgatom, atom);
                rgbond.setType(bondType);
                query.add(rgatom);
                query.add(rgbond);
            }
        }
        if (dim == 2) {
            IntVector indexes = new IntVector(atoms.size());
            for (MolAtom atom : atoms) {
                indexes.add(query.indexOf(atom));
            }
            int[] fixed = indexes.toArray();
            query.partialClean(dim, fixed, null);
        } else if (dim != 0) {
            query.clean(dim, null);
        }
    }

    private static Molecule generateSkeleton(Molecule query) {
        int i;
        Molecule skeleton = query.cloneMolecule();
        for (i = skeleton.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = skeleton.getAtom(i);
            atom.clearQProps();
            int atno = atom.getAtno();
            if (atno == 131) {
                atom.setAtno(6);
                continue;
            }
            if (atno != 128) continue;
            atom.setAtno(RGroupDecomposition.getRepresentativeAtno(atom.getList()));
        }
        for (i = skeleton.getBondCount() - 1; i >= 0; --i) {
            int type;
            int leastType;
            MolBond bond = skeleton.getBond(i);
            if (bond instanceof QueryBond) {
                ((QueryBond)bond).setQuerystr(null);
            }
            if ((leastType = RGroupDecomposition.getLeastBondType(type = bond.getType())) == type) continue;
            bond.setType(leastType);
        }
        skeleton.valenceCheck();
        return skeleton;
    }

    private static int getRepresentativeAtno(int[] atnos) {
        if (atnos == null || atnos.length == 0) {
            return 128;
        }
        int repr = atnos[0];
        int m = Integer.MIN_VALUE;
        for (int atno : atnos) {
            int state;
            if (RGroupDecomposition.isHalogen(atno) || m >= (state = RGroupDecomposition.getOxState(atno))) continue;
            m = state;
            repr = atno;
        }
        return repr;
    }

    private static int getOxState(int atno) {
        int m = Integer.MIN_VALUE;
        for (int k = MolAtom.numoxstatesOf(atno) - 1; k >= 0; --k) {
            int oxstate = MolAtom.oxstateOf(atno, k);
            m = Math.max(oxstate, m);
        }
        return m;
    }

    private static boolean isHalogen(int atno) {
        return atno == 9 || atno == 17 || atno == 35 || atno == 53 || atno == 85;
    }

    private static int getImplHReplacementCount(MolAtom atom, int bondType) {
        int count = Math.min(RGroupDecomposition.getImplicitHcount(atom) / RGroupDecomposition.getMultiplicity(bondType), 4 - atom.getBondCount());
        return count >= 0 ? count : 0;
    }

    private static int getImplicitHcount(MolAtom atom) {
        if (atom.getAtno() == 7 && atom.getBondCount() == 2 && atom.getBond(0).getType() == 4 && atom.getBond(1).getType() == 4) {
            return 1;
        }
        return atom.getImplicitHcount();
    }

    private static int getMultiplicity(int bondType) {
        switch (bondType) {
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 1;
    }

    private static int getLeastBondType(int bondType) {
        switch (bondType) {
            case 0: 
            case 5: 
            case 6: {
                return 1;
            }
            case 7: {
                return 4;
            }
        }
        return bondType;
    }

    public void setAlign(boolean align) {
        this.ligandHandler.setAlign(align);
    }

    public boolean isMarkushQuery() {
        return this.markushQuery;
    }

    public void setQuery(Molecule mol, int undefinedRAtom) {
        this.getSearchOptions().setUndefinedRAtom(undefinedRAtom);
        this.setQuery(mol);
    }

    @Override
    public void setQuery(Molecule mol) {
        this.ratomToColumn = null;
        this.columnToRID = null;
        this.origQuery = null;
        MolSearchOptions options = this.getSearchOptions();
        boolean hasUndefinedRAtom = SearchUtil.hasUndefinedRAtom(mol);
        if (!options.isUndefinedRAtomUserDefined()) {
            int undefinedRAtom = hasUndefinedRAtom ? 3 : 4;
            options.setUndefinedRAtom(undefinedRAtom, false);
        }
        if (!hasUndefinedRAtom) {
            this.origQuery = mol;
            mol = mol.cloneMolecule();
            RGroupDecomposition.addRGroups(mol);
        }
        super.setQuery(mol);
        this.ligandHandler.setQuery(mol);
        this.markushQuery = ExpansionUtil.isMarkushMoleculeExceptHomologyAndRgroup(mol);
    }

    @Override
    public void setTarget(Molecule mol) {
        super.setTarget(mol);
        this.ligandHandler.setTarget(mol);
    }

    @Override
    public Molecule getQuery() {
        return this.origQuery == null ? super.getQuery() : this.origQuery;
    }

    public Molecule getRGroupedQuery() {
        return super.getQuery();
    }

    public Decomposition findFirstDecomposition() throws SearchException {
        return this.findDecomposition(true);
    }

    public Decomposition findNextDecomposition() throws SearchException {
        return this.findDecomposition(false);
    }

    public Decomposition findDecomposition() throws SearchException {
        return this.findDecomposition(true);
    }

    public Decomposition findDecomposition(boolean first) throws SearchException {
        return this.getDecomposition(first ? this.findFirstGroup() : this.findNextGroup());
    }

    private Decomposition getDecomposition(int[][] groupHit) {
        boolean fullSearch;
        this.checkLicense();
        if (groupHit == null) {
            return null;
        }
        boolean bl = fullSearch = this.getSearchOptions().getSearchType() == 4;
        if (this.markushQuery) {
            this.ratomToColumn = null;
            this.ligandHandler.setQuery(this.getMatchingQuery());
        }
        this.ligandHandler.convertToLigands(groupHit, fullSearch);
        return new Decomposition(this.ligandHandler.getQuery(), this.ligandHandler.getTarget(), groupHit, this.ligandHandler.getQueryToRLigand(), this.ligandHandler.getScaffold(), this.ligandHandler.getAttachmentType());
    }

    public Molecule[][] findLigandTable(int headerType, int addCols) throws SearchException {
        return this.findLigandTable(headerType, addCols, null);
    }

    public Molecule[][] findLigandTable(int headerType, int addCols, String colorTag) throws SearchException {
        ArrayList<Molecule[]> tableList = new ArrayList<Molecule[]>();
        ArrayList<Decomposition> decompositionList = new ArrayList<Decomposition>();
        if (headerType != 0) {
            tableList.add(this.getLigandTableHeader(headerType, addCols, colorTag));
        }
        Decomposition decomposition = this.findFirstDecomposition();
        while (decomposition != null && decompositionList.size() < 100) {
            boolean duplicate = false;
            for (Decomposition d : decompositionList) {
                if (!decomposition.equals(d)) continue;
                duplicate = true;
                break;
            }
            if (!duplicate) {
                decompositionList.add(decomposition);
                tableList.add(this.getLigandTableRow(decomposition, addCols, colorTag));
            }
            decomposition = this.findNextDecomposition();
        }
        Molecule[][] table = new Molecule[tableList.size()][];
        tableList.toArray((T[])table);
        return table;
    }

    public Molecule[] findLigandTableRow(int addCols) throws SearchException {
        return this.findLigandTableRow(addCols, null);
    }

    public Molecule[] findLigandTableRow(int addCols, String colorTag) throws SearchException {
        Decomposition decomposition = this.findFirstDecomposition();
        if (decomposition == null) {
            return null;
        }
        return this.getLigandTableRow(decomposition, addCols, colorTag);
    }

    public Molecule[] getLigandTableHeader(int headerType, int addCols) {
        return this.getLigandTableHeader(headerType, addCols, null);
    }

    public Molecule[] getLigandTableHeader(int headerType, int addCols, String colorTag) {
        MolAtom atom;
        int i;
        this.setColumnMaps();
        int n = 0;
        Molecule mol = this.ligandHandler.getQuery();
        for (int i2 = mol.getAtomCount() - 1; i2 >= 0; --i2) {
            if (mol.getAtom(i2).getAtno() != 134) continue;
            ++n;
        }
        if ((addCols & 1) != 0) {
            ++n;
        }
        if ((addCols & 2) != 0) {
            ++n;
        }
        Molecule[] header = new Molecule[n];
        Molecule query = null;
        if (addCols != 0) {
            query = mol.cloneMolecule();
        }
        Molecule scaffold = null;
        if ((addCols & 2) != 0) {
            scaffold = mol.cloneMolecule();
            for (i = scaffold.getAtomCount() - 1; i >= 0; --i) {
                atom = scaffold.getAtom(i);
                if (atom.getAtno() != 134) continue;
                scaffold.removeAtom(atom);
            }
            if (colorTag != null) {
                Decomposition.color(scaffold, colorTag);
            } else {
                Decomposition.color(scaffold);
            }
        }
        if ((addCols & 1) != 0) {
            if (colorTag != null) {
                Decomposition.color(query, colorTag);
            } else {
                Decomposition.color(query);
            }
            if (headerType == 2) {
                for (i = query.getAtomCount() - 1; i >= 0; --i) {
                    atom = query.getAtom(i);
                    if (atom.getAtno() != 134) continue;
                    atom.setAtomMap(atom.getRgroup());
                    atom.setAtno(131);
                }
            }
        }
        int k = 0;
        if ((addCols & 1) != 0) {
            header[k++] = query;
        }
        if ((addCols & 2) != 0) {
            header[k++] = scaffold;
        }
        int count = mol.getAtomCount();
        for (int i3 = 0; i3 < count; ++i3) {
            if (mol.getAtom(i3).getAtno() != 134) continue;
            int rid = mol.getAtom(i3).getRgroup();
            MolAtom rgatom = null;
            if (headerType == 2) {
                rgatom = new MolAtom(131);
                rgatom.setAtomMap(rid);
            } else {
                rgatom = new MolAtom(134);
                rgatom.setRgroup(rid);
            }
            Molecule rgmol = new Molecule();
            rgmol.add(rgatom);
            if (colorTag != null) {
                rgmol.setProperty(colorTag, "" + rid);
            } else {
                rgatom.setSetSeq(rid + 1);
            }
            assert (this.ratomToColumn[i3] >= 0);
            header[k + this.ratomToColumn[i3]] = rgmol;
        }
        return header;
    }

    private Molecule[] getLigandTableRow(Decomposition decomposition, int addCols, String colorTag) {
        this.setColumnMaps();
        if (colorTag == null) {
            decomposition.color();
        } else {
            decomposition.color(colorTag);
        }
        int k = 0;
        Molecule mol = this.getRGroupedQuery();
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            if (mol.getAtom(i).getAtno() != 134) continue;
            ++k;
        }
        int n = 0;
        if ((addCols & 1) != 0) {
            ++n;
        }
        if ((addCols & 2) != 0) {
            ++n;
        }
        Molecule[] row = new Molecule[k + n];
        k = 0;
        if ((addCols & 1) != 0) {
            row[k++] = decomposition.getTarget();
        }
        if ((addCols & 2) != 0) {
            row[k++] = decomposition.getScaffold();
        }
        Molecule[] ligands = decomposition.getLigands();
        for (int i = 0; i < ligands.length; ++i) {
            if (ligands[i] == null) continue;
            assert (this.ratomToColumn[i] >= 0);
            row[k + this.ratomToColumn[i]] = ligands[i];
        }
        return row;
    }

    private void setColumnMaps() throws IllegalArgumentException {
        int i;
        if (this.ratomToColumn != null) {
            return;
        }
        Molecule mol = this.ligandHandler.getQuery();
        int count = mol.getAtomCount();
        this.ratomToColumn = new int[count];
        Arrays.fill(this.ratomToColumn, -1);
        IntVector v = new IntVector(count);
        for (i = 0; i < count; ++i) {
            MolAtom atom = mol.getAtom(i);
            if (atom.getAtno() != 134) continue;
            v.add(atom.getRgroup() * count + i);
        }
        v.sort();
        if (this.columnToRID == null) {
            this.columnToRID = new int[v.size()];
        } else if (this.columnToRID.length != v.size()) {
            throw new IllegalArgumentException("Original and matching queries have different R-group settings, R-group decomposition failed.");
        }
        for (i = 0; i < this.columnToRID.length; ++i) {
            int atomIndex = v.get(i) % count;
            int rid = mol.getAtom(atomIndex).getRgroup();
            this.ratomToColumn[atomIndex] = i;
            if (this.columnToRID[i] == 0) {
                this.columnToRID[i] = rid;
                continue;
            }
            if (this.columnToRID[i] == rid) continue;
            throw new IllegalArgumentException("Original and matching queries have different R-group settings, R-group decomposition failed.");
        }
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Structure Search", this.licenseEnvironment);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Structure Search", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }
}

