/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.reaction.Reaction;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.Reactor;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.StructureSearch;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;

public class ReactionSearch
extends StructureSearch {
    private int queryReactantCount;
    private int queryAgentCount;
    private int queryProductCount;
    private int targetReactantCount;
    private int targetAgentCount;
    private int targetProductCount;
    private int[] query;
    private int queryLength = -1;
    private int[] target;
    private boolean targetInitialized;
    private int targetLength = -1;
    private int[] queryMap;
    private int[] targetMap;
    private int[] targetMapPair;
    private int[] queryReactionStereo;
    private int[] targetReactionStereo;
    private int[] queryMapPair;
    private int[] queryComponentPair;
    private int queryComponentPairLength = -1;
    private Reactor reactor;
    private Reaction reaction;
    private StructureSearch searcher;

    @Override
    protected void initQuery() throws SearchException {
        int j;
        Molecule m;
        int i;
        RxnMolecule q = (RxnMolecule)super.getQuery();
        super.initQuery();
        int ac = q.getAtomCount();
        for (i = 0; i < ac; ++i) {
            if (!super.isExcluded(i)) continue;
            --ac;
        }
        if (this.queryLength == -1 || this.queryLength < ac) {
            this.query = new int[ac];
            this.queryMap = new int[ac];
            this.queryMapPair = new int[ac];
            this.queryReactionStereo = new int[ac];
        }
        this.queryLength = ac;
        this.queryReactantCount = q.getReactantCount();
        this.queryAgentCount = q.getAgentCount();
        this.queryProductCount = q.getProductCount();
        int c = this.queryReactantCount + this.queryAgentCount + this.queryProductCount;
        if (this.queryComponentPairLength == -1 || this.queryComponentPairLength < c) {
            this.queryComponentPair = new int[c];
        }
        this.queryComponentPairLength = c;
        for (i = 0; i < this.queryReactantCount; ++i) {
            m = q.getReactant(i);
            c = m.getAtomCount();
            for (j = 0; j < c; ++j) {
                this.query[q.indexOf((MolAtom)m.getAtom((int)j))] = i;
            }
        }
        for (i = 0; i < this.queryAgentCount; ++i) {
            m = q.getAgent(i);
            c = m.getAtomCount();
            for (j = 0; j < c; ++j) {
                this.query[q.indexOf((MolAtom)m.getAtom((int)j))] = this.queryReactantCount + i;
            }
        }
        for (i = 0; i < this.queryProductCount; ++i) {
            m = q.getProduct(i);
            c = m.getAtomCount();
            for (j = 0; j < c; ++j) {
                this.query[q.indexOf((MolAtom)m.getAtom((int)j))] = this.queryReactantCount + this.queryAgentCount + i;
            }
        }
        for (i = 0; i < this.queryLength; ++i) {
            this.queryMapPair[i] = -1;
            this.queryReactionStereo[i] = 0;
        }
        this.initMapPair(q, this.queryMap, this.queryMapPair, this.queryLength);
        for (int k = 0; k < this.queryLength; ++k) {
            MolAtom atom = q.getAtom(k);
            if (this.queryMap[k] <= 0) continue;
            this.queryReactionStereo[k] = atom.getReactionStereo();
        }
    }

    private void initMapPair(RxnMolecule r, int[] maps, int[] mapPair, int length) {
        block0: for (int i = 0; i < length; ++i) {
            MolAtom atom = r.getAtom(i);
            if (mapPair[i] != -1) continue;
            maps[i] = atom.getAtomMap();
            if (maps[i] <= 0) continue;
            for (int j = 0; j < i; ++j) {
                if (maps[i] != maps[j]) continue;
                mapPair[i] = j;
                mapPair[j] = i;
                continue block0;
            }
        }
    }

    @Override
    protected void initTarget() throws SearchException {
        int j;
        int c;
        Molecule m;
        int i;
        RxnMolecule t = (RxnMolecule)super.getTarget();
        super.initTarget();
        int ac = t.getAtomCount();
        if (this.targetLength == -1 || this.target.length < ac) {
            this.target = new int[ac];
            this.targetMap = new int[ac];
            this.targetReactionStereo = new int[ac];
            if (!this.searchOptions.isReactionUnpairedMapMatching()) {
                this.targetMapPair = new int[ac];
            }
        }
        this.targetLength = ac;
        this.targetReactantCount = t.getReactantCount();
        this.targetAgentCount = t.getAgentCount();
        this.targetProductCount = t.getProductCount();
        for (i = 0; i < this.targetReactantCount; ++i) {
            m = t.getReactant(i);
            c = m.getAtomCount();
            for (j = 0; j < c; ++j) {
                this.target[t.indexOf((MolAtom)m.getAtom((int)j))] = i;
            }
        }
        for (i = 0; i < this.targetAgentCount; ++i) {
            m = t.getAgent(i);
            c = m.getAtomCount();
            for (j = 0; j < c; ++j) {
                this.target[t.indexOf((MolAtom)m.getAtom((int)j))] = this.targetReactantCount + i;
            }
        }
        for (i = 0; i < this.targetProductCount; ++i) {
            m = t.getProduct(i);
            c = m.getAtomCount();
            for (j = 0; j < c; ++j) {
                this.target[t.indexOf((MolAtom)m.getAtom((int)j))] = this.targetReactantCount + this.targetAgentCount + i;
            }
        }
        for (i = 0; i < this.targetLength; ++i) {
            this.targetReactionStereo[i] = 0;
        }
        for (i = 0; i < this.targetLength; ++i) {
            MolAtom atom = t.getAtom(i);
            this.targetMap[i] = atom.getAtomMap();
            if (this.targetMap[i] <= 0) continue;
            this.targetReactionStereo[i] = atom.getReactionStereo();
        }
        if (!this.searchOptions.isReactionUnpairedMapMatching()) {
            for (int k = 0; k < this.targetLength; ++k) {
                this.targetMapPair[k] = -1;
            }
            this.initMapPair(t, this.targetMap, this.targetMapPair, this.targetLength);
        }
        this.targetInitialized = true;
    }

    @Override
    protected SearchHit findFirst0() throws SearchException {
        this.isHitArrayNeeded = true;
        if (this.getQuery() instanceof RxnMolecule && !(this.getTarget() instanceof RxnMolecule)) {
            return null;
        }
        this.initQuery();
        this.initTarget();
        if (super.excludedTargetAtomCount() == 0 && (this.queryReactantCount > this.targetReactantCount || this.queryAgentCount > this.targetAgentCount || this.queryProductCount > this.targetProductCount)) {
            return null;
        }
        return super.findFirst0();
    }

    @Override
    public void setTarget(Molecule mol) {
        super.setTarget(mol);
        this.targetInitialized = false;
    }

    @Override
    protected boolean isValidHit(SearchHit searchHit) throws SearchException {
        int i;
        if (!super.isValidHit(searchHit)) {
            return false;
        }
        int[] hit = searchHit.getSingleHit();
        for (int i2 = 0; i2 < this.queryComponentPairLength; ++i2) {
            this.queryComponentPair[i2] = -1;
        }
        for (i = 0; i < this.queryLength; ++i) {
            int h;
            if (hit[i] == Integer.MIN_VALUE) {
                h = 0;
            } else {
                if (hit[i] == -2147483641 || hit[i] == -2147483646) continue;
                h = Math.abs(hit[i]);
            }
            int qc = this.queryComponentPair[this.query[i]];
            int tc = this.target[h];
            if (qc == -1) {
                for (int j = 0; j < this.queryComponentPairLength; ++j) {
                    if (this.queryComponentPair[j] != tc) continue;
                    return false;
                }
                this.queryComponentPair[this.query[i]] = tc;
                continue;
            }
            if (this.target[h] == qc) continue;
            return false;
        }
        for (i = 0; i < this.queryLength; ++i) {
            if (this.query[i] >= this.queryReactantCount || this.queryReactionStereo[i] <= 0 || this.reactionStereoType(hit[i], hit[this.queryMapPair[i]]) == this.queryReactionStereo[i]) continue;
            return false;
        }
        return true;
    }

    private boolean compareComponentTypes(int i, int j) {
        if (this.query[i] < this.queryReactantCount) {
            return this.target[j] < this.targetReactantCount;
        }
        if (this.query[i] < this.queryReactantCount + this.queryAgentCount) {
            return this.target[j] >= this.targetReactantCount && this.target[j] < this.targetReactantCount + this.targetAgentCount;
        }
        return this.target[j] >= this.targetReactantCount + this.targetAgentCount;
    }

    @Override
    protected boolean compareAtoms(int queryAtom, int targetAtom) throws SearchException {
        int tm;
        int qi = this.sub.atomIdxInAtomsArray[queryAtom];
        int ti = this.atomIdxInAtomsArray[targetAtom];
        if (queryAtom < this.sub.atomIdxInAtomsArrayLength && targetAtom < this.atomIdxInAtomsArrayLength && qi != -1 && ti != -1 && !this.compareComponentTypes(qi, ti)) {
            return false;
        }
        int qm = queryAtom >= this.sub.atomIdxInAtomsArrayLength || -1 == qi ? 0 : this.queryMap[qi];
        int n = tm = targetAtom >= this.atomIdxInAtomsArrayLength || -1 == ti ? 0 : this.targetMap[ti];
        if (0 != qm) {
            if (0 == tm && ti != -1 && this.queryMapPair[qi] != -1) {
                return false;
            }
            if (this.queryMapPair[qi] == -1 && !this.searchOptions.isReactionUnpairedMapMatching() && tm != 0 && this.targetMapPair[ti] != -1) {
                return false;
            }
        }
        return super.compareAtoms(queryAtom, targetAtom);
    }

    public int reactionStereoType(int i, int j) throws SearchException {
        int pparity;
        int rparity;
        MolAtom ratom;
        int ratomstereo;
        int result;
        if (!this.targetInitialized) {
            this.initTarget();
        }
        if ((result = this.targetReactionStereo[i]) != 0) {
            return result;
        }
        RxnMolecule t = (RxnMolecule)super.getTarget();
        if (t.getParent() != null && t.getParent() instanceof RgMolecule) {
            t = (RxnMolecule)t.clone();
        }
        if ((ratomstereo = StructureSearch.getAtomStereo(ratom = t.getAtom(i), rparity = t.getLocalParity(i))) != 32) {
            return 0;
        }
        MolAtom patom = t.getAtom(j);
        int patomstereo = StructureSearch.getAtomStereo(patom, pparity = t.getLocalParity(j));
        if (patomstereo != 32) {
            return 0;
        }
        Molecule[] reactants = new Molecule[this.targetReactantCount];
        for (int r = 0; r < this.targetReactantCount; ++r) {
            reactants[r] = t.getReactant(r);
        }
        ratom.setReactionStereo(2);
        if (this.reactor == null) {
            this.reactor = new Reactor();
        }
        if (this.reaction == null) {
            this.reaction = new Reaction();
        }
        Molecule[] products = null;
        try {
            this.reaction.setReaction(t);
            this.reactor.setReaction(this.reaction);
            this.reactor.setReactants(reactants);
            products = this.reactor.react();
        }
        catch (ReactionException e) {
            throw new SearchException("Error during reaction processing: " + e);
        }
        if (this.searcher == null) {
            this.searcher = new StructureSearch();
        }
        int p = this.target[j] - this.targetReactantCount - this.targetAgentCount;
        this.searcher.setQuery(t.getProduct(p));
        this.searcher.setTarget(products[p]);
        if (this.searcher.isMatching()) {
            return 2;
        }
        return 1;
    }

    @Override
    protected boolean isCompatibleIdx(int d) {
        int lastQAtom = d;
        int lastTAtom = this.idx[d];
        if (!super.isCompatibleIdx(d)) {
            return false;
        }
        int origQAtom = -1;
        int qMapPair = -1;
        int qMapPairMatch = -1;
        if (lastQAtom >= this.sub.atomIdxInAtomsArrayLength || (origQAtom = this.sub.atomIdxInAtomsArray[lastQAtom]) == -1 || (qMapPair = this.queryMapPair[origQAtom]) == -1 || qMapPair > origQAtom || (qMapPairMatch = this.atomIdxInAtomsArray[-1 + this.idx[this.sub.idxAtomInMatomArray[qMapPair]]]) == -1) {
            return true;
        }
        int origTAtom = -1;
        origTAtom = this.atomIdxInAtomsArray[lastTAtom];
        return origTAtom < 0 || this.targetMap[origTAtom] != 0 && this.targetMap[origTAtom] == this.targetMap[qMapPairMatch];
    }
}

