/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.IntVector;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.license.Licensable;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.Search;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.options.HomologyTranslationOption;
import chemaxon.sss.search.rg.RgSearchComplex;
import chemaxon.sss.search.rg.RgSearchDescriptor;
import chemaxon.sss.search.rg.RgSearchSimple;
import chemaxon.sss.search.rg.RgSearchUtil;
import chemaxon.sss.search.rg.RgSearcher;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.StereoConstants;
import chemaxon.util.EnhStereoConverter;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RgSearch
extends Search
implements StereoConstants,
Licensable {
    public static boolean enumerationModeDisabled = false;
    private RgMolecule query = null;
    private RgMolecule input_query = null;
    private Molecule target = null;
    private Molecule input_target = null;
    private RgSearchDescriptor descriptor = null;
    private RgSearcher searcher;
    private boolean initialized = false;
    private boolean queryInitialized = false;
    private Vector<int[][]> hits = null;
    private int[] excludedTargetAtoms = null;
    private String licenseEnvironment = "";
    private HomologyConversionUtil hcu = null;
    private static Logger logger = Logger.getLogger(RgSearch.class.getName());

    @Override
    public void setTarget(Molecule mol) {
        this.setTarget(mol, null);
    }

    @Override
    public void setTarget(Molecule mol, int[] exclude) {
        this.input_target = mol;
        this.target = mol;
        this.excludedTargetAtoms = exclude;
        this.initialized = false;
    }

    @Override
    public Molecule getTarget() {
        return this.input_target;
    }

    @Override
    public void setQuery(Molecule query) {
        query = this.convertUserDefinedHomologies(query);
        this.input_query = (RgMolecule)query;
        if (query != null) {
            this.query = (RgMolecule)query.clone();
        }
        this.initialized = false;
        this.queryInitialized = false;
    }

    private Molecule convertUserDefinedHomologies(Molecule query) {
        if (this.searchOptions.getHomologyNarrowTranslation() != HomologyTranslationOption.ALL || !HomologyConstants.containsQueryConvertibleHomology(query)) {
            this.hcu = null;
            return query;
        }
        this.hcu = new HomologyConversionUtil();
        this.hcu.setMol(query, false, true);
        Molecule convMol = this.hcu.getConvertedMol();
        if (convMol instanceof RgMolecule) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Homologies Converted: \n" + convMol.toFormat("mrv"));
            }
            return convMol;
        }
        return query;
    }

    @Override
    public void setQuery(Molecule mol, int[] exclude) {
        this.setQuery(mol);
    }

    @Override
    public Molecule getQuery() {
        return this.input_query;
    }

    public void setHitIncludesRNodes(boolean value) {
        this.searchOptions.setHitIncludesRNodes(value);
    }

    private void init() throws SearchException {
        if (this.searchOptions.isSubgraphSearch() && this.searchOptions.isFullFragment()) {
            throw new SearchException("R-group search with FULL_FRAGMENT mode is not implemented yet.");
        }
        this.hits = new Vector();
        if (!this.queryInitialized) {
            if (RgSearchUtil.containsNestedRgroup(this.query)) {
                throw new SearchException("Nested R-groups are not implemented yet.");
            }
            EnhStereoConverter.convert(this.query, this.searchOptions.isQueryAbsoluteStereo());
            RgSearchUtil.autoMap(this.query);
            this.descriptor = new RgSearchDescriptor(this.query, this.searchOptions);
            this.descriptor.queryHasExplicitH = RgSearchUtil.hasExplicitH(this.query);
        }
        this.initSearcher();
        this.initialized = true;
    }

    private void initSearcher() {
        if (this.descriptor.isSimpleCase && !this.queryInitialized) {
            this.searcher = new RgSearchSimple(this.licenseEnvironment, this, this.descriptor, this.target, this.excludedTargetAtoms);
            this.queryInitialized = true;
        } else if (!this.descriptor.isSimpleCase && !this.queryInitialized) {
            this.searchOptions.ignoreChiralityForAtoms = this.descriptor.nonChiral;
            this.searcher = new RgSearchComplex(this.licenseEnvironment, this, this.descriptor, this.target, this.excludedTargetAtoms);
            this.queryInitialized = true;
        } else if (this.queryInitialized) {
            this.searcher.setTarget(this.target, this.excludedTargetAtoms);
        }
    }

    @Override
    protected SearchHit findFirstHit() throws SearchException {
        this.initialized = false;
        return this.findNextHit();
    }

    @Override
    protected SearchHit findNextHit() throws SearchException {
        SearchHit groupHit;
        if (!this.initialized) {
            this.init();
        }
        SearchHit hit = null;
        do {
            if ((hit = this.searcher.findNext()) == null) {
                return null;
            }
            int[] singleHit = hit.getSingleHit();
            groupHit = this.convertGroupHit(hit);
            if (!this.searchOptions.isHitIncludesRNodes()) continue;
            singleHit = this.getRootHit(this.input_query, singleHit);
            hit.setSingleHit(singleHit);
        } while (!this.searchOptions.isOrderSensitiveSearch() && !RgSearchUtil.isNewHit(this.hits, groupHit.getGroupHit()));
        this.hits.add(groupHit.getGroupHit());
        return groupHit;
    }

    public static void printHit(int[] hit) {
        StringBuffer sbHit = new StringBuffer();
        for (int j = 0; j < hit.length; ++j) {
            sbHit.append(hit[j] + " ");
        }
        System.out.println(sbHit.toString());
    }

    private SearchHit convertGroupHit(SearchHit hit) {
        int[] singleHit = hit.getSingleHit();
        int[][] hit2D = hit.getGroupHit();
        boolean isRealGroupHit = false;
        for (int[] hitRow : hit2D) {
            if (hitRow.length <= 1) continue;
            isRealGroupHit = true;
            break;
        }
        if (!isRealGroupHit) {
            return hit;
        }
        IntVector firstElements = new IntVector();
        for (int[] h : hit2D) {
            firstElements.add(h[0]);
        }
        int[][] newHit2D = new int[singleHit.length][];
        for (int i = 0; i < singleHit.length; ++i) {
            if (HomologyConstants.isHomologyRAtom(this.input_query.getAtom(i)) && !this.descriptor.isSimpleCase) {
                newHit2D[i] = RgSearchUtil.getHomologyRgrHit(this.descriptor.rgnodes, i);
                continue;
            }
            int indIn2D = firstElements.indexOf(singleHit[i]);
            if (indIn2D > -1) {
                newHit2D[i] = hit2D[indIn2D];
                continue;
            }
            newHit2D[i] = new int[1];
            newHit2D[i][0] = singleHit[i];
        }
        hit.setGroupHit(newHit2D);
        return hit;
    }

    @Override
    public boolean isMatching() throws SearchException {
        return this.findFirst() != null;
    }

    @Override
    public void stop() {
    }

    private int[] getRootHit(RgMolecule query, int[] hit) {
        int atomCount = query.getAtomCount();
        int[] result = (int[])hit.clone();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            int[] hgHit;
            MolAtom atom = query.getAtom(atomIndex);
            if (!HomologyConstants.isHomologyRAtom(atom) || this.descriptor.isSimpleCase || (hgHit = RgSearchUtil.getHomologyRgrHit(this.descriptor.rgnodes, atomIndex)) == null || hgHit.length <= 0) continue;
            result[atomIndex] = hgHit[0];
        }
        return result;
    }

    public Hashtable<String, Boolean> getStereoMatchingDirections(MolSearch ms, int[] hit) {
        return ms.getStereoMatchingDirections(hit);
    }

    @Override
    public boolean isLicensed() {
        return true;
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }
}

