/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import java.util.HashMap;
import java.util.Map;

class SearchAtomDescriptor {
    private static final int BOND_TYPES = 4;
    private static final int AROMATIC = 0;
    private static final int SINGLE = 1;
    private static final int DOUBLE = 2;
    private static final int TRIPLE = 3;
    private static final int AROMATIC_MASK = 255;
    private static final int SINGLE_MASK = 65280;
    private static final int DOUBLE_MASK = 0xFF0000;
    private static final int TRIPLE_MASK = -16777216;
    public static final int ALL_MASK = -1;
    private static final int AROMATIC_NEW = 1;
    private static final int SINGLE_NEW = 256;
    private static final int DOUBLE_NEW = 65536;
    private static final int TRIPLE_NEW = 0x1000000;
    Map<Integer, Integer>[] neighbors = new HashMap[4];

    public SearchAtomDescriptor() {
        for (int i = 0; i < 4; ++i) {
            this.neighbors[i] = new HashMap<Integer, Integer>();
        }
    }

    public void addNeighbor(int bondType, int[] atNo) {
        for (int an : atNo) {
            this.addNeighbor(bondType, an);
        }
    }

    public void addNeighbor(int bondType, int atNo) {
        switch (bondType) {
            case 0: {
                for (int i = 0; i < 4; ++i) {
                    this.addNeighborByBond(i, atNo);
                }
                break;
            }
            case 4: {
                this.addNeighborByBond(0, atNo);
                break;
            }
            case 6: {
                for (int i = 0; i < 2; ++i) {
                    this.addNeighborByBond(i, atNo);
                }
                break;
            }
            case 5: {
                for (int i = 1; i < 3; ++i) {
                    this.addNeighborByBond(i, atNo);
                }
                break;
            }
            case 7: {
                this.addNeighborByBond(0, atNo);
                this.addNeighborByBond(2, atNo);
                break;
            }
            default: {
                this.addNeighborByBond(bondType, atNo);
            }
        }
    }

    private void addNeighborByBond(int bondType, int an) {
        Integer val = this.neighbors[bondType].get(an);
        if (val == null) {
            this.neighbors[bondType].put(an, 1);
        } else {
            Integer n = val;
            Integer n2 = val = Integer.valueOf(val + 1);
        }
    }

    public boolean isMatching(SearchAtomDescriptor ad) {
        for (int i = 0; i < 4; ++i) {
            if (this.isMatching(i, ad)) continue;
            return false;
        }
        return true;
    }

    private boolean isMatching(int bondType, SearchAtomDescriptor ad) {
        for (Map.Entry<Integer, Integer> entry : this.neighbors[bondType].entrySet()) {
            Integer val = ad.neighbors[bondType].get(entry.getKey());
            if (val != null && entry.getValue() <= val) continue;
            return false;
        }
        return true;
    }

    public static int addToNeighborDescriptor(int current, int btype) {
        int result;
        switch (btype) {
            case 0: {
                result = (current << 1 | 1) & 0xFF | (current << 1 | 0x100) & 0xFF00 | (current << 1 | 0x10000) & 0xFF0000 | (current << 1 | 0x1000000) & 0xFF000000;
                break;
            }
            case 4: {
                result = (current << 1 | 1) & 0xFF;
                break;
            }
            case 6: {
                result = (current << 1 | 1) & 0xFF | (current << 1 | 0x100) & 0xFF00;
                break;
            }
            case 5: {
                result = (current << 1 | 0x100) & 0xFF00 | (current << 1 | 0x10000) & 0xFF0000;
                break;
            }
            case 7: {
                result = (current << 1 | 1) & 0xFF | (current << 1 | 0x10000) & 0xFF0000;
                break;
            }
            case 1: {
                result = (current << 1 | 0x100) & 0xFF00;
                break;
            }
            case 2: {
                result = (current << 1 | 0x10000) & 0xFF0000;
                break;
            }
            case 3: {
                result = (current << 1 | 0x1000000) & 0xFF000000;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result | current;
    }
}

