/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.core.calculations.BondClassifier;
import chemaxon.core.calculations.RingClassifier;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.enumeration.supergraph.util.SupergraphBondClassifier;
import chemaxon.sss.search.MoleculeMatcher;
import chemaxon.sss.search.StructureSearch;
import chemaxon.struc.Molecule;
import java.util.BitSet;

public class SearchRingAtomMatcher
implements MoleculeMatcher {
    private StructureSearch searcher;
    private BitSet targetRingMembership;
    private BitSet queryRingMembership;

    @Override
    public void setTarget(Molecule molecule) {
        this.targetRingMembership = null;
    }

    @Override
    public void setQuery(Molecule molecule) {
        this.queryRingMembership = null;
    }

    @Override
    public void setSearcher(StructureSearch searcher) {
        this.searcher = searcher;
    }

    @Override
    public void compareAllAtoms() {
        if (this.queryRingMembership == null) {
            this.fillQueryRingMembership();
        }
        if (this.targetRingMembership == null) {
            this.fillTargetRingMembership();
        }
        int qMatomIndex = -1;
        while ((qMatomIndex = this.queryRingMembership.nextSetBit(qMatomIndex + 1)) != -1) {
            this.searcher.map.andRowNoLog(qMatomIndex, this.targetRingMembership);
        }
    }

    private void fillTargetRingMembership() {
        Molecule target = this.searcher.molecule;
        int[] matomAtomMap = this.searcher.atomIdxInAtomsArray;
        BitSet ringMembership = new BitSet(this.searcher.matomLength);
        RingClassifier rc = target instanceof Supergraph ? new SupergraphBondClassifier() : new BondClassifier();
        this.fillRingMembership(target, matomAtomMap, ringMembership, rc, this.searcher.matomLength);
        this.targetRingMembership = ringMembership;
    }

    private void fillQueryRingMembership() {
        Molecule query = this.searcher.sub.molecule;
        int[] matomAtomMap = this.searcher.sub.atomIdxInAtomsArray;
        BitSet ringMembership = new BitSet(this.searcher.sub.matomLength);
        BondClassifier rc = new BondClassifier();
        this.fillRingMembership(query, matomAtomMap, ringMembership, rc, this.searcher.sub.matomLength);
        this.queryRingMembership = ringMembership;
    }

    private void fillRingMembership(Molecule molecule, int[] matomAtomMap, BitSet ringMembership, RingClassifier rc, int matomLength) {
        rc.classify(molecule);
        for (int matomIndex = 0; matomIndex < matomLength; ++matomIndex) {
            int atomIndex = matomAtomMap[matomIndex];
            if (atomIndex < 0) continue;
            ringMembership.set(matomIndex, rc.isRingAtom(atomIndex));
        }
    }

    @Override
    public boolean isSpecialQueryH(int atomInd) {
        return false;
    }

    @Override
    public boolean isSpecialTargetH(int atomInd) {
        return false;
    }

    @Override
    public boolean refine() {
        return false;
    }
}

