/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.modules.smarts.ParseException;
import chemaxon.marvin.modules.smarts.SimpleNode;
import chemaxon.marvin.modules.smarts.SmartsAtomTreeParser;
import chemaxon.marvin.modules.smarts.SmartsAtomTreeParserTreeConstants;
import chemaxon.sss.SearchConstants;
import chemaxon.sss.search.InitializationIndicator;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.Search;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.StructureSearch;
import chemaxon.struc.MolAtom;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.StereoConstants;
import chemaxon.util.MolHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.BitSet;
import java.util.HashMap;

class SmartsAtomMatcher
implements SmartsAtomTreeParserTreeConstants,
StereoConstants,
SearchConstants {
    SmartsAtomMatcher() {
    }

    static boolean isRecursiveMatching(StructureSearch targetSearch, int targetAtom, String subQuery) throws SearchException {
        boolean isSearchNeeded = true;
        BitSet subQueryResult = null;
        if (targetSearch.recursiveSmartsResults == null) {
            targetSearch.recursiveSmartsResults = new HashMap();
        } else {
            subQueryResult = targetSearch.recursiveSmartsResults.get(subQuery);
            if (subQueryResult != null) {
                isSearchNeeded = false;
            }
        }
        if (isSearchNeeded) {
            MolSearch recursiveSearch = new MolSearch();
            recursiveSearch.setLicenseEnvironment("StructureSearchForInternalMolSearchLicenseEnvironment");
            recursiveSearch.setTarget(targetSearch.getTarget());
            MolHandler mh = null;
            mh = SmartsAtomMatcher.createMolHandlerFromSMARTS(subQuery);
            mh.aromatize(2);
            recursiveSearch.setQuery(mh.getMolecule());
            recursiveSearch.searchOptions.setOrderSensitiveSearch(true);
            recursiveSearch.setVerbose(targetSearch.getSearchOptions().verbose);
            recursiveSearch.getSearchOptions().setDistinctFirstAtomMatching(true);
            recursiveSearch.getSearchOptions().setKeepQueryOrder(true);
            subQueryResult = recursiveSearch.getMatchingAtoms(0);
            targetSearch.recursiveSmartsResults.put(subQuery, subQueryResult);
        }
        if (-1 == targetSearch.atomIdxInAtomsArray[targetAtom]) {
            int heavyNeighbour = targetSearch.bto[targetSearch.bondidx[targetAtom]];
            int atomCount = targetSearch.getTarget().getAtomCount();
            int origHeavyIdx = targetSearch.atomIdxInAtomsArray[heavyNeighbour];
            return subQueryResult.get(origHeavyIdx + atomCount);
        }
        return subQueryResult.get(targetSearch.atomIdxInAtomsArray[targetAtom]);
    }

    private static MolHandler createMolHandlerFromSMARTS(String subQuery) throws SearchException {
        byte[] b = subQuery.getBytes();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(b);
            MolInputStream mis = new MolInputStream((InputStream)is, "smarts");
            MolImporter mi = new MolImporter(mis);
            mi.setQueryMode(true);
            return new MolHandler(mi.read());
        }
        catch (MolFormatException ex) {
            throw new SearchException(ex.toString(), ex);
        }
        catch (IOException ex) {
            throw new SearchException(ex.toString(), ex);
        }
    }

    static void prepareSMARTSTrees(StructureSearch s) throws ParseException {
        SmartsAtomTreeParser parser = null;
        for (int i = 0; i < s.atomsLength; ++i) {
            String queryStr;
            if (s.atoms[i] == null || (queryStr = s.atoms[i].getQuerystr()) == null || s.isExcluded(i)) continue;
            if (s.smartsAtomTrees == null) {
                s.smartsAtomTrees = new SimpleNode[s.atomsLength];
            }
            StringReader sr = new StringReader(queryStr);
            parser = new SmartsAtomTreeParser(sr);
            s.smartsAtomTrees[i] = parser.parseSmartsAtomExpression();
        }
    }

    public static void analyseTrees(StructureSearch s, InitializationIndicator ii) {
        if (s.smartsAtomTrees == null) {
            return;
        }
        for (int i = 0; i < s.atomsLength; ++i) {
            if (s.smartsAtomTrees[i] == null) continue;
            SmartsAtomMatcher.collectInitializationIndicator(s.smartsAtomTrees[i], ii);
            s.hasQueryProperty = true;
        }
    }

    private static void collectInitializationIndicator(SimpleNode node, InitializationIndicator ii) {
        block0 : switch (node.getId()) {
            case 6: {
                char first = node.getValue().charAt(0);
                if (Character.isLowerCase(first) || Character.isUpperCase(first)) {
                    ii.isAromaticityNeeded = true;
                }
                if (!node.getValue().equals("#1") && !node.getValue().equals("H")) break;
                ii.isAllHydrogensNeeded = true;
                break;
            }
            case 7: {
                String value = node.getValue();
                if (!(value.equals("@") || value.equals("@@") || value.equals("@?") || value.equals("@@?"))) {
                    System.err.println("Warning: unsupported chiral specification:" + node.getValue());
                    System.err.println("Will always be accepted.");
                }
                ii.isChiralityNeeded = true;
                break;
            }
            case 9: {
                ii.isMapNeeded = true;
                break;
            }
            case 5: {
                switch (node.getValue().charAt(0)) {
                    case 'A': 
                    case 'a': {
                        ii.isAromaticityNeeded = true;
                        break block0;
                    }
                    case 'H': {
                        ii.isHydrogenCountNeeded = true;
                        break block0;
                    }
                    case 'h': {
                        break block0;
                    }
                    case 'R': {
                        if (node.getValue().length() == 1 || "R0".equals(node.getValue())) {
                            ii.isRingMembershipNeeded = true;
                            break block0;
                        }
                        ii.isRingCountNeeded = true;
                        break block0;
                    }
                    case 'r': {
                        if (node.getValue().length() == 1) {
                            ii.isRingMembershipNeeded = true;
                            break block0;
                        }
                        ii.isRingSizeNeeded = true;
                        break block0;
                    }
                    case 'D': {
                        ii.isExplicitConnectionsNeeded = true;
                        break block0;
                    }
                    case 'v': {
                        ii.isValenceNeeded = true;
                        break block0;
                    }
                    case 'X': {
                        ii.isConnectionNeeded = true;
                        break block0;
                    }
                    case 'x': {
                        ii.isRingBondCountNeeded = true;
                        ii.isRingMembershipNeeded = true;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                String s = node.getValue();
                if (s.indexOf("[H") == -1 && s.indexOf("#1") == -1) break;
                ii.isAllHydrogensNeeded = true;
                break;
            }
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SmartsAtomMatcher.collectInitializationIndicator((SimpleNode)node.jjtGetChild(i), ii);
        }
    }

    public static boolean evaluateSmartsAtomTree(StructureSearch qs, SimpleNode node, int queryAtom, StructureSearch ts, int targetAtom) throws SearchException {
        boolean value = false;
        int sign = 1;
        switch (node.getId()) {
            case 1: {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    value = SmartsAtomMatcher.evaluateSmartsAtomTree(qs, (SimpleNode)node.jjtGetChild(i), queryAtom, ts, targetAtom);
                    if (value) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    value = SmartsAtomMatcher.evaluateSmartsAtomTree(qs, (SimpleNode)node.jjtGetChild(i), queryAtom, ts, targetAtom);
                    if (!value) continue;
                    return true;
                }
                return false;
            }
            case 4: {
                if (ts.depth < ts.qryAtoms && ((SimpleNode)node.jjtGetChild(0)).getId() == 7) {
                    return true;
                }
                value = SmartsAtomMatcher.evaluateSmartsAtomTree(qs, (SimpleNode)node.jjtGetChild(0), queryAtom, ts, targetAtom);
                return !value;
            }
            case 6: {
                String qAtom = node.getValue();
                int qAtomNo = -1;
                if (qAtom.equals("*")) {
                    return !ts.isPlainH(targetAtom);
                }
                if (qAtom.charAt(0) == '#') {
                    qAtomNo = Integer.parseInt(qAtom.substring(1));
                } else {
                    int qAromaticity;
                    int n = qAromaticity = Character.isLowerCase(qAtom.charAt(0)) ? 1 : 2;
                    if (ts.aromatic[targetAtom] != qAromaticity) {
                        return false;
                    }
                    qAtomNo = PeriodicSystem.getAtomicNumber(qAtom);
                }
                if (qAtomNo == 0) {
                    return ts.matom[targetAtom] == 131;
                }
                if (ts.matom[targetAtom] != qAtomNo) {
                    return false;
                }
                if (ts.searchOptions.getIsotopeMatching() == 1 && SmartsAtomMatcher.hasNotIsotopeSibling(node) && ts.isotope[targetAtom] != 0) {
                    return false;
                }
                if (!SmartsAtomMatcher.negated(node)) {
                    ts.exactIsotopeFailed = false;
                }
                return true;
            }
            case 8: {
                return SmartsAtomMatcher.isRecursiveMatching(ts, targetAtom, node.getValue());
            }
            case 7: {
                int parityClass;
                int i;
                if (ts.depth < ts.qryAtoms) {
                    ts.needToRepeatChiralCheck = true;
                    return true;
                }
                int QParity = -1;
                String Qvalue = node.getValue();
                if (Qvalue.equals("@")) {
                    QParity = 2;
                } else if (Qvalue.equals("@@")) {
                    QParity = 1;
                } else if (Qvalue.equals("@?")) {
                    QParity = 6;
                } else if (Qvalue.equals("@@?")) {
                    QParity = 5;
                } else {
                    return true;
                }
                int[] n = new int[4];
                MolAtom qMAtom = qs.atoms[qs.atomIdxInAtomsArray[queryAtom]];
                for (i = 0; i < qMAtom.getBondCount(); ++i) {
                    MolAtom neighbourMolAtom = qMAtom.getLigand(i);
                    boolean isPlainH = neighbourMolAtom.getAtno() == 1 && neighbourMolAtom.getMassno() == 0;
                    n[i] = isPlainH ? Integer.MAX_VALUE : qs.getTarget().indexOf(neighbourMolAtom);
                }
                if (i < 4) {
                    while (i < 4) {
                        n[i] = Integer.MAX_VALUE;
                        ++i;
                    }
                }
                if ((parityClass = MolAtom.paritySign(n[0], n[1], n[2], n[3])) == -1) {
                    if (QParity == 1) {
                        QParity = 2;
                    } else if (QParity == 2) {
                        QParity = 1;
                    }
                }
                int QAtomStereo = Search.getAtomStereo(qs.atoms[qs.atomIdxInAtomsArray[queryAtom]], QParity);
                int oldQAtomStereo = qs.atomStereo[queryAtom];
                int oldQParity = qs.parity[queryAtom];
                qs.atomStereo[queryAtom] = QAtomStereo;
                qs.parity[queryAtom] = QParity;
                boolean returnValue = ts.compareChiralities(queryAtom, targetAtom);
                qs.atomStereo[queryAtom] = oldQAtomStereo;
                qs.parity[queryAtom] = oldQParity;
                return returnValue;
            }
            case 9: {
                return true;
            }
            case 5: {
                char label = node.getValue().charAt(0);
                switch (label) {
                    case 'A': 
                    case 'a': {
                        int qAromaticity = label == 'a' ? 1 : 2;
                        return ts.aromatic[targetAtom] == qAromaticity;
                    }
                    case 'H': {
                        int qHCount = node.getValue().length() == 1 ? 1 : Integer.parseInt(node.getValue().substring(1));
                        return ts.hcount[targetAtom] == qHCount;
                    }
                    case 'h': {
                        int qHCount = node.getValue().length() == 1 ? 1 : Integer.parseInt(node.getValue().substring(1));
                        MolAtom atom = ts.atoms[ts.atomIdxInAtomsArray[targetAtom]];
                        return atom.getImplicitHcount() == qHCount;
                    }
                    case 'R': {
                        if (node.getValue().length() == 1) {
                            int atomsIdx = ts.atomIdxInAtomsArray[targetAtom];
                            if (-1 == atomsIdx) {
                                return false;
                            }
                            return ts.targetRingClassifier.isRingAtom(atomsIdx);
                        }
                        if ("R0".equals(node.getValue())) {
                            int atomsIdx = ts.atomIdxInAtomsArray[targetAtom];
                            if (-1 == atomsIdx) {
                                return true;
                            }
                            return !ts.targetRingClassifier.isRingAtom(atomsIdx);
                        }
                        int qRcount = Integer.parseInt(node.getValue().substring(1));
                        return ts.ringCount[targetAtom] == qRcount;
                    }
                    case 'r': {
                        if (node.getValue().length() == 1) {
                            int atomsIdx = ts.atomIdxInAtomsArray[targetAtom];
                            if (atomsIdx < 0) {
                                return false;
                            }
                            return ts.targetRingClassifier.isRingAtom(atomsIdx);
                        }
                        int qRSize = Integer.parseInt(node.getValue().substring(1));
                        return ts.smallestRingSize[targetAtom] == qRSize;
                    }
                    case 'x': {
                        if (node.getValue().length() == 1) {
                            return ts.ringBondCount[targetAtom] > 0;
                        }
                        int qRBondCount = Integer.parseInt(node.getValue().substring(1));
                        return ts.ringBondCount[targetAtom] == qRBondCount;
                    }
                    case '-': {
                        sign = -1;
                    }
                    case '+': {
                        int qCharge = sign;
                        if (ts.searchOptions.getChargeMatching() == 2) {
                            return true;
                        }
                        if (node.getValue().length() != 1) {
                            qCharge = "+-".indexOf(node.getValue().charAt(1)) != -1 ? (qCharge *= node.getValue().length()) : (qCharge *= Integer.parseInt(node.getValue().substring(1)));
                        }
                        return qCharge == ts.acharge[targetAtom];
                    }
                    case 'D': {
                        int qD = node.getValue().length() == 1 ? 1 : Integer.parseInt(node.getValue().substring(1));
                        int atomsIdx = ts.atomIdxInAtomsArray[targetAtom];
                        if (atomsIdx < 0) {
                            return qD == 1;
                        }
                        int edgeCount = ts.getSubstitutionCount(atomsIdx, ts.atoms[atomsIdx]);
                        return qD == edgeCount;
                    }
                    case 'v': {
                        if (!ts.searchOptions.isValenceMatching()) {
                            return true;
                        }
                        int qV = node.getValue().length() == 1 ? 1 : Integer.parseInt(node.getValue().substring(1));
                        return qV == ts.valence[targetAtom];
                    }
                    case 'X': {
                        int qX = node.getValue().length() == 1 ? 1 : Integer.parseInt(node.getValue().substring(1));
                        return qX == ts.connection[targetAtom];
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (ts.searchOptions.getIsotopeMatching() == 2) {
                            return true;
                        }
                        int qMass = Integer.parseInt(node.getValue());
                        if (ts.isotope[targetAtom] != qMass) {
                            return false;
                        }
                        if (!SmartsAtomMatcher.negated(node)) {
                            ts.exactIsotopeFailed = false;
                        }
                        return true;
                    }
                }
                throw new SearchException("Invalid query treenode value:\"" + node + "\"");
            }
        }
        throw new SearchException("Invalid treenode type: " + node);
    }

    private static boolean negated(SimpleNode node) {
        SimpleNode parent = (SimpleNode)node.jjtGetParent();
        return parent != null && parent.getId() == 4;
    }

    private static boolean hasNotIsotopeSibling(SimpleNode node) {
        SimpleNode parent = (SimpleNode)node.jjtGetParent();
        if (parent == null || parent.getId() != 1) {
            return true;
        }
        int n = parent.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode sibling = (SimpleNode)parent.jjtGetChild(i);
            if (sibling.getId() != 5 || !Character.isDigit(sibling.getValue().charAt(0))) continue;
            return true;
        }
        return false;
    }
}

