/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.BondClassifier;
import chemaxon.core.calculations.RingClassifier;
import chemaxon.enumeration.bracket.PolymerUtil;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.marvin.modules.smarts.ParseException;
import chemaxon.marvin.modules.smarts.SimpleNode;
import chemaxon.sss.search.AtomRearranger;
import chemaxon.sss.search.BitSetSearchMap;
import chemaxon.sss.search.BracketComparator;
import chemaxon.sss.search.DataSgroupComparator;
import chemaxon.sss.search.InitializationIndicator;
import chemaxon.sss.search.MolComparator;
import chemaxon.sss.search.MoleculeMatcher;
import chemaxon.sss.search.ReactingCenterComparator;
import chemaxon.sss.search.Search;
import chemaxon.sss.search.SearchAtomDescriptor;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.SearchMap;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.SearchTimeoutException;
import chemaxon.sss.search.SearchUtil;
import chemaxon.sss.search.SmartsAtomMatcher;
import chemaxon.sss.search.SmartsBondMatcher;
import chemaxon.sss.search.StereoMatcher;
import chemaxon.sss.search.bracket.PolymerMatcher;
import chemaxon.sss.search.options.HomologyTranslationOption;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.util.Dumper;
import chemaxon.util.IntIntQuickSort;
import chemaxon.util.MolHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

class StructureSearch
extends Search {
    static final int INITMODE_SPECIAL_HYDROGENS_ONLY = 0;
    static final int INITMODE_EXPLICIT = 1;
    static final int INITMODE_ALL = 2;
    private static final boolean[][] enhStereoMatching = new boolean[][]{{true, true, true, true}, {false, true, false, false}, {false, true, true, false}, {false, true, true, true}};
    private int initMode = 1;
    int[] matom;
    protected int matomLength = -1;
    int[] isotope;
    private int isotopeLength = -1;
    SearchMap map;
    protected int[] idx;
    protected boolean[] usd;
    protected int usdLength = -1;
    protected int[] ind;
    private int indLength = -1;
    boolean hasQueryProperty = false;
    private boolean initialized = false;
    private boolean queryPropertiesInitialized = false;
    private boolean chiralityInitialized = false;
    private boolean hasExplicitHydrogen = false;
    MolAtom[] atoms;
    int atomsLength = -1;
    int[] atomIdxInAtomsArray;
    int atomIdxInAtomsArrayLength = -1;
    protected int[] idxAtomInMatomArray;
    protected int idxAtomInMatomArrayLength = -1;
    int[] abonds;
    int[] bondidx;
    int[] btyp;
    int btypLength = -1;
    int[] bFrom;
    int[] bto;
    private int btoLength = -1;
    private int maxbonds = 0;
    private int[] lst;
    private int[] lstcnt;
    private int[] lstidx;
    int[] acharge;
    private int[] radical;
    int[] hcount;
    protected int hcountLength = -1;
    private int[] hidx;
    int[] hydrogens;
    protected int hydrogensLength = -1;
    private int steps = -1;
    private BitSet specialHToHandle;
    private boolean hasSpecialHToHandle = false;
    int[] connection;
    protected int connectionLength = -1;
    int[] explConnection;
    protected int explConnectionLength = -1;
    int[] valence;
    private int valenceLength = -1;
    int[] hydrogen;
    int hydrogenLength = -1;
    int[] hydrogenGreaterRelation;
    boolean convertExplHToHCount = false;
    int[] implH;
    private int implHLength = -1;
    int[] aromatic;
    private int aromaticLength = -1;
    int[] ringCount;
    private int ringCountLength = -1;
    int[] smallestRingSize;
    private int smallestRingSizeLength = -1;
    protected int[] substCount;
    protected static final int SUBSTCOUNT_OFFSET = 1000000;
    protected static final int SUBSTCOUNT_MULTIPLIER = 1000;
    protected int substCountLength = -1;
    int[] ringBondCount;
    private int ringBondCountLength = -1;
    protected boolean hasUnSaturatedFlag = false;
    int[] atomStereo;
    private boolean hasAtomStereo;
    private int[] stereoGroupType;
    private int[] stereoGroupNumber;
    private int[] prevIndexInStereoGroup;
    int[] parity;
    private int[] gParity = null;
    private int parityLength = -1;
    protected int strAtoms = 0;
    int qryAtoms = 0;
    protected StructureSearch sub;
    int depth;
    ArrayList<SearchHit> hits = null;
    protected int[] chneib = new int[10];
    boolean hasDoubleBondStereo;
    protected boolean isHitArrayNeeded = true;
    private int[] excludedAtoms;
    private int excludedAtomsLength = -1;
    protected boolean _IAmTheQuery = false;
    protected boolean foundZeroLineInMap = false;
    boolean isZeroLineProhibited = true;
    protected int[] component = null;
    protected static final int NOT_MATCHING = -2;
    protected static final int CTI_COUNT = 4;
    protected static final int CTI_INDEX_DB = 0;
    protected static final int CTI_INDEX_A1 = 1;
    protected static final int CTI_INDEX_A2 = 2;
    protected static final int CTI_INDEX_TYPE = 3;
    private static final int CTI_MAX_NEIB = 10;
    protected int ctiRecordsLength = 0;
    protected int[] ctiRecords = null;
    protected int[] dBSWaitsFor = null;
    protected int[] dBSRecord = null;
    private boolean[] isSymmetrical = null;
    private boolean hasMultiValent = false;
    private boolean[] multiValentV = null;
    private boolean[] multiValentVCisT = null;
    protected Molecule molecule;
    HashMap<String, BitSet> recursiveSmartsResults = null;
    private boolean optIsPerfectSearch = false;
    protected boolean optIsExactQueryAtomMatching = false;
    private boolean optIsExactBondMatching = false;
    private boolean optHasUserComparators = false;
    private int optRadicalMatching = 0;
    private int optIsotopeMatching = 0;
    private int optChargeMatching = 0;
    private boolean optIsExactStereoMatching = false;
    private boolean optCheckSpHyb = false;
    private boolean isTetrahedralStereoSearch = true;
    private boolean isDoubleBondStereoSearch = true;
    private boolean isFastSearch = true;
    private int[] stat_atomTypeCounts = null;
    private int stat_atomTypeCountsLength = 0;
    protected int[] stat_bondTypeCounts = null;
    private boolean isComponentInitialized = false;
    public SimpleNode[] smartsAtomTrees = null;
    InitializationIndicator targetInit = new InitializationIndicator();
    RingClassifier targetRingClassifier = null;
    int[] bondTopology = null;
    public SimpleNode[] smartsBondTrees = null;
    private int[] componentLevelGrouping = null;
    private int componentLevelGroupingLength = -1;
    boolean needToRepeatChiralCheck = false;
    private Molecule origQuery;
    protected int[] queryRearrangedToOrig;
    private int[] queryOrigToRearranged;
    private int[] chiralAtoms;
    private int[] chiralAtomWaitsFor;
    private int chiralAtomsLenght;
    protected volatile boolean stopping = false;
    private int[] lPCount;
    private boolean hasLP;
    private IntVector lpIndices;
    protected int[] neib1 = new int[10];
    protected int[] neib2 = new int[10];
    boolean exactIsotopeFailed = false;
    ArrayList<MolComparator> molcomparators = new ArrayList();
    ArrayList<MolComparator> usedMolComparators = null;
    ArrayList<MolComparator> maybeUsedMolComparators = new ArrayList();
    MolComparator[] userDefinedComparators = null;
    boolean areStandardMolComparatorsAdded = false;
    MoleculeMatcher[] moleculeMatchers;
    PolymerMatcher polymerSU = null;
    private static final Logger logger = Logger.getLogger(StructureSearch.class.getName() + ".general");
    private static final Logger duplicateLogger = Logger.getLogger(StructureSearch.class.getName() + ".duplicate");
    protected boolean isMarkushSearch = false;
    protected int[] attBondsHash;
    private boolean hasSpecificAtomStereo = false;
    public static final int QUERY_AROMATICITY_SHIFT = 5;
    private static final int QUERY_AROMATICITY_MASK = 96;
    protected boolean hasAmbigArom = false;
    public static final Hashtable<String, Integer> SPECIAL_PSEUDO_INDEXES = new Hashtable(30);
    public static final int PSEUDO_IDX_AH = 0;
    public static final int PSEUDO_IDX_G1 = 1;
    public static final int PSEUDO_IDX_G14 = 14;
    public static final int PSEUDO_IDX_G17 = 17;
    public static final int PSEUDO_IDX_QH = 19;
    public static final int PSEUDO_IDX_M = 20;
    public static final int PSEUDO_IDX_MH = 21;
    public static final int PSEUDO_IDX_X = 22;
    public static final int PSEUDO_IDX_XH = 23;
    private int multiCenterCount = 0;
    static final int UNLABELLED_STEREOCENTER_AND_GROUP_LABEL = -2;
    public static final String DUPLICATE_CHECK_MARKER = "[DUP]";

    protected static int getSpecialPseudoIndex(String key) {
        Integer v = SPECIAL_PSEUDO_INDEXES.get(key);
        if (v == null) {
            return -1;
        }
        return v;
    }

    protected int getSpecialPseudoIndex(int index) {
        return StructureSearch.getSpecialPseudoIndex(this.atoms[index].getAliasstr().toUpperCase());
    }

    public StructureSearch() {
        this.hits = new ArrayList();
    }

    @Override
    public Molecule getQuery() {
        return this.sub != null ? this.sub.getTarget() : null;
    }

    @Override
    public void setQuery(Molecule mol) {
        this.createSub(mol);
        this.sub._IAmTheQuery = true;
        this.queryPropertiesInitialized = false;
        this.chiralityInitialized = false;
        this.clearMatch();
        this.sub.setTarget(mol);
        this.unInitialize();
    }

    protected void createSub(Molecule query) {
        this.sub = new StructureSearch();
    }

    @Override
    public void setQuery(Molecule mol, int[] exclude) {
        this.setQuery(mol);
        this.sub.excludeAtoms(exclude);
    }

    @Override
    public Molecule getTarget() {
        return this.molecule;
    }

    @Override
    public void setTarget(Molecule mol) {
        Molecule molClone = mol;
        if (mol == null) {
            this.freeTargetMemory();
        } else if (mol.getSgroupCount() > 0 && !(mol instanceof Supergraph) && !(molClone = (Molecule)mol.clone()).expandSgroups()) {
            molClone = mol;
        }
        this.molecule = molClone;
        this.excludedAtoms = null;
        this.excludedAtomsLength = -1;
        this.clearMatch();
        this.unInitialize();
    }

    private void freeTargetMemory() {
        this.molecule = null;
        this.map = null;
        for (int i = 0; i < this.molcomparators.size(); ++i) {
            MolComparator mc = this.molcomparators.get(i);
            mc.setTarget(null);
        }
        this.atoms = null;
        this.atomsLength = -1;
    }

    @Override
    public void setTarget(Molecule mol, int[] exclude) {
        this.setTarget(mol);
        this.excludeAtoms(exclude);
    }

    public void addComparator(MolComparator mc) {
        this.molcomparators.add(mc);
        mc.setSearcher(this);
    }

    public void initUserComparators() {
        if (this.optHasUserComparators) {
            this.userDefinedComparators = this.searchOptions.getUserComparators();
            for (int i = this.userDefinedComparators.length - 1; i >= 0; --i) {
                this.userDefinedComparators[i].initAll(this.sub.molecule, this.molecule, this);
            }
            this.searchOptions.clearChangesInUserComparators();
        } else {
            this.userDefinedComparators = null;
        }
    }

    private final void excludeAtoms(int[] exclude) {
        int i;
        int ec;
        int n = ec = exclude == null || exclude.length == 0 ? 0 : exclude.length;
        if (this.excludedAtomsLength > 0) {
            this.excludedAtomsLength = 0;
        }
        if (ec == 0) {
            return;
        }
        this.excludedAtoms = ArrayTools.initArray(this.excludedAtoms, ec, -1);
        this.excludedAtomsLength = 0;
        int ac = this.molecule.getAtomCount();
        for (i = 0; i < ec; ++i) {
            int e = exclude[i];
            if (e <= -1 || e >= ac) continue;
            this.excludedAtoms[this.excludedAtomsLength] = e;
            ++this.excludedAtomsLength;
        }
        Arrays.sort(this.excludedAtoms, 0, this.excludedAtomsLength);
        for (i = 0; i < this.excludedAtomsLength - 1; ++i) {
            if (this.excludedAtoms[i] != this.excludedAtoms[i + 1]) continue;
            System.arraycopy(this.excludedAtoms, i + 1, this.excludedAtoms, i, this.excludedAtomsLength - i - 1);
            --this.excludedAtomsLength;
            --i;
        }
    }

    private final void addExcluded(int ex) {
        int foundIndex = ArrayTools.binarySearch(this.excludedAtoms, ex, 0, this.excludedAtomsLength - 1);
        if (foundIndex >= 0) {
            return;
        }
        this.excludedAtoms = ArrayTools.extendArray(this.excludedAtoms, this.excludedAtomsLength + 1);
        int insertionPoint = -foundIndex - 1;
        if (insertionPoint < this.excludedAtomsLength) {
            System.arraycopy(this.excludedAtoms, insertionPoint, this.excludedAtoms, insertionPoint + 1, this.excludedAtomsLength - insertionPoint);
        }
        this.excludedAtoms[insertionPoint] = ex;
        this.excludedAtomsLength = this.excludedAtomsLength == -1 ? 1 : ++this.excludedAtomsLength;
    }

    public final int excludedQueryAtomCount() {
        return this.sub != null && this.sub.excludedAtomsLength > 0 ? this.sub.excludedAtomsLength : 0;
    }

    public final int excludedTargetAtomCount() {
        return this.excludedAtomsLength > 0 ? this.excludedAtomsLength : 0;
    }

    public void unInitialize() {
        this.initialized = false;
        this.queryPropertiesInitialized = false;
        this.chiralityInitialized = false;
        this.isComponentInitialized = false;
        this.clearHits();
        if (this.targetInit != null) {
            this.targetInit.clear();
            if (!this._IAmTheQuery && this.sub != null) {
                this.targetInit.fill(this.sub.targetInit);
            }
            this.smartsAtomTrees = null;
            if (this.recursiveSmartsResults != null) {
                this.recursiveSmartsResults.clear();
            }
        }
        this.stat_atomTypeCountsLength = 0;
        this.aromaticLength = -1;
        this.bondTopology = null;
        this.hasLP = false;
        if (this.lpIndices != null) {
            this.lpIndices.removeAllElements();
        }
        this.gParity = null;
        this.isSymmetrical = null;
    }

    public final boolean isExcluded(int index) {
        if (this.excludedAtomsLength <= 0) {
            return false;
        }
        index = this.queryRearrangedToOrig != null ? this.queryRearrangedToOrig[index] : index;
        int foundIndex = ArrayTools.binarySearch(this.excludedAtoms, index, 0, this.excludedAtomsLength - 1);
        return foundIndex >= 0;
    }

    private final int collectNeighbors(int atomidx, int bondIdx, int[] neib) {
        int c = 0;
        for (int i = 0; i < this.abonds[atomidx]; ++i) {
            int otherBondIdx = this.bondidx[atomidx] + i;
            int btype = this.btyp[otherBondIdx];
            if (otherBondIdx == bondIdx || btype != 1 && btype != 4) continue;
            int otherAtomIdx = this.bto[otherBondIdx];
            neib[c++] = otherAtomIdx;
            if (c != 10) continue;
            return c;
        }
        return c;
    }

    @Override
    public void stop() {
        this.stopping = true;
    }

    protected void storeCTIForBond(int bondIdx, MolBond bond, int atom1_idx, int atom2_idx) {
        if (atom1_idx > atom2_idx) {
            int t = atom1_idx;
            atom1_idx = atom2_idx;
            atom2_idx = t;
        }
        MolAtom atom1 = this.atoms[this.atomIdxInAtomsArray[atom1_idx]];
        int singleNeibCount1 = this.collectNeighbors(atom1_idx, bondIdx, this.neib1);
        MolAtom atom2 = this.atoms[this.atomIdxInAtomsArray[atom2_idx]];
        int singleNeibCount2 = this.collectNeighbors(atom2_idx, bondIdx, this.neib2);
        boolean isWigglyDoubleBond = this.isWigglyDoubleBond(atom1, atom2);
        int totalCovalentBondCount1 = this.getCovalentBondCount(atom1);
        int totalCovalentBond2 = this.getCovalentBondCount(atom2);
        if (singleNeibCount1 > 0 && totalCovalentBondCount1 <= 3 && singleNeibCount2 > 0 && totalCovalentBond2 <= 3) {
            for (int j = 0; j < singleNeibCount1; ++j) {
                for (int k = 0; k < singleNeibCount2; ++k) {
                    int type;
                    boolean secondNeibIsPlainHWithAlternative;
                    boolean firstNeibIsPlainHWithAlternative = this.matom[this.neib1[j]] == 1 && singleNeibCount1 > 1 && this.isPlainH(this.neib1[j]);
                    boolean bl = secondNeibIsPlainHWithAlternative = this.matom[this.neib2[k]] == 1 && singleNeibCount2 > 1 && this.isPlainH(this.neib2[k]);
                    if (this._IAmTheQuery && (firstNeibIsPlainHWithAlternative || secondNeibIsPlainHWithAlternative)) continue;
                    if (isWigglyDoubleBond) {
                        type = 448;
                    } else {
                        int n1 = this.atomIdxInAtomsArray[this.neib1[j]];
                        int n2 = this.atomIdxInAtomsArray[this.neib2[k]];
                        if (n1 < 0 || n2 < 0) {
                            if (this._IAmTheQuery) continue;
                            type = -1;
                        } else {
                            type = this.getStereo2(this.molecule, bond, this.atoms[n1], this.atoms[n2]);
                        }
                    }
                    if (this.searchOptions.verbose) {
                        this.printDBS(this.neib1[j], atom1_idx, atom2_idx, this.neib2[k], type);
                    }
                    if (this._IAmTheQuery && !this.optIsPerfectSearch && (type & 0x1C0) == 448) continue;
                    this.storeCTInfo(bondIdx, this.neib1[j], this.neib2[k], type);
                }
            }
        }
    }

    private int getCovalentBondCount(MolAtom atom1) {
        int c = 0;
        for (int i = atom1.getBondCount() - 1; i >= 0; --i) {
            MolBond b = atom1.getBond(i);
            int bt = b.getType();
            if (bt == 9) continue;
            ++c;
        }
        return c;
    }

    private int getStereo2(Molecule molecule2, MolBond bond, MolAtom atom1, MolAtom atom2) {
        boolean ssho = this.searchOptions.getStereoModel() == 2;
        return molecule2.getStereo2(bond, atom1, atom2, ssho) & 0x1C0;
    }

    protected boolean isWigglyDoubleBond(MolAtom atom1, MolAtom atom2) {
        int stereo1;
        MolBond neighbourBond;
        int i;
        int bc1 = atom1.getBondCount();
        int bc2 = atom2.getBondCount();
        if (bc1 > 3 || bc2 > 3) {
            return true;
        }
        for (i = 0; i < bc1; ++i) {
            neighbourBond = atom1.getBond(i);
            stereo1 = neighbourBond.getStereo1(atom1);
            if (stereo1 != 48 || atom1 != neighbourBond.getAtom1()) continue;
            return true;
        }
        for (i = 0; i < bc2; ++i) {
            neighbourBond = atom2.getBond(i);
            stereo1 = neighbourBond.getStereo1(atom2);
            if (stereo1 != 48 || atom2 != neighbourBond.getAtom1()) continue;
            return true;
        }
        return false;
    }

    protected void storeCTInfo(int bondIdx, int neibOne, int neibTwo, int type) {
        this.ctiRecords = ArrayTools.extendArray(this.ctiRecords, (this.ctiRecordsLength + 1) * 4);
        this.ctiRecords[this.ctiRecordsLength * 4 + 0] = bondIdx;
        this.ctiRecords[this.ctiRecordsLength * 4 + 1] = neibOne;
        this.ctiRecords[this.ctiRecordsLength * 4 + 2] = neibTwo;
        this.ctiRecords[this.ctiRecordsLength * 4 + 3] = type;
        ++this.ctiRecordsLength;
        this.hasDoubleBondStereo = true;
    }

    protected boolean isCTCheckNeeded(MolBond bond, boolean daylightFormat) {
        if (!this._IAmTheQuery && !this.optIsExactStereoMatching && this.sub != null && !this.sub.hasDoubleBondStereo || !this.isDoubleBondStereoSearch || bond.getType() != 2) {
            return false;
        }
        if (this.optIsExactStereoMatching || !this._IAmTheQuery || this.searchOptions.getDoubleBondStereoMatchingMode() == 0) {
            return true;
        }
        if (this.searchOptions.getDoubleBondStereoMatchingMode() == 1) {
            return daylightFormat || (bond.getFlags() & 0x200) == 512;
        }
        return false;
    }

    protected void printDBS(int a1, int a2, int a3, int a4, int bondType) {
        System.err.print(this._IAmTheQuery ? "Query : " : "Target: ");
        System.err.print("[" + a1 + "]-[" + a2 + "]=[" + a3 + "]-[" + a4 + "] : ");
        if (bondType == -1) {
            System.err.print("IMP");
        } else {
            System.err.print((bondType & 0x80) > 0 ? "C" : " ");
            System.err.print((bondType & 0x40) > 0 ? "T" : " ");
            System.err.print((bondType & 0x100) > 0 ? "U" : " ");
        }
        System.err.println("");
    }

    final int[] restoreSingleHitIndexes(int[] hit) {
        int r = this.sub.getTotalOrigAtoms() + this.sub.multiCenterCount + (this.sub.hasLP ? this.sub.lpIndices.size() : 0) + (this.sub.excludedAtomsLength > 0 ? this.sub.excludedAtomsLength : 0);
        int[] result = new int[r];
        int j = 0;
        int k = 0;
        int totalOrigAtoms = this.getTotalOrigAtoms();
        for (int i = 0; i < this.sub.atomsLength; ++i) {
            int atno = this.sub.atoms[i].getAtno();
            if (this.sub.isExcluded(i) || this.sub.isNonInitH(atno, i)) {
                result[k] = -2147483641;
                ++k;
                continue;
            }
            if (atno == 137) {
                result[k] = -2147483646;
                ++k;
                continue;
            }
            if (atno != 130) {
                if (hit[j] >= totalOrigAtoms) {
                    if (this.isUnMappableHit(hit[j])) {
                        result[k] = -2147483645;
                    } else {
                        result[k] = -this.atomIdxInAtomsArray[this.bto[this.bondidx[hit[j]]]];
                        if (result[k] == 0) {
                            result[k] = Integer.MIN_VALUE;
                        }
                    }
                } else {
                    result[k] = this.atomIdxInAtomsArray[hit[j]];
                }
                ++j;
            }
            ++k;
        }
        if (this.sub.hasLP) {
            for (int l = 0; l < this.sub.lpIndices.size(); ++l) {
                int qNIndex;
                int lpIndex = this.sub.lpIndices.get(l);
                MolAtom lpAtom = this.sub.atoms[lpIndex];
                int lpHitValue = -2147483644;
                if (lpAtom.getBondCount() > 0 && (lpHitValue = -result[qNIndex = this.sub.molecule.indexOf(lpAtom.getLigand(0))]) == 0) {
                    lpHitValue = Integer.MIN_VALUE;
                }
                result[lpIndex] = lpHitValue;
            }
        }
        return result;
    }

    protected boolean isUnMappableHit(int i) {
        return false;
    }

    protected SearchHit restoreHitIndexes(SearchHit searchHit) {
        int[] hit = searchHit.getSingleHit();
        searchHit.setSingleHit(this.restoreSingleHitIndexes(hit));
        return searchHit;
    }

    private int getTotalOrigAtoms() {
        int r = this.atomsLength;
        if (this.excludedAtomsLength > 0) {
            r -= this.excludedAtomsLength;
        }
        if (this.hasLP) {
            r -= this.lpIndices.size();
        }
        return r -= this.multiCenterCount;
    }

    final int[] restoreRearrangedSingleHitIndices(int[] hit) {
        if (!this.isHitArrayNeeded || this.sub.queryRearrangedToOrig == null) {
            return hit;
        }
        int[] origHit = new int[hit.length];
        for (int i = 0; i < hit.length; ++i) {
            origHit[this.sub.queryRearrangedToOrig[i]] = hit[i];
        }
        return origHit;
    }

    protected SearchHit restoreRearrangedHitIndices(SearchHit searchHit) {
        int[] singleHit = searchHit.getSingleHit();
        int[] origHit = this.restoreRearrangedSingleHitIndices(singleHit);
        searchHit.setSingleHit(origHit);
        return searchHit;
    }

    int[] restorePolymerTransformation(int[] actHit) {
        if (this.polymerSU != null) {
            actHit = this.polymerSU.restoreHitIndexes(actHit);
        }
        return actHit;
    }

    protected void initSearch() throws SearchException {
        if (this.searchOptions.isDirty()) {
            this.unInitialize();
        }
        this.clearHits();
        this.selectStereoModel();
        this.initSearchOptionVariables();
        this.sub.setSearchOptions(this.searchOptions);
        this.searchOptions.verbose |= logger.isLoggable(Level.FINEST);
        this.sub.searchOptions.verbose |= logger.isLoggable(Level.FINEST);
        this.sub.initSearchOptionVariables();
        this.sub.getSearchOptions().setTargetAbsoluteStereo(this.searchOptions.isQueryAbsoluteStereo());
        if (!this.sub.initialized) {
            this.handlePolymers(true);
            this.sub.initAtoms();
            this.targetInit.fill(this.sub.targetInit);
        }
        if (!this.initialized) {
            this.handlePolymers(false);
            this.initAtoms();
        }
        this.createAndInitMatchers();
        this.selectInitMode();
        if (!this.areStandardMolComparatorsAdded) {
            this.createMolComparators();
            this.areStandardMolComparatorsAdded = true;
        }
        if (this.searchOptions.hasChangesInUserComparators()) {
            this.initUserComparators();
        }
        if (!this.sub.initialized) {
            this.sub.initMolecule();
            this.targetInit.fill(this.sub.targetInit);
            this.setQueryForComparators();
        }
        if (!this.sub.queryPropertiesInitialized) {
            this.sub.initQueryProperties();
            this.sub.initAromatic();
            this.targetInit.fill(this.sub.targetInit);
        }
        if (!this.initialized) {
            this.initMolecule();
            this.setTargetForComparators();
        }
        if (!this.queryPropertiesInitialized) {
            this.initQueryProperties();
            this.initAromatic();
        }
        if (this.isTetrahedralStereoSearch && !this.sub.chiralityInitialized) {
            this.sub.initChirality();
        }
        if (this.isTetrahedralStereoSearch && !this.chiralityInitialized && (this.sub.hasAtomStereo || this.targetInit.isChiralityNeeded || this.optIsExactStereoMatching)) {
            this.initChirality();
        }
        if (this.optCheckSpHyb) {
            this.initHybridization();
        }
        this.isFastSearch = true;
        this.searchOptions.setDirty(false);
        this.createHomologyMatchers();
    }

    private void createAndInitMatchers() {
        if (this.moleculeMatchers == null) {
            this.createMoleculeMatchers();
        }
        if (!this.sub.initialized) {
            for (MoleculeMatcher matcher : this.moleculeMatchers) {
                matcher.setQuery(this.sub.molecule);
            }
        }
        if (!this.initialized) {
            for (MoleculeMatcher matcher : this.moleculeMatchers) {
                matcher.setTarget(this.molecule);
            }
        }
    }

    protected void clearHits() {
        this.hits.clear();
    }

    private void initSearchOptionVariables() {
        this.optIsPerfectSearch = this.searchOptions.isPerfectSearchType();
        this.optIsExactQueryAtomMatching = this.searchOptions.isExactQueryAtomMatching();
        this.optIsExactBondMatching = this.searchOptions.isExactBondMatching();
        this.optHasUserComparators = this.searchOptions.hasUserComparators();
        this.optRadicalMatching = this.searchOptions.getRadicalMatching();
        this.optIsotopeMatching = this.searchOptions.getIsotopeMatching();
        this.optChargeMatching = this.searchOptions.getChargeMatching();
        this.optIsExactStereoMatching = this.searchOptions.getStereoSearchType() == 2;
        this.optCheckSpHyb = this.searchOptions.getCheckSpHyb();
        this.isTetrahedralStereoSearch = this.searchOptions.getStereoSearchType() != 1 && !this.searchOptions.isIgnoreTetrahedralStereo();
        this.isDoubleBondStereoSearch = this.searchOptions.getStereoSearchType() != 1 && !this.searchOptions.isIgnoreDoubleBondStereo();
    }

    protected void selectStereoModel() {
        SearchUtil.selectStereoModel(this.getSearchOptions(), this.getSearchOptions(), null, false);
    }

    private void handlePolymers(boolean transformQuery) throws SearchException {
        if (this.searchOptions.isPolymerMatching() && !this.searchOptions.isMarkushEnabled()) {
            this.transformPolymers(transformQuery);
        } else {
            this.polymerSU = null;
        }
    }

    protected void transformPolymers(boolean transformQuery) throws SearchException {
        if (this.polymerSU == null) {
            this.polymerSU = new PolymerMatcher();
        }
        this.polymerSU.setSearchOptions(this.searchOptions);
        if (transformQuery) {
            this.polymerSU.setQuery(this.sub.molecule);
            this.polymerSU.transform(transformQuery);
        } else {
            this.polymerSU.setTarget(this.molecule);
            this.polymerSU.transform(transformQuery);
        }
    }

    protected void createHomologyMatchers() {
    }

    private void initHybridization() {
        this.molecule.calcHybridization();
        Object nonE = this.sub.molecule.getPropertyObject("nonEnumeratedMol");
        if (nonE != null) {
            Molecule nonEnum = (Molecule)nonE;
            nonEnum.calcHybridization();
        } else {
            this.sub.molecule.calcHybridization();
        }
    }

    private boolean checkSpHyb(int queryAtom, int targetAtom) {
        if (this.atomIdxInAtomsArray[targetAtom] < 0 || this.sub.atomIdxInAtomsArray[queryAtom] < 0) {
            return true;
        }
        int tHyb = this.molecule.getAtom(this.atomIdxInAtomsArray[targetAtom]).getHybridizationState();
        int qHyb = 0;
        Object nonE = this.sub.molecule.getPropertyObject("nonEnumeratedMol");
        if (nonE != null) {
            Molecule nonEnum = (Molecule)nonE;
            int qInd = 0;
            qInd = this.sub.queryRearrangedToOrig == null ? this.sub.atomIdxInAtomsArray[queryAtom] : this.sub.queryRearrangedToOrig[this.sub.atomIdxInAtomsArray[queryAtom]];
            qHyb = nonEnum.getAtom(qInd).getHybridizationState();
        } else {
            qHyb = this.sub.molecule.getAtom(this.sub.atomIdxInAtomsArray[queryAtom]).getHybridizationState();
        }
        return tHyb == qHyb || tHyb == 0 || qHyb == 0;
    }

    private final void setTargetForComparators() {
        MolComparator mc;
        int i;
        int mcNo = this.maybeUsedMolComparators.size();
        for (i = 0; i < mcNo; ++i) {
            mc = this.maybeUsedMolComparators.get(i);
            mc.setTarget(this.molecule);
            if (mc.isUsefulForTarget() != 0) continue;
            this.addToUsedMolComparators(mc);
        }
        if (this.usedMolComparators != null) {
            mcNo = this.usedMolComparators.size();
            for (i = 0; i < mcNo; ++i) {
                mc = this.usedMolComparators.get(i);
                mc.setTarget(this.molecule);
            }
        }
    }

    private final void setQueryForComparators() {
        this.usedMolComparators = null;
        this.maybeUsedMolComparators.clear();
        int mcNo = this.molcomparators.size();
        for (int i = 0; i < mcNo; ++i) {
            MolComparator mc = this.molcomparators.get(i);
            mc.setQuery(this.sub.molecule);
            int usefulForQuery = mc.isUsefulForQuery();
            if (usefulForQuery == 0) {
                this.addToUsedMolComparators(mc);
                continue;
            }
            if (usefulForQuery != 1) continue;
            this.maybeUsedMolComparators.add(mc);
        }
    }

    private final void addToUsedMolComparators(MolComparator mc) {
        if (this.usedMolComparators == null) {
            this.usedMolComparators = new ArrayList();
        }
        String currClassName = mc.getClass().getName();
        for (int i = 0; i < this.usedMolComparators.size(); ++i) {
            if (!currClassName.equals(this.usedMolComparators.get(i).getClass().getName())) continue;
            return;
        }
        this.usedMolComparators.add(mc);
    }

    protected void createMolComparators() {
        if (this.searchOptions.getAttachedDataMatch() != 0) {
            this.addComparator(new DataSgroupComparator(this.searchOptions.getAttachedDataMatch(), this.searchOptions.getAttachedDataPrefixes()));
        }
        if (this.searchOptions.getSearchType() == 5) {
            this.addComparator(new DataSgroupComparator(2, DUPLICATE_CHECK_MARKER));
        }
        if ((this.searchOptions.isMixSgroupMatching() || this.searchOptions.isPolymerMatching()) && !this.searchOptions.isMarkushEnabled()) {
            BracketComparator bComp = new BracketComparator();
            this.addComparator(bComp);
            if (this.polymerSU != null) {
                this.polymerSU.setComparator(bComp);
            }
        }
        this.addComparator(new ReactingCenterComparator());
    }

    protected void createMoleculeMatchers() {
        ArrayList<StereoMatcher> matchers = new ArrayList<StereoMatcher>();
        if (!(this.searchOptions.isIgnoreAlleneStereo() && this.searchOptions.isIgnoreAxialStereo() && this.searchOptions.isIgnoreSynAntiStereo() || this.searchOptions.getStereoSearchType() == 1)) {
            matchers.add(new StereoMatcher());
        }
        for (MoleculeMatcher moleculeMatcher : this.moleculeMatchers = matchers.toArray(new MoleculeMatcher[0])) {
            moleculeMatcher.setSearcher(this);
        }
    }

    protected void selectInitMode() {
        int qm = 0;
        int impHMatch = this.searchOptions.getImplicitHMatching();
        if (impHMatch == 0 || impHMatch == 1) {
            int j;
            int tm = 0;
            if (this.hasSpecialHydrogen(true)) {
                tm = Math.max(tm, 2);
                qm = this.searchOptions.isFullFragment() && (this.optIsPerfectSearch || this.optRadicalMatching == 1 || this.optIsotopeMatching == 1 || this.optChargeMatching == 1) ? Math.max(qm, 2) : Math.max(qm, 1);
            }
            if (qm == 0) {
                for (j = 0; j < this.preMatchLength; ++j) {
                    if (!StructureSearch.isHydrogen(this.preMatchQueryAtoms[j], this.sub.origQuery == null ? this.sub.molecule : this.sub.origQuery)) continue;
                    qm = Math.max(qm, 1);
                }
            }
            if (tm != 2 && this.hasSpecialHydrogen(false)) {
                tm = Math.max(tm, 2);
                qm = this.searchOptions.isFullFragment() ? Math.max(qm, 2) : Math.max(qm, 1);
            }
            if (this.targetInit.isAllHydrogensNeeded) {
                tm = Math.max(tm, 2);
                if (qm == 0) {
                    qm = Math.max(qm, 1);
                }
            }
            if (tm == 0) {
                for (j = 0; j < this.preMatchLength; ++j) {
                    if (!StructureSearch.isHydrogen(this.preMatchTargetAtoms[j], this.molecule)) continue;
                    tm = Math.max(tm, 1);
                }
            }
            if (tm < qm) {
                tm = qm;
            }
            this.setInitMode(tm);
        } else if (impHMatch == 2) {
            this.setInitMode(1);
            qm = 1;
        } else if (impHMatch == 3) {
            this.setInitMode(0);
            qm = 0;
        } else {
            throw new AssertionError();
        }
        InitializationIndicator save_ti = this.sub.targetInit;
        this.sub.targetInit = null;
        this.sub.setInitMode(qm);
        this.sub.targetInit = save_ti;
    }

    private boolean hasSpecialHydrogen(boolean isQuery) {
        StructureSearch searcher = isQuery ? this.sub : this;
        for (int i = 0; i < searcher.atomsLength; ++i) {
            int an = searcher.atoms[i].getAtno();
            if (an == 1 && (this.isHitArrayNeeded && isQuery || this.isSpecialH(i, isQuery))) {
                return true;
            }
            if (!searcher.canContainH(an, i) || !isQuery) continue;
            return true;
        }
        return false;
    }

    private boolean canContainH(int atomType, int index) {
        int i;
        if (atomType == 134 || atomType == 138 || atomType == 128 || atomType == 129 || atomType == 133) {
            return true;
        }
        return atomType == 136 && ((i = this.getSpecialPseudoIndex(index)) == 0 || i == 21 || i == 19 || i == 23 || i == 1);
    }

    private boolean isSpecialH(int atomInd, boolean isQuery) {
        Molecule molecule2;
        boolean isCTspecificH = false;
        MolAtom atom = isQuery ? this.sub.atoms[atomInd] : this.atoms[atomInd];
        Molecule molecule = molecule2 = isQuery ? this.sub.molecule : this.molecule;
        if (atom.getBondCount() != 1 || atom.getMassno() != 0 || atom.getCharge() != 0 || atom.getRadical() != 0 || atom.hasQueryBonds() || atom.getBondCount() == 1 && atom.getLigand(0).getAtno() == 1) {
            return true;
        }
        if (atom.getBondCount() > 0) {
            MolAtom a = atom.getLigand(0);
            int ne = a.getBondCount();
            if (ne == 2) {
                MolBond b;
                MolBond molBond = b = a.getLigand(0) == atom ? a.getBond(1) : a.getBond(0);
                if (b.getType() == 2) {
                    int s;
                    MolAtom n1 = b.getCTAtom1();
                    MolAtom n4 = b.getCTAtom4();
                    if (n1 != null && n4 != null && ((s = this.getStereo2(molecule2, b, n1, n4)) == 128 || s == 64)) {
                        isCTspecificH = true;
                    }
                }
            }
            for (int i = 0; i < this.moleculeMatchers.length && !isCTspecificH; isCTspecificH |= isQuery ? this.moleculeMatchers[i].isSpecialQueryH(atomInd) : this.moleculeMatchers[i].isSpecialTargetH(atomInd), ++i) {
            }
        }
        return isCTspecificH;
    }

    protected final void setInitMode(int mode) {
        if (this.initMode != mode) {
            this.initMode = mode;
            this.unInitialize();
        }
    }

    protected void initMolecule() throws SearchException {
        int j;
        boolean hadDBSInSmarts;
        int atomicNumber;
        this.hasLP = false;
        int atomCount = this.atomsLength;
        int[] implicitHCountPerAtom = new int[atomCount];
        int explicitHCount = 0;
        int implicitHCount = 0;
        int excludedAtomCount = 0;
        int lonePairCount = 0;
        this.multiCenterCount = 0;
        assert (this.searchOptions.getImplicitHMatching() != 3 || this.initMode == 0 || this.isMarkushSearch) : "In case of ignored implicit H matching hydrogen initialization mode must be INITMODE_NONIGNORED_SPECIAL_HYDROGENS for non-markush searches!";
        this.idxAtomInMatomArray = ArrayTools.initArray(this.idxAtomInMatomArray, atomCount);
        this.idxAtomInMatomArrayLength = atomCount;
        this.specialHToHandle = new BitSet(atomCount);
        block7: for (int i = 0; i < atomCount; ++i) {
            if (this.isExcluded(i)) {
                ++excludedAtomCount;
                continue;
            }
            int atno = this.atoms[i].getAtno();
            switch (atno) {
                case 1: {
                    if (this.initMode == 0 && this.searchOptions.getImplicitHMatching() == 3 && this.isSpecialHToHandle(this.atoms[i], this.searchOptions)) {
                        this.specialHToHandle.set(i, true);
                    }
                    ++explicitHCount;
                    continue block7;
                }
                case 130: {
                    this.hasLP = true;
                    if (this.lpIndices == null) {
                        this.lpIndices = new IntVector();
                    }
                    this.lpIndices.addElement(i);
                    ++lonePairCount;
                    continue block7;
                }
                case 137: {
                    ++this.multiCenterCount;
                    continue block7;
                }
                default: {
                    implicitHCountPerAtom[i] = this.atoms[i].getImplicitHcount();
                    if (implicitHCountPerAtom[i] < 0) continue block7;
                    implicitHCount += implicitHCountPerAtom[i];
                }
            }
        }
        this.hasExplicitHydrogen = explicitHCount != 0;
        int atomsInSearch = atomCount - excludedAtomCount - lonePairCount - this.multiCenterCount;
        int specialHCount = this.specialHToHandle.cardinality();
        boolean bl = this.hasSpecialHToHandle = specialHCount > 0;
        if (this.initMode == 0) {
            atomsInSearch -= explicitHCount;
            atomsInSearch += specialHCount;
        } else if (this.initMode == 2) {
            atomsInSearch += implicitHCount;
        }
        this.matom = ArrayTools.initArray(this.matom, atomsInSearch);
        this.abonds = ArrayTools.initArray(this.abonds, atomsInSearch);
        this.isotope = ArrayTools.initArray(this.isotope, atomsInSearch, 0);
        this.atomIdxInAtomsArray = ArrayTools.initArray(this.atomIdxInAtomsArray, atomsInSearch);
        this.matomLength = atomsInSearch;
        this.isotopeLength = atomsInSearch;
        this.atomIdxInAtomsArrayLength = atomsInSearch;
        int initializedAtomCount = 0;
        int totalBondCount = 0;
        int listAtomMemberCount = 0;
        boolean hasNonInitializedAtoms = this.initMode == 0 && explicitHCount - specialHCount > 0 || lonePairCount > 0 || this.excludedAtomsLength > 0 || this.multiCenterCount > 0;
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            int bondCountOfAtom;
            this.idxAtomInMatomArray[atomIndex] = -1;
            MolAtom ma = this.atoms[atomIndex];
            atomicNumber = ma.getAtno();
            if (this.isNonInitH(atomicNumber, atomIndex) || this.isExcludedOrLP(atomIndex, atomicNumber) || atomicNumber == 137) continue;
            int numLigands = bondCountOfAtom = ma.getBondCount();
            if (hasNonInitializedAtoms) {
                for (int j2 = 0; j2 < numLigands; ++j2) {
                    int atno;
                    MolAtom neighborAtom = ma.getLigand(j2);
                    int oAtomIndex = this.molecule.indexOf(neighborAtom);
                    if (this.isExcludedOrLP(oAtomIndex, atno = neighborAtom.getAtno()) || this.isNonInitH(atno, oAtomIndex)) {
                        --bondCountOfAtom;
                        continue;
                    }
                    if (atno != 137) continue;
                    --bondCountOfAtom;
                    bondCountOfAtom += this.getMultiCenterInternalAtomCount(neighborAtom);
                }
                if (this.multiCenterCount >= 0) {
                    for (int l = this.molecule.getSgroupCount() - 1; l >= 0; --l) {
                        Sgroup sg = this.molecule.getSgroup(l);
                        if (!(sg instanceof MulticenterSgroup) || sg.indexOf(ma) == -1) continue;
                        MulticenterSgroup msg = (MulticenterSgroup)sg;
                        MolAtom c = msg.getCentralAtom();
                        for (int m = c.getBondCount() - 1; m >= 0; --m) {
                            MolAtom coatom = c.getLigand(m);
                            int coAtomIndex = this.molecule.indexOf(coatom);
                            int coatno = coatom.getAtno();
                            if (coatno == 137) {
                                bondCountOfAtom += this.getMultiCenterInternalAtomCount(coatom);
                                continue;
                            }
                            if (!this.isInternalAtom(coAtomIndex, coatno)) continue;
                            ++bondCountOfAtom;
                        }
                    }
                }
            }
            if (this.initMode == 2) {
                bondCountOfAtom += implicitHCountPerAtom[atomIndex];
            }
            this.abonds[initializedAtomCount] = bondCountOfAtom;
            if (this.maxbonds < this.abonds[initializedAtomCount]) {
                this.maxbonds = this.abonds[initializedAtomCount];
            }
            totalBondCount += this.abonds[initializedAtomCount];
            if (atomicNumber == 128 || atomicNumber == 129) {
                listAtomMemberCount += this.atoms[atomIndex].getList().length;
            }
            this.matom[initializedAtomCount] = atomicNumber;
            this.isotope[initializedAtomCount] = ma.getMassno();
            this.atomIdxInAtomsArray[initializedAtomCount] = atomIndex;
            this.idxAtomInMatomArray[atomIndex] = initializedAtomCount++;
        }
        if (this.initMode == 2) {
            totalBondCount += implicitHCount;
        }
        this.bto = ArrayTools.initArray(this.bto, totalBondCount);
        this.bFrom = ArrayTools.initArray(this.bFrom, totalBondCount);
        this.btyp = ArrayTools.initArray(this.btyp, totalBondCount);
        this.btoLength = totalBondCount;
        this.btypLength = totalBondCount;
        this.lst = ArrayTools.initArray(this.lst, listAtomMemberCount);
        this.bondidx = ArrayTools.initArray(this.bondidx, atomsInSearch);
        this.lstidx = ArrayTools.initArray(this.lstidx, atomsInSearch, 0);
        this.lstcnt = ArrayTools.initArray(this.lstcnt, atomsInSearch, 0);
        this.acharge = ArrayTools.initArray(this.acharge, atomsInSearch, 0);
        this.radical = ArrayTools.initArray(this.radical, atomsInSearch, 0);
        this.initBacktrackArrays(this.maxbonds + 1);
        this.hasDoubleBondStereo = false;
        this.ctiRecordsLength = 0;
        boolean isDaylightFormat = MolHandler.isDaylightFormat(this.molecule.getInputFormat());
        boolean bl2 = hadDBSInSmarts = this.smartsBondTrees != null && this.hasDoubleBondStereo;
        if (this.initMode == 0) {
            this.hcount = ArrayTools.initArray(this.hcount, atomsInSearch, 0);
            this.hidx = ArrayTools.initArray(this.hidx, atomsInSearch, 0);
            this.hcountLength = atomsInSearch;
            this.hydrogens = ArrayTools.initArray(this.hydrogens, (explicitHCount + implicitHCount) * 3, 0);
            this.hydrogensLength = (explicitHCount + implicitHCount) * 3;
        } else {
            if (this.hcountLength != -1) {
                this.hcountLength = 0;
            }
            if (this.hydrogensLength != -1) {
                this.hydrogensLength = 0;
            }
        }
        int k2 = 0;
        int bondIndexStartingPosition = 0;
        listAtomMemberCount = 0;
        int h = 0;
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            MolAtom ma = this.atoms[atomIndex];
            atomicNumber = ma.getAtno();
            if (this.isExcludedOrLP(atomIndex, atomicNumber) || atomicNumber == 137 || this.isNonInitH(atomicNumber, atomIndex)) continue;
            if (atomicNumber == 128 || atomicNumber == 129) {
                int[] list = ma.getList();
                this.lstcnt[k2] = list.length;
                this.lstidx[k2] = listAtomMemberCount;
                System.arraycopy(list, 0, this.lst, listAtomMemberCount, this.lstcnt[k2]);
                listAtomMemberCount += this.lstcnt[k2];
            } else {
                this.lstcnt[k2] = 0;
                this.lstidx[k2] = -1;
            }
            this.acharge[k2] = ma.getCharge();
            this.radical[k2] = ma.getRadical();
            this.bondidx[k2] = bondIndexStartingPosition;
            if (this.initMode == 0) {
                this.hidx[k2] = h;
            }
            int edgeCount = ma.getBondCount();
            implicitHCount = implicitHCountPerAtom[atomIndex];
            if (this.hcountLength > k2) {
                this.hcount[k2] = 0;
            }
            for (j = 0; j < edgeCount; ++j) {
                int oAtno;
                MolBond bond = ma.getBond(j);
                MolAtom neighborAtom = bond.getOtherAtom(ma);
                int neighborIndex = this.molecule.indexOf(neighborAtom);
                if (this.isExcludedOrLP(neighborIndex, oAtno = neighborAtom.getAtno())) continue;
                if (this.isNonInitH(oAtno, neighborIndex)) {
                    this.hydrogens[h] = neighborIndex;
                    int n = k2;
                    this.hcount[n] = this.hcount[n] + 1;
                    ++h;
                    continue;
                }
                bondIndexStartingPosition += this.storeBond(bondIndexStartingPosition, atomIndex, neighborIndex, neighborAtom, oAtno, bond.getType(), bond.getFlags() & 0xC00, this.molecule.indexOf(bond));
            }
            if (this.multiCenterCount > 0) {
                for (int l = this.molecule.getSgroupCount() - 1; l >= 0; --l) {
                    Sgroup sg = this.molecule.getSgroup(l);
                    if (!(sg instanceof MulticenterSgroup) || sg.indexOf(ma) == -1) continue;
                    MulticenterSgroup msg = (MulticenterSgroup)sg;
                    MolAtom centralAtom = msg.getCentralAtom();
                    for (int m = centralAtom.getBondCount() - 1; m >= 0; --m) {
                        int oAtno;
                        MolBond bond = centralAtom.getBond(m);
                        MolAtom neighborAtom = bond.getOtherAtom(centralAtom);
                        int oIdx = this.molecule.indexOf(neighborAtom);
                        if (!this.isInternalAtom(oIdx, oAtno = neighborAtom.getAtno())) continue;
                        bondIndexStartingPosition += this.storeBond(bondIndexStartingPosition, atomIndex, oIdx, neighborAtom, oAtno, bond.getType(), bond.getFlags() & 0xC00, this.molecule.indexOf(bond));
                    }
                }
            }
            if (this.initMode == 2) {
                bondIndexStartingPosition += implicitHCount;
            } else if (this.initMode == 0) {
                j = 0;
                while (j < implicitHCount) {
                    this.hydrogens[h] = atomIndex == 0 ? Integer.MIN_VALUE : -atomIndex;
                    ++j;
                    ++h;
                }
                int n = k2;
                this.hcount[n] = this.hcount[n] + implicitHCount;
            }
            ++k2;
        }
        if (this.initMode == 2) {
            int new_h = atomCount - excludedAtomCount - lonePairCount - this.multiCenterCount;
            for (int i = 0; i < atomCount; ++i) {
                int intI = this.idxAtomInMatomArray[i];
                implicitHCount = implicitHCountPerAtom[i];
                j = 0;
                while (j < implicitHCount) {
                    this.abonds[new_h] = 1;
                    this.matom[new_h] = 1;
                    this.isotope[new_h] = 0;
                    this.acharge[new_h] = 0;
                    this.radical[new_h] = 0;
                    this.atomIdxInAtomsArray[new_h] = -1;
                    this.bondidx[new_h] = bondIndexStartingPosition;
                    this.lstcnt[new_h] = 0;
                    this.lstidx[new_h] = -1;
                    this.bto[bondIndexStartingPosition] = intI;
                    this.bFrom[bondIndexStartingPosition] = new_h;
                    this.btyp[bondIndexStartingPosition] = 1;
                    this.bto[this.bondidx[intI] + this.abonds[intI] - implicitHCount + j] = new_h++;
                    this.bFrom[this.bondidx[intI] + this.abonds[intI] - implicitHCount + j] = intI;
                    this.btyp[this.bondidx[intI] + this.abonds[intI] - implicitHCount + j] = 1;
                    ++j;
                    ++bondIndexStartingPosition;
                }
            }
        }
        this.initMultiValence();
        if (this._IAmTheQuery || this.optIsExactBondMatching) {
            try {
                SmartsBondMatcher.prepareSMARTSTrees(this);
            }
            catch (ParseException e) {
                throw new SearchException(e);
            }
            SmartsBondMatcher.analyseTrees(this, this.targetInit);
        }
        if (hadDBSInSmarts) {
            this.hasDoubleBondStereo = true;
        }
        this.initDBStereo(isDaylightFormat);
        this.logAtInit();
        this.initialized = true;
    }

    private boolean isSpecialHToHandle(MolAtom atom, SearchOptions options) {
        return atom.getBondCount() != 1 || atom.getMassno() != 0 && options.getIsotopeMatching() != 2 || atom.getCharge() != 0 && options.getChargeMatching() != 2 || atom.getRadical() != 0 && options.getRadicalMatching() != 2 || atom.getBondCount() == 1 && atom.getLigand(0).getAtno() == 1;
    }

    private void initSubDescriptors() {
        this.attBondsHash = new int[Math.max(this.matomLength, this.qryAtoms)];
        for (int mai = 0; mai < this.matomLength; ++mai) {
            int bondOffset;
            int bondNum = this.abonds[mai];
            for (int bi = bondOffset = this.bondidx[mai]; bi < bondOffset + bondNum; ++bi) {
                if (this.btyp[bi] <= 0 || this.btyp[bi] >= 5) continue;
                this.attBondsHash[mai] = SearchAtomDescriptor.addToNeighborDescriptor(this.attBondsHash[mai], this.btyp[bi]);
            }
        }
    }

    private void initDescriptors() {
        int mai;
        this.attBondsHash = new int[Math.max(this.matomLength, this.strAtoms)];
        for (mai = 0; mai < this.matomLength; ++mai) {
            int bondNum = this.abonds[mai];
            int bondOffset = this.bondidx[mai];
            if (this.searchOptions.getHomologyBroadTranslation() != HomologyTranslationOption.NONE || this.searchOptions.getHomologyNarrowTranslation() != HomologyTranslationOption.NONE) {
                this.attBondsHash[mai] = -1;
                continue;
            }
            for (int bi = bondOffset; bi < bondOffset + bondNum; ++bi) {
                this.attBondsHash[mai] = SearchAtomDescriptor.addToNeighborDescriptor(this.attBondsHash[mai], this.btyp[bi]);
                if (this.atomIdxInAtomsArray[this.bFrom[bi]] == -1 || this.btyp[bi] != 1 && this.btyp[bi] != 2 && this.btyp[bi] != 5 || !(this.molecule instanceof Supergraph) || this.atomIdxInAtomsArray[this.bto[bi]] == -1 || !((Supergraph)this.molecule).isAmbiguousAromaticBond(this.atomIdxInAtomsArray[this.bFrom[bi]], this.atomIdxInAtomsArray[this.bto[bi]])) continue;
                this.attBondsHash[mai] = SearchAtomDescriptor.addToNeighborDescriptor(this.attBondsHash[mai], 4);
            }
        }
        for (mai = this.matomLength; mai < this.attBondsHash.length; ++mai) {
            this.attBondsHash[mai] = -1;
        }
    }

    private void initMultiValence() {
        this.multiValentV = ArrayTools.initArray(this.multiValentV, this.matomLength);
        this.multiValentVCisT = ArrayTools.initArray(this.multiValentVCisT, this.matomLength);
        for (int i = 0; i < this.matomLength; ++i) {
            this.multiValentV[i] = this.isMultivalent(i, true);
            this.multiValentVCisT[i] = this.isMultivalent(i, false);
            this.hasMultiValent = this.hasMultiValent || this.multiValentV[i] || this.multiValentVCisT[i];
        }
    }

    protected void initBacktrackArrays(int len) {
        this.usd = ArrayTools.initArray(this.usd, len);
        this.ind = ArrayTools.initArray(this.ind, len);
        this.usdLength = len;
        this.indLength = len;
    }

    private void logAtInit() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Array lengths: \nbtypLength:" + this.btypLength);
        }
    }

    private int getMultiCenterInternalAtomCount(MolAtom oatom) {
        int mcInnerAtoms = 0;
        MulticenterSgroup msg = this.molecule.findContainingMulticenterSgroup(oatom);
        if (msg != null) {
            for (int l = msg.getAtomCount() - 1; l >= 0; --l) {
                MolAtom sgAtom = msg.getAtom(l);
                int sgAtomIdx = this.molecule.indexOf(sgAtom);
                if (!this.isInternalAtom(sgAtomIdx, sgAtom.getAtno())) continue;
                ++mcInnerAtoms;
            }
        }
        return mcInnerAtoms;
    }

    private boolean isExcludedOrLP(int o, int oAtno) {
        return this.isExcluded(o) || oAtno == 130;
    }

    private boolean isInternalAtom(int oAtomIndex, int atno) {
        return !this.isExcluded(oAtomIndex) && !this.isNonInitH(atno, oAtomIndex) && atno != 130;
    }

    private final boolean isNonInitH(int atno, int atomIndex) {
        return this.initMode == 0 && atno == 1 && !this.specialHToHandle.get(atomIndex);
    }

    private int storeBond(int bondIdx, int fromAtom, int toAtomIdx, MolAtom toAtom, int toAtno, int type, int topology, int origIdx) {
        int deposited = 0;
        if (toAtno == 137) {
            MulticenterSgroup msg = this.molecule.findContainingMulticenterSgroup(toAtom);
            if (msg != null) {
                for (int l = msg.getAtomCount() - 1; l >= 0; --l) {
                    int sgAtomNo;
                    MolAtom sgAtom = msg.getAtom(l);
                    int sgAtomIdx = this.molecule.indexOf(sgAtom);
                    if (!this.isInternalAtom(sgAtomIdx, sgAtomNo = sgAtom.getAtno())) continue;
                    if (toAtomIdx == sgAtomIdx) {
                        throw new IllegalArgumentException("Multicenter atom (atom " + toAtomIdx + ") contains itself in the  multicenter Sgroup.");
                    }
                    deposited += this.storeBond(bondIdx + deposited, fromAtom, sgAtomIdx, sgAtom, sgAtomNo, type, topology, origIdx);
                }
            }
        } else {
            this.bto[bondIdx] = this.idxAtomInMatomArray[toAtomIdx];
            this.bFrom[bondIdx] = this.idxAtomInMatomArray[fromAtom];
            this.btyp[bondIdx] = type;
            if (topology != 0) {
                this.targetInit.isRingMembershipNeeded = true;
                this.bondTopology = ArrayTools.initArray(this.bondTopology, this.btypLength, 0);
                this.bondTopology[bondIdx] = topology;
            }
            ++deposited;
        }
        return deposited;
    }

    protected void initDBStereo(boolean isDaylightFormat) {
        int[] grinv = null;
        for (int bondIdx = 0; bondIdx < this.btoLength; ++bondIdx) {
            if (this.btyp[bondIdx] != 2) continue;
            int atom1 = this.bFrom[bondIdx];
            int atom2 = this.bto[bondIdx];
            int origAtom1 = this.atomIdxInAtomsArray[atom1];
            int origAtom2 = this.atomIdxInAtomsArray[atom2];
            int origBondIdx = this.molecule.getBondTable().getBondIndex(origAtom1, origAtom2);
            MolBond bond = this.molecule.getBond(origBondIdx);
            if (!this.isCTCheckNeeded(bond, isDaylightFormat)) continue;
            this.storeCTIForBond(bondIdx, bond, atom1, atom2);
            if (this.searchOptions.getStereoModel() != 1) continue;
            if (grinv == null) {
                grinv = new int[this.molecule.getAtomCount()];
                this.molecule.getGrinv(grinv, 3);
            }
            if (!this.isSymm(atom1, atom2, grinv, origAtom1) && !this.isSymm(atom2, atom1, grinv, origAtom1)) continue;
            this.isSymmetrical = ArrayTools.initArray(this.isSymmetrical, this.btypLength);
            this.isSymmetrical[bondIdx] = true;
        }
    }

    private boolean isSymm(int atom1, int atom2, int[] grinv, int origAtom1) {
        int nBonds = this.abonds[atom1];
        if (nBonds < 4 && nBonds > 1) {
            int g0;
            int i;
            int[] n = new int[2];
            int nc = 0;
            for (i = 0; i < nBonds; ++i) {
                int n1 = this.bto[this.bondidx[atom1] + i];
                if (n1 == atom2) continue;
                n[nc++] = n1;
            }
            for (i = 0; i < nc; ++i) {
                n[i] = this.atomIdxInAtomsArray[n[i]];
            }
            if (nc == 2) {
                g0 = n[0] == -1 ? -1 : grinv[n[0]];
                int g1 = n[1] == -1 ? -1 : grinv[n[1]];
                return g0 == g1;
            }
            int n2 = g0 = n[0] == -1 ? -1 : grinv[n[0]];
            if (g0 == -1) {
                MolAtom a = this.atoms[origAtom1];
                return a.getImplicitHcount() + a.getExplicitHcount() == 1;
            }
            return false;
        }
        return false;
    }

    protected void initDBSWaitsFor() {
        this.dBSWaitsFor = ArrayTools.initArray(this.dBSWaitsFor, this.ctiRecordsLength);
        this.dBSRecord = ArrayTools.initArray(this.dBSRecord, this.ctiRecordsLength);
        for (int i = 0; i < this.ctiRecordsLength; ++i) {
            this.dBSRecord[i] = i;
            int max = this.ctiRecords[i * 4 + 1];
            max = Math.max(max, this.ctiRecords[i * 4 + 2]);
            int bi = this.ctiRecords[i * 4 + 0];
            int a1 = this.bFrom[bi];
            max = Math.max(max, a1);
            int a2 = this.bto[bi];
            this.dBSWaitsFor[i] = max = Math.max(max, a2);
        }
        IntIntQuickSort sorter = new IntIntQuickSort(1, this.dBSWaitsFor, this.dBSRecord);
        sorter.qsort(0, this.ctiRecordsLength - 1);
        if (this.searchOptions.verbose) {
            System.err.println("DBSWaitsFor:" + Dumper.dumpIntArray(this.dBSWaitsFor));
            System.err.println("DBSRecord  :" + Dumper.dumpIntArray(this.dBSRecord));
        }
    }

    private void initChirality() {
        int i;
        int ac = this.atomsLength;
        this.atomStereo = ArrayTools.initArray(this.atomStereo, this.matomLength);
        this.parity = ArrayTools.initArray(this.parity, this.matomLength);
        this.parityLength = this.matomLength;
        this.hasAtomStereo = false;
        this.hasSpecificAtomStereo = false;
        this.stereoGroupType = null;
        this.stereoGroupNumber = null;
        int[] atomsStereoGroupType = null;
        int[] atomsStereoGroupNumber = null;
        atomsStereoGroupType = ArrayTools.initArrayAndFill(atomsStereoGroupType, this.atomsLength, -1);
        atomsStereoGroupNumber = ArrayTools.initArrayAndFill(atomsStereoGroupNumber, this.atomsLength, -1);
        this.prevIndexInStereoGroup = null;
        int k = 0;
        for (i = 0; i < ac; ++i) {
            if (this.idxAtomInMatomArray[i] == -1) continue;
            this.parity[k] = this.getTetrahedralParity(i);
            this.correctSingleAtomEnh(k, i, atomsStereoGroupType, atomsStereoGroupNumber);
            this.atomStereo[k] = StructureSearch.getAtomStereo(this.atoms[i], this.parity[k]);
            if (this.atomStereo[k] != 0) {
                boolean enantiomerAndNoEnh;
                if (!this.hasAtomStereo) {
                    this.hasAtomStereo = true;
                    this.initEnhStereoArrays();
                }
                if ((this.parity[k] & 4) == 0) {
                    this.hasSpecificAtomStereo = true;
                }
                MolAtom ma = this.molecule.getAtom(i);
                int sgt = ma.getStereoGroupType();
                int sgtn = -1;
                if (2 == sgt || 3 == sgt) {
                    sgtn = ma.getStereoGroupNumber();
                }
                boolean bl = enantiomerAndNoEnh = sgtn == -1 && this.searchOptions.getStereoSearchType() == 4;
                if (0 == sgt || enantiomerAndNoEnh) {
                    if ((this.molecule.isAbsStereo() || this.searchOptions.isTargetAbsoluteStereo()) && !enantiomerAndNoEnh) {
                        sgt = 1;
                    } else {
                        sgt = 3;
                        sgtn = -2;
                    }
                }
                this.stereoGroupType[k] = sgt;
                this.stereoGroupNumber[k] = sgtn;
            }
            ++k;
        }
        for (i = ac; i < this.parityLength; ++i) {
            this.atomStereo[i] = 0;
            this.parity[i] = 0;
        }
        if (this._IAmTheQuery) {
            if (this.targetInit.isChiralityNeeded && !this.hasAtomStereo) {
                this.hasAtomStereo = true;
                this.initEnhStereoArrays();
            }
            if (this.hasAtomStereo) {
                int j;
                this.chiralAtoms = new int[this.matomLength];
                this.chiralAtomWaitsFor = new int[this.matomLength];
                this.chiralAtomsLenght = 0;
                for (j = 0; j < this.matomLength; ++j) {
                    if (this.atomStereo[j] == 0) continue;
                    int max = j;
                    for (int l = 0; l < this.abonds[j]; ++l) {
                        int neigh = this.bto[this.bondidx[j] + l];
                        if (neigh <= max) continue;
                        max = neigh;
                    }
                    int insertionPoint = ArrayTools.binarySearch(this.chiralAtomWaitsFor, max, 0, this.chiralAtomsLenght - 1);
                    if (insertionPoint < 0) {
                        insertionPoint = -1 - insertionPoint;
                    }
                    System.arraycopy(this.chiralAtoms, insertionPoint, this.chiralAtoms, insertionPoint + 1, this.chiralAtomsLenght - insertionPoint);
                    System.arraycopy(this.chiralAtomWaitsFor, insertionPoint, this.chiralAtomWaitsFor, insertionPoint + 1, this.chiralAtomsLenght - insertionPoint);
                    this.chiralAtoms[insertionPoint] = j;
                    this.chiralAtomWaitsFor[insertionPoint] = max;
                    ++this.chiralAtomsLenght;
                }
                if (this.searchOptions.verbose) {
                    System.err.println("chiralAtomsLength = " + this.chiralAtomsLenght);
                    System.err.println("chiralAtoms:" + Dumper.dumpIntArray(this.chiralAtoms));
                    System.err.println("chiralAtomWaitsFor:" + Dumper.dumpIntArray(this.chiralAtomWaitsFor));
                }
                if (this.hasAtomStereo) {
                    for (i = 1; i < this.chiralAtomsLenght; ++i) {
                        int chAtom = this.chiralAtoms[i];
                        int stGT = this.stereoGroupType[chAtom];
                        if (stGT == 0 || stGT == 1) continue;
                        int otherChIdx = 0;
                        int otherChAtom = this.chiralAtoms[otherChIdx];
                        while (this.stereoGroupType[otherChAtom] != this.stereoGroupType[chAtom] || this.stereoGroupNumber[otherChAtom] != this.stereoGroupNumber[chAtom]) {
                            otherChAtom = this.chiralAtoms[++otherChIdx];
                        }
                        if (otherChAtom == chAtom) continue;
                        this.prevIndexInStereoGroup[chAtom] = otherChAtom;
                    }
                    for (j = 0; j < this.matomLength; ++j) {
                    }
                }
            }
        }
        if (this.searchOptions.verbose) {
            System.err.println("parity:" + Dumper.dumpIntArray(this.parity) + " isQuery:" + this._IAmTheQuery);
        }
        this.chiralityInitialized = true;
    }

    private void correctSingleAtomEnh(int matomInd, int atInd, int[] atomsStereoGroupType, int[] atomsStereoGroupNumber) {
        int i;
        if (!this.isEnhancedCorrectionNeeded(matomInd, atInd)) {
            return;
        }
        if (atomsStereoGroupType[0] == -1) {
            for (i = 0; i < this.atomsLength; ++i) {
                MolAtom atom = this.molecule.getAtom(i);
                atomsStereoGroupNumber[i] = atom.getStereoGroupNumber();
                atomsStereoGroupType[i] = atom.getStereoGroupType();
            }
        }
        if (atomsStereoGroupType[atInd] == 0) {
            return;
        }
        for (i = 0; i < this.atomsLength; ++i) {
            if (i == atInd || atomsStereoGroupNumber[i] != atomsStereoGroupNumber[atInd] || atomsStereoGroupType[i] != atomsStereoGroupType[atInd]) continue;
            return;
        }
        this.parity[matomInd] = 2;
    }

    private boolean isEnhancedCorrectionNeeded(int matomInd, int atInd) {
        int atomParity = this.parity[matomInd];
        if (this.searchOptions.getStereoModel() == 2) {
            return atomParity == 3;
        }
        return atomParity != 1 && atomParity != 2 && this.molecule.getParityType(atInd) == 1;
    }

    private void initEnhStereoArrays() {
        this.stereoGroupType = ArrayTools.initArrayAndFill(this.stereoGroupType, this.matomLength, 0);
        this.stereoGroupNumber = ArrayTools.initArrayAndFill(this.stereoGroupNumber, this.matomLength, -1);
        this.prevIndexInStereoGroup = ArrayTools.initArrayAndFill(this.prevIndexInStereoGroup, this.matomLength, -1);
    }

    private final int getTetrahedralParity(int i) {
        if (this.molecule.getParityType(i) == 2) {
            return 0;
        }
        if (this.searchOptions.getStereoModel() == 2) {
            return this.molecule.getParity(i);
        }
        return this.molecule.getLocalParity(i);
    }

    private void initAromatic() {
        block7: {
            int i;
            block6: {
                this.aromaticLength = -1;
                this.hasAmbigArom = false;
                if (!this._IAmTheQuery && !this.optIsExactQueryAtomMatching) break block6;
                int j = 0;
                for (int i2 = 0; i2 < this.atomsLength; ++i2) {
                    MolAtom atom = this.atoms[i2];
                    if (this.idxAtomInMatomArray[i2] == -1) continue;
                    int value = this.getQueryAromaticity(atom, j);
                    if (value != 0) {
                        if (this.aromaticLength < this.matomLength) {
                            this.aromatic = ArrayTools.initArrayAndFill(this.aromatic, this.matomLength, 0);
                            this.aromaticLength = this.matomLength;
                        }
                        this.targetInit.isAromaticityNeeded = true;
                        this.aromatic[j] = value == 3 ? 0 : value;
                    }
                    ++j;
                }
                break block7;
            }
            if (!this.isAromaticityNeededInTarget()) {
                return;
            }
            this.aromatic = ArrayTools.initArray(this.aromatic, this.matomLength);
            this.aromaticLength = this.matomLength;
            int j = 0;
            for (i = 0; i < this.atomsLength; ++i) {
                if (this.idxAtomInMatomArray[i] == -1) continue;
                this.aromatic[j] = this.getTargetAromaticity(j);
                ++j;
            }
            if (this.initMode != 2) break block7;
            for (i = this.atomsLength; i < this.matomLength; ++i) {
                this.aromatic[i] = 2;
            }
        }
    }

    protected boolean isAromaticityNeededInTarget() {
        return this.sub.aromaticLength >= 0 || this.targetInit.isAromaticityNeeded;
    }

    private int getQueryAromaticity(MolAtom atom, int atomIdx) {
        int v = atom.getQueryAromaticity();
        if (v == 3) {
            v = 0;
        }
        int vq = v;
        if (this.optIsExactQueryAtomMatching) {
            v <<= 5;
            v |= vq;
        }
        if (vq == 1 || vq == 2) {
            return v;
        }
        int ta = this.getTargetAromaticity(atomIdx);
        if (ta == 2 || ta == 3) {
            ta = 0;
        }
        return v |= ta;
    }

    protected int getTargetAromaticity(int atomIdx) {
        int bi = this.bondidx[atomIdx];
        for (int i = 0; i < this.abonds[atomIdx]; ++i) {
            if (this.btyp[bi + i] != 4) continue;
            return 1;
        }
        return 2;
    }

    private void initQueryProperties() throws SearchException {
        this.connectionLength = -1;
        this.valenceLength = -1;
        this.hydrogenLength = -1;
        this.ringCountLength = -1;
        this.smallestRingSizeLength = -1;
        this.implHLength = -1;
        this.explConnectionLength = -1;
        this.substCountLength = -1;
        this.ringBondCountLength = -1;
        this.hasUnSaturatedFlag = false;
        if (this._IAmTheQuery || this.optIsExactQueryAtomMatching) {
            this.hasQueryProperty = false;
            int j = 0;
            for (int atomIndex = 0; atomIndex < this.atomsLength; ++atomIndex) {
                MolAtom atom = this.atoms[atomIndex];
                if (this.idxAtomInMatomArray[atomIndex] == -1) continue;
                if (this.smartsAtomTrees != null && this.smartsAtomTrees[atomIndex] != null) {
                    this.hasQueryProperty = true;
                }
                if (this.isNonInitH(atom.getAtno(), atomIndex)) continue;
                int value = atom.getQPropAsInt("X");
                if (value != -1) {
                    if (this.connectionLength < this.matomLength) {
                        this.connection = ArrayTools.initArrayAndFill(this.connection, this.matomLength, -1);
                        this.connectionLength = this.matomLength;
                    }
                    this.targetInit.isConnectionNeeded = true;
                    this.hasQueryProperty = true;
                    this.connection[j] = value;
                }
                if ((value = atom.getValenceProp()) != -1 && this.searchOptions.isValenceMatching()) {
                    if (this.valenceLength < this.matomLength) {
                        this.valence = ArrayTools.initArrayAndFill(this.valence, this.matomLength, -1);
                        this.valenceLength = this.matomLength;
                    }
                    this.targetInit.isValenceNeeded = true;
                    this.hasQueryProperty = true;
                    this.valence[j] = value;
                }
                this.initH_hProp(j, atom);
                value = atom.getQPropAsInt("D");
                if (value != -1) {
                    if (this.explConnectionLength < this.matomLength) {
                        this.explConnection = ArrayTools.initArrayAndFill(this.explConnection, this.matomLength, -1);
                        this.explConnectionLength = this.matomLength;
                    }
                    this.hasQueryProperty = true;
                    this.explConnection[j] = value;
                }
                if ((value = atom.getQPropAsInt("R")) != -1) {
                    if (this.ringCountLength < this.matomLength) {
                        this.ringCount = ArrayTools.initArrayAndFill(this.ringCount, this.matomLength, -1);
                        this.ringCountLength = this.matomLength;
                    }
                    this.hasQueryProperty = true;
                    if (value == 256 || value == 0) {
                        this.targetInit.isRingMembershipNeeded = true;
                    } else {
                        this.targetInit.isRingCountNeeded = true;
                    }
                    this.ringCount[j] = value;
                }
                if ((value = atom.getQPropAsInt("r")) != -1) {
                    if (value == 256) {
                        this.targetInit.isRingMembershipNeeded = true;
                        if (this.ringCountLength < this.matomLength) {
                            this.ringCount = ArrayTools.initArrayAndFill(this.ringCount, this.matomLength, -1);
                            this.ringCountLength = this.matomLength;
                        }
                        this.hasQueryProperty = true;
                        this.ringCount[j] = value;
                    } else {
                        if (this.smallestRingSizeLength < this.matomLength) {
                            this.smallestRingSize = ArrayTools.initArrayAndFill(this.smallestRingSize, this.matomLength, -1);
                            this.smallestRingSizeLength = this.matomLength;
                        }
                        this.targetInit.isRingSizeNeeded = true;
                        this.hasQueryProperty = true;
                        this.smallestRingSize[j] = value;
                    }
                }
                if ((value = atom.getQPropAsInt("c")) != -1) {
                    if (this.componentLevelGroupingLength < this.matomLength) {
                        this.componentLevelGrouping = ArrayTools.initArrayAndFill(this.componentLevelGrouping, this.matomLength, -1);
                        this.componentLevelGroupingLength = this.matomLength;
                    }
                    this.hasQueryProperty = true;
                    this.targetInit.isComponentNumberNeeded = true;
                    this.componentLevelGrouping[j] = value;
                }
                if ((value = atom.getQPropAsInt("s")) != -1) {
                    if (this.substCountLength < this.matomLength) {
                        this.substCount = ArrayTools.initArrayAndFill(this.substCount, this.matomLength, -1);
                        this.substCountLength = this.matomLength;
                    }
                    this.hasQueryProperty = true;
                    if (value > 6) {
                        value = 6;
                    } else if (value == -2) {
                        int qSubst = 0;
                        int qCanBeH = 0;
                        for (int l = 0; l < this.abonds[j]; ++l) {
                            int n = this.bto[this.bondidx[j] + l];
                            if (this.isPlainH(n)) continue;
                            ++qSubst;
                            if (!this.canMatchToH(n, true)) continue;
                            ++qCanBeH;
                        }
                        value = 1000000 + 1000 * qSubst + qCanBeH;
                    }
                    this.substCount[j] = value;
                }
                if ((value = atom.getQPropAsInt("rb")) != -1) {
                    if (this.ringBondCountLength < this.matomLength) {
                        this.ringBondCount = ArrayTools.initArrayAndFill(this.ringBondCount, this.matomLength, -1);
                        this.ringBondCountLength = this.matomLength;
                    }
                    this.hasQueryProperty = true;
                    this.targetInit.isRingMembershipNeeded = true;
                    if (value == -2) {
                        value = 1000;
                        BondClassifier qbc = new BondClassifier();
                        qbc.classify(this.molecule);
                        int atomiInMol = this.molecule.indexOf(atom);
                        int[] ctabForAtom = this.molecule.getCtab()[atomiInMol];
                        for (int l = 0; l < ctabForAtom.length; ++l) {
                            int n = ctabForAtom[l];
                            MolBond bond = atom.getBond(l);
                            int top = bond.getFlags() & 0xC00;
                            if (!qbc.isRingBond(atomiInMol, n) && top != 1024) continue;
                            ++value;
                        }
                    } else if (value > 4) {
                        value = 4;
                    }
                    this.ringBondCount[j] = value;
                }
                if ((value = atom.getQPropAsInt("u")) != -1) {
                    this.hasUnSaturatedFlag = true;
                    this.hasQueryProperty = true;
                }
                ++j;
            }
            if (this.bondTopology != null || this.smartsBondTrees != null) {
                this.hasQueryProperty = true;
            }
            if (this.hasLP) {
                this.initLPQuery();
            }
        } else {
            this.initTargetForQueryProperties();
        }
        this.queryPropertiesInitialized = true;
    }

    private void initH_hProp(int atomIndex, MolAtom atom) {
        int hCount;
        int bigHCount = atom.getQPropAsInt("H");
        int modifiedBigHCount = this.modifyHCountWithExplicitH(atom, bigHCount);
        if (modifiedBigHCount != -1) {
            if (this.hydrogenLength < this.matomLength) {
                this.hydrogen = ArrayTools.initArrayAndFill(this.hydrogen, this.matomLength, -1);
                this.hydrogenGreaterRelation = ArrayTools.initArrayAndFill(this.hydrogenGreaterRelation, this.matomLength, -1);
                this.hydrogenLength = this.matomLength;
            }
            this.targetInit.isHydrogenCountNeeded = true;
            this.hasQueryProperty = true;
            this.hydrogen[atomIndex] = modifiedBigHCount;
            if (this.searchOptions.getHCountMatching() == 1 || this.searchOptions.getHCountMatching() == 0 && MolHandler.isDaylightFormat(this.molecule.getInputFormat())) {
                this.hydrogenGreaterRelation[atomIndex] = atom.getProperty("origHmissing") == null ? 61 : 62;
            } else {
                this.hydrogenGreaterRelation[atomIndex] = this.hydrogen[atomIndex] == 0 || atom.getProperty("origH0") != null ? 61 : 62;
                if (!this.convertExplHToHCount) {
                    int n = atomIndex;
                    this.hydrogen[n] = this.hydrogen[n] + this.atoms[this.atomIdxInAtomsArray[atomIndex]].getExplicitHcount();
                }
            }
            atom.removeProperty("origH0");
            atom.removeProperty("origHmissing");
        }
        if ((hCount = atom.getQPropAsInt("h")) != -1) {
            if (this.implHLength < this.matomLength) {
                this.implH = ArrayTools.initArrayAndFill(this.implH, this.matomLength, -1);
                this.implHLength = this.matomLength;
            }
            this.hasQueryProperty = true;
            this.implH[atomIndex] = hCount;
        }
    }

    private void initTargetForQueryProperties() throws SearchException {
        if (!this.sub.hasQueryProperty) {
            return;
        }
        if (this.targetInit.isConnectionNeeded) {
            this.connection = ArrayTools.initArray(this.connection, this.matomLength);
            this.connectionLength = this.matomLength;
        }
        if (this.targetInit.isValenceNeeded) {
            this.valence = ArrayTools.initArray(this.valence, this.matomLength);
            this.valenceLength = this.matomLength;
        }
        if (this.targetInit.isHydrogenCountNeeded) {
            this.hcount = ArrayTools.initArray(this.hcount, this.matomLength);
            this.hcountLength = this.matomLength;
        }
        if (this.targetInit.isRingCountNeeded) {
            this.ringCount = ArrayTools.initArrayAndFill(this.ringCount, this.matomLength, 0);
            this.ringCountLength = this.matomLength;
        }
        if (this.targetInit.isRingSizeNeeded) {
            this.smallestRingSize = ArrayTools.initArrayAndFill(this.smallestRingSize, this.matomLength, 0);
            this.smallestRingSizeLength = this.matomLength;
        }
        if (this.sub.substCountLength != -1) {
            this.substCount = ArrayTools.initArrayAndFill(this.substCount, this.matomLength, 0);
            this.substCountLength = this.matomLength;
        }
        if (this.sub.explConnectionLength != -1) {
            this.explConnection = ArrayTools.initArrayAndFill(this.explConnection, this.matomLength, 0);
            this.explConnectionLength = this.matomLength;
        }
        if (this.sub.ringBondCountLength != -1 || this.targetInit.isRingBondCountNeeded) {
            this.ringBondCount = ArrayTools.initArrayAndFill(this.ringBondCount, this.matomLength, 0);
            this.ringBondCountLength = this.matomLength;
        }
        int[][] rings = this.targetInit.isRingCountNeeded || this.targetInit.isRingSizeNeeded ? this.getSSR() : (int[][])null;
        if (this.targetInit.isComponentNumberNeeded) {
            this.componentLevelGrouping = ArrayTools.initArrayAndFill(this.componentLevelGrouping, this.matomLength, -1);
            this.componentLevelGroupingLength = this.matomLength;
            int[] fragIds = this.getFragIds();
            for (int l = 0; l < this.componentLevelGroupingLength; ++l) {
                if (this.atomIdxInAtomsArray[l] == -1) {
                    int nextAtom = this.bto[this.bondidx[l]];
                    if (this.atomIdxInAtomsArray[nextAtom] == -1) {
                        throw new SearchException("Error at CLG.");
                    }
                    this.componentLevelGrouping[l] = fragIds[this.atomIdxInAtomsArray[nextAtom]];
                    continue;
                }
                this.componentLevelGrouping[l] = fragIds[this.atomIdxInAtomsArray[l]];
            }
        }
        if (this.targetInit.isRingMembershipNeeded) {
            this.targetRingClassifier = this.getTargetRingClassifier();
            this.targetRingClassifier.classify(this.molecule);
        }
        if (this.sub.hasLP) {
            this.initLPTarget();
        }
        int j = 0;
        for (int atomIndex = 0; atomIndex < this.atomsLength; ++atomIndex) {
            MolAtom atom = this.atoms[atomIndex];
            if (this.idxAtomInMatomArray[atomIndex] == -1 || this.isNonInitH(atom.getAtno(), atomIndex)) continue;
            if (this.targetInit.isConnectionNeeded) {
                this.connection[j] = atom.getBondCount() + atom.getImplicitHcount();
            }
            if (this.targetInit.isValenceNeeded) {
                this.valence[j] = atom.getValence();
            }
            if (this.targetInit.isHydrogenCountNeeded) {
                this.hcount[j] = atom.getImplicitHcount() + atom.getExplicitHcount();
            }
            if (rings != null) {
                block2: for (int k = 0; k < rings.length; ++k) {
                    for (int m = 0; m < rings[k].length; ++m) {
                        if (rings[k][m] != atomIndex) continue;
                        if (this.targetInit.isRingCountNeeded) {
                            int n = j;
                            this.ringCount[n] = this.ringCount[n] + 1;
                        }
                        if (!this.targetInit.isRingSizeNeeded || this.smallestRingSize[j] != 0) continue block2;
                        this.smallestRingSize[j] = rings[k].length;
                        continue block2;
                    }
                }
            }
            if (this.substCountLength > 0) {
                this.substCount[j] = this.getSubstitutionCount(j, atom);
            }
            if (this.explConnectionLength > 0) {
                this.explConnection[j] = this.getSubstitutionCount(j, atom);
            }
            if (this.ringBondCountLength > 0) {
                this.ringBondCount[j] = 0;
                int bondCount = atom.getBondCount();
                for (int l = 0; l < bondCount; ++l) {
                    int neighidx;
                    int atomidx = this.molecule.indexOf(atom);
                    if (!this.targetRingClassifier.isRingBond(atomidx, neighidx = this.molecule.indexOf(atom.getLigand(l)))) continue;
                    int n = j;
                    this.ringBondCount[n] = this.ringBondCount[n] + 1;
                }
            }
            ++j;
        }
        if (this.initMode == 2) {
            for (int i = this.atomsLength; i < this.matomLength; ++i) {
                if (this.targetInit.isConnectionNeeded) {
                    this.connection[i] = 1;
                }
                if (!this.targetInit.isValenceNeeded) continue;
                this.valence[i] = 1;
            }
        }
    }

    protected int[] getFragIds() {
        return this.molecule.getFragIds();
    }

    int getSubstitutionCount(int atomIndex, MolAtom atom) throws SearchException {
        int ret = 0;
        int atomiInMol = this.molecule.indexOf(atom);
        int[] ctabForAtom = this.molecule.getCtab()[atomiInMol];
        for (int l = 0; l < ctabForAtom.length; ++l) {
            MolAtom nAtom = this.molecule.getAtom(ctabForAtom[l]);
            if (nAtom.getAtno() == 1 && nAtom.getMassno() == 0) continue;
            ++ret;
        }
        return ret;
    }

    protected RingClassifier getTargetRingClassifier() {
        return new BondClassifier();
    }

    private void initLPQuery() {
        this.hasQueryProperty = true;
        this.lPCount = ArrayTools.initArrayAndFill(this.lPCount, this.matomLength, 0);
        for (int l = 0; l < this.lpIndices.size(); ++l) {
            int i1 = this.lpIndices.get(l);
            MolAtom atom = this.atoms[i1];
            int edgeCount = atom.getBondCount();
            if (edgeCount == 0) {
                System.err.println("Structural Search: WARNING! Isolated lone pair is not supported!");
            }
            for (int i = 0; i < edgeCount; ++i) {
                int nIndex = this.molecule.indexOf(atom.getLigand(i));
                int nIndInMatom = this.idxAtomInMatomArray[nIndex];
                if (nIndInMatom == -1) continue;
                int n = nIndInMatom;
                this.lPCount[n] = this.lPCount[n] + 1;
            }
        }
    }

    private void initLPTarget() {
        this.lPCount = ArrayTools.initArrayAndFill(this.lPCount, this.matomLength, 0);
        for (int i = 0; i < this.matomLength; ++i) {
            int atomIdx = this.atomIdxInAtomsArray[i];
            if (atomIdx <= 0) continue;
            this.lPCount[i] = this.molecule.getLonePairCount(atomIdx);
        }
        if (this.lpIndices != null) {
            for (int l = 0; l < this.lpIndices.size(); ++l) {
                int i1 = this.lpIndices.get(l);
                MolAtom atom = this.atoms[i1];
                int edgeCount = atom.getBondCount();
                if (edgeCount == 0) {
                    System.err.println("Structural Search: WARNING! Isolated lone pair is not supported!");
                }
                for (int i = 0; i < edgeCount; ++i) {
                    int nIndex = this.molecule.indexOf(atom.getLigand(i));
                    int nIndInMatom = this.idxAtomInMatomArray[nIndex];
                    if (nIndInMatom == -1) continue;
                    int n = nIndInMatom;
                    this.lPCount[n] = this.lPCount[n] + 1;
                }
            }
        }
    }

    private void initAtoms() throws SearchException {
        if (this._IAmTheQuery && this.origQuery == null && !this.searchOptions.isKeepQueryOrder()) {
            AtomRearranger ar = new AtomRearranger(this.molecule);
            this.origQuery = this.molecule;
            Molecule mol = ar.getRearrangedMolecule();
            if (mol == this.molecule) {
                this.origQuery = null;
                this.queryRearrangedToOrig = null;
                this.queryOrigToRearranged = null;
            } else {
                this.molecule = mol;
                this.queryRearrangedToOrig = ar.getNewToOld();
                this.queryOrigToRearranged = ar.getOldToNew();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Orig->Rearranged (0-based): " + Dumper.dumpIntArray(this.queryOrigToRearranged));
                    logger.finer("Rearranged->Orig (0-based): " + Dumper.dumpIntArray(this.queryRearrangedToOrig));
                }
            }
        }
        int ac = this.molecule.getAtomCount();
        if (this.atomsLength == -1 || this.atoms.length < ac) {
            this.atoms = new MolAtom[ac];
        }
        this.atomsLength = ac;
        for (int i = 0; i < ac; ++i) {
            this.atoms[i] = this.molecule.getAtom(i);
        }
        for (int j = ac; j < this.atoms.length; ++j) {
            this.atoms[j] = null;
        }
        if (this._IAmTheQuery && !this.optIsExactQueryAtomMatching) {
            try {
                SmartsAtomMatcher.prepareSMARTSTrees(this);
                SmartsAtomMatcher.analyseTrees(this, this.targetInit);
            }
            catch (ParseException e1) {
                throw new SearchException(e1);
            }
        }
    }

    private void fillWithSpaces(StringBuffer sb, int value, int length) {
        if (value >= 0) {
            sb.setLength(0);
            sb.append(value);
        }
        while (sb.length() < length) {
            sb.append(" ");
        }
    }

    private void printMap(Logger maplogger) {
        int i;
        int itemLength = 3;
        StringBuffer sb = new StringBuffer(itemLength + 3);
        StringBuffer wholeSb = null;
        if (maplogger != null) {
            wholeSb = new StringBuffer();
        }
        this.print("\n", wholeSb);
        sb.setLength(0);
        this.fillWithSpaces(sb, -1, itemLength);
        this.print("  " + sb + " Target atoms\n", wholeSb);
        this.print("  " + sb + " [ ", wholeSb);
        for (i = 0; i < this.strAtoms; ++i) {
            this.fillWithSpaces(sb, i, itemLength);
            this.print(sb + " ", wholeSb);
        }
        this.print("]\n", wholeSb);
        this.print("Query atoms\n", wholeSb);
        for (i = 0; i < this.qryAtoms; ++i) {
            this.fillWithSpaces(sb, i, itemLength);
            this.print("  " + sb + " [ ", wholeSb);
            for (int j = 0; j < this.strAtoms; ++j) {
                sb.setCharAt(0, this.map.getMap(i, j) ? (char)'T' : '.');
                sb.setLength(1);
                if (this.optIsPerfectSearch) {
                    if (i == j) {
                        sb.append(')');
                        sb.insert(0, '(');
                    } else {
                        sb.insert(0, ' ');
                    }
                }
                this.fillWithSpaces(sb, -1, itemLength);
                this.print(sb + " ", wholeSb);
            }
            this.print("]\n", wholeSb);
        }
        this.print("\n", wholeSb);
        this.print("depth = " + this.depth + "\n", wholeSb);
        this.print("idx = [", wholeSb);
        for (int l = 0; l < this.depth; ++l) {
            this.print(this.idx[l] + " ", wholeSb);
        }
        this.print("]\n", wholeSb);
        if (maplogger != null && wholeSb != null) {
            maplogger.finest(wholeSb.toString());
        }
    }

    private void print(String string, StringBuffer wholeSb) {
        if (wholeSb == null) {
            System.err.print(string);
        } else {
            wholeSb.append(string);
        }
    }

    protected void initMaps() throws SearchException {
        this.idx = ArrayTools.initArray(this.idx, this.qryAtoms);
        if (this.map == null) {
            this.map = new BitSetSearchMap(this.qryAtoms, this.strAtoms);
        } else {
            this.map.update(this.qryAtoms, this.strAtoms);
        }
        this.sub.initSubDescriptors();
        this.initDescriptors();
        this.needToRepeatChiralCheck = false;
        this.enforcePreMatch();
        for (MoleculeMatcher matcher : this.moleculeMatchers) {
            matcher.compareAllAtoms();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Map after matcher compareAllAtoms()");
            this.printMap(logger);
        }
        int k = 0;
        for (int i = 0; i < this.qryAtoms; ++i) {
            this.idx[i] = 0;
            this.foundZeroLineInMap = true;
            if (this.stopping) {
                return;
            }
            int j = 0;
            while (j < this.strAtoms) {
                if (!(this.preMatchLength != 0 && !this.map.getMap(i, j) || (this.sub.attBondsHash[i] & this.attBondsHash[j]) == this.sub.attBondsHash[i] && this.compareAtoms(i, j) && this.compareHydrogens(i, j))) {
                    this.map.clearMapWithoutStack(i, j);
                }
                this.logDuplicateFailure(i, j);
                if (this.foundZeroLineInMap && this.map.getMap(i, j)) {
                    this.foundZeroLineInMap = false;
                }
                ++j;
                ++k;
            }
            if (!this.foundZeroLineInMap || !this.isZeroLineProhibited) continue;
            if (this.searchOptions.verbose) {
                System.err.println("Found zero line during filling. Exiting..");
                this.printMap(null);
            }
            return;
        }
        this.logInitializedMap();
        while (this.refine()) {
        }
        if (this.searchOptions.verbose) {
            System.err.println("Refined:");
            this.printMap(null);
        }
        if (this.foundZeroLineInMap && this.isZeroLineProhibited) {
            if (this.searchOptions.verbose) {
                System.err.println("Found zero line during refining. Exiting..");
            }
            return;
        }
        this.initHomology();
        if (this.searchOptions.verbose) {
            System.err.println("After HomologyInit:");
            this.printMap(null);
        }
        this.pushMap(this.depth);
    }

    private void logInitializedMap() {
        if (this.searchOptions.verbose || logger.isLoggable(Level.FINEST)) {
            String[] logStrV;
            for (String logStr : logStrV = new String[]{"Query:" + this.getQueryAsString(), "Target:" + this.getTargetAsString(), "", "Compared atoms:"}) {
                if (this.searchOptions.verbose) {
                    System.err.println(logStr);
                }
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest(logStr);
            }
            if (this.searchOptions.verbose) {
                this.printMap(null);
            }
            if (logger.isLoggable(Level.FINEST)) {
                this.printMap(logger);
            }
        }
    }

    private void enforcePreMatch() {
        for (int i = 0; i < this.preMatchLength; ++i) {
            int tAtom = this.preMatchTargetAtoms[i];
            int qAtom = this.preMatchQueryAtoms[i];
            if (qAtom >= this.sub.idxAtomInMatomArrayLength || qAtom < 0 || tAtom >= this.idxAtomInMatomArrayLength || tAtom < 0) continue;
            if (this.sub.origQuery != null) {
                qAtom = this.sub.queryOrigToRearranged[qAtom];
            }
            qAtom = this.sub.idxAtomInMatomArray[qAtom];
            tAtom = this.idxAtomInMatomArray[tAtom];
            if (-1 == qAtom || -1 == tAtom) continue;
            this.clearRowColumn(qAtom, tAtom);
        }
    }

    private void logDuplicateFailure(int i, int j) {
        if (i == j && !this.map.getMap(i, j) && duplicateLogger.isLoggable(Level.FINER)) {
            int qAtomIdx = this.sub.atomIdxInAtomsArray[i];
            int tAtomIdx = this.atomIdxInAtomsArray[j];
            duplicateLogger.fine("Atom " + (qAtomIdx + 1) + " (" + this.atoms[tAtomIdx].toString() + ") doesn't match atom " + (tAtomIdx + 1));
            if (duplicateLogger.isLoggable(Level.FINEST)) {
                duplicateLogger.finest("Target molecule: " + this.molecule.toFormat("mrv"));
                duplicateLogger.finest("Query molecule: " + this.sub.molecule.toFormat("mrv"));
            }
        }
    }

    protected void initHomology() {
    }

    protected void clearRowColumn(int qAtom, int tAtom) {
        this.map.clearRowExcept(qAtom, tAtom);
        this.map.clearColumnExcept(qAtom, tAtom);
    }

    protected final void clearColumn(int tAtom) {
        for (int i = this.depth; i < this.qryAtoms; ++i) {
            this.map.clearMap(i, tAtom);
        }
    }

    protected boolean compareAtomTypes(int queryAtom, int targetAtom) {
        if (this.optIsExactQueryAtomMatching) {
            String ts;
            if (this.sub.matom[queryAtom] != this.matom[targetAtom]) {
                return false;
            }
            switch (this.sub.matom[queryAtom]) {
                case 134: {
                    if (this.sub.atoms[this.sub.atomIdxInAtomsArray[queryAtom]].getRgroup() == this.atoms[this.atomIdxInAtomsArray[targetAtom]].getRgroup()) break;
                    return false;
                }
                case 128: 
                case 129: {
                    if (this.sub.lstcnt[queryAtom] != this.lstcnt[targetAtom]) {
                        return false;
                    }
                    for (int l = 0; l < this.sub.lstcnt[queryAtom]; ++l) {
                        int m;
                        for (m = 0; m < this.lstcnt[targetAtom] && this.sub.lst[this.sub.lstidx[queryAtom] + l] != this.matom[targetAtom]; ++m) {
                        }
                        if (m == this.lstcnt[targetAtom]) continue;
                        return false;
                    }
                    break;
                }
                case 136: {
                    if (this.isPseudoMatching(queryAtom, targetAtom)) break;
                    return false;
                }
            }
            int queryAtomsIndex = this.sub.atomIdxInAtomsArray[queryAtom];
            String qs = queryAtomsIndex != -1 ? this.sub.atoms[queryAtomsIndex].getQuerystr() : null;
            int targetAtomsIndex = this.atomIdxInAtomsArray[targetAtom];
            String string = ts = targetAtomsIndex != -1 ? this.atoms[targetAtom].getQuerystr() : null;
            if (qs == null) {
                return ts == null;
            }
            return qs.equals(ts);
        }
        switch (this.sub.matom[queryAtom]) {
            case 132: {
                if (this.matom[targetAtom] == 6) {
                    return false;
                }
            }
            case 131: {
                if (this.isExactPseudoMatchingNeeded("A")) {
                    return this.matom[targetAtom] == 131;
                }
                if (this.matom[targetAtom] != 1) {
                    return true;
                }
                if (this.isPlainH(targetAtom)) {
                    return this.sub.canMatchToH(queryAtom, true);
                }
                if (MolHandler.isDaylightFormat(this.getQuery().getInputFormat()) || this.sub.hasHReferenceInSMARTS(queryAtom)) break;
                return false;
            }
            case 128: {
                int l;
                for (l = 0; l < this.sub.lstcnt[queryAtom] && this.sub.lst[this.sub.lstidx[queryAtom] + l] != this.matom[targetAtom]; ++l) {
                }
                if (l != this.sub.lstcnt[queryAtom]) break;
                return false;
            }
            case 129: {
                for (int l = 0; l < this.sub.lstcnt[queryAtom]; ++l) {
                    if (this.sub.lst[this.sub.lstidx[queryAtom] + l] != this.matom[targetAtom]) continue;
                    return false;
                }
                if (!this.isPlainH(targetAtom) || this.sub.canMatchToH(queryAtom, true)) break;
                return false;
            }
            case 134: {
                switch (this.searchOptions.getUndefinedRAtom()) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        if (this.matom[targetAtom] == 134) break;
                        return false;
                    }
                }
                break;
            }
            case 138: {
                return true;
            }
            case 136: {
                if (this.isSpecialPseudoMatching(queryAtom, targetAtom)) break;
                return false;
            }
            case 133: {
                String starMatch = this.searchOptions.getExactSpecialAtomMatching();
                if (starMatch != null && starMatch.contains("*")) {
                    return this.matom[targetAtom] == 133;
                }
                return true;
            }
            default: {
                if (this.sub.matom[queryAtom] == this.matom[targetAtom]) break;
                return false;
            }
        }
        return true;
    }

    private final boolean canMatchToH(int queryAtom, boolean toPlainH) {
        switch (this.matom[queryAtom]) {
            case 1: 
            case 133: 
            case 134: 
            case 138: {
                return true;
            }
            case 129: {
                int idx = this.lstidx[queryAtom];
                for (int i = 0; i < this.lstcnt[queryAtom]; ++i) {
                    if (this.lst[idx + i] != 1) continue;
                    return false;
                }
                if (!MolHandler.isDaylightFormat(this.molecule.getInputFormat())) {
                    return true;
                }
            }
            case 131: {
                return this.hasHReferenceInSMARTS(queryAtom) || !toPlainH && MolHandler.isDaylightFormat(this.getTarget().getInputFormat());
            }
            case 128: {
                int idx = this.lstidx[queryAtom];
                for (int i = 0; i < this.lstcnt[queryAtom]; ++i) {
                    if (this.lst[idx + i] != 1) continue;
                    return true;
                }
                return false;
            }
            case 136: {
                int atomIdx = this.atomIdxInAtomsArray[queryAtom];
                if (atomIdx == -1) {
                    return false;
                }
                int qPseudoIdx = this.getSpecialPseudoIndex(atomIdx);
                return qPseudoIdx == 0 || qPseudoIdx == 1 || qPseudoIdx == 21 || qPseudoIdx == 19 || qPseudoIdx == 23;
            }
            default: {
                return false;
            }
        }
    }

    private boolean hasHReferenceInSMARTS(int queryAtom) {
        if (this.smartsAtomTrees != null && this.smartsAtomTrees[queryAtom] != null && this.targetInit.isAllHydrogensNeeded) {
            String querystr = this.atoms[this.atomIdxInAtomsArray[queryAtom]].getQuerystr();
            return querystr.indexOf("#1") != -1 || querystr.indexOf("[H") != -1;
        }
        return false;
    }

    protected boolean isPseudoMatching(int queryAtom, int targetAtom) {
        boolean isQNotPseudo;
        int qmi = this.sub.atomIdxInAtomsArray[queryAtom];
        boolean bl = isQNotPseudo = !this.sub.isPseudo(qmi);
        if (isQNotPseudo) {
            return true;
        }
        int tmi = this.atomIdxInAtomsArray[targetAtom];
        if (!this.isPseudo(tmi)) {
            return false;
        }
        return this.sub.atoms[qmi].getAliasstr().equalsIgnoreCase(this.atoms[tmi].getAliasstr());
    }

    protected boolean isSpecialPseudoMatching(int queryAtom, int targetAtom) {
        boolean isTNotPseudo;
        boolean isQNotPseudo;
        int qmi = this.sub.atomIdxInAtomsArray[queryAtom];
        boolean bl = isQNotPseudo = !this.sub.isPseudo(qmi);
        if (isQNotPseudo) {
            assert (false);
            return true;
        }
        String qAlias = this.sub.atoms[qmi].getAliasstr().toUpperCase();
        if (this.isExactPseudoMatchingNeeded(qAlias)) {
            return this.isPseudoMatching(queryAtom, targetAtom);
        }
        int qPseudoIdx = StructureSearch.getSpecialPseudoIndex(qAlias);
        int tmi = this.atomIdxInAtomsArray[targetAtom];
        boolean bl2 = isTNotPseudo = !this.isPseudo(tmi);
        if (qPseudoIdx == 0) {
            return true;
        }
        if (isTNotPseudo) {
            int targetAtomType = this.matom[targetAtom];
            return StructureSearch.areCompatiblePseudoAndSpecific(qPseudoIdx, targetAtomType);
        }
        String tAlias = this.atoms[tmi].getAliasstr().toUpperCase();
        int tPseudoIdx = StructureSearch.getSpecialPseudoIndex(tAlias);
        if (qPseudoIdx == tPseudoIdx) {
            if (qPseudoIdx == -1) {
                return tAlias.equals(qAlias);
            }
            return true;
        }
        return false;
    }

    static boolean areCompatiblePseudoAndSpecific(int pseudoIdx, int atomType) {
        if (atomType == 134) {
            return true;
        }
        if (atomType > 109) {
            return false;
        }
        switch (pseudoIdx) {
            case -1: {
                return false;
            }
            case 0: {
                return true;
            }
            case 19: {
                return atomType != 6;
            }
            case 21: {
                if (atomType == 1) {
                    return true;
                }
            }
            case 20: {
                return PeriodicSystem.isMetal(atomType);
            }
            case 23: {
                if (atomType == 1) {
                    return true;
                }
            }
            case 22: {
                if (atomType == 85) {
                    return false;
                }
            }
            case 17: {
                return PeriodicSystem.getColumn(atomType) == 17;
            }
        }
        return pseudoIdx < 19 && pseudoIdx == PeriodicSystem.getColumn(atomType);
    }

    boolean isExactPseudoMatchingNeeded(String alias) {
        String specialMatch = this.searchOptions.getExactSpecialAtomMatching();
        if (specialMatch != null && specialMatch.length() > 0) {
            String[] list = specialMatch.split(",");
            for (int i = 0; i < list.length; ++i) {
                if (!alias.equalsIgnoreCase(list[i])) continue;
                return true;
            }
        }
        return false;
    }

    boolean isPseudo(int atomIndex) {
        return atomIndex != -1 && this.atoms[atomIndex] != null && this.atoms[atomIndex].isPseudo();
    }

    protected boolean compareAromaticity(int queryAtom, int targetAtom) {
        int aroQT;
        int aroQQ;
        int aroQ = 0;
        int aroT = 0;
        if (this.sub.aromaticLength > 0) {
            aroQ = this.sub.aromatic[queryAtom];
        }
        if (this.aromaticLength > 0) {
            aroT = this.aromatic[targetAtom];
        }
        if (this.optIsExactQueryAtomMatching && (aroQQ = aroQ >> 5) != (aroQT = aroT >> 5)) {
            return false;
        }
        if ((aroQ &= 0xFFFFFF9F) == 0 || (aroT &= 0xFFFFFF9F) == 3) {
            return true;
        }
        return aroQ == aroT;
    }

    protected boolean compareAtomQueryProperties(int queryAtom, int targetAtom) throws SearchException {
        if (this.optIsExactQueryAtomMatching) {
            MolAtom atom;
            MolAtom tAtom;
            MolAtom qAtom;
            int conQ = -1;
            int conT = -1;
            if (this.sub.connectionLength > 0) {
                conQ = this.sub.connection[queryAtom];
            }
            if (this.connectionLength > 0) {
                conT = this.connection[targetAtom];
            }
            if (conQ != conT) {
                return false;
            }
            int valQ = -1;
            int valT = -1;
            if (this.sub.valenceLength > 0) {
                valQ = this.sub.valence[queryAtom];
            }
            if (this.valenceLength > 0) {
                valT = this.valence[targetAtom];
            }
            if (valQ != valT && (valQ = (qAtom = this.sub.getAtom(queryAtom)) != null ? qAtom.getValence() : 1) != (valT = (tAtom = this.getAtom(targetAtom)) != null ? tAtom.getValence() : 1)) {
                return false;
            }
            int rcoQ = -1;
            int rcoT = -1;
            if (this.sub.ringCountLength > 0) {
                rcoQ = this.sub.ringCount[queryAtom];
            }
            if (this.ringCountLength > 0) {
                rcoT = this.ringCount[targetAtom];
            }
            if (rcoQ != rcoT) {
                return false;
            }
            int srsQ = -1;
            int srsT = -1;
            if (this.sub.smallestRingSizeLength > 0) {
                srsQ = this.sub.smallestRingSize[queryAtom];
            }
            if (this.smallestRingSizeLength > 0) {
                srsT = this.smallestRingSize[targetAtom];
            }
            if (srsQ != srsT) {
                return false;
            }
            int hydQ = -1;
            int hydT = -1;
            int hydQR = 61;
            int hydTR = 61;
            if (this.sub.hydrogenLength > 0) {
                hydQ = this.sub.hydrogen[queryAtom];
                hydQR = this.sub.hydrogenGreaterRelation[queryAtom];
            }
            if (this.hydrogenLength > 0) {
                hydT = this.hydrogen[targetAtom];
                hydTR = this.hydrogenGreaterRelation[targetAtom];
            }
            if (hydQR != hydTR || hydQ != hydT) {
                return false;
            }
            int implHQ = -1;
            int implHT = -1;
            if (this.sub.implHLength > 0) {
                implHQ = this.sub.implH[queryAtom];
            }
            if (this.implHLength > 0) {
                implHT = this.implH[queryAtom];
            }
            if (implHQ != implHT) {
                return false;
            }
            int explCQ = -1;
            int explCT = -1;
            if (this.sub.explConnectionLength > 0) {
                explCQ = this.sub.explConnection[queryAtom];
            }
            if (this.explConnectionLength > 0) {
                explCT = this.explConnection[queryAtom];
            }
            if (explCQ != explCT) {
                return false;
            }
            if (!this.isSubstCountOK(queryAtom, targetAtom, -1)) {
                return false;
            }
            int rbQ = -1;
            int rbT = -1;
            if (this.sub.ringBondCountLength > 0) {
                rbQ = this.sub.ringBondCount[queryAtom];
            }
            if (this.ringBondCountLength > 0) {
                rbT = this.ringBondCount[targetAtom];
            }
            if (rbQ != rbT) {
                return false;
            }
            int uQ = -1;
            int uT = -1;
            if (this.sub.hasUnSaturatedFlag && this.sub.atomIdxInAtomsArray[queryAtom] >= 0) {
                atom = this.sub.atoms[this.sub.atomIdxInAtomsArray[queryAtom]];
                uQ = atom.getQPropAsInt("u");
            }
            if (this.hasUnSaturatedFlag && this.atomIdxInAtomsArray[targetAtom] >= 0) {
                atom = this.atoms[this.atomIdxInAtomsArray[targetAtom]];
                uT = atom.getQPropAsInt("u");
            }
            if (uQ != uT) {
                return false;
            }
            if (this.sub.hasLP || this.hasLP) {
                int tLPCount;
                int qLPCount = this.sub.hasLP ? this.sub.lPCount[queryAtom] : 0;
                int n = tLPCount = this.hasLP ? this.lPCount[targetAtom] : 0;
                if (qLPCount != tLPCount) {
                    int mta;
                    int mqa;
                    if (qLPCount == 0 && (mqa = this.sub.atomIdxInAtomsArray[queryAtom]) >= 0) {
                        qLPCount = this.sub.molecule.getLonePairCount(mqa);
                    }
                    if (tLPCount == 0 && (mta = this.atomIdxInAtomsArray[targetAtom]) >= 0) {
                        tLPCount = this.molecule.getLonePairCount(mta);
                    }
                    if (qLPCount != tLPCount) {
                        return false;
                    }
                }
            }
            return true;
        }
        if (this.sub.hasQueryProperty) {
            MolAtom atom;
            int uQ;
            if (this.sub.connectionLength > 0 && !this.isConnectionOK(queryAtom, targetAtom)) {
                return false;
            }
            if (this.sub.explConnectionLength > 0 && !this.isExplConnectionCountOk(queryAtom, targetAtom)) {
                return false;
            }
            if (this.searchOptions.isValenceMatching() && this.sub.valenceLength > 0 && this.sub.valence[queryAtom] != -1 && this.valence[targetAtom] != this.sub.valence[queryAtom]) {
                return false;
            }
            if (this.sub.hydrogenLength > 0 && !this.isHydrogenOK(queryAtom, targetAtom)) {
                return false;
            }
            if (this.sub.implHLength > 0 && this.sub.implH[queryAtom] != -1) {
                int atomidx = this.atomIdxInAtomsArray[targetAtom];
                int implHT = 0;
                if (atomidx >= 0) {
                    MolAtom atom2 = this.atoms[atomidx];
                    implHT = atom2.getImplicitHcount();
                }
                if (implHT != this.sub.implH[queryAtom]) {
                    return false;
                }
            }
            if (this.sub.smallestRingSizeLength > 0 && !this.isSmallestRingSizeOk(queryAtom, targetAtom)) {
                return false;
            }
            if (this.sub.ringCountLength > 0 && this.sub.ringCount[queryAtom] != -1 && (this.sub.ringCount[queryAtom] == 256 ? this.atomIdxInAtomsArray[targetAtom] >= 0 && !this.targetRingClassifier.isRingAtom(this.atomIdxInAtomsArray[targetAtom]) : (this.sub.ringCount[queryAtom] == 0 ? this.atomIdxInAtomsArray[targetAtom] >= 0 && this.targetRingClassifier.isRingAtom(this.atomIdxInAtomsArray[targetAtom]) : !this.isRingCountOk(queryAtom, targetAtom)))) {
                return false;
            }
            if (!this.isSubstCountOK(queryAtom, targetAtom, -1)) {
                return false;
            }
            if (this.sub.ringBondCountLength > 0 && !this.isRingBondCountOk(queryAtom, targetAtom)) {
                return false;
            }
            if (this.sub.hasUnSaturatedFlag && this.sub.atomIdxInAtomsArray[queryAtom] >= 0 && (uQ = (atom = this.sub.atoms[this.sub.atomIdxInAtomsArray[queryAtom]]).getQPropAsInt("u")) == 1 && !this.isUnsaturatedAtom(targetAtom)) {
                return false;
            }
            if (this.sub.smartsAtomTrees != null && this.sub.atomIdxInAtomsArray[queryAtom] != -1 && this.sub.smartsAtomTrees[this.sub.atomIdxInAtomsArray[queryAtom]] != null) {
                SimpleNode node = this.sub.smartsAtomTrees[this.sub.atomIdxInAtomsArray[queryAtom]];
                return SmartsAtomMatcher.evaluateSmartsAtomTree(this.sub, node, queryAtom, this, targetAtom);
            }
            if (this.sub.hasLP && this.sub.lPCount[queryAtom] > this.lPCount[targetAtom]) {
                return false;
            }
        }
        return true;
    }

    protected boolean isConnectionOK(int queryAtom, int targetAtom) {
        return this.sub.connection[queryAtom] == -1 || this.connection[targetAtom] == this.sub.connection[queryAtom];
    }

    protected boolean isHydrogenOK(int queryAtom, int targetAtom) {
        return this.sub.hydrogen[queryAtom] == -1 || this.sub.hydrogenGreaterRelation[queryAtom] == 61 && this.hcount[targetAtom] == this.sub.hydrogen[queryAtom] || this.sub.hydrogenGreaterRelation[queryAtom] == 62 && this.hcount[targetAtom] >= this.sub.hydrogen[queryAtom];
    }

    protected boolean isRingBondCountOk(int queryAtom, int targetAtom) {
        if (this.sub.ringBondCount[queryAtom] == -1) {
            return true;
        }
        int actRbQ = this.sub.ringBondCount[queryAtom];
        int actRbT = this.ringBondCount[targetAtom];
        if (actRbQ >= 1000) {
            return (actRbQ -= 1000) == actRbT;
        }
        if (actRbQ > 4) {
            actRbQ = 4;
        }
        return actRbQ == 4 && actRbT >= 4 || actRbQ == actRbT;
    }

    protected boolean isSubstCountOK(int qInd, int tInd, int tSubstCount) {
        if (this.optIsExactQueryAtomMatching) {
            int qSubstCount = -1;
            if (this.sub.substCountLength > 0) {
                qSubstCount = this.sub.substCount[qInd];
            }
            if (this.substCountLength > 0 && tInd != -1) {
                tSubstCount = this.substCount[tInd];
            }
            return qSubstCount == tSubstCount;
        }
        if (this.sub.substCountLength > 0 && this.sub.substCount[qInd] != -1) {
            int n = tSubstCount = tInd != -1 ? this.substCount[tInd] : tSubstCount;
            if (this.sub.substCount[qInd] >= 1000000) {
                int value = this.sub.substCount[qInd] - 1000000;
                int qSubst = value / 1000;
                int qCanBeH = value % 1000;
                if (tSubstCount > qSubst) {
                    return false;
                }
                if (tSubstCount < qSubst - qCanBeH) {
                    return false;
                }
            } else {
                int qSubst = this.sub.substCount[qInd];
                if (qSubst == 6 && tSubstCount > 6) {
                    tSubstCount = 6;
                }
                if (qSubst != tSubstCount) {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isExplConnectionCountOk(int queryAtom, int targetAtom) {
        return this.sub.explConnection[queryAtom] == -1 || this.sub.explConnection[queryAtom] == this.explConnection[targetAtom];
    }

    int getExplicitBondCount(int targetAtom) {
        int atomsIdx = this.atomIdxInAtomsArray[targetAtom];
        int edgeCount = atomsIdx < 0 ? 0 : this.atoms[atomsIdx].getBondCount();
        return edgeCount;
    }

    private MolAtom getAtom(int atom) {
        int atomsIdx;
        if (atom < this.atomIdxInAtomsArrayLength && (atomsIdx = this.atomIdxInAtomsArray[atom]) != -1) {
            return this.atoms[atomsIdx];
        }
        return null;
    }

    protected boolean isUnsaturatedAtom(int targetAtom) {
        if (this.atomIdxInAtomsArray[targetAtom] >= 0) {
            MolAtom atom = this.atoms[this.atomIdxInAtomsArray[targetAtom]];
            int bondCount = atom.getBondCount();
            for (int i = 0; i < bondCount; ++i) {
                int type = atom.getBond(i).getType();
                if (type != 2 && type != 3 && type != 4) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean compareAtoms(int queryAtom, int targetAtom) throws SearchException {
        this.exactIsotopeFailed = false;
        if (!this.compareAtomTypes(queryAtom, targetAtom)) {
            if (queryAtom == targetAtom) {
                duplicateLogger.finer("Atom type comparison failed.");
            }
            return false;
        }
        if (!this.compareAromaticity(queryAtom, targetAtom)) {
            if (queryAtom == targetAtom) {
                duplicateLogger.finer("Aromaticity comparison failed.");
            }
            return false;
        }
        if (this.optIsotopeMatching != 2 && this.sub.isotope[queryAtom] != this.isotope[targetAtom] && (this.optIsotopeMatching == 1 || 0 != this.sub.isotope[queryAtom])) {
            if (this.sub.isotope[queryAtom] == 0 && this.optIsotopeMatching == 1 && this.sub.smartsAtomTrees != null && this.sub.smartsAtomTrees[queryAtom] != null) {
                this.exactIsotopeFailed = true;
            } else {
                if (queryAtom == targetAtom) {
                    duplicateLogger.finer("Isotope comparison failed.");
                }
                return false;
            }
        }
        if (this.optChargeMatching != 2 && this.sub.acharge[queryAtom] != this.acharge[targetAtom] && (this.optChargeMatching == 1 || 0 != this.sub.acharge[queryAtom])) {
            if (queryAtom == targetAtom) {
                duplicateLogger.finer("Charge comparison failed for atom.");
            }
            return false;
        }
        if (this.optRadicalMatching == 0 ? this.sub.radical[queryAtom] != 0 && this.sub.radical[queryAtom] != this.radical[targetAtom] && (this.sub.radical[queryAtom] != 2 || this.radical[targetAtom] != 6 && this.radical[targetAtom] != 10) : this.optRadicalMatching == 1 && this.sub.radical[queryAtom] != this.radical[targetAtom]) {
            return false;
        }
        if (!this.compareAtomQueryProperties(queryAtom, targetAtom)) {
            if (queryAtom == targetAtom) {
                duplicateLogger.finer("Atom query property comparison.");
            }
            return false;
        }
        if (this.isTetrahedralStereoSearch) {
            if (0 != this.sub.atomStereo[queryAtom] && (this.sub.parity[queryAtom] & 4) == 0 && 0 == this.atomStereo[targetAtom] && !this.multiValentV[targetAtom] && this.searchOptions.getStereoModel() != 1) {
                if (queryAtom == targetAtom) {
                    duplicateLogger.finer("Stereo doesn't match to non-stereo.");
                }
                return false;
            }
            if (this.optIsExactStereoMatching && this.sub.hasEnoughBondsForStereo(queryAtom) && !this.multiValentV[targetAtom] && this.sub.atomStereo[queryAtom] != this.atomStereo[targetAtom]) {
                if (this.searchOptions.getStereoModel() == 1) {
                    if (0 == this.sub.atomStereo[queryAtom] && 0 < this.getGParityValue(targetAtom)) {
                        if (queryAtom == targetAtom) {
                            duplicateLogger.finer("Exact stereo matching failed.");
                        }
                        return false;
                    }
                } else {
                    if (queryAtom == targetAtom) {
                        duplicateLogger.finer("Exact stereo matching failed.");
                    }
                    return false;
                }
            }
        }
        if (this.exactIsotopeFailed) {
            return false;
        }
        if (this.optCheckSpHyb && !this.checkSpHyb(queryAtom, targetAtom)) {
            return false;
        }
        if (this.usedMolComparators != null) {
            int mcNo = this.usedMolComparators.size();
            for (int i = 0; i < mcNo; ++i) {
                MolComparator mc = this.usedMolComparators.get(i);
                if (mc.compareAtoms(queryAtom, targetAtom)) continue;
                this.logComparatorFailure(queryAtom, targetAtom, mc);
                return false;
            }
        }
        if (this.optHasUserComparators) {
            for (int i = this.userDefinedComparators.length - 1; i >= 0; --i) {
                if (this.userDefinedComparators[i].compareAtoms(queryAtom, targetAtom)) continue;
                this.logComparatorFailure(queryAtom, targetAtom, this.userDefinedComparators[i]);
                return false;
            }
        }
        return true;
    }

    private void logComparatorFailure(int queryAtom, int targetAtom, MolComparator mc) {
        if (queryAtom == targetAtom && duplicateLogger.isLoggable(Level.FINER)) {
            duplicateLogger.finer("Comparison by " + mc.getClass().getName() + " failed.");
        }
    }

    private boolean hasEnoughBondsForStereo(int queryAtom) {
        int bNum = this.abonds[queryAtom];
        if (bNum < 2) {
            return false;
        }
        int nonHLigands = 0;
        int b = this.bondidx[queryAtom];
        boolean hasDoubleBond = false;
        for (int i = 0; i < bNum; ++i) {
            switch (this.btyp[b + i]) {
                case 3: {
                    return false;
                }
                case 2: {
                    hasDoubleBond = true;
                }
            }
            nonHLigands = !this.isPlainH(this.bto[b + i]) ? nonHLigands + 1 : nonHLigands;
        }
        if (hasDoubleBond) {
            return nonHLigands >= 2;
        }
        return nonHLigands >= 3;
    }

    protected final boolean compareBonds(int queryBond, int targetBond) throws SearchException {
        int qTopology;
        if (!this.compareBondType(queryBond, targetBond)) {
            return false;
        }
        if (this.isDoubleBondStereoSearch && 2 == this.sub.btyp[queryBond] && 2 == this.btyp[targetBond] && !this.compareCT(queryBond, targetBond)) {
            return false;
        }
        if (this.optIsExactBondMatching) {
            qTopology = 0;
            int tTopology = 0;
            if (this.sub.bondTopology != null) {
                qTopology = this.sub.bondTopology[queryBond];
            }
            if (this.bondTopology != null) {
                tTopology = this.bondTopology[targetBond];
            }
            if (qTopology != tTopology) {
                return false;
            }
            if (this.sub.smartsBondTrees != null && this.sub.smartsBondTrees[queryBond] != null) {
                if (this.smartsBondTrees == null || this.smartsBondTrees[targetBond] == null) {
                    return false;
                }
                return SimpleNode.compareSMARTSBondTrees(this.sub.smartsBondTrees[queryBond], this.smartsBondTrees[targetBond]);
            }
        } else {
            if (this.sub.bondTopology != null && this.sub.bondTopology[queryBond] != 0) {
                qTopology = this.sub.bondTopology[queryBond];
                int at1 = this.atomIdxInAtomsArray[this.bto[targetBond]];
                int at2 = this.atomIdxInAtomsArray[this.bFrom[targetBond]];
                if (!(qTopology != 1024 || at1 != -1 && at2 != -1 && this.targetRingClassifier.isRingBond(at1, at2))) {
                    return false;
                }
                if (qTopology == 2048 && at1 != -1 && at2 != -1 && this.targetRingClassifier.isRingBond(at1, at2)) {
                    return false;
                }
            }
            if (this.sub.smartsBondTrees != null && this.sub.smartsBondTrees[queryBond] != null) {
                return SmartsBondMatcher.evaluateSmartsBondTree(this.sub, this.sub.smartsBondTrees[queryBond], queryBond, this, targetBond);
            }
        }
        if (this.usedMolComparators != null) {
            int mcNo = this.usedMolComparators.size();
            for (int i = 0; i < mcNo; ++i) {
                MolComparator mc = this.usedMolComparators.get(i);
                if (mc.compareBonds(queryBond, targetBond)) continue;
                return false;
            }
        }
        if (this.optHasUserComparators) {
            for (int i = this.userDefinedComparators.length - 1; i >= 0; --i) {
                if (this.userDefinedComparators[i].compareBonds(queryBond, targetBond)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean compareBondType(int queryBond, int targetBond) {
        return Search.areMatchingBondTypes(this.sub.btyp[queryBond], this.btyp[targetBond], this.optIsExactBondMatching);
    }

    protected boolean compareCT(int queryBond, int targetBond) {
        boolean cct = this.compareCT0(queryBond, targetBond);
        if (!cct && this.searchOptions.getStereoModel() == 1 && this.isSymmetrical != null && this.isSymmetrical[targetBond]) {
            return true;
        }
        return cct;
    }

    protected boolean compareCT0(int queryBond, int targetBond) {
        if (this.searchOptions.getDoubleBondStereoMatchingMode() == 2) {
            return true;
        }
        int qCTIPos = this.sub.findCTIRecs(queryBond);
        int tCTIPos = this.findCTIRecs(targetBond);
        if (qCTIPos == -1) {
            if (this.optIsExactStereoMatching) {
                int qFrom = this.sub.bFrom[queryBond];
                int qTo = this.sub.bto[queryBond];
                if (this.sub.hasEnoughBondsForStereo(qFrom) && this.sub.hasEnoughBondsForStereo(qTo)) {
                    return tCTIPos == -1;
                }
                return true;
            }
            return true;
        }
        if (qCTIPos != -1 && tCTIPos == -1) {
            return this.multiValentVCisT[this.bto[targetBond]] || this.multiValentVCisT[this.bFrom[targetBond]];
        }
        for (int qi = qCTIPos; qi < this.sub.ctiRecordsLength && this.sub.ctiRecords[qi * 4 + 0] == queryBond; ++qi) {
            int qT = this.sub.ctiRecords[qi * 4 + 3];
            int qA1 = this.sub.ctiRecords[qi * 4 + 1];
            int qA2 = this.sub.ctiRecords[qi * 4 + 2];
            boolean found = false;
            for (int ti = tCTIPos; ti < this.ctiRecordsLength && this.ctiRecords[ti * 4 + 0] == targetBond; ++ti) {
                int tT = this.ctiRecords[ti * 4 + 3];
                int tA1 = this.ctiRecords[ti * 4 + 1];
                int tA2 = this.ctiRecords[ti * 4 + 2];
                if (!this.areMatchingCTITypes(qT, tT) || (!this.map.getMap(qA1, tA1) || !this.map.getMap(qA2, tA2)) && (!this.map.getMap(qA1, tA2) || !this.map.getMap(qA2, tA1))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    final boolean areMatchingCTITypes(int qtype, int stype) {
        boolean sUnspec;
        if (qtype == 0 || qtype == 192) {
            qtype = 448;
        }
        if (stype == 0 || stype == 192) {
            stype = 448;
        }
        if (this.optIsExactStereoMatching) {
            return qtype == stype;
        }
        if (stype == -1) {
            return true;
        }
        if ((qtype & 0xC0) == 192) {
            return true;
        }
        boolean bl = sUnspec = (stype & 0x100) > 0 || (stype & 0xC0) == 192;
        if ((qtype & 0x100) > 0 && sUnspec) {
            return true;
        }
        if ((qtype & 0x100) == 0 && sUnspec) {
            return false;
        }
        return (stype &= 0xC0) == (qtype &= 0xC0);
    }

    protected final int findCTIRecs(int bondIndex) {
        int high = this.ctiRecordsLength;
        int low = -1;
        while (high - low > 1) {
            int probe = (high + low) / 2;
            if (this.ctiRecords[probe * 4 + 0] < bondIndex) {
                low = probe;
                continue;
            }
            high = probe;
        }
        if (high == this.ctiRecordsLength || this.ctiRecords[high * 4 + 0] != bondIndex) {
            return -1;
        }
        return high;
    }

    protected boolean compareHydrogens(int queryAtom, int targetAtom) {
        int queryHCount;
        int b;
        int list = 0;
        if (!this.optIsExactQueryAtomMatching) {
            for (b = 0; b < this.sub.abonds[queryAtom]; ++b) {
                int atomIndex = this.sub.bto[this.sub.bondidx[queryAtom] + b];
                int atype = this.sub.matom[atomIndex];
                if (atype == 1 || !this.sub.canMatchToH(atomIndex, false)) continue;
                ++list;
            }
        }
        int queryNonHConnection = this.sub.abonds[queryAtom];
        if (this.sub.initMode != 0 || this.sub.hasSpecialHToHandle) {
            for (b = 0; b < this.sub.abonds[queryAtom]; ++b) {
                if (this.sub.matom[this.sub.bto[this.sub.bondidx[queryAtom] + b]] != 1) continue;
                --queryNonHConnection;
            }
        }
        int targetNonHConnection = this.abonds[targetAtom];
        if (this.initMode != 0 || this.hasSpecialHToHandle) {
            for (b = 0; b < this.abonds[targetAtom]; ++b) {
                if (this.matom[this.bto[this.bondidx[targetAtom] + b]] != 1) continue;
                --targetNonHConnection;
            }
        }
        if (this.optIsPerfectSearch) {
            if (queryNonHConnection != targetNonHConnection) {
                if (queryAtom == targetAtom) {
                    duplicateLogger.finer("Query and target has different non-H connections.");
                }
                return false;
            }
        } else if (this.searchOptions.isFullFragment() && targetNonHConnection > queryNonHConnection) {
            return false;
        }
        if (queryNonHConnection - list > targetNonHConnection) {
            return false;
        }
        if (this.sub.hydrogensLength > 0) {
            if (this.optIsPerfectSearch) {
                queryHCount = this.sub.hcount[queryAtom];
            } else {
                queryHCount = 0;
                for (b = 0; b < this.sub.hcount[queryAtom]; ++b) {
                    if (this.sub.hydrogens[this.sub.hidx[queryAtom] + b] < 0) continue;
                    ++queryHCount;
                }
            }
        } else {
            queryHCount = this.sub.abonds[queryAtom] - queryNonHConnection;
        }
        int targetHCount = this.hydrogensLength > 0 ? this.hcount[targetAtom] : this.abonds[targetAtom] - targetNonHConnection;
        if (this.searchOptions.getImplicitHMatching() == 3) {
            return true;
        }
        if (this.optIsPerfectSearch && this.sub.matom[queryAtom] > 0 && this.sub.matom[queryAtom] <= 109) {
            if (queryHCount - list != targetHCount) {
                if (queryAtom == targetAtom) {
                    duplicateLogger.finer("Query and target has different hydrogen connections.");
                }
                return false;
            }
        } else if (queryHCount - list > targetHCount) {
            return false;
        }
        return true;
    }

    private final boolean compareEnhParities(int i, int j, int prevInGroupMatchingType) {
        if (this.sub.hasAtomStereo && (2 == this.sub.stereoGroupType[i] || 3 == this.sub.stereoGroupType[i])) {
            if (-1 == prevInGroupMatchingType) {
                return true;
            }
            if (0 == prevInGroupMatchingType) {
                try {
                    return this.sub.parity[i] == this.parity[j] == this.equalParities(i, j);
                }
                catch (ParityCannotBeEvaluatedYetException e) {
                    return true;
                }
            }
            try {
                return this.sub.parity[i] == this.parity[j] != this.equalParities(i, j);
            }
            catch (ParityCannotBeEvaluatedYetException e) {
                return true;
            }
        }
        try {
            boolean isQAtomABS = this.searchOptions.isQueryAbsoluteStereo() || this.getQuery().isAbsStereo() || this.sub.hasAtomStereo && this.sub.stereoGroupType[i] == 1;
            boolean isTAtomABS = this.searchOptions.isTargetAbsoluteStereo() || this.getTarget().isAbsStereo() || this.sub.hasAtomStereo && this.sub.stereoGroupType[j] == 1;
            return this.sub.parity[i] == this.parity[j] == this.equalParities(i, j) && isQAtomABS == isTAtomABS;
        }
        catch (ParityCannotBeEvaluatedYetException e) {
            return true;
        }
    }

    private final int getMatchingTypeForwardOrReverse(int i, int j) {
        int rv = -1;
        try {
            if (this.sub.atomStereo[i] != 64 && this.atomStereo[j] != 64) {
                rv = this.sub.parity[i] == this.parity[j] == this.equalParities(i, j) ? 0 : 1;
            }
        }
        catch (ParityCannotBeEvaluatedYetException e) {
            rv = -1;
        }
        return rv;
    }

    final boolean compareEnhLabels(int i, int j) {
        int enhLabelJ;
        int enhLabelI = this.sub.hasAtomStereo ? this.sub.stereoGroupType[i] : 0;
        if (0 == enhLabelI && 32 == this.sub.atomStereo[i]) {
            enhLabelI = 1;
        }
        if (0 == (enhLabelJ = this.hasAtomStereo ? this.stereoGroupType[j] : 0) && 32 == this.atomStereo[j]) {
            enhLabelJ = 1;
        }
        return enhStereoMatching[enhLabelI][enhLabelJ];
    }

    protected boolean compareChiralities(int q, int t) {
        boolean cc = this.compareChiralities0(q, t);
        if (!cc) {
            int gp;
            if (this.searchOptions.getStereoModel() == 1 && (gp = this.getGParityValue(t)) == 0) {
                cc = true;
            }
            if (!cc && this.multiValentV[t]) {
                cc = true;
            }
        }
        return cc;
    }

    private int getGParityValue(int t) {
        int gp;
        if (this.gParity == null) {
            this.gParity = ArrayTools.initArray(this.gParity, this.matomLength, -1);
        }
        if ((gp = this.gParity[t]) == -1) {
            int origT = this.atomIdxInAtomsArray[t];
            if (origT == -1) {
                gp = -2;
            } else {
                this.gParity[t] = gp = this.molecule.getParity(origT);
            }
        }
        return gp;
    }

    final boolean compareChiralities0(int i, int j) {
        int prevInGroupMatchingType = -1;
        int q = this.sub.parity[i];
        int t = this.parity[j];
        int qs = this.sub.atomStereo[i];
        int ts = this.atomStereo[j];
        if (this.optIsExactStereoMatching) {
            if (this.searchOptions.ignoreChiralityForAtoms != null && this.searchOptions.ignoreChiralityForAtoms.contains(this.idxAtomInMatomArray[i])) {
                return true;
            }
            if (qs == 32) {
                if (this.sub.hasAtomStereo && (this.sub.stereoGroupType[i] != 0 && !this.hasAtomStereo || this.sub.stereoGroupType[i] != this.stereoGroupType[j])) {
                    return false;
                }
                if (this.sub.hasAtomStereo && this.sub.prevIndexInStereoGroup[i] != -1) {
                    int jGroupMember = this.idx[this.sub.prevIndexInStereoGroup[i]] - 1;
                    if (this.hasAtomStereo && (this.stereoGroupType[jGroupMember] != this.stereoGroupType[j] || this.stereoGroupNumber[jGroupMember] != this.stereoGroupNumber[j])) {
                        return false;
                    }
                    prevInGroupMatchingType = this.getMatchingTypeForwardOrReverse(this.sub.prevIndexInStereoGroup[i], jGroupMember);
                }
                if (this.hasAtomStereo && this.prevIndexInStereoGroup[j] != -1) {
                    int iGroupMember = -1;
                    for (int k = 0; k < this.depth; ++k) {
                        if (this.idx[k] - 1 != this.prevIndexInStereoGroup[j]) continue;
                        iGroupMember = k;
                        break;
                    }
                    if (this.sub.hasAtomStereo && -1 != iGroupMember && (this.sub.stereoGroupType[iGroupMember] != this.sub.stereoGroupType[i] || this.sub.stereoGroupNumber[iGroupMember] != this.sub.stereoGroupNumber[i])) {
                        return false;
                    }
                }
                return ts == 32 && (q & 4) == (t & 4) && this.compareEnhParities(i, j, prevInGroupMatchingType);
            }
            return qs == ts || !this.sub.hasEnoughBondsForStereo(i);
        }
        switch (qs) {
            case 0: {
                return true;
            }
            case 64: {
                return ts != 0;
            }
        }
        if (this.searchOptions.getStereoSearchType() == 3) {
            return ts != 0;
        }
        if ((q & 4) != 0) {
            try {
                return ts != 32 || (q & 0xFFFFFFFB) == (t & 0xFFFFFFFB) == this.equalParities(i, j);
            }
            catch (ParityCannotBeEvaluatedYetException e) {
                return true;
            }
        }
        if (this.sub.hasAtomStereo && this.sub.prevIndexInStereoGroup[i] != -1) {
            int jGroupMember = this.idx[this.sub.prevIndexInStereoGroup[i]] - 1;
            if (this.hasAtomStereo && (this.stereoGroupType[jGroupMember] != this.stereoGroupType[j] || this.stereoGroupNumber[jGroupMember] != this.stereoGroupNumber[j])) {
                return false;
            }
            prevInGroupMatchingType = this.getMatchingTypeForwardOrReverse(this.sub.prevIndexInStereoGroup[i], jGroupMember);
        }
        return ts == 32 && this.compareEnhLabels(i, j) && this.compareEnhParities(i, j, prevInGroupMatchingType);
    }

    private final boolean equalParities(int i, int j) throws ParityCannotBeEvaluatedYetException {
        if (this.setChiralNeighbors(i)) {
            return MolAtom.isSameParityClass(this.sub.chneib[0], this.sub.chneib[1], this.sub.chneib[2], this.sub.chneib[3], this.chneib[0], this.chneib[1], this.chneib[2], this.chneib[3]);
        }
        throw new ParityCannotBeEvaluatedYetException();
    }

    protected boolean testChiralityInTheMiddle(int d) {
        if (!this.optIsExactStereoMatching && !this.sub.hasAtomStereo || !this.isTetrahedralStereoSearch) {
            return true;
        }
        int index = ArrayTools.binarySearchForFirst(this.sub.chiralAtomWaitsFor, d, 0, this.sub.chiralAtomsLenght - 1);
        if (index >= 0) {
            int n = this.depth;
            this.idx[n] = this.idx[n] + 1;
            while (index < this.sub.chiralAtomsLenght && this.sub.chiralAtomWaitsFor[index] == d) {
                int chiralAtom = this.sub.chiralAtoms[index];
                if (!this.compareChiralities(chiralAtom, this.idx[chiralAtom] - 1)) {
                    int n2 = this.depth;
                    this.idx[n2] = this.idx[n2] - 1;
                    return false;
                }
                ++index;
            }
            int n3 = this.depth;
            this.idx[n3] = this.idx[n3] - 1;
        }
        return true;
    }

    protected boolean isCompatibleIdx(int d) {
        boolean foundCLGComponent;
        boolean foundComponent = false;
        boolean bl = foundCLGComponent = this.sub.componentLevelGrouping == null || this.sub.componentLevelGrouping[d] == -1;
        if (d != 0) {
            int i;
            int idx_d = this.idx[d];
            int compDT = -1;
            if (this.componentLevelGroupingLength > idx_d) {
                compDT = this.componentLevelGrouping[idx_d];
            }
            for (i = 0; i < d; ++i) {
                int idx_i = this.idx[i] - 1;
                if (this.targetInit.isComponentNumberNeeded && !foundCLGComponent) {
                    int compIT = -1;
                    if (this.componentLevelGroupingLength > idx_i) {
                        compIT = this.componentLevelGrouping[idx_i];
                    }
                    if (this.sub.componentLevelGrouping[d] == this.sub.componentLevelGrouping[i]) {
                        if (compIT != compDT) {
                            return false;
                        }
                        foundCLGComponent = true;
                    }
                    if (this.sub.componentLevelGrouping[d] != this.sub.componentLevelGrouping[i] && this.sub.componentLevelGrouping[i] != -1 && this.sub.componentLevelGrouping[d] != -1 && compDT == compIT) {
                        return false;
                    }
                }
                if (this.isFastSearch || foundComponent || this.sub.component[d] != this.sub.component[i]) continue;
                if (this.component[idx_d] != this.component[idx_i]) {
                    return false;
                }
                foundComponent = true;
            }
            if (!this.testChiralityInTheMiddle(d)) {
                return false;
            }
            if (this.hasAtomStereo && this.optIsExactStereoMatching && this.sub.hasAtomStereo && this.sub.stereoGroupNumber[d] != -1) {
                int qSGNd = this.sub.stereoGroupNumber[d];
                int qSGTd = this.sub.stereoGroupType[d];
                for (int i2 = 0; i2 < d; ++i2) {
                    int idx_i;
                    if (this.sub.stereoGroupType[i2] != qSGTd || this.sub.stereoGroupNumber[i2] == qSGNd || this.stereoGroupNumber[idx_i = this.idx[i2] - 1] != this.stereoGroupNumber[idx_d]) continue;
                    return false;
                }
            }
            if (this.usedMolComparators != null) {
                int n = d;
                this.idx[n] = this.idx[n] + 1;
                int mcNo = this.usedMolComparators.size();
                for (int i3 = 0; i3 < mcNo; ++i3) {
                    MolComparator mc = this.usedMolComparators.get(i3);
                    if (mc.compareHit(this.idx, d + 1)) continue;
                    int n2 = d;
                    this.idx[n2] = this.idx[n2] - 1;
                    return false;
                }
                int n3 = d;
                this.idx[n3] = this.idx[n3] - 1;
            }
            if (this.optHasUserComparators) {
                int n = d;
                this.idx[n] = this.idx[n] + 1;
                for (i = this.userDefinedComparators.length - 1; i >= 0; --i) {
                    if (this.userDefinedComparators[i].compareHit(this.idx, d + 1)) continue;
                    int n4 = d;
                    this.idx[n4] = this.idx[n4] - 1;
                    return false;
                }
                int n5 = d;
                this.idx[n5] = this.idx[n5] - 1;
            }
        }
        return true;
    }

    protected boolean findNextSNforThisQN(int d) {
        boolean inSearch = true;
        while (inSearch) {
            if (this.idx[d] < this.strAtoms) {
                if (this.map.getMap(d, this.idx[d]) && this.isCompatibleIdx(d)) {
                    return true;
                }
                int nextTrue = this.map.getNextTrue(d, this.idx[d] + 1);
                if (nextTrue == -1) {
                    this.idx[d] = this.strAtoms;
                    continue;
                }
                this.idx[d] = nextTrue;
                continue;
            }
            inSearch = false;
        }
        return false;
    }

    protected boolean refine() throws SearchException {
        this.steps += ((this.qryAtoms - this.depth) * this.strAtoms + 250) / 500;
        boolean mapHasChanged = false;
        IntVector queryQueue = new IntVector();
        IntVector targetQueue = new IntVector();
        for (int queryAtomInd = 0; queryAtomInd < this.qryAtoms; ++queryAtomInd) {
            this.foundZeroLineInMap = true;
            int targetAtomInd = this.map.getNextTrue(queryAtomInd, 0);
            while (targetAtomInd < this.strAtoms && targetAtomInd != -1) {
                boolean isZeroed = this.testNode(queryAtomInd, targetAtomInd);
                boolean bl = mapHasChanged = isZeroed || mapHasChanged;
                if (this.foundZeroLineInMap && !isZeroed) {
                    this.foundZeroLineInMap = false;
                }
                targetAtomInd = this.map.getNextTrue(queryAtomInd, targetAtomInd + 1);
            }
            if (!this.foundZeroLineInMap || !this.isZeroLineProhibited) continue;
            return false;
        }
        this.refineForNeighbours(queryQueue, targetQueue);
        mapHasChanged |= this.refineForHomologies();
        return mapHasChanged |= this.refineByMatchers();
    }

    private void refineForNeighbours(IntVector queryQueue, IntVector targetQueue) throws SearchException {
        while (!queryQueue.isEmpty()) {
            boolean isZeroed;
            int targetAtomInd;
            int queryAtomInd = queryQueue.removeLast();
            if (!this.map.getMap(queryAtomInd, targetAtomInd = targetQueue.removeLast()) || !(isZeroed = this.testNode(queryAtomInd, targetAtomInd))) continue;
            this.addNeighbourCartesian(queryAtomInd, targetAtomInd, queryQueue, targetQueue);
        }
    }

    private void addNeighbourCartesian(int queryAtomInd, int targetAtomInd, IntVector queryQueue, IntVector targetQueue) {
        int[] qNeigh;
        int[] tNeigh = this.getNeighbours(targetAtomInd);
        for (int qInd : qNeigh = this.sub.getNeighbours(queryAtomInd)) {
            for (int tInd : tNeigh) {
                queryQueue.add(qInd);
                targetQueue.add(tInd);
            }
        }
    }

    private boolean refineByMatchers() {
        boolean mapHasChanged = false;
        for (MoleculeMatcher matcher : this.moleculeMatchers) {
            mapHasChanged |= matcher.refine();
        }
        return mapHasChanged;
    }

    protected boolean refineForHomologies() throws SearchException {
        return false;
    }

    protected void clearAmbiguousHits() {
    }

    boolean isMappable(int i) {
        for (int q = 0; q < this.sub.matomLength; ++q) {
            if (!this.map.getMap(q, i)) continue;
            return true;
        }
        return false;
    }

    protected final boolean areCompatibleBondsAndMapped(int queryBond, int targetBond) throws SearchException {
        return this.map.getMap(this.sub.bto[queryBond], this.bto[targetBond]) && this.compareBonds(queryBond, targetBond);
    }

    protected boolean testNode(int i, int j) throws SearchException {
        boolean mapHasChanged = false;
        int qi = this.sub.bondidx[i];
        int si = this.bondidx[j];
        int hashCode = this.abonds[j] < 16 ? this.sub.abonds[i] * 16 + this.abonds[j] : -1;
        switch (hashCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
            case 17: {
                if (this.areCompatibleBondsAndMapped(qi, si)) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            case 18: {
                if (this.areCompatibleBondsAndMapped(qi, si) || this.areCompatibleBondsAndMapped(qi, si + 1)) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            case 19: {
                if (this.areCompatibleBondsAndMapped(qi, si) || this.areCompatibleBondsAndMapped(qi, si + 1) || this.areCompatibleBondsAndMapped(qi, si + 2)) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            case 20: {
                if (this.areCompatibleBondsAndMapped(qi, si) || this.areCompatibleBondsAndMapped(qi, si + 1) || this.areCompatibleBondsAndMapped(qi, si + 2) || this.areCompatibleBondsAndMapped(qi, si + 3)) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            case 34: {
                if (this.areCompatibleBondsAndMapped(qi, si) && this.areCompatibleBondsAndMapped(qi + 1, si + 1) && this.areCompatibleAtoms(this.bto[si], this.bto[si + 1]) || this.areCompatibleBondsAndMapped(qi, si + 1) && this.areCompatibleBondsAndMapped(qi + 1, si) && this.areCompatibleAtoms(this.bto[si], this.bto[si + 1])) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            case 35: {
                boolean found = false;
                if (this.areCompatibleBondsAndMapped(qi, si) && (this.areCompatibleBondsAndMapped(qi + 1, si + 1) && this.areCompatibleAtoms(this.bto[si], this.bto[si + 1]) || this.areCompatibleBondsAndMapped(qi + 1, si + 2) && this.areCompatibleAtoms(this.bto[si], this.bto[si + 2]))) {
                    found = true;
                } else if (this.areCompatibleBondsAndMapped(qi, si + 1) && (this.areCompatibleBondsAndMapped(qi + 1, si) && this.areCompatibleAtoms(this.bto[si + 1], this.bto[si]) || this.areCompatibleBondsAndMapped(qi + 1, si + 2) && this.areCompatibleAtoms(this.bto[si + 1], this.bto[si + 2]))) {
                    found = true;
                } else if (this.areCompatibleBondsAndMapped(qi, si + 2) && (this.areCompatibleBondsAndMapped(qi + 1, si) && this.areCompatibleAtoms(this.bto[si + 2], this.bto[si]) || this.areCompatibleBondsAndMapped(qi + 1, si + 1) && this.areCompatibleAtoms(this.bto[si + 2], this.bto[si + 1]))) {
                    found = true;
                }
                if (found) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            default: {
                int m;
                int dep = 0;
                boolean notFinishedBacktrack = true;
                for (m = 0; m < this.sub.indLength; ++m) {
                    this.sub.ind[m] = 0;
                }
                for (m = 0; m < this.usdLength; ++m) {
                    this.usd[m] = false;
                }
                while (notFinishedBacktrack) {
                    if (dep < this.sub.abonds[i]) {
                        boolean found = false;
                        while (!found && this.sub.ind[dep] < this.abonds[j]) {
                            found = !this.usd[this.sub.ind[dep]] && this.areCompatibleBondsAndMapped(qi + dep, si + this.sub.ind[dep]) && this.isCompatibleWithTheRest(dep, si, this.bto[si + this.sub.ind[dep]]);
                            int n = dep;
                            this.sub.ind[n] = this.sub.ind[n] + 1;
                        }
                        if (found) {
                            int n = dep;
                            this.sub.ind[n] = this.sub.ind[n] - 1;
                            this.usd[this.sub.ind[dep]] = true;
                            ++dep;
                            continue;
                        }
                        this.sub.ind[dep] = 0;
                        if (--dep >= 0) {
                            this.usd[this.sub.ind[dep]] = false;
                            int n = dep;
                            this.sub.ind[n] = this.sub.ind[n] + 1;
                            continue;
                        }
                        this.map.clearMap(i, j);
                        mapHasChanged = true;
                        notFinishedBacktrack = false;
                        continue;
                    }
                    notFinishedBacktrack = false;
                }
                break block0;
            }
        }
        return mapHasChanged;
    }

    protected boolean isCompatibleWithTheRest(int dep, int si, int newAtom) {
        return true;
    }

    protected boolean areCompatibleAtoms(int i, int i1) {
        return true;
    }

    protected boolean setChiralNeighbors(int i) {
        int neib;
        int ncq = this.sub.abonds[i];
        int bondIndex = this.sub.bondidx[i];
        if ((this.sub.hasLP || this.hasLP) && this.isLPStereoCentre(i)) {
            try {
                return this.setChiralNeighboursFromMolecule(i);
            }
            catch (ParityCannotBeEvaluatedYetException e) {
                return false;
            }
        }
        for (int k = 0; k < ncq; ++k) {
            neib = this.sub.bto[bondIndex + k];
            if (neib > this.depth || k >= 10) {
                return false;
            }
            this.sub.chneib[k] = this.sub.isPlainH(neib) ? Integer.MAX_VALUE : neib;
            neib = this.idx[neib] - 1;
            this.chneib[k] = this.isPlainH(neib) ? Integer.MAX_VALUE : neib;
        }
        if (ncq == 3) {
            this.sub.chneib[3] = Integer.MAX_VALUE;
            int ncs = this.abonds[this.idx[i] - 1];
            if (ncs == 4) {
                bondIndex = this.bondidx[this.idx[i] - 1];
                for (int k = 0; k < 4; ++k) {
                    neib = this.bto[bondIndex + k];
                    boolean found = false;
                    for (int j = 0; j < 3 && !found; ++j) {
                        found = this.chneib[j] == neib;
                    }
                    if (found) continue;
                    this.chneib[3] = this.isPlainH(neib) ? Integer.MAX_VALUE : neib;
                    break;
                }
            } else {
                this.chneib[3] = Integer.MAX_VALUE;
            }
        }
        return true;
    }

    protected boolean setChiralNeighboursFromMolecule(int i) throws ParityCannotBeEvaluatedYetException {
        MolAtom qca = this.sub.atoms[this.sub.atomIdxInAtomsArray[i]];
        int ncq = this.setQueryChiralNeighboursFromMolecule(this.sub.molecule, qca);
        if (ncq < 3) {
            return false;
        }
        MolAtom tca = this.atoms[this.atomIdxInAtomsArray[this.idx[i] - 1]];
        try {
            int nct = this.setTargetChiralNeighboursFromMolecule(ncq, this.sub.molecule, qca, this.molecule, tca);
            if (nct != 4) {
                return false;
            }
        }
        catch (SearchException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected int setTargetChiralNeighboursFromMolecule(int nqn, Molecule qMol, MolAtom qAtom, Molecule tMol, MolAtom tAtom) throws SearchException, ParityCannotBeEvaluatedYetException {
        for (int i = 0; i < nqn; ++i) {
            if (this.sub.chneib[i] == Integer.MAX_VALUE) {
                this.chneib[i] = Integer.MAX_VALUE;
                continue;
            }
            if (this.sub.chneib[i] == 0x7FFFFFFE) {
                this.chneib[i] = 0x7FFFFFFE;
                continue;
            }
            int qNeighInternalIdx = this.sub.idxAtomInMatomArray[this.sub.chneib[i]];
            if (qNeighInternalIdx < 0) {
                throw new SearchException("Could not assign chiral neighbor: (neighbor " + i + " of query atom " + qMol.indexOf(qAtom) + " is missing.");
            }
            this.chneib[i] = this.atomIdxInAtomsArray[this.idx[qNeighInternalIdx] - 1];
        }
        this.addImplHChiralNeighbours(nqn, tAtom, tMol);
        return 4;
    }

    protected void addImplHChiralNeighbours(int nqn, MolAtom tAtom, MoleculeGraph tMol) throws ParityCannotBeEvaluatedYetException {
        if (nqn == 3) {
            int tBondCount = tAtom.getBondCount();
            if (tBondCount == 3) {
                this.chneib[3] = tAtom.getImplicitHcount() >= 1 ? Integer.MAX_VALUE : 0x7FFFFFFE;
            } else if (tBondCount == 4) {
                for (int k = 0; k < 4; ++k) {
                    MolAtom tna = tAtom.getLigand(k);
                    int neib = tMol.indexOf(tna);
                    boolean found = false;
                    for (int j = 0; j < 3 && !found; ++j) {
                        found = this.chneib[j] == neib;
                    }
                    if (found) continue;
                    this.chneib[3] = MolHandler.isPlainH(tna) ? Integer.MAX_VALUE : (tna.getAtno() == 130 ? 0x7FFFFFFE : neib);
                    break;
                }
            } else {
                throw new ParityCannotBeEvaluatedYetException("" + nqn);
            }
        }
    }

    protected int setQueryChiralNeighboursFromMolecule(Molecule mol, MolAtom atom) {
        int ncq = atom.getBondCount();
        for (int k = 0; k < ncq; ++k) {
            MolAtom qna = atom.getLigand(k);
            int qneib = mol.indexOf(qna);
            int qneibInternal = this.sub.idxAtomInMatomArray[qneib];
            if (qneibInternal > this.depth || k >= 10) {
                return -1;
            }
            this.sub.chneib[k] = MolHandler.isPlainH(qna) ? Integer.MAX_VALUE : (qna.getAtno() == 130 ? 0x7FFFFFFE : qneib);
        }
        if (ncq == 3) {
            this.sub.chneib[3] = Integer.MAX_VALUE;
        }
        return ncq;
    }

    private int findLPNeighbor(MolAtom ma) {
        int bondCount = ma.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            MolAtom n = ma.getLigand(i);
            if (n.getAtno() != 130) continue;
            return this.molecule.indexOf(n);
        }
        return -1;
    }

    private boolean isLPStereoCentre(int i) {
        int j = this.idx[i] - 1;
        if (this.sub.lPCount == null || this.sub.lPCount[i] == 0 || this.lPCount == null || this.lPCount[j] == 0) {
            return false;
        }
        MolAtom qma = this.sub.atoms[this.sub.atomIdxInAtomsArray[i]];
        MolAtom tma = this.atoms[this.atomIdxInAtomsArray[j]];
        return this.sub.hasXLP(qma) || this.hasXLP(tma);
    }

    private boolean hasXLP(MolAtom ma) {
        return this.findLPNeighbor(ma) != -1;
    }

    final boolean isPlainH(int i) {
        return this.matom[i] == 1 && this.isotope[i] == 0 && this.acharge[i] == 0;
    }

    private boolean testChirality() throws SearchException {
        int i;
        if (!this.optIsExactStereoMatching && !this.sub.hasAtomStereo || !this.isTetrahedralStereoSearch) {
            return true;
        }
        for (i = 0; i < this.qryAtoms; ++i) {
            if (this.compareChiralities(i, this.idx[i] - 1)) continue;
            return false;
        }
        if (this.sub.smartsAtomTrees != null && this.needToRepeatChiralCheck) {
            for (i = 0; i < this.qryAtoms; ++i) {
                if (this.sub.smartsAtomTrees[this.sub.atomIdxInAtomsArray[i]] == null || SmartsAtomMatcher.evaluateSmartsAtomTree(this.sub, this.sub.smartsAtomTrees[this.sub.atomIdxInAtomsArray[i]], i, this, this.idx[i] - 1)) continue;
                return false;
            }
        }
        return true;
    }

    boolean isNewOrderedHit(ArrayList<SearchHit> list, SearchHit searchHit) {
        if (!this.searchOptions.isOrderSensitiveSearch() || !this.sub.hasExplicitHydrogen || this.atomsLength == this.matomLength) {
            return true;
        }
        int[] actHit = searchHit.getSingleHit();
        for (int i = 0; i < list.size(); ++i) {
            boolean sameAsThisHit = true;
            int[] listElem = list.get(i).getSingleHit();
            for (int j = 0; j < actHit.length; ++j) {
                if (actHit[j] == listElem[j]) continue;
                sameAsThisHit = false;
                break;
            }
            if (!sameAsThisHit) continue;
            return false;
        }
        return true;
    }

    boolean isNewHitIgnoreOrder(ArrayList<SearchHit> list, SearchHit searchHit) {
        int[] actHit = searchHit.getSingleHit();
        for (int i = 0; i < list.size(); ++i) {
            int[] listElem = list.get(i).getSingleHit();
            boolean sameAsThisHit = true;
            for (int j = 0; j < actHit.length; ++j) {
                if (ArrayTools.foundInArray(listElem, actHit[j]) && ArrayTools.foundInArray(actHit, listElem[j])) continue;
                sameAsThisHit = false;
                break;
            }
            if (!sameAsThisHit) continue;
            return false;
        }
        return true;
    }

    protected boolean preCheck() {
        if (this.sub.initMode == 0 && !this.sub.hasSpecialHToHandle && this.initMode == 0 && !this.hasSpecialHToHandle || this.sub.initMode == 2 && this.initMode == 2) {
            String inputFormat = this.getQuery().getInputFormat();
            if (inputFormat == null || inputFormat.equals("cxsmarts")) {
                inputFormat = "smarts";
            }
            if (!(this.searchOptions.isSubgraphSearch() || this.isMarkushSearch || this.optRadicalMatching != 1 || inputFormat.equals("smarts") || this.strAtoms == this.qryAtoms && this.btoLength == this.sub.btoLength)) {
                logger.fine("atom or bond length mismatch");
                return false;
            }
            if (this.chiralityInitialized && this.sub.chiralityInitialized && this.sub.hasSpecificAtomStereo && !this.hasSpecificAtomStereo && this.searchOptions.getStereoModel() != 1 && !this.hasMultiValent) {
                logger.fine("hasSpecificAtomStereo mismatch");
                return false;
            }
            if (this.chiralityInitialized && this.sub.chiralityInitialized && this.searchOptions.getStereoModel() != 1 && this.searchOptions.getStereoSearchType() == 2 && !this.hasMultiValent) {
                if (this.sub.hasAtomStereo && !this.hasAtomStereo) {
                    logger.fine("hasAtomStereo mismatch - chirality");
                    return false;
                }
                if ((this.searchOptions.getSearchType() == 4 || this.searchOptions.getSearchType() == 5) && this.sub.hasAtomStereo != this.hasAtomStereo) {
                    logger.fine("hasAtomStereo mismatch - full or duplicate search");
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected SearchHit findFirstHit() throws SearchException {
        this.stopping = false;
        return this.findFirst0();
    }

    protected SearchHit findFirst0() throws SearchException {
        if (!this.statCheck()) {
            logger.fine("statCheck() failed.");
            this.clearHits();
            return null;
        }
        this.initSearch();
        this.strAtoms = this.matomLength;
        this.qryAtoms = this.sub.matomLength;
        if (this.qryAtoms == 0) {
            if (this.searchOptions.getSearchType() == 5) {
                return null;
            }
            if (this.searchOptions.getSearchType() == 4) {
                if (this.strAtoms == 0) {
                    return new SearchHit(new int[0]);
                }
                return null;
            }
            return new SearchHit(new int[0]);
        }
        if (!this.preCheck()) {
            logger.fine("preCheck() failed.");
            return null;
        }
        this.depth = 0;
        this.initMaps();
        if (this.foundZeroLineInMap && this.isZeroLineProhibited) {
            this.pushMap(this.depth);
            return null;
        }
        return this.findNext0();
    }

    protected boolean statCheck() {
        if (this.skipBecausePolymers()) {
            return true;
        }
        if (this.sub.stat_atomTypeCountsLength == 0) {
            this.sub.initStats();
        }
        if (this.stat_atomTypeCountsLength == 0) {
            this.initStats();
        }
        if (this.searchOptions.isPerfectSearchType()) {
            int i;
            for (i = 1; i <= this.sub.stat_atomTypeCountsLength; ++i) {
                if (this.sub.stat_atomTypeCounts[i] == this.stat_atomTypeCounts[i]) continue;
                return false;
            }
            for (i = 1; i <= 4; ++i) {
                if (this.sub.stat_bondTypeCounts[i] == this.stat_bondTypeCounts[i]) continue;
                return false;
            }
        } else {
            for (int i = 1; i <= this.sub.stat_atomTypeCountsLength; ++i) {
                if (this.sub.stat_atomTypeCounts[i] <= this.stat_atomTypeCounts[i]) continue;
                return false;
            }
            if (!this.statBondCheck()) {
                return false;
            }
        }
        return true;
    }

    private boolean skipBecausePolymers() {
        boolean qPoly = PolymerUtil.hasPolymerSgroup(this.sub.molecule);
        boolean tPoly = PolymerUtil.hasPolymerSgroup(this.molecule);
        return !(this.searchOptions.isEndgroupMatching() && !this.searchOptions.areMonomersTransformed() || !qPoly && !tPoly);
    }

    protected boolean statBondCheck() {
        boolean r = true;
        for (int i = 1; i <= 4; ++i) {
            if (this.sub.stat_bondTypeCounts[i] <= this.stat_bondTypeCounts[i]) continue;
            r = false;
        }
        return r;
    }

    private final void initStats() {
        this.stat_atomTypeCounts = ArrayTools.initArrayAndFill(this.stat_atomTypeCounts, 109, 0);
        this.stat_atomTypeCountsLength = 0;
        this.stat_bondTypeCounts = ArrayTools.initArrayAndFill(this.stat_bondTypeCounts, 5, 0);
        int ac = this.molecule.getAtomCount();
        for (int atomIdx = 0; atomIdx < ac; ++atomIdx) {
            MolAtom atom = this.molecule.getAtom(atomIdx);
            int atomType = atom.getAtno();
            if (1 >= atomType || atomType >= 109) continue;
            int n = atomType;
            this.stat_atomTypeCounts[n] = this.stat_atomTypeCounts[n] + 1;
            if (this.stat_atomTypeCountsLength >= atomType) continue;
            this.stat_atomTypeCountsLength = atomType;
        }
        int bondCount = this.molecule.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            MolBond bond = this.molecule.getBond(i);
            int bt = bond.getType();
            if (1 > bt || bt > 4) continue;
            int at1 = bond.getAtom1().getAtno();
            int at2 = bond.getAtom2().getAtno();
            if (1 >= at1 || at1 >= 109 || 1 >= at2 || at2 >= 109) continue;
            int n = bt;
            this.stat_bondTypeCounts[n] = this.stat_bondTypeCounts[n] + 1;
        }
    }

    @Override
    protected SearchHit findNextHit() throws SearchException {
        this.stopping = false;
        this.initRecursiveSMARTS();
        return this.findNext0();
    }

    private void initRecursiveSMARTS() throws SearchException {
        if (!this.searchOptions.isDistinctFirstAtomMatching()) {
            return;
        }
        for (int i = this.depth; i > 0; --i) {
            this.idx[this.depth] = 0;
            --this.depth;
            this.popMap(this.depth);
        }
    }

    private SearchHit findNext0() throws SearchException {
        long startTime = System.currentTimeMillis();
        if (!this.sub.initialized || !this.initialized || this.searchOptions.isDirty()) {
            return this.findFirst0();
        }
        if (this.qryAtoms == 0) {
            return null;
        }
        SearchHit actHit = null;
        boolean finished = false;
        this.steps = -1;
        if (this.depth < 0) {
            return actHit;
        }
        int exhaustiveModeLimit = this.searchOptions.getExhaustiveModeLimit();
        int timeoutLimitSteps = this.searchOptions.getTimeoutLimit();
        while (actHit == null && !finished) {
            ++this.steps;
            boolean stepBack = false;
            if (this.stopping) {
                return null;
            }
            if (this.steps >= exhaustiveModeLimit && this.isFastSearch && exhaustiveModeLimit != -1) {
                if (this.searchOptions.verbose) {
                    System.err.println("StructureSearch.findNext(): switching to exhaustive mode at step " + this.steps + ".");
                }
                if (!this.switchToExhaustiveMode()) {
                    return null;
                }
            } else if (this.steps > timeoutLimitSteps && timeoutLimitSteps != -1 || this.isTimeoutMSReached(startTime, this.steps)) {
                String message = this.isTimeoutMSReached(startTime, this.steps) ? "Search.findNext(): Timed out at " + this.searchOptions.getTimeoutLimitMilliseconds() + " milliseconds." : "Search.findNext(): Timed out at step " + this.steps + ".";
                this.logException(logger, message);
                if (!this.searchOptions.isThrowExceptionOnTimeout()) break;
                String queryShortString = StructureSearch.getShortString(this.molecule, true);
                String targetShortString = StructureSearch.getShortString(this.sub.molecule, false);
                String exceptionMessage = message + "\nQuery:" + queryShortString + "\n  Target:" + targetShortString;
                throw new SearchTimeoutException(exceptionMessage);
            }
            if (this.depth < this.qryAtoms) {
                if (this.findNextSNforThisQN(this.depth)) {
                    this.addToHit(this.depth, this.idx[this.depth]);
                    this.clearRowColumn(this.depth, this.idx[this.depth]);
                    int n = this.depth++;
                    this.idx[n] = this.idx[n] + 1;
                    if (this.depth < this.qryAtoms) {
                        while (this.refine()) {
                        }
                        if (logger.isLoggable(Level.FINEST)) {
                            this.printMap(logger);
                        }
                        if (this.foundZeroLineInMap && this.isZeroLineProhibited) {
                            stepBack = true;
                        }
                        if (!stepBack) {
                            this.pushMap(this.depth);
                        }
                    }
                } else {
                    stepBack = true;
                }
            } else {
                boolean changed = false;
                this.foundZeroLineInMap = false;
                logger.fine("Checking the hit.");
                changed |= this.refineForHomologies();
                if (!((changed |= this.refine()) || this.foundZeroLineInMap || this.isTetrahedralStereoSearch && (this.hasAtomStereo && this.sub.hasAtomStereo || this.sub.smartsAtomTrees != null) && !this.testChirality())) {
                    int[] singleHit = new int[this.qryAtoms];
                    for (int i = 0; i < singleHit.length; ++i) {
                        singleHit[i] = this.idx[i] - 1;
                    }
                    actHit = new SearchHit(singleHit);
                    if (!this.isValidHitInner(actHit)) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("\nHit candidate dropped by isValidHitInner (0-based): " + Dumper.dumpIntArray(actHit.getSingleHit()) + "\n");
                        }
                        actHit = null;
                    }
                    if (this.isHitArrayNeeded && actHit != null) {
                        actHit = this.restoreHitIndexes(actHit);
                        actHit = this.restoreRearrangedHitIndices(actHit);
                        actHit.setSingleHit(this.restorePolymerTransformation(actHit.getSingleHit()));
                        if (this.isValidHit(actHit)) {
                            this.storeHit(actHit);
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("\nHit found (0-based): " + Dumper.dumpIntArray(actHit.getSingleHit()) + "\n");
                            }
                        } else {
                            actHit = null;
                        }
                    }
                }
                --this.depth;
                this.popMap(this.depth);
                if (this.depth >= 0) {
                    this.removeFromHit(this.depth, this.idx[this.depth] - 1, actHit != null);
                }
            }
            if (!stepBack) continue;
            do {
                this.idx[this.depth] = 0;
                --this.depth;
                if (this.depth < 0) {
                    finished = true;
                    continue;
                }
                this.popMap(this.depth);
                if (this.depth < 0) continue;
                this.removeFromHit(this.depth, this.idx[this.depth] - 1, false);
            } while (this.depth > this.sub.atomsLength && this.sub.matom[this.depth] == 1);
        }
        return actHit;
    }

    private boolean isTimeoutMSReached(long startTime, int steps2) {
        int stepLimitForTimeoutCheck = 10;
        if (steps2 % stepLimitForTimeoutCheck == 0) {
            int timeoutLimitMilliseconds = this.searchOptions.getTimeoutLimitMilliseconds();
            return timeoutLimitMilliseconds != -1 && System.currentTimeMillis() - startTime > (long)timeoutLimitMilliseconds;
        }
        return false;
    }

    private void storeHit(SearchHit actHit) {
        SearchHit clone = new SearchHit(actHit.getSingleHit(), actHit.getGroupHit());
        this.hits.add(clone);
    }

    protected void removeFromHit(int q, int t, boolean afterHit) {
        logger.fine("Removed from hit: q-" + (q + 1) + "  t-" + (t + 1));
    }

    protected void addToHit(int q, int t) {
        logger.fine("Added to hit: q-" + (q + 1) + "  t-" + (t + 1));
    }

    final void pushMap(int depth) {
        this.map.pushMap(depth);
    }

    private final void popMap(int depth) throws SearchException {
        this.map.popMap(depth);
    }

    private boolean switchToExhaustiveMode() throws SearchException {
        this.isFastSearch = false;
        this.sub.isFastSearch = false;
        this.sub.calculateComponents();
        this.calculateComponents();
        if (this.depth == this.qryAtoms) {
            int n = --this.depth;
            this.idx[n] = this.idx[n] - 1;
        }
        int i = 0;
        while (i < this.depth) {
            int oldDepth = this.depth;
            this.depth = i;
            int n = i;
            this.idx[n] = this.idx[n] - 1;
            boolean isWrong = !this.isCompatibleIdx(i);
            int n2 = i++;
            this.idx[n2] = this.idx[n2] + 1;
            this.depth = oldDepth;
            if (!isWrong) continue;
            oldDepth = this.depth;
            int n3 = this.depth = i;
            this.idx[n3] = this.idx[n3] - 1;
            for (int j = this.depth + 1; j < oldDepth; ++j) {
                this.idx[j] = 0;
            }
            this.popMap(this.depth);
            break;
        }
        for (int j = 0; j < this.depth; ++j) {
            this.clearRowColumn(j, this.idx[j] - 1);
        }
        this.clearRowColumn(this.depth, this.idx[this.depth]);
        return true;
    }

    @Override
    protected SearchHit[] findAllHits() throws SearchException {
        this.stopping = false;
        SearchHit hit = this.findFirst0();
        if (hit == null) {
            return null;
        }
        while (hit != null) {
            hit = this.findNext0();
        }
        if (this.stopping) {
            return null;
        }
        SearchHit[] hitsArray = null;
        if (this.hits.size() > 0) {
            hitsArray = new SearchHit[this.hits.size()];
            for (int i = 0; i < hitsArray.length; ++i) {
                hitsArray[i] = this.hits.get(i);
            }
        }
        return hitsArray;
    }

    static boolean isHydrogen(int a, Molecule m) {
        if (a > m.getAtomCount() || a < 0) {
            return false;
        }
        return m.getAtom(a).getAtno() == 1;
    }

    protected boolean isValidHit(SearchHit actHit) throws SearchException {
        if (!this.searchOptions.isOrderSensitiveSearch() && !this.isNewHitIgnoreOrder(this.hits, actHit)) {
            return false;
        }
        return this.isNewOrderedHit(this.hits, actHit);
    }

    protected boolean isValidHitInner(SearchHit searchHit) throws SearchException {
        int i;
        int[] hit = searchHit.getSingleHit();
        if (!this.searchOptions.isSubgraphSearch()) {
            for (i = 0; i < this.matomLength; ++i) {
                if (this.matom[i] == 1 || ArrayTools.foundInArray(hit, i)) continue;
                return false;
            }
        }
        for (i = 0; i < this.sub.matomLength; ++i) {
            if (this.checkSasDrawnQProp(i, hit[i])) continue;
            return false;
        }
        return true;
    }

    private boolean checkSasDrawnQProp(int q, int t) {
        int[] tNeigh;
        if (this.sub.substCountLength < 1) {
            return true;
        }
        if (this.sub.substCount[q] < 1000000) {
            return true;
        }
        int canBeH = (this.sub.substCount[q] - 1000000) % 1000;
        if (canBeH < 1) {
            return true;
        }
        int[] qNeigh = this.sub.getNeighbours(q);
        block0: for (int tn : tNeigh = this.getNeighbours(t)) {
            if (this.atomIdxInAtomsArray[tn] < 0 || this.matom[tn] == 1 && this.atoms[this.atomIdxInAtomsArray[tn]].getMassno() == 0) continue;
            for (int qn : qNeigh) {
                if (this.map.getMap(qn, tn)) continue block0;
            }
            return false;
        }
        return true;
    }

    public int[] getNeighbours(int a) {
        int bondOffset;
        StructureSearch searcher = this;
        int bondNum = searcher.abonds[a];
        int[] ret = new int[bondNum];
        for (int bondInd = bondOffset = searcher.bondidx[a]; bondInd < bondOffset + bondNum; ++bondInd) {
            ret[bondInd - bondOffset] = searcher.bto[bondInd];
        }
        return ret;
    }

    @Override
    public boolean isMatching() throws SearchException {
        this.stopping = false;
        return this.isMatching0();
    }

    private boolean isMatching0() throws SearchException {
        this.isHitArrayNeeded = false;
        boolean result = this.findFirst0() != null;
        this.isHitArrayNeeded = true;
        return result;
    }

    protected void calculateComponents() {
        if (this.isFastSearch || this.isComponentInitialized) {
            return;
        }
        int startingAtom = 0;
        int actualComponent = 0;
        this.component = ArrayTools.initArrayAndFill(this.component, this.matomLength, -1);
        this.isComponentInitialized = true;
        if (!this._IAmTheQuery) {
            for (int a = 0; a < this.matomLength; ++a) {
                boolean zeroCol = true;
                for (int i = 0; i < this.sub.matomLength; ++i) {
                    if (!this.map.getMap(i, a)) continue;
                    zeroCol = false;
                    break;
                }
                if (!zeroCol) continue;
                this.component[a] = -2;
            }
        }
        while (startingAtom < this.matomLength) {
            while (startingAtom < this.matomLength && this.component[startingAtom] != -1) {
                ++startingAtom;
            }
            if (startingAtom >= this.matomLength) break;
            this.calculateComponentsSearch(startingAtom, actualComponent);
            ++actualComponent;
        }
    }

    protected void calculateComponentsSearch(int atom, int actualComponent) {
        if (this.component[atom] != -1) {
            return;
        }
        this.component[atom] = actualComponent;
        for (int i = 0; i < this.abonds[atom]; ++i) {
            this.calculateComponentsSearch(this.bto[this.bondidx[atom] + i], actualComponent);
        }
    }

    protected void initQuery() throws SearchException {
        this.sub.initAtoms();
    }

    protected void initTarget() throws SearchException {
        this.initAtoms();
    }

    @Override
    Hashtable<String, Boolean> getStereoMatchingDirections(int[] hit) {
        Hashtable<String, Boolean> ht = new Hashtable<String, Boolean>();
        for (int i = 0; i < this.getQuery().getAtomCount(); ++i) {
            boolean isFwdMatching;
            String key;
            int esgt = this.sub.atoms[i].getStereoGroupType();
            if (esgt == 3) {
                key = "&" + this.sub.atoms[i].getStereoGroupNumber();
            } else if (esgt == 2) {
                key = "|" + this.sub.atoms[i].getStereoGroupNumber();
            } else {
                if (!this.sub.hasAtomStereo || this.sub.atomStereo[i] == 0 || this.sub.atomStereo[i] == 64 || esgt == 1 || esgt == 0 && (this.searchOptions.isQueryAbsoluteStereo() || this.getQuery().isAbsStereo())) continue;
                key = "rel";
            }
            if (ht.containsKey(key)) continue;
            try {
                isFwdMatching = this.sub.parity == null || this.parity == null ? true : this.sub.parity[i] == this.parity[hit[i]] == this.equalParities(i, hit[i]);
            }
            catch (ParityCannotBeEvaluatedYetException e) {
                isFwdMatching = true;
            }
            ht.put(key, isFwdMatching);
        }
        return ht;
    }

    public boolean isFastSearch() {
        return this.isFastSearch;
    }

    public void setFastSearch(boolean fastSearch) {
        this.isFastSearch = fastSearch;
    }

    protected boolean isMultivalent(int targetAtom, boolean isTetrahedral) {
        int bNum = this.abonds[targetAtom];
        return isTetrahedral ? bNum > 4 : (bNum += this.hcountLength > targetAtom ? this.hcount[targetAtom] : 0) > 3;
    }

    protected int[][] getSSR() {
        switch (this.searchOptions.getSSRType()) {
            case CSSR: {
                return this.molecule.getCSSR();
            }
            case SSSR: {
                return this.molecule.getSSSR();
            }
        }
        return this.molecule.getSSSR();
    }

    protected boolean isRingCountOk(int queryAtom, int targetAtom) {
        return this.sub.ringCount[queryAtom] == this.ringCount[targetAtom];
    }

    protected boolean isSmallestRingSizeOk(int queryAtom, int targetAtom) {
        return this.sub.smallestRingSize[queryAtom] == -1 || this.sub.smallestRingSize[queryAtom] == this.smallestRingSize[targetAtom];
    }

    private int modifyHCountWithExplicitH(MolAtom atom, int qProp) {
        int hCount;
        if (!this._IAmTheQuery || !this.convertExplHToHCount) {
            return qProp;
        }
        int atno = atom.getAtno();
        if (atno != 137 && atno != 138 && (hCount = atom.getExplicitHcount()) > 0) {
            if (qProp != -1) {
                if (qProp == 0) {
                    atom.putProperty("origH0", "1");
                }
                if (!MolHandler.isDaylightFormat(this.molecule.getInputFormat())) {
                    return hCount + qProp;
                }
            } else {
                atom.putProperty("origHmissing", "1");
                return hCount;
            }
        }
        return qProp;
    }

    static {
        StringTokenizer st = new StringTokenizer("AH G1 G2 G3 G4 G5 G6 G7 G8 G9 G10 G11 G12 G13 G14 G15 G16 G17 G18 QH M MH X XH");
        int i = 0;
        while (st.hasMoreElements()) {
            SPECIAL_PSEUDO_INDEXES.put(st.nextToken(), new Integer(i++));
        }
    }

    protected class ParityCannotBeEvaluatedYetException
    extends Exception {
        ParityCannotBeEvaluatedYetException() {
        }

        ParityCannotBeEvaluatedYetException(String message) {
            super(message);
        }
    }
}

