/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.enumeration.bracket.PolymerUtil;
import chemaxon.marvin.calculations.TautomerizationPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;

public class TautomerUtil {
    public static boolean isTautomerizable(TautomerizationPlugin tautomerizationPlugin, Molecule mol) {
        if (PolymerUtil.hasPolymerSgroup(mol)) {
            return false;
        }
        try {
            tautomerizationPlugin.checkMolecule(mol);
            return true;
        }
        catch (PluginException e) {
            return false;
        }
    }

    public static Molecule createGenericTautomer(Molecule mol, boolean protectChirality, boolean switchOffAllProtectsForTDF, boolean ignoreIsotopeMatching) throws PluginException {
        TautomerizationPlugin tautomerizationPlugin = new TautomerizationPlugin();
        tautomerizationPlugin.setLicenseEnvironment("LicenseEnvironmentForFreeIsomersInternalUsage");
        tautomerizationPlugin.setTakeGenericTautomer(true);
        if (switchOffAllProtectsForTDF) {
            TautomerUtil.switchOffAllProtects(tautomerizationPlugin);
        } else {
            tautomerizationPlugin.setProtectAllTetrahedralStereoCenters(protectChirality);
        }
        tautomerizationPlugin.setMolecule(mol);
        if (!TautomerUtil.isTautomerizable(tautomerizationPlugin, mol)) {
            return mol;
        }
        tautomerizationPlugin.run();
        Molecule genericTautomer = tautomerizationPlugin.getStructure(0);
        if (ignoreIsotopeMatching) {
            TautomerUtil.removeIsotopeInfoFromGenericTautomer(genericTautomer);
        }
        return genericTautomer;
    }

    public static void switchOffAllProtects(TautomerizationPlugin tautomerizationPlugin) {
        tautomerizationPlugin.setProtectAllTetrahedralStereoCenters(false);
        tautomerizationPlugin.setProtectAromaticity(false);
        tautomerizationPlugin.setProtectCharge(false);
        tautomerizationPlugin.setProtectDoubleBondStereo(false);
        tautomerizationPlugin.setProtectEsterGroups(false);
        tautomerizationPlugin.setProtectLabeledTetrahedralStereoCenters(false);
    }

    public static void removeIsotopeInfoFromGenericTautomer(Molecule mol) {
        int sgc = mol.getSgroupCount();
        for (int i = 0; i < sgc; ++i) {
            Sgroup sg = mol.getSgroup(i);
            if (sg.getType() != 10 || !((DataSgroup)sg).getFieldName().equals("BEC")) continue;
            String[] value = ((DataSgroup)sg).getData().split("e");
            ((DataSgroup)sg).setData(value[0]);
        }
    }
}

