/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.BondClassifier;
import chemaxon.core.util.BondTable;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.StandardizedMolSearch;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.util.ShortestPath;

public class TemplateBasedClean {
    private static final int STEREO1_MASK = 48;
    private MolSearch[] searchers = null;
    private Molecule[] queries = null;
    private ShortestPath sp = null;
    private ShortestPath[] sps = null;
    private int[] path = null;
    private BondClassifier[] analysers = null;
    private BondClassifier analyser = null;

    public TemplateBasedClean(Molecule template) {
        this(new Molecule[]{template});
    }

    public TemplateBasedClean(Molecule[] templates) {
        this.searchers = new MolSearch[templates.length];
        MolSearchOptions mso = new MolSearchOptions(2);
        mso.setIgnoreTetrahedralStereo(true);
        mso.setHitIncludesRNodes(true);
        for (int i = 0; i < templates.length; ++i) {
            this.searchers[i] = new StandardizedMolSearch();
            this.searchers[i].setSearchOptions(mso);
            if (templates[i].getDim() != 2) {
                templates[i] = (Molecule)templates[i].clone();
                templates[i].clean(2, null);
            }
            this.searchers[i].setQuery(templates[i]);
        }
        this.queries = templates;
        this.setCleanTargetRings(true);
        this.setShortestPathCheck(true);
    }

    public void setCleanTargetRings(boolean cleanTargetRings) {
        if (cleanTargetRings) {
            this.analyser = new BondClassifier();
            this.analysers = new BondClassifier[this.queries.length];
            for (int i = 0; i < this.queries.length; ++i) {
                this.analysers[i] = new BondClassifier();
                this.analysers[i].classify(this.queries[i]);
            }
        } else {
            this.analyser = null;
            this.analysers = null;
        }
    }

    public void setShortestPathCheck(boolean shortestPathCheck) {
        if (shortestPathCheck) {
            this.sp = new ShortestPath();
            this.sps = new ShortestPath[this.queries.length];
            for (int i = 0; i < this.queries.length; ++i) {
                this.sps[i] = new ShortestPath();
                this.sps[i].calculate(this.queries[i]);
            }
        } else {
            this.sp = null;
            this.sps = null;
        }
    }

    public int[] clean(Molecule target) throws SearchException {
        int[] hit;
        if (this.sp != null) {
            this.sp.calculate(target);
        }
        if ((hit = this.clean(target, this.analyser)) == null && this.analyser != null) {
            hit = this.clean(target, null);
        }
        return hit;
    }

    private int[] clean(Molecule target, BondClassifier tanalyser) throws SearchException {
        for (int i = 0; i < this.searchers.length; ++i) {
            this.searchers[i].setTarget(target);
            int[] hit = null;
            while ((hit = this.searchers[i].findNext()) != null) {
                BondClassifier qanalyser;
                if (this.sp != null && !this.check(target, this.sps[i], hit) || !this.clean(target, this.queries[i], qanalyser = tanalyser != null ? this.analysers[i] : null, tanalyser, hit)) continue;
                return hit;
            }
        }
        return null;
    }

    private boolean check(Molecule target, ShortestPath qsp, int[] hit) {
        for (int i = 1; i < hit.length; ++i) {
            if (hit[i] < 0) continue;
            for (int j = 0; j < i; ++j) {
                if (hit[j] < 0) continue;
                int queryDist = qsp.minDist(i, j);
                int targetDist = this.sp.minDist(hit[i], hit[j]);
                if (targetDist < queryDist) {
                    return false;
                }
                if (targetDist != queryDist) continue;
                if (this.path == null || this.path.length < targetDist + 1) {
                    this.path = new int[targetDist + 1];
                }
                this.sp.getPath(hit[i], hit[j], this.path);
                for (int k = targetDist - 1; k >= 1; --k) {
                    if (TemplateBasedClean.contains(hit, this.path[k])) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean clean(Molecule target, Molecule query, BondClassifier qanalyser, BondClassifier tanalyser, int[] hit) {
        MolBond b;
        int i;
        int i2;
        if (tanalyser != null) {
            tanalyser.classify(target);
        }
        int[] parities = new int[target.getAtomCount()];
        for (i2 = 0; i2 < parities.length; ++i2) {
            parities[i2] = target.getParity(i2);
        }
        for (i2 = target.getBondCount() - 1; i2 >= 0; --i2) {
            MolBond b2 = target.getBond(i2);
            MolAtom a1 = b2.getCTAtom1();
            MolAtom a4 = b2.getCTAtom4();
            if (a1 == null || a4 == null) continue;
            int s = target.getStereo2(b2, a1, a4, false);
            b2.setFlags(s, 448);
        }
        IntVector fixed = new IntVector();
        IntVector hitsCorrectedWithAddedH = new IntVector();
        boolean expHAdded = false;
        for (int i3 = 0; i3 < hit.length; ++i3) {
            MolAtom qatom;
            int hitIdx = hit[i3];
            if (hitIdx >= 0) {
                if (tanalyser == null || qanalyser.isRingAtom(i3) || !tanalyser.isRingAtom(hitIdx)) {
                    qatom = query.getAtom(i3);
                    target.getAtom(hitIdx).setXY(qatom.getX(), qatom.getY());
                    fixed.addElement(hitIdx);
                }
            } else {
                MolAtom tatom;
                qatom = query.getAtom(i3);
                MolBond qbond = qatom.getBond(0);
                int n = query.indexOf(qatom.getLigand(0));
                int targetIdx = -1;
                if (n >= 0) {
                    targetIdx = hit[n];
                }
                if (targetIdx >= 0 && (tatom = target.getAtom(targetIdx)).getImplicitHcount() > 0) {
                    expHAdded = true;
                    MolAtom H = new MolAtom(1, qatom.getX(), qatom.getY(), 0.0);
                    target.add(H);
                    MolBond b3 = qbond.getAtom1() == qatom ? new MolBond(H, tatom, qbond.getFlags()) : new MolBond(tatom, H, qbond.getFlags());
                    target.add(b3);
                    hitIdx = target.indexOf(H);
                    fixed.addElement(hitIdx);
                }
            }
            hitsCorrectedWithAddedH.addElement(hitIdx);
        }
        if (expHAdded) {
            int[] tmp = new int[hitsCorrectedWithAddedH.size()];
            hitsCorrectedWithAddedH.copyInto(tmp);
            hit = tmp;
            tmp = new int[target.getAtomCount()];
            System.arraycopy(parities, 0, tmp, 0, parities.length);
            parities = tmp;
        }
        boolean queryHasWedge = false;
        for (i = 0; i < query.getBondCount() && !queryHasWedge; ++i) {
            b = query.getBond(i);
            queryHasWedge = (b.getFlags() & 0x30) != 0;
        }
        if (queryHasWedge) {
            for (i = 0; i < target.getBondCount(); ++i) {
                b = target.getBond(i);
                b.setFlags(0, 48);
            }
        }
        boolean success = target.partialClean(2, fixed.toArray(), "p");
        if (queryHasWedge && query.getDim() == 2) {
            BondTable targetBtab = null;
            int bc = query.getBondCount();
            for (int i4 = 0; i4 < bc; ++i4) {
                MolBond tb;
                MolBond b4 = query.getBond(i4);
                if ((b4.getFlags() & 0x30) == 0) continue;
                MolAtom a1 = b4.getAtom1();
                MolAtom a2 = b4.getAtom2();
                int i1 = query.indexOf(a1);
                int i22 = query.indexOf(a2);
                int ti1 = hit[i1];
                int ti2 = hit[i22];
                if (ti1 < 0 || ti2 < 0) continue;
                if (targetBtab == null) {
                    targetBtab = target.getBondTable();
                }
                if (target.indexOf((tb = target.getBond(targetBtab.getBondIndex(ti1, ti2))).getAtom1()) != ti1) {
                    tb.swap();
                }
                tb.setFlags(b4.getFlags() & 0x30, 48);
            }
        }
        if (!target.setParity(parities)) {
            System.err.println("Warning: Partial parity information is applied.");
        }
        return success;
    }

    private static boolean contains(int[] array, int element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return true;
        }
        return false;
    }
}

