/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.enumeration.ExpansionUtil;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.Search;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.ratom.HeavyMatchFirstSorter;
import chemaxon.sss.search.ratom.QueryModifier;
import chemaxon.struc.Molecule;

public class UndefinedRAtomSearch
extends Search {
    private MolSearch molSearch = new MolSearch();
    private QueryModifier queryModifier = new QueryModifier();
    private HeavyMatchFirstSorter groupHitStore = new HeavyMatchFirstSorter();
    private boolean first = true;
    private Molecule query = null;
    private int[] exclude = null;

    public UndefinedRAtomSearch() {
        this.setOrdering();
        this.setModifiedOptions();
    }

    public void setKeepGroupOrder(boolean keepGroupOrder) {
        this.queryModifier.setKeepGroupOrder(keepGroupOrder);
    }

    private void setOrdering() {
        this.groupHitStore.setOrdering(this.searchOptions.getHitOrdering() == 1 && this.searchOptions.getUndefinedRAtom() != 2);
    }

    private void setModifiedOptions() {
        SearchOptions modifiedOptions = new SearchOptions(2);
        this.searchOptions.clonecopyOptions(modifiedOptions);
        modifiedOptions.setSubgraphSearch(true);
        modifiedOptions.setOrderSensitiveSearch(true);
        modifiedOptions.setSuperstructureSearch(false);
        this.molSearch.setSearchOptions(modifiedOptions);
        this.molSearch.getSearchOptions().setMarkushEnabled(true);
        this.queryModifier.setSearchOptions(modifiedOptions, this.searchOptions.getSearchType() == 4);
    }

    @Override
    public void setTarget(Molecule mol) {
        this.setTarget(mol, null);
    }

    @Override
    public void setTarget(Molecule mol, int[] exclude) {
        if (ExpansionUtil.containsMulticenter(mol)) {
            throw new IllegalArgumentException("Query with undefined R-atom and target with multicenter is not allowed.");
        }
        this.molSearch.setTarget(mol, exclude);
        this.queryModifier.setTarget(mol, exclude);
        this.groupHitStore.setTarget(mol);
        this.first = true;
    }

    @Override
    public Molecule getTarget() {
        return this.molSearch.getTarget();
    }

    @Override
    public void setQuery(Molecule mol) {
        this.setQuery(mol, null);
    }

    @Override
    public void setQuery(Molecule mol, int[] exclude) {
        this.query = mol;
        this.exclude = exclude;
        this.groupHitStore.setQuery(mol, exclude);
        this.first = true;
    }

    @Override
    public Molecule getQuery() {
        return this.queryModifier.getOrigQuery();
    }

    @Override
    public boolean isMatching() throws SearchException {
        return this.findFirstHit() != null;
    }

    @Override
    protected SearchHit findFirstHit() throws SearchException {
        this.first = true;
        return this.findNextHit();
    }

    @Override
    protected SearchHit findNextHit() throws SearchException {
        if (this.first) {
            this.molSearch.setQuery(this.queryModifier.modify(this.query, this.exclude), this.queryModifier.modify(this.exclude));
            this.groupHitStore.clear();
        } else if (this.groupHitStore.peek() != null) {
            return new SearchHit(this.groupHitStore.pop());
        }
        SearchHit hit = this.first ? this.molSearch.findFirstHit() : this.molSearch.findNextHit();
        this.first = false;
        while (hit != null) {
            this.queryModifier.extendHitToGroups(this.groupHitStore, hit);
            if (this.groupHitStore.peek() != null) {
                return new SearchHit(this.groupHitStore.pop());
            }
            hit = this.molSearch.findNextHit();
        }
        this.groupHitStore.close();
        return this.groupHitStore.peek() != null ? new SearchHit(this.groupHitStore.pop()) : null;
    }

    @Override
    public void stop() {
    }

    @Override
    public void setSearchOptions(SearchOptions options) {
        super.setSearchOptions(options);
        this.setOrdering();
        this.setModifiedOptions();
        this.first = true;
    }
}

