/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology;

import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.HeteroCycleMatcher;
import chemaxon.sss.search.homology.HomologyRingMatcher;
import chemaxon.struc.MolAtom;

public class AnyCycleMatcher
extends HomologyRingMatcher {
    AnyCycleMatcher(int hgIdx, HomologySGSearch structureSearch) {
        super(hgIdx, structureSearch);
        this.homologyType = 10;
        this.init();
    }

    @Override
    protected void init() {
        this.canBeFused = true;
        this.ligandOnOptional = false;
        this.multiOptional = this.completeHG && this.ligandOnOptional;
        if (!this.completeHG) {
            this.ligandOnOptional = true;
            this.lazyInit = true;
        } else {
            this.lazyInit = false;
        }
        this.canAlkylSubstitute = false;
    }

    @Override
    public boolean isInitialAtom(int atomNum, int atomIdx, MolAtom atom) {
        if (!HeteroCycleMatcher.isAcceptedHeteroAtomType(atomNum)) {
            return false;
        }
        return super.isInitialAtom(atomNum, atomIdx, atom);
    }

    @Override
    protected boolean isRingTypeOK(int ringIndex) {
        return super.isRingTypeOK(ringIndex);
    }
}

