/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology;

import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.HomologyMatcher;
import chemaxon.sss.search.homology.HomologyRingMatcher;
import chemaxon.struc.MolAtom;

class CycloAlkylMatcher
extends HomologyRingMatcher {
    CycloAlkylMatcher(int hgIdx, HomologySGSearch structureSearch) {
        super(hgIdx, structureSearch);
        this.homologyType = 3;
        this.init();
    }

    @Override
    protected void init() {
        this.ligandOnOptional = false;
        this.multiOptional = this.completeHG && this.ligandOnOptional;
        if (!this.completeHG) {
            this.ligandOnOptional = true;
            this.lazyInit = true;
        } else {
            this.lazyInit = false;
        }
        this.canAlkylSubstitute = false;
        this.canBeFused = true;
    }

    @Override
    public boolean isInitialAtom(int atomNum, int atomIdx, MolAtom atom) {
        if (!HomologyMatcher.isAcceptedCarbonicAtomType(atomNum)) {
            return false;
        }
        if (!super.isInitialAtom(atomNum, atomIdx, atom)) {
            return false;
        }
        return !this.hasAromaticBond(atomIdx, false);
    }

    @Override
    protected boolean isRingTypeOK(int ringIndex) {
        if (!super.isRingTypeOK(ringIndex)) {
            return false;
        }
        boolean res = this.searcher.homologyRingClassifier.getAliphatic(ringIndex) && this.searcher.homologyRingClassifier.getCarboHydro(ringIndex);
        return res;
    }
}

