/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology;

import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.HomologyMatcher;
import chemaxon.sss.search.homology.HomologyRingMatcher;
import chemaxon.struc.MolAtom;

class HeteroArylMatcher
extends HomologyRingMatcher {
    HeteroArylMatcher(int hgIdx, HomologySGSearch structureSearch) {
        super(hgIdx, structureSearch);
        this.homologyType = 7;
        this.init();
    }

    @Override
    protected void init() {
        this.canBeFused = false;
        this.ligandOnOptional = false;
        this.multiOptional = this.completeHG && this.ligandOnOptional;
        if (!this.completeHG) {
            this.ligandOnOptional = true;
            this.lazyInit = true;
        } else {
            this.lazyInit = false;
        }
        this.aromatic = true;
        this.canAlkylSubstitute = false;
    }

    @Override
    public boolean isInitialAtom(int atomNum, int atomIdx, MolAtom atom) {
        if (!HomologyMatcher.isAcceptedHeteroAtomType(atomNum)) {
            return false;
        }
        if (!super.isInitialAtom(atomNum, atomIdx, atom)) {
            return false;
        }
        int ringBNum = this.searcher.countRingBonds(atomIdx);
        if (!this.completeHG && ringBNum == 0 && atomNum != 6 && atomNum != 1 && !this.isPossibleRingAtom(atomIdx, atomNum)) {
            return false;
        }
        return !this.completeHG || ringBNum != 0 || atomNum == 6 || atomNum == 1;
    }

    @Override
    public boolean isRingTypeOK(int ringIndex) {
        if (!super.isRingTypeOK(ringIndex)) {
            return false;
        }
        return this.searcher.homologyRingClassifier.getAromatic(ringIndex) && this.searcher.homologyRingClassifier.getHetero(ringIndex) && this.searcher.homologyRingClassifier.getHeteroAromatic(ringIndex);
    }
}

