/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.enumeration.homology.HomologyPropertyChecker;
import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.HomologyMatcher;
import chemaxon.struc.MolAtom;
import chemaxon.struc.PeriodicSystem;

public abstract class HomologyRingMatcher
extends HomologyMatcher {
    boolean canBeFused = true;
    boolean aromatic = false;
    boolean canAlkylSubstitute = true;

    protected HomologyRingMatcher(int hgIdx, HomologySGSearch searchObj) {
        super(hgIdx, searchObj);
    }

    @Override
    protected void findCriticals() {
        if (this.lazyInit) {
            return;
        }
        boolean[] checkedAtoms = null;
        checkedAtoms = ArrayTools.initBooleanArrayAndFill(checkedAtoms, this.searcher.getAtomCountMatched(), false);
        for (int i = 0; i < this.searcher.getAtomCountMatched(); ++i) {
            if (checkedAtoms[i] || !this.isHgMappable(i)) continue;
            int ringIndex = this.searcher.getRingIndex(i);
            if (ringIndex < 0) {
                if (!this.isMatchingOnSameHg(i)) continue;
                int[] crit = new int[]{i};
                this.addNewCritical(crit);
                continue;
            }
            boolean removeRingAtoms = !this.isRingTypeOK(ringIndex);
            int[] ringAtoms = this.searcher.getRing(ringIndex);
            if (!removeRingAtoms) {
                boolean bl = removeRingAtoms = !this.isRingHGMappable(ringAtoms);
            }
            if (removeRingAtoms) {
                this.clearRing(ringAtoms);
                continue;
            }
            this.addNewCritical(ringAtoms);
            for (int j = 0; j < ringAtoms.length; ++j) {
                checkedAtoms[ringAtoms[j]] = true;
            }
        }
    }

    protected boolean isRingHGMappable(int[] ringAtoms) {
        for (int j = 0; j < ringAtoms.length; ++j) {
            if (this.isHgMappable(ringAtoms[j])) continue;
            return false;
        }
        return true;
    }

    protected boolean isRingTypeOK(int ringIndex) {
        if (!this.canBeFused && this.searcher.homologyRingClassifier.getFused(ringIndex)) {
            return false;
        }
        if (this.searcher.homologyRingClassifier.getAtomNumber(ringIndex, 6) == 0) {
            return false;
        }
        return this.isHomologyPropOK(ringIndex);
    }

    private boolean isHomologyPropOK(int ringIndex) {
        if (!HomologyPropertyChecker.isRingPropOK(this.homologyProperties, this.searcher.homologyRingClassifier, ringIndex)) {
            return false;
        }
        if (!HomologyPropertyChecker.isDTCountOK(this.homologyProperties, this.searcher.homologyRingClassifier, ringIndex, false)) {
            return false;
        }
        return HomologyPropertyChecker.isTextNoteOK(this.homologyProperties, this.searcher.homologyRingClassifier, ringIndex);
    }

    @Override
    public void add(int q) {
        if (this.completeHG) {
            super.add(q);
            return;
        }
        int ringIdx = this.searcher.getRingIndex(q);
        if (ringIdx >= 0) {
            boolean needToStepBack;
            int[] ringAtoms = this.searcher.getRing(ringIdx);
            boolean bl = needToStepBack = !this.isRingTypeOK(ringIdx) || !this.isRingHGMappable(ringAtoms);
            if (needToStepBack) {
                this.clearHGMap(q);
                ++this.atomsAdded;
                return;
            }
            for (int i = 0; i < ringAtoms.length && !this.searcher.isAtomAlreadyMatched(ringAtoms[i]); ++i) {
                this.allowOnlyHGMap(ringAtoms[i]);
            }
        }
        super.add(q);
    }

    @Override
    protected boolean isOutWardConnection(int parent, int currAtom, int c) {
        if (this.completeHG) {
            return super.isOutWardConnection(parent, currAtom, c);
        }
        int critInd = this.getCritical(currAtom);
        if (critInd == c) {
            return false;
        }
        boolean res = !this.isHgMappable(currAtom) || !this.isExpansionBond(parent, currAtom);
        res = res || critInd != c && critInd > -1;
        return res;
    }

    protected boolean isPossibleRingAtom(int atomIdx, int atomNum) {
        int bondNum = this.searcher.getBondCount(atomIdx, true);
        int heavyConnNum = 0;
        int bindingElectrons = 0;
        boolean dontCheck = false;
        for (int i = 0; i < bondNum; ++i) {
            int otherAtomNum = this.searcher.getAtomTypeMatched(this.searcher.getNeighAtomMatched(atomIdx, i), true);
            int bondType = this.searcher.getBondType(atomIdx, i, true);
            if (bondType > 3) {
                dontCheck = true;
            } else {
                bindingElectrons += bondType;
            }
            if (otherAtomNum == 1) continue;
            ++heavyConnNum;
        }
        if (heavyConnNum > 1 || dontCheck) {
            return true;
        }
        int columnNum = PeriodicSystem.getColumn(atomNum);
        return columnNum + bindingElectrons <= 17;
    }

    @Override
    protected boolean isExpansionBond(int parent, int currAtom) {
        if (this.completeHG) {
            return super.isExpansionBond(parent, currAtom);
        }
        return true;
    }

    @Override
    public boolean isInitialAtom(int atomNum, int atomIdx, MolAtom atom) {
        int ringBNum = this.searcher.countRingBonds(atomIdx);
        if (!this.canAlkylSubstitute && this.completeHG && atomNum != 1 && ringBNum < 2) {
            return false;
        }
        if (!this.canBeFused) {
            if (ringBNum > 2) {
                return false;
            }
            if (this.aromatic && ringBNum > 0 && !this.hasAromaticBond(atomIdx, true)) {
                return false;
            }
        }
        return super.isInitialAtom(atomNum, atomIdx, atom);
    }

    @Override
    public void buildUpStructures() {
        super.buildUpStructures();
        if (this.aromatic) {
            this.checkArylSubstitution();
        }
    }

    @Override
    protected void expandCritical(int i) {
        super.expandCritical(i);
        if (this.aromatic && this.lazyInit) {
            this.checkArylSubstitution();
        }
    }

    private void checkArylSubstitution() {
        if (this.aromatic && this.borderAtoms != null) {
            block0: for (int crit = 0; crit < this.borderAtoms.length; ++crit) {
                for (int a : this.borderAtoms[crit]) {
                    if (this.completeHG) {
                        if (a <= 0 && (this.hasAromaticBond(-a - 1, true) || this.isMatchingOnSameHg(-a - 1))) continue;
                        this.clearCriticalAndOptional(crit);
                        continue block0;
                    }
                    int n = a = a >= 0 ? a : -a - 1;
                    if (this.searcher.getBondCount(a, true) <= 1 || this.hasAromaticBond(a, true)) continue;
                    this.prohibitMatching(a);
                }
            }
        }
    }

    @Override
    public void prohibitMatching(int q) {
        int[] opts;
        super.prohibitMatching(q);
        if (this.aromatic && (opts = this.getAllOptional(q)).length > 0) {
            int critPart = opts[0];
            int[] pathToCrit = this.getPathToCrit(critPart, q);
            if (this.completeHG) {
                int critAtom = -pathToCrit[pathToCrit.length - 1] - 1;
                if (!this.hasAromaticBond(critAtom, true)) {
                    this.clearCriticalAndOptional(critPart);
                }
            } else if (pathToCrit.length > 1) {
                int neighIdx;
                int n = neighIdx = pathToCrit[1] >= 0 ? pathToCrit[1] : -pathToCrit[1] - 1;
                if (this.searcher.getBondCount(neighIdx, true) > 1 && !this.hasAromaticBond(neighIdx, true)) {
                    this.prohibitMatching(neighIdx);
                }
            }
        }
    }

    @Override
    void clearCriticalAndOptional(int c) {
        this.clearRing(this.criticalParts[c]);
        for (int oAtom = 0; oAtom < this.optionalParts[c].length; ++oAtom) {
            this.clearHGMap(this.optionalParts[c][oAtom]);
        }
    }

    private void clearRing(int[] ringAtoms) {
        IntVector spiroAtoms = new IntVector();
        for (int rInd = 0; rInd < ringAtoms.length; ++rInd) {
            int cAtom = ringAtoms[rInd];
            if (!this.canBeFused || this.searcher.countRingBonds(cAtom) != 4) {
                this.clearHGMap(cAtom);
                continue;
            }
            spiroAtoms.add(cAtom);
        }
        while (spiroAtoms.size() > 0) {
            int[] neigh;
            int spiroAtom = spiroAtoms.removeLast();
            int numOfmatchable = 0;
            for (int n : neigh = this.searcher.getNeighbours(spiroAtom, true)) {
                if (!this.isHgMappable(n)) continue;
                ++numOfmatchable;
            }
            if (numOfmatchable >= 2) continue;
            this.clearHGMap(spiroAtom);
        }
    }
}

