/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology;

import chemaxon.common.util.IntVector;
import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.HomologyMatcher;
import chemaxon.struc.MolAtom;

public class RingSegmentMatcher
extends HomologyMatcher {
    RingSegmentMatcher(int hgIdx, HomologySGSearch structureSearch) {
        super(hgIdx, structureSearch);
        this.homologyType = 11;
        this.lazyInit = true;
        this.multiOptional = false;
        this.neighbouringCritical = false;
        this.ligandOnOptional = true;
    }

    @Override
    public boolean isInitialAtom(int atomNum, int atomIdx, MolAtom atom) {
        if (!HomologyMatcher.isAcceptedHeteroAtomType(atomNum)) {
            return false;
        }
        if (this.searcher.countRingBonds(atomIdx) != 2) {
            return false;
        }
        return this.checkHMatching(atomIdx, false);
    }

    @Override
    protected boolean isOutWardConnection(int parent, int currAtom, int c) {
        int critInd = this.getCritical(currAtom);
        if (critInd == c) {
            return false;
        }
        boolean res = !this.isHgMappable(currAtom) || !this.isExpansionBond(parent, currAtom);
        res = res || critInd != c && critInd > -1;
        return res;
    }

    @Override
    protected boolean isExpansionBond(int parent, int currAtom) {
        parent = parent < 0 ? -parent - 1 : parent;
        return this.searcher.isRingBond(parent, currAtom);
    }

    @Override
    public void add(int q) {
        if (this.atomsAdded == 0) {
            super.add(q);
        } else {
            ++this.atomsAdded;
        }
        if (this.searcher.isQuerySide()) {
            return;
        }
        for (int o : this.optionalParts[0]) {
            if (!this.isNotTheWholeRingOccupied(o, q)) continue;
            return;
        }
        if (this.isNotTheWholeRingOccupied(this.criticalParts[0][0], q)) {
            return;
        }
        this.clearHGMap(q);
    }

    private boolean isNotTheWholeRingOccupied(int o, int q) {
        int[] neigh;
        if (o > q) {
            return true;
        }
        for (int n : neigh = this.searcher.getNeighbours(o, true)) {
            if (!this.searcher.isRingBond(n, o) || this.isHgMappable(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void prohibitMatching(int q) {
        this.clearHGMap(q);
        if (this.atomsAdded > 0 && q != this.criticalParts[0][0]) {
            IntVector reachables = this.getAtomsReachableFromCritical();
            for (int o : this.optionalParts[0]) {
                if (reachables.contains(o)) continue;
                this.clearHGMap(o);
            }
        }
    }

    private IntVector getAtomsReachableFromCritical() {
        IntVector reachables = new IntVector();
        IntVector toCheck = new IntVector();
        toCheck.add(this.criticalParts[0][0]);
        while (toCheck.size() > 0) {
            int[] neigh;
            int current = toCheck.removeLast();
            reachables.add(current);
            for (int n : neigh = this.searcher.getNeighbours(current, true)) {
                if (!this.isHgMappable(n) || reachables.contains(n)) continue;
                toCheck.add(n);
            }
        }
        return reachables;
    }
}

