/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology;

import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.HomologyMatcher;

class UnknownMatcher
extends HomologyMatcher {
    boolean entireQuery = false;

    UnknownMatcher(int hgIdx, HomologySGSearch structureSearch) {
        super(hgIdx, structureSearch);
        this.homologyType = 12;
        this.lazyInit = true;
        this.ligandOnOptional = true;
        this.multiOptional = false;
    }

    @Override
    protected boolean isOutWardConnection(int parent, int currAtom, int c) {
        int critInd = this.getCritical(currAtom);
        if (critInd == c) {
            return false;
        }
        boolean res = !this.isHgMappable(currAtom) || !this.isExpansionBond(parent, currAtom);
        res = res || critInd != c && critInd > -1;
        return res;
    }

    @Override
    protected boolean isExpansionBond(int parent, int currAtom) {
        return true;
    }

    @Override
    public void add(int q) {
        super.add(q);
        if (!this.searcher.isQuerySide() && q >= this.searcher.getAtomCountMatched() - 1 && !this.entireQuery && this.searcher.getNeighbours(this.hgIndex).length > 0) {
            boolean allHGmapped = true;
            for (int i = 0; i < this.searcher.getAtomCountMatched() && allHGmapped; ++i) {
                allHGmapped = this.isHgMappable(i);
            }
            if (allHGmapped) {
                this.clearHGMap(this.criticalParts[0][0]);
            }
        }
    }
}

