/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.ratom;

import chemaxon.common.util.IntVector;
import chemaxon.sss.search.ratom.QueryModifier;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.util.ArrayList;
import java.util.Arrays;

public class LigandHandler {
    private static final String FRAGID = "FRAGID";
    private static final String ATTACH_QUERY_INDEX = "ATTACH_QUERY_INDEX";
    private static final String ATTACHMENT_MARKER = "ATTACHMENT_MARKER";
    private Molecule target = null;
    private Molecule query = null;
    private int[] excludedQueryAtoms = null;
    private int attachmentType = 4;
    private boolean align = false;
    private Molecule[] queryToRLigand = null;
    private Molecule scaffold = null;
    private static final int ACTION_BREAK_BONDS = 0;
    private static final int ACTION_REORDER_GROUPS = 1;

    public void setQuery(Molecule query) {
        this.query = query;
        if (this.align && query.getDim() != 2) {
            query.clean(2, null);
        }
    }

    public Molecule getQuery() {
        return this.query;
    }

    public void setTarget(Molecule target) {
        this.target = target;
    }

    public Molecule getTarget() {
        return this.target;
    }

    public void setExcludedQueryAtoms(int[] excludedQueryAtoms) {
        this.excludedQueryAtoms = excludedQueryAtoms;
    }

    public void setAttachmentType(int attachmentType) {
        this.attachmentType = attachmentType;
    }

    public int getAttachmentType() {
        return this.attachmentType;
    }

    public void setAlign(boolean align) {
        this.align = align;
    }

    public Molecule[] getQueryToRLigand() {
        return this.queryToRLigand;
    }

    public Molecule getScaffold() {
        return this.scaffold;
    }

    public boolean convertToLigands(int[][] groupHit, boolean fullSearch) {
        Molecule[] frags;
        this.queryToRLigand = null;
        this.scaffold = null;
        if (this.align) {
            this.alignTarget(groupHit);
        }
        Molecule mol = this.target.cloneMolecule();
        this.queryToRLigand = new Molecule[groupHit.length];
        this.scaffold = (Molecule)mol.newInstance();
        RgMolecule rgmol = this.query instanceof RgMolecule ? (RgMolecule)this.query : null;
        for (int i = 0; i < this.queryToRLigand.length; ++i) {
            MolAtom queryAtom = this.query.getAtom(i);
            if (queryAtom.getAtno() != 134) continue;
            if (groupHit[i].length == 0) {
                this.queryToRLigand[i] = new Molecule();
                continue;
            }
            int heavyAtomIndex = this.getHeavyAtomIndex(groupHit[i]);
            if (heavyAtomIndex == -1) continue;
            assert (queryAtom.getBondCount() == 1);
            Molecule rligand = new Molecule();
            MolAtom t = mol.getAtom(heavyAtomIndex);
            MolAtom a = queryAtom.getLigand(0);
            MolAtom h = new MolAtom(1);
            rligand.add(h);
            this.setAttachment(rligand, t, h, null, queryAtom, this.query.indexOf(a));
            if (this.align) {
                rligand.clean(2, null);
            }
            this.queryToRLigand[i] = rligand;
        }
        this.setFragIds(mol, groupHit);
        this.breakBonds(mol, groupHit);
        for (Molecule frag : frags = mol.convertToFrags()) {
            int[] fragIds = this.getFragIds(frag.getAtom(0));
            if (fragIds != null) {
                LigandHandler.clearFragIds(frag);
                for (int fragId : fragIds) {
                    this.queryToRLigand[fragId] = frag;
                }
                continue;
            }
            if (LigandHandler.hasAttachment(frag)) {
                this.scaffold.fuse(frag, false);
                continue;
            }
            if (!fullSearch) continue;
            return false;
        }
        if (this.align) {
            this.arrangeLigandAttachments(frags);
        }
        return true;
    }

    private void setFragIds(Molecule mol, int[][] groupHit) {
        RgMolecule rgmol = this.query instanceof RgMolecule ? (RgMolecule)this.query : null;
        for (int i = 0; i < groupHit.length; ++i) {
            if (this.query.getAtom(i).getAtno() != 134) continue;
            for (int k : groupHit[i]) {
                if (k < 0) continue;
                this.setFragId(mol.getAtom(k), i);
            }
        }
    }

    private void setFragId(MolAtom atom, int fragId) {
        IntVector fragIds = (IntVector)atom.getQProp(FRAGID);
        if (fragIds == null) {
            fragIds = new IntVector();
            atom.setQProp(FRAGID, fragIds);
        }
        fragIds.add(fragId);
    }

    private int getHeavyAtomIndex(int[] group) {
        if (group.length != 1) {
            return -1;
        }
        int x = group[0];
        if (x == Integer.MIN_VALUE) {
            return 0;
        }
        if (x < 0 && x > -this.target.getAtomCount()) {
            return -x;
        }
        return -1;
    }

    private void breakBonds(Molecule mol, int[][] groupHit) {
        this.processAttachments(mol, groupHit, 0);
    }

    void reorderGroups(Molecule mol, int[][] groupHit) {
        this.processAttachments(mol, groupHit, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processAttachments(Molecule mol, int[][] groupHit, int action) {
        RgMolecule rgmol = this.query instanceof RgMolecule ? (RgMolecule)this.query : null;
        int i = this.query.getAtomCount() - 1;
        while (i >= 0) {
            MolAtom queryAtom = this.query.getAtom(i);
            if (queryAtom.getAtno() == 134 && !this.isExcludedQueryAtomIndex(i)) {
                block5: for (int j = queryAtom.getBondCount() - 1; j >= 0; --j) {
                    MolAtom queryLigand = queryAtom.getLigand(j);
                    int queryIndex = this.query.indexOf(queryLigand);
                    assert (groupHit[queryIndex].length == 1);
                    int targetIndex = groupHit[queryIndex][0];
                    if (targetIndex < 0) continue;
                    MolAtom targetLigand = mol.getAtom(targetIndex);
                    switch (action) {
                        case 0: {
                            this.breakBonds(mol, targetLigand, i, queryAtom, queryIndex);
                            break;
                        }
                        case 1: {
                            if (this.reorderGroup(groupHit[i], mol, targetLigand)) break block5;
                        }
                    }
                }
            }
            --i;
        }
        return;
    }

    private boolean reorderGroup(int[] group, Molecule mol, MolAtom atom) {
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            MolAtom ligand = atom.getLigand(i);
            int ligandIndex = mol.indexOf(ligand);
            int groupIndex = Arrays.binarySearch(group, ligandIndex);
            if (groupIndex <= 0) continue;
            for (int j = groupIndex; j >= 1; --j) {
                group[j] = group[j - 1];
            }
            group[0] = ligandIndex;
            return true;
        }
        return false;
    }

    private void breakBonds(Molecule mol, MolAtom atom, int fragId, MolAtom ratom, int attachQueryIndex) {
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            MolBond bond = atom.getBond(i);
            MolAtom ligand = bond.getOtherAtom(atom);
            if (!this.containedInFrag(ligand, fragId)) continue;
            this.setAttachment(mol, atom, ligand, bond, ratom, attachQueryIndex);
            mol.removeBond(bond);
        }
    }

    private void setAttachment(Molecule mol, MolAtom atom, MolAtom ligand, MolBond bond, MolAtom ratom, int attachQueryIndex) {
        LigandHandler.setAttachmentAtom(atom, attachQueryIndex);
        int rid = ratom.getRgroup();
        MolAtom qatom = this.query.getAtom(attachQueryIndex);
        switch (this.attachmentType) {
            case 4: {
                MolAtom anyAtom = new MolAtom(131, atom.getX(), atom.getY(), atom.getZ());
                LigandHandler.setAttachmentAtom(anyAtom, attachQueryIndex);
                anyAtom.setQProp(FRAGID, ligand.getQProp(FRAGID));
                anyAtom.setExtraLabel(rid > 0 ? "" + rid : "");
                MolBond attachmentBond = bond != null ? bond.cloneBond(ligand, anyAtom) : new MolBond(ligand, anyAtom);
                mol.add(anyAtom);
                mol.add(attachmentBond);
                break;
            }
            case 1: {
                int order = this.getAttachmentOrder(ratom, attachQueryIndex);
                int type = bond != null ? bond.getType() : 1;
                MolAtom attachment = ligand.addRgroupAttachmentPoint(order, type);
                attachment.setXYZ(atom.getX(), atom.getY(), atom.getZ());
                LigandHandler.setAttachmentAtom(attachment, attachQueryIndex);
                attachment.setQProp(FRAGID, ligand.getQProp(FRAGID));
                break;
            }
            case 2: {
                LigandHandler.setAttachmentAtom(ligand, attachQueryIndex);
                ligand.setAtomMap(rid);
                break;
            }
            case 3: {
                LigandHandler.setAttachmentAtom(ligand, attachQueryIndex);
                ligand.setExtraLabel("" + rid);
                break;
            }
            case 5: {
                LigandHandler.setAttachmentAtom(ligand, attachQueryIndex);
                ligand.setExtraLabel("R" + (rid > 0 ? "" + rid : ""));
            }
        }
    }

    static int getAttachQueryIndex(MolAtom atom) {
        return atom.getQPropAsInt(ATTACH_QUERY_INDEX);
    }

    private void alignTarget(int[][] groupHit) {
        IntVector fixed = new IntVector();
        ArrayList<MolAtom> qatoms = new ArrayList<MolAtom>();
        IntVector bridge = new IntVector();
        boolean bridging = false;
        for (int i = 0; i < groupHit.length; ++i) {
            if (groupHit[i].length == 1 && groupHit[i][0] >= 0) {
                MolAtom qatom = this.query.getAtom(i);
                fixed.add(groupHit[i][0]);
                qatoms.add(qatom);
                continue;
            }
            if (bridging || groupHit[i].length <= 1) continue;
            if (bridge.contains(groupHit[i][0])) {
                bridging = true;
                continue;
            }
            bridge.add(groupHit[i][0]);
        }
        int[] fixedInds = fixed.toArray();
        if (!bridging && LigandHandler.isConnected(this.target, fixedInds)) {
            for (int i = 0; i < fixedInds.length; ++i) {
                MolAtom qatom = (MolAtom)qatoms.get(i);
                this.target.getAtom(fixedInds[i]).setXYZ(qatom.getX(), qatom.getY(), qatom.getZ());
            }
            this.target.partialClean(2, fixedInds, null);
        } else if (this.target.getDim() != 2) {
            this.target.clean(2, null);
        }
    }

    private static boolean isConnected(Molecule mol, int[] inds) {
        int[] compIds = mol.findComponentIds(inds);
        for (int i = compIds.length - 1; i >= 1; --i) {
            if (compIds[i] == compIds[i - 1]) continue;
            return false;
        }
        return true;
    }

    private void arrangeLigandAttachments(Molecule[] frags) {
        if (this.attachmentType != 4 && this.attachmentType != 1) {
            return;
        }
        int dim = this.target.getDim();
        if (dim == 0) {
            return;
        }
        for (Molecule mol : frags) {
            if (mol == null) continue;
            if (dim == 3) {
                mol.clean(3, null);
                continue;
            }
            if (mol.getDim() == 0) {
                mol.clean(dim, null);
                continue;
            }
            if (!LigandHandler.isHLigand(mol)) continue;
            mol.clean(dim, null);
        }
    }

    public static boolean isHLigand(Molecule mol) {
        int count = mol.getAtomCount();
        if (count > 2) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            MolAtom atom = mol.getAtom(i);
            if (QueryModifier.isH(atom) || LigandHandler.isAttachmentAtom(atom)) continue;
            return false;
        }
        return true;
    }

    private int[] getFragIds(MolAtom atom) {
        IntVector fragIds = (IntVector)atom.getQProp(FRAGID);
        return fragIds != null ? fragIds.toArray() : null;
    }

    private boolean containedInFrag(MolAtom atom, int fragId) {
        IntVector fragIds = (IntVector)atom.getQProp(FRAGID);
        return fragIds != null ? fragIds.contains(fragId) : false;
    }

    private static void clearFragIds(Molecule mol) {
        LigandHandler.clearQProp(FRAGID, mol);
    }

    public static void clearAttachQueryIndexes(Molecule mol) {
        LigandHandler.clearQProp(ATTACH_QUERY_INDEX, mol);
    }

    static void getAttachmentAtoms(ArrayList<MolAtom> attachmentAtoms, Molecule mol) {
        attachmentAtoms.clear();
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = mol.getAtom(i);
            if (!LigandHandler.isAttachmentAtom(atom)) continue;
            attachmentAtoms.add(atom);
        }
    }

    private static void setAttachmentAtom(MolAtom attachAtom, int attachQueryIndex) {
        attachAtom.setQProp(ATTACHMENT_MARKER, "true");
        attachAtom.setQProp(ATTACH_QUERY_INDEX, attachQueryIndex);
    }

    public static boolean isAttachmentAtom(MolAtom atom) {
        return atom.getAtno() == 138 || atom.getAtno() == 131 && LigandHandler.hasAttachment(atom);
    }

    private static boolean hasAttachment(MolAtom atom) {
        return atom.getQProp(ATTACHMENT_MARKER) != null;
    }

    private static boolean hasAttachment(Molecule mol) {
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            if (!LigandHandler.hasAttachment(mol.getAtom(i))) continue;
            return true;
        }
        return false;
    }

    private int getAttachmentOrder(MolAtom ratom, int attachQueryIndex) {
        MolAtom[] rligands = ratom.getLigands();
        for (int i = 0; i < rligands.length; ++i) {
            if (this.query.indexOf(rligands[i]) != attachQueryIndex) continue;
            return ratom.getLigandOrder(rligands[i]);
        }
        return 0;
    }

    boolean isExcludedQueryAtomIndex(int i) {
        return LigandHandler.contains(this.excludedQueryAtoms, i);
    }

    private static void clearQProp(String prop, Molecule mol) {
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            mol.getAtom(i).setQProp(prop, null);
        }
    }

    private static boolean contains(int[] indexes, int index) {
        if (indexes == null) {
            return false;
        }
        for (int x : indexes) {
            if (x != index) continue;
            return true;
        }
        return false;
    }
}

