/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.ratom;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.sss.search.Search;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.SearchUtil;
import chemaxon.sss.search.ratom.GroupHitHandler;
import chemaxon.sss.search.ratom.HeavyMatchFirstSorter;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.BackTrack;
import chemaxon.util.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueryModifier {
    private static final Logger logger = Logger.getLogger(QueryModifier.class.getName());
    private static final int MAX_GROUPHIT_COUNT = 5000;
    private Molecule origQuery = null;
    private Molecule target = null;
    private int[] targetExclude = null;
    private final boolean containsRAtom = false;
    private boolean hasQueryProps = false;
    private int[] queryOrigToModified = null;
    private int undefinedRAtom = 2;
    private boolean bridgingRAllowed = false;
    private final GroupHitHandler groupHitHandler = new GroupHitHandler();
    private boolean keepGroupOrder = false;

    public void setKeepGroupOrder(boolean keepGroupOrder) {
        this.keepGroupOrder = keepGroupOrder;
    }

    public void setSearchOptions(SearchOptions searchOptions, boolean fullSearch) {
        this.groupHitHandler.setSearchOptions(searchOptions, fullSearch);
        this.setUndefinedRAtom(searchOptions.getUndefinedRAtom());
        this.setBridgingRAllowed(searchOptions.isBridgingRAllowed());
    }

    public void setUndefinedRAtom(int undefinedRAtom) {
        this.undefinedRAtom = undefinedRAtom;
    }

    public int getUndefinedRAtom() {
        return this.undefinedRAtom;
    }

    public boolean isUndefinedRAtomMatchingGroup() {
        return this.undefinedRAtom == 2 || this.undefinedRAtom == 3 || this.undefinedRAtom == 4;
    }

    public void setBridgingRAllowed(boolean value) {
        this.bridgingRAllowed = value;
    }

    public boolean isBridgingRAllowed() {
        return this.bridgingRAllowed;
    }

    public Molecule getOrigQuery() {
        return this.origQuery;
    }

    public Molecule modify(Molecule origQuery, int[] exclude) throws IllegalArgumentException {
        this.origQuery = origQuery;
        this.groupHitHandler.setQuery(origQuery, exclude);
        Molecule query = null;
        HashSet<MolAtom> undefRs = null;
        RgMolecule rgQuery = origQuery instanceof RgMolecule ? (RgMolecule)origQuery : null;
        for (int i = origQuery.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = origQuery.getAtom(i);
            if (!SearchUtil.isUndefinedRAtom(atom, rgQuery) || ArrayTools.contains(exclude, i)) continue;
            if (query == null) {
                query = origQuery.cloneMolecule();
                undefRs = new HashSet<MolAtom>(query.getAtomCount());
            }
            undefRs.add(query.getAtom(i));
        }
        if (query == null) {
            return origQuery;
        }
        if (QueryModifier.hasAdjacentAtoms(undefRs)) {
            throw new IllegalArgumentException("Adjacent undefined R-atoms are not allowed in query.");
        }
        if (QueryModifier.hasOnlyHLigand(undefRs)) {
            throw new IllegalArgumentException("Undefined R-atoms with only-H ligands are not allowed in query.");
        }
        if (QueryModifier.hasQProps(undefRs)) {
            throw new IllegalArgumentException("Undefined R-atoms with query properties are not allowed in query.");
        }
        if (QueryModifier.hasStereo(undefRs, query)) {
            throw new IllegalArgumentException("Undefined R-atoms around stereo centers are not allowed in query.");
        }
        if (QueryModifier.hasAdjacentHomology(undefRs)) {
            throw new IllegalArgumentException("Undefined R-atom adjacent to a homology group is not allowed.");
        }
        this.hasQueryProps = QueryModifier.clearQueryProps(query);
        if (!this.setComponentNumbers(query)) {
            return origQuery;
        }
        this.setConnectionCounts(query, undefRs);
        MolAtom[] atomsBeforeChanges = rgQuery == null ? query.getAtomArray() : ((RgMolecule)query).getRoot().getAtomArray();
        for (MolAtom r : undefRs) {
            query.removeAtom(r);
        }
        this.queryOrigToModified = new int[atomsBeforeChanges.length];
        for (int i = 0; i < atomsBeforeChanges.length; ++i) {
            this.queryOrigToModified[i] = query.indexOf(atomsBeforeChanges[i]);
        }
        return query;
    }

    private static boolean clearQueryProps(Molecule mol) {
        boolean cleared = false;
        for (int j = mol.getBondCount() - 1; j >= 0; --j) {
            MolBond bond = mol.getBond(j);
            int flags = bond.getFlags();
            if ((flags & 0xC00) != 0) {
                bond.setFlags(0, 3072);
                cleared = true;
            }
            if ((flags & 0xF000) == 0) continue;
            bond.setFlags(0, 61440);
            cleared = true;
        }
        return cleared;
    }

    private static boolean hasAdjacentAtoms(Set<MolAtom> set) {
        for (MolAtom atom : set) {
            for (int i = atom.getBondCount() - 1; i >= 0; --i) {
                MolAtom ligand = atom.getLigand(i);
                if (ligand.getAtno() != 134 || !set.contains(ligand)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasAdjacentHomology(Set<MolAtom> set) {
        for (MolAtom atom : set) {
            for (int i = atom.getBondCount() - 1; i >= 0; --i) {
                MolAtom ligand = atom.getLigand(i);
                if (!ligand.isPseudo() || !HomologyConstants.isHomology(ligand.getAliasstr())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasOnlyHLigand(Set<MolAtom> set) {
        for (MolAtom atom : set) {
            int bcount = atom.getBondCount();
            int hcount = QueryModifier.getExplicitHcount(atom);
            if (bcount <= 0 || bcount != hcount) continue;
            return true;
        }
        return false;
    }

    private static boolean hasQProps(Set<MolAtom> set) {
        for (MolAtom atom : set) {
            if (!atom.hasQProps()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasStereo(Set<MolAtom> set, Molecule parent) {
        for (MolAtom atom : set) {
            if (QueryModifier.hasParity(atom, parent)) {
                return true;
            }
            for (int k = atom.getBondCount() - 1; k >= 0; --k) {
                MolAtom ligand = atom.getLigand(k);
                if (!QueryModifier.hasParity(ligand, parent)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasParity(MolAtom atom, Molecule parent) {
        int parity = parent.getParity(parent.indexOf(atom));
        return parity == 1 || parity == 2;
    }

    public int[] modify(int[] origIndexes) {
        if (origIndexes == null) {
            return null;
        }
        return this.modify(origIndexes, origIndexes.length);
    }

    public int[] modify(int[] origIndexes, int length) {
        if (origIndexes == null) {
            return null;
        }
        if (this.queryOrigToModified == null) {
            return origIndexes;
        }
        int[] indexes = new int[origIndexes.length];
        for (int i = 0; i < length; ++i) {
            indexes[i] = this.queryOrigToModified[origIndexes[i]];
        }
        return indexes;
    }

    public void setTarget(Molecule mol, int[] exclude) {
        this.target = mol instanceof Supergraph ? ((Supergraph)mol).getMolecule() : mol;
        this.targetExclude = exclude;
        this.groupHitHandler.setTarget(this.target, exclude);
    }

    public boolean extendHitToGroups(HeavyMatchFirstSorter result, SearchHit hit) throws SearchException {
        int[][] hit2D = hit.getGroupHit();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("-------------> HIT: " + QueryModifier.arrayTo1BasedString(hit2D, ",", " "));
            logger.fine("queryOrigToModified: " + StringUtil.arrayToString(this.queryOrigToModified, 1, " "));
            logger.fine("ORIG HIT: " + this.getOrigHitString(hit2D));
        }
        int[] inds = QueryModifier.getUncoveredAtomIndexes(hit2D, this.targetExclude, this.target.getAtomCount());
        int[] targetToCompId = QueryModifier.findTargetToCompId(this.target, inds);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("targetToCompId: " + StringUtil.arrayToString(targetToCompId, " "));
        }
        IntVector isolatedCompIds = new IntVector();
        IntVector connectedCompIds = new IntVector();
        IntVector explicitHCompIds = new IntVector();
        this.collectCompIds(isolatedCompIds, connectedCompIds, explicitHCompIds, this.target, targetToCompId);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("isolatedCompIds: " + isolatedCompIds);
            logger.fine("connectedCompIds: " + connectedCompIds);
        }
        int[][] queryOrigToCompIds = this.findQueryOrigToCompIds(hit2D, this.target, targetToCompId, isolatedCompIds);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("queryOrigToCompIds: " + QueryModifier.getCompIdString(queryOrigToCompIds));
        }
        if (!this.fullFragmentMatchPossible(queryOrigToCompIds, connectedCompIds)) {
            logger.fine("fullFragmentMatchPossible() failed");
            return false;
        }
        int k = 0;
        int[] queryOrigToCompId = new int[queryOrigToCompIds.length];
        BackTrack indexEnumerator = new BackTrack(queryOrigToCompIds);
        while (indexEnumerator.hasMoreElements() && k < 5000) {
            int[] index = (int[])indexEnumerator.nextElement();
            for (int i = 0; i < index.length; ++i) {
                queryOrigToCompId[i] = queryOrigToCompIds[i][index[i]];
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Processing queryOrigToCompId: " + QueryModifier.getCompIdString(queryOrigToCompId));
            }
            if (!this.checkQueryCompIdMaps(queryOrigToCompId, connectedCompIds)) {
                logger.fine("checkQueryCompIdMaps() failed");
                continue;
            }
            if (!this.checkExtraGroupConnections(queryOrigToCompId, targetToCompId)) {
                logger.fine("checkExtraGroupConnections() failed");
                continue;
            }
            if (!this.checkRNeighborhoods(hit2D, this.target, explicitHCompIds, targetToCompId, queryOrigToCompId)) {
                logger.fine("checkRNeighborhoods() failed");
                continue;
            }
            int[][] groupHit = this.getGroupHit(hit2D, targetToCompId, queryOrigToCompId);
            if (this.groupHitHandler.isValidGroupHit(groupHit, this.hasQueryProps)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("VALID GROUP HIT FOUND");
                    logger.fine("\n" + QueryModifier.getGroupHitString(groupHit) + "\n");
                }
                if (!this.keepGroupOrder) {
                    this.groupHitHandler.reorderGroups(groupHit);
                }
                result.push(groupHit);
                ++k;
                continue;
            }
            logger.fine("groupHitHandler.isValidGroupHit() failed");
        }
        return k > 0;
    }

    private static int[] findTargetToCompId(Molecule target, int[] inds) {
        int[] compIds = target.findComponentIds(inds);
        int[] targetToCompId = new int[target.getAtomCount()];
        Arrays.fill(targetToCompId, -1);
        for (int i = 0; i < inds.length; ++i) {
            targetToCompId[inds[i]] = compIds[i];
        }
        return targetToCompId;
    }

    private boolean checkQueryCompIdMaps(int[] queryOrigToCompId, IntVector connectedCompIds) {
        int i;
        int[] v = (int[])queryOrigToCompId.clone();
        Arrays.sort(v);
        if (!this.bridgingRAllowed) {
            for (i = v.length - 1; i >= 1 && v[i] >= 0; --i) {
                if (v[i] != v[i - 1]) continue;
                logger.fine("Component ID: " + v[i] + " is assigned to more query atoms.");
                return false;
            }
        }
        for (i = connectedCompIds.size() - 1; i >= 0; --i) {
            int compId = connectedCompIds.get(i);
            if (Arrays.binarySearch(v, compId) >= 0) continue;
            logger.fine("Connected component ID: " + compId + " is not assigned to any query atom");
            return false;
        }
        return true;
    }

    private boolean checkRNeighborhoods(int[][] hit2D, Molecule target, IntVector explicitHCompIds, int[] targetToCompId, int[] queryOrigToCompId) {
        int i;
        if (this.undefinedRAtom != 2) {
            for (i = this.origQuery.getAtomCount() - 1; i >= 0; --i) {
                MolAtom queryAtom;
                if (this.queryOrigToModified[i] == -1 || !this.hasRLigand(queryAtom = this.origQuery.getAtom(i))) continue;
                int modifiedQueryAtomIndex = this.queryOrigToModified[i];
                assert (hit2D[modifiedQueryAtomIndex].length == 1 || QueryModifier.getNumberOfNonRGroups(target, hit2D[modifiedQueryAtomIndex]) == 1);
                int targetAtomIndex = hit2D[modifiedQueryAtomIndex][0];
                if (targetAtomIndex < 0) continue;
                MolAtom targetAtom = target.getAtom(targetAtomIndex);
                int heavyMatchCount = 0;
                int implHMatchCount = 0;
                for (int j = queryAtom.getBondCount() - 1; j >= 0; --j) {
                    MolAtom queryLigand = queryAtom.getLigand(j);
                    int queryLigandIndex = this.origQuery.indexOf(queryLigand);
                    if (this.isUndefR(queryLigand)) {
                        int compId = queryOrigToCompId[queryLigandIndex];
                        if (compId == -2147483643) continue;
                        if (compId >= 0) {
                            if (explicitHCompIds.contains(compId)) continue;
                            ++heavyMatchCount;
                            continue;
                        }
                        ++implHMatchCount;
                        continue;
                    }
                    int modifiedQueryLigandIndex = this.queryOrigToModified[queryLigandIndex];
                    if (hit2D[modifiedQueryLigandIndex].length == 0) continue;
                    if (hit2D[modifiedQueryLigandIndex].length == 1) {
                        int targetLigandIndex = hit2D[modifiedQueryLigandIndex][0];
                        if (targetLigandIndex < 0) {
                            ++implHMatchCount;
                            continue;
                        }
                        if (QueryModifier.isH(target.getAtom(targetLigandIndex))) continue;
                        ++heavyMatchCount;
                        continue;
                    }
                    ++heavyMatchCount;
                }
                if (targetAtom.getImplicitHcount() < implHMatchCount) {
                    return false;
                }
                if (targetAtom.getBondCount() - QueryModifier.getExplicitHcount(targetAtom) >= heavyMatchCount) continue;
                return false;
            }
        }
        for (i = 0; i < this.queryOrigToModified.length; ++i) {
            if (this.queryOrigToModified[i] != -1) continue;
            MolAtom r = this.origQuery.getAtom(i);
            for (int j = r.getBondCount() - 1; j >= 0; --j) {
                MolAtom targetAtom;
                MolBond queryBond = r.getBond(j);
                MolAtom queryAtom = queryBond.getOtherAtom(r);
                int modifiedQueryAtomIndex = this.queryOrigToModified[this.origQuery.indexOf(queryAtom)];
                assert (hit2D[modifiedQueryAtomIndex].length == 1 || QueryModifier.getNumberOfNonRGroups(target, hit2D[modifiedQueryAtomIndex]) == 1);
                int targetAtomIndex = hit2D[modifiedQueryAtomIndex][0];
                if (targetAtomIndex < 0 || this.checkConnections(queryAtom, targetAtom = target.getAtom(targetAtomIndex), hit2D, target, targetToCompId, queryOrigToCompId)) continue;
                logger.fine("checkConnections() failed");
                return false;
            }
        }
        return true;
    }

    private boolean hasRLigand(MolAtom atom) {
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            if (!this.isUndefR(atom.getLigand(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isUndefR(MolAtom atom) {
        int k;
        return atom.getAtno() == 134 && this.queryOrigToModified[k = this.origQuery.indexOf(atom)] == -1;
    }

    private boolean checkConnections(MolAtom queryAtom, MolAtom targetAtom, int[][] hit2D, Molecule target, int[] targetToCompId, int[] queryOrigToCompId) {
        IntVector compIds = new IntVector();
        for (int i = targetAtom.getBondCount() - 1; i >= 0; --i) {
            int targetLigandIndex;
            MolAtom targetLigand = targetAtom.getLigand(i);
            if (QueryModifier.isH(targetLigand) || targetToCompId[targetLigandIndex = target.indexOf(targetLigand)] == -1) continue;
            compIds.add(targetToCompId[targetLigandIndex]);
        }
        int maxHMatchCount = QueryModifier.getExplicitHcount(targetAtom);
        int h = 0;
        int s = 0;
        block1: for (int j = queryAtom.getBondCount() - 1; j >= 0; --j) {
            MolAtom queryLigand = queryAtom.getLigand(j);
            int queryLigandIndex = this.origQuery.indexOf(queryLigand);
            int modifiedQueryLigandIndex = this.queryOrigToModified[queryLigandIndex];
            if (modifiedQueryLigandIndex >= 0) {
                int[] targetLigandIndexes;
                for (int targetLigandIndex : targetLigandIndexes = hit2D[modifiedQueryLigandIndex]) {
                    MolAtom targetLigand;
                    if (targetLigandIndex < 0 || !(targetLigand = target.getAtom(targetLigandIndex)).isBoundTo(targetAtom)) continue;
                    if (QueryModifier.isH(targetLigand)) {
                        ++h;
                        continue;
                    }
                    ++s;
                }
                continue;
            }
            int compId = queryOrigToCompId[queryLigandIndex];
            if (compId < 0) continue;
            if (h < maxHMatchCount) {
                for (int k = targetAtom.getBondCount() - 1; k >= 0; --k) {
                    MolAtom targetLigand = targetAtom.getLigand(k);
                    int targetLigandIndex = target.indexOf(targetLigand);
                    if (targetToCompId[targetLigandIndex] != compId) continue;
                    if (QueryModifier.isH(targetLigand)) {
                        ++h;
                        continue block1;
                    }
                    ++s;
                    if (compIds.removeElement(compId)) continue block1;
                    return false;
                }
                continue;
            }
            ++s;
            if (compIds.removeElement(compId)) continue;
            return false;
        }
        int heavyTargetLigandCount = targetAtom.getBondCount() - maxHMatchCount;
        return s == heavyTargetLigandCount && compIds.isEmpty();
    }

    private int[][] getGroupHit(int[][] hit2D, int[] targetToCompId, int[] queryOrigToCompId) {
        int[][] groupHit = new int[queryOrigToCompId.length][];
        for (int i = 0; i < groupHit.length; ++i) {
            int[] nArray;
            int m = this.queryOrigToModified[i];
            if (m >= 0) {
                groupHit[i] = hit2D[m];
                continue;
            }
            int compId = queryOrigToCompId[i];
            if (compId >= 0) {
                groupHit[i] = QueryModifier.getIndexesMappedTo(targetToCompId, compId);
                continue;
            }
            if (compId == -2147483643) {
                nArray = new int[]{};
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = compId;
            }
            groupHit[i] = nArray;
        }
        return groupHit;
    }

    private static int[] getIndexesMappedTo(int[] map, int value) {
        IntVector v = new IntVector();
        for (int i = 0; i < map.length; ++i) {
            if (map[i] != value) continue;
            v.add(i);
        }
        return v.toArray();
    }

    /*
     * WARNING - void declaration
     */
    private static int[] getUncoveredAtomIndexes(int[][] hit2D, int[] excluded, int count) {
        void var4_5;
        IntVector v = new IntVector();
        boolean bl = false;
        while (var4_5 < count) {
            v.add((int)var4_5);
            ++var4_5;
        }
        int[][] nArray = hit2D;
        int len$ = nArray.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] g;
            for (int j : g = nArray[i$]) {
                v.removeElement(j);
            }
        }
        if (excluded != null) {
            for (int j : excluded) {
                v.removeElement(j);
            }
        }
        return v.toArray();
    }

    private void collectCompIds(IntVector isolatedCompIds, IntVector connectedCompIds, IntVector explicitHCompIds, Molecule target, int[] targetToCompId) {
        for (int compId : targetToCompId) {
            if (compId == -1 || isolatedCompIds.contains(compId)) continue;
            isolatedCompIds.add(compId);
        }
        for (int j = target.getBondCount() - 1; j >= 0; --j) {
            int compId2;
            MolBond targetBond = target.getBond(j);
            MolAtom atom1 = targetBond.getAtom1();
            MolAtom atom2 = targetBond.getAtom2();
            int compId1 = targetToCompId[target.indexOf(atom1)];
            if (compId1 == (compId2 = targetToCompId[target.indexOf(atom2)])) continue;
            if (compId1 != -1) {
                if (QueryModifier.isH(atom1) || QueryModifier.isH(atom2)) {
                    isolatedCompIds.removeElement(compId1);
                } else if (!connectedCompIds.contains(compId1)) {
                    isolatedCompIds.removeElement(compId1);
                    connectedCompIds.add(compId1);
                }
            }
            if (compId2 == -1) continue;
            if (QueryModifier.isH(atom1) || QueryModifier.isH(atom2)) {
                isolatedCompIds.removeElement(compId2);
                continue;
            }
            if (connectedCompIds.contains(compId2)) continue;
            isolatedCompIds.removeElement(compId2);
            connectedCompIds.add(compId2);
        }
        for (int i = target.getAtomCount() - 1; i >= 0; --i) {
            int k;
            int compId;
            MolAtom atom = target.getAtom(i);
            if (!QueryModifier.isH(atom) || atom.getBondCount() != 1 || (compId = targetToCompId[i]) == -1 || targetToCompId[k = target.indexOf(atom.getLigand(0))] == compId) continue;
            explicitHCompIds.add(compId);
        }
    }

    private int[][] findQueryOrigToCompIds(int[][] hit2D, Molecule target, int[] targetToCompId, IntVector isolatedCompIds) {
        IntVector global = new IntVector();
        IntVector local = new IntVector();
        IntVector localH = new IntVector();
        IntVector localAll = new IntVector();
        int[][] queryOrigToCompIds = new int[this.origQuery.getAtomCount()][];
        for (int i = 0; i < queryOrigToCompIds.length; ++i) {
            if (this.queryOrigToModified[i] != -1) {
                queryOrigToCompIds[i] = new int[]{-2147483642};
                continue;
            }
            global.clear();
            MolAtom queryAtom = this.origQuery.getAtom(i);
            int queryBondCount = queryAtom.getBondCount();
            for (int j = 0; j < queryBondCount; ++j) {
                local.clear();
                localH.clear();
                MolBond queryBond = queryAtom.getBond(j);
                MolAtom queryLigand = queryBond.getOtherAtom(queryAtom);
                int modifiedQueryLigandIndex = this.queryOrigToModified[this.origQuery.indexOf(queryLigand)];
                assert (hit2D[modifiedQueryLigandIndex].length == 1 || QueryModifier.getNumberOfNonRGroups(target, hit2D[modifiedQueryLigandIndex]) == 1);
                int ligandIndexInTarget = hit2D[modifiedQueryLigandIndex][0];
                if (ligandIndexInTarget < 0) {
                    int heavyTargetAtomIndex;
                    int compId;
                    if (Search.areMatchingBondTypes(queryBond.getType(), 1) && (compId = targetToCompId[heavyTargetAtomIndex = ligandIndexInTarget == Integer.MIN_VALUE ? 0 : -ligandIndexInTarget]) >= 0) {
                        local.add(compId);
                    }
                } else {
                    localAll.clear();
                    MolAtom targetLigand = target.getAtom(ligandIndexInTarget);
                    for (int k = targetLigand.getBondCount() - 1; k >= 0; --k) {
                        int compId;
                        MolBond targetBond = targetLigand.getBond(k);
                        MolAtom targetAtom = targetBond.getOtherAtom(targetLigand);
                        int indexInTarget = target.indexOf(targetAtom);
                        if (indexInTarget >= targetToCompId.length || (compId = targetToCompId[indexInTarget]) < 0 || localAll.contains(compId)) continue;
                        localAll.add(compId);
                        if (!Search.areMatchingBondTypes(queryBond.getType(), targetBond.getType())) continue;
                        if (!QueryModifier.isH(targetAtom)) {
                            local.add(compId);
                            continue;
                        }
                        if (this.undefinedRAtom == 2) continue;
                        localH.add(compId);
                    }
                }
                local.addAll(localH);
                if (j == 0) {
                    global.addAll(local);
                } else {
                    for (int k = global.size() - 1; k >= 0; --k) {
                        if (local.contains(global.get(k))) continue;
                        global.remove(k);
                    }
                }
                if (global.isEmpty()) break;
            }
            if (queryBondCount == 0) {
                global.addAll(isolatedCompIds);
            }
            if (this.undefinedRAtom != 2) {
                int implHMatch = this.getImplicitHMatch(queryAtom, hit2D, target);
                if (implHMatch != -1) {
                    global.add(implHMatch == 0 ? Integer.MIN_VALUE : -implHMatch);
                }
                if (this.undefinedRAtom == 4 && queryAtom.getBondCount() <= 1) {
                    global.add(-2147483643);
                }
            }
            global.reverse();
            queryOrigToCompIds[i] = global.toArray();
        }
        return queryOrigToCompIds;
    }

    static boolean isH(MolAtom atom) {
        return atom.getAtno() == 1 && atom.getMassno() == 0;
    }

    private static int getExplicitHcount(MolAtom atom) {
        int n = 0;
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            if (!QueryModifier.isH(atom.getLigand(i))) continue;
            ++n;
        }
        return n;
    }

    private int getImplicitHMatch(MolAtom queryAtom, int[][] hit2D, Molecule target) {
        MolAtom heavyQueryLigand = null;
        for (int j = queryAtom.getBondCount() - 1; j >= 0; --j) {
            MolBond queryBond = queryAtom.getBond(j);
            MolAtom queryLigand = queryBond.getOtherAtom(queryAtom);
            if (queryLigand.getAtno() == 1 || !Search.areMatchingBondTypes(queryBond.getType(), 1)) continue;
            if (heavyQueryLigand == null) {
                heavyQueryLigand = queryLigand;
                continue;
            }
            return -1;
        }
        if (heavyQueryLigand == null) {
            return -1;
        }
        int modifiedHeavyQueryLigandIndex = this.queryOrigToModified[this.origQuery.indexOf(heavyQueryLigand)];
        assert (hit2D[modifiedHeavyQueryLigandIndex].length == 1 || QueryModifier.getNumberOfNonRGroups(target, hit2D[modifiedHeavyQueryLigandIndex]) == 1);
        int heavyLigandIndexInTarget = hit2D[modifiedHeavyQueryLigandIndex][0];
        MolAtom heavyTargetLigand = target.getAtom(heavyLigandIndexInTarget);
        return heavyTargetLigand.getImplicitHcount() > 0 ? heavyLigandIndexInTarget : -1;
    }

    private boolean fullFragmentMatchPossible(int[][] queryOrigToCompIds, IntVector connectedCompIds) {
        IntVector v = (IntVector)connectedCompIds.clone();
        int[][] arr$ = queryOrigToCompIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] ids;
            for (int id : ids = arr$[i$]) {
                if (id < 0) continue;
                v.removeElement(id);
            }
        }
        return v.isEmpty();
    }

    private boolean checkExtraGroupConnections(int[] queryOrigToCompId, int[] targetToCompId) {
        if (!QueryModifier.hasDefinedRgroup(this.origQuery)) {
            return true;
        }
        int c1 = this.getTargetTransitionCount(targetToCompId);
        int c2 = this.getQueryTransitionCount(queryOrigToCompId);
        if (logger.isLoggable(Level.FINE) && c1 != c2) {
            logger.fine("target transition count: " + c1 + "\nquery transition count: " + c2);
        }
        return c1 == c2;
    }

    private int getTargetTransitionCount(int[] targetToCompId) {
        int k = 0;
        for (int i = this.target.getBondCount() - 1; i >= 0; --i) {
            int i2;
            MolBond bond = this.target.getBond(i);
            int i1 = this.target.indexOf(bond.getAtom1());
            if (targetToCompId[i1] == targetToCompId[i2 = this.target.indexOf(bond.getAtom2())]) continue;
            ++k;
        }
        return k;
    }

    private int getQueryTransitionCount(int[] queryOrigToCompId) {
        int k = 0;
        for (int i = 0; i < queryOrigToCompId.length; ++i) {
            if (queryOrigToCompId[i] < 0) continue;
            k += this.origQuery.getAtom(i).getBondCount();
        }
        return k;
    }

    private static boolean hasDefinedRgroup(Molecule mol) {
        return mol instanceof RgMolecule && ((RgMolecule)mol).getRgroupCount() > 0;
    }

    private boolean setComponentNumbers(Molecule mol) {
        MolAtom fragAtom;
        int j;
        int fragId;
        int compNo;
        MolAtom atom;
        int i;
        if (this.undefinedRAtom == 4) {
            return true;
        }
        int[] fragIds = mol.findComponentIds();
        int maxCompNo = -1;
        for (i = mol.getAtomCount() - 1; i >= 0; --i) {
            atom = mol.getAtom(i);
            compNo = atom.getQPropAsInt("c");
            if (compNo == -1) continue;
            maxCompNo = Math.max(compNo, maxCompNo);
            fragId = fragIds[i];
            for (j = 0; j < fragIds.length; ++j) {
                if (fragIds[j] != fragId) continue;
                fragAtom = mol.getAtom(j);
                int fragCompNo = fragAtom.getQPropAsInt("c");
                if (fragCompNo == -1) {
                    fragAtom.setQProp("c", compNo);
                    continue;
                }
                if (fragCompNo == compNo) continue;
                return false;
            }
        }
        for (i = mol.getAtomCount() - 1; i >= 0; --i) {
            atom = mol.getAtom(i);
            compNo = atom.getQPropAsInt("c");
            if (compNo != -1) continue;
            ++maxCompNo;
            fragId = fragIds[i];
            for (j = 0; j < fragIds.length; ++j) {
                if (fragIds[j] != fragId) continue;
                fragAtom = mol.getAtom(j);
                fragAtom.setQProp("c", maxCompNo);
            }
        }
        return true;
    }

    private void setConnectionCounts(Molecule mol, Set<MolAtom> undefRs) {
        HashSet<MolAtom> undefRNeighborhood = new HashSet<MolAtom>(mol.getAtomCount());
        for (MolAtom r : undefRs) {
            undefRNeighborhood.add(r);
            for (int i = r.getBondCount() - 1; i >= 0; --i) {
                int s;
                MolAtom a = r.getLigand(i);
                undefRNeighborhood.add(a);
                if (a.getAtno() == 1 || (s = a.getQPropAsInt("s")) != -2 && (s != -1 || this.undefinedRAtom != 2)) continue;
                a.setQProp("s", a.getBondCount() - QueryModifier.getExplicitHcount(a));
            }
        }
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            int s;
            MolAtom a = mol.getAtom(i);
            if (undefRNeighborhood.contains(a) || a.getAtno() == 1 || (s = a.getQPropAsInt("s")) != -1) continue;
            a.setQProp("s", -2);
        }
    }

    public void clear() {
        this.origQuery = null;
        this.queryOrigToModified = null;
    }

    public boolean inited() {
        return this.origQuery != null;
    }

    public boolean modified() {
        return this.queryOrigToModified != null;
    }

    private String getOrigHitString(int[][] hit2D) {
        int[][] origHit2D = new int[this.queryOrigToModified.length][];
        for (int i = 0; i < this.queryOrigToModified.length; ++i) {
            int[] nArray;
            if (this.queryOrigToModified[i] != -1) {
                nArray = hit2D[this.queryOrigToModified[i]];
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = -2147483647;
            }
            origHit2D[i] = nArray;
        }
        return QueryModifier.arrayTo1BasedString(origHit2D, ",", " ");
    }

    private static int getNumberOfNonRGroups(Molecule mol, int[] hit) {
        int count = 0;
        for (int i : hit) {
            if (mol.getAtom(i).getAtno() == 134) continue;
            ++count;
        }
        return count;
    }

    private static String getGroupHitString(int[][] groupHit) {
        return QueryModifier.arrayTo1BasedString(groupHit, " ", "\n");
    }

    private static String getCompIdString(int[] array) {
        StringBuffer b = new StringBuffer();
        for (int c : array) {
            b.append(QueryModifier.getIdCode(c));
            b.append(" ");
        }
        return new String(b);
    }

    private static String getCompIdString(int[][] array) {
        StringBuffer b = new StringBuffer();
        for (int[] a : array) {
            if (a.length == 1) {
                b.append(QueryModifier.getIdCode(a[0]));
            } else {
                b.append("{" + StringUtil.arrayToString(a, ",") + "}");
            }
            b.append(" ");
        }
        return new String(b);
    }

    private static String getIdCode(int c) {
        String code = "";
        switch (c) {
            case -2147483642: {
                return "-";
            }
            case -2147483643: {
                return "E";
            }
        }
        return "" + c;
    }

    private static String arrayTo1BasedString(int[] arr, String sep) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                b.append(sep);
            }
            b.append(QueryModifier.getSymbol(arr[i]));
        }
        return new String(b);
    }

    private static String arrayTo1BasedString(int[][] arr, String sep1, String sep2) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                b.append(sep2);
            }
            for (int j = 0; j < arr[i].length; ++j) {
                if (j > 0) {
                    b.append(sep1);
                }
                b.append(QueryModifier.getSymbol(arr[i][j]));
            }
        }
        return new String(b);
    }

    private static int getSymbol(int c) {
        if (c == Integer.MIN_VALUE) {
            return -1;
        }
        return c >= 0 ? c + 1 : c - 1;
    }
}

