/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.rg;

import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.RgSearch;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.rg.RgMember;
import chemaxon.sss.search.rg.RgNode;
import chemaxon.sss.search.rg.RgSearchDescriptor;
import chemaxon.sss.search.rg.RgSearchUtil;
import chemaxon.sss.search.rg.RgSearcher;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Hashtable;

public class RgSearchSimple
implements RgSearcher {
    private RgSearchDescriptor descriptor;
    Molecule[] combinedMol;
    int[][] molCombination;
    int[][] rootMap;
    int rootAtomCount;
    SearchHit combinedMolHit;
    int currentCombination;
    private MolSearch molSearch;
    private RgSearch rgSearch;
    private Molecule target;
    private int[] excludedTargetAtoms;
    private String licenseEnvironment;

    public RgSearchSimple(String licenseEnvironment, RgSearch rgSearch, RgSearchDescriptor descriptor, Molecule target, int[] excludedTargetAtoms) {
        this.licenseEnvironment = licenseEnvironment;
        this.rgSearch = rgSearch;
        this.target = target;
        this.excludedTargetAtoms = excludedTargetAtoms;
        this.descriptor = descriptor;
        this.combinedMol = new Molecule[descriptor.combinations];
        this.molCombination = new int[descriptor.combinations][descriptor.rgnodes.size()];
        this.rootMap = new int[descriptor.combinations][];
        this.rootAtomCount = descriptor.root.getAtomCount();
        this.combinedMolHit = null;
        this.currentCombination = 0;
        this.initSearcher();
    }

    @Override
    public void setTarget(Molecule target, int[] excludedTargetAtoms) {
        this.target = target;
        this.excludedTargetAtoms = excludedTargetAtoms;
        this.currentCombination = 0;
        this.combinedMolHit = null;
        this.initSearcher();
    }

    private void initSearcher() {
        this.molSearch = new MolSearch();
        this.molSearch.setLicenseEnvironment(this.licenseEnvironment);
        this.molSearch.setSearchOptions(this.rgSearch.getSearchOptions());
        this.molSearch.setTarget(this.target, this.excludedTargetAtoms);
    }

    @Override
    public SearchHit findNext() throws SearchException {
        SearchHit hit = null;
        while (hit == null && this.currentCombination < this.descriptor.combinations) {
            if (this.combinedMolHit == null) {
                if (this.combinedMol[this.currentCombination] == null) {
                    this.calculateNextCombination();
                    this.buildCombinedMolecule();
                }
                this.molSearch.setQuery(this.combinedMol[this.currentCombination]);
            }
            try {
                hit = this.combinedMolHit = this.molSearch.findNextHit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (hit != null) {
                this.convertHitToGroupHit(hit);
                continue;
            }
            ++this.currentCombination;
        }
        return hit;
    }

    private void convertHitToGroupHit(SearchHit hit) {
        int index;
        int[] singleHitOld = hit.getSingleHit();
        int[][] groupHitOld = hit.getGroupHit();
        int[][] groupHitNew = new int[this.rootMap[this.currentCombination].length][];
        int[] singleHitNew = new int[this.rootMap[this.currentCombination].length];
        int[] groupSize = new int[this.rootMap[this.currentCombination].length + 1];
        for (index = 0; index < this.rootMap[this.currentCombination].length; ++index) {
            singleHitNew[index] = singleHitOld[RgSearchUtil.getRealId(this.rootMap[this.currentCombination][index], this.combinedMol[this.currentCombination])];
        }
        for (index = 0; index < singleHitOld.length; ++index) {
            int n = RgSearchUtil.getAtomID(this.combinedMol[this.currentCombination].getAtom(index));
            groupSize[n] = groupSize[n] + groupHitOld[index].length;
        }
        for (index = 1; index <= groupHitNew.length; ++index) {
            groupHitNew[index - 1] = new int[groupSize[index]];
            groupSize[index] = 0;
        }
        for (int index2 = 0; index2 < singleHitOld.length; ++index2) {
            for (int atomIndex = 0; atomIndex < groupHitOld[index2].length; ++atomIndex) {
                int cIndex = RgSearchUtil.getAtomID(this.combinedMol[this.currentCombination].getAtom(index2));
                groupHitNew[cIndex - 1][groupSize[cIndex]] = groupHitOld[index2][atomIndex];
                int n = cIndex;
                groupSize[n] = groupSize[n] + 1;
            }
        }
        hit.setSingleHit(singleHitNew);
        hit.setGroupHit(groupHitNew);
    }

    private void buildCombinedMolecule() {
        this.combinedMol[this.currentCombination] = this.descriptor.root.cloneMolecule();
        this.rootAtomCount = this.combinedMol[this.currentCombination].getAtomCount();
        this.rootMap[this.currentCombination] = new int[this.rootAtomCount];
        for (int atomIndex = 0; atomIndex < this.rootAtomCount; ++atomIndex) {
            this.rootMap[this.currentCombination][atomIndex] = RgSearchUtil.getAtomID(this.combinedMol[this.currentCombination].getAtom(atomIndex));
        }
        Hashtable<MolAtom, Object[]> substParities = new Hashtable<MolAtom, Object[]>();
        Hashtable<Integer, int[]> rootParities = new Hashtable<Integer, int[]>();
        this.combinedMol[this.currentCombination].setDim(0);
        RgSearchUtil.storeRootParities(this.combinedMol[this.currentCombination], rootParities);
        int rgCount = this.descriptor.rgnodes.size();
        for (int rgnodeIndex = 0; rgnodeIndex < rgCount; ++rgnodeIndex) {
            RgNode rgnode = this.descriptor.rgnodes.get(rgnodeIndex);
            RgMember rgmember = this.descriptor.rgroups[rgnode.group - 1].members.get(this.molCombination[this.currentCombination][rgnodeIndex]);
            Molecule memberMol = rgmember.getMolecule().cloneMolecule();
            memberMol.setDim(0);
            RgSearchUtil.storeSubstParities(memberMol, substParities);
            RgSearchUtil.mergeMols2(this.combinedMol[this.currentCombination], rgnode.map, memberMol, rgmember.attIndex);
            RgSearchUtil.changeParityIfNeeded(this.combinedMol[this.currentCombination], rootParities, substParities);
        }
    }

    private void calculateNextCombination() {
        int combinationIndex = this.currentCombination;
        for (int rgnodeIndex = this.molCombination[this.currentCombination].length - 1; rgnodeIndex >= 0; --rgnodeIndex) {
            int nodeId = this.descriptor.rgnodes.get((int)rgnodeIndex).group - 1;
            int memberCount = this.descriptor.rgroups[nodeId].members.size();
            this.molCombination[this.currentCombination][rgnodeIndex] = combinationIndex % memberCount;
            combinationIndex /= memberCount;
        }
    }
}

