/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.rg;

import chemaxon.common.util.ArrayTools;
import chemaxon.sss.search.rg.RgNode;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class RgSearchUtil {
    public static final int MAX_COMBINATIONS_FOR_SIMPLE_CASE = 10;
    private static final String ID_PROP_NAME = "rgsearch_id";

    public static void autoMap(Molecule m) {
        int atomCount = m.getAtomCount();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            RgSearchUtil.setAtomID(m.getAtom(atomIndex), atomIndex + 1);
        }
    }

    public static void setAtomID(MolAtom atom, int id) {
        atom.setQProp(ID_PROP_NAME, id);
    }

    public static int getAtomID(MolAtom atom) {
        Object prop = atom.getQProp(ID_PROP_NAME);
        if (prop != null) {
            return (Integer)prop;
        }
        return 0;
    }

    public static boolean isRelevantCT(int flag) {
        return (((flag &= 0x1C0) & 0x80) > 0 || (flag & 0x40) > 0) && (flag & 0xC0) != 192;
    }

    public static int getHighestLigand(Molecule m, int index) {
        int[] ligs = m.getCtab()[index];
        int max = -1;
        for (int ligIndex = 0; ligIndex < ligs.length; ++ligIndex) {
            if (ligs[ligIndex] <= max) continue;
            max = ligs[ligIndex];
        }
        return max;
    }

    public static boolean hasExplicitH(Molecule m) {
        MoleculeGraph mol = m.getGraphUnion();
        int atomCount = mol.getAtomCount();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            if (mol.getAtom(atomIndex).getAtno() != 1) continue;
            return true;
        }
        return false;
    }

    public static int[] getHomologyRgrHit(ArrayList<RgNode> rgnodes, int x) {
        for (RgNode rn : rgnodes) {
            if (rn.idx != x) continue;
            for (int[] hit : rn.validHits) {
                if (hit.length <= 0) continue;
                return hit;
            }
        }
        return null;
    }

    public static int compareChiralities(int qPar, int tPar, int qSign, int tSign, int queryAtomStereo, int targetAtomStereo, boolean exactMatch) {
        if (exactMatch) {
            if (queryAtomStereo == 32 && targetAtomStereo == 32 && (qPar & 4) == (tPar & 4)) {
                return qPar == tPar == (qSign == tSign) ? 1 : -1;
            }
            return queryAtomStereo == targetAtomStereo ? 2 : 0;
        }
        switch (queryAtomStereo) {
            case 0: {
                return 1;
            }
            case 64: {
                return targetAtomStereo != 0 ? 2 : 0;
            }
        }
        if ((qPar & 4) != 0) {
            if (targetAtomStereo != 32) {
                return 1;
            }
            return qPar == tPar == (qSign == tSign) ? 1 : -1;
        }
        if (targetAtomStereo != 32) {
            return 0;
        }
        return qPar == tPar == (qSign == tSign) ? 1 : -1;
    }

    public static void printHit(int[] hit) {
        StringBuffer sbHit = new StringBuffer();
        for (int j = 0; j < hit.length; ++j) {
            sbHit.append(hit[j] + " ");
        }
        System.out.println(sbHit.toString());
    }

    public static void printHits(int[][] hits) {
        if (hits == null) {
            System.out.println("No hits");
        } else {
            for (int i = 0; i < hits.length; ++i) {
                System.out.print("Hit " + (i + 1) + ":  ");
                int[] hit = hits[i];
                RgSearchUtil.printHit(hit);
            }
        }
    }

    public static boolean rNodesAreUnique(Molecule mol) {
        HashSet<Integer> rNumbers = new HashSet<Integer>();
        int atomCount = mol.getAtomCount();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            MolAtom atom = mol.getAtom(atomIndex);
            if (atom.getAtno() != 134) continue;
            int rNum = atom.getRgroup();
            if (rNumbers.contains(rNum)) {
                return false;
            }
            rNumbers.add(rNum);
        }
        return true;
    }

    public static int getRealId(int mapId, Molecule m) {
        int atomCount = m.getAtomCount();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            MolAtom atom = m.getAtom(atomIndex);
            int map = RgSearchUtil.getAtomID(atom);
            if (map != mapId) continue;
            return atomIndex;
        }
        return -1;
    }

    public static boolean isMatchingCT(int queryFlag, int targetFlag, boolean exactMatch) {
        if (exactMatch && (queryFlag &= 0x1C0) != targetFlag) {
            return false;
        }
        if ((queryFlag & 0x80) > 0 && (queryFlag & 0x40) > 0) {
            return true;
        }
        if (!((queryFlag & 0x100) <= 0 || (targetFlag & 0x200) <= 0 && RgSearchUtil.isRelevantCT(targetFlag))) {
            return true;
        }
        return (queryFlag & 0xFFFFFEFF) == (targetFlag & 0x1C0);
    }

    public static void mergeMols(Molecule root, int rootAtomMap, Molecule subst, int[] substAtoms) {
        root.fuse(subst);
        MolAtom ra = root.getAtom(RgSearchUtil.getRealId(rootAtomMap, root));
        int edgeCount = ra.getBondCount();
        int substNum = 1;
        substNum = substAtoms[1] == -1 || substAtoms[0] == substAtoms[1] ? 1 : 2;
        if (edgeCount > 2) {
            System.err.println("Too many ligands on R-node: " + edgeCount);
            return;
        }
        int priID = 0;
        if (substNum == 2) {
            int minMap = Integer.MAX_VALUE;
            for (int index = 0; index < 2; ++index) {
                MolAtom atom = ra.getLigand(index);
                int map = RgSearchUtil.getAtomID(atom);
                if (map >= minMap) continue;
                priID = index;
                minMap = map;
            }
        }
        for (int edgeIndex = 0; edgeIndex < edgeCount; ++edgeIndex) {
            MolBond bond = ra.getBond(edgeIndex);
            MolAtom ligand = ra.getLigand(edgeIndex);
            int flags = bond.getFlags();
            int idx = 0;
            idx = edgeIndex == priID ? substAtoms[0] : substAtoms[1];
            MolAtom newAtom = subst.getAtom(idx);
            RgSearchUtil.setAtomID(newAtom, RgSearchUtil.getAtomID(ra));
            root.add(new MolBond(ligand, newAtom, flags));
        }
        if (edgeCount == 0) {
            RgSearchUtil.setAtomID(subst.getAtom(substAtoms[0]), RgSearchUtil.getAtomID(ra));
        }
        root.removeAtom(ra);
    }

    public static void mergeMols2(Molecule root, int rootAtomMap, Molecule subst, int[] substAtoms) {
        root.fuse(subst);
        MolAtom ra = root.getAtom(RgSearchUtil.getRealId(rootAtomMap, root));
        int edgeCount = ra.getBondCount();
        int substNum = 1;
        substNum = substAtoms[1] == -1 || substAtoms[0] == substAtoms[1] ? 1 : 2;
        if (edgeCount > 2) {
            System.err.println("Too many ligands on R-node: " + edgeCount);
            return;
        }
        int priID = 0;
        if (substNum == 2) {
            int minMap = Integer.MAX_VALUE;
            for (int index = 0; index < 2; ++index) {
                MolAtom atom = ra.getLigand(index);
                int map = RgSearchUtil.getAtomID(atom);
                if (map >= minMap) continue;
                priID = index;
                minMap = map;
            }
        }
        for (int edgeIndex = 0; edgeIndex < edgeCount; ++edgeIndex) {
            MolBond bond = ra.getBond(edgeIndex);
            MolAtom ligand = ra.getLigand(edgeIndex);
            int flags = bond.getFlags();
            int idx = 0;
            idx = edgeIndex == priID ? substAtoms[0] : substAtoms[1];
            MolAtom newAtom = subst.getAtom(idx);
            root.add(new MolBond(ligand, newAtom, flags));
        }
        int atomID = RgSearchUtil.getAtomID(ra);
        for (int atomIndex = subst.getAtomCount() - 1; atomIndex >= 0; --atomIndex) {
            RgSearchUtil.setAtomID(subst.getAtom(atomIndex), atomID);
        }
        root.removeAtom(ra);
    }

    public static void removeRgroups(Molecule m) {
        int atomCount = m.getAtomCount();
        for (int atomIndex = atomCount - 1; atomIndex >= 0; --atomIndex) {
            MolAtom atom = m.getAtom(atomIndex);
            if (atom.getAtno() != 134) continue;
            m.removeAtom(atomIndex);
        }
    }

    public static boolean haveCommonNumbers(int[] arr1, int[] arr2) {
        int[] array1 = (int[])arr1.clone();
        int[] array2 = (int[])arr2.clone();
        Arrays.sort(array1);
        Arrays.sort(array2);
        int a = 0;
        int b = 0;
        while (a < array1.length && b < array2.length) {
            if (array1[a] < array2[b]) {
                ++a;
                continue;
            }
            if (array2[b] < array1[a]) {
                ++b;
                continue;
            }
            return true;
        }
        return false;
    }

    public static int getRNodeLigandsCount(MolAtom atom) {
        int ligands = atom.getBondCount();
        int result = 0;
        for (int ligandIndex = 0; ligandIndex < ligands; ++ligandIndex) {
            MolAtom ligand = atom.getLigand(ligandIndex);
            if (ligand.getAtno() != 134) continue;
            ++result;
        }
        return result;
    }

    public static boolean isNewHit(Vector<int[][]> list, int[][] hit) {
        for (int i = 0; i < list.size(); ++i) {
            boolean exists = true;
            for (int j = 0; exists && j < hit.length; ++j) {
                boolean found = false;
                for (int k = 0; !found && k < list.elementAt(i).length; ++k) {
                    if (list.elementAt(i)[k].length != hit[j].length) continue;
                    found = true;
                    for (int l = 0; l < hit[j].length; ++l) {
                        if (ArrayTools.contains(list.elementAt(i)[k], hit[j][l])) continue;
                        found = false;
                    }
                }
                if (found) continue;
                exists = false;
            }
            if (!exists) continue;
            return false;
        }
        return true;
    }

    public static void addNewHit(Vector<int[]> list, int[][] hit) {
        int sum = 0;
        for (int i = 0; i < hit.length; ++i) {
            sum += hit[i].length;
        }
        int[] newItem = new int[sum];
        int index = 0;
        for (int i = 0; i < hit.length; ++i) {
            for (int j = 0; j < hit[i].length; ++j) {
                newItem[index++] = hit[i][j];
            }
        }
        list.add(newItem);
    }

    public static void storeRootParities(Molecule mol, Hashtable<Integer, int[]> parities) {
        int atomCount = mol.getAtomCount();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            int parity = mol.getLocalParity(atomIndex);
            if (parity == 0) continue;
            int[] parityInfo = new int[6];
            int[] neighbours = new int[4];
            int pSign = RgSearchUtil.getParitySign(mol, atomIndex, neighbours);
            if (pSign == 0) continue;
            for (int y = 0; y < 4; ++y) {
                if (neighbours[y] == Integer.MAX_VALUE) continue;
                parityInfo[y + 2] = RgSearchUtil.getAtomID(mol.getAtom(neighbours[y]));
            }
            parityInfo[0] = parity;
            parityInfo[1] = pSign;
            int map = RgSearchUtil.getAtomID(mol.getAtom(atomIndex));
            parities.put(map, parityInfo);
        }
    }

    public static void storeSubstParities(Molecule mol, Hashtable<MolAtom, Object[]> parities) {
        int atomCount = mol.getAtomCount();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            int parity = mol.getLocalParity(atomIndex);
            if (parity == 0) continue;
            Object[] parityInfo = new Object[6];
            int[] neighbours = new int[4];
            int pSign = RgSearchUtil.getParitySign(mol, atomIndex, neighbours);
            if (pSign == 0) continue;
            for (int y = 0; y < 4; ++y) {
                if (neighbours[y] == Integer.MAX_VALUE) continue;
                parityInfo[y + 2] = mol.getAtom(neighbours[y]);
            }
            parityInfo[0] = parity;
            parityInfo[1] = pSign;
            MolAtom center = mol.getAtom(atomIndex);
            parities.put(center, parityInfo);
        }
    }

    private static int getParitySign(Molecule mol, int index, int[] neighbours) {
        int bondCount;
        MolAtom center = mol.getAtom(index);
        int impH = center.getImplicitHcount();
        if (impH + (bondCount = center.getBondCount()) == 4 && impH < 2) {
            int[] i = new int[4];
            for (int bondIndex = 0; bondIndex < bondCount; ++bondIndex) {
                MolAtom ligand = center.getLigand(bondIndex);
                int atno = ligand.getAtno();
                i[bondIndex] = atno == 1 ? Integer.MAX_VALUE : mol.indexOf(ligand);
            }
            if (impH == 1) {
                i[3] = Integer.MAX_VALUE;
            }
            for (int x = 0; x < 4; ++x) {
                neighbours[x] = i[x];
            }
            return MolAtom.paritySign(i[0], i[1], i[2], i[3]);
        }
        return 0;
    }

    public static void changeParityIfNeeded(Molecule mol, Hashtable<Integer, int[]> rootParities, Hashtable<MolAtom, Object[]> substParities) {
        int atomCount = mol.getAtomCount();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            int p;
            int ps;
            MolAtom atom = mol.getAtom(atomIndex);
            int map = RgSearchUtil.getAtomID(atom);
            int[] rp = rootParities.get(map);
            int[] idx = null;
            int sign = 0;
            int parity = 0;
            if (rp != null) {
                parity = rp[0];
                sign = rp[1];
                idx = new int[4];
                for (int y = 0; y < 4; ++y) {
                    idx[y] = rp[y + 2] != 0 ? RgSearchUtil.getRealId(rp[y + 2], mol) : Integer.MAX_VALUE;
                }
            } else {
                Object[] sp = substParities.get(atom);
                if (sp != null) {
                    idx = new int[4];
                    parity = (Integer)sp[0];
                    sign = (Integer)sp[1];
                    for (int y = 0; y < 4; ++y) {
                        MolAtom a = (MolAtom)sp[y + 2];
                        idx[y] = a != null ? mol.indexOf(a) : Integer.MAX_VALUE;
                    }
                }
            }
            if (idx == null || (ps = MolAtom.paritySign(idx[0], idx[1], idx[2], idx[3])) == sign == ((p = mol.getLocalParity(atomIndex)) == parity)) continue;
            if (p == 1) {
                mol.setParity(atomIndex, 2);
                continue;
            }
            if (p != 2) continue;
            mol.setParity(atomIndex, 1);
        }
    }

    public static int getHBondCount(Molecule mol) {
        int result = 0;
        int atomCount = mol.getAtomCount();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            MolAtom atom = mol.getAtom(atomIndex);
            if (atom.getAtno() != 1) continue;
            result += atom.getBondCount();
        }
        return result;
    }

    public static boolean getBit(int num, int index) {
        int mask = 1 << index;
        return (num & mask) > 0;
    }

    public static boolean containsNestedRgroup(RgMolecule rgMol) {
        int rgCount = rgMol.getRgroupCount();
        for (int rgIdx = 0; rgIdx < rgCount; ++rgIdx) {
            int memberCount = rgMol.getRgroupMemberCount(rgIdx);
            for (int memberIdx = 0; memberIdx < memberCount; ++memberIdx) {
                Molecule memberMol = rgMol.getRgroupMember(rgIdx, memberIdx);
                if (!RgSearchUtil.containsRgroup(memberMol)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsRgroup(Molecule mol) {
        int atomCount = mol.getAtomCount();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            if (mol.getAtom(atomIndex).getAtno() != 134) continue;
            return true;
        }
        return false;
    }
}

