/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.stat;

import chemaxon.stat.ResultProcessor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ResultDBWriter
implements ResultProcessor {
    PreparedStatement pstmt;
    int index = 0;
    int col = 0;
    long start = System.currentTimeMillis();

    ResultDBWriter(Connection conn, String sql) throws SQLException {
        this.pstmt = conn.prepareStatement(sql);
    }

    @Override
    public void printHeader(boolean printCentroid) {
    }

    @Override
    public void process(int id, int clusterid, int clustersize, boolean centroid, int numofneighbours) throws SQLException {
        this.pstmt.setInt(1, id);
        this.pstmt.setInt(2, clusterid);
        this.pstmt.setInt(3, centroid ? 1 : 0);
        this.pstmt.executeUpdate();
    }

    @Override
    public void process(int id, int clusterid, int clustersize, int numofneighbours) throws SQLException {
        this.pstmt.setInt(1, id);
        this.pstmt.setInt(2, clusterid);
        this.pstmt.executeUpdate();
    }

    @Override
    public void setInt(int value) throws SQLException {
        this.pstmt.setInt(++this.col, value);
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.pstmt.setFloat(++this.col, value);
    }

    @Override
    public void writeln() throws SQLException {
        this.pstmt.executeUpdate();
        this.col = 0;
    }

    @Override
    public void writeHeader(String line) {
    }

    protected void finalize() {
        try {
            this.pstmt.close();
        }
        catch (SQLException exc) {
            exc.printStackTrace();
        }
    }
}

