/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.CIPStereoDescriptorIface;
import chemaxon.struc.StereoActivePart;

public class AxialStereoDescriptor
implements CIPStereoDescriptorIface {
    private final StereoActivePart[] activeParts = new StereoActivePart[2];
    private final CIPStereoDescriptorIface.CIPValue.AxialStereoValue stereoValue;
    private final int centralAtomIndex;

    public AxialStereoDescriptor(CIPStereoDescriptorIface.CIPValue.AxialStereoValue value, int centralAtomIndex, StereoActivePart activePart1, StereoActivePart activePart2) {
        this.activeParts[0] = activePart1;
        this.activeParts[1] = activePart2;
        this.stereoValue = value;
        this.centralAtomIndex = centralAtomIndex;
    }

    @Override
    public StereoActivePart[] getStereoActiveParts() {
        return this.activeParts;
    }

    @Override
    public CIPStereoDescriptorIface.CIPValue.AxialStereoValue getStereoValue() {
        return this.stereoValue;
    }

    public int getCentralAtomIndex() {
        return this.centralAtomIndex;
    }

    public int hashCode() {
        int result = 101;
        switch (this.stereoValue) {
            case ODD: {
                break;
            }
            case EVEN: {
                result *= 2;
                break;
            }
            case UNKNOWN: {
                result *= 3;
                break;
            }
            case WIGGLY: {
                result *= 4;
                break;
            }
        }
        for (StereoActivePart sap : this.activeParts) {
            result += sap.hashCode();
        }
        return result += this.centralAtomIndex;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AxialStereoDescriptor)) {
            return false;
        }
        AxialStereoDescriptor other = (AxialStereoDescriptor)o;
        int minIndex = this.activeParts[0].getStereoActiveAtom() < this.activeParts[1].getStereoActiveAtom() ? 0 : 1;
        int maxIndex = 1 - minIndex;
        int otherMinIndex = other.activeParts[0].getStereoActiveAtom() < other.activeParts[1].getStereoActiveAtom() ? 0 : 1;
        int otherMaxIndex = 1 - otherMinIndex;
        return this.stereoValue == other.stereoValue && this.centralAtomIndex == other.centralAtomIndex && this.activeParts[minIndex].equals(other.activeParts[otherMinIndex]) && this.activeParts[maxIndex].equals(other.activeParts[otherMaxIndex]);
    }

    @Override
    public boolean equalsTo(Object o, int[] map) {
        if (o != null && o instanceof AxialStereoDescriptor) {
            AxialStereoDescriptor other = (AxialStereoDescriptor)o;
            if (map[this.centralAtomIndex] != other.centralAtomIndex) {
                return false;
            }
            if (this.getStereoActiveParts()[0].equalsTo(other.getStereoActiveParts()[0], map) && this.getStereoActiveParts()[1].equalsTo(other.getStereoActiveParts()[1], map) || this.getStereoActiveParts()[1].equalsTo(other.getStereoActiveParts()[0], map) && this.getStereoActiveParts()[0].equalsTo(other.getStereoActiveParts()[1], map)) {
                if (this.stereoValue == CIPStereoDescriptorIface.CIPValue.AxialStereoValue.UNKNOWN || other.stereoValue == CIPStereoDescriptorIface.CIPValue.AxialStereoValue.UNKNOWN || this.stereoValue == CIPStereoDescriptorIface.CIPValue.AxialStereoValue.WIGGLY || other.stereoValue == CIPStereoDescriptorIface.CIPValue.AxialStereoValue.WIGGLY) {
                    return this.stereoValue == other.stereoValue;
                }
                int[] firstPartLigands = this.getStereoActiveParts()[0].getLigands();
                int[] secondPartLigands = this.getStereoActiveParts()[1].getLigands();
                int inversion = 0;
                if (firstPartLigands.length < 2 && secondPartLigands.length < 2) {
                    return this.getStereoValue() == other.getStereoValue();
                }
                if (firstPartLigands.length == 2) {
                    int firstLow;
                    int firstHigh = firstPartLigands[0] > firstPartLigands[1] ? firstPartLigands[0] : firstPartLigands[1];
                    int n = firstLow = firstPartLigands[0] > firstPartLigands[1] ? firstPartLigands[1] : firstPartLigands[0];
                    if (map[firstHigh] < map[firstLow]) {
                        ++inversion;
                    }
                }
                if (secondPartLigands.length == 2) {
                    int secondLow;
                    int secondHigh = secondPartLigands[0] > secondPartLigands[1] ? secondPartLigands[0] : secondPartLigands[1];
                    int n = secondLow = secondPartLigands[0] > secondPartLigands[1] ? secondPartLigands[1] : secondPartLigands[0];
                    if (map[secondHigh] < map[secondLow]) {
                        ++inversion;
                    }
                }
                if (inversion % 2 == 1) {
                    return this.getStereoValue() != other.getStereoValue();
                }
                return this.getStereoValue() == other.getStereoValue();
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AX: ");
        sb.append(this.activeParts[0]);
        sb.append(",");
        sb.append(this.activeParts[1]);
        sb.append(" ");
        sb.append(this.stereoValue);
        return sb.toString();
    }
}

