/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class BicycloStereoDescriptor {
    private static final int TOWARDS_BRIDGE_1 = 1;
    private static final int TOWARDS_BRIDGE_2 = 2;
    public static final int TOWARDS_HIGHER_BRIDGE = 4;
    public static final int TOWARDS_LOWER_BRIDGE = 5;
    public static final int TOWARDS_EITHER_BRIDGE = 6;
    private int innerStereo;
    private MolAtom connectionAtom;
    MolAtom[] bridge1;
    MolAtom[] bridge2;

    BicycloStereoDescriptor() {
    }

    public BicycloStereoDescriptor(MolAtom connectionAtom, int stereoValue, MolAtom[] bridge1, MolAtom[] bridge2) {
        this.connectionAtom = connectionAtom;
        this.bridge1 = this.getHigherIndexed(bridge1, bridge2);
        this.bridge2 = this.getLowerIndexed(bridge1, bridge2);
        switch (stereoValue) {
            case 4: {
                this.innerStereo = 1;
                break;
            }
            case 5: {
                this.innerStereo = 2;
                break;
            }
            case 6: {
                this.innerStereo = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid stereo");
            }
        }
    }

    public MolAtom getConnectionAtom() {
        return this.connectionAtom;
    }

    public int getConnectionAtomIndex() {
        return this.connectionAtom.getParent().indexOf(this.connectionAtom);
    }

    public int getStereoValue() {
        if (this.innerStereo == 6) {
            return 6;
        }
        if (this.bridge1 == this.getHighBridgeAtoms()) {
            if (this.innerStereo == 1) {
                return 4;
            }
            return 5;
        }
        if (this.innerStereo == 1) {
            return 5;
        }
        return 4;
    }

    public MolAtom[] getHighBridgeAtoms() {
        return this.getHigherIndexed(this.bridge1, this.bridge2);
    }

    public MolAtom[] getLowBridgeAtoms() {
        return this.getLowerIndexed(this.bridge1, this.bridge2);
    }

    public int[] getHighBridgeAtomIndexes() {
        return this.getBridgeIndexes(this.getHighBridgeAtoms());
    }

    public int[] getLowBridgeAtomIndexes() {
        return this.getBridgeIndexes(this.getLowBridgeAtoms());
    }

    private MolAtom[] getHigherIndexed(MolAtom[] bridge1, MolAtom[] bridge2) {
        int bridge2HighestIndex;
        int bridge1HighestIndex = this.getHighestIndexOfBridge(bridge1);
        if (bridge1HighestIndex > (bridge2HighestIndex = this.getHighestIndexOfBridge(bridge2))) {
            return bridge1;
        }
        return bridge2;
    }

    private MolAtom[] getLowerIndexed(MolAtom[] bridge1, MolAtom[] bridge2) {
        int bridge2HighestIndex;
        int bridge1HighestIndex = this.getHighestIndexOfBridge(bridge1);
        if (bridge1HighestIndex > (bridge2HighestIndex = this.getHighestIndexOfBridge(bridge2))) {
            return bridge2;
        }
        return bridge1;
    }

    private int getHighestIndexOfBridge(MolAtom[] bridge) {
        int[] bridgeIndexes = this.getBridgeIndexes(bridge);
        int highest = bridgeIndexes[0];
        for (int i = 1; i < bridgeIndexes.length; ++i) {
            int next = bridgeIndexes[i];
            if (next <= highest) continue;
            highest = next;
        }
        return highest;
    }

    private int[] getBridgeIndexes(MolAtom[] bridge) {
        int[] result = new int[bridge.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = bridge[i].getParent().indexOf(bridge[i]);
        }
        return result;
    }

    void read(ObjectInputStream ois, MoleculeGraph parent) throws IOException, ClassNotFoundException {
        this.innerStereo = ois.readInt();
        this.connectionAtom = (MolAtom)ois.readObject();
        this.bridge1 = this.readAtoms(ois, parent);
        this.bridge2 = this.readAtoms(ois, parent);
    }

    private MolAtom[] readAtoms(ObjectInputStream ois, MoleculeGraph parent) throws IOException, ClassNotFoundException {
        int atomCount = ois.readInt();
        MolAtom[] atoms = new MolAtom[atomCount];
        for (int i = 0; i < atomCount; ++i) {
            atoms[i] = (MolAtom)ois.readObject();
        }
        return atoms;
    }

    void write(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.innerStereo);
        oos.writeObject(this.getConnectionAtom());
        this.writeAtoms(oos, this.bridge1);
        this.writeAtoms(oos, this.bridge2);
    }

    private void writeAtoms(ObjectOutputStream oos, MolAtom[] atoms) throws IOException {
        int size = atoms != null ? atoms.length : 0;
        oos.writeInt(size);
        if (size > 0) {
            for (int i = 0; i < atoms.length; ++i) {
                oos.writeObject(atoms[i]);
            }
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        buff.append(this.getConnectionAtomIndex());
        buff.append(", ");
        switch (this.getStereoValue()) {
            case 5: {
                buff.append("TLB, ");
                break;
            }
            case 4: {
                buff.append("THB, ");
                break;
            }
            case 6: {
                buff.append("TEB, ");
                break;
            }
        }
        buff.append("[");
        int[] lowBridge = this.getLowBridgeAtomIndexes();
        Arrays.sort(lowBridge);
        for (int i : lowBridge) {
            buff.append(Integer.toString(i));
            buff.append(" ");
        }
        buff.append("], [");
        int[] highBridge = this.getHighBridgeAtomIndexes();
        Arrays.sort(highBridge);
        for (int i : highBridge) {
            buff.append(Integer.toString(i));
            buff.append(" ");
        }
        buff.append("]");
        buff.append("]");
        return buff.toString();
    }

    private boolean equalsArrays(int[] list1, int[] list2) {
        Arrays.sort(list1);
        Arrays.sort(list2);
        return Arrays.equals(list1, list2);
    }

    public boolean compareTo(BicycloStereoDescriptor bicycloStereoDescriptor) {
        return this.getStereoValue() == bicycloStereoDescriptor.getStereoValue() && this.equalsArrays(this.getHighBridgeAtomIndexes(), bicycloStereoDescriptor.getHighBridgeAtomIndexes()) && this.equalsArrays(this.getLowBridgeAtomIndexes(), bicycloStereoDescriptor.getLowBridgeAtomIndexes()) && this.getConnectionAtomIndex() == bicycloStereoDescriptor.getConnectionAtomIndex();
    }
}

