/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.DPoint3;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CTransform3D
implements Externalizable {
    private static final long serialVersionUID = 0L;
    public transient double m00;
    public transient double m01;
    public transient double m02;
    public transient double m03;
    public transient double m10;
    public transient double m11;
    public transient double m12;
    public transient double m13;
    public transient double m20;
    public transient double m21;
    public transient double m22;
    public transient double m23;
    public transient double m30;
    public transient double m31;
    public transient double m32;
    public transient double m33;

    public CTransform3D(CTransform3D t) {
        this.set(t);
    }

    public CTransform3D() {
        this.setIdentity();
    }

    public void set(CTransform3D t) {
        this.m00 = t.m00;
        this.m01 = t.m01;
        this.m02 = t.m02;
        this.m03 = t.m03;
        this.m10 = t.m10;
        this.m11 = t.m11;
        this.m12 = t.m12;
        this.m13 = t.m13;
        this.m20 = t.m20;
        this.m21 = t.m21;
        this.m22 = t.m22;
        this.m23 = t.m23;
        this.m30 = t.m30;
        this.m31 = t.m31;
        this.m32 = t.m32;
        this.m33 = t.m33;
    }

    public final void setZero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 0.0;
    }

    public final void setIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final double[] getEuler() {
        double phi;
        double theta = Math.asin(-this.m20);
        double cosTheta = Math.cos(theta);
        double d = phi = this.m10 * this.m10 + this.m20 * this.m20 > 1.0E-30 ? Math.atan2(this.m10, this.m00) : 0.0;
        double psi = this.m21 * this.m21 + this.m22 * this.m22 > 1.0E-30 ? (cosTheta > 0.0 ? Math.atan2(this.m21, this.m22) : Math.atan2(-this.m21, -this.m22)) : 0.0;
        return new double[]{psi, theta, phi};
    }

    public final void setEuler(double psi, double theta, double phi) {
        double sinPsi = Math.sin(psi);
        double sinTheta = Math.sin(theta);
        double sinPhi = Math.sin(phi);
        double cosPsi = Math.cos(psi);
        double cosTheta = Math.cos(theta);
        double cosPhi = Math.cos(phi);
        this.m00 = cosTheta * cosPhi;
        this.m01 = -(cosPsi * sinPhi) + sinPsi * sinTheta * cosPhi;
        this.m02 = sinPsi * sinPhi + cosPsi * sinTheta * cosPhi;
        this.m10 = cosTheta * sinPhi;
        this.m11 = cosPsi * cosPhi + sinPsi * sinTheta * sinPhi;
        this.m12 = -(sinPsi * cosPhi) + cosPsi * sinTheta * sinPhi;
        this.m20 = -sinTheta;
        this.m21 = sinPsi * cosTheta;
        this.m22 = cosPsi * cosTheta;
        this.m33 = 1.0;
        this.m32 = 0.0;
        this.m31 = 0.0;
        this.m30 = 0.0;
        this.m23 = 0.0;
        this.m13 = 0.0;
        this.m03 = 0.0;
    }

    public final double getScale() {
        double c = this.determinant();
        return c < 0.0 ? -Math.pow(-c, 0.3333333333333333) : Math.pow(c, 0.3333333333333333);
    }

    public final void setScale(double scale) {
        double c = scale / this.getScale();
        this.m00 *= c;
        this.m01 *= c;
        this.m02 *= c;
        this.m10 *= c;
        this.m11 *= c;
        this.m12 *= c;
        this.m20 *= c;
        this.m21 *= c;
        this.m22 *= c;
    }

    public final double determinant() {
        return this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20);
    }

    public final double determinant2D() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public final void setRotation(double nx, double ny, double nz, double phi) {
        double r = Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (r == 0.0) {
            nx = 0.0;
            ny = 0.0;
            nz = 0.0;
        } else {
            nx /= r;
            ny /= r;
            nz /= r;
        }
        double c = Math.cos(phi);
        double s = Math.sin(phi);
        double a = 1.0 - c;
        this.m00 = a * nx * nx + c;
        this.m01 = a * nx * ny - s * nz;
        this.m02 = a * nx * nz + s * ny;
        this.m10 = a * nx * ny + s * nz;
        this.m11 = a * ny * ny + c;
        this.m12 = a * ny * nz - s * nx;
        this.m20 = a * nx * nz - s * ny;
        this.m21 = a * ny * nz + s * nx;
        this.m22 = a * nz * nz + c;
    }

    public final void setRotationCenter(DPoint3 o) {
        this.m03 = o.x - this.m00 * o.x - this.m01 * o.y - this.m02 * o.z;
        this.m13 = o.y - this.m10 * o.x - this.m11 * o.y - this.m12 * o.z;
        this.m23 = o.z - this.m20 * o.x - this.m21 * o.y - this.m22 * o.z;
    }

    public final void setTranslation(DPoint3 p) {
        this.m03 = p.x;
        this.m13 = p.y;
        this.m23 = p.z;
    }

    public final void setTranslation(double x0, double y0, double z0) {
        this.m03 = x0;
        this.m13 = y0;
        this.m23 = z0;
    }

    public final void transform(DPoint3 p) {
        double x = p.x;
        double y = p.y;
        double z = p.z;
        p.x = this.m00 * x + this.m01 * y + this.m02 * z + this.m03;
        p.y = this.m10 * x + this.m11 * y + this.m12 * z + this.m13;
        p.z = this.m20 * x + this.m21 * y + this.m22 * z + this.m23;
    }

    public final void mul(CTransform3D b) {
        double x00 = this.m00 * b.m00 + this.m01 * b.m10 + this.m02 * b.m20 + this.m03 * b.m30;
        double x01 = this.m00 * b.m01 + this.m01 * b.m11 + this.m02 * b.m21 + this.m03 * b.m31;
        double x02 = this.m00 * b.m02 + this.m01 * b.m12 + this.m02 * b.m22 + this.m03 * b.m32;
        double x03 = this.m00 * b.m03 + this.m01 * b.m13 + this.m02 * b.m23 + this.m03 * b.m33;
        double x10 = this.m10 * b.m00 + this.m11 * b.m10 + this.m12 * b.m20 + this.m13 * b.m30;
        double x11 = this.m10 * b.m01 + this.m11 * b.m11 + this.m12 * b.m21 + this.m13 * b.m31;
        double x12 = this.m10 * b.m02 + this.m11 * b.m12 + this.m12 * b.m22 + this.m13 * b.m32;
        double x13 = this.m10 * b.m03 + this.m11 * b.m13 + this.m12 * b.m23 + this.m13 * b.m33;
        double x20 = this.m20 * b.m00 + this.m21 * b.m10 + this.m22 * b.m20 + this.m23 * b.m30;
        double x21 = this.m20 * b.m01 + this.m21 * b.m11 + this.m22 * b.m21 + this.m23 * b.m31;
        double x22 = this.m20 * b.m02 + this.m21 * b.m12 + this.m22 * b.m22 + this.m23 * b.m32;
        double x23 = this.m20 * b.m03 + this.m21 * b.m13 + this.m22 * b.m23 + this.m23 * b.m33;
        double x30 = this.m30 * b.m00 + this.m31 * b.m10 + this.m32 * b.m20 + this.m33 * b.m30;
        double x31 = this.m30 * b.m01 + this.m31 * b.m11 + this.m32 * b.m21 + this.m33 * b.m31;
        double x32 = this.m30 * b.m02 + this.m31 * b.m12 + this.m32 * b.m22 + this.m33 * b.m32;
        double x33 = this.m30 * b.m03 + this.m31 * b.m13 + this.m32 * b.m23 + this.m33 * b.m33;
        this.m00 = x00;
        this.m01 = x01;
        this.m02 = x02;
        this.m03 = x03;
        this.m10 = x10;
        this.m11 = x11;
        this.m12 = x12;
        this.m13 = x13;
        this.m20 = x20;
        this.m21 = x21;
        this.m22 = x22;
        this.m23 = x23;
        this.m30 = x30;
        this.m31 = x31;
        this.m32 = x32;
        this.m33 = x33;
    }

    public boolean is3d() {
        return this.m20 != 0.0 || this.m21 != 0.0 || this.m23 != 0.0;
    }

    public final void invert() {
        double b00 = 1.0;
        double b01 = 0.0;
        double b02 = 0.0;
        double b03 = 0.0;
        double b10 = 0.0;
        double b11 = 1.0;
        double b12 = 0.0;
        double b13 = 0.0;
        double b20 = 0.0;
        double b21 = 0.0;
        double b22 = 1.0;
        double b23 = 0.0;
        double b30 = 0.0;
        double b31 = 0.0;
        double b32 = 0.0;
        double b33 = 1.0;
        double x00 = this.m00;
        double x01 = this.m01;
        double x02 = this.m02;
        double x03 = this.m03;
        double q = this.m10 / x00;
        double x10 = this.m10 - q * this.m00;
        b10 -= q * b00;
        double x11 = this.m11 - q * this.m01;
        b11 -= q * b01;
        double x12 = this.m12 - q * this.m02;
        b12 -= q * b02;
        double x13 = this.m13 - q * this.m03;
        b13 -= q * b03;
        q = this.m20 / x00;
        double x20 = this.m20 - q * this.m00;
        b20 -= q * b00;
        double x21 = this.m21 - q * this.m01;
        b21 -= q * b01;
        double x22 = this.m22 - q * this.m02;
        b22 -= q * b02;
        double x23 = this.m23 - q * this.m03;
        b23 -= q * b03;
        q = this.m30 / x00;
        double x30 = this.m30 - q * this.m00;
        b30 -= q * b00;
        double x31 = this.m31 - q * this.m01;
        b31 -= q * b01;
        double x32 = this.m32 - q * this.m02;
        b32 -= q * b02;
        double x33 = this.m33 - q * this.m03;
        b33 -= q * b03;
        q = x21 / x11;
        x20 -= q * x10;
        b20 -= q * b10;
        x21 -= q * x11;
        b21 -= q * b11;
        x22 -= q * x12;
        b22 -= q * b12;
        x23 -= q * x13;
        b23 -= q * b13;
        q = x31 / x11;
        x30 -= q * x10;
        b30 -= q * b10;
        x31 -= q * x11;
        b31 -= q * b11;
        x32 -= q * x12;
        b32 -= q * b12;
        x33 -= q * x13;
        b33 -= q * b13;
        q = x32 / x22;
        x30 -= q * x20;
        b30 -= q * b20;
        x31 -= q * x21;
        b31 -= q * b21;
        x32 -= q * x22;
        b32 -= q * b22;
        b33 -= q * b23;
        this.m30 = b30 / (x33 -= q * x23);
        this.m20 = (b20 - x23 * this.m30) / x22;
        this.m10 = (b10 - x12 * this.m20 - x13 * this.m30) / x11;
        this.m00 = (b00 - x01 * this.m10 - x02 * this.m20 - x03 * this.m30) / x00;
        this.m31 = b31 / x33;
        this.m21 = (b21 - x23 * this.m31) / x22;
        this.m11 = (b11 - x12 * this.m21 - x13 * this.m31) / x11;
        this.m01 = (b01 - x01 * this.m11 - x02 * this.m21 - x03 * this.m31) / x00;
        this.m32 = b32 / x33;
        this.m22 = (b22 - x23 * this.m32) / x22;
        this.m12 = (b12 - x12 * this.m22 - x13 * this.m32) / x11;
        this.m02 = (b02 - x01 * this.m12 - x02 * this.m22 - x03 * this.m32) / x00;
        this.m33 = b33 / x33;
        this.m23 = (b23 - x23 * this.m33) / x22;
        this.m13 = (b13 - x12 * this.m23 - x13 * this.m33) / x11;
        this.m03 = (b03 - x01 * this.m13 - x02 * this.m23 - x03 * this.m33) / x00;
    }

    public String toString() {
        return "[[" + this.m00 + ", " + this.m01 + ", " + this.m02 + ", " + this.m03 + "],\n" + " [" + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m13 + "],\n" + " [" + this.m20 + ", " + this.m21 + ", " + this.m22 + ", " + this.m23 + "],\n" + " [" + this.m30 + ", " + this.m31 + ", " + this.m32 + ", " + this.m33 + "]]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        this.write16doubles(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        byte version = in.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize transformation matrix with future version (" + version + ")");
        }
        this.read16doubles(in);
    }

    public final void write16doubles(ObjectOutput out) throws IOException {
        double[] x = this.toArray();
        for (int i = 0; i < 16; ++i) {
            out.writeDouble(x[i]);
        }
    }

    public final void read16doubles(ObjectInput in) throws IOException {
        double[] m = new double[16];
        for (int i = 0; i < 16; ++i) {
            m[i] = in.readDouble();
        }
        this.fromArray(m);
    }

    public final void write16floats(ObjectOutput out) throws IOException {
        double[] x = this.toArray();
        for (int i = 0; i < 16; ++i) {
            out.writeFloat((float)x[i]);
        }
    }

    public final void read16floats(ObjectInput in) throws IOException {
        double[] m = new double[16];
        for (int i = 0; i < 16; ++i) {
            m[i] = in.readFloat();
        }
        this.fromArray(m);
    }

    private double[] toArray() {
        double[] m = new double[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33};
        return m;
    }

    private void fromArray(double[] m) {
        this.m00 = m[0];
        this.m01 = m[1];
        this.m02 = m[2];
        this.m03 = m[3];
        this.m10 = m[4];
        this.m11 = m[5];
        this.m12 = m[6];
        this.m13 = m[7];
        this.m20 = m[8];
        this.m21 = m[9];
        this.m22 = m[10];
        this.m23 = m[11];
        this.m30 = m[12];
        this.m31 = m[13];
        this.m32 = m[14];
        this.m33 = m[15];
    }
}

