/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DPoint3
implements Cloneable,
Externalizable {
    private static final long serialVersionUID = 0L;
    public transient double x;
    public transient double y;
    public transient double z;

    public DPoint3() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public DPoint3(DPoint3 p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public DPoint3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(DPoint3 p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public boolean equals(Object o) {
        if (o instanceof DPoint3) {
            DPoint3 p = (DPoint3)o;
            return this.x == p.x && this.y == p.y && this.z == p.z;
        }
        return false;
    }

    public final double distance(DPoint3 p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        double dz = this.z - p.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public final double distance2D(DPoint3 p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public final double angle2D(double x2, double y2) {
        double dx = x2 - this.x;
        double dy = y2 - this.y;
        return dx < -1.0E-7 || dx > 1.0E-7 || dy < -1.0E-7 || dy > 1.0E-7 ? Math.atan2(dy, dx) : 0.0;
    }

    public Object clone() {
        return new DPoint3(this.x, this.y, this.z);
    }

    public String toString() {
        return "DPoint3(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
    }

    public void subtract(DPoint3 v2) {
        this.x -= v2.x;
        this.y -= v2.y;
        this.z -= v2.z;
    }

    public double angle3D(DPoint3 p) {
        double length = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        length = length < 1.0E-10 ? 1.0E-10 : length;
        double p_length = Math.sqrt(p.x * p.x + p.y * p.y + p.z * p.z);
        p_length = p_length < 1.0E-10 ? 1.0E-10 : p_length;
        double dotproduct = this.x * p.x + this.y * p.y + this.z * p.z;
        return Math.acos(dotproduct / length / p_length);
    }

    public static DPoint3 cross(DPoint3 v1, DPoint3 v2) {
        return new DPoint3(v1.y * v2.z - v1.z * v2.y, v1.z * v2.x - v1.x * v2.z, v1.x * v2.y - v1.y * v2.x);
    }

    public static DPoint3 add(DPoint3 v1, DPoint3 v2) {
        return new DPoint3(v1.x + v2.x, v1.y + v2.y, v1.z + v2.z);
    }

    public void add(DPoint3 v1) {
        this.x += v1.x;
        this.y += v1.y;
        this.z += v1.z;
    }
}

