/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.common.util.LongVector;
import chemaxon.core.spi.StructureExporterIface;
import chemaxon.core.spi.StructureImporterIface;
import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MObjectContainer;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MTransformable;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PageSettings;
import chemaxon.struc.graphics.MChemicalStruct;
import chemaxon.struc.graphics.MEFlow;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MMoleculeMovie;
import chemaxon.struc.graphics.MRectangle;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MDocument
implements MTransformable,
Serializable {
    private static final long serialVersionUID = 553557622036381832L;
    public static final int SETCOLOR_DEFAULT = 0;
    public static final int SETCOLOR_SPECIFIED = 1;
    public static final int SETCOLOR_COLORLESS = 2;
    private transient boolean serializing = false;
    protected transient ArrayList<MObject> objects;
    protected transient MChemicalStruct mainMChemicalStruct;
    protected transient MMoleculeMovie mainMMoleculeMovie;
    private transient List<MObject> highlightedObjects;
    private transient MObject focusedObject;
    private transient MObject draggedObject;
    private transient String inputFormat;
    private transient long fileStartPosition;
    private transient long fileEndPosition;
    private transient Prop property = new Prop();
    private transient MPropertyContainer propertyContainer;
    private transient MPropertyContainer guiPropertyContainer;
    protected transient MObject objectContainingSelection;
    private transient byte[] atomSetColorMode = null;
    private transient byte[] bondSetColorMode = null;
    private transient int[] atomSetRGBs = null;
    private transient int[] bondSetRGBs = null;
    private transient Color[] atomSetColors = null;
    private transient Color[] bondSetColors = null;
    private transient MFont[] atomSetFonts = null;
    private transient double[] bondSetThickness = null;
    private transient byte[] extraLabelSetColorMode = null;
    private transient long[] extraLabelSetRGBs = null;
    private transient MFont[] extraLabelSetFonts = null;
    private transient PageSettings pageSettings = null;
    private transient long checkerMarksGrinvCC = 0L;
    private transient List<CheckerMark> checkerMarks = null;

    private String convertDocumentToString(String fmt, int flags) throws IllegalArgumentException {
        try {
            StructureExporterIface exporter = (StructureExporterIface)MarvinModule.load("chemaxon.formats.StructureExporterUtil");
            return exporter.convertToString(this, fmt, flags);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public MDocument(MoleculeGraph m) {
        this.objects = new ArrayList();
        this.mainMChemicalStruct = new MChemicalStruct(m);
        this.mainMMoleculeMovie = null;
        this.propertyContainer = new MPropertyContainer();
        m.theDocument = this;
        this.pageSettings = new PageSettings();
        this.objects.add(this.mainMChemicalStruct);
    }

    public MDocument(Molecule[] mols) {
        this.objects = new ArrayList();
        Molecule m = new Molecule();
        this.mainMChemicalStruct = new MChemicalStruct(m);
        this.mainMMoleculeMovie = new MMoleculeMovie(mols);
        this.propertyContainer = new MPropertyContainer();
        this.pageSettings = new PageSettings();
        m.theDocument = this;
        for (int i = 0; i < mols.length; ++i) {
            mols[i].theDocument = this;
        }
        this.objects.add(this.mainMChemicalStruct);
        this.objects.add(this.mainMMoleculeMovie);
    }

    public MDocument(MDocument doc) {
        this(doc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MDocument(MDocument doc, boolean cloneobjs) {
        this.objects = new ArrayList<MObject>(doc.objects);
        this.pageSettings = (PageSettings)doc.pageSettings.clone();
        this.inputFormat = doc.inputFormat;
        this.fileStartPosition = doc.fileStartPosition;
        this.fileEndPosition = doc.fileEndPosition;
        this.serializing = doc.serializing;
        if (doc.checkerMarks != null) {
            this.checkerMarks = new ArrayList<CheckerMark>(doc.checkerMarks);
            this.checkerMarksGrinvCC = doc.checkerMarksGrinvCC;
        }
        if (cloneobjs) {
            int i;
            MObject[] objarr0;
            MDocument mDocument = doc;
            synchronized (mDocument) {
                objarr0 = new MObject[doc.objects.size()];
                doc.objects.toArray(objarr0);
            }
            MObject[] objarr = new MObject[objarr0.length];
            boolean hasgraphics = false;
            for (i = 0; i < objarr0.length; ++i) {
                MObject o;
                MObject o0 = objarr0[i];
                objarr[i] = o = (MObject)o0.clone();
                hasgraphics |= this.fixStructuralDependencies(o, o0, doc);
            }
            if (hasgraphics) {
                this.fixGraphicObjects(objarr, objarr0);
            }
            this.propertyContainer = (MPropertyContainer)doc.propertyContainer.clone();
            for (i = 0; i < objarr.length; ++i) {
                this.objects.set(i, objarr[i]);
            }
            for (i = 0; i < objarr.length; ++i) {
                objarr[i].finishCloning(doc, this);
            }
            MObject selobj = doc.objectContainingSelection;
            if (selobj != null) {
                int i2 = doc.indexOf(selobj);
                this.objectContainingSelection = i2 >= 0 ? this.getObject(i2) : (MObject)selobj.clone();
            }
            this.cloneSets(doc);
        } else {
            this.mainMChemicalStruct = doc.mainMChemicalStruct;
            this.mainMMoleculeMovie = doc.mainMMoleculeMovie;
            this.propertyContainer = doc.propertyContainer;
            this.objectContainingSelection = doc.objectContainingSelection;
            this.atomSetColorMode = doc.atomSetColorMode;
            this.atomSetRGBs = doc.atomSetRGBs;
            this.atomSetColors = doc.atomSetColors;
            this.bondSetColorMode = doc.bondSetColorMode;
            this.bondSetRGBs = doc.bondSetRGBs;
            this.atomSetFonts = doc.atomSetFonts;
            this.bondSetThickness = doc.bondSetThickness;
            this.extraLabelSetColorMode = doc.extraLabelSetColorMode;
            this.extraLabelSetFonts = doc.extraLabelSetFonts;
            this.extraLabelSetRGBs = doc.extraLabelSetRGBs;
        }
    }

    private void fixGraphicObjects(MObject[] objarr, MObject[] objarr0) {
        for (int i = 0; i < objarr.length; ++i) {
            objarr0[i].fixClonedPoints(objarr0, objarr, i);
            MRectangle.fixRectanglePointClones(objarr0, objarr);
        }
    }

    public void cloneSets(MDocument doc) {
        MFont[] elsf;
        long[] elsrgbs;
        byte[] elscm;
        int[] bsc;
        byte[] bscf;
        int[] asc;
        if (doc == null) {
            return;
        }
        byte[] ascf = doc.atomSetColorMode;
        if (ascf != null) {
            this.atomSetColorMode = new byte[ascf.length];
            System.arraycopy(ascf, 0, this.atomSetColorMode, 0, ascf.length);
        }
        if ((asc = doc.atomSetRGBs) != null) {
            this.atomSetRGBs = new int[asc.length];
            System.arraycopy(asc, 0, this.atomSetRGBs, 0, asc.length);
        }
        this.atomSetColors = null;
        MFont[] af = doc.atomSetFonts;
        if (af != null) {
            this.atomSetFonts = new MFont[af.length];
            System.arraycopy(af, 0, this.atomSetFonts, 0, af.length);
        }
        if ((bscf = doc.bondSetColorMode) != null) {
            this.bondSetColorMode = new byte[bscf.length];
            System.arraycopy(bscf, 0, this.bondSetColorMode, 0, bscf.length);
        }
        if ((bsc = doc.bondSetRGBs) != null) {
            this.bondSetRGBs = new int[bsc.length];
            System.arraycopy(bsc, 0, this.bondSetRGBs, 0, bsc.length);
        }
        this.bondSetColors = null;
        double[] bt = doc.bondSetThickness;
        if (bt != null) {
            this.bondSetThickness = new double[bt.length];
            System.arraycopy(bt, 0, this.bondSetThickness, 0, bt.length);
        }
        if ((elscm = doc.extraLabelSetColorMode) != null) {
            this.extraLabelSetColorMode = new byte[elscm.length];
            System.arraycopy(elscm, 0, this.extraLabelSetColorMode, 0, elscm.length);
        }
        if ((elsrgbs = doc.extraLabelSetRGBs) != null) {
            this.extraLabelSetRGBs = new long[elsrgbs.length];
            System.arraycopy(elsrgbs, 0, this.extraLabelSetRGBs, 0, elsrgbs.length);
        }
        if ((elsf = doc.extraLabelSetFonts) != null) {
            this.extraLabelSetFonts = new MFont[elsf.length];
            System.arraycopy(elsf, 0, this.extraLabelSetFonts, 0, elsf.length);
        }
    }

    @Deprecated
    public static MDocument parseMRV(String sval) throws MolFormatException {
        try {
            StructureImporterIface importer = (StructureImporterIface)MarvinModule.load("chemaxon.formats.StructureImporterUtil");
            return importer.parseMRV(sval);
        }
        catch (IOException e) {
            throw new MolFormatException(e);
        }
    }

    public MDocument cloneDocument() {
        return new MDocument(this);
    }

    public final Molecule cloneMainMolecule() {
        return (Molecule)this.cloneMainMoleculeGraph();
    }

    public final MoleculeGraph cloneMainMoleculeGraph() {
        MDocument doc = this.cloneDocument();
        return doc.getMainMoleculeGraph();
    }

    public final Object clone() {
        return this.cloneDocument();
    }

    public void removeAtomFromGraphs(MolAtom node) {
        for (int i = 0; i < this.getObjectCount(); ++i) {
            MObject o = this.getObject(i);
            if (o instanceof MChemicalStruct) {
                ((MChemicalStruct)o).getMoleculeGraph().removeAtom(node);
                continue;
            }
            if (!(o instanceof MMoleculeMovie)) continue;
            MMoleculeMovie mmm = (MMoleculeMovie)o;
            for (int j = 0; j < mmm.getMoleculeCount(); ++j) {
                mmm.getMolecule(j).removeAtom(node);
            }
        }
    }

    public void selectAllObjects(boolean s) {
        for (int i = 0; i < this.getObjectCount(); ++i) {
            this.getObject(i).setSelected(s);
        }
    }

    public void selectAllConnectedObjects(boolean s) {
        List<MObject> list = this.getAllObjects();
        for (int i = list.size() - 1; i >= 0; --i) {
            list.get(i).setSelected(s);
        }
    }

    public MObject getObjectContainingSelection() {
        return this.objectContainingSelection;
    }

    public void setObjectContainingSelection(MObject o) {
        for (int i = 0; i < this.getObjectCount(); ++i) {
            MObject oo = this.getObject(i);
            if (o != null) {
                oo.setSelected(false);
            }
            if (oo == o) continue;
            oo.unselectContents();
        }
        this.objectContainingSelection = o;
    }

    public boolean isHighlighted(MObject o) {
        List<MObject> v = this.highlightedObjects;
        return v != null && v.contains(o);
    }

    public void highlight(MObject o) {
        List<MObject> v = this.highlightedObjects;
        if (v == null) {
            this.highlightedObjects = v = new ArrayList<MObject>();
        }
        if (!v.contains(o)) {
            v.add(o);
        }
    }

    public void unhighlight(MObject o) {
        List<MObject> v = this.highlightedObjects;
        if (v != null) {
            int i = v.indexOf(o);
            if (i >= 0) {
                v.remove(i);
            }
            if (v.size() == 0) {
                this.highlightedObjects = null;
            }
        }
    }

    public void unhighlightAll() {
        this.highlightedObjects = null;
    }

    public MObject getDraggedObject() {
        return this.draggedObject;
    }

    public void setDraggedObject(MObject o) {
        this.draggedObject = o;
    }

    public MObject getFocus() {
        return this.focusedObject;
    }

    public void setFocus(MObject o) {
        this.focusedObject = o;
    }

    public MoleculeGraph getMainMoleculeGraph() {
        return this.mainMChemicalStruct == null ? null : this.mainMChemicalStruct.getMoleculeGraph();
    }

    public void setMainMoleculeGraph(MoleculeGraph m) {
        if (m != this.mainMChemicalStruct.getMoleculeGraph()) {
            int i = this.indexOf(this.mainMChemicalStruct);
            this.mainMChemicalStruct = new MChemicalStruct(m);
            m.theDocument = this;
            this.setObject(this.mainMChemicalStruct, i);
        }
        ArrayList<MolAtom> invec = new ArrayList<MolAtom>();
        for (int i = this.getObjectCount() - 1; i >= 0; --i) {
            MObject mo = this.getObject(i);
            if (mo.checkValidity(this, invec)) continue;
            for (int j = 0; j < invec.size(); ++j) {
                MolAtom a = (MolAtom)invec.get(j);
                MolAtom aa = m.findAtomClone(a);
                if (aa == a || aa == null) continue;
                this.replaceAtomInGraphicsObjects(a, aa);
            }
            invec.clear();
            if (mo.checkValidity(this, null) || this.inputFormat == null || this.inputFormat.startsWith("mrv") && mo instanceof MEFlow) continue;
            this.removeObject(i);
        }
    }

    public MMoleculeMovie getMoleculeMovie() {
        return this.mainMMoleculeMovie;
    }

    public Molecule getPrimaryMolecule() {
        MMoleculeMovie mmm;
        MoleculeGraph molg = this.mainMChemicalStruct.getMoleculeGraph();
        if (molg.isEmpty() && (mmm = this.mainMMoleculeMovie) != null) {
            return mmm.getCurrentMolecule();
        }
        if (molg instanceof Molecule) {
            return (Molecule)molg;
        }
        return new Molecule();
    }

    public Molecule[] getPrimaryMolecules() {
        MMoleculeMovie mmm;
        MoleculeGraph molg = this.mainMChemicalStruct.getMoleculeGraph();
        if (molg.isEmpty() && (mmm = this.mainMMoleculeMovie) != null) {
            return mmm.getMolecules();
        }
        Molecule[] m = new Molecule[]{molg instanceof Molecule ? (Molecule)molg : new Molecule()};
        return m;
    }

    public Molecule[] getAllMolecules() {
        int n = 0;
        for (int i = 0; i < this.getObjectCount(); ++i) {
            MObject mo = this.getObject(i);
            if (mo instanceof MChemicalStruct) {
                MChemicalStruct mcs = (MChemicalStruct)mo;
                MoleculeGraph molg = mcs.getMoleculeGraph();
                if (!(molg instanceof Molecule)) continue;
                ++n;
                continue;
            }
            if (!(mo instanceof MMoleculeMovie)) continue;
            MMoleculeMovie mmm = (MMoleculeMovie)mo;
            n += mmm.getMoleculeCount();
        }
        Molecule[] mols = new Molecule[n];
        int k = 0;
        for (int i = 0; i < this.getObjectCount(); ++i) {
            MObject mo = this.getObject(i);
            if (mo instanceof MChemicalStruct) {
                MChemicalStruct mcs = (MChemicalStruct)mo;
                MoleculeGraph molg = mcs.getMoleculeGraph();
                if (!(molg instanceof Molecule)) continue;
                mols[k++] = (Molecule)molg;
                continue;
            }
            if (!(mo instanceof MMoleculeMovie)) continue;
            MMoleculeMovie mmm = (MMoleculeMovie)mo;
            for (int j = 0; j < mmm.getMoleculeCount(); ++j) {
                Molecule m = mmm.getMolecule(j);
                mols[k++] = m;
            }
        }
        return mols;
    }

    public Molecule[] getAllNonEmptyMolecules() {
        int n = 0;
        for (int i = 0; i < this.getObjectCount(); ++i) {
            MObject mo = this.getObject(i);
            if (mo instanceof MChemicalStruct) {
                MChemicalStruct mcs = (MChemicalStruct)mo;
                MoleculeGraph molg = mcs.getMoleculeGraph();
                if (!(molg instanceof Molecule) || molg.isEmpty()) continue;
                ++n;
                continue;
            }
            if (!(mo instanceof MMoleculeMovie)) continue;
            MMoleculeMovie mmm = (MMoleculeMovie)mo;
            for (int j = 0; j < mmm.getMoleculeCount(); ++j) {
                if (mmm.getMolecule(j).isEmpty()) continue;
                ++n;
            }
        }
        Molecule[] mols = new Molecule[n];
        int k = 0;
        for (int i = 0; i < this.getObjectCount(); ++i) {
            MObject mo = this.getObject(i);
            if (mo instanceof MChemicalStruct) {
                MChemicalStruct mcs = (MChemicalStruct)mo;
                MoleculeGraph molg = mcs.getMoleculeGraph();
                if (!(molg instanceof Molecule) || molg.isEmpty()) continue;
                mols[k++] = (Molecule)molg;
                continue;
            }
            if (!(mo instanceof MMoleculeMovie)) continue;
            MMoleculeMovie mmm = (MMoleculeMovie)mo;
            for (int j = 0; j < mmm.getMoleculeCount(); ++j) {
                Molecule m = mmm.getMolecule(j);
                if (m.isEmpty()) continue;
                mols[k++] = m;
            }
        }
        return mols;
    }

    private boolean fixStructuralDependencies(MObject o, MObject o0, MDocument doc) {
        if (o instanceof MChemicalStruct) {
            MChemicalStruct mm0 = (MChemicalStruct)o0;
            MChemicalStruct mm = (MChemicalStruct)o;
            if (mm0.getMoleculeGraph().theDocument == doc) {
                mm.getMoleculeGraph().theDocument = this;
            }
            if (mm0 == doc.mainMChemicalStruct) {
                this.mainMChemicalStruct = mm;
            }
            return false;
        }
        if (o instanceof MMoleculeMovie) {
            MMoleculeMovie mm0 = (MMoleculeMovie)o0;
            MMoleculeMovie mm = (MMoleculeMovie)o;
            for (int j = 0; j < mm0.getMoleculeCount(); ++j) {
                if (mm0.getMolecule((int)j).theDocument == doc) {
                    mm.getMolecule((int)j).theDocument = this;
                }
                if (mm0 != doc.mainMMoleculeMovie) continue;
                this.mainMMoleculeMovie = mm;
            }
            return false;
        }
        return true;
    }

    public void setMoleculeMovie(MMoleculeMovie mmm) {
        int i = this.indexOf(this.mainMMoleculeMovie);
        this.mainMMoleculeMovie = mmm;
        if (mmm != null) {
            for (int j = 0; j < mmm.getMoleculeCount(); ++j) {
                mmm.getMolecule((int)j).theDocument = this;
            }
            if (i >= 0) {
                this.setObject(this.mainMMoleculeMovie, i);
            } else {
                this.addObject(this.mainMMoleculeMovie);
            }
        } else if (i >= 0) {
            this.removeObject(i);
        }
        ArrayList<MolAtom> invec = new ArrayList<MolAtom>();
        for (int j = this.getObjectCount() - 1; j >= 0; --j) {
            MObject mo = this.getObject(j);
            if (mo.checkValidity(this, invec)) continue;
            if (mmm != null) {
                for (int k = 0; k < invec.size(); ++k) {
                    MolAtom a = (MolAtom)invec.get(k);
                    MolAtom aa = null;
                    int n = mmm.getMoleculeCount();
                    for (int l = 0; l < n && aa == null; ++l) {
                        aa = mmm.getMolecule(l).findAtomClone(a);
                    }
                    if (aa == a || aa == null) continue;
                    this.replaceAtomInGraphicsObjects(a, aa);
                }
            }
            invec.clear();
            if (mo.checkValidity(this, null)) continue;
            this.removeObject(j);
        }
    }

    public int indexOf(MObject o) {
        int index = this.objects.indexOf(o);
        if (index == -1) {
            if (this.getMainMoleculeGraph() instanceof MObjectContainer) {
                List<MObject> list = ((MObjectContainer)((Object)this.getMainMoleculeGraph())).getAllObjects();
                index = list.indexOf(o);
            }
            if (index != -1) {
                index += this.objects.size();
            }
        }
        return index;
    }

    public void moveObject(MObject o, int i) {
        this.objects.remove(o);
        this.objects.add(i, o);
    }

    public void moveMainMoleculeGraphToFront() {
        int i = this.objects.indexOf(this.mainMChemicalStruct);
        if (i >= 0 && i < this.objects.size() - 1) {
            this.objects.remove(i);
            this.objects.add(this.mainMChemicalStruct);
        }
    }

    public void moveMoleculeMovieToFront() {
        int i;
        MMoleculeMovie mmm = this.mainMMoleculeMovie;
        if (mmm != null && (i = this.objects.indexOf(mmm)) >= 0 && i < this.objects.size() - 1) {
            this.objects.remove(i);
            this.objects.add(mmm);
        }
    }

    public boolean contains(MObject o) {
        return this.objects.contains(o);
    }

    public boolean contains(MDocument doc) {
        for (int i = 0; i < doc.getObjectCount(); ++i) {
            MObject oo = doc.getObject(i);
            boolean contains = this.contains(oo);
            if (!contains && oo instanceof MChemicalStruct) {
                MoleculeGraph mm = ((MChemicalStruct)oo).getMoleculeGraph();
                for (int j = 0; j < this.getObjectCount() && !contains; ++j) {
                    MObject o = this.getObject(i);
                    if (!(o instanceof MChemicalStruct)) continue;
                    MoleculeGraph m = ((MChemicalStruct)o).getMoleculeGraph();
                    contains = m.contains(mm);
                }
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    public boolean containsOnlyOne(Class cl) {
        int n = 0;
        for (int i = 0; i < this.getObjectCount(); ++i) {
            MObject o = this.getObject(i);
            if (o.isEmpty()) continue;
            if (cl.isInstance(o)) {
                ++n;
                continue;
            }
            return false;
        }
        return n == 1;
    }

    public void addObject(MObject o) {
        if (!this.isExtraObject(o)) {
            this.objects.add(o);
            if (o instanceof MChemicalStruct) {
                ((MChemicalStruct)o).getMoleculeGraph().theDocument = this;
            }
            o.addNotify();
        }
    }

    public boolean isExtraObject(MObject o) {
        return this.objects.indexOf(o) == -1 && this.indexOf(o) != -1;
    }

    public void removeObject(MObject o) {
        int i = this.objects.indexOf(o);
        if (i >= 0) {
            this.removeObject(i);
        } else if (this.isExtraObject(o)) {
            if (this.getMainMoleculeGraph() instanceof MObjectContainer) {
                ((MObjectContainer)((Object)this.getMainMoleculeGraph())).removeObject(o);
            }
        } else {
            List<MObject> list = this.getAllObjects();
            for (int j = list.size() - 1; j >= 0; --j) {
                MObject oo = list.get(j);
                if (!o.isChildOf(oo)) continue;
                oo.removeChild(o);
                if (!oo.isEmpty()) continue;
                this.removeObject(j);
            }
        }
    }

    public void removeObject(int i) {
        MObject o = this.getObject(i);
        if (o == this.mainMChemicalStruct) {
            this.mainMChemicalStruct = null;
        }
        o.removeNotify();
        this.objects.remove(i);
        this.unhighlight(o);
        if (o == this.focusedObject) {
            this.focusedObject = null;
        }
    }

    public int getObjectCount() {
        return this.objects.size();
    }

    public int getConnectedObjectCount() {
        int containedObjectCount = 0;
        if (this.mainMChemicalStruct != null && this.getMainMoleculeGraph() instanceof MObjectContainer) {
            containedObjectCount = ((MObjectContainer)((Object)this.getMainMoleculeGraph())).getObjectCount();
        }
        return this.objects.size() + containedObjectCount;
    }

    public MObject getObject(int i) {
        return this.objects.get(i);
    }

    public MObject getConnectedObject(int i) {
        List<MObject> list = this.getAllObjects();
        return list.get(i);
    }

    public List<MObject> getAllObjects() {
        ArrayList<MObject> list = new ArrayList<MObject>();
        list.addAll(this.objects);
        if (this.getMainMoleculeGraph() instanceof MObjectContainer) {
            list.addAll(((MObjectContainer)((Object)this.getMainMoleculeGraph())).getAllObjects());
        }
        return list;
    }

    public void setObject(MObject o, int i) {
        MObject old = this.getObject(i);
        if (old != o) {
            old.removeNotify();
            this.unhighlight(old);
            this.objects.set(i, o);
        }
    }

    public void removeAtom(MolAtom a) {
        this.removeAtom(a, -33);
    }

    public void removeAtom(MolAtom a, int cleanupFlags) {
        for (int i = this.getObjectCount() - 1; i >= 0; --i) {
            MObject o = this.getObject(i);
            if (o instanceof MChemicalStruct) {
                MoleculeGraph m = ((MChemicalStruct)o).getMoleculeGraph();
                m.removeAtom(a, cleanupFlags);
                continue;
            }
            if ((cleanupFlags & 4) == 0 || !o.containsAtom(a)) continue;
            this.removeObject(i);
        }
    }

    boolean isBeingSerialized() {
        return this.serializing;
    }

    public void clear() {
        this.objectContainingSelection = null;
        for (int i = 0; i < this.getObjectCount(); ++i) {
            this.getObject(i).removeNotify();
        }
        this.objects.clear();
        this.objects.add(this.mainMChemicalStruct);
        this.mainMChemicalStruct.getMoleculeGraph().removeAll();
        if (this.getMainMoleculeGraph() instanceof MObjectContainer) {
            ((MObjectContainer)((Object)this.getMainMoleculeGraph())).clearObjects();
        }
        this.clearSets();
        this.unhighlightAll();
    }

    public void clearSets() {
        this.atomSetColorMode = null;
        this.bondSetColorMode = null;
        this.atomSetRGBs = null;
        this.bondSetRGBs = null;
        this.atomSetColors = null;
        this.bondSetColors = null;
        this.atomSetFonts = null;
        this.bondSetThickness = null;
        this.extraLabelSetColorMode = null;
        this.extraLabelSetFonts = null;
        this.extraLabelSetRGBs = null;
    }

    public boolean isEmpty() {
        MoleculeGraph molg = this.getMainMoleculeGraph();
        return this.getObjectCount() == 1 && molg.isEmpty() && this.objectContainingSelection == null && this.getConnectedObjectCount() == 1;
    }

    public boolean isSimpleMolecule() {
        return this.getObjectCount() == 1 && this.getObject(0) instanceof MChemicalStruct && this.atomSetColorMode == null && this.bondSetColorMode == null && this.atomSetRGBs == null && this.bondSetRGBs == null && this.atomSetColors == null && this.bondSetColors == null && this.atomSetFonts == null && this.bondSetThickness == null && this.extraLabelSetColorMode == null && this.extraLabelSetFonts == null && this.extraLabelSetRGBs == null;
    }

    public void simplifyMolecule() {
        int n = this.getObjectCount();
        for (int i = 0; i < n; ++i) {
            Molecule m;
            MoleculeGraph mg;
            MObject o = this.getObject(i);
            if (o != this.mainMChemicalStruct || !((mg = this.mainMChemicalStruct.getMoleculeGraph()) instanceof Molecule) || (m = ((Molecule)mg).getMostSimplifiedMolecule()) == mg) continue;
            m.superGraph = m;
            m.parentGraph = null;
            m.theDocument = this;
            MChemicalStruct mcs = new MChemicalStruct(m);
            this.setObject(mcs, i);
            this.mainMChemicalStruct = mcs;
            return;
        }
    }

    @Override
    public void transform(CTransform3D t) {
        this.transform(t, 0, null);
    }

    public void transform(CTransform3D t, int opts) {
        this.transform(t, opts, null);
    }

    public void transform(CTransform3D t, int opts, CTransform3D trot) {
        for (int i = 0; i < this.getObjectCount(); ++i) {
            this.getObject(i).transform(t, opts, trot);
        }
    }

    public DPoint3 calcCenter() {
        return this.calcCenter(null);
    }

    public DPoint3 calcCenter(CTransform3D t) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int n = 0;
        DPoint3 q = new DPoint3(0.0, 0.0, 0.0);
        for (int i = 0; i < this.getObjectCount(); ++i) {
            MObject o = this.getObject(i);
            if (o instanceof MChemicalStruct && ((MChemicalStruct)o).getMoleculeGraph().isEmpty()) continue;
            o.calcCenter(q, t);
            x += q.x;
            y += q.y;
            z += q.z;
            ++n;
        }
        return n != 0 ? new DPoint3(x / (double)n, y / (double)n, z / (double)n) : new DPoint3(0.0, 0.0, 0.0);
    }

    public long getStartPosition() {
        return this.fileStartPosition;
    }

    public void setStartPosition(long off) {
        this.fileStartPosition = off;
    }

    public long getEndPosition() {
        return this.fileEndPosition;
    }

    public void setEndPosition(long off) {
        this.fileEndPosition = off;
    }

    public final String getInputFormat() {
        String f = this.inputFormat;
        return f != null ? f : this.getPrimaryMolecule().getInputFormat();
    }

    public void setInputFormat(String format2) {
        this.inputFormat = format2;
    }

    @Deprecated
    public final String exportToFormat(String fmt) throws MolExportException {
        try {
            StructureExporterIface exporter = (StructureExporterIface)MarvinModule.load("chemaxon.formats.StructureExporterUtil");
            return exporter.exportToFormat(this, fmt);
        }
        catch (IOException e) {
            throw new MolExportException(e);
        }
    }

    @Deprecated
    public final byte[] exportToBinFormat(String fmt) throws MolExportException {
        try {
            StructureExporterIface exporter = (StructureExporterIface)MarvinModule.load("chemaxon.formats.StructureExporterUtil");
            return exporter.exportToBinFormat(this, fmt);
        }
        catch (IOException e) {
            throw new MolExportException(e);
        }
    }

    @Deprecated
    public Object exportToObject(String fmt) throws MolExportException {
        try {
            StructureExporterIface exporter = (StructureExporterIface)MarvinModule.load("chemaxon.formats.StructureExporterUtil");
            return exporter.exportToObject(this, fmt);
        }
        catch (IOException e) {
            throw new MolExportException(e);
        }
    }

    public MProp getMProp() {
        return this.property;
    }

    public MPropertyContainer properties() {
        return this.propertyContainer;
    }

    public MFont getAtomSetFont(int seq) {
        MFont f = this.atomSetFonts != null && seq >= 0 && seq <= this.atomSetFonts.length ? this.atomSetFonts[seq] : null;
        return f;
    }

    public void setAtomSetFont(int seq, MFont font) {
        if (this.atomSetFonts == null) {
            this.atomSetFonts = new MFont[64];
        }
        if (0 <= seq && seq <= this.atomSetFonts.length) {
            this.atomSetFonts[seq] = font;
        }
    }

    public int getAtomSetColorMode(int seq) {
        return this.atomSetColorMode != null ? this.atomSetColorMode[seq] : 0;
    }

    public void setAtomSetColorMode(int seq, int m) {
        if (this.atomSetColorMode == null) {
            this.atomSetColorMode = new byte[64];
            this.atomSetColorMode[0] = 2;
        }
        this.atomSetColorMode[seq] = (byte)m;
        if (this.atomSetRGBs == null) {
            this.atomSetRGBs = new int[this.atomSetColorMode.length];
            for (int i = 0; i < this.atomSetRGBs.length; ++i) {
                this.atomSetRGBs[i] = -1;
            }
        } else if (m >= this.atomSetRGBs.length) {
            int[] asc = new int[m + 1];
            System.arraycopy(this.atomSetRGBs, 0, asc, 0, this.atomSetRGBs.length);
            this.atomSetRGBs = asc;
        }
    }

    public boolean isAtomSetColorModeSet() {
        return this.atomSetColorMode != null;
    }

    public void setExtraLabelSetColorMode(int seq, int mode) {
        if (this.extraLabelSetColorMode == null) {
            this.extraLabelSetColorMode = new byte[64];
            this.extraLabelSetColorMode[0] = 2;
        }
        this.extraLabelSetColorMode[seq] = (byte)mode;
    }

    public int getAtomSetSize() {
        return this.atomSetRGBs == null ? 0 : this.atomSetRGBs.length;
    }

    public int getExtraLabelSetSize() {
        return this.extraLabelSetRGBs == null ? 0 : this.extraLabelSetRGBs.length;
    }

    public int getAtomSetRGB(int seq) {
        byte f;
        byte by = f = this.atomSetColorMode != null ? this.atomSetColorMode[seq] : (byte)0;
        if (f == 0 || f == 2) {
            return -1;
        }
        return this.atomSetRGBs != null ? this.atomSetRGBs[seq] : -1;
    }

    public long getExtraLabelSetRGBs(int seq) {
        byte cm;
        byte by = cm = this.extraLabelSetColorMode != null ? this.extraLabelSetColorMode[seq] : (byte)0;
        long rgb = cm == 0 || cm == 2 ? -1L : (this.extraLabelSetRGBs != null ? this.extraLabelSetRGBs[seq] : -1L);
        return rgb;
    }

    public int getExtraLabelSetColorMode(int seq) {
        return this.extraLabelSetColorMode != null ? this.extraLabelSetColorMode[seq] : 0;
    }

    public MFont getExtraLabelSetFont(int seq) {
        return this.extraLabelSetFonts != null && seq >= 0 && seq <= this.extraLabelSetFonts.length ? this.extraLabelSetFonts[seq] : null;
    }

    public void setExtraLabelColorsForDocument(Molecule mol) {
        MolAtom a;
        int i;
        boolean hasSpecifiedColors = false;
        for (i = 0; i < mol.getAtomCount() && !hasSpecifiedColors; ++i) {
            a = mol.getAtom(i);
            hasSpecifiedColors = a.getExtraLabelColor() > 0L;
        }
        if (hasSpecifiedColors) {
            int i2;
            LongVector rgbV = new LongVector();
            for (i2 = 0; i2 < mol.getAtomCount(); ++i2) {
                MolAtom a2 = mol.getAtom(i2);
                long rgb = a2.getExtraLabelColor();
                if (rgbV.contains(rgb)) continue;
                rgbV.add(rgb);
            }
            rgbV.sort();
            this.extraLabelSetColorMode = new byte[64];
            this.extraLabelSetRGBs = new long[64];
            for (i2 = 0; i2 < rgbV.size(); ++i2) {
                long rgb = rgbV.get(i2);
                this.extraLabelSetColorMode[i2] = rgb == 0L ? (byte)0 : 1;
                this.extraLabelSetRGBs[i2] = rgb;
                for (int j = 0; j < mol.getAtomCount(); ++j) {
                    MolAtom a3 = mol.getAtom(j);
                    long atomRGB = a3.getExtraLabelColor();
                    if (atomRGB != rgb) continue;
                    a3.setExtraLabelSetSeq(i2);
                }
            }
        } else {
            this.extraLabelSetColorMode = null;
            for (i = 0; i < mol.getAtomCount(); ++i) {
                a = mol.getAtom(i);
                a.setExtraLabelSetSeq(0);
            }
        }
    }

    public void setAtomSetRGB(int seq, int rgb) {
        if (this.atomSetColorMode == null) {
            this.atomSetColorMode = new byte[64];
            this.atomSetColorMode[0] = 2;
        }
        if (this.atomSetRGBs == null) {
            this.atomSetRGBs = new int[64];
            for (int i = 0; i < this.atomSetRGBs.length; ++i) {
                this.atomSetRGBs[i] = -1;
            }
        }
        this.atomSetColorMode[seq] = 1;
        this.atomSetRGBs[seq] = rgb;
        if (this.atomSetColors != null) {
            this.atomSetColors[seq] = null;
        }
    }

    public void setExtraLabelSetRGBs(int seq, int rgb) {
        this.setExtraLabelSetRGBs(seq, rgb, 0);
    }

    public void setExtraLabelSetRGBs(int seq, int rgb1, int rgb2) {
        if (this.extraLabelSetColorMode == null) {
            this.extraLabelSetColorMode = new byte[64];
            this.extraLabelSetColorMode[0] = 2;
        }
        if (this.extraLabelSetRGBs == null) {
            this.extraLabelSetRGBs = new long[64];
            for (int i = 0; i < this.extraLabelSetRGBs.length; ++i) {
                this.extraLabelSetRGBs[i] = -1L;
            }
        }
        this.extraLabelSetColorMode[seq] = 1;
        this.extraLabelSetRGBs[seq] = (long)rgb2 << 32 | (long)rgb1;
    }

    public Color getAtomSetColor(int seq) {
        Color c;
        byte f;
        byte by = f = this.atomSetColorMode != null ? this.atomSetColorMode[seq] : (byte)0;
        if (f == 0 || f == 2) {
            return null;
        }
        Color color = c = this.atomSetColors != null ? this.atomSetColors[seq] : null;
        if (c == null && this.atomSetRGBs != null) {
            if (this.atomSetColors == null) {
                this.atomSetColors = new Color[this.atomSetRGBs.length];
            }
            this.atomSetColors[seq] = c = new Color(this.atomSetRGBs[seq]);
        }
        return c;
    }

    public int getBondSetSize() {
        return this.bondSetRGBs == null ? 0 : this.bondSetRGBs.length;
    }

    public double getBondSetThickness(int seq) {
        double thickness = this.bondSetThickness != null && seq >= 0 && seq <= this.bondSetThickness.length ? this.bondSetThickness[seq] : 0.0;
        return thickness;
    }

    public void setBondSetThickness(int seq, double thickness) {
        if (this.bondSetThickness == null) {
            this.bondSetThickness = new double[64];
        }
        if (0 <= seq && seq <= this.bondSetThickness.length) {
            this.bondSetThickness[seq] = thickness;
        }
    }

    public int getBondSetColorMode(int seq) {
        return this.bondSetColorMode != null ? this.bondSetColorMode[seq] : 0;
    }

    public void setBondSetColorMode(int seq, int m) {
        if (this.bondSetColorMode == null) {
            this.bondSetColorMode = new byte[64];
            this.bondSetColorMode[0] = 2;
        }
        this.bondSetColorMode[seq] = (byte)m;
        if (this.bondSetRGBs == null) {
            this.bondSetRGBs = new int[this.bondSetColorMode.length];
        } else if (m >= this.bondSetRGBs.length) {
            int[] bsc = new int[m + 1];
            System.arraycopy(this.bondSetRGBs, 0, bsc, 0, this.bondSetRGBs.length);
            this.bondSetRGBs = bsc;
        }
    }

    public int getBondSetRGB(int seq) {
        byte f;
        byte by = f = this.bondSetColorMode != null ? this.bondSetColorMode[seq] : (byte)0;
        if (f == 0 || f == 2) {
            return -1;
        }
        return this.bondSetRGBs != null ? this.bondSetRGBs[seq] : -1;
    }

    public void setBondSetRGB(int seq, int rgb) {
        if (this.bondSetColorMode == null) {
            this.bondSetColorMode = new byte[64];
            this.bondSetColorMode[0] = 2;
        }
        if (this.bondSetRGBs == null) {
            this.bondSetRGBs = new int[64];
            for (int i = 0; i < this.bondSetRGBs.length; ++i) {
                this.bondSetRGBs[i] = -1;
            }
        }
        this.bondSetColorMode[seq] = 1;
        this.bondSetRGBs[seq] = rgb;
        if (this.bondSetColors != null) {
            this.bondSetColors[seq] = null;
        }
    }

    public Color getBondSetColor(int seq) {
        Color c;
        byte f;
        byte by = f = this.bondSetColorMode != null ? this.bondSetColorMode[seq] : (byte)0;
        if (f == 0 || f == 2) {
            return null;
        }
        Color color = c = this.bondSetColors != null ? this.bondSetColors[seq] : null;
        if (c == null && this.bondSetRGBs != null) {
            if (this.bondSetColors == null) {
                this.bondSetColors = new Color[this.bondSetRGBs.length];
            }
            this.bondSetColors[seq] = c = new Color(this.bondSetRGBs[seq]);
        }
        return c;
    }

    public void addCheckerMark(CheckerMark mark) {
        this.checkerMarksGrinvCC = this.getPrimaryMolecule().getGrinvCC();
        if (this.checkerMarks == null) {
            this.checkerMarks = new ArrayList<CheckerMark>();
        }
        this.checkerMarks.add(mark);
    }

    public void clearCheckerMarks() {
        this.checkerMarks = null;
    }

    public CheckerMark[] getCheckerMarks() {
        if (this.checkerMarksGrinvCC != this.getPrimaryMolecule().getGrinvCC()) {
            this.checkerMarks = null;
        }
        return this.checkerMarks == null ? null : this.checkerMarks.toArray(new CheckerMark[0]);
    }

    void replaceAtomInGraphicsObjects(MolAtom orig, MolAtom a) {
        for (int i = this.getObjectCount() - 1; i >= 0; --i) {
            this.getObject(i).replaceAtom(orig, a);
        }
    }

    public String toString() {
        String s = super.toString();
        int i = s.lastIndexOf(46);
        StringBuffer sb = new StringBuffer(i >= 0 ? s.substring(i + 1) : s);
        MoleculeGraph m = this.getMainMoleculeGraph();
        if (m != null && !m.isEmpty()) {
            s = m.toString();
            i = s.indexOf(91);
            int j = s.lastIndexOf(93);
            if (i >= 0 && j == s.length() - 1) {
                sb.append(s.substring(i));
            }
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int f;
        MObject o;
        int i;
        this.serializing = true;
        oos.writeByte(4);
        this.propertyContainer.writeExternal(oos);
        int n = this.getObjectCount();
        oos.writeInt(n);
        int k = -1;
        for (i = 0; i < n; ++i) {
            o = this.getObject(i);
            oos.writeObject(o);
            if (o != this.mainMChemicalStruct) continue;
            k = i;
        }
        oos.writeInt(k);
        oos.writeObject(this.inputFormat);
        oos.writeLong(this.fileStartPosition);
        oos.writeLong(this.fileEndPosition);
        n = this.highlightedObjects == null ? 0 : this.highlightedObjects.size();
        oos.writeInt(n);
        for (i = 0; i < n; ++i) {
            o = this.highlightedObjects.get(i);
            k = this.indexOf(o);
            oos.writeInt(k);
        }
        int n2 = f = this.objectContainingSelection != null ? 1 : 0;
        if (this.atomSetColorMode != null) {
            f |= 2;
        }
        if (this.bondSetColorMode != null) {
            f |= 4;
        }
        if (this.atomSetFonts != null) {
            f |= 8;
        }
        if (this.bondSetThickness != null) {
            f |= 0x10;
        }
        if (this.pageSettings != null) {
            f |= 0x20;
        }
        oos.writeInt(f);
        if ((f & 1) != 0) {
            oos.writeObject(this.objectContainingSelection);
        }
        if ((f & 2) != 0) {
            n = this.atomSetColorMode.length;
            oos.writeInt(n);
            for (int i2 = 0; i2 < n; ++i2) {
                oos.writeInt(this.atomSetRGBs[i2]);
                oos.writeByte(this.atomSetColorMode[i2]);
            }
        }
        if ((f & 4) != 0) {
            n = this.bondSetColorMode.length;
            oos.writeInt(n);
            for (int i3 = 0; i3 < n; ++i3) {
                oos.writeInt(this.bondSetRGBs[i3]);
                oos.writeByte(this.bondSetColorMode[i3]);
            }
        }
        if ((f & 8) != 0) {
            n = this.atomSetFonts.length;
            oos.writeInt(n);
            for (int i4 = 0; i4 < n; ++i4) {
                oos.writeObject(this.atomSetFonts[i4]);
            }
        }
        if ((f & 0x10) != 0) {
            n = this.bondSetThickness.length;
            oos.writeInt(n);
            for (int i5 = 0; i5 < n; ++i5) {
                oos.writeDouble(this.bondSetThickness[i5]);
            }
        }
        if ((f & 0x20) != 0) {
            this.pageSettings.writeExternal(oos);
        }
        this.serializing = false;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte cmode;
        int rgb;
        int i;
        int f;
        byte version = ois.readByte();
        if (version < 2) {
            throw new IOException("Cannot deserialize document stored in obsolete format (" + version + ")");
        }
        if (version > 4) {
            throw new IOException("Cannot deserialize document with future version (" + version + ")");
        }
        this.property = new Prop();
        this.propertyContainer = new MPropertyContainer();
        if (version > 2) {
            this.propertyContainer.readExternal(ois);
        }
        int n = ois.readInt();
        this.objects = new ArrayList();
        for (int i2 = 0; i2 < n; ++i2) {
            MObject o = (MObject)ois.readObject();
            this.addObject(o);
        }
        int k = ois.readInt();
        if (k >= 0) {
            this.mainMChemicalStruct = (MChemicalStruct)this.objects.get(k);
        }
        this.inputFormat = (String)ois.readObject();
        this.fileStartPosition = ois.readLong();
        this.fileEndPosition = ois.readLong();
        n = ois.readInt();
        this.highlightedObjects = n != 0 ? new ArrayList() : null;
        for (int i3 = 0; i3 < n; ++i3) {
            k = ois.readInt();
            this.highlightedObjects.add(this.getObject(k));
        }
        int n2 = f = version < 4 ? ois.readByte() : ois.readInt();
        if ((f & 1) != 0) {
            this.objectContainingSelection = (MObject)ois.readObject();
        }
        if ((f & 2) != 0) {
            n = ois.readInt();
            this.atomSetColorMode = new byte[n];
            this.atomSetRGBs = new int[n];
            for (i = 0; i < n; ++i) {
                this.atomSetRGBs[i] = rgb = ois.readInt();
                cmode = version < 4 ? (rgb == -1 ? (byte)0 : 1) : ois.readByte();
                this.atomSetColorMode[i] = cmode;
            }
        }
        if ((f & 4) != 0) {
            n = ois.readInt();
            this.bondSetColorMode = new byte[n];
            this.bondSetRGBs = new int[n];
            for (i = 0; i < n; ++i) {
                this.bondSetRGBs[i] = rgb = ois.readInt();
                cmode = version < 4 ? (rgb == -1 ? (byte)0 : 1) : ois.readByte();
                this.bondSetColorMode[i] = cmode;
            }
        }
        if ((f & 8) != 0) {
            n = ois.readInt();
            this.atomSetFonts = new MFont[n];
            for (i = 0; i < n; ++i) {
                this.atomSetFonts[i] = (MFont)ois.readObject();
            }
        }
        if ((f & 0x10) != 0) {
            n = ois.readInt();
            this.bondSetThickness = new double[n];
            for (i = 0; i < n; ++i) {
                this.bondSetThickness[i] = ois.readDouble();
            }
        }
        if ((f & 0x20) != 0) {
            this.pageSettings = new PageSettings();
            this.pageSettings.readExternal(ois);
        }
        if ((f & 0x40) != 0) {
            // empty if block
        }
    }

    public PageSettings getPageSettings() {
        return this.pageSettings;
    }

    public void setPageSettings(PageSettings pageSettings) {
        this.pageSettings = pageSettings;
    }

    public void setGUIPropertyContainer(MPropertyContainer gpc) {
        this.guiPropertyContainer = gpc;
    }

    public void setGUIProperyContainer(MPropertyContainer gpc) {
        this.setGUIPropertyContainer(gpc);
    }

    public MPropertyContainer getGUIPropertyContainer() {
        return this.guiPropertyContainer;
    }

    public class Prop
    extends MProp {
        @Override
        public int getPropArraySize() {
            return -1;
        }

        @Override
        @Deprecated
        public String convertToString(String fmt, int flags) throws IllegalArgumentException {
            return MDocument.this.convertDocumentToString(fmt, flags);
        }

        @Override
        public Object getPropValue() {
            return this;
        }

        @Override
        public String getPropType() {
            return "MDocument";
        }

        @Override
        public String getPropXSDType() {
            return "ENTITY";
        }

        @Override
        public final MProp cloneProp() {
            return MDocument.this.cloneDocument().getMProp();
        }
    }

    public static class CheckerMark {
        final MolAtom[] atoms;
        final MolBond[] bonds;
        final Color color;

        public CheckerMark(MolAtom[] atoms, MolBond[] bonds, Color color) {
            this.atoms = atoms;
            this.bonds = bonds;
            this.color = color;
        }

        public MolAtom[] getAtoms() {
            return this.atoms;
        }

        public MolBond[] getBonds() {
            return this.bonds;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

