/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.common.util.text.SimpleTeX;
import chemaxon.core.calculations.ValenceCheck;
import chemaxon.core.spi.SmartsAtomQuerifierIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.BicycloStereoDescriptor;
import chemaxon.struc.CNode;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.ExtraAtomProperties;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.Sgroup;
import chemaxon.struc.StereoConstants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class MolAtom
implements StereoConstants,
Serializable,
CNode {
    private static final long serialVersionUID = -3974070468228529467L;
    private static final String[] STANDARD_RESIDUES;
    private static final Map<String, Integer> RESIDUE_HASH;
    public static final int LONELY_H = 1;
    public static final int ISOTOPE_H = 2;
    public static final int CHARGED_H = 4;
    public static final int RADICAL_H = 8;
    public static final int MAPPED_H = 16;
    public static final int WEDGED_H = 32;
    public static final int HCONNECTED_H = 64;
    public static final int CTSPECIFIC_H = 128;
    public static final int POLYMERENDGROUP_H = 256;
    public static final int SGROUPEND_H = 512;
    public static final int VALENCEERROR_H = 1024;
    public static final int ALL_H = 2047;
    public static final int ELEMENT_COUNT = 109;
    public static final int EMPTY = 0;
    private static final int SPEC_ATNO_OFFSET = 128;
    public static final int LIST = 128;
    public static final int NOTLIST = 129;
    public static final int LP = 130;
    public static final int ANY = 131;
    public static final int HETERO = 132;
    public static final int STAR = 133;
    public static final int RGROUP = 134;
    public static final int SGROUP = 135;
    public static final int PSEUDO = 136;
    public static final int MULTICENTER = 137;
    public static final int RGROUP_ATTACHMENT = 138;
    public static final int ATOM_TYPE_MAX = 138;
    public static final int ATOM_TYPE_COUNT = 139;
    private static final int HYBRIDIZATION_OFF = 7;
    private static final int HYBRIDIZATION_MASK = 896;
    public static final int HS_UNKNOWN = 0;
    public static final int HS_S = 1;
    public static final int HS_SP = 2;
    public static final int HS_SP2 = 3;
    public static final int HS_SP3 = 4;
    public static final int RGROUP_MAX = Short.MAX_VALUE;
    public static final int RAD_OFF = 10;
    public static final int RAD_MASK = 15360;
    public static final int RAD_COUNT_MASK = 3072;
    public static final int RAD1 = 1;
    public static final int RAD2 = 2;
    public static final int RAD2_SINGLET = 6;
    public static final int RAD2_TRIPLET = 10;
    public static final int RAD3 = 3;
    public static final int RAD3_DOUBLET = 7;
    public static final int RAD3_QUARTET = 11;
    public static final int RAD4 = 4;
    public static final int AAMAP_MAX = 1023;
    public static final int AAMAP_OFF = 18;
    public static final int AAMAP_MASK = 0xFFC0000;
    public static final int SETSEQ_MAX = 63;
    public static final int RESTYPE_MAX = 63;
    private static final int RESTYPE_OFF = 6;
    private static final int RESTYPE_MASK = 4032;
    public static final int RESSEQ_MAX = 8191;
    private static final int RESSEQ_OFF = 12;
    private static final int RESSEQ_MASK = 0x1FFF000;
    private static final int EXTRALABELSEQ_MAX = 63;
    private static final int EXTRALABELSEQ_OFFSET = 24;
    private static final int EXTRALABELSEQ_MASK = 0x3F000000;
    public static final int RXNSTEREO_NONE = 0;
    public static final int RXNSTEREO_INVERSION = 1;
    public static final int RXNSTEREO_RETENTION = 2;
    public static final int UNSPECIFIED_AROMATICITY = 0;
    public static final int AROMATIC = 1;
    public static final int ALIPHATIC = 2;
    public static final int AROMATIC_OR_ALIPHATIC = 3;
    public static final int ATTACH1 = 1;
    public static final int ATTACH2 = 2;
    public static final int ATTACH_BOTH = 3;
    public static final int SMARTS_H_DAYLIGHT_COMP_MODE = 1;
    public static final int SMARTS_H_MARVIN_COMP_MODE = 0;
    public static final int LDIR_RIGHT = 0;
    public static final int LDIR_LEFT = 1;
    public static final int LDIR_ABOVE = 2;
    public static final int LDIR_BELOW = 3;
    public static final int SYM_SQBRACKETS = 1;
    public static final int SYM_IMPLH = 2;
    public static final int SYM_EXPLH = 4;
    public static final int SYM_NEUTRAL = 8;
    public static final int SYM_SMARTS = 16;
    public static final int SYM_MOLEX = 32;
    public static final int SYM_CX = 64;
    private static final int ATNO_MASK = 255;
    private static final int MASSNO_OFF = 8;
    private static final int MASSNO_MASK = 130816;
    private static final int CHARGE_OFF = 17;
    private static final int CHARGE_MASK = 917504;
    private static final int CHARGE0 = 3;
    private static final int HCOUNT_OFF = 20;
    private static final int HCOUNT_MASK = 0x700000;
    private static final int RESATOM_ID_OFF = 23;
    private static final int RESATOM_ID_MASK = 528482304;
    public static final int VALENCE_CHECKED = 16384;
    public static final int VALENCE_ERROR = 32768;
    public static final int FIX_CHARGE = 65536;
    private static final int SELECTED = 131072;
    private static final String[] ELEM_SYMBOLS;
    private static final Map<String, Integer> SYMBOL_HASH;
    private static final String[] LONG_NAMES;
    private static final boolean[] IS_QUERY;
    private static final int[] ELECTRONEGS;
    private static final int[][] OXIDATION_STATES;
    private static final int[] NEGATIVE_OXIDATION;
    private static final int[] POSITIVE_OXIDATION;
    private static final int[] ION_CHARGE;
    private static final double[][] COVALENT_RADII;
    static final boolean[][][] IS_BOND_ALLOWED;
    transient MoleculeGraph parentGraph = null;
    transient int index;
    protected transient int bondCount = 0;
    protected transient MolBond[] theBonds = new MolBond[0];
    protected transient double xCoordinate;
    protected transient double yCoordinate;
    protected transient double zCoordinate;
    private transient int countFlags;
    private transient int flags = 0;
    private transient int atomSetFlags;
    transient ExtraAtomProperties extraProperties;
    private transient HashMap<String, Object> properties = null;
    private transient double[] corners = null;
    public static final char RADICAL_CHAR;
    private static final char NEGATIVE_CHARGE_CHAR;
    private static final Map<String, String> GENERIC_HASH;

    public MolAtom(int zZ, double x, double y, double z) {
        this.xCoordinate = x;
        this.yCoordinate = y;
        this.zCoordinate = z;
        this.setQueryString(null);
        this.countFlags = zZ & 0xFF | 0x60000;
    }

    public MolAtom(double x, double y) {
        this(6, x, y, 0.0);
    }

    public MolAtom(int z) {
        this(z, 0.0, 0.0, 0.0);
    }

    public final MoleculeGraph getParent() {
        return this.parentGraph;
    }

    public final int indexOf(MolBond bond) {
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.theBonds[i].equals(bond)) continue;
            return i;
        }
        return -1;
    }

    public final MolAtom[] getLigands() {
        MolAtom[] ligands = new MolAtom[this.bondCount];
        for (int i = 0; i < this.bondCount; ++i) {
            ligands[i] = this.theBonds[i].getOtherAtom(this);
        }
        return ligands;
    }

    public final MolAtom getLigand(int i) {
        MolBond edge = this.theBonds[i];
        MolAtom node1 = edge.getAtom1();
        MolAtom node2 = edge.getAtom2();
        return node1 == this ? node2 : node1;
    }

    public final int getLigandIndex(MolAtom atom) {
        MolBond edge = this.getBondTo(atom);
        return edge == null ? -1 : this.indexOf(edge);
    }

    public final MolBond getBondTo(MolAtom other) {
        for (int i = 0; i < this.bondCount; ++i) {
            if ((this.theBonds[i].theAtom2 != other || this.theBonds[i].theAtom1 != this) && (this.theBonds[i].theAtom1 != other || this.theBonds[i].theAtom2 != this)) continue;
            return this.theBonds[i];
        }
        return null;
    }

    public final boolean isBoundTo(MolAtom other) {
        return this.getBondTo(other) != null;
    }

    public final int sringsize() {
        int min = 0x7FFFFFFE;
        for (int i = this.bondCount - 2; i >= 0; --i) {
            MolBond b = this.theBonds[i];
            MolAtom a = b.getOtherAtom(this);
            int x = a.distance2(this, b);
            if (x >= min) continue;
            min = x;
        }
        return min + 1;
    }

    protected final Object getLock() {
        MoleculeGraph p = this.parentGraph;
        return p != null ? p.getLock() : this;
    }

    protected static void setAtom1(MolBond bond, MolAtom newatom) {
        bond.setAtom1(newatom);
    }

    protected static void setAtom2(MolBond bond, MolAtom newatom) {
        bond.setAtom2(newatom);
    }

    void resetGrinv() {
        MoleculeGraph p = this.parentGraph;
        if (p != null) {
            do {
                p.incGrinvCC();
            } while ((p = p.getParent()) != null);
        }
    }

    private int distance2(MolAtom target, MolBond from) {
        ArrayList v = new ArrayList();
        ArrayList<MolAtom> f = new ArrayList<MolAtom>();
        ArrayList<MolAtom> f2 = new ArrayList<MolAtom>();
        f.add(this);
        int depth = 0;
        while (f.size() > 0) {
            int i;
            for (i = f.size() - 1; i >= 0; --i) {
                v.add(f.get(i));
            }
            f2.clear();
            for (i = f.size() - 1; i >= 0; --i) {
                MolAtom a = (MolAtom)f.get(i);
                MolBond[] fi = a.theBonds;
                for (int j = a.bondCount - 1; j >= 0; --j) {
                    MolBond b = fi[j];
                    if (b.equals(from)) continue;
                    MolAtom aa = b.getOtherAtom(a);
                    if (aa == target) {
                        return depth + 1;
                    }
                    if (v.contains(aa)) continue;
                    f2.add(aa);
                }
            }
            f.clear();
            for (i = f2.size() - 1; i >= 0; --i) {
                f.add((MolAtom)f2.get(i));
            }
            ++depth;
        }
        return Integer.MAX_VALUE;
    }

    public boolean haveSimilarBonds(MolAtom a) {
        if (this.bondCount != a.bondCount) {
            return false;
        }
        boolean[] visited = new boolean[this.bondCount];
        for (int i = 0; i < this.bondCount; ++i) {
            int j;
            for (j = 0; j < this.bondCount; ++j) {
                if (visited[j] || !this.getBond(i).haveEqualProperties(a.getBond(j))) continue;
                visited[j] = true;
                break;
            }
            if (j != this.bondCount) continue;
            return false;
        }
        return true;
    }

    public final int getBondCount() {
        return this.bondCount;
    }

    public final MolBond getBond(int i) {
        return this.theBonds[i];
    }

    public final int getRealBondCount() {
        int nb = 0;
        for (int i = 0; i < this.getBondCount(); ++i) {
            int a = this.getLigand(i).getAtno();
            if (a == 130) continue;
            ++nb;
        }
        return nb;
    }

    public void set(MolAtom atom) {
        double[] c;
        this.countFlags = atom.countFlags;
        this.flags = atom.flags;
        this.atomSetFlags = atom.atomSetFlags;
        ExtraAtomProperties xprops = atom.extraProperties;
        ExtraAtomProperties extraAtomProperties = this.extraProperties = xprops != null ? (ExtraAtomProperties)xprops.clone() : null;
        if (atom.properties != null) {
            this.properties = (HashMap)atom.properties.clone();
        }
        if ((c = atom.corners) != null) {
            this.corners = new double[4];
            this.corners[0] = c[0];
            this.corners[1] = c[1];
            this.corners[2] = c[2];
            this.corners[3] = c[3];
        } else {
            this.corners = null;
        }
        this.resetGrinv();
    }

    public double getX() {
        return this.xCoordinate;
    }

    public void setX(double x) {
        this.xCoordinate = x;
        this.resetGrinv();
    }

    public double getY() {
        return this.yCoordinate;
    }

    public void setY(double y) {
        this.yCoordinate = y;
        this.resetGrinv();
    }

    public double getZ() {
        return this.zCoordinate;
    }

    public void setZ(double z) {
        this.zCoordinate = z;
        this.resetGrinv();
    }

    public void setXY(double x, double y) {
        this.xCoordinate = x;
        this.yCoordinate = y;
        this.resetGrinv();
    }

    public void setXYZ(double x, double y, double z) {
        this.xCoordinate = x;
        this.yCoordinate = y;
        this.zCoordinate = z;
        this.resetGrinv();
    }

    public final DPoint3 getLocation() {
        DPoint3 p = new DPoint3();
        this.getLocation(p);
        return p;
    }

    public final void getLocation(DPoint3 p) {
        p.x = this.xCoordinate;
        p.y = this.yCoordinate;
        p.z = this.zCoordinate;
    }

    public void setLocation(DPoint3 p) {
        this.xCoordinate = p.x;
        this.yCoordinate = p.y;
        this.zCoordinate = p.z;
        this.resetGrinv();
    }

    public void transform(CTransform3D t, boolean incg) {
        DPoint3 p = this.getLocation();
        t.transform(p);
        this.xCoordinate = p.x;
        this.yCoordinate = p.y;
        this.zCoordinate = p.z;
        if (incg) {
            this.resetGrinv();
        }
    }

    public String getSymbol() {
        int z = this.countFlags & 0xFF;
        int a = this.getMassno();
        if (z == 136) {
            String s = this.getAliasstr();
            return s != null ? SimpleTeX.convertShort2TeX(s, 0) : null;
        }
        if (a != 0 && this.isSpecIsotopeSymbolUsed()) {
            return MolAtom.symbolOf(z, a);
        }
        if (z == 138) {
            return Integer.toString(this.getRgroupAttachmentPointOrder());
        }
        return MolAtom.symbolOf(z);
    }

    public final int getAtno() {
        return this.countFlags & 0xFF;
    }

    public void setAtno(int z) {
        int oldAtno = this.getAtno();
        int f = this.countFlags & 0xFFFFFF00 | z & 0xFF;
        ExtraAtomProperties p = this.extraProperties;
        if (p != null) {
            p.setImplicitHcount(0);
        }
        if (z == 134) {
            f &= 0xFF8FFFFF;
        }
        if (f != this.countFlags) {
            this.countFlags = f;
            this.resetGrinv();
        }
        if (this.parentGraph != null && oldAtno != this.getAtno()) {
            this.parentGraph.update(this);
        }
    }

    public static boolean checkAtno(int z) {
        return z >= 0 && z <= 138;
    }

    public int getMassno() {
        return (this.countFlags & 0x1FF00) >> 8;
    }

    public void setMassno(int a) {
        int f = this.countFlags & 0xFFFE00FF | a << 8 & 0x1FF00;
        if (f != this.countFlags) {
            this.countFlags = f;
            this.resetGrinv();
        }
    }

    public void setForSpecIsotopeSymbol(String sym) {
        int a;
        if (sym == null) {
            return;
        }
        int n = (sym = sym.trim()).equals("D") ? 2 : (a = sym.equals("T") ? 3 : 0);
        if (a != 0) {
            this.setSpecIsotopeSymbolPreferred(true);
            this.setMassno(a);
        } else {
            this.setSpecIsotopeSymbolPreferred(false);
        }
    }

    public void setMassnoIfKnown(String sym) {
        this.setForSpecIsotopeSymbol(sym);
    }

    public double getMass() {
        return PeriodicSystem.getMass(this.getAtno(), this.getMassno());
    }

    public boolean isNobleGas() {
        int atno = this.countFlags & 0xFF;
        return PeriodicSystem.isNobleGas(atno);
    }

    public boolean isMappable() {
        return this.getAtno() != 130 && this.getAtno() != 137;
    }

    public int getRelativeNegativity() {
        int atno = this.countFlags & 0xFF;
        boolean isneg = false;
        int e = MolAtom.electronegOf(atno);
        int nb = this.bondCount;
        boolean ispos = false;
        for (int i = nb - 1; i >= 0; --i) {
            int oatno;
            MolBond b = this.theBonds[i];
            MolAtom oa = b.getOtherAtom(this);
            if (oa == null || (oatno = oa.getAtno()) < 1 || oatno > 109) continue;
            int oe = MolAtom.electronegOf(oatno);
            if (oe < e) {
                isneg = true;
                continue;
            }
            if (oe <= e) continue;
            ispos = true;
        }
        if (isneg && ispos || !isneg && !ispos) {
            return 0;
        }
        return isneg ? -1 : 1;
    }

    public int getImplicitHcount() {
        Map<String, Object> q;
        int h = this.getNonQueryImplicitHcount();
        ExtraAtomProperties p = this.extraProperties;
        if (p != null && (q = p.qprops) != null) {
            Object o = q.get("h");
            if (o != null) {
                h = (Integer)o;
            } else {
                o = q.get("H");
                if (o != null) {
                    h = (Integer)o - this.getExplicitHcount();
                }
            }
        }
        return h;
    }

    public void setImplicitHcount(int h) {
        int old = this.getNonQueryImplicitHcount();
        if (h != old) {
            this.setNonQueryImplicitHcount(h);
        }
    }

    public int getNonQueryImplicitHcount() {
        int h = this.countFlags & 0x700000;
        int x = h >> 20;
        return h != 0x700000 ? x : this.extraProperties.getImplicitHcount();
    }

    public void setNonQueryImplicitHcount(int h) {
        if (h < 0) {
            throw new IllegalArgumentException("Illegal value " + h + " specified for the number of implicit hydrogens.");
        }
        if (h < 7) {
            int f = this.countFlags & 0xFF8FFFFF | h << 20 & 0x700000;
            if (f != this.countFlags) {
                this.countFlags = f;
                ExtraAtomProperties p = this.extraProperties;
                if (p != null) {
                    p.setNonQueryImplicitHcount(h);
                }
                this.resetGrinv();
            }
        } else if (this.getNonQueryImplicitHcount() != h) {
            this.countFlags |= 0x700000;
            ExtraAtomProperties p = this.getExtraProperties();
            p.setNonQueryImplicitHcount(h);
            this.resetGrinv();
        }
    }

    public int getCharge() {
        int c = this.countFlags & 0xE0000;
        return c != 917504 ? (c >> 17) - 3 : this.extraProperties.getCharge();
    }

    public void setCharge(int q) {
        this.flags |= 0x10000;
        int f = this.countFlags & 0xFFF1FFFF;
        ExtraAtomProperties p = this.extraProperties;
        if (q >= -3 && q <= 3) {
            int e = 3 + q << 17 & 0xE0000;
            this.countFlags = f | e;
            if (p != null) {
                p.setCharge(q);
            }
        } else {
            this.countFlags |= 0xE0000;
            p = this.getExtraProperties();
            p.setCharge(q);
        }
        this.resetGrinv();
    }

    public static int getColumn(int z) {
        return PeriodicSystem.getColumn(z);
    }

    public int getRadical() {
        return (this.flags & 0x3C00) >> 10;
    }

    public void setRadical(int r) {
        r = r << 10 & 0x3C00;
        this.flags = this.flags & 0xFFFFC3FF | r;
        this.resetGrinv();
    }

    public int getRadicalCount() {
        if (this.getRadical() == 4) {
            return 4;
        }
        return (this.flags & 0xC00) >>> 10;
    }

    public static int getRow(int z) {
        return PeriodicSystem.getRow(z);
    }

    public int[] getValencePropMinMax() {
        int qhcount = this.getQPropAsInt("H");
        int x = this.twicesumbonds(false, false) / 2;
        int xh = this.twicesumbonds(true, false) / 2;
        int min = qhcount >= 0 ? x + qhcount : xh;
        int max = 8;
        return new int[]{min, max};
    }

    public int getValenceProp() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.valence1 - 1 : -1;
    }

    public void setValenceProp(int v) {
        ExtraAtomProperties p = this.extraProperties;
        if (p == null && v >= 0) {
            p = this.getExtraProperties();
        }
        if (p != null) {
            p.valence1 = (short)(v + 1);
        }
    }

    public int incValenceProp() {
        int[] minmax = this.getValencePropMinMax();
        int min = minmax[0];
        int max = minmax[1];
        int val = this.getValenceProp();
        val = val == -1 ? min : (val >= max ? -1 : ++val);
        this.setValenceProp(val);
        return val;
    }

    public int decValenceProp() {
        int[] minmax = this.getValencePropMinMax();
        int min = minmax[0];
        int max = minmax[1];
        int val = this.getValenceProp();
        val = val == -1 ? max : (val <= min ? -1 : --val);
        this.setValenceProp(val);
        return val;
    }

    public int getValence() {
        int v = this.getValenceProp();
        if (v != -1) {
            return v;
        }
        int h = this.getImplicitHcount();
        int x = this.twicesumbonds(true, false) / 2;
        return x + h;
    }

    public int getExplicitHcount() {
        int n = 0;
        for (int i = this.bondCount - 1; i >= 0; --i) {
            MolAtom a = this.theBonds[i].getOtherAtom(this);
            if (a.getAtno() != 1) continue;
            ++n;
        }
        return n;
    }

    public boolean hasQProps() {
        return this.getQProps() != null;
    }

    public Object getQProp(String name) {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.getQProp(name) : null;
    }

    public int getQPropAsInt(String name) {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.getQPropAsInt(name) : -1;
    }

    public int[] getQPropMinMax(String name) {
        int max;
        int min;
        if (name.equals("X")) {
            int maxX = MolAtom.maxAbsOxStateOf(this.getAtno());
            min = this.getBondCount();
            max = maxX == 0 ? 4 : maxX;
        } else if (name.equals("H")) {
            int h;
            int x = this.twicesumbonds(false, false) / 2;
            int xh = this.twicesumbonds(true, false) / 2;
            min = h = xh - x;
            max = xh < 4 ? 4 - x : h;
        } else if (name.equals("R")) {
            int srs = this.getQPropAsInt("R") > 254 || this.getQPropAsInt("r") > 254 ? this.sringsize() : Integer.MAX_VALUE;
            min = srs == Integer.MAX_VALUE ? 0 : 1;
            max = 6;
        } else if (name.equals("r")) {
            int srs = this.getQPropAsInt("R") > 254 || this.getQPropAsInt("r") > 254 ? this.sringsize() : Integer.MAX_VALUE;
            min = 3;
            max = srs == Integer.MAX_VALUE ? 30 : srs;
        } else if (name.equals("rb")) {
            min = -2;
            max = 4;
        } else if (name.equals("s")) {
            min = -2;
            max = 6;
        } else if (name.equals("D")) {
            min = 0;
            max = 6;
        } else if (name.equals("h")) {
            min = 0;
            max = 4;
        } else {
            min = 0;
            max = 254;
        }
        return new int[]{min, max};
    }

    private boolean canQPropHaveTrueValue(String name) {
        if (name.equals("R")) {
            int srs = this.getQPropAsInt("R") > 254 || this.getQPropAsInt("r") > 254 ? this.sringsize() : Integer.MAX_VALUE;
            return srs == Integer.MAX_VALUE;
        }
        return false;
    }

    public int incQProp(String name) {
        int[] minmax = this.getQPropMinMax(name);
        int min = minmax[0];
        int max = minmax[1];
        int val = this.getQPropAsInt(name);
        val = name.equals("rb") ? (val == -1 ? min : (val == -2 ? 0 : (val == 0 ? 2 : (val >= max ? -1 : val + 1)))) : (val == -1 ? (this.canQPropHaveTrueValue(name) ? 256 : min) : (val == 256 ? min : (val == -2 ? 0 : (val >= max ? -1 : ++val))));
        this.setQProp(name, val);
        return val;
    }

    public int decQProp(String name) {
        int[] minmax = this.getQPropMinMax(name);
        int min = minmax[0];
        int max = minmax[1];
        int val = this.getQPropAsInt(name);
        if (name.equals("rb")) {
            val = val == -1 ? max : (val == 0 ? -2 : (val == 2 ? 0 : (val <= min ? -1 : val - 1)));
        } else if (val == -1) {
            val = max;
        } else if (val == 256) {
            val = -1;
        } else if (val <= min) {
            val = -1;
        } else if (val == 0) {
            if (min < -1) {
                val = -2;
            } else if (this.canQPropHaveTrueValue(name)) {
                val = 256;
            }
        } else {
            --val;
        }
        this.setQProp(name, val);
        return val;
    }

    public void setQProp(String name, Object v) {
        ExtraAtomProperties p = this.extraProperties;
        if (p == null && v != null) {
            p = this.getExtraProperties();
        }
        if (p != null) {
            p.setQProp(name, v);
        }
        this.resetGrinv();
    }

    public void setQProp(String name, int v) {
        this.setQProp(name, v == -1 ? null : new Integer(v));
    }

    public void clearQProps() {
        ExtraAtomProperties p = this.extraProperties;
        if (p != null) {
            p.qprops = null;
            p.querystr = null;
        }
    }

    public String[] getQPropNames() {
        Map<String, Object> h = this.getQProps();
        int n = h != null ? h.size() : 0;
        String[] arr = new String[n];
        if (n != 0) {
            h.keySet().toArray(arr);
        }
        return arr;
    }

    public Set<String> getQPropNameSet() {
        Map<String, Object> h = this.getQProps();
        if (h == null || h.size() == 0) {
            return null;
        }
        return h.keySet();
    }

    private Map<String, Object> getQProps() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.qprops : null;
    }

    public int getQueryAromaticity() {
        int x = this.getQPropAsInt("a");
        return x < 0 ? 0 : (x == 0 ? 2 : (x == 1 ? 1 : 3));
    }

    public void setQueryAromaticity(int x) {
        int y = x == 0 ? -1 : (x == 1 ? 1 : (x == 2 ? 0 : 2));
        this.setQProp("a", y);
    }

    public int incQueryAromaticity() {
        int arom = this.getQueryAromaticity();
        arom = arom == 0 ? 1 : (arom == 1 ? 2 : (arom == 2 ? 3 : 0));
        this.setQueryAromaticity(arom);
        return arom;
    }

    public int getRgroup() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.getRgroup() : 0;
    }

    public void setRgroup(int r) {
        if (r < 0 || r > Short.MAX_VALUE) {
            throw new IllegalArgumentException("R-group value " + r + " is not in range [0, " + Short.MAX_VALUE + "]");
        }
        ExtraAtomProperties p = this.extraProperties;
        if (p == null && (r != 0 || this.getAtno() == 134)) {
            p = this.getExtraProperties();
        }
        if (p != null) {
            p.setRgroup(r);
        }
        this.resetGrinv();
    }

    public int getAttach() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.getAttach() : 0;
    }

    public void setAttach(int a) {
        this.setAttach(a, this.getAttachParentSgroup());
    }

    public void setAttach(int a, Sgroup sg) {
        ExtraAtomProperties p = this.extraProperties;
        if (p == null && a != 0) {
            p = this.getExtraProperties();
        }
        if (p != null) {
            p.attachParentSgroup = a != 0 ? sg : null;
            p.setAttach(a);
        }
        this.resetGrinv();
    }

    public Sgroup getAttachParentSgroup() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.attachParentSgroup : null;
    }

    public int getHybridizationState() {
        return (this.flags & 0x380) >> 7;
    }

    public void setHybridizationState(int h) {
        h = h << 7 & 0x380;
        this.flags = this.flags & 0xFFFFFC7F | h;
    }

    public int getAtomMap() {
        return (this.flags & 0xFFC0000) >> 18;
    }

    public void setAtomMap(int map) {
        if (map < 0 || map > 1023) {
            throw new IllegalArgumentException("atom-atom mapping number " + map + " is not in range [0, " + 1023 + "]");
        }
        this.flags = this.flags & 0xF003FFFF | map << 18;
        this.resetGrinv();
    }

    public int getSetSeq() {
        return this.atomSetFlags & 0x3F;
    }

    public void setSetSeq(int id) {
        this.atomSetFlags = this.atomSetFlags & 0xFFFFFFC0 | id & 0x3F;
    }

    public void setExtraLabelSetSeq(int id) {
        this.atomSetFlags = this.atomSetFlags & 0xC0FFFFFF | id << 24 & 0x3F000000;
    }

    public int getExtraLabelSetSeq() {
        return (this.atomSetFlags & 0x3F000000) >> 24;
    }

    public static int residueTypeOf(String name) {
        Integer i = RESIDUE_HASH.get(name.toUpperCase());
        return i != null ? i : 0;
    }

    public static String residueSymbolOf(int id) {
        return id < STANDARD_RESIDUES.length ? STANDARD_RESIDUES[id] : null;
    }

    public int getResidueType() {
        return (this.atomSetFlags & 0xFC0) >> 6;
    }

    public void setResidueType(int t) {
        this.atomSetFlags = this.atomSetFlags & 0xFFFFF03F | t << 6 & 0xFC0;
    }

    public int getResidueSeq() {
        return (this.atomSetFlags & 0x1FFF000) >> 12;
    }

    public void setResidueSeq(int n) {
        this.atomSetFlags = this.atomSetFlags & 0xFE000FFF | n << 12 & 0x1FFF000;
    }

    public int getResidueAtomId() {
        return (this.countFlags & 0x1F800000) >> 23;
    }

    public void setResidueAtomId(int id) {
        int f = id << 23 & 0x1F800000;
        this.countFlags = this.countFlags & 0xE07FFFFF | f;
    }

    public int getMinRepetitions() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.getMinRepetitions() : 1;
    }

    public void setMinRepetitions(int r) {
        ExtraAtomProperties p = this.extraProperties;
        if (p != null) {
            p.setMinRepetitions(r);
        } else if (r != 1) {
            p = this.getExtraProperties();
            p.setMinRepetitions(r);
        }
    }

    public int getMaxRepetitions() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.getMaxRepetitions() : 1;
    }

    public void setMaxRepetitions(int r) {
        ExtraAtomProperties p = this.extraProperties;
        if (p != null) {
            p.setMaxRepetitions(r);
        } else if (r != 1) {
            p = this.getExtraProperties();
            p.setMaxRepetitions(r);
        }
    }

    public int getLinkNodeOuterAtom(int idx) {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.getLinkNodeOuterBondIdx(idx) : -1;
    }

    public void setLinkNodeOuterAtom(int idx, int outer) {
        ExtraAtomProperties p = this.extraProperties;
        if (p != null) {
            p.setLinkNodeOuterBondIdx(idx, outer);
        } else if (outer != -1) {
            p = this.getExtraProperties();
            p.setLinkNodeOuterBondIdx(idx, outer);
        }
    }

    public boolean isLinkNode() {
        return this.getMaxRepetitions() != 1 && (this.getLinkNodeOuterAtom(0) != -1 || this.getLinkNodeOuterAtom(1) != -1);
    }

    public final boolean isArrowEnd() {
        return false;
    }

    private double getBondPhi(int i, CTransform3D t) {
        DPoint3 p0 = this.getLocation();
        t.transform(p0);
        MolBond b = this.theBonds[i];
        DPoint3 p = new DPoint3();
        b.getOtherAtom(this).getLocation(p);
        t.transform(p);
        return p0.angle2D(p.x, p.y);
    }

    public void bondweights(double[] w, CTransform3D t) {
        this.bondweights0(w, t, true);
    }

    private void bondweights0(double[] w, CTransform3D t, boolean explh) {
        int n = explh ? this.bondCount : this.bondCount - this.getExplicitHcount();
        w[0] = 0.0;
        w[1] = 0.0;
        w[2] = 0.0;
        DPoint3 p0 = this.getLocation();
        t.transform(p0);
        DPoint3 p = new DPoint3();
        for (int i = 0; i < this.bondCount; ++i) {
            MolBond b = this.theBonds[i];
            MolAtom a1 = b.getOtherAtom(this);
            if (a1.getAtno() == 1 && !explh) continue;
            a1.getLocation(p);
            t.transform(p);
            double r = (double)n * b.getLength();
            w[0] = w[0] + (p.x - p0.x) / r;
            w[1] = w[1] + (p.y - p0.y) / r;
            w[2] = w[2] + (p.z - p0.z) / r;
        }
    }

    private ExtraAtomProperties getExtraProperties() {
        ExtraAtomProperties p = this.extraProperties;
        if (p == null) {
            this.extraProperties = p = new ExtraAtomProperties();
        }
        return p;
    }

    private static boolean appendQProp(StringBuffer s, char c, int x) {
        if (x != -1) {
            s.append(c);
            if (x == 256) {
                return true;
            }
            if (x == 255) {
                s.append('-');
            } else if (x == 257) {
                s.append('+');
            } else if (x >= 0) {
                s.append(String.valueOf(x));
            } else if (x == -2) {
                s.append('*');
            }
            return true;
        }
        return false;
    }

    private static boolean appendQProp(StringBuffer s, String ss, int x) {
        if (x >= 0) {
            s.append(ss);
            if (x != 256) {
                s.append(x == 257 ? "+" : (x == 255 ? "-" : String.valueOf(x)));
            }
            return true;
        }
        return false;
    }

    private boolean appendQProp(StringBuffer qlbuf, String queryProp) {
        int v = this.getQPropAsInt(queryProp);
        if (v != -1) {
            qlbuf.append(queryProp);
            if (queryProp.equals("u")) {
                return true;
            }
            qlbuf.append(v == -2 ? "*" : String.valueOf(v));
            return true;
        }
        return false;
    }

    private static void appendQueryAromaticity(StringBuffer s, int arom) {
        if (arom == 2) {
            s.append("A");
        } else if (arom == 1) {
            s.append("a");
        } else if (arom == 3) {
            s.append("A,a");
        }
    }

    public String getAtomSymbol(int opts, int aflags, int[] lcenter, CTransform3D preTransform) {
        String s;
        if ((opts & 1) == 0 && this.getAtno() != 136 && this.getAliasstr() != null && !(s = this.getAliasstr()).equals("")) {
            return SimpleTeX.convertShort2TeX(s, 0);
        }
        StringBuffer sbuf = new StringBuffer();
        if (lcenter != null) {
            lcenter[0] = -1;
        }
        boolean arom = false;
        if ((opts & 1) != 0 && (opts & 0x20) == 0) {
            for (int i = this.bondCount - 1; i >= 0; --i) {
                MolBond b = this.theBonds[i];
                if (b.getType() != 4) continue;
                arom = true;
                break;
            }
        }
        if (aflags == -1) {
            aflags = this.flags;
        }
        if ((opts & 1) != 0) {
            this.toStringSqBrackets(sbuf, opts, aflags, lcenter, arom);
            return sbuf.toString();
        }
        this.toStringNormal(sbuf, opts, aflags, lcenter, arom, preTransform);
        return sbuf.toString();
    }

    private void appendImplH(StringBuffer sbuf, int h) {
        sbuf.append('H');
        if (h > 1) {
            sbuf.append("_{");
            sbuf.append(h);
            sbuf.append('}');
        }
    }

    public String getQueryLabel() {
        String querystr = this.getQueryString();
        if (querystr == null) {
            querystr = "";
        }
        int f = this.countFlags;
        int atno = f & 0xFF;
        if (this.isQuery() && atno != 134 || this.getValenceProp() >= 0) {
            boolean empty;
            StringBuffer qlbuf = new StringBuffer();
            boolean islist = atno == 128 || atno == 129;
            boolean bl = empty = atno == 0;
            if (islist) {
                boolean notlist = atno == 129;
                int[] a = this.getList();
                if (notlist) {
                    qlbuf.append('!');
                }
                qlbuf.append('[');
                if (a != null) {
                    for (int j = 0; j < a.length; ++j) {
                        String s = MolAtom.symbolOf(a[j]);
                        qlbuf.append(s);
                        if (j == a.length - 1) continue;
                        qlbuf.append(',');
                    }
                }
                qlbuf.append(']');
            }
            if (qlbuf.length() > 0) {
                qlbuf.append(",");
            }
            qlbuf.append("(");
            if (!empty) {
                int arom;
                int qhcount = this.getQPropAsInt("H");
                int v = this.getValenceProp();
                boolean app = false;
                if (qhcount != -1) {
                    app = MolAtom.appendQProp(qlbuf, 'H', qhcount);
                }
                if (app) {
                    qlbuf.append(',');
                }
                if (MolAtom.appendQProp(qlbuf, 'h', this.getQPropAsInt("h"))) {
                    qlbuf.append(',');
                }
                if (MolAtom.appendQProp(qlbuf, 'v', v)) {
                    qlbuf.append(',');
                }
                if (MolAtom.appendQProp(qlbuf, 'X', this.getQPropAsInt("X"))) {
                    qlbuf.append(',');
                }
                if (MolAtom.appendQProp(qlbuf, 'D', this.getQPropAsInt("D"))) {
                    qlbuf.append(',');
                }
                if (MolAtom.appendQProp(qlbuf, 'R', this.getQPropAsInt("R"))) {
                    qlbuf.append(',');
                }
                if (MolAtom.appendQProp(qlbuf, 'r', this.getQPropAsInt("r"))) {
                    qlbuf.append(',');
                }
                if (this.appendQProp(qlbuf, "rb")) {
                    qlbuf.append(',');
                }
                if (this.appendQProp(qlbuf, "s")) {
                    qlbuf.append(',');
                }
                if (this.appendQProp(qlbuf, "u")) {
                    qlbuf.append(',');
                }
                if ((arom = this.getQueryAromaticity()) != 0) {
                    MolAtom.appendQueryAromaticity(qlbuf, arom);
                    qlbuf.append(",");
                }
            }
            int length = qlbuf.length();
            String qls = qlbuf.toString();
            if (length == 1) {
                qls = "";
            } else if (qls.substring(length - 2, length).equals(",(")) {
                qls = qls.substring(0, length - 2);
            } else if (qls.charAt(length - 1) == ',') {
                qls = qls.substring(0, length - 1) + ")";
            }
            return qls + (qls.length() > 1 && querystr.length() > 1 ? "," : "") + querystr;
        }
        return querystr;
    }

    private void toStringSqBrackets(StringBuffer sbuf, int opts, int flags, int[] lcenter, boolean arom) {
        int aamap;
        int val;
        sbuf.append('[');
        int f = this.countFlags;
        int atno = f & 0xFF;
        boolean islist = atno == 128 || atno == 129;
        boolean notlist = atno == 129;
        String querystr = this.getQueryString();
        boolean hasQueryStr = querystr != null;
        int qArom = this.getQueryAromaticity();
        if (querystr != null && !notlist && qArom == 0) {
            int qv;
            int absOx = MolAtom.numoxstatesOf(atno) > 0 ? Math.abs(MolAtom.oxstateOf(atno, 0)) : 4;
            int twicesb = this.twicesumbonds(true, false);
            int charge = Math.abs(this.getCharge());
            int freeValence = absOx - twicesb / 2 - charge;
            int x = this.getQPropAsInt("X");
            int h = this.getImplicitHcount();
            if (x >= 0) {
                freeValence = x - h - this.getBondCount();
                int n = freeValence = freeValence > 1 ? 3 : freeValence;
            }
            if ((qv = this.getValenceProp()) >= 0) {
                freeValence = qv - twicesb / 2;
            }
            if (atno == 7 || atno == 8 || atno == 16) {
                ++freeValence;
            }
            if (atno != 132 && freeValence > 2) {
                qArom = 3;
            }
        }
        boolean atomWritten = false;
        boolean propWritten = false;
        ExtraAtomProperties xprops = this.extraProperties;
        int massno = (f & 0x1FF00) >> 8;
        if (massno != 0 && (opts & 0x20) == 0) {
            sbuf.append(massno);
        }
        boolean empty = atno == 0;
        int[] alist = this.getList();
        if (islist && alist != null) {
            for (int j = 0; j < alist.length; ++j) {
                int atn = alist[j];
                if (notlist) {
                    sbuf.append('!');
                }
                String s = null;
                s = MolAtom.symbolOf(atn);
                if (qArom == 1 && !notlist) {
                    s = (opts & 0x10) == 0 && (opts & 0x40) != 0 || MolAtom.isAromaticSMILESSubset(atn) ? s.toLowerCase() : '#' + String.valueOf(atn) + "&a";
                } else if ((qArom == 3 || notlist) && atn != 9 && atn != 17 && atn != 35 && atn != 53 && atn != 85) {
                    s = '#' + String.valueOf(atn);
                }
                if ((opts & 0x10) != 0 && (s.equals("H") || s.equals("h"))) {
                    if (notlist) {
                        s = "#1";
                    } else if (s.equals("H")) {
                        s = "#1A";
                    } else if (s.equals("h")) {
                        s = "#1a";
                    }
                }
                if (lcenter != null) {
                    lcenter[0] = sbuf.length();
                    lcenter[1] = s.length();
                }
                sbuf.append(s);
                if (j == alist.length - 1 || notlist) continue;
                sbuf.append(',');
            }
            atomWritten = true;
        } else if (islist && alist == null) {
            sbuf.append("*");
            atomWritten = true;
        } else if (!empty || (flags & 7) != 0) {
            String s;
            int a = atno;
            String generic_atom_smarts = null;
            if (a == 136) {
                generic_atom_smarts = GENERIC_HASH.get(this.getAliasstr());
            }
            if (generic_atom_smarts != null) {
                s = generic_atom_smarts;
                atomWritten = true;
            } else if (a == 131 || a == 136 && generic_atom_smarts == null) {
                s = "";
                if (!hasQueryStr || qArom == 2 || qArom == 1) {
                    if (qArom != 2 && qArom != 1 || (opts & 0x20) != 0) {
                        s = "*";
                        atomWritten = true;
                    }
                    if (qArom == 2) {
                        s = "A";
                        atomWritten = true;
                    } else if (qArom == 1) {
                        s = "a";
                        atomWritten = true;
                    }
                }
            } else if (a == 132) {
                s = "!#1!#6";
                atomWritten = true;
            } else if (a == 134) {
                int rgid = this.getRgroup();
                s = "R" + rgid;
                atomWritten = true;
            } else {
                s = MolAtom.symbolOf(a);
                if (qArom == 1 || arom) {
                    s = (opts & 0x10) == 0 && (opts & 0x40) != 0 || MolAtom.isAromaticSMILESSubset(a) ? s.toLowerCase() : '#' + String.valueOf(a) + "&a";
                } else if ((qArom == 3 || qArom > 0 && (opts & 0x10) == 0) && atno != 9 && atno != 17 && atno != 35 && atno != 53 && atno != 85) {
                    s = '#' + String.valueOf(a);
                }
                if ((opts & 0x10) != 0 && s.equals("h")) {
                    s = "#1a";
                }
                atomWritten = true;
            }
            if (lcenter != null) {
                lcenter[0] = sbuf.length();
                lcenter[1] = s.length();
            }
            sbuf.append(s);
        }
        boolean ihaw = MolAtom.addChiSyms(sbuf, this.getBondCount(), flags, this.getAtno());
        int charge = this.getCharge();
        int hcount = this.getNonQueryImplicitHcount();
        int qhcount = this.getQPropAsInt("H");
        if (atomWritten && xprops != null && !empty && (opts & 0x30) != 0 && (this.getValenceProp() != -1 || xprops.isQuery())) {
            if ((islist || notlist || atno == 132) && (hcount > 0 || charge != 0) || this.hasSMARTSPropsExcluding("Ha")) {
                sbuf.append(';');
            } else if (qhcount != -1 && (islist || notlist || atno == 132)) {
                sbuf.append(';');
            }
        }
        if (qhcount != -1) {
            if (!ihaw) {
                propWritten |= MolAtom.appendQProp(sbuf, 'H', qhcount);
            }
        } else if (hcount > 0 && (opts & 0x30) == 0) {
            if (!ihaw) {
                sbuf.append('H');
            }
            if (hcount > 1) {
                sbuf.append(hcount);
            }
        }
        propWritten |= MolAtom.appendQProp(sbuf, 'h', this.getQPropAsInt("h"));
        if ((opts & 0x30) != 0) {
            propWritten |= MolAtom.appendQProp(sbuf, 'v', this.getValenceProp());
        }
        propWritten |= MolAtom.appendQProp(sbuf, 'X', this.getQPropAsInt("X"));
        if ((opts & 0x20) == 0) {
            val = this.getQPropAsInt("rb");
            if (val == -2) {
                val = 0;
                if (this.parentGraph != null) {
                    long[] sssrBondSet = this.parentGraph.getSSSRBondSetInLong();
                    for (int i = this.getBondCount() - 1; i >= 0; --i) {
                        int bondIdx = this.parentGraph.indexOf(this.getBond(i));
                        if ((sssrBondSet[bondIdx / 64] & 1L << 63 - bondIdx % 64) == 0L) continue;
                        ++val;
                    }
                }
            }
            propWritten |= MolAtom.appendQProp(sbuf, 'x', val);
        }
        propWritten |= MolAtom.appendQProp(sbuf, 'D', this.getQPropAsInt("D"));
        propWritten |= MolAtom.appendQProp(sbuf, 'R', this.getQPropAsInt("R"));
        propWritten |= MolAtom.appendQProp(sbuf, 'r', this.getQPropAsInt("r"));
        if ((opts & 0x20) == 0) {
            val = this.getQPropAsInt("s");
            if (val == -2) {
                val = 0;
                for (int i = this.getBondCount() - 1; i >= 0; --i) {
                    MolAtom a = this.getLigand(i);
                    if (a.getAtno() == 1 && a.getMassno() == 0) continue;
                    ++val;
                }
            }
            propWritten |= MolAtom.appendQProp(sbuf, 'D', val);
            val = this.getQPropAsInt("u");
            if (val == 1) {
                sbuf.append("$([*,#1]=,#,:[*,#1])");
                propWritten = true;
            }
        }
        if (((opts & 0x20) != 0 && !hasQueryStr || notlist || atno == 132) && qArom != 0) {
            sbuf.append(";");
            MolAtom.appendQueryAromaticity(sbuf, qArom);
        }
        if (charge != 0) {
            if (charge > 0) {
                sbuf.append('+');
            }
            if (charge == 2) {
                sbuf.append('+');
            } else if (charge == -2) {
                sbuf.append("--");
            } else if (charge == -1) {
                sbuf.append('-');
            } else if (charge != 1) {
                sbuf.append(charge);
            }
            propWritten = true;
        }
        if (hasQueryStr) {
            if (propWritten || atomWritten) {
                sbuf.append(";");
            }
            sbuf.append(querystr.substring(1, querystr.length() - 1));
        }
        if ((aamap = (flags & 0xFFC0000) >> 18) != 0) {
            sbuf.append(':');
            sbuf.append(String.valueOf(aamap));
        }
        sbuf.append(']');
    }

    private void toStringNormal(StringBuffer sbuf, int opts, int flags, int[] lcenter, boolean arom, CTransform3D preTransform) {
        int hdir;
        int hcount;
        String sa;
        boolean hydrit;
        int atno;
        int a = atno = this.countFlags & 0xFF;
        int f = this.countFlags;
        int massno = (f & 0x1FF00) >> 8;
        String isotope = "";
        if (massno != 0 && !this.isSpecIsotopeSymbolUsed()) {
            isotope = "^{" + massno + "}";
        }
        boolean bl = hydrit = (opts & 6) != 0 && !this.isQuery();
        if (atno == 131) {
            sa = "A";
        } else if (atno == 134) {
            int rgid = this.getRgroup();
            sa = rgid != 0 ? "R" + rgid : "R";
        } else if (atno == 136) {
            sa = this.getSymbol();
            if (sa == null) {
                sa = "";
            }
        } else {
            sa = this.getSymbol();
        }
        if (a == 0) {
            MolAtom.appendQProp(sbuf, 'v', this.getValenceProp());
            MolAtom.appendQProp(sbuf, 'X', this.getQPropAsInt("X"));
            MolAtom.appendQProp(sbuf, 'D', this.getQPropAsInt("D"));
            MolAtom.appendQProp(sbuf, 'R', this.getQPropAsInt("R"));
            MolAtom.appendQProp(sbuf, 'r', this.getQPropAsInt("r"));
            MolAtom.appendQProp(sbuf, 'H', this.getQPropAsInt("H"));
            MolAtom.appendQProp(sbuf, 'h', this.getQPropAsInt("h"));
            this.appendQProp(sbuf, "u");
            MolAtom.appendQProp(sbuf, "rb", this.getQPropAsInt("rb"));
            MolAtom.appendQProp(sbuf, 's', this.getQPropAsInt("s"));
            int arom_ = this.getQueryAromaticity();
            if (arom_ != 0) {
                MolAtom.appendQueryAromaticity(sbuf, arom_);
            }
        }
        int charge = (opts & 8) == 0 ? this.getCharge() : 0;
        int h = hcount = this.getNonQueryImplicitHcount();
        boolean explhvis = true;
        if ((opts & 4) != 0) {
            h += this.getExplicitHcount();
            explhvis = false;
        }
        if ((hdir = this.getPreferredLabelDir0(preTransform, h, explhvis)) == 2 && charge != 0 && hcount > 1) {
            hdir = 3;
        }
        if (a != 0) {
            if (hdir != 1) {
                if (hydrit && h != 0 && hdir == 2) {
                    sbuf.append('\t');
                    this.appendImplH(sbuf, h);
                    sbuf.append('\n');
                }
                sbuf.append(isotope);
                if (lcenter != null) {
                    lcenter[0] = sbuf.length();
                    lcenter[1] = sa.length();
                }
                sbuf.append(sa);
                if (hydrit && h != 0 && hdir == 0) {
                    this.appendImplH(sbuf, h);
                }
                if (charge != 0) {
                    this.appendCharge(sbuf, charge);
                }
                if (hydrit && h != 0 && hdir == 3) {
                    sbuf.append('\n');
                    sbuf.append('\t');
                    this.appendImplH(sbuf, h);
                }
            } else {
                if (charge != 0) {
                    this.appendCharge(sbuf, charge);
                }
                if (hydrit && h != 0) {
                    this.appendImplH(sbuf, h);
                }
                sbuf.append(isotope);
                if (lcenter != null) {
                    lcenter[0] = sbuf.length();
                    lcenter[1] = sa.length();
                }
                sbuf.append(sa);
            }
        } else if (charge != 0) {
            this.appendCharge(sbuf, charge);
        }
        if (lcenter != null) {
            lcenter[2] = hydrit && h != 0 && (hdir == 2 || hdir == 3) ? (hdir == 2 ? 1 : -1) : 0;
        }
    }

    private boolean hasNorthSouthBond(CTransform3D t, boolean north, boolean explh) {
        int n = explh ? this.bondCount : this.bondCount - this.getExplicitHcount();
        int sign = north ? 1 : -1;
        double dx = 0.0;
        double dy = 0.0;
        DPoint3 p0 = this.getLocation();
        t.transform(p0);
        DPoint3 p = new DPoint3();
        for (int i = 0; i < n; ++i) {
            MolBond b = this.theBonds[i];
            MolAtom a1 = b.getOtherAtom(this);
            if (a1.getAtno() == 0 && !explh) continue;
            a1.getLocation(p);
            t.transform(p);
            double r = b.getLength();
            dx = (p.x - p0.x) / r;
            dy = (p.y - p0.y) / r;
            if (!(Math.abs(dx) < 0.125) || !((double)sign * dy > 0.0)) continue;
            return true;
        }
        return false;
    }

    public int getPreferredLabelDir(CTransform3D pretr, int h) {
        return this.getPreferredLabelDir0(pretr, h, true);
    }

    private int getPreferredLabelDir0(CTransform3D pretr, int h, boolean explh) {
        if (h > 0 && this.bondCount == 0) {
            int a = this.getAtno();
            if (a == 9 || a == 17 || a == 35 || a == 53 || (a == 8 || a == 16 || a == 34 || a == 52 || a == 84) && h > 1) {
                return 1;
            }
            return 0;
        }
        int hdir = 0;
        if (this.bondCount != 0) {
            double[] bwght = new double[3];
            if (pretr != null) {
                this.bondweights0(bwght, pretr, explh);
            }
            if (bwght[0] > 0.125) {
                hdir = 1;
            }
            if (Math.abs(bwght[0]) < Math.abs(bwght[1])) {
                if (this.bondCount > 1) {
                    if (bwght[1] < -0.125) {
                        if (this.bondCount > 2 && !this.hasNorthSouthBond(pretr, true, explh)) {
                            hdir = 2;
                        }
                    } else if (bwght[1] > 0.125 && this.bondCount > 2 && !this.hasNorthSouthBond(pretr, false, explh)) {
                        hdir = 3;
                    }
                }
                if (h == 0 && this.bondCount == 1) {
                    int n = hdir = bwght[1] > 0.0 ? 3 : 2;
                }
            }
            if (hdir == 0 && this.bondCount == 2) {
                double f2;
                double f1 = this.getBondPhi(0, pretr);
                if (f1 > (f2 = this.getBondPhi(1, pretr))) {
                    double t = f1;
                    f1 = f2;
                    f2 = t;
                }
                double fA = 2.356194490192345;
                double fB = 0.7853981633974483;
                if (f1 < -2.356194490192345 && f2 < 0.7853981633974483 && f2 > -0.7853981633974483) {
                    hdir = f2 - f1 > Math.PI ? 3 : 2;
                } else if (f1 > -0.7853981633974483 && f1 < 0.7853981633974483 && f2 > 2.356194490192345) {
                    hdir = f2 - f1 > Math.PI ? 2 : 3;
                }
            }
        }
        return hdir;
    }

    private void appendCharge(StringBuffer sbuf, int charge) {
        int abscharge;
        boolean pos;
        boolean bl = pos = charge > 0;
        char sign = pos ? (char)'+' : (charge == -1 ? (char)NEGATIVE_CHARGE_CHAR : (char)'-');
        int n = abscharge = pos ? charge : -charge;
        if (this.getAtno() != 137) {
            sbuf.append("^{");
        }
        if (abscharge <= 1) {
            sbuf.append(sign);
        } else {
            sbuf.append(abscharge);
            sbuf.append(sign);
        }
        if (this.getAtno() != 137) {
            sbuf.append('}');
        }
    }

    public final boolean isQuery() {
        int a = this.countFlags & 0xFF;
        ExtraAtomProperties p = this.extraProperties;
        return this.isLinkNode() || p != null && p.isQuery() || this.isPseudoAndQuery(a) || a < IS_QUERY.length && IS_QUERY[a];
    }

    private boolean isPseudoAndQuery(int a) {
        String s;
        if (a == 136 && (s = this.getAliasstr()) != null) {
            return (s = SimpleTeX.convertShort2TeX(s, 0)).equals("M") || s.equals("X") || s.equals("AH") || s.equals("QH") || s.equals("MH") || s.equals("XH") || s.startsWith("G_");
        }
        return false;
    }

    public boolean isQProp() {
        if (this.isQuery()) {
            int f = this.countFlags;
            int atno = f & 0xFF;
            return atno == 0;
        }
        return false;
    }

    public boolean isImplicitizableH(int f) {
        if (this.getAtno() == 1) {
            MolAtom a;
            int ne;
            int nb = this.getBondCount();
            if (nb == 1 && (f & 0x40) == 0 && this.getLigand(0).getAtno() == 1) {
                return false;
            }
            if (nb == 1 && this.getLigand(0).getAtno() == 138) {
                return false;
            }
            if (nb == 1 && (f & 0x80) == 0 && (ne = (a = this.getLigand(0)).getBondCount()) == 2) {
                int s;
                MolBond b = a.getLigand(0) == this ? a.getBond(1) : a.getBond(0);
                MoleculeGraph m = this.getParent();
                MolAtom n1 = b.getCTAtom1();
                MolAtom n4 = b.getCTAtom4();
                if (n1 != null && n4 != null && ((s = m.getStereo2(b, n1, n4, true)) == 128 || s == 64)) {
                    return false;
                }
            }
            if (nb == 1 && (f & 0x400) == 0 && this.getLigand(0).hasValenceError()) {
                return false;
            }
            return !(nb != 1 || this.getMassno() != 0 && (f & 2) == 0 || this.getCharge() != 0 && (f & 4) == 0 || this.getRadical() != 0 && (f & 8) == 0 || this.getAtomMap() != 0 && (f & 0x10) == 0 || this.hasWedgedBond() && (f & 0x20) == 0);
        }
        return false;
    }

    public boolean isPseudo() {
        return this.getAtno() == 136;
    }

    public boolean isGeneric() {
        return this.getAtno() == 136 && GENERIC_HASH.get(this.getAliasstr()) != null;
    }

    public final boolean hasWedgedBond() {
        for (int i = 0; i < this.bondCount; ++i) {
            MolBond b = this.theBonds[i];
            if (b.getStereo1(this) == 0) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAromaticBond() {
        for (int i = 0; i < this.bondCount; ++i) {
            MolBond b = this.theBonds[i];
            if (b.getType() != 4) continue;
            return true;
        }
        return false;
    }

    public final boolean hasQueryBonds() {
        boolean hasQuery = false;
        for (int i = 0; i < this.bondCount && !hasQuery; ++i) {
            MolBond b = this.theBonds[i];
            int t = b.getType();
            if (t >= 1 && t <= 4 || t == 9 || t == 8) continue;
            hasQuery = true;
        }
        return hasQuery;
    }

    public final boolean hasSMARTSProps() {
        return this.hasSMARTSPropsExcluding("");
    }

    public final boolean hasSMARTSPropsExcluding(String exclude) {
        SmartsAtomQuerifierIface smaAtQuery = null;
        try {
            smaAtQuery = (SmartsAtomQuerifierIface)MarvinModule.load("chemaxon.marvin.io.formats.smiles.SmartsAtomQuerifierImpl");
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            System.err.println("Cannot load SmartsAtomQuerifierImpl module\n");
        }
        return smaAtQuery.hasSMARTSPropsExcluding(this, exclude);
    }

    public void setSMARTS(String s) throws SecurityException {
        SmartsAtomQuerifierIface smaAtQuery = null;
        try {
            smaAtQuery = (SmartsAtomQuerifierIface)MarvinModule.load("chemaxon.marvin.io.formats.smiles.SmartsAtomQuerifierImpl");
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            System.err.println("Cannot load SmartsAtomQuerifierImpl module\n");
        }
        smaAtQuery.setSMARTS(this, s);
    }

    public String getQuerystr() {
        return this.getQueryString();
    }

    public void setQuerystr(String s) {
        this.setQuerystr(s, 0);
    }

    public void setQuerystr(String s, int options) {
        SmartsAtomQuerifierIface smaAtQuery = null;
        try {
            smaAtQuery = (SmartsAtomQuerifierIface)MarvinModule.load("chemaxon.marvin.io.formats.smiles.SmartsAtomQuerifierImpl");
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            System.err.println("Cannot load SmartsAtomQuerifierImpl module\n");
        }
        smaAtQuery.setQuerystr(this, s, options);
    }

    public void setQueryString(String queryString) {
        if (queryString != null) {
            ExtraAtomProperties properties = this.getExtraProperties();
            properties.querystr = queryString;
        } else if (this.extraProperties != null) {
            this.extraProperties.querystr = null;
        }
    }

    public String getQueryString() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.querystr : null;
    }

    public void setAliasstr(String s) {
        ExtraAtomProperties p = this.extraProperties;
        if (p == null && s != null) {
            p = this.getExtraProperties();
        }
        if (p != null) {
            p.aliasstr = s;
        }
    }

    public String getAliasstr() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.aliasstr : null;
    }

    public void setExtraLabel(String s) {
        ExtraAtomProperties p = this.extraProperties;
        if (p == null && s != null) {
            p = this.getExtraProperties();
        }
        if (p != null) {
            p.extrastr = s;
        }
    }

    public void setExtraLabelColor(long rgbs) {
        ExtraAtomProperties p = this.extraProperties;
        if (p == null && rgbs != 0L) {
            p = this.getExtraProperties();
        }
        if (p != null) {
            p.extrargbs = rgbs;
        }
    }

    public void setExtraLabelColor(int rgb1, int rgb2) {
        this.setExtraLabelColor((long)rgb2 << 32 | (long)rgb1);
    }

    public String getExtraLabel() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.extrastr : null;
    }

    public long getExtraLabelColor() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.extrargbs : 0L;
    }

    public int getExtraLabelColor(int i) {
        ExtraAtomProperties p = this.extraProperties;
        if (p == null) {
            return 0;
        }
        return MolAtom.getExtraLabelColor(p.extrargbs, i);
    }

    public static int getExtraLabelColor(long rgbs, int i) {
        return i == 0 ? (int)(rgbs & 0xFFFFFFFFFFFFFFFFL) : (int)(rgbs >> 32);
    }

    public void clearExtraLabel() {
        ExtraAtomProperties p = this.extraProperties;
        if (p != null) {
            p.extrastr = null;
            p.extrargbs = 0L;
        }
    }

    public int[] getList() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.getList() : null;
    }

    public void setList(int[] l, int n) {
        ExtraAtomProperties p = this.extraProperties;
        if (l != null && n > 0 && p == null) {
            p = this.getExtraProperties();
        }
        if (p != null) {
            p.setList(l, n);
        }
        this.resetGrinv();
    }

    public void setList(int[] l) {
        this.setList(l, l != null ? l.length : 0);
    }

    public int getReactionStereo() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null ? p.getReactionStereo() : 0;
    }

    public void setReactionStereo(int r) {
        ExtraAtomProperties p = this.extraProperties;
        if (p == null && r != 0) {
            p = this.getExtraProperties();
        }
        if (p != null) {
            p.setReactionStereo(r);
        }
    }

    public void clear() {
        int f = this.countFlags & 0xFF8FFFFF;
        this.countFlags = f & 0xFFF1FFFF | 0x60000;
        this.flags &= 0x20000;
        this.atomSetFlags = 0;
        this.extraProperties = null;
        this.resetGrinv();
    }

    void clear(int zZ) {
        this.xCoordinate = 0.0;
        this.yCoordinate = 0.0;
        this.zCoordinate = 0.0;
        this.bondCount = 0;
        this.clear();
        this.countFlags = zZ & 0xFF | 0x60000;
    }

    public Object clone() {
        MolAtom a = new MolAtom(0, this.xCoordinate, this.yCoordinate, this.zCoordinate);
        a.set(this);
        return a;
    }

    public String toString() {
        String s = super.toString();
        int i = s.lastIndexOf(46);
        StringBuffer sb = new StringBuffer(i >= 0 ? s.substring(i + 1) : s);
        sb.append('[');
        String sym = this.getSymbol();
        sb.append(!sym.equals("") ? sym : MolAtom.nameOf(this.getAtno()));
        if (this.getSetSeq() != 0) {
            sb.append(",set");
            sb.append(this.getSetSeq());
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean insideLabel(double x, double y) {
        if (this.corners != null) {
            return x > this.corners[0] && x < this.corners[2] && y < this.corners[1] && y > this.corners[3];
        }
        return false;
    }

    public static int getAtomicNumber(String element) {
        int res = MolAtom.numOf(element);
        if (res <= 0) {
            throw new IllegalArgumentException("Unknown chemical element: " + element);
        }
        return res;
    }

    public static int numOf(String e) {
        Integer z = SYMBOL_HASH.get(e = e.trim());
        if (z != null) {
            return z;
        }
        if (e.startsWith("R")) {
            if (e.length() == 1) {
                return 134;
            }
            try {
                if (Integer.parseInt(e.substring(1)) >= 0) {
                    return 134;
                }
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
        return 0;
    }

    public static String symbolOf(int z) {
        return z < ELEM_SYMBOLS.length ? ELEM_SYMBOLS[z] : "";
    }

    public static String symbolOf(int z, int a) {
        if (z == 1) {
            if (a == 2) {
                return "D";
            }
            if (a == 3) {
                return "T";
            }
        }
        return z < ELEM_SYMBOLS.length ? ELEM_SYMBOLS[z] : "";
    }

    public static String nameOf(int z) {
        return z < LONG_NAMES.length ? LONG_NAMES[z] : "";
    }

    public static int electronegOf(int z) {
        return ELECTRONEGS[z];
    }

    public static int numoxstatesOf(int z) {
        return OXIDATION_STATES[z].length;
    }

    public static int oxstateOf(int z, int k) {
        return OXIDATION_STATES[z][k];
    }

    public static int maxAbsOxStateOf(int z) {
        if (z == 8) {
            return 3;
        }
        int l = OXIDATION_STATES[z].length;
        int max = 0;
        for (int i = 0; i < l; ++i) {
            int t = 0;
            t = Math.abs(OXIDATION_STATES[z][i]);
            max = max < t ? t : max;
        }
        return max;
    }

    public static int negOxOf(int z) {
        return z < NEGATIVE_OXIDATION.length ? NEGATIVE_OXIDATION[z] : 0;
    }

    public static int posOxOf(int z) {
        return z < POSITIVE_OXIDATION.length ? POSITIVE_OXIDATION[z] : 0;
    }

    public static int ionChargeOf(int z) {
        return z < ION_CHARGE.length ? ION_CHARGE[z] : 0;
    }

    public static double covalentRadiusOf(int z, int t) {
        return z < COVALENT_RADII[t].length ? COVALENT_RADII[t][z] : 0.5;
    }

    public static double naturalWeightOf(int z) {
        return PeriodicSystem.getMass(z);
    }

    public static int isotopeType(int z, int a) {
        int i = PeriodicSystem.indexOfIsotope(z, a);
        if (i < 0) {
            return 0;
        }
        return PeriodicSystem.getAbundance(z, a) != 0.0 ? 2 : 1;
    }

    public int twicesumbonds(boolean countH, boolean all2) {
        int x = 0;
        if (all2) {
            for (int i = this.bondCount - 1; i >= 0; --i) {
                boolean isH;
                MolAtom a = this.theBonds[i].getOtherAtom(this);
                if (a.getAtno() == 130) continue;
                boolean bl = isH = (a.countFlags & 0xFF) == 1;
                if (isH && !countH) continue;
                x += 2;
            }
        } else {
            int bcountbits = 0;
            for (int i = this.bondCount - 1; i >= 0; --i) {
                boolean isH;
                MolBond b = this.theBonds[i];
                MolAtom a = b.getOtherAtom(this);
                if (a.getAtno() == 130 || b.isCoordinate()) continue;
                boolean bl = isH = (a.countFlags & 0xFF) == 1;
                if (isH && !countH) continue;
                int btype = b.getType();
                x += MolBond.NUMELECTRONS[btype];
                int d = btype << 2;
                bcountbits = bcountbits & ~(15 << d) | (bcountbits >> d & 0xF) + 1 << d;
            }
            int bcount4 = bcountbits >> 16 & 0xF;
            int a = this.countFlags & 0xFF;
            int c = this.getCharge();
            if (bcount4 == 0 || bcount4 == 2 && a == 6 && c == 0 && (bcountbits >> 8 & 0xF) == 0) {
                return x;
            }
            int hcount = this.getNonQueryImplicitHcount();
            if (bcount4 == 3) {
                x = (a == 7 || a == 15) && c == 0 ? (x -= 3) : (a == 6 && c == -1 ? (x -= 3) : --x);
            } else if (bcount4 == 2) {
                int bcount1 = bcountbits >> 4 & 0xF;
                int bcount2 = bcountbits >> 8 & 0xF;
                if (bcount2 == 1) {
                    if (a == 6 || a == 8 || a == 16) {
                        x -= 2;
                    }
                } else if ((a == 7 || a == 15) && hcount + bcount1 - c == 1 || a == 6 && c != 0 && (hcount == 1 || bcount1 == 1) || (a == 8 || a == 16 || a == 34 || a == 52) && hcount - c == 0) {
                    x -= 2;
                }
            }
        }
        return x;
    }

    public void qpropCheck() {
        this.flags |= 0x8000;
        if (this.extraProperties != null && this.extraProperties.hasKnownQueryProps()) {
            int qH = this.getQPropAsInt("H");
            int qx = this.getQPropAsInt("X");
            int nbWithoutH = this.twicesumbonds(false, true) / 2;
            int nbWithH = qH > 0 ? nbWithoutH + qH : nbWithoutH;
            int qv = this.getValenceProp();
            int xh = this.twicesumbonds(true, false) / 2;
            int xqH = this.twicesumbonds(false, false) / 2 + qH;
            int r = this.getQPropAsInt("r");
            if (qx >= 0 && (nbWithH > qx || qx > 4) || nbWithH > 4 || (qH >= 0 && xqH > qv || xh > qv) && qv >= 0 || r >= 0 && r < 256 && (r < 3 || this.sringsize() < r)) {
                return;
            }
        } else {
            int xh;
            int qv = this.getValenceProp();
            if (qv >= 0 && (xh = this.twicesumbonds(true, false) / 2) > qv) {
                return;
            }
        }
        this.flags &= 0xFFFF7FFF;
    }

    public void valenceCheck() {
        if (this.parentGraph == null) {
            ValenceCheck.check(this);
        } else {
            MoleculeGraph.ValenceCheckState checkState = this.parentGraph.getValenceCheckState();
            if (checkState != MoleculeGraph.ValenceCheckState.OFF) {
                ValenceCheck.check(this, checkState == MoleculeGraph.ValenceCheckState.AMBIGUOUS_AROMATIC_ATOMS_IGNORED);
            }
        }
    }

    public void valenceCheck(int opts) {
        this.valenceCheck();
    }

    public void setCorners(double xnw, double ynw, double xse, double yse) {
        if (this.corners == null) {
            this.corners = new double[4];
        }
        this.corners[0] = xnw;
        this.corners[1] = ynw;
        this.corners[2] = xse;
        this.corners[3] = yse;
    }

    public void moveCorners(double diffx, double diffy) {
        if (this.corners != null) {
            this.corners[0] = this.corners[0] + diffx;
            this.corners[2] = this.corners[2] + diffx;
            this.corners[1] = this.corners[1] + diffy;
            this.corners[3] = this.corners[3] + diffy;
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int f) {
        this.flags = f;
        this.resetGrinv();
    }

    public void setFlags(int f, int mask) {
        this.flags = this.flags & ~mask | f & mask;
        this.resetGrinv();
    }

    public boolean isSelected() {
        return (this.flags & 0x20000) != 0;
    }

    public void setSelected(boolean sel) {
        this.flags = sel ? (this.flags |= 0x20000) : (this.flags &= 0xFFFDFFFF);
    }

    public boolean hasValenceError() {
        return (this.flags & 0x8000) != 0;
    }

    public void setValenceError(boolean v) {
        this.flags = v ? (this.flags |= 0x8000) : (this.flags &= 0xFFFF7FFF);
    }

    public boolean getStereoCare() {
        for (int i = 0; i < this.bondCount; ++i) {
            MolBond b = this.theBonds[i];
            if ((b.getFlags() & 0x200) == 0) continue;
            return true;
        }
        return false;
    }

    public int getStereoGroupType() {
        ExtraAtomProperties p = this.extraProperties;
        return p == null ? 0 : p.getStereoGroupType();
    }

    public void setStereoGroupType(int t) {
        ExtraAtomProperties p = this.extraProperties;
        if (p != null) {
            p.setStereoGroupType(t);
        } else if (t != 0) {
            p = this.getExtraProperties();
            p.setStereoGroupType(t);
        }
    }

    public int getStereoGroupNumber() {
        ExtraAtomProperties p = this.extraProperties;
        return p == null ? 1 : p.getStereoGroupNumber();
    }

    public void setStereoGroupNumber(int n) {
        ExtraAtomProperties p = this.extraProperties;
        if (p != null) {
            p.setStereoGroupNumber(n);
        } else if (n != 1) {
            p = this.getExtraProperties();
            p.setStereoGroupNumber(n);
        }
    }

    public boolean isSpecIsotopeSymbolUsed() {
        if (this.isSpecIsotopeSymbolPreferred()) {
            int z = this.getAtno();
            int a = this.getMassno();
            return z == 1 && (a == 2 || a == 3);
        }
        return false;
    }

    public boolean isSpecIsotopeSymbolPreferred() {
        ExtraAtomProperties p = this.extraProperties;
        return p != null && p.isSpecIsotopeSymbolPreferred();
    }

    public void setSpecIsotopeSymbolPreferred(boolean v) {
        ExtraAtomProperties p = this.extraProperties;
        if (p != null) {
            p.setSpecIsotopeSymbolPreferred(v);
        } else if (v) {
            p = this.getExtraProperties();
            p.setSpecIsotopeSymbolPreferred(v);
        }
    }

    private static final boolean addChiSyms(StringBuffer sb, int nb, int flags, int atno) {
        boolean ihaw = false;
        int par = flags & 7;
        if (par > 0) {
            sb.append("@");
            if ((par & 3) == 2) {
                sb.append("@");
            }
            if ((par & 4) == 4) {
                sb.append("?");
            }
            if (nb == 3 && atno != 7 && atno != 15 && atno != 16) {
                sb.append("H");
                ihaw = true;
            }
        }
        return ihaw;
    }

    private boolean isSpecialAromatic() {
        int atno = this.getAtno();
        int arom = 0;
        if (atno == 7 || atno == 15 || atno == 6 && this.getCharge() == -1) {
            for (int j = this.getBondCount() - 1; j >= 0; --j) {
                if (this.getBond(j).getType() != 4) continue;
                ++arom;
            }
        }
        return arom >= 2;
    }

    protected void add(MolBond b) {
        if (this.indexOf(b) < 0) {
            if (this.bondCount >= this.theBonds.length) {
                MolBond[] e = new MolBond[this.bondCount + 1];
                for (int i = 0; i < this.bondCount; ++i) {
                    e[i] = this.theBonds[i];
                }
                this.theBonds = e;
            }
            this.theBonds[this.bondCount++] = b;
        }
        if ((this.flags & 0x4000) != 0) {
            this.valenceCheck();
        }
    }

    public void pack() {
        if (this.bondCount < this.theBonds.length) {
            MolBond[] e = new MolBond[this.bondCount];
            for (int i = 0; i < this.bondCount; ++i) {
                e[i] = this.theBonds[i];
            }
            this.theBonds = e;
        }
    }

    protected void removeAllBonds() {
        this.bondCount = 0;
        for (int j = 0; j < this.theBonds.length; ++j) {
            this.theBonds[j] = null;
        }
    }

    protected void removeBond(MolBond bond) {
        for (int i = this.bondCount - 1; i >= 0; --i) {
            if (this.theBonds[i] != bond) continue;
            this.removeBond(i);
        }
    }

    protected void removeBond(int i) {
        for (int j = i + 1; j < this.bondCount; ++j) {
            this.theBonds[j - 1] = this.theBonds[j];
        }
        this.theBonds[--this.bondCount] = null;
        if ((this.flags & 0x4000) != 0) {
            if (this.isSpecialAromatic() && !this.hasValenceError()) {
                this.setImplicitHcount(this.getImplicitHcount() + 1);
            }
            if (this.getParent() != null) {
                this.valenceCheck();
            }
        }
        if (this.isLinkNode()) {
            int outerIdx1 = this.extraProperties.getLinkNodeOuterBondIdx(0);
            int outerIdx2 = this.extraProperties.getLinkNodeOuterBondIdx(1);
            if (outerIdx1 == i || outerIdx2 == i) {
                this.setMaxRepetitions(1);
                this.setMinRepetitions(1);
            } else {
                if (outerIdx1 > i) {
                    this.extraProperties.setLinkNodeOuterBondIdx(0, outerIdx1 - 1);
                }
                if (outerIdx2 > i) {
                    this.extraProperties.setLinkNodeOuterBondIdx(1, outerIdx2 - 1);
                }
            }
        }
    }

    public static int paritySign(int a, int b, int c, int d) {
        int t;
        int sign = 1;
        if (a > b) {
            t = a;
            a = b;
            b = t;
            sign = -sign;
        }
        if (a > c) {
            t = a;
            a = c;
            c = t;
            sign = -sign;
        }
        if (a > d) {
            t = a;
            a = d;
            d = t;
            sign = -sign;
        }
        if (b > c) {
            t = b;
            b = c;
            c = t;
            sign = -sign;
        }
        if (b > d) {
            t = b;
            b = d;
            d = t;
            sign = -sign;
        }
        if (c > d) {
            t = c;
            c = d;
            d = t;
            sign = -sign;
        }
        if (a == b || b == c || c == d) {
            sign = 0;
        }
        return sign;
    }

    public static boolean isSameParityClass(int i1, int i2, int i3, int i4, int j1, int j2, int j3, int j4) {
        int sign2;
        int sign1 = MolAtom.paritySign(i1, i2, i3, i4);
        return sign1 == (sign2 = MolAtom.paritySign(j1, j2, j3, j4));
    }

    public boolean isTerminalAtom() {
        int ehc = this.getExplicitHcount();
        int nb = this.getBondCount();
        return nb - ehc <= 1;
    }

    public boolean haveEqualProperties(MolAtom a) {
        if (this == a) {
            return true;
        }
        if ((this.flags & 0xFFFDFFFF) == (a.flags & 0xFFFDFFFF) && (this.countFlags & 0xFF8FFFFF) == (a.countFlags & 0xFF8FFFFF) && this.atomSetFlags == a.atomSetFlags) {
            if (this.extraProperties == null && a.extraProperties == null) {
                return true;
            }
            if (this.extraProperties != null && a.extraProperties != null) {
                return this.extraProperties.equals(a.extraProperties);
            }
        }
        return false;
    }

    protected int countAllAtoms() {
        return 1;
    }

    public int getLonePairCount() {
        MoleculeGraph parent = this.getParent();
        if (parent != null && parent instanceof MoleculeGraph) {
            this.index = parent.indexOf(this);
            if (this.index != -1) {
                return parent.getLonePairCount(this.index);
            }
        }
        return -1;
    }

    public int getElectronProp() {
        if (this.extraProperties != null) {
            return this.extraProperties.getElectronProp();
        }
        return 0;
    }

    private void initExtraProperties() {
        if (this.extraProperties == null) {
            this.extraProperties = new ExtraAtomProperties();
        }
    }

    public void setElectronProp(int eProp) {
        this.initExtraProperties();
        this.extraProperties.setElectronProp(eProp);
    }

    public void storeTemporaryObject(String key, Object val) {
        if (this.extraProperties == null) {
            this.extraProperties = new ExtraAtomProperties();
        }
        this.extraProperties.storeTemporaryObject(key, val);
    }

    public Object getTemporaryObject(String key) {
        if (this.extraProperties != null) {
            return this.extraProperties.getTemporaryObject(key);
        }
        return null;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int bits;
        Sgroup attachpsg;
        int rxnstereo;
        oos.writeByte(6);
        oos.writeShort(this.bondCount);
        for (int i = 0; i < this.bondCount; ++i) {
            oos.writeObject(this.theBonds[i]);
        }
        oos.writeInt(this.index);
        oos.writeObject(this.parentGraph);
        int control = 0;
        if (this.getX() != 0.0 || this.getY() != 0.0) {
            control |= 1;
        }
        if (this.getZ() != 0.0) {
            control |= 2;
        }
        if (this.getMassno() != 0) {
            control |= 4;
        }
        if (this.getCharge() != 0) {
            control |= 8;
        }
        if (this.getRadical() != 0) {
            control |= 0x10;
        }
        if (this.getNonQueryImplicitHcount() != 0) {
            control |= 0x20;
        }
        if (this.getSetSeq() != 0) {
            control |= 0x40;
        }
        if (this.getAtomMap() != 0) {
            control |= 0x80;
        }
        if (this.getResidueSeq() != 0 || this.getResidueType() != 0 || this.getResidueAtomId() != 0) {
            control |= 0x100;
        }
        if (this.getStereoGroupType() != 0 || this.getStereoGroupNumber() != 0) {
            control |= 0x200;
        }
        if (this.getRgroup() != 0 || this.getAttach() != 0) {
            control |= 0x400;
        }
        int f = this.getFlags();
        short pbits = 0;
        if ((f & 1) != 0) {
            pbits = (short)(pbits | 1);
        }
        if ((f & 2) != 0) {
            pbits = (short)(pbits | 2);
        }
        if ((f & 4) != 0) {
            pbits = (short)(pbits | 4);
        }
        if ((f & 8) != 0) {
            pbits = (short)(pbits | 8);
        }
        if ((f & 0x10) != 0) {
            pbits = (short)(pbits | 0x10);
        }
        if ((f & 0x20) != 0) {
            pbits = (short)(pbits | 0x20);
        }
        if ((f & 0x40) != 0) {
            pbits = (short)(pbits | 0x40);
        }
        if ((rxnstereo = this.getReactionStereo()) != 0) {
            pbits = rxnstereo == 1 ? (short)(pbits | 0x80) : (short)(pbits | 0x100);
        }
        if (pbits != 0) {
            control |= 0x800;
        }
        if (this.getList() != null || this.getQueryString() != null || this.getAliasstr() != null || this.getQProps() != null) {
            control |= 0x1000;
        }
        if (this.getHybridizationState() != 0) {
            control |= 0x2000;
        }
        if (this.getExtraLabel() != null || this.getExtraLabelColor() != 0L) {
            control |= 0x4000;
        }
        if (this.getMinRepetitions() != 1 || this.getMaxRepetitions() != 1) {
            control |= 0x8000;
        }
        if (this.getValenceProp() >= 0) {
            control |= 0x10000;
        }
        if ((attachpsg = this.getAttachParentSgroup()) != null) {
            control |= 0x20000;
        }
        if (this.getLinkNodeOuterAtom(0) != -1 || this.getLinkNodeOuterAtom(1) != -1) {
            control |= 0x40000;
        }
        if (this.isSpecIsotopeSymbolPreferred()) {
            control |= 0x80000;
        }
        oos.writeInt(control);
        if ((control & 1) != 0) {
            oos.writeDouble(this.getX());
            oos.writeDouble(this.getY());
        }
        if ((control & 2) != 0) {
            oos.writeDouble(this.getZ());
        }
        oos.writeShort(this.getAtno());
        if ((control & 4) != 0) {
            oos.writeShort(this.getMassno());
        }
        if ((control & 8) != 0) {
            oos.writeShort(this.getCharge());
        }
        if ((control & 0x10) != 0) {
            oos.writeByte(this.getRadical());
        }
        if ((control & 0x20) != 0) {
            oos.writeShort(this.getNonQueryImplicitHcount());
        }
        if ((control & 0x40) != 0) {
            oos.writeInt(this.getSetSeq());
        }
        if ((control & 0x80) != 0) {
            oos.writeInt(this.getAtomMap());
        }
        if ((control & 0x100) != 0) {
            oos.writeInt(this.getResidueSeq());
            oos.writeShort(this.getResidueType());
            oos.writeShort(this.getResidueAtomId());
        }
        if ((control & 0x200) != 0) {
            oos.writeByte(this.getStereoGroupType());
            oos.writeInt(this.getStereoGroupNumber());
        }
        if ((control & 0x400) != 0) {
            oos.writeShort(this.getRgroup());
            oos.writeByte(this.getAttach());
        }
        if ((control & 0x800) != 0) {
            oos.writeShort(pbits);
        }
        if ((control & 0x1000) != 0) {
            int[] list = this.getList();
            if (list != null) {
                oos.writeShort(list.length);
                for (int i = 0; i < list.length; ++i) {
                    oos.writeShort((short)list[i]);
                }
            } else {
                oos.writeShort(0);
            }
            oos.writeObject(this.getQueryString());
            oos.writeObject(this.getAliasstr());
            Map<String, Object> qprops = this.getQProps();
            if (qprops != null) {
                Set<String> keyset = qprops.keySet();
                oos.writeShort(keyset.size());
                for (String key : keyset) {
                    oos.writeObject(key);
                    oos.writeObject(qprops.get(key));
                }
            } else {
                oos.writeShort(0);
            }
        }
        if ((control & 0x2000) != 0) {
            oos.writeByte(this.getHybridizationState());
        }
        if ((control & 0x4000) != 0) {
            oos.writeObject(this.getExtraLabel());
            oos.writeLong(this.getExtraLabelColor());
        }
        if ((control & 0x8000) != 0) {
            oos.writeInt(this.getMinRepetitions());
            oos.writeInt(this.getMaxRepetitions());
        }
        if ((control & 0x10000) != 0) {
            oos.writeShort((short)this.getValenceProp());
        }
        if ((control & 0x20000) != 0) {
            oos.writeObject(attachpsg);
        }
        if ((control & 0x40000) != 0) {
            oos.writeInt(this.getLinkNodeOuterAtom(0));
            oos.writeInt(this.getLinkNodeOuterAtom(1));
        }
        int n = bits = this.isSelected() ? 1 : 0;
        if (this.hasValenceError()) {
            bits = (byte)(bits | 2);
        }
        if ((f & 0x4000) != 0) {
            bits = (byte)(bits | 4);
        }
        if ((f & 0x10000) != 0) {
            bits = (byte)(bits | 8);
        }
        if (this.corners != null) {
            bits = (byte)(bits | 0x10);
        }
        if (this.getElectronProp() != 0) {
            bits = (byte)(bits | 0x20);
        }
        if (this.getRgroupAttachmentPointOrder() != 0) {
            bits = (byte)(bits | 0x40);
        }
        oos.writeByte(bits);
        if ((bits & 0x10) != 0) {
            oos.writeByte((byte)this.corners.length);
            for (int i = 0; i < this.corners.length; ++i) {
                oos.writeDouble(this.corners[i]);
            }
        }
        if ((bits & 0x20) != 0) {
            oos.writeInt(this.getElectronProp());
        }
        if ((bits & 0x40) != 0) {
            oos.writeInt(this.getRgroupAttachmentPointOrder());
        }
        if (this.properties != null) {
            int size = this.properties.size();
            oos.writeInt(size);
            for (Map.Entry<String, Object> e : this.properties.entrySet()) {
                oos.writeObject(e.getKey());
                oos.writeObject(e.getValue());
            }
        } else {
            oos.writeInt(0);
        }
        this.writeBicycloStereoDescriptors(oos);
    }

    private void writeBicycloStereoDescriptors(ObjectOutputStream oos) throws IOException {
        BicycloStereoDescriptor[] descriptors = this.getBicycloStereo();
        int size = descriptors != null ? descriptors.length : 0;
        oos.writeInt(size);
        if (size > 0) {
            for (BicycloStereoDescriptor descriptor : descriptors) {
                descriptor.write(oos);
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        int properties_size;
        int l;
        String key;
        int i;
        short pbits;
        byte version = ois.readByte();
        if (version > 6) {
            throw new IOException("Cannot deserialize atom with future version (" + version + ")");
        }
        this.bondCount = ois.readShort();
        this.theBonds = new MolBond[this.bondCount];
        for (int i2 = 0; i2 < this.bondCount; ++i2) {
            this.theBonds[i2] = (MolBond)ois.readObject();
        }
        this.index = ois.readInt();
        this.parentGraph = (MoleculeGraph)ois.readObject();
        int control = version == 0 ? ois.readShort() : ois.readInt();
        double x = (control & 1) != 0 ? ois.readDouble() : 0.0;
        double y = (control & 1) != 0 ? ois.readDouble() : 0.0;
        double z = (control & 2) != 0 ? ois.readDouble() : 0.0;
        this.setXYZ(x, y, z);
        this.setAtno(ois.readShort());
        this.setMassno((control & 4) != 0 ? ois.readShort() : (short)0);
        this.setCharge((control & 8) != 0 ? ois.readShort() : (short)0);
        this.setRadical((control & 0x10) != 0 ? ois.readByte() : (byte)0);
        this.setImplicitHcount((control & 0x20) != 0 ? ois.readShort() : (short)0);
        this.setSetSeq((control & 0x40) != 0 ? ois.readInt() : 0);
        this.setAtomMap((control & 0x80) != 0 ? ois.readInt() : 0);
        this.setResidueType((control & 0x100) != 0 ? ois.readShort() : (short)0);
        this.setResidueAtomId((control & 0x100) != 0 ? ois.readShort() : (short)0);
        this.setResidueSeq((control & 0x100) != 0 ? ois.readInt() : 0);
        this.setStereoGroupType((control & 0x200) != 0 ? ois.readByte() : (byte)0);
        this.setStereoGroupNumber((control & 0x200) != 0 ? ois.readInt() : 0);
        this.setRgroup((control & 0x400) != 0 ? ois.readShort() : (version >= 2 ? (short)0 : 1));
        this.setAttach((control & 0x400) != 0 ? ois.readByte() : (byte)0);
        short s = pbits = (control & 0x800) != 0 ? ois.readShort() : (short)0;
        if ((control & 0x1000) != 0) {
            int l2 = ois.readShort();
            int[] list = new int[l2];
            for (int i3 = 0; i3 < l2; ++i3) {
                list[i3] = ois.readShort();
            }
            this.setList(list);
            String querystr = (String)ois.readObject();
            if (querystr != null) {
                ExtraAtomProperties xprops = this.getExtraProperties();
                xprops.querystr = querystr;
            }
            this.setAliasstr((String)ois.readObject());
            l2 = ois.readShort();
            for (i = 0; i < l2; ++i) {
                key = (String)ois.readObject();
                Object val = ois.readObject();
                this.setQProp(key, val);
            }
        }
        this.setHybridizationState((control & 0x2000) != 0 ? ois.readByte() : (byte)0);
        this.setExtraLabel((control & 0x4000) != 0 ? (String)ois.readObject() : null);
        this.setExtraLabelColor((control & 0x4000) != 0 ? ois.readLong() : 0L);
        if ((control & 0x8000) != 0) {
            this.setMinRepetitions(ois.readInt());
            this.setMaxRepetitions(ois.readInt());
        }
        this.setValenceProp((control & 0x10000) != 0 ? (int)ois.readShort() : -1);
        if ((control & 0x20000) != 0) {
            ExtraAtomProperties p = this.getExtraProperties();
            p.attachParentSgroup = (Sgroup)ois.readObject();
        }
        if ((control & 0x40000) != 0) {
            this.setLinkNodeOuterAtom(0, ois.readInt());
            this.setLinkNodeOuterAtom(1, ois.readInt());
        } else if ((control & 0x8000) != 0) {
            this.setLinkNodeDefaultOuters();
        }
        this.setSpecIsotopeSymbolPreferred((control & 0x80000) != 0);
        byte bits = ois.readByte();
        this.setSelected((bits & 1) != 0);
        this.setValenceError((bits & 2) != 0);
        int f = 0;
        if ((bits & 4) != 0) {
            f |= 0x4000;
        }
        if ((bits & 8) != 0) {
            f |= 0x10000;
        }
        if ((control & 0x800) != 0) {
            int rxnstereo;
            if ((pbits & 1) != 0) {
                f |= 1;
            }
            if ((pbits & 2) != 0) {
                f |= 2;
            }
            if ((pbits & 4) != 0) {
                f |= 4;
            }
            if ((pbits & 8) != 0) {
                f |= 8;
            }
            if ((pbits & 0x10) != 0) {
                f |= 0x10;
            }
            if ((pbits & 0x20) != 0) {
                f |= 0x20;
            }
            if ((pbits & 0x40) != 0) {
                f |= 0x40;
            }
            this.setReactionStereo((rxnstereo = pbits & 0x180) == 128 ? 1 : (rxnstereo == 256 ? 2 : 0));
        }
        this.setFlags(f, 82047);
        if ((bits & 0x10) != 0) {
            int l3 = ois.readByte();
            this.corners = new double[l3];
            for (i = 0; i < l3; ++i) {
                this.corners[i] = ois.readDouble();
            }
        }
        if ((bits & 0x20) != 0 && (l = ois.readInt()) != 0) {
            this.setElectronProp(l);
        }
        if ((bits & 0x40) != 0 && (l = ois.readInt()) != 0) {
            this.setRgroupAttachmentPointOrder(l);
        }
        if (version > 3 && (properties_size = ois.readInt()) != 0) {
            this.properties = new HashMap();
            for (i = 0; i < properties_size; ++i) {
                key = (String)ois.readObject();
                Object value = ois.readObject();
                this.properties.put(key, value);
            }
        }
        this.readBicycloStereoDescriptors(ois, version);
    }

    private void readBicycloStereoDescriptors(ObjectInputStream ois, int version) throws IOException, ClassNotFoundException {
        int size;
        if (version > 5 && (size = ois.readInt()) > 0) {
            BicycloStereoDescriptor[] descriptors = new BicycloStereoDescriptor[size];
            for (int i = 0; i < size; ++i) {
                descriptors[i] = new BicycloStereoDescriptor();
                descriptors[i].read(ois, this.getParent());
            }
            this.setBicycloStereo(descriptors);
        }
    }

    public void setLinkNodeDefaultOuters() {
        int i;
        for (i = 0; i < Math.min(2, this.getBondCount()); ++i) {
            if (this.getLinkNodeOuterAtom(i) != -1) continue;
            this.setLinkNodeOuterAtom(i, i);
        }
        while (i < 2) {
            this.setLinkNodeOuterAtom(i, -1);
            ++i;
        }
    }

    public boolean isAmbiguousStereo() {
        int dim = 2;
        MoleculeGraph p = this.getParent();
        if (p != null) {
            dim = p.getDim();
        }
        int n_wedge = 0;
        boolean hasWiggly = false;
        for (int i = 0; i < this.getBondCount(); ++i) {
            MolBond b = this.getBond(i);
            int f = b.getFlags();
            if ((f & 0x30) == 48) {
                hasWiggly = true;
                continue;
            }
            if ((f & 0x30) == 0) continue;
            ++n_wedge;
        }
        if (dim == 2 && hasWiggly && n_wedge > 0) {
            return true;
        }
        if (p != null && n_wedge > 0) {
            int ec = this.getBondCount();
            int impH = this.getImplicitHcount();
            int expH = 0;
            for (int j = ec - 1; j >= 0; --j) {
                MolAtom l = this.getLigand(j);
                if (l.getAtno() != 1 || l.getMassno() != 0) continue;
                ++expH;
            }
            if (ec + impH == 4 && impH + expH < 2) {
                if (dim == 3 && (hasWiggly || n_wedge > 0)) {
                    return true;
                }
                int lp = p.getLocalParity(p.indexOf(this));
                if (lp == 0 || lp == 3) {
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean isAromaticSMILESSubset(int atno) {
        return atno == 6 || atno == 7 || atno == 8 || atno == 15 || atno == 16 || atno == 33 || atno == 34 || atno == 131;
    }

    public final int getEdgeCount() {
        return this.getBondCount();
    }

    public final MolBond getEdge(int i) {
        return this.getBond(i);
    }

    public final MolBond getEdgeTo(MolAtom other) {
        return this.getBondTo(other);
    }

    public boolean haveSimilarEdges(MolAtom a) {
        return this.haveSimilarBonds(a);
    }

    public Set<Map.Entry<String, Object>> propertySet() {
        return this.properties == null ? new HashMap().entrySet() : this.properties.entrySet();
    }

    public Set<String> propertyKeySet() {
        return this.properties == null ? new HashMap().keySet() : this.properties.keySet();
    }

    public boolean containsPropertyKey(String key) {
        return this.properties == null ? false : this.properties.containsKey(key);
    }

    public Object removeProperty(String key) {
        return this.properties == null ? null : this.properties.remove(key);
    }

    public int propertyCount() {
        return this.properties == null ? 0 : this.properties.size();
    }

    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    public void putProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
    }

    public void clearProperties() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    public void setRgroupAttachmentPointOrder(int order) {
        this.initExtraProperties();
        this.extraProperties.order = order;
    }

    public int getRgroupAttachmentPointOrder() {
        return this.extraProperties == null ? 0 : this.extraProperties.order;
    }

    public MolAtom addRgroupAttachmentPoint(int order, int bondtype) {
        MoleculeGraph parent = this.getParent();
        MolAtom attachmentAtom = null;
        if (parent != null) {
            attachmentAtom = new MolAtom(138);
            MolBond bond = new MolBond(this, attachmentAtom, bondtype);
            parent.add(attachmentAtom);
            parent.add(bond);
        }
        attachmentAtom.setRgroupAttachmentPointOrder(order);
        return attachmentAtom;
    }

    final void insertBond(int i, MolBond bond) {
        int nullCount = i < this.bondCount ? 1 : i - this.bondCount + 1;
        int position = i < this.bondCount ? i : this.bondCount;
        this.insertNullBonds(position, nullCount);
        this.theBonds[i] = bond;
    }

    private void insertNullBonds(int i, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("cannot insert " + count + " bonds");
        }
        if (count == 0) {
            return;
        }
        if (this.bondCount + count > this.theBonds.length) {
            MolBond[] newBonds = new MolBond[this.bondCount + count];
            System.arraycopy(this.theBonds, 0, newBonds, 0, i);
            System.arraycopy(this.theBonds, i, newBonds, i + count, this.bondCount - i);
            this.theBonds = newBonds;
        } else {
            System.arraycopy(this.theBonds, i, this.theBonds, i + count, this.bondCount - i);
            for (int j = i; j < i + count; ++j) {
                this.theBonds[j] = null;
            }
        }
        this.bondCount += count;
    }

    private int indexOf(MolAtom atom) {
        for (int i = 0; i < this.bondCount; ++i) {
            if (this.theBonds[i] == null || this.theBonds[i].getAtom1() != atom && this.theBonds[i].getAtom2() != atom) continue;
            return i;
        }
        return -1;
    }

    public int getLigandOrder(MolAtom ligand) {
        return this.getLigandIndex(ligand) + 1;
    }

    public boolean setLigandOrder(int order, MolAtom ligand) {
        if (order > this.bondCount) {
            return false;
        }
        int index = order - 1;
        int bondIndex = this.indexOf(ligand);
        if (bondIndex == -1) {
            return false;
        }
        MolBond tmpBond = this.theBonds[bondIndex];
        this.theBonds[bondIndex] = this.theBonds[index];
        this.theBonds[index] = tmpBond;
        return true;
    }

    public BicycloStereoDescriptor[] getBicycloStereo() {
        if (this.extraProperties != null) {
            return this.extraProperties.getBicycloStereo();
        }
        return null;
    }

    public void setBicycloStereo(BicycloStereoDescriptor[] descriptors) {
        this.initExtraProperties();
        this.extraProperties.setBicycloStereo(descriptors);
    }

    static {
        int i;
        STANDARD_RESIDUES = new String[35];
        RESIDUE_HASH = new HashMap<String, Integer>();
        ELEM_SYMBOLS = new String[139];
        SYMBOL_HASH = new HashMap<String, Integer>();
        LONG_NAMES = new String[139];
        IS_QUERY = new boolean[139];
        ELECTRONEGS = new int[139];
        OXIDATION_STATES = new int[139][];
        NEGATIVE_OXIDATION = new int[139];
        POSITIVE_OXIDATION = new int[139];
        ION_CHARGE = new int[139];
        COVALENT_RADII = new double[8][139];
        IS_BOND_ALLOWED = new boolean[139][139][4];
        GENERIC_HASH = new HashMap<String, String>();
        String jver = System.getProperty("java.version");
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows") && jver.startsWith("1.3") || jver.startsWith("1.1")) {
            RADICAL_CHAR = (char)183;
            NEGATIVE_CHARGE_CHAR = (char)45;
        } else {
            RADICAL_CHAR = (char)8226;
            NEGATIVE_CHARGE_CHAR = (char)8211;
        }
        StringTokenizer st = new StringTokenizer("0  100000-00Nothing\nH  1e----L2B1Hydrogen\nHe 5d----010Helium\nLi 7b0000A210Lithium\nBe 5a0000F220Beryllium\nB  520000K13Boron\nC  4d433cP3E42Carbon\nN  463e37U4D352Nitrogen\nO  4237--Z1COxygen\nF  480000e1BFluorine\nNe 47----010Neon\nNa 9a00009210Sodium\nMg 880000C220Magnesium\nAl 760000F3310Aluminium\nSi 6f0000I14Silicon\nP  6a0000L3D35Phosphorus\nS  660000P4C246Sulfur\nCl 640000U5B1357Chlorine\nAr 62----010Argon\nK  ca00008210Potassium\nCa ae0000A220Calcium\nSc 900000DM3Scandium\nTi 840000FM4Titanium\nV  7a0000GM5Vanadium\nCr 760000GM6Chromium\nMn 750000FM7Manganese\nFe 750000IM6Iron\nCo 730000IM3Cobalt\nNi 720000IM3Nickel\nCu 750000JM2Copper\nZn 7d0000GM2Zinc\nGa 7e0000G230Gallium\nGe 7a0000I14Germanium\nAs 780000K3D35Arsenic\nSe 730000O3C46Selenium\nBr 710000S4B135Bromine\nKr 70----0202Krypton\nRb d800008210Rubidium\nSr bf0000A220Strontium\nY  a20000DM3Yttrium\nZr 910000EM4Zirconium\nNb 860000GM5Niobium\nMo 820000IM6Molybdenum\nTc 7f0000JM7Technetium\nRu 7d0000MM8Ruthenium\nRh 7d0000MM4Rhodium\nPd 800000MM4Palladium\nAg 860000JM1Silver\nCd 940000HM2Cadmium\nIn 900000H230Indium\nSn 8d0000I3420Tin\nSb 8c0000J3D35Antimony\nTe 880000L3C46Tellurium\nI  850000P5B1357Iodine\nXe 83----0502468Xenon\nCs eb00007210Caesium\nBa c600009220Barium\nLa a90000BM3Lanthanum\nCe a50000BM4Cerium\nPr a50000BM4Praseodymium\nNd a40000CM3Neodymium\nPm a300000M3Promethium\nSm a20000CM3Samarium\nEu b900000M3Europium\nGd a10000BM3Gadolinium\nTb 9f0000CM4Terbium\nDy 9f00000M3Dysprosium\nHo 9e0000CM3Holmium\nEr 9d0000CM3Erbium\nTm 9c0000CM3Thulium\nYb ae0000BM3Ytterbium\nLu 9c----CM3Lutetium\nHf 900000DM4Hafnium\nTa 860000FM5Tantalum\nW  820000HM6Tungsten\nRe 800000JM7Rhenium\nOs 7e0000MM8Osmium\nIr 7f0000MM6Iridium\nPt 820000MM4Platinum\nAu 860000OM3Gold\nHg 950000JM2Mercury\nTl 940000I3130Thallium\nPb 930000I3240Lead\nBi 920000J3350Bismuth\nPo 920000K224Polonium\nAt 910000M5B1357Astatine\nRn 99----0202Radon\nFr 9900007210Francium\nRa 990000B220Radium\nAc 990000BM3Actinium\nTh a50000DM4Thorium\nPa 990000FM5Protactinium\nU  8e0000HM6Uranium\nNp 990000DM6Neptunium\nPu 990000DM6Plutonium\nAm 990000DM6Americium\nCm 9900000M3Curium\nBk 9900000M4Berkelium\nCf 9900000M3Californium\nEs 9900000M3Einsteinium\nFm 9900000M3Fermium\nMd 9900000M2Mendelevium\nNo 9900000M2Nobelium\nLr 99----0M3Lawrencium\nRf 9900000M4Rutherfordium\nDb 9900000M5Dubnium\nSg 99000000Seaborgium\nBh 99000000Bohrium\nHs 99000000Hessium\nMt 99000000Meitnerium\n---SPEC_ATNOS---\nL  4d433c00Atom list\n~L 4d433c00Not list\nLP 4d433c00Lonely pair\nA  4d433c00Any atom\nQ  4d433c00Heteroatom\n*  4d433c00Star atom\nR# 4d433c00Rgroup label\nSG 4d433c00Sgroup label\npsa4d433c00Pseudoatom\n   10000000Multicenter\n   10000000Rgroup attachment", "\n");
        boolean[][] allowbond = new boolean[ELEM_SYMBOLS.length][4];
        double[][] radii = COVALENT_RADII;
        for (i = 0; i < ELEM_SYMBOLS.length; ++i) {
            String sym;
            String s = st.nextToken();
            if (s.equals("---SPEC_ATNOS---")) {
                i = 127;
                continue;
            }
            MolAtom.ELEM_SYMBOLS[i] = sym = s.substring(0, 3).trim();
            SYMBOL_HASH.put(sym, new Integer(i));
            try {
                int x3;
                int x2;
                int x1 = Integer.parseInt(s.substring(3, 5), 16);
                radii[1][i] = (double)x1 * 0.01;
                String s2 = s.substring(5, 7);
                String s3 = s.substring(7, 9);
                allowbond[i][1] = true;
                allowbond[i][2] = !s2.equals("--");
                allowbond[i][3] = !s3.equals("--");
                int n = x2 = s2.equals("--") ? 0 : Integer.parseInt(s2, 16);
                if (x2 == 0) {
                    x2 = (int)(0.87 * (double)x1 + 0.5);
                }
                radii[2][i] = (double)x2 * 0.01;
                int n2 = x3 = s3.equals("--") ? 0 : Integer.parseInt(s3, 16);
                if (x3 == 0) {
                    x3 = (int)(0.9 * (double)x2 + 0.5);
                }
                radii[3][i] = (double)x3 * 0.01;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            char c = s.charAt(9);
            int n = c >= 'a' ? c - 97 + 36 : (MolAtom.ELECTRONEGS[i] = c >= 'A' ? c - 65 + 10 : c - 48);
            if (s.charAt(10) == 'M') {
                int maxox = s.charAt(11) - 48;
                MolAtom.OXIDATION_STATES[i] = new int[maxox + 1];
                for (int j = 0; j <= maxox; ++j) {
                    MolAtom.OXIDATION_STATES[i][j] = j;
                    MolAtom.NEGATIVE_OXIDATION[i] = 0;
                    MolAtom.POSITIVE_OXIDATION[i] = 1;
                }
                MolAtom.LONG_NAMES[i] = s.substring(12);
            } else {
                int noxstates = s.charAt(10) - 48;
                MolAtom.OXIDATION_STATES[i] = new int[noxstates];
                if (noxstates != 0) {
                    int m = 10;
                    MolAtom.NEGATIVE_OXIDATION[i] = 0;
                    MolAtom.POSITIVE_OXIDATION[i] = 0;
                    for (int j = 0; j < noxstates; ++j) {
                        int o;
                        char x = s.charAt(11 + j);
                        MolAtom.OXIDATION_STATES[i][j] = o = x >= 'A' ? 65 - x : x - 48;
                        if (o < 0) {
                            MolAtom.NEGATIVE_OXIDATION[i] = o;
                            continue;
                        }
                        if (o <= 0 || o >= m) continue;
                        m = o;
                    }
                    if (m > 0) {
                        MolAtom.POSITIVE_OXIDATION[i] = m;
                    }
                }
                MolAtom.LONG_NAMES[i] = s.substring(11 + noxstates);
            }
            boolean bl = MolAtom.IS_QUERY[i] = i == 131 || i == 132 || i == 128 || i == 129 || i == 134;
            if (PeriodicSystem.isNobleGas(i)) {
                allowbond[i][1] = false;
            }
            MolAtom.ION_CHARGE[i] = NEGATIVE_OXIDATION[i] < 0 ? NEGATIVE_OXIDATION[i] : POSITIVE_OXIDATION[i];
        }
        SYMBOL_HASH.put("D", new Integer(1));
        SYMBOL_HASH.put("T", new Integer(1));
        for (i = 0; i < radii[0].length; ++i) {
            radii[4][i] = (radii[1][i] + radii[2][i]) / 2.0;
            double d = radii[1][i];
            radii[7][i] = d;
            radii[6][i] = d;
            radii[5][i] = d;
            radii[0][i] = d;
        }
        for (i = 0; i < IS_BOND_ALLOWED.length; ++i) {
            for (int j = 0; j < IS_BOND_ALLOWED.length; ++j) {
                for (int k = 1; k <= 3; ++k) {
                    MolAtom.IS_BOND_ALLOWED[i][j][k] = allowbond[i][k] && allowbond[j][k];
                }
            }
        }
        st = new StringTokenizer("UNK A +A C +C G +G T +T I +I U +U Ala Arg Asn Asp Cys Gln Glu Gly His Ile Leu Lys Met Phe Pro Ser Thr Trp Tyr Val Asx Glx");
        i = 0;
        while (st.hasMoreTokens()) {
            String s;
            MolAtom.STANDARD_RESIDUES[i] = s = st.nextToken();
            RESIDUE_HASH.put(s.toUpperCase(), new Integer(i));
            ++i;
        }
        st = new StringTokenizer("AH*,#1\nQH#1,!#6\nX F,Cl,Br,I\nXHF,Cl,Br,I,#1\nM !#1!#2!#5!#6!#7!#8!#9!#10!#14!#15!#16!#17!#18!#33!#34!#35!#36!#52!#53!#54!#85!#86\nMH!#2!#5!#6!#7!#8!#9!#10!#14!#15!#16!#17!#18!#33!#34!#35!#36!#52!#53!#54!#85!#86\n", "\n");
        i = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            String sym = s.substring(0, 2).trim();
            String smarts = s.substring(2);
            GENERIC_HASH.put(sym, smarts);
            ++i;
        }
    }
}

