/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.core.calculations.Aromata;
import chemaxon.core.calculations.DearomatizePlus;
import chemaxon.core.calculations.ElementalAnalysisCalc;
import chemaxon.core.calculations.LonePairCounter;
import chemaxon.core.calculations.Parity;
import chemaxon.core.spi.CleanerIface;
import chemaxon.core.spi.HydrogenizeIface;
import chemaxon.core.util.BondTable;
import chemaxon.core.util.GeomUtil;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.BicycloStereoDescriptor;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.Gearch;
import chemaxon.struc.Incomplecule;
import chemaxon.struc.MDocument;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MTransformable;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Smolecule;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.gearch.MoleculeGraphGearch;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class MoleculeGraph
implements Incomplecule,
MTransformable,
StereoConstants,
Serializable {
    private static final long serialVersionUID = -2053719583816270190L;
    protected static final int INITIAL_CAPACITY = 32;
    public static final int AROM_BASIC = 1;
    public static final int AROM_CHEMAXON = 1;
    public static final int AROM_GENERAL = 2;
    public static final int AROM_DAYLIGHT = 2;
    public static final int AROM_LOOSE = 3;
    public static final int AROM_SUBSTRUCTURE = 4;
    public static final int AROM_AMBIGUOUS = 5;
    public static final int DEAROM_GENERAL = 0;
    public static final int DEAROM_HUCKELCHECK = 1;
    public static final int DEAROM_HUCKELCHECK_EX = 2;
    public static final String INVALID_LINKNODE_MESSAGE = "Link node cannot be created from the specified configuration!";
    transient MDocument theDocument = null;
    protected static final int DIM_MASK = 3;
    private static final int ABS_STEREO_FLAG = 4;
    private static final int MULTICHIRAL_FLAG = 8;
    protected static final int AUTO_UNGROUP = 16;
    protected static final int VALENCE_CHECK = 32;
    protected static final int VALENCE_CHECK_AMBIGUOUS = 64;
    public static final int RMCLEANUP_NONE = 0;
    protected static final int RMCLEANUP_FIXCOMPONENT = 32;
    public static final int RMCLEANUP_ALL = -33;
    public static final int RMCLEANUP_EDGES = 1;
    public static final int CACHE_REMOVE_ALL = 0;
    public static final int CACHE_REMOVE_CACHEMEMORY = 1;
    public static final int RMCLEANUP_STEREO = 2;
    public static final int RMCLEANUP_MOBJECT = 4;
    public static final int RMCLEANUP_PARENTDOC = 64;
    public static final int GRINV_NOHYDROGEN = 1;
    public static final int GRINV_STEREO = 2;
    public static final int GRINV_OLDSTEREO = 4;
    public static final int GRINV_USEMAPS = 32;
    public static final int GRINV_VALUE_OPTIONS = 39;
    public static final int GRINV_DONT_STORE = 8;
    public static final int CACHE_REMOVE_GRINVMODULE = 2;
    public static final int CACHE_REMOVE_PARITYMODULE = 4;
    public static final int CACHE_REMOVE_AROMATAMODULE = 8;
    public static final int CACHE_REMOVE_SSSRMODULE = 16;
    public static final int CACHE_REMOVE_TABS = 32;
    public static final int MIN_RING_SIZE_FOR_TRANS_DB = 8;
    public static final int OMIT_POSTCLEAN = 1;
    public static final int FRAG_BASIC = 0;
    public static final int FRAG_KEEPING_MULTICENTERS = 1;
    public static final int FRAG_KEEPING_SGROUPS = 2;
    public static final int FRAG_TYPE_COUNT = 3;
    protected transient MoleculeGraph superGraph;
    protected transient MoleculeGraph parentGraph;
    protected transient MolAtom[] theAtoms;
    protected transient int atomCount;
    protected transient MolBond[] theBonds;
    protected transient int bondCount;
    protected transient double orix;
    protected transient double oriy;
    protected transient double oriz;
    private transient int flags = 98;
    protected transient long grinvCC = 0L;
    protected transient List<Object[]> cacheMemory;
    protected transient int[][] ctab = null;
    protected transient BondTable btab = null;
    protected transient MoleculeGraphGearch gearch = null;
    private transient Parity parityModule = null;
    private transient Aromata aromataModule = null;
    private transient int[] lonePairCounts = null;
    private transient long lonePairCountsGrinvCC = 0L;
    private transient int[] explicitLonePairCounts = null;
    protected transient MPropertyContainer propertyContainer;
    protected transient boolean useOnlyFirstAtomInStereoCalculation = true;
    private transient Smolecule theSmolecule = null;

    public MoleculeGraph(MoleculeGraph p, int na, int nb) {
        this.theAtoms = new MolAtom[na];
        this.theBonds = new MolBond[nb];
        this.atomCount = 0;
        this.bondCount = 0;
        if (p != null) {
            this.superGraph = p.superGraph;
            this.parentGraph = p;
        } else {
            this.superGraph = this;
            this.parentGraph = null;
        }
        if (p != null) {
            this.setLocation(p.getLocation());
        }
        this.propertyContainer = new MPropertyContainer();
        this.propertyContainer.molecule = this;
    }

    public MoleculeGraph() {
        this(null, 32, 32);
    }

    public final MoleculeGraph getParent() {
        return this.parentGraph;
    }

    public final MoleculeGraph getForefather() {
        return this.superGraph;
    }

    public final Object getLock() {
        return this.superGraph;
    }

    public void add(MolAtom atom) {
        this.addAtom0(atom);
        this.resetCtab();
    }

    public void add(MolBond bond) {
        this.addBond0(bond);
        bond.getAtom1().add(bond);
        bond.getAtom2().add(bond);
        this.resetCtab();
    }

    protected void addAtom0(MolAtom atom) {
        int i = this.addAtomWithoutChangingIt(atom);
        atom.parentGraph = this;
        atom.index = i;
    }

    protected final int addAtomWithoutChangingIt(MolAtom atom) {
        int i = this.atomCount;
        if (i >= this.theAtoms.length) {
            MolAtom[] newAtoms = new MolAtom[2 * (i + 1)];
            System.arraycopy(this.theAtoms, 0, newAtoms, 0, i);
            this.theAtoms = newAtoms;
        }
        this.theAtoms[i] = atom;
        ++this.atomCount;
        return i;
    }

    protected void addAtomToFragment(MolAtom atom) {
        this.add(atom);
    }

    protected void addBond0(MolBond bond) {
        int i = this.addBondWithoutChangingIt(bond);
        bond.setParent(this);
        bond.setIndex(i);
    }

    protected final int addBondWithoutChangingIt(MolBond bond) {
        int i = this.bondCount;
        if (i >= this.theBonds.length) {
            MolBond[] newBonds = new MolBond[2 * (i + 1)];
            System.arraycopy(this.theBonds, 0, newBonds, 0, i);
            this.theBonds = newBonds;
        }
        this.theBonds[i] = bond;
        ++this.bondCount;
        return i;
    }

    public void pack() {
        int n = this.atomCount;
        MolAtom[] newAtoms = new MolAtom[n];
        System.arraycopy(this.theAtoms, 0, newAtoms, 0, n);
        this.theAtoms = newAtoms;
        for (int i = 0; i < n; ++i) {
            this.theAtoms[i].pack();
        }
        n = this.bondCount;
        MolBond[] newBonds = new MolBond[n];
        System.arraycopy(this.theBonds, 0, newBonds, 0, n);
        this.theBonds = newBonds;
    }

    public void removeAtom(MolAtom atom) {
        this.removeAtom(atom, -33);
    }

    public void removeAtom(int i) {
        this.removeAtom(i, -33);
    }

    public void removeBond(MolBond bond) {
        this.removeBond(bond, -33);
    }

    public void removeBond(int i) {
        this.removeBond(i, -33);
    }

    public void removeAllBonds() {
        this.theBonds = new MolBond[32];
        this.bondCount = 0;
        for (int i = this.atomCount - 1; i >= 0; --i) {
            MolAtom a = this.theAtoms[i];
            a.removeAllBonds();
        }
        this.resetCtab();
    }

    public void removeAll() {
        this.atomCount = 0;
        this.bondCount = 0;
        this.theAtoms = new MolAtom[32];
        this.theBonds = new MolBond[32];
        this.resetCtab();
    }

    public MDocument getDocument() {
        MoleculeGraph p;
        MDocument doc = this.theDocument;
        if (doc == null && (p = this.getParent()) != null) {
            doc = p.getDocumentForChild(this);
        }
        return doc;
    }

    protected MDocument getParentDocument() {
        MDocument doc = this.theDocument;
        MoleculeGraph p = this;
        while (doc == null) {
            if ((p = p.getParent()) == null) {
                return null;
            }
            if (!(p instanceof MoleculeGraph)) continue;
            doc = p.theDocument;
        }
        return doc;
    }

    protected MDocument getDocumentForChild(MoleculeGraph g) {
        if (g == this) {
            return this.theDocument;
        }
        MoleculeGraph p = this.getParent();
        return p != null ? p.getDocumentForChild(g) : null;
    }

    public final Smolecule smol() {
        Smolecule m = this.theSmolecule;
        if (m == null) {
            this.theSmolecule = m = this.createSmolecule();
        }
        return m;
    }

    protected final Smolecule createSmolecule() {
        return new MySmolecule();
    }

    public void setDim(int d) {
        if (d != 0 && d != 2 && d != 3) {
            throw new IllegalArgumentException("Unknown molecule dimension in setDim: " + d);
        }
        if (this.getDim() != d && d == 0 && this.getBondCount() > 0 && this.getAtomCount() > 0) {
            int i;
            this.btab = this.getBondTable();
            this.ctab = this.getCtab();
            for (i = 0; i < this.getBondCount(); ++i) {
                MolBond b = this.getBond(i);
                int f = 0;
                if (!MolBond.CAN_BE_CTDOUBLE[b.getType()]) continue;
                f = b.getFlags() & 0x1C0;
                if ((f & 0xC0) != 192) {
                    int i2 = this.indexOf(b.getAtom1());
                    int i3 = this.indexOf(b.getAtom2());
                    if (this.canBeCTAtom(this.getAtom(i2), this.ctab[i2], this.btab.getBondIndexesToAtom(i2), i3, false) && this.canBeCTAtom(this.getAtom(i3), this.ctab[i3], this.btab.getBondIndexesToAtom(i3), i2, false)) {
                        if (this.getDim() != 0) {
                            f = this.hasBondWigglyNeighbour(b) || this.isDegenerateCTBond(b) ? 192 : b.calcStereo2() | f & 0x100;
                        }
                    } else if (this.getDim() == 0) {
                        f = 0;
                    }
                }
                b.setFlags(f, 448);
            }
            if (this.getDim() != 0) {
                for (i = 0; i < this.getAtomCount(); ++i) {
                    MolAtom atom = this.getAtom(i);
                    int bc = atom.getBondCount();
                    if (bc == 3 && atom.getImplicitHcount() == 1 || bc >= 4) {
                        int parity = this.getLocalParity(i);
                        atom.setFlags(parity, 7);
                        continue;
                    }
                    if (bc == 2) {
                        boolean dbbonly = true;
                        for (int j = 0; j < bc; ++j) {
                            MolBond b = atom.getBond(j);
                            if (b.getType() == 2) continue;
                            dbbonly = false;
                            break;
                        }
                        if (dbbonly) {
                            int parity = this.getLocalParity(i);
                            atom.setFlags(parity, 7);
                            continue;
                        }
                        atom.setFlags(0, 7);
                        continue;
                    }
                    atom.setFlags(0, 7);
                }
            }
        }
        this.setFlags(this.getFlags() & 0xFFFFFFFC | d & 3);
        this.resetGrinvInParents();
    }

    public int getDim() {
        return this.getFlags() & 3;
    }

    public int getFlags() {
        return this.flags;
    }

    protected void setFlags(int f) {
        this.flags = f;
    }

    public boolean isAbsStereo() {
        return (this.getFlags() & 4) != 0;
    }

    public void setAbsStereo(boolean c) {
        int f = this.getFlags();
        this.setFlags(c ? f | 4 : f & 0xFFFFFFFB);
    }

    public void clear() {
        this.theAtoms = new MolAtom[32];
        this.atomCount = 0;
        this.clearForImport(null);
    }

    public void clearForImport(String format2) {
        this.theBonds = new MolBond[32];
        this.bondCount = 0;
        this.ctab = null;
        this.btab = null;
        if (this.gearch != null) {
            this.gearch.clearResults();
        }
        this.incGrinvCC();
        this.orix = 0.0;
        this.oriy = 0.0;
        this.oriz = 0.0;
        this.setFlags(2, 3);
        this.aromataModule = null;
        this.lonePairCounts = null;
        this.lonePairCountsGrinvCC = 0L;
        this.explicitLonePairCounts = null;
    }

    public void removeAtom(MolAtom atom, int cleanupFlags) {
        int i = this.indexOf(atom);
        if (i >= 0) {
            this.removeAtom0(i, cleanupFlags);
        }
    }

    public void removeAtom(int i, int cleanupFlags) {
        this.removeAtom0(i, cleanupFlags);
    }

    private void removeAtom0(int i, int cleanupFlags) {
        MolAtom a = this.getAtom(i);
        if ((cleanupFlags & 1) != 0) {
            for (int j = 0; j < a.getBondCount(); ++j) {
                MolAtom ligand = a.getLigand(j);
                if (ligand.getLinkNodeOuterAtom(0) == -1 || ligand.getLinkNodeOuterAtom(1) == -1 || ligand.getLigand(ligand.getLinkNodeOuterAtom(0)) != a && ligand.getLigand(ligand.getLinkNodeOuterAtom(1)) != a) continue;
                if (ligand.getMinRepetitions() != 1 || ligand.getMaxRepetitions() != 1) {
                    ligand.setMaxRepetitions(1);
                    ligand.setMinRepetitions(1);
                }
                ligand.setLinkNodeOuterAtom(0, -1);
                ligand.setLinkNodeOuterAtom(1, -1);
            }
        }
        if (a.getAtno() == 1 && a.getMassno() == 0 && a.getBondCount() != 0) {
            MolAtom neib = a.getLigand(0);
            int iHcount = neib.getImplicitHcount();
            if (this.getDim() < 3) {
                this.removeH(i, cleanupFlags);
            } else {
                this.removeAtom00(i, cleanupFlags);
            }
            if ((cleanupFlags & 1) != 0) {
                neib.setImplicitHcount(iHcount + 1);
            }
        } else {
            this.removeAtom00(i, cleanupFlags);
        }
        MDocument doc = this.getParentDocument();
        if (doc != null && (cleanupFlags & 0x40) != 0) {
            doc.removeAtom(a, cleanupFlags);
        }
    }

    private void removeAtom00(int i, int cleanupFlags) {
        int j;
        MolAtom a = this.theAtoms[i];
        MolBond[] v = a.theBonds;
        --this.atomCount;
        System.arraycopy(this.theAtoms, i + 1, this.theAtoms, i, this.atomCount - i);
        this.theAtoms[this.atomCount] = null;
        if (a.getParent() == this) {
            a.parentGraph = null;
        }
        for (j = this.atomCount - 1; j >= i; --j) {
            MolAtom aa = this.getAtom(j);
            if (aa == null || aa.getParent() != this) continue;
            --aa.index;
        }
        for (j = a.bondCount - 1; j >= 0; --j) {
            this.removeBond(v[j], cleanupFlags);
        }
        this.resetCtab();
    }

    protected void setAtom0(int i, MolAtom atom) {
        MDocument doc;
        MoleculeGraph p;
        MolAtom old = this.getAtom(i);
        MoleculeGraph moleculeGraph = p = old != null ? old.getParent() : null;
        if (old != atom && old != null && old.getParent() == this) {
            old.parentGraph = null;
        }
        this.theAtoms[i] = atom;
        atom.parentGraph = this;
        atom.index = i;
        if (p == this && atom != old && (doc = this.getParentDocument()) != null) {
            doc.removeAtom(old, 0);
        }
    }

    public void setBond(int i, MolBond b) {
        MolAtom a1 = b.getAtom1();
        MolAtom a2 = b.getAtom2();
        int h1 = a1.getNonQueryImplicitHcount();
        int h2 = a2.getNonQueryImplicitHcount();
        MolBond old = this.theBonds[i];
        if (b != old && b.equals(old)) {
            for (int j = 0; j < this.atomCount; ++j) {
                MolAtom a = this.theAtoms[j];
                for (int k = 0; k < a.getBondCount(); ++k) {
                    if (a.getBond(k) != old) continue;
                    a.theBonds[k] = b;
                }
            }
        }
        this.theBonds[i] = b;
        b.setParent(this);
        b.setIndex(i);
        b.getAtom1().add(b);
        b.getAtom2().add(b);
        this.resetCtab();
        a1.setNonQueryImplicitHcount(h1);
        a2.setNonQueryImplicitHcount(h2);
    }

    public void replaceBond(MolBond oldb, MolBond newb) {
        int i = this.indexOf(oldb);
        if (i >= 0) {
            this.setBond(i, newb);
        }
    }

    public final void setAtomSetSeqs(int id) {
        MoleculeGraph u = this.getGraphUnion();
        for (int i = u.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = u.getAtom(i);
            a.setSetSeq(id);
        }
    }

    public final void setBondSetSeqs(int id) {
        MoleculeGraph u = this.getGraphUnion();
        for (int i = u.getBondCount() - 1; i >= 0; --i) {
            MolBond b = u.getBond(i);
            b.setSetSeq(id);
        }
    }

    public final void setSetSeqs(int id) {
        this.setAtomSetSeqs(id);
    }

    public int getGrinv(int[] gi) {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch.getGrinv(gi, this.gearch.getGrinvOptions());
    }

    public int getGrinv(int[] gi, boolean uniqueFlag) {
        return this.getGrinv(gi, uniqueFlag ? 4 : 0);
    }

    public int getGrinv(int[] gi, int options) {
        if (this.gearch == null) {
            this.regenGearch();
        }
        int r = this.gearch.getGrinv(gi, options);
        return r;
    }

    public int calcDehydrogenizedGrinv(int[] gi) {
        MoleculeGraph m = this.createDehydrogenizedReadOnlyGraph();
        int[] gi0 = new int[m.getAtomCount()];
        int n = m.getGrinv(gi0);
        int j = 0;
        for (int i = 0; i < this.getAtomCount(); ++i) {
            MolAtom a = this.getAtom(i);
            gi[i] = a.getAtno() != 1 || a.getMassno() != 0 ? gi0[j++] : -1;
        }
        return n;
    }

    protected MoleculeGraph createDehydrogenizedReadOnlyGraph() {
        int i;
        MoleculeGraph m = new MoleculeGraph();
        for (i = 0; i < this.getAtomCount(); ++i) {
            MolAtom a = this.getAtom(i);
            if (a.getAtno() == 1 && a.getMassno() == 0) continue;
            m.addAtomWithoutChangingIt(a);
        }
        for (i = 0; i < this.getBondCount(); ++i) {
            MolBond b = this.getBond(i);
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            if (a1.getAtno() == 1 && a1.getMassno() == 0 || a2.getAtno() == 1 && a2.getMassno() == 0) continue;
            m.addBondWithoutChangingIt(b);
        }
        return m;
    }

    protected int[] getGrinv() {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch.getGrinv();
    }

    public final long getGrinvCC() {
        return this.grinvCC;
    }

    protected final void setGrinvCC(long g) {
        this.grinvCC = g;
    }

    protected final void incGrinvCC() {
        if (this.gearch != null) {
            this.gearch.resetGrinv();
        }
        ++this.grinvCC;
    }

    public final void incGrinvCCOnly() {
        ++this.grinvCC;
    }

    protected void resetCtab() {
        MoleculeGraph p = this;
        do {
            p.ctab = null;
            MoleculeGraphGearch mgg = p.gearch;
            if (mgg != null) {
                mgg.clearResults();
            }
            p.incGrinvCC();
        } while ((p = p.parentGraph) != null);
    }

    protected final void resetGrinvInParents() {
        MoleculeGraph p = this;
        do {
            p.incGrinvCC();
        } while ((p = p.getParent()) != null);
    }

    protected void regenCtabs() {
        int na = this.atomCount;
        this.ctab = new int[na][];
        this.btab = BondTable.createBondTable(na);
        int[] tmp = new int[na];
        for (int i = 0; i < na; ++i) {
            MolAtom a = this.theAtoms[i];
            int k = 0;
            int nb = a.getBondCount();
            for (int j = 0; j < nb; ++j) {
                int iaa;
                MolBond b = a.getBond(j);
                MolAtom aa = b.getOtherAtom(a);
                int n = iaa = aa.getParent() == this ? aa.index : this.findAtom(aa);
                if (iaa < 0) continue;
                int ib = this.btab.getBondIndex(iaa, i);
                if (ib < 0) {
                    int n2 = ib = b.getParent() == this ? b.getIndex() : this.findBond(b);
                }
                if (ib < 0) continue;
                tmp[k++] = iaa;
                this.btab.setBondIndex(i, iaa, ib);
            }
            this.ctab[i] = new int[k];
            System.arraycopy(tmp, 0, this.ctab[i], 0, k);
        }
    }

    public boolean addExplicitHydrogens(int f) {
        return this.addExplicitHydrogens(f, null);
    }

    public boolean addExplicitHydrogens(int f, MolAtom[] atoms) {
        HydrogenizeIface hydrogenize = null;
        try {
            hydrogenize = (HydrogenizeIface)MarvinModule.load("chemaxon.calculations.hydrogenize.HydrogenizeUtil");
        }
        catch (SecurityException sex) {
            throw sex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (hydrogenize != null) {
            return hydrogenize.addHAtoms(this, atoms, f);
        }
        return false;
    }

    public boolean hydrogenize(boolean add) {
        return add ? this.addExplicitHydrogens(0, null) : this.implicitizeHydrogens0(33, null, true);
    }

    public void addExplicitLonePairs() {
        HydrogenizeIface hydrogenize = null;
        try {
            hydrogenize = (HydrogenizeIface)MarvinModule.load("chemaxon.calculations.hydrogenize.HydrogenizeUtil");
        }
        catch (SecurityException sex) {
            throw sex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (hydrogenize != null) {
            hydrogenize.addLonePairs(this, null);
        }
    }

    public void removeExplicitLonePairs() {
        HydrogenizeIface hydrogenize = null;
        try {
            hydrogenize = (HydrogenizeIface)MarvinModule.load("chemaxon.calculations.hydrogenize.HydrogenizeUtil");
        }
        catch (SecurityException sex) {
            throw sex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (hydrogenize != null) {
            hydrogenize.removeLonePairs(this);
        }
    }

    @Deprecated
    public final void implicitizeHydrogens(int f) {
        this.implicitizeHydrogens(f, null);
    }

    public void implicitizeHydrogens(int f, MolAtom[] atoms) {
        this.implicitizeHydrogens(f, atoms, true);
    }

    public void implicitizeHydrogens(int f, MolAtom[] atoms, boolean check) {
        this.implicitizeHydrogens0(f, atoms, check);
    }

    protected boolean implicitizeHydrogens0(int f, MolAtom[] atoms, boolean check) {
        HydrogenizeIface hydrogenize = null;
        try {
            hydrogenize = (HydrogenizeIface)MarvinModule.load("chemaxon.calculations.hydrogenize.HydrogenizeUtil");
        }
        catch (SecurityException sex) {
            throw sex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (hydrogenize != null) {
            return hydrogenize.removeHAtoms(this, atoms, f, check);
        }
        return false;
    }

    public void fuse(MoleculeGraph graph, boolean check) {
        this.fuse0(graph, check);
    }

    public final void fuse(MoleculeGraph graph) {
        this.fuse(graph, true);
    }

    protected void fuse0(MoleculeGraph g, boolean check) {
        int j;
        int i;
        if (g instanceof MoleculeGraph) {
            this.updateDim(g);
        }
        int na = this.atomCount;
        int nb = this.bondCount;
        for (i = 0; i < g.getAtomCount(); ++i) {
            MolAtom node = g.getAtom(i);
            int n = j = check ? this.indexOf(node) : -1;
            if (j < 0) {
                this.addAtom0(node);
                continue;
            }
            node.parentGraph = this;
            node.index = j;
        }
        for (i = 0; i < g.getBondCount(); ++i) {
            MolBond edge = g.getBond(i);
            int n = j = check ? this.indexOf(edge) : -1;
            if (j < 0) {
                MolAtom atom2;
                this.addBond0(edge);
                if (edge.getParent() != this) continue;
                MolAtom atom1 = edge.getAtom1();
                if (atom1.getParent() == this && atom1.indexOf(edge) < 0 && this.contains(atom1)) {
                    atom1.add(edge);
                }
                if ((atom2 = edge.getAtom2()).getParent() != this || atom2.indexOf(edge) >= 0 || !this.contains(atom2)) continue;
                atom2.add(edge);
                continue;
            }
            edge.setParent(this);
            edge.setIndex(j);
        }
        if (this.atomCount != na || this.bondCount != nb) {
            this.resetCtab();
        }
    }

    public void checkConsistency() {
        this.checkBondConsistency();
    }

    protected void checkBondConsistency() {
        MolBond b;
        int i;
        int bc = 0;
        boolean[] W = new boolean[this.getBondCount()];
        for (i = 0; i < this.getAtomCount(); ++i) {
            MolAtom a = this.getAtom(i);
            for (int j = 0; j < a.getBondCount(); ++j) {
                MolBond b2 = a.getBond(j);
                int k = this.indexOf(b2);
                if (k < 0) {
                    throw new RuntimeException("structure does not contain " + b2);
                }
                W[k] = true;
            }
            bc += a.getBondCount();
        }
        if (bc != 2 * this.getBondCount()) {
            throw new RuntimeException("bond count is inconsistent");
        }
        for (i = 0; i < W.length; ++i) {
            if (W[i]) continue;
            b = this.getBond(i);
            throw new RuntimeException("bond " + i + " = " + b + " is not known by any atom");
        }
        for (i = 0; i < this.getBondCount(); ++i) {
            b = this.getBond(i);
            if (b.getAtom1() == b.getAtom2()) {
                throw new RuntimeException("bond " + i + " = " + b + " connects atom " + b.getAtom1() + " with itself");
            }
            if (this.indexOf(b.getAtom1()) < 0) {
                throw new RuntimeException("structure does not contain the first endpoint of bond " + i + " = " + b + " (" + b.getAtom1() + ")");
            }
            if (this.indexOf(b.getAtom2()) >= 0) continue;
            throw new RuntimeException("structure does not contain the second endpoint of bond " + i + " = " + b + " (" + b.getAtom2() + ")");
        }
    }

    protected final void updateDim(MoleculeGraph m) {
        int d = m.getDim();
        if (this.isEmpty()) {
            this.setDim(d);
            this.setAbsStereo(m.isAbsStereo());
        } else if (d > this.getDim()) {
            this.setDim(d);
        }
    }

    public void mergeAtoms(MolAtom that, MolAtom a) {
        int i;
        MDocument doc;
        MolAtom maA;
        MolAtom maThat;
        MolBond outer0 = null;
        MolBond outer1 = null;
        int maxRep = 0;
        int minRep = 0;
        if (that instanceof MolAtom && (maThat = that).isLinkNode()) {
            outer0 = maThat.getBond(maThat.getLinkNodeOuterAtom(0));
            outer1 = maThat.getBond(maThat.getLinkNodeOuterAtom(1));
            minRep = maThat.getMinRepetitions();
            maxRep = maThat.getMaxRepetitions();
        }
        if (a instanceof MolAtom && (maA = a).isLinkNode()) {
            outer0 = maA.getBond(maA.getLinkNodeOuterAtom(0));
            outer1 = maA.getBond(maA.getLinkNodeOuterAtom(1));
            minRep = maA.getMinRepetitions();
            maxRep = maA.getMaxRepetitions();
        }
        if ((doc = this.getDocument()) == null && this.getParent() != null && this.getParent() instanceof RxnMolecule) {
            doc = this.getParent().getDocument();
        }
        if (doc != null && that instanceof MolAtom && a instanceof MolAtom) {
            doc.replaceAtomInGraphicsObjects(a, that);
        }
        int removedAtomIndex = -1;
        if (that != a) {
            block0: for (i = a.bondCount - 1; i >= 0; --i) {
                MolBond b = a.theBonds[i];
                int edgeIndex = this.indexOf(b);
                if (b.getAtom1() == a) {
                    b.setAtom1(that);
                }
                if (b.getAtom2() == a) {
                    b.setAtom2(that);
                }
                int j = that.indexOf(b);
                if (b.getAtom1() == that && b.getAtom2() == that) {
                    a.removeBond(i);
                    if (j >= 0) {
                        that.removeBond(j);
                    }
                    if (edgeIndex < 0) continue;
                    this.removeBond(edgeIndex);
                    continue;
                }
                if (j >= 0) {
                    MolBond bb = that.theBonds[j];
                    if (b.overridesAtMerge(bb)) {
                        that.theBonds[j] = b;
                    } else {
                        MolBond tmp = bb;
                        bb = b;
                        b = tmp;
                    }
                    this.removeBond(bb);
                    this.removeBond(b);
                    this.add(b);
                    MolAtom neighbor = b.getOtherAtom(that);
                    for (int k = neighbor.bondCount - 1; k >= 0; --k) {
                        if (neighbor.theBonds[k] != bb) continue;
                        neighbor.removeBond(k);
                        continue block0;
                    }
                    continue;
                }
                if (this.contains(that)) {
                    if (this.contains(b)) {
                        that.add(b);
                        continue;
                    }
                    this.add(b);
                    continue;
                }
                that.insertBond(0, b);
            }
            a.removeAllBonds();
            removedAtomIndex = this.indexOf(a);
            if (removedAtomIndex >= 0) {
                if (this.contains(that)) {
                    this.removeAtom(removedAtomIndex);
                } else {
                    this.setAtom(removedAtomIndex, that);
                }
            } else {
                this.removeAtom(a);
            }
        }
        if (!this.contains(that)) {
            if (removedAtomIndex >= 0) {
                this.insertAtom(removedAtomIndex, that);
            } else {
                this.add(that);
            }
        }
        for (i = 0; i < that.bondCount; ++i) {
            MolBond e = that.theBonds[i];
            if (this.contains(e)) continue;
            this.add(e);
        }
        this.resetCtab();
        if (outer0 != null) {
            int i0 = that.indexOf(outer0);
            int i1 = that.indexOf(outer1);
            if (i0 != -1 && i1 != -1) {
                MolAtom ma = that;
                ma.setLinkNodeOuterAtom(0, i0);
                ma.setLinkNodeOuterAtom(1, i1);
                ma.setMinRepetitions(minRep);
                ma.setMaxRepetitions(maxRep);
            }
        }
    }

    public boolean hasValenceError() {
        MoleculeGraph mg = this.getGraphUnion();
        for (int i = 0; i < mg.getAtomCount(); ++i) {
            MolAtom a = mg.getAtom(i);
            if (!a.hasValenceError()) continue;
            return true;
        }
        return false;
    }

    public void valenceCheck() {
        if (this.getValenceCheckState() != ValenceCheckState.OFF) {
            MoleculeGraph mg = this.getGraphUnion();
            for (int i = 0; i < mg.getAtomCount(); ++i) {
                MolAtom a = mg.getAtom(i);
                a.valenceCheck();
            }
        }
    }

    public void valenceCheck(List<MolAtom> v) {
        if ((this.flags & 0x20) != 0) {
            if (v == null) {
                this.valenceCheck();
            } else {
                for (MolAtom a : v) {
                    a.valenceCheck();
                }
            }
        }
    }

    public void qpropCheck(List<MolAtom> v) {
        if (v == null) {
            for (int i = 0; i < this.atomCount; ++i) {
                MolAtom a = this.theAtoms[i];
                a.qpropCheck();
            }
        } else {
            for (int i = 0; i < v.size(); ++i) {
                MolAtom a = v.get(i);
                a.qpropCheck();
            }
        }
    }

    public boolean isSimilarTo(MoleculeGraph g) {
        if (!(g instanceof MoleculeGraph)) {
            return false;
        }
        MoleculeGraph u = this.getGraphUnion();
        g = g.getGraphUnion();
        if (u.getAtomCount() != g.getAtomCount() || u.getBondCount() != g.getBondCount()) {
            return false;
        }
        int[] gi = u.getGrinv();
        int[] gj = g.getGrinv();
        int[][] ctab = u.getCtab();
        int[][] ctabg = g.getCtab();
        boolean[] visited = new boolean[gj.length];
        for (int i = 0; i < gi.length; ++i) {
            int j;
            MolAtom ai = u.getAtom(i);
            for (j = 0; j < gj.length; ++j) {
                if (visited[j] || gj[j] != gi[i]) continue;
                if (!MoleculeGraph.testGraphInvEqualityInNeighbors(ctab[i], gi, ctabg[j], gj)) {
                    return false;
                }
                MolAtom aj = g.getAtom(j);
                if (!aj.haveEqualProperties(ai) || !aj.haveSimilarBonds(ai)) {
                    return false;
                }
                visited[j] = true;
                break;
            }
            if (j != gj.length) continue;
            return false;
        }
        return true;
    }

    private static boolean testGraphInvEqualityInNeighbors(int[] ctabi, int[] gi, int[] ctabj, int[] gj) {
        int n = ctabi.length;
        if (ctabj.length != n) {
            return false;
        }
        boolean[] visited = new boolean[n];
        int m = 0;
        for (int k = 0; k < n; ++k) {
            int g = gj[ctabj[k]];
            for (int l = 0; l < n; ++l) {
                if (visited[l] || gi[ctabi[l]] != g) continue;
                visited[l] = true;
                ++m;
            }
        }
        return m == n;
    }

    public boolean isAtom() {
        return this.getAtomCount() == 1;
    }

    public boolean isBond() {
        if (this.getBondCount() == 1) {
            if (this.getAtomCount() == 0) {
                return true;
            }
            if (this.getAtomCount() == 2) {
                MolAtom a1 = this.getAtom(0);
                MolAtom a2 = this.getAtom(1);
                int z1 = a1.getAtno();
                int z2 = a2.getAtno();
                int h1 = a1.getImplicitHcount();
                int h2 = a2.getImplicitHcount();
                if (!(z1 != z2 || z1 != 0 && z1 != 6 || h1 != 0 || h2 != 0 || a1.hasQProps() || a2.hasQProps())) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isRing() {
        int i;
        int[][] ctab = this.getCtab();
        int n = ctab.length;
        if (n < 3) {
            return false;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            if (ctab[i2].length == 2) continue;
            return false;
        }
        int k = 0;
        boolean[] visited = new boolean[n];
        visited[0] = true;
        block1: for (i = 1; i < n; ++i) {
            for (int j = 0; j < 2; ++j) {
                int k2 = ctab[k][j];
                if (visited[k2]) continue;
                k = k2;
                visited[k] = true;
                continue block1;
            }
        }
        for (i = 0; i < n; ++i) {
            if (visited[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isSymmetric() {
        int[] g = this.getGrinv();
        for (int i = 1; i < g.length; ++i) {
            if (g[i] == g[0]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public MPropertyContainer properties() {
        return this.propertyContainer;
    }

    public void revalidateCoordDependentProps() {
        this.properties().revalidateCoordDependents();
    }

    @Override
    public int getAtomCount() {
        return this.atomCount;
    }

    public int getAtomCount(int atomicNumber) {
        int atomicNCount = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.theAtoms[i].getAtno() != atomicNumber) continue;
            ++atomicNCount;
        }
        return atomicNCount;
    }

    @Override
    public int getBondCount() {
        return this.bondCount;
    }

    public int getFormalCharge() {
        int totalCharge = 0;
        for (int i = 0; i < this.getAtomCount(); ++i) {
            totalCharge += this.getAtom(i).getCharge();
        }
        return totalCharge;
    }

    public int getTotalCharge() {
        return this.getFormalCharge();
    }

    protected boolean isRealAtomParent() {
        return true;
    }

    public MolAtom getAtom(int n) {
        if (n >= this.atomCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.theAtoms[n];
    }

    public MolBond getBond(int n) {
        if (n >= this.getBondCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.theBonds[n];
    }

    public void setAtom(int i, MolAtom atom) {
        this.setAtom0(i, atom);
        this.resetCtab();
    }

    public final void insertAtom(int i, MolAtom atom) {
        this.insertNullAtoms(i, 1);
        this.setAtom(i, atom);
    }

    protected void insertNullAtoms(int i, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("cannot insert " + count + " atoms");
        }
        if (count == 0) {
            return;
        }
        if (this.atomCount + count > this.theAtoms.length) {
            MolAtom[] newAtoms = new MolAtom[this.atomCount + count];
            System.arraycopy(this.theAtoms, 0, newAtoms, 0, i);
            System.arraycopy(this.theAtoms, i, newAtoms, i + count, this.atomCount - i);
            this.theAtoms = newAtoms;
        } else {
            System.arraycopy(this.theAtoms, i, this.theAtoms, i + count, this.atomCount - i);
            for (int j = i; j < i + count; ++j) {
                this.theAtoms[j] = null;
            }
        }
        this.atomCount += count;
        for (int j = i + count; j < this.atomCount; ++j) {
            MolAtom a = this.getAtom(j);
            if (a == null || a.getParent() != this) continue;
            a.index += count;
        }
        this.resetCtab();
    }

    public final void insertBond(int i, MolBond bond) {
        this.insertNullBonds(i, 1);
        this.setBond(i, bond);
    }

    public void insertBondInOrder(MolBond e, MolBond[] order) {
        int pos = -1;
        for (int i = 0; i < order.length; ++i) {
            if (e != order[i]) continue;
            pos = i;
            break;
        }
        if (pos < 0) {
            this.add(e);
            return;
        }
        while (pos > 0) {
            MolBond e1;
            int i;
            if ((i = this.indexOf(e1 = order[--pos])) < 0) continue;
            this.insertBond(i + 1, e);
            return;
        }
        this.insertBond(0, e);
    }

    protected void insertNullBonds(int i, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("cannot insert " + count + " bonds");
        }
        if (count == 0) {
            return;
        }
        if (this.bondCount + count > this.theBonds.length) {
            MolBond[] newBonds = new MolBond[this.bondCount + count];
            System.arraycopy(this.theBonds, 0, newBonds, 0, i);
            System.arraycopy(this.theBonds, i, newBonds, i + count, this.bondCount - i);
            this.theBonds = newBonds;
        } else {
            System.arraycopy(this.theBonds, i, this.theBonds, i + count, this.bondCount - i);
            for (int j = i; j < i + count; ++j) {
                this.theBonds[j] = null;
            }
        }
        this.bondCount += count;
        for (int j = i + count; j < this.bondCount; ++j) {
            MolBond b = this.getBond(j);
            if (b == null || b.getParent() != this) continue;
            b.index += count;
        }
        this.resetCtab();
    }

    public void sortBondsAccordingTo(MolBond[] order) {
        boolean changed = false;
        for (int i = 0; i < this.bondCount; ++i) {
            MolBond ei = this.theBonds[i];
            int ig = Integer.MAX_VALUE;
            for (int k = 0; k < order.length; ++k) {
                if (!ei.equals(order[k])) continue;
                ig = k;
                break;
            }
            for (int j = i + 1; j < this.bondCount; ++j) {
                MolBond ej = this.theBonds[j];
                int jg = Integer.MAX_VALUE;
                for (int k = 0; k < order.length; ++k) {
                    if (!ej.equals(order[k])) continue;
                    jg = k;
                    break;
                }
                if (ig <= jg) continue;
                this.theBonds[i] = ej;
                this.theBonds[j] = ei;
                if (ej.getParent() == this) {
                    ej.setIndex(i);
                }
                if (ei.getParent() == this) {
                    ei.setIndex(j);
                }
                ei = ej;
                ig = jg;
                changed = true;
            }
        }
        if (changed) {
            this.resetCtab();
        }
    }

    public MolAtom[] getAtomArray() {
        MoleculeGraph u = this.getGraphUnion();
        MolAtom[] arr = new MolAtom[u.getAtomCount()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = u.getAtom(i);
        }
        return arr;
    }

    public MolBond[] getBondArray() {
        MoleculeGraph u = this.getGraphUnion();
        MolBond[] arr = new MolBond[u.getBondCount()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = u.getBond(i);
        }
        return arr;
    }

    private List<MolBond> getBondList(MolAtom[] atoms, int na) {
        ArrayList<MolBond> tmp = new ArrayList<MolBond>();
        for (int i = 0; i < na; ++i) {
            MolAtom atom1 = atoms[i];
            MolBond[] v = this.getBonds(atom1);
            for (int j = 0; j < v.length; ++j) {
                MolAtom atom2;
                MolBond edge = v[j];
                if (tmp.contains(edge) || MoleculeGraph.findInArray(atoms, null, na, atom2 = edge.getOtherAtom(atom1)) < 0) continue;
                tmp.add(edge);
            }
        }
        return tmp;
    }

    public void calcCenter(DPoint3 p) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        MoleculeGraph u = this.getGraphUnion();
        int n = u.getAtomCount();
        for (int i = 0; i < n; ++i) {
            MolAtom a = u.getAtom(i);
            x += a.xCoordinate;
            y += a.yCoordinate;
            z += a.zCoordinate;
        }
        if (n != 0) {
            p.x = x / (double)n;
            p.y = y / (double)n;
            p.z = z / (double)n;
        } else {
            p.x = 0.0;
            p.y = 0.0;
            p.z = 0.0;
        }
    }

    public DPoint3 calcOutRect() {
        DPoint3 c = new DPoint3();
        this.calcOutRect(c);
        return c;
    }

    public void calcOutRect(DPoint3 p) {
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        double zmin = Double.MAX_VALUE;
        double zmax = -1.7976931348623157E308;
        for (int i = this.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = this.getAtom(i);
            double x = atom.getX();
            xmin = Math.min(x, xmin);
            xmax = Math.max(x, xmax);
            double y = atom.getY();
            ymin = Math.min(y, ymin);
            ymax = Math.max(y, ymax);
            double z = atom.getZ();
            zmin = Math.min(z, zmin);
            zmax = Math.max(z, zmax);
        }
        p.x = xmax - xmin;
        p.y = ymax - ymin;
        p.z = zmax - zmin;
    }

    public DPoint3 calcOutRectCenter() {
        DPoint3 c = new DPoint3();
        this.calcOutRectCenter(c);
        return c;
    }

    public void calcOutRectCenter(DPoint3 p) {
        double xMin = 0.0;
        double xMax = 0.0;
        double yMin = 0.0;
        double yMax = 0.0;
        double zMin = 0.0;
        double zMax = 0.0;
        for (int i = this.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = this.getAtom(i);
            if (i == this.getAtomCount() - 1) {
                xMin = xMax = a.getX();
                yMin = yMax = a.getY();
                zMin = zMax = a.getZ();
            } else {
                if (a.getX() < xMin) {
                    xMin = a.getX();
                }
                if (a.getX() > xMax) {
                    xMax = a.getX();
                }
                if (a.getY() < yMin) {
                    yMin = a.getY();
                }
                if (a.getY() > yMax) {
                    yMax = a.getY();
                }
                if (a.getZ() < zMin) {
                    zMin = a.getZ();
                }
                if (a.getZ() > zMax) {
                    zMax = a.getZ();
                }
            }
            p.x = (xMax + xMin) / 2.0;
            p.y = (yMax + yMin) / 2.0;
            p.z = (zMax + zMin) / 2.0;
        }
    }

    public DPoint3 calcCenter() {
        DPoint3 c = new DPoint3();
        this.calcCenter(c);
        return c;
    }

    public double calcWidth() {
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        for (int i = this.getAtomCount() - 1; i >= 0; --i) {
            double x = this.getAtom(i).getX();
            xmin = Math.min(x, xmin);
            xmax = Math.max(x, xmax);
        }
        return xmax - xmin;
    }

    public double calcHeight() {
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        for (int i = this.getAtomCount() - 1; i >= 0; --i) {
            double y = this.getAtom(i).getY();
            ymin = Math.min(y, ymin);
            ymax = Math.max(y, ymax);
        }
        return ymax - ymin;
    }

    public double getDesiredLength(int atno1, int atno2, int type) {
        return MolBond.desiredLength(atno1, atno2, type, this.getDim());
    }

    public double getDesiredLength(MolBond b) {
        MolAtom a1 = b.getAtom1();
        MolAtom a2 = b.getAtom2();
        if (a1 != null && a2 != null) {
            return this.getDesiredLength(a1.getAtno(), a2.getAtno(), b.getType());
        }
        return 0.0;
    }

    public double bondlength() {
        int nb = this.bondCount;
        if (nb == 0 || this.getDim() == 0) {
            return 1.54;
        }
        double[] blens = new double[4 * nb];
        int nl = 0;
        for (int i = 0; i < nb; ++i) {
            boolean isCC;
            MolBond b = this.theBonds[i];
            int a1 = b.getAtom1().getAtno();
            int a2 = b.getAtom2().getAtno();
            int t = b.getType();
            double l = b.getLength();
            if (l == 0.0) continue;
            double d = this.getDesiredLength(a1, a2, t);
            blens[nl] = l *= 1.54 / d;
            boolean bl = isCC = a1 == 6 && a2 == 6;
            if (isCC) {
                blens[nl + 1] = l;
                blens[nl + 2] = l;
                blens[nl + 3] = l;
            }
            for (int j = 0; j < nl; ++j) {
                if (!(l < blens[j])) continue;
                int jnext = isCC ? j + 4 : j + 1;
                System.arraycopy(blens, j, blens, jnext, nl - j);
                blens[j] = l;
                if (!isCC) break;
                blens[j + 1] = l;
                blens[j + 2] = l;
                blens[j + 3] = l;
                break;
            }
            if (isCC) {
                nl += 4;
                continue;
            }
            ++nl;
        }
        int k = nl >> 1;
        return (nl & 1) == 0 && k > 0 ? (blens[k - 1] + blens[k]) / 2.0 : blens[k];
    }

    public DPoint3 getLocation() {
        return new DPoint3(this.orix, this.oriy, this.oriz);
    }

    public void setLocation(DPoint3 o) {
        this.orix = o.x;
        this.oriy = o.y;
        this.oriz = o.z;
    }

    public void moveTo(DPoint3 o) {
        CTransform3D t = new CTransform3D();
        t.setTranslation(o.x - this.orix, o.y - this.oriy, o.z - this.oriz);
        this.transform(t);
    }

    @Override
    public void transform(CTransform3D t) {
        this.transform(t, t.determinant2D() < 0.0);
    }

    public void transform(CTransform3D t, boolean incg) {
        int i;
        if (this.getDim() < 3 && t.is3d()) {
            this.setDim(3);
        }
        DPoint3 p = this.getLocation();
        t.transform(p);
        this.orix = p.x;
        this.oriy = p.y;
        this.oriz = p.z;
        for (i = 0; i < this.atomCount; ++i) {
            MolAtom a = this.theAtoms[i];
            a.transform(t, incg);
        }
        if (t.m22 < 0.0) {
            for (i = 0; i < this.bondCount; ++i) {
                MolBond b = this.theBonds[i];
                int f = b.getFlags();
                if ((f & 0x30) == 16) {
                    b.setFlags(32, 48);
                    continue;
                }
                if ((f & 0x30) != 32) continue;
                b.setFlags(16, 48);
            }
        }
        this.propertyContainer.transform(t);
        if (incg) {
            this.resetGrinvInParents();
        }
    }

    public DPoint3[] getPoints() {
        DPoint3[] p = new DPoint3[this.atomCount];
        for (int i = 0; i < p.length; ++i) {
            p[i] = this.theAtoms[i].getLocation();
        }
        return p;
    }

    public DPoint3[] getEnclosingCube() {
        DPoint3[] corners = new DPoint3[2];
        DPoint3 atomPos = this.getAtom(0).getLocation();
        corners[0] = new DPoint3(atomPos);
        corners[1] = new DPoint3(atomPos);
        for (int i = 1; i < this.getAtomCount(); ++i) {
            atomPos = this.getAtom(i).getLocation();
            corners[0].x = atomPos.x < corners[0].x ? atomPos.x : corners[0].x;
            corners[0].y = atomPos.y < corners[0].y ? atomPos.y : corners[0].y;
            corners[0].z = atomPos.z < corners[0].z ? atomPos.z : corners[0].z;
            corners[1].x = atomPos.x > corners[1].x ? atomPos.x : corners[1].x;
            corners[1].y = atomPos.y > corners[1].y ? atomPos.y : corners[1].y;
            corners[1].z = atomPos.z > corners[1].z ? atomPos.z : corners[1].z;
        }
        return corners;
    }

    public void clonecopy(MoleculeGraph m) {
        if (this.parentGraph == null) {
            m.superGraph = m;
            m.parentGraph = null;
        }
        boolean xbondFound = this.clonecopyMoleculeGraphWithoutSgroups(null, this.theBonds, this.bondCount, m);
        if (this.ctab != null && !xbondFound) {
            m.ctab = new int[this.ctab.length][];
            for (int i = 0; i < this.ctab.length; ++i) {
                m.ctab[i] = new int[this.ctab[i].length];
                System.arraycopy(this.ctab[i], 0, m.ctab[i], 0, this.ctab[i].length);
            }
        }
        if (this.btab != null && !xbondFound) {
            m.btab = BondTable.cloneBondTable(this.btab);
        }
        if (this.gearch != null && !xbondFound) {
            m.gearch = this.gearch.cloneMoleculeGraphGearch(m, xbondFound);
        }
        m.grinvCC = this.grinvCC;
        m.orix = this.orix;
        m.oriy = this.oriy;
        m.oriz = this.oriz;
        HashSet<MProp> xprops = new HashSet<MProp>();
        for (MProp p : this.propertyContainer.getPropList()) {
            if (!this.isSelfReference(p)) continue;
            xprops.add(p);
        }
        m.propertyContainer = this.propertyContainer.clonePropertyContainer(xprops);
        for (MProp p : xprops) {
            m.fixSelfReferringProperty(p);
        }
        m.propertyContainer.molecule = m;
    }

    public void clonecopy(int[] iatoms, MoleculeGraph g) {
        this.clonecopyMoleculeGraphWithoutSgroups(iatoms, null, 0, g);
    }

    protected boolean clonecopyMoleculeGraphWithoutSgroups(int[] cnodes, MolBond[] cedges, int nb, MoleculeGraph graph) {
        MolAtom a0;
        MolAtom atom;
        int i;
        int na;
        graph.atomCount = 0;
        if (cnodes != null) {
            na = cnodes.length;
            graph.theAtoms = new MolAtom[na];
            for (i = 0; i < na; ++i) {
                atom = this.theAtoms[cnodes[i]];
                graph.addAtom0((MolAtom)atom.clone());
            }
        } else {
            na = this.atomCount;
            graph.theAtoms = new MolAtom[na];
            for (i = 0; i < na; ++i) {
                atom = this.theAtoms[i];
                graph.addAtom0((MolAtom)atom.clone());
            }
        }
        if (cedges == null) {
            MolAtom[] w = this.toAtomArray(cnodes);
            List<MolBond> tmp = this.getBondList(w, na);
            nb = tmp.size();
            cedges = new MolBond[nb];
            tmp.toArray(cedges);
        }
        graph.theBonds = new MolBond[nb];
        graph.bondCount = 0;
        for (int i2 = 0; i2 < nb; ++i2) {
            MolBond edge = cedges[i2];
            MolBond newBond = (MolBond)edge.clone();
            graph.addBond0(newBond);
        }
        if (cnodes != null) {
            this.cloneBicycloStereoInformation(cnodes, graph);
        } else {
            this.cloneBicycloStereoInformation(graph);
        }
        boolean xbondFound = false;
        if (cnodes != null) {
            for (int i3 = 0; i3 < na; ++i3) {
                a0 = this.theAtoms[cnodes[i3]];
                MolAtom a = graph.theAtoms[i3];
                xbondFound |= this.fixAtomBondRefs(a0, a, graph, cedges, nb);
            }
        } else {
            for (int i4 = 0; i4 < na; ++i4) {
                a0 = this.theAtoms[i4];
                MolAtom a = graph.theAtoms[i4];
                xbondFound |= this.fixAtomBondRefs(a0, a, graph, cedges, nb);
            }
        }
        graph.ctab = null;
        graph.btab = null;
        graph.incGrinvCC();
        if (graph.gearch != null) {
            graph.gearch.setGrinvOptions(0);
        }
        graph.orix = 0.0;
        graph.oriy = 0.0;
        graph.oriz = 0.0;
        graph.flags = this.flags;
        graph.parityModule = null;
        graph.aromataModule = null;
        graph.lonePairCounts = null;
        graph.lonePairCountsGrinvCC = 0L;
        graph.explicitLonePairCounts = null;
        if (graph.propertyContainer != null) {
            graph.propertyContainer.molecule = graph;
        }
        return xbondFound;
    }

    private void cloneBicycloStereoInformation(int[] atomIndexes, MoleculeGraph targetGraph) {
        if (atomIndexes.length != 0 && this.theAtoms[atomIndexes[0]].getParent() != this) {
            for (int i = 0; i < targetGraph.atomCount; ++i) {
                if (this.theAtoms[atomIndexes[i]].getBicycloStereo() == null) continue;
                this.cloneStereoDescriptors(this.theAtoms[atomIndexes[i]], targetGraph.theAtoms[i], targetGraph);
            }
        }
    }

    private void cloneBicycloStereoInformation(MoleculeGraph targetGraph) {
        if (this.theAtoms != null && this.theAtoms.length > 0 && this.theAtoms[0] != null && this.theAtoms[0].getParent() == this) {
            for (int i = 0; i < targetGraph.atomCount; ++i) {
                if (this.theAtoms[i].getBicycloStereo() == null) continue;
                this.cloneStereoDescriptors(this.theAtoms[i], targetGraph.theAtoms[i], targetGraph);
            }
        }
    }

    private boolean fixAtomBondRefs(MolAtom a0, MolAtom a, MoleculeGraph graph, MolBond[] cedges, int nb) {
        MolBond[] bonds = this.getBonds(a0);
        a.theBonds = new MolBond[bonds.length];
        a.bondCount = bonds.length;
        for (int j = bonds.length - 1; j >= 0; --j) {
            MolBond b;
            MolBond b0 = bonds[j];
            int k = -1;
            k = cedges == this.theBonds && nb == this.bondCount ? this.indexOf(b0) : MoleculeGraph.findInArray(cedges, null, nb, b0);
            if (k < 0) continue;
            a.theBonds[j] = b = graph.theBonds[k];
            if (b.getAtom1() == a0) {
                b.setAtom1(a);
            }
            if (b.getAtom2() != a0) continue;
            b.setAtom2(a);
        }
        boolean xbondFound = false;
        for (int j = bonds.length - 1; j >= 0; --j) {
            if (a.theBonds[j] != null) continue;
            xbondFound = true;
            for (int i = j + 1; i < a.bondCount; ++i) {
                a.theBonds[i - 1] = a.theBonds[i];
            }
            a.theBonds[--a.bondCount] = null;
        }
        return xbondFound;
    }

    private void cloneStereoDescriptors(MolAtom sourceAtom, MolAtom targetAtom, MoleculeGraph targetGraph) {
        BicycloStereoDescriptor[] descriptors = sourceAtom.getBicycloStereo();
        if (descriptors != null) {
            BicycloStereoDescriptor[] clonedDescriptors = new BicycloStereoDescriptor[descriptors.length];
            for (int i = 0; i < clonedDescriptors.length; ++i) {
                clonedDescriptors[i] = new BicycloStereoDescriptor(targetGraph.getAtom(this.indexOf(descriptors[i].getConnectionAtom())), descriptors[i].getStereoValue(), this.findTargetAtoms(descriptors[i].bridge1, targetGraph), this.findTargetAtoms(descriptors[i].bridge2, targetGraph));
            }
            targetAtom.setBicycloStereo(clonedDescriptors);
        }
    }

    private MolAtom[] findTargetAtoms(MolAtom[] sourceAtoms, MoleculeGraph targetGraph) {
        MolAtom[] targetAtoms;
        MolAtom[] molAtomArray = targetAtoms = sourceAtoms != null ? new MolAtom[sourceAtoms.length] : null;
        if (sourceAtoms != null) {
            for (int j = 0; j < sourceAtoms.length; ++j) {
                targetAtoms[j] = targetGraph.getAtom(this.indexOf(sourceAtoms[j]));
            }
        }
        return targetAtoms;
    }

    protected MolBond[] getBonds(MolAtom atom) {
        MolBond[] bonds = new MolBond[atom.getBondCount()];
        for (int i = 0; i < bonds.length; ++i) {
            bonds[i] = atom.getBond(i);
        }
        return bonds;
    }

    protected static final int findInArray(Object[] array, int[] indices, int n, Object o) {
        if (indices == null) {
            for (int i = 0; i < n; ++i) {
                if (array[i] != o) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (array[indices[i]] != o) continue;
                return i;
            }
        }
        return -1;
    }

    private MolAtom[] toAtomArray(int[] cnodes) {
        if (cnodes == null) {
            return this.theAtoms;
        }
        int na = cnodes.length;
        MolAtom[] w = new MolAtom[na];
        for (int i = 0; i < na; ++i) {
            w[i] = this.theAtoms[cnodes[i]];
        }
        return w;
    }

    public void clonelesscopy(MoleculeGraph graph) {
        if (this.parentGraph == null) {
            graph.superGraph = graph;
        }
        graph.theAtoms = new MolAtom[this.atomCount];
        graph.atomCount = this.atomCount;
        System.arraycopy(this.theAtoms, 0, graph.theAtoms, 0, this.atomCount);
        graph.theBonds = new MolBond[this.bondCount];
        graph.bondCount = this.bondCount;
        System.arraycopy(this.theBonds, 0, graph.theBonds, 0, this.bondCount);
        graph.ctab = this.ctab;
        graph.btab = this.btab;
        if (this.gearch != null) {
            graph.regenGearch();
            this.gearch.clonelesscopy(graph.gearch);
        }
        graph.grinvCC = this.grinvCC;
        graph.orix = this.orix;
        graph.oriy = this.oriy;
        graph.oriz = this.oriz;
        graph.flags = this.flags;
        graph.parityModule = this.parityModule;
        graph.aromataModule = this.aromataModule;
        graph.lonePairCounts = null;
        graph.lonePairCountsGrinvCC = 0L;
        graph.explicitLonePairCounts = null;
        graph.propertyContainer = this.propertyContainer;
        graph.propertyContainer.molecule = graph;
    }

    public final boolean hasSelfReferringProperty() {
        for (MProp p : this.propertyContainer.getPropList()) {
            if (!this.isSelfReference(p)) continue;
            return true;
        }
        return false;
    }

    public boolean isSelfReference(MProp p) {
        return p.getPropValue() == this;
    }

    protected boolean fixSelfReferringProperty(MProp prop) {
        return false;
    }

    public String toString() {
        String s = super.toString();
        int i = s.lastIndexOf(46);
        StringBuffer sb = new StringBuffer(i >= 0 ? s.substring(i + 1) : s);
        int na = this.atomCount;
        int nb = this.bondCount;
        if (na == 1 && nb == 0) {
            sb.append('[');
            sb.append(this.getAtom(0));
            sb.append(']');
        } else if (na != 0 || nb != 0) {
            sb.append('[');
            boolean empty = true;
            if (na != 0) {
                sb.append(na);
                sb.append("a,");
                empty = false;
            }
            if (nb != 0) {
                sb.append(nb);
                sb.append("b,");
                empty = false;
            }
            if (!empty) {
                sb.setLength(sb.length() - 1);
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public Object clone() {
        MoleculeGraph m = new MoleculeGraph(this.superGraph == this ? null : this.superGraph, this.atomCount, this.bondCount);
        this.clonecopy(m);
        return m;
    }

    public int getParityType(int idx) {
        MolAtom a = this.getAtom(idx);
        int atno = a.getAtno();
        if (atno == 1) {
            return 0;
        }
        int ec = a.getBondCount();
        if (ec == 2) {
            for (int i = 0; i < ec; ++i) {
                if (a.getBond(i).getType() == 2) continue;
                return 0;
            }
            return 2;
        }
        if (ec == 3 || ec == 4) {
            return 1;
        }
        return 0;
    }

    public int getParity(int i) {
        if (this.parityModule == null) {
            this.parityModule = new Parity();
            this.parityModule.setMolecule(this);
        }
        if (this.isParityRecalculationNeeded()) {
            this.parityModule.setMolecule(this);
        }
        this.parityModule.useOnlyFirstAtom(this.useOnlyFirstAtomInStereoCalculation);
        return this.parityModule.getParity(i);
    }

    public int getLocalParity(int i) {
        int type = this.getParityType(i);
        MolAtom a = this.getAtom(i);
        if (type == 1) {
            int atno = a.getAtno();
            int ec = a.getBondCount();
            int impH = a.getImplicitHcount();
            if (impH > 1 || ec == 3 && impH == 0 && atno != 16 && atno != 15 && (atno != 7 || a.twicesumbonds(true, false) != 6)) {
                return 0;
            }
            int expH = 0;
            boolean centerS = atno == 16 || atno == 15;
            int dbbc = 0;
            int updownWedgeCount = 0;
            for (int j = ec - 1; j >= 0; --j) {
                int f;
                MolBond b;
                int t;
                MolAtom l = a.getLigand(j);
                if (l.getAtno() == 1 && l.getMassno() == 0) {
                    ++expH;
                }
                if ((t = (b = a.getBond(j)).getType()) == 2) {
                    ++dbbc;
                    if (centerS) {
                        MolAtom n = a.getLigand(j);
                        int latno = n.getAtno();
                        if (dbbc > 2 || latno != 7 && latno != 8 && latno != 16 && latno != 15) {
                            return 0;
                        }
                    }
                } else if (t > 2) {
                    return 0;
                }
                if (((f = b.getFlags()) & 0x30) == 48 && b.getAtom1() == a) {
                    return 3;
                }
                if ((f & 0x30) == 0) continue;
                ++updownWedgeCount;
            }
            if (this.getDim() == 2 && updownWedgeCount == 0) {
                return 0;
            }
            if (impH + expH > 1) {
                // empty if block
            }
            if (this.getExplicitLonePairCount(i) > 1) {
                return 0;
            }
            if (this.getDim() == 0) {
                return this.getAtom(i).getFlags() & 7;
            }
            int p = Parity.getLocalParity(this, a, type, this.useOnlyFirstAtomInStereoCalculation);
            return p == 3 ? 0 : p;
        }
        if (type == 2) {
            int p = Parity.getLocalParity(this, a, type, this.useOnlyFirstAtomInStereoCalculation);
            return p;
        }
        return 0;
    }

    public boolean setParity(int i, int p) {
        if (this.parityModule == null) {
            this.parityModule = new Parity();
        }
        this.parityModule.setMolecule(this);
        this.parityModule.useOnlyFirstAtom(this.useOnlyFirstAtomInStereoCalculation);
        return this.parityModule.setParity(i, p);
    }

    public boolean setParity(int[] p) {
        return this.setParity(p, true);
    }

    public boolean setParity(int[] p, boolean useActualWedges) {
        int dim;
        if (this.parityModule == null) {
            this.parityModule = new Parity();
        }
        if ((dim = this.getDim()) < 3 && this.getAtomCount() > 100) {
            boolean allZero = true;
            for (int i = p.length - 1; i >= 0; --i) {
                if (p[i] == 0) continue;
                allZero = false;
                break;
            }
            if (allZero) {
                Parity.clearParityInfo(this);
                return true;
            }
        }
        this.parityModule.setMolecule(this);
        this.parityModule.useOnlyFirstAtom(this.useOnlyFirstAtomInStereoCalculation);
        return this.parityModule.setParity(p, useActualWedges);
    }

    public boolean setLocalParity(int[] p, boolean useActualWedges) {
        return this.setLocalParity(null, p, useActualWedges);
    }

    public boolean setLocalParity(int[] idxes, int[] p, boolean useActualWedges) {
        if (!this.useOnlyFirstAtomInStereoCalculation) {
            return false;
        }
        return Parity.setLocalParity(this, idxes, p, useActualWedges);
    }

    public int getChirality(int i) {
        if (this.getAtomCount() < 4) {
            return 0;
        }
        if (this.parityModule == null) {
            this.parityModule = new Parity();
            this.parityModule.setMolecule(this);
        }
        if (this.isParityRecalculationNeeded()) {
            this.parityModule.setMolecule(this);
        }
        this.parityModule.useOnlyFirstAtom(this.isOnlyFirstAtomInStereoCalculation());
        return this.parityModule.getChirality(i);
    }

    public boolean setChirality(int i, int c) {
        if (c == 0 || c == 8 || c == 16 || c == 24) {
            if (this.parityModule == null) {
                this.parityModule = new Parity();
            }
            this.parityModule.setMolecule(this);
            this.parityModule.useOnlyFirstAtom(this.useOnlyFirstAtomInStereoCalculation);
            return this.parityModule.setChirality(i, c);
        }
        return false;
    }

    public int getStereo2(int i1, int i2, int i3, int i4) {
        MolBond b;
        int i = this.getBondTable().getBondIndex(i2, i3);
        if (i >= 0 && (MolBond.CAN_BE_CTDOUBLE[(b = this.getBond(i)).getType()] || b.isConjugated())) {
            MolAtom a1 = this.getAtom(i1);
            MolAtom a4 = this.getAtom(i4);
            if (b.getAtom1() == this.getAtom(i3)) {
                return this.getStereo2(b, a4, i3, i2, a1);
            }
            return this.getStereo2(b, a1, i2, i3, a4);
        }
        return 0;
    }

    public int getStereo2(MolAtom a1, int i2, int i3, MolAtom a4) {
        MolBond b;
        int i = this.getBondTable().getBondIndex(i2, i3);
        if (i >= 0 && (MolBond.CAN_BE_CTDOUBLE[(b = this.getBond(i)).getType()] || b.isConjugated())) {
            if (b.getAtom1() == this.getAtom(i3)) {
                return this.getStereo2(b, a4, i3, i2, a1);
            }
            return this.getStereo2(b, a1, i2, i3, a4);
        }
        return 0;
    }

    public int getStereo2(MolBond b, MolAtom a1, MolAtom a4) {
        return this.getStereo2(b, a1, a4, false);
    }

    public int getStereo2(MolBond b, MolAtom a1, MolAtom a4, boolean grcheck) {
        if (a1 == null || a4 == null) {
            return 0;
        }
        if (MolBond.CAN_BE_CTDOUBLE[b.getType()] || b.isConjugated()) {
            MolAtom a2 = b.getAtom1();
            MolAtom a3 = b.getAtom2();
            int i2 = this.indexOf(a2);
            int i3 = this.indexOf(a3);
            if (a1.isBoundTo(a3) && a4.isBoundTo(a2)) {
                MolAtom t = a1;
                a1 = a4;
                a4 = t;
            }
            return this.getStereo2(b, a1, i2, i3, a4, grcheck);
        }
        return 0;
    }

    public int getStereo2(MolBond b) {
        if (this.getBondCount() < 3 || !this.canBeCT(this.indexOf(b.getAtom1()), this.indexOf(b.getAtom2()), false)) {
            return 0;
        }
        if (this.parityModule == null) {
            this.parityModule = new Parity();
            this.parityModule.setMolecule(this);
        }
        if (this.isParityRecalculationNeeded()) {
            this.parityModule.setMolecule(this);
        }
        return this.parityModule.getCTStereoforBond(this.indexOf(b));
    }

    protected final int getStereo2(MolBond b, MolAtom a1, int i2, int i3, MolAtom a4) {
        return this.getStereo2(b, a1, i2, i3, a4, false);
    }

    protected final int getStereo2(MolBond b, MolAtom a1, int i2, int i3, MolAtom a4, boolean grcheck) {
        int f = b.getFlags();
        if (MolBond.CAN_BE_CTDOUBLE[f & 0xF] || b.isConjugated()) {
            f &= 0x1C0;
            if (this.getDim() != 0) {
                int bi3;
                int bi1;
                if (!(this.canBeCT(i2, i3, grcheck) && this.indexOf(a1) >= 0 && this.indexOf(a4) >= 0 && (bi1 = this.getBondTable().getBondIndex(this.indexOf(a1), i2)) >= 0 && (bi3 = this.getBondTable().getBondIndex(i3, this.indexOf(a4))) >= 0 && MolBond.CAN_BE_CTSINGLE[this.getBond(bi1).getType()] && MolBond.CAN_BE_CTSINGLE[this.getBond(bi3).getType()])) {
                    return 0;
                }
                if ((f & 0xC0) == 192) {
                    return f;
                }
                int stereo = this.hasBondWigglyNeighbour(b) || this.isDegenerateCTBond(b) ? 192 : b.calcStereo2(a1, a4);
                return stereo | f & 0x100;
            }
            if ((f = b.transformCT(a1, a4, f)) == 0) {
                return this.canBeCT(i2, i3, grcheck) ? 192 : 0;
            }
            return this.canBeCT(i2, i3, grcheck) ? f : 0;
        }
        return 0;
    }

    private int checkDBInRing(MolAtom a1, int i2, int i3, MolAtom a4) {
        int[][] sssr = this.getSSSR();
        for (int i = 0; i < sssr.length; ++i) {
            int[] r = sssr[i];
            int l = r.length;
            if (l >= 8) continue;
            for (int j = 0; j < l; ++j) {
                int n;
                int h = r[j];
                if (h == i2) {
                    n = r[(j + 1) % l];
                    if (n != i3) continue;
                    int p = r[(j + l - 1) % l];
                    int nn = r[(j + 2) % l];
                    return p == this.indexOf(a1) ^ nn == this.indexOf(a4) ? 64 : 128;
                }
                if (h != i3 || (n = r[(j + 1) % l]) != i2) continue;
                int p = r[(j + l - 1) % l];
                int nn = r[(j + 2) % l];
                return p == this.indexOf(a4) ^ nn == this.indexOf(a1) ? 64 : 128;
            }
        }
        return 0;
    }

    private boolean isDegenerateCTBond(MolBond b) {
        int dim = this.getDim();
        if (dim < 2) {
            return false;
        }
        MolAtom atom1 = b.getAtom1();
        MolAtom atom2 = b.getAtom2();
        if (dim == 2) {
            MolAtom ligand2;
            MolAtom ligand;
            int i;
            for (i = 0; i < atom1.getBondCount(); ++i) {
                ligand = atom1.getLigand(i);
                if (ligand == atom2 || !b.isCollinear(ligand)) continue;
                return true;
            }
            for (i = 0; i < atom2.getBondCount(); ++i) {
                ligand = atom2.getLigand(i);
                if (ligand == atom1 || !b.isCollinear(ligand)) continue;
                return true;
            }
            if (atom1.getBondCount() == 3) {
                MolAtom ligand1 = atom1.getLigand(0);
                ligand2 = atom1.getLigand(1);
                if (ligand1 == atom2) {
                    ligand1 = atom1.getLigand(2);
                } else if (ligand2 == atom2) {
                    ligand2 = atom1.getLigand(2);
                }
                if (b.calcStereo2(ligand1, ligand2) == 128) {
                    return true;
                }
            }
            if (atom2.getBondCount() == 3) {
                MolAtom ligand1 = atom2.getLigand(0);
                ligand2 = atom2.getLigand(1);
                if (ligand1 == atom1) {
                    ligand1 = atom2.getLigand(2);
                } else if (ligand2 == atom1) {
                    ligand2 = atom2.getLigand(2);
                }
                if (b.calcStereo2(ligand1, ligand2) == 128) {
                    return true;
                }
            }
        } else if (dim == 3) {
            MolAtom a1 = b.getCTAtom1();
            MolAtom a4 = b.getCTAtom4();
            int stereo = b.calcStereo2(a1, a4);
            int conn1 = atom1.getBondCount();
            int conn2 = atom2.getBondCount();
            if (conn1 > 2) {
                MolAtom a1v = null;
                for (int i = 0; i < conn1; ++i) {
                    MolAtom l = atom1.getLigand(i);
                    if (l == a1 || l == atom2) continue;
                    a1v = l;
                    break;
                }
                if (stereo == b.calcStereo2(a1v, a4)) {
                    return true;
                }
            } else if (conn2 > 2) {
                MolAtom a4v = null;
                for (int i = 0; i < conn2; ++i) {
                    MolAtom l = atom2.getLigand(i);
                    if (l == a4 || l == atom1) continue;
                    a4v = l;
                    break;
                }
                if (stereo == b.calcStereo2(a1, a4v)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasBondWigglyNeighbour(MolBond bond) {
        MolAtom atom1 = bond.getAtom1();
        MolAtom atom2 = bond.getAtom2();
        return this.hasAtomWigglyBond(atom1) || this.hasAtomWigglyBond(atom2);
    }

    private boolean hasAtomWigglyBond(MolAtom atom1) {
        for (int i = 0; i < atom1.getBondCount(); ++i) {
            MolBond neighbourBond = atom1.getBond(i);
            int stereo1 = neighbourBond.getStereo1(atom1);
            if (stereo1 != 48 || atom1 != neighbourBond.getAtom1()) continue;
            return true;
        }
        return false;
    }

    protected void removeBond(MolBond bond, int cleanupFlags) {
        int n = this.bondCount;
        for (int i = 0; i < n; ++i) {
            if (this.theBonds[i] != bond) continue;
            this.removeBond0(i, cleanupFlags);
            return;
        }
    }

    protected void removeBond(int i, int cleanupFlags) {
        this.removeBond0(i, cleanupFlags);
    }

    private void removeBond0(int i, int cleanupFlags) {
        MolBond e = this.theBonds[i];
        --this.bondCount;
        System.arraycopy(this.theBonds, i + 1, this.theBonds, i, this.bondCount - i);
        this.theBonds[this.bondCount] = null;
        if (e.getParent() == this) {
            e.setParent(null);
        }
        for (int j = this.bondCount - 1; j >= i; --j) {
            MolBond ee = this.getBond(j);
            if (ee == null || ee.getParent() != this) continue;
            ee.setIndex(ee.getIndex() - 1);
        }
        if ((cleanupFlags & 1) != 0) {
            MolAtom atom1 = e.getAtom1();
            MolAtom atom2 = e.getAtom2();
            if (atom1 != null) {
                atom1.removeBond(e);
            }
            if (atom2 != null) {
                atom2.removeBond(e);
            }
        }
        this.resetCtab();
    }

    private void removeH(int i, int cleanupFlags) {
        MolAtom atom = this.getAtom(i);
        if ((cleanupFlags & 2) == 0 || atom.getBondCount() != 1) {
            this.removeAtom00(i, cleanupFlags);
            return;
        }
        MolAtom otherAtom = atom.getLigand(0);
        MolBond bond = atom.getBond(0);
        int otherIndex = this.indexOf(otherAtom);
        if (otherIndex < 0) {
            this.removeAtom00(i, cleanupFlags);
            return;
        }
        int parity = this.getParity(otherIndex);
        int x = parity & 3;
        boolean parityIsSet = x == 1 || x == 2;
        MolAtom a2 = otherAtom;
        MolAtom a1 = null;
        MolAtom a4 = null;
        MolBond otherBond = null;
        int stereo2 = 0;
        if (a2.getBondCount() == 3) {
            for (int k = 0; k < otherAtom.getBondCount() && otherBond == null; ++k) {
                MolBond b = a2.getBond(k);
                if (b == bond) continue;
                stereo2 = b.getFlags() & 0x1C0;
                x = stereo2 & 0xC0;
                MolAtom a3 = b.getOtherAtom(a2);
                if (x != 128 && x != 64 || a3.getBondCount() < 2) continue;
                otherBond = b;
                a1 = b.getCTAtom1();
                a4 = b.getCTAtom4();
                if (a1 != atom && a4 != atom) continue;
                otherBond.setStereo2Flags(a1, a4, stereo2 ^= 0xC0);
            }
        }
        this.removeAtom00(i, cleanupFlags);
        otherIndex = this.indexOf(otherAtom);
        if (this.getDim() == 2 && parityIsSet && otherAtom.getBondCount() == 3) {
            this.setParity(otherIndex, parity);
        }
    }

    public void regenBonds() {
        List<MolBond> tmp = this.getBondList(this.theAtoms, this.atomCount);
        this.theBonds = new MolBond[tmp.size()];
        this.bondCount = 0;
        for (int i = 0; i < tmp.size(); ++i) {
            MolBond e = tmp.get(i);
            this.addBond0(e);
        }
        this.resetCtab();
    }

    protected void isolate(MolAtom node) {
        for (int i = node.getBondCount() - 1; i >= 0; --i) {
            MolBond edge = node.getBond(i);
            MolAtom ligand = edge.getOtherAtom(node);
            ligand.removeBond(edge);
            this.theBonds[edge.index] = null;
            edge.index = -1;
        }
        this.theAtoms[node.index] = null;
        node.index = -1;
        node.theBonds = null;
    }

    protected void isolate(MolBond edge) {
        MolAtom atom1 = edge.getAtom1();
        MolAtom atom2 = edge.getAtom2();
        if (atom1 != null) {
            atom1.removeBond(edge);
        }
        if (atom2 != null) {
            atom2.removeBond(edge);
        }
        this.theBonds[edge.index] = null;
        edge.index = -1;
    }

    protected void removeIsolatedAtoms() {
        int i;
        int k = -1;
        for (i = 0; i < this.atomCount; ++i) {
            if (this.theAtoms[i] == null) continue;
            this.theAtoms[++k] = this.theAtoms[i];
            this.theAtoms[k].index = k;
        }
        for (i = k + 1; i < this.atomCount; ++i) {
            this.theAtoms[i] = null;
        }
        this.atomCount = k + 1;
    }

    protected void removeIsolatedBonds() {
        int i;
        int k = -1;
        for (i = 0; i < this.bondCount; ++i) {
            if (this.theBonds[i] == null) continue;
            this.theBonds[++k] = this.theBonds[i];
            this.theBonds[k].index = k;
        }
        for (i = k + 1; i < this.bondCount; ++i) {
            this.theBonds[i] = null;
        }
        this.bondCount = k + 1;
    }

    public boolean canBeCT(int i2, int i3) {
        return this.canBeCT(i2, i3, true);
    }

    public boolean canBeCT(int i2, int i3, boolean grcheck) {
        this.btab = this.getBondTable();
        int k = this.btab.getBondIndex(i2, i3);
        if (k >= 0) {
            MolBond b = this.getBond(k);
            if (b.isConjugated()) {
                return true;
            }
            int t = b.getType();
            if (!MolBond.CAN_BE_CTDOUBLE[t]) {
                return false;
            }
        } else {
            return false;
        }
        this.ctab = this.getCtab();
        if (!this.canBeCTAtom(this.getAtom(i2), this.ctab[i2], this.btab.getBondIndexesToAtom(i2), i3, grcheck)) {
            return false;
        }
        return this.canBeCTAtom(this.getAtom(i3), this.ctab[i3], this.btab.getBondIndexesToAtom(i3), i2, grcheck);
    }

    public boolean canBeCT(MolBond bond) {
        return this.canBeCT(this.indexOf(bond.getAtom1()), this.indexOf(bond.getAtom2()), true);
    }

    private boolean canBeCTAtom(MolAtom a2, int[] an, int[] bn, int i3, boolean grchk) {
        int nSingles = 0;
        int nExpH = 0;
        for (int i = 0; i < an.length; ++i) {
            int i1 = an[i];
            if (i1 == i3) continue;
            int t = this.getBond(bn[i1]).getType();
            if (!MolBond.CAN_BE_CTSINGLE[t]) {
                return false;
            }
            ++nSingles;
            MolAtom a = this.getAtom(i1);
            if (a.getAtno() != 1 || a.getMassno() != 0) continue;
            ++nExpH;
        }
        if (nSingles == nExpH) {
            return !grchk && (nSingles == 1 || nSingles == 2);
        }
        if (nSingles == 1) {
            nSingles = 2;
        }
        if (nSingles == 2) {
            if (grchk) {
                int[] g = new int[this.getAtomCount()];
                this.getGrinv(g, 2);
                for (int i = 1; i < an.length; ++i) {
                    int i1 = an[i];
                    if (i1 == i3) continue;
                    for (int j = 0; j < i; ++j) {
                        int i4 = an[j];
                        if (i4 == i3 || g[i1] != g[i4]) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public int getLonePairCount(int i) {
        if (this.lonePairCounts == null || this.grinvCC != this.lonePairCountsGrinvCC) {
            this.callLonePairCounter();
        }
        return this.lonePairCounts[i];
    }

    private void callLonePairCounter() {
        LonePairCounter mod = new LonePairCounter();
        this.lonePairCounts = mod.getLonePairCount(this);
        this.explicitLonePairCounts = mod.getExplicitLonePairCount(this);
        this.lonePairCountsGrinvCC = this.grinvCC;
    }

    public int getExplicitLonePairCount(int i) {
        if (this.explicitLonePairCounts == null) {
            this.setExistingLPCount();
        }
        try {
            return this.explicitLonePairCounts[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.setExistingLPCount();
            return this.explicitLonePairCounts[i];
        }
    }

    private void setExistingLPCount() {
        MoleculeGraph m = this.getGraphUnion();
        int atomCount = m.getAtomCount();
        int[][] localctab = m.getCtab();
        MolAtom[] atomArray = m.getAtomArray();
        this.explicitLonePairCounts = new int[atomCount];
        for (int i = 0; i < atomCount; ++i) {
            for (int j = 0; j < localctab[i].length; ++j) {
                int nb = localctab[i][j];
                int protonCount = atomArray[nb].getAtno();
                if (protonCount != 130) continue;
                int n = i;
                this.explicitLonePairCounts[n] = this.explicitLonePairCounts[n] + 1;
            }
        }
    }

    public void aromatize(boolean a) throws SecurityException {
        if (a) {
            this.aromatize();
        } else {
            this.dearomatize();
        }
    }

    public final void aromatize() {
        this.aromatize(2);
    }

    public boolean dearomatize() {
        return this.dearomatize(0);
    }

    public boolean dearomatize(int method) {
        DearomatizePlus c = new DearomatizePlus();
        if (c != null) {
            boolean success;
            if (method == 1 || method == 2) {
                success = c.huckelCheck(this);
                if (method == 2 && !success) {
                    throw new RuntimeException("Not Aromatic");
                }
            } else {
                success = c.dearomatize(this);
            }
            this.incGrinvCCOnly();
            return success;
        }
        return false;
    }

    public void aromatize(int method) {
        this.aromatize(method, true);
    }

    public void aromatize(int method, boolean checkAmbiguity) {
        if (this.aromataModule == null) {
            this.aromataModule = new Aromata();
        }
        this.aromataModule.setAmbiguousGeneralAromatization(checkAmbiguity);
        if (method == 2 || method == 2) {
            if (!this.isGrinvCCValid() || this.aromataModule == null || this.aromataModule.getGeneralGrinvCC() != this.grinvCC) {
                this.aromataModule.setMol(this);
                this.aromataModule.generalAromatize();
                this.aromataModule.setGeneralGrinvCC(this.grinvCC);
            }
        } else if (method == 1 || method == 1) {
            if (!this.isGrinvCCValid() || this.aromataModule == null || this.aromataModule.getBasicGrinvCC() != this.grinvCC) {
                this.aromataModule.setMol(this);
                this.aromataModule.basicAromatize();
                this.aromataModule.setBasicGrinvCC(this.grinvCC);
            }
        } else if (method == 3) {
            if (!this.isGrinvCCValid() || this.aromataModule == null || this.aromataModule.getMDLGrinvCC() != this.grinvCC) {
                this.aromataModule.setMol(this);
                this.aromataModule.mdlAromatize();
                this.aromataModule.setMDLGrinvCC(this.grinvCC);
            }
        } else if (method == 4) {
            this.aromataModule.setMol(this);
            this.aromataModule.substrAromatize();
        } else if (method == 5) {
            this.aromataModule.setMol(this);
            this.aromataModule.ambigAromatize();
        } else {
            throw new IllegalArgumentException("Unknown aromatization method " + method);
        }
    }

    public void calcHybridization() {
        block5: for (int i = 0; i < this.getAtomCount(); ++i) {
            MolAtom a = this.getAtom(i);
            if (a.getAtno() <= 2) {
                a.setHybridizationState(1);
                continue;
            }
            if (a.hasQueryBonds()) {
                a.setHybridizationState(0);
                continue;
            }
            if (a.hasAromaticBond()) {
                a.setHybridizationState(3);
                continue;
            }
            int connNum = 4;
            for (int j = 0; j < a.getBondCount(); ++j) {
                int bondType = a.getBond(j).getType();
                if (bondType == 2) {
                    --connNum;
                }
                if (bondType != 3) continue;
                connNum -= 2;
            }
            switch (connNum) {
                case 2: {
                    a.setHybridizationState(2);
                    continue block5;
                }
                case 3: {
                    a.setHybridizationState(3);
                    continue block5;
                }
                case 4: {
                    a.setHybridizationState(4);
                    continue block5;
                }
                default: {
                    a.setHybridizationState(0);
                }
            }
        }
    }

    public String getFormula() {
        ElementalAnalysisCalc elemanal = new ElementalAnalysisCalc();
        elemanal.setMolecule(this);
        return elemanal.formula();
    }

    public double getMass() {
        ElementalAnalysisCalc elemanal = new ElementalAnalysisCalc();
        elemanal.setMolecule(this);
        return elemanal.mass();
    }

    public double getExactMass() {
        ElementalAnalysisCalc elemanal = new ElementalAnalysisCalc();
        elemanal.setMolecule(this);
        return elemanal.exactMass();
    }

    protected void makeItSimilar(MoleculeGraph g) {
        MoleculeGraph m = g;
        m.orix = this.orix;
        m.oriy = this.oriy;
        m.oriz = this.oriz;
        m.flags = this.flags;
    }

    public MoleculeGraph newInstance() {
        MoleculeGraph m = new MoleculeGraph();
        this.makeItSimilar(m);
        return m;
    }

    public MoleculeGraph getGraphUnion() {
        return this;
    }

    public int indexOf(MolAtom atom) {
        return atom.getParent() == this ? atom.index : this.findAtom(atom);
    }

    public int indexOf(MolBond bond) {
        return bond.getParent() == this ? bond.getIndex() : this.findBond(bond);
    }

    protected final int findAtom(MolAtom atom) {
        return MoleculeGraph.findInArray(this.theAtoms, null, this.atomCount, atom);
    }

    protected final int findBond(MolBond bond) {
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.theBonds[i].equals(bond)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(MolAtom atom) {
        return this.indexOf(atom) != -1;
    }

    public boolean contains(MolBond bond) {
        return this.indexOf(bond) != -1;
    }

    public boolean contains(MoleculeGraph graph) {
        graph = graph.getGraphUnion();
        int n = graph.getAtomCount();
        for (int i = 0; i < n; ++i) {
            if (this.indexOf(graph.getAtom(i)) >= 0) continue;
            return false;
        }
        return n != 0;
    }

    public boolean isEmpty() {
        return this.getAtomCount() == 0 && this.getBondCount() == 0;
    }

    public final MoleculeGraph[] getSubGraphs() {
        int n = this.getSubGraphCount();
        MoleculeGraph[] m = new MoleculeGraph[n];
        this.getSubGraphs(m, 0);
        return m;
    }

    protected int getSubGraphCount() {
        return 1;
    }

    protected void getSubGraphs(MoleculeGraph[] m, int off) {
        m[off] = this;
    }

    protected void addAtomsAndBondsTo(MoleculeGraph s) {
        int i;
        for (i = 0; i < this.getAtomCount(); ++i) {
            s.add(this.theAtoms[i]);
        }
        for (i = 0; i < this.getBondCount(); ++i) {
            s.add(this.theBonds[i]);
        }
    }

    public boolean hasExplicitLonePairs() {
        MoleculeGraph m = this.getGraphUnion();
        for (int i = 0; i < m.getAtomCount(); ++i) {
            if (m.getAtom(i).getAtno() != 130) continue;
            return true;
        }
        return false;
    }

    public boolean hasImplicitH() {
        for (int x = 0; x < this.getAtomCount(); ++x) {
            if (this.getAtom(x).getImplicitHcount() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasAtomSet() {
        for (int i = 0; i < this.getAtomCount(); ++i) {
            if (this.getAtom(i).getSetSeq() == 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasBondSet() {
        for (int i = 0; i < this.getBondCount(); ++i) {
            if (this.getBond(i).getSetSeq() == 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasExtraLabelSet() {
        boolean hasSet = false;
        for (int i = 0; i < this.getAtomCount() && !hasSet; ++i) {
            hasSet = this.getAtom(i).getExtraLabel() != null;
        }
        return hasSet;
    }

    public boolean clean(int dim, String opts) {
        return this.clean(dim, opts, null);
    }

    public boolean partialClean(Molecule[] template, String opts) {
        return this.clean(2, opts);
    }

    public boolean partialClean(MoleculeGraph template, int[] map, String opts) {
        CleanerIface cleaner = null;
        try {
            cleaner = (CleanerIface)MarvinModule.load("chemaxon.calculations.clean.CleanerUtil");
        }
        catch (SecurityException sex) {
            throw sex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (cleaner != null) {
            return cleaner.partialClean(this, template, map, opts);
        }
        return false;
    }

    public boolean partialClean(int dim, int[] fixed, String opts) {
        CleanerIface cleaner = null;
        try {
            cleaner = (CleanerIface)MarvinModule.load("chemaxon.calculations.clean.CleanerUtil");
        }
        catch (SecurityException sex) {
            throw sex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (cleaner != null) {
            return cleaner.partialClean(this, dim, fixed, opts);
        }
        return false;
    }

    public boolean clean(int dim, String opts, MProgressMonitor pmon) {
        CleanerIface cleaner = null;
        try {
            cleaner = (CleanerIface)MarvinModule.load("chemaxon.calculations.clean.CleanerUtil");
        }
        catch (SecurityException sex) {
            throw sex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (cleaner != null) {
            return cleaner.clean(this, dim, opts, pmon);
        }
        return false;
    }

    public boolean stereoClean() {
        if (this.getDim() == 2) {
            if (this.parityModule == null) {
                this.parityModule = new Parity();
                this.parityModule.setMolecule(this);
            }
            if (this.isParityRecalculationNeeded()) {
                this.parityModule.setMolecule(this);
            }
            this.parityModule.useOnlyFirstAtom(this.useOnlyFirstAtomInStereoCalculation);
            return this.parityModule.resetParity();
        }
        if (this.getDim() == 3) {
            for (int i = this.getBondCount() - 1; i >= 0; --i) {
                MolBond b = this.getBond(i);
                if ((b.getFlags() & 0x30) == 48) continue;
                b.setFlags(0, 48);
            }
            return true;
        }
        return false;
    }

    protected boolean isGrinvCCValid() {
        return true;
    }

    public int[][] getAromrings() {
        return this.getAromrings(18);
    }

    public int[][] getNonAromrings() {
        return this.getNonAromrings(18);
    }

    public int[][] getAromrings(int size) {
        return this.getAromaticAndAliphaticRings(1, true, false, size, 1000)[0];
    }

    public int[][] getNonAromrings(int size) {
        return this.getAromaticAndAliphaticRings(1, false, false, size, 1000)[1];
    }

    public int[][][] getAromaticAndAliphaticRings(int aromatizationType, boolean onlyAromrings, boolean aromatize, int maxRingSize, int ringsLimit) {
        if (this.aromataModule == null) {
            this.aromataModule = new Aromata();
        }
        this.aromataModule.setMol(this);
        this.aromataModule.aromatize(aromatize, onlyAromrings, maxRingSize, ringsLimit, aromatizationType, true);
        return this.aromataModule.getRings();
    }

    private MoleculeGraph[] getSubstructures() {
        int i;
        ArrayList<MoleculeGraph> substructures = new ArrayList<MoleculeGraph>();
        IntVector atomCounts = new IntVector();
        int count = this.getAtomCount();
        for (int i2 = 0; i2 < count; ++i2) {
            MolAtom atom = this.getAtom(i2);
            MoleculeGraph structure = atom.getParent();
            int index = substructures.indexOf(structure);
            if (index == -1) {
                substructures.add(structure);
                atomCounts.add(1);
                continue;
            }
            int atomCount = atomCounts.get(index) + 1;
            atomCounts.set(index, atomCount);
        }
        Hashtable map = null;
        for (i = substructures.size() - 1; i >= 0; --i) {
            if (((MoleculeGraph)substructures.get(i)).getAtomCount() <= atomCounts.get(i)) continue;
            if (map == null) {
                map = new Hashtable();
            }
            SelectionMolecule sel = new SelectionMolecule();
            map.put(substructures.get(i), sel);
            substructures.set(i, sel);
        }
        if (map != null) {
            for (i = 0; i < count; ++i) {
                MolAtom atom = this.getAtom(i);
                SelectionMolecule sel = (SelectionMolecule)map.get(atom.getParent());
                if (sel == null) continue;
                sel.add(atom);
                for (int j = atom.getBondCount() - 1; j >= 0; --j) {
                    MolBond bond = atom.getBond(j);
                    if (sel.indexOf(bond.getOtherAtom(atom)) == -1) continue;
                    sel.add(bond);
                }
            }
        }
        return substructures.toArray(new MoleculeGraph[substructures.size()]);
    }

    public final int[][] getSSSR() {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch.getSSSR();
    }

    public final int[][] getCSSR() {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch.getCSSR();
    }

    public final int[][] getSSSRBonds() {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch.getSSSRBonds();
    }

    public int[][] getSSSRIdxesForAtoms() {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch.getSSSRIdxesForAtoms();
    }

    public int[] getSSSRBondSet() {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch.getSSSRBondSet();
    }

    public long[] getSSSRBondSetInLong() {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch.getSSSRBondSetInLong();
    }

    public int[] getSmallestRingSizeForIdx() {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch.getSmallestRingSizeForIdx();
    }

    public boolean isRingBond(int idx) {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch.isRingBond(idx);
    }

    public int[][] createCHtab() {
        int na = this.getAtomCount();
        int nh = this.getImplicitHcount();
        int[][] chtab = new int[na + nh][];
        int h = na;
        for (int i = 0; i < na; ++i) {
            int j;
            MolAtom a = this.getAtom(i);
            int nn = a.getBondCount();
            int hh = this.getAtom(i).getImplicitHcount();
            chtab[i] = new int[nn + hh];
            for (j = 0; j < nn; ++j) {
                chtab[i][j] = this.indexOf(a.getBond(j).getOtherAtom(a));
            }
            for (j = nn; j < chtab[i].length; ++j) {
                chtab[i][j] = h;
                chtab[h] = new int[]{i};
                ++h;
            }
        }
        return chtab;
    }

    public int[][] createBHtab() {
        int na = this.getAtomCount();
        int nh = this.getImplicitHcount();
        int m = na + nh;
        int[][] bhtab = new int[m][m];
        if (m > 0) {
            int i;
            for (i = 0; i < m; ++i) {
                bhtab[0][i] = -1;
            }
            for (i = 1; i < m; ++i) {
                System.arraycopy(bhtab[0], 0, bhtab[i], 0, m);
            }
        }
        int nb = this.getBondCount();
        for (int i = 0; i < nb; ++i) {
            MolBond b = this.getBond(i);
            int ib = this.indexOf(b);
            int i1 = this.indexOf(b.getAtom1());
            int i2 = this.indexOf(b.getAtom2());
            bhtab[i1][i2] = ib;
            bhtab[i2][i1] = ib;
        }
        int h = na;
        for (int i = 0; i < na; ++i) {
            int hh = this.getAtom(i).getImplicitHcount();
            for (int j = 0; j < hh; ++j) {
                bhtab[i][h] = -2;
                bhtab[h][i] = -2;
                ++h;
            }
        }
        return bhtab;
    }

    public int getImplicitHcount() {
        int hcount = 0;
        for (int i = this.getAtomCount() - 1; i >= 0; --i) {
            hcount += this.getAtom(i).getImplicitHcount();
        }
        return hcount;
    }

    public int getExplicitHcount() {
        int hcount = 0;
        for (int i = this.getAtomCount() - 1; i >= 0; --i) {
            if (this.getAtom(i).getAtno() != 1) continue;
            ++hcount;
        }
        return hcount;
    }

    public MolAtom findAtomClone(MolAtom a) {
        MolAtom aa;
        int i;
        DPoint3 pa = a.getLocation();
        DPoint3 paa = new DPoint3(0.0, 0.0, 0.0);
        ArrayList<MolAtom> v = new ArrayList<MolAtom>();
        MoleculeGraph umol = this.getGraphUnion();
        for (i = 0; i < umol.getAtomCount(); ++i) {
            aa = umol.getAtom(i);
            if (aa == a) {
                return a;
            }
            if (!aa.haveEqualProperties(a)) continue;
            aa.getLocation(paa);
            if (!paa.equals(pa)) continue;
            v.add(aa);
        }
        if (v.size() == 1) {
            return (MolAtom)v.get(0);
        }
        for (i = v.size() - 1; i >= 0; --i) {
            aa = (MolAtom)v.get(i);
            if (aa.haveSimilarBonds(a)) continue;
            v.remove(i);
        }
        if (v.size() == 1) {
            return (MolAtom)v.get(0);
        }
        return null;
    }

    public boolean isValidLinkNode(int linkAtomIdx, int outer1, int outer2) {
        if (outer1 == -1 || outer2 == -1) {
            return false;
        }
        MolAtom linkAtom = this.getAtom(linkAtomIdx);
        int[] outAtomIdx = new int[]{this.indexOf(linkAtom.getLigand(outer1)), this.indexOf(linkAtom.getLigand(outer2))};
        if (linkAtom.getBondCount() == outAtomIdx.length) {
            return true;
        }
        int[] inAtomIdx = new int[linkAtom.getBondCount() - outAtomIdx.length];
        int i = 0;
        for (int j = 0; j < linkAtom.getBondCount(); ++j) {
            int ligand = this.indexOf(linkAtom.getLigand(j));
            if (ArrayTools.foundInArray(outAtomIdx, ligand)) continue;
            inAtomIdx[i] = ligand;
            ++i;
        }
        int[][] sssr = this.getSSSR();
        if (sssr == null) {
            return true;
        }
        for (int j = 0; j < inAtomIdx.length; ++j) {
            int inAtom = inAtomIdx[j];
            for (int k = 0; k < outAtomIdx.length; ++k) {
                int outAtom = outAtomIdx[k];
                for (int l = 0; l < sssr.length; ++l) {
                    int[] ring = sssr[l];
                    if (!ArrayTools.foundInArray(ring, inAtom) || !ArrayTools.foundInArray(ring, outAtom)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void setLinkNodeDefaultOuters(MolAtom atom) {
        int bondCount = atom.getBondCount();
        if (bondCount == 2) {
            atom.setLinkNodeDefaultOuters();
            return;
        }
        boolean found = false;
        int[] outers = new int[2];
        int linkAtomIdx = this.indexOf(atom);
        outers[0] = 0;
        block0: while (outers[0] < bondCount) {
            outers[1] = outers[0] + 1;
            while (outers[1] < bondCount) {
                if (this.isValidLinkNode(linkAtomIdx, outers[0], outers[1])) {
                    found = true;
                    break block0;
                }
                outers[1] = outers[1] + 1;
            }
            outers[0] = outers[0] + 1;
        }
        if (!found) {
            throw new IllegalArgumentException(INVALID_LINKNODE_MESSAGE);
        }
        atom.setLinkNodeOuterAtom(0, outers[0]);
        atom.setLinkNodeOuterAtom(1, outers[1]);
    }

    public double[] getVisibleCoords(MolAtom ma) {
        return new double[]{ma.getX(), ma.getY(), ma.getZ()};
    }

    protected Object[] saveCache(int n) {
        Object[] x = new Object[10 + n];
        x[0] = new Long(this.getGrinvCC());
        x[1] = this.ctab;
        x[2] = this.btab;
        x[3] = this.gearch != null ? this.gearch.saveCache() : null;
        x[4] = this.lonePairCounts;
        x[5] = new Long(this.lonePairCountsGrinvCC);
        x[6] = this.explicitLonePairCounts;
        if (this.cacheMemory == null) {
            this.cacheMemory = new ArrayList<Object[]>();
        }
        this.cacheMemory.add(x);
        return x;
    }

    protected Object[] restoreCache(int n) {
        long g_now;
        if (this.cacheMemory == null) {
            return null;
        }
        int k = this.cacheMemory.size();
        if (k == 0) {
            return null;
        }
        Object[] x = this.cacheMemory.remove(k - 1);
        long g_stored = (Long)x[0];
        if (g_stored == (g_now = this.getGrinvCC())) {
            this.ctab = (int[][])x[1];
            this.btab = (BondTable)x[2];
            if (x[5] != null) {
                this.gearch.restoreCache(x[3]);
            } else {
                this.gearch = null;
            }
            this.lonePairCounts = (int[])x[4];
            this.lonePairCountsGrinvCC = (Long)x[5];
            this.explicitLonePairCounts = (int[])x[6];
            return x;
        }
        return null;
    }

    public boolean isMultiChiral() {
        return (this.getFlags() & 8) > 0;
    }

    public void adjustMultiChiralFlag() {
        int atomCount = this.getAtomCount();
        int chiralCount = 0;
        for (int atomIdx = 0; atomIdx < atomCount && chiralCount < 1; ++atomIdx) {
            if (this.getParity(atomIdx) == 0) continue;
            ++chiralCount;
        }
        if (chiralCount > 1) {
            this.setFlags(this.getFlags() | 8);
        }
    }

    private final boolean isParityRecalculationNeeded() {
        if (this.parityModule == null) {
            return true;
        }
        int[] p = new int[2];
        p[0] = 10;
        long parityGrinvCC = this.parityModule.getGrinvCC();
        return parityGrinvCC == 0L || parityGrinvCC != this.grinvCC;
    }

    public boolean isMolecule() {
        return false;
    }

    public boolean isQuery() {
        for (int x = 0; x < this.atomCount; ++x) {
            MolAtom atom = this.theAtoms[x];
            if (!atom.isQuery()) continue;
            return true;
        }
        for (int i = 0; i < this.bondCount; ++i) {
            MolBond bond = this.theBonds[i];
            if (!bond.isQuery()) continue;
            return true;
        }
        return false;
    }

    public void clearCachedInfo(int options) {
        MoleculeGraph p = this.getParent();
        if (p != null) {
            p.clearCachedInfo(options);
        }
        if (this.gearch != null) {
            this.gearch.clear(options);
        }
        if (options == 0 || (options & 4) != 0) {
            this.parityModule = null;
        }
        if (options == 0 || (options & 8) != 0) {
            this.aromataModule = null;
        }
        if (options == 0 || (options & 0x20) != 0) {
            this.ctab = null;
            this.btab = null;
        }
        if (options == 0) {
            this.theSmolecule = null;
            this.gearch = null;
            this.cacheMemory = null;
            this.lonePairCounts = null;
            this.explicitLonePairCounts = null;
        }
    }

    public boolean arrangeComponents() {
        return GeomUtil.arrangeComponents(this, true, true);
    }

    public void setGrinvOptions(int opt) {
        if (this.gearch == null) {
            this.regenGearch();
        }
        this.gearch.setGrinvOptions(opt);
    }

    public int getGrinvOptions() {
        return this.gearch != null ? this.gearch.getGrinvOptions() : 0;
    }

    public void useOnlyFirstAtomInStereoCalculation(boolean f) {
        this.useOnlyFirstAtomInStereoCalculation = f;
    }

    public boolean isOnlyFirstAtomInStereoCalculation() {
        return this.useOnlyFirstAtomInStereoCalculation;
    }

    protected void sumConservedQuantities(MolAtom a, int[] atoms, int sign) {
        int atno = a.getAtno();
        if (atno == 134) {
            atoms[0] = atoms[0] + sign;
            atoms[136] = atoms[136] + sign;
        } else if (atno != 130 && atno > 0 && atno < atoms.length - 1) {
            atoms[0] = atoms[0] + sign;
            atoms[1] = atoms[1] + a.getCharge() * sign;
            atoms[2] = atoms[2] + a.getImplicitHcount() * sign;
            int n = atno + 2;
            atoms[n] = atoms[n] + sign;
        }
    }

    public int[][] getCtab() {
        if (this.ctab == null) {
            this.regenCtabs();
        }
        return this.ctab;
    }

    public int[][] getBtab() {
        return this.getBondTable().getMatrixArray();
    }

    public BondTable getBondTable() {
        if (this.ctab == null) {
            this.regenCtabs();
        }
        return this.btab;
    }

    @Deprecated
    public <C extends MoleculeGraph> C[] findFrags(Class<C> cl) {
        return this.findFrags(cl, 1);
    }

    public <C extends MoleculeGraph> C[] findFrags(Class<C> cl, int fragmentationType) {
        int[][] ctab = this.getCtab();
        BondTable btab = this.getBondTable();
        int[] fragIds = this.getFragIds(fragmentationType);
        return this.createFrags(fragmentationType, ctab, btab, fragIds, cl);
    }

    @Deprecated
    public void mergeFrags() {
        this.gearch.mergeFrags(1);
    }

    public final int[] findComponentIds() {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch.getFragIds(0);
    }

    public final int[] findComponentIds(int[] inds) {
        return inds == null ? this.findComponentIds() : this.createSelection(inds).findComponentIds();
    }

    private SelectionMolecule createSelection(int[] inds) {
        int i;
        String SELECTED = "SELECTED";
        SelectionMolecule sel = new SelectionMolecule();
        for (int ind : inds) {
            MolAtom atom = this.getAtom(ind);
            atom.putProperty("SELECTED", "true");
            sel.add(this.getAtom(ind));
        }
        for (i = this.getBondCount() - 1; i >= 0; --i) {
            MolBond bond = this.getBond(i);
            if (!bond.getAtom1().containsPropertyKey("SELECTED") || !bond.getAtom2().containsPropertyKey("SELECTED")) continue;
            sel.add(bond);
        }
        for (i = sel.getAtomCount() - 1; i >= 0; --i) {
            sel.getAtom(i).removeProperty("SELECTED");
        }
        return sel;
    }

    @Deprecated
    public final int getFragCount() {
        return this.getFragCount(1);
    }

    public final int getFragCount(int fragmentationType) {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch.fragCount(fragmentationType);
    }

    @Deprecated
    public final int[] getFragIds() {
        return this.getFragIds(1);
    }

    public final int[] getFragIds(int fragmentationType) {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch.getFragIds(fragmentationType);
    }

    protected final void regenGearch() {
        this.gearch = this.createGearch();
    }

    @Deprecated
    public final void findFrag(int i, MoleculeGraph frag) {
        this.findFrag(i, 1, frag);
    }

    public final void findFrag(int i, int fragmentationType, MoleculeGraph frag) {
        int[] fragIds = this.getFragIds(fragmentationType);
        this.findFragById(fragIds[i], fragmentationType, frag);
    }

    @Deprecated
    public final void findFragById(int fragId, MoleculeGraph frag) {
        this.findFragById(fragId, 1, frag);
    }

    public final void findFragById(int fragId, int fragmentationType, MoleculeGraph frag) {
        int[][] ctab = this.getCtab();
        BondTable btab = this.getBondTable();
        int[] fragIds = this.getFragIds(fragmentationType);
        MoleculeGraph[] parents = this.beginAtomCorruption();
        for (int atom = 0; atom < fragIds.length; ++atom) {
            if (fragIds[atom] != fragId) continue;
            MolAtom a = this.getAtom(atom);
            if (!frag.contains(a)) {
                frag.add(a);
            }
            int[] neighbors = ctab[atom];
            for (int j = 0; j < neighbors.length; ++j) {
                MolBond b;
                int neighbor = neighbors[j];
                if (neighbor <= atom || fragIds[neighbor] != fragId || frag.contains(b = this.getBond(btab.getBondIndex(atom, neighbor)))) continue;
                frag.add(b);
            }
        }
        this.endAtomCorruption(parents);
    }

    private MoleculeGraph[] beginAtomCorruption() {
        MoleculeGraph[] parents = new MoleculeGraph[this.getAtomCount()];
        for (int i = 0; i < parents.length; ++i) {
            parents[i] = this.getAtom(i).getParent();
        }
        return parents;
    }

    private void endAtomCorruption(MoleculeGraph[] parents) {
        for (int i = parents.length - 1; i >= 0; --i) {
            MolAtom a = this.getAtom(i);
            MoleculeGraph p = parents[i];
            if (a.getParent() == p || p == null || !p.isRealAtomParent()) continue;
            this.removeAtom(a, 0);
        }
    }

    private <C extends MoleculeGraph> C[] createFrags(int opts, int[][] ctab, BondTable btab, int[] fragIds, Class<C> cl) {
        int nFrags = this.gearch != null ? this.gearch.fragCount(opts) : 0;
        MoleculeGraph[] frags = (MoleculeGraph[])Array.newInstance(cl, nFrags);
        MoleculeGraph[] parents = this.beginAtomCorruption();
        for (int atom = 0; atom < fragIds.length; ++atom) {
            int fragId = fragIds[atom];
            MoleculeGraph frag = frags[fragId];
            if (frag == null) {
                try {
                    frag = frags[fragId] = (MoleculeGraph)cl.newInstance();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                this.makeItSimilar(frag);
                frag.setDim(this.getDim());
            }
            frag.addAtomToFragment(this.getAtom(atom));
            int[] neighbors = ctab[atom];
            for (int i = 0; i < neighbors.length; ++i) {
                int neighbor = neighbors[i];
                if (neighbor <= atom || fragIds[neighbor] != fragId) continue;
                MolBond b = this.getBond(btab.getBondIndex(atom, neighbor));
                frag.add(b);
            }
        }
        this.endAtomCorruption(parents);
        return frags;
    }

    public final <C extends MoleculeGraph> C[] findBasicFrags(Class<C> cl) {
        if (this.isLargeMolecule()) {
            return this.findBasicFragsLarge(cl);
        }
        return this.findBasicFrags0(cl);
    }

    <C extends MoleculeGraph> C[] findBasicFrags0(Class<C> cl) {
        int[][] ctab = this.getCtab();
        BondTable btab = this.getBondTable();
        this.regenGearch();
        return this.createFrags(0, ctab, btab, this.gearch.getFragIds(0), cl);
    }

    <C extends MoleculeGraph> C[] findBasicFragsLarge(Class<C> cl) {
        MoleculeGraph[] substructures = this.getSubstructures();
        ArrayList<MoleculeGraph> list = new ArrayList<MoleculeGraph>();
        for (MoleculeGraph substructure : substructures) {
            MoleculeGraph[] frags;
            for (MoleculeGraph frag : frags = substructure.findBasicFrags0(cl)) {
                list.add(frag);
            }
        }
        MoleculeGraph[] fragsToReturn = (MoleculeGraph[])Array.newInstance(cl, list.size());
        return list.toArray(fragsToReturn);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int i;
        oos.writeByte(2);
        oos.writeInt(this.atomCount);
        for (i = 0; i < this.atomCount; ++i) {
            oos.writeObject(this.theAtoms[i]);
        }
        oos.writeInt(this.bondCount);
        for (i = 0; i < this.bondCount; ++i) {
            oos.writeObject(this.theBonds[i]);
        }
        oos.writeObject(this.parentGraph);
        oos.writeObject(this.superGraph);
        int f = this.getDim() & 3;
        if (this.isAbsStereo()) {
            f |= 4;
        }
        if (this.isValenceCheckEnabled()) {
            f |= 0x20;
        }
        oos.writeByte(f);
        oos.writeDouble(this.orix);
        oos.writeDouble(this.oriy);
        oos.writeDouble(this.oriz);
        int opts = 0;
        MDocument doc = this.getDocument();
        if (doc != null && !doc.isBeingSerialized()) {
            opts = (byte)(opts | 1);
        }
        if (this.propertyContainer.size() != 0) {
            opts = (byte)(opts | 2);
        }
        oos.writeByte(opts);
        if ((opts & 1) != 0) {
            oos.writeObject(doc);
        }
        if ((opts & 2) != 0) {
            this.propertyContainer.writeExternal(oos);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        int i;
        byte version = ois.readByte();
        if (version > 2) {
            throw new IOException("Cannot deserialize molecule graph with future version (" + version + ")");
        }
        this.atomCount = ois.readInt();
        this.theAtoms = new MolAtom[this.atomCount];
        for (i = 0; i < this.atomCount; ++i) {
            this.theAtoms[i] = (MolAtom)ois.readObject();
        }
        this.bondCount = ois.readInt();
        this.theBonds = new MolBond[this.bondCount];
        for (i = 0; i < this.bondCount; ++i) {
            this.theBonds[i] = (MolBond)ois.readObject();
        }
        this.parentGraph = (MoleculeGraph)ois.readObject();
        this.superGraph = (MoleculeGraph)ois.readObject();
        byte f = ois.readByte();
        this.flags = f & 3 | f & 4;
        if (version > 1) {
            this.flags |= f & 0x20;
        }
        this.orix = ois.readDouble();
        this.oriy = ois.readDouble();
        this.oriz = ois.readDouble();
        this.propertyContainer = new MPropertyContainer();
        this.propertyContainer.molecule = this;
        if (version > 0) {
            byte opts = ois.readByte();
            if ((opts & 1) != 0) {
                this.theDocument = (MDocument)ois.readObject();
            }
            if ((opts & 2) != 0) {
                this.propertyContainer.readExternal(ois);
            }
        }
    }

    public int getNodeCount() {
        return this.getAtomCount();
    }

    public MolAtom getNode(int i) {
        return this.getAtom(i);
    }

    public void setNode(int i, MolAtom node) {
        this.setAtom(i, node);
    }

    public final void insertNode(int i, MolAtom node) {
        this.insertAtom(i, node);
    }

    public void removeNode(MolAtom node) {
        this.removeAtom(node);
    }

    public void removeNode(int i) {
        this.removeAtom(i);
    }

    public void removeNode(MolAtom node, int cleanupFlags) {
        this.removeAtom(node, cleanupFlags);
    }

    public void removeNode(int i, int cleanupFlags) {
        this.removeAtom(i, cleanupFlags);
    }

    public Vector<MolAtom> getNodeVector() {
        Vector<MolAtom> v = new Vector<MolAtom>(this.getAtomCount());
        v.addAll(Arrays.asList(this.getAtomArray()));
        return v;
    }

    public int getEdgeCount() {
        return this.getBondCount();
    }

    public MolBond getEdge(int i) {
        return this.getBond(i);
    }

    public void setEdge(int i, MolBond edge) {
        this.setBond(i, edge);
    }

    public final void insertEdge(int i, MolBond edge) {
        this.insertBond(i, edge);
    }

    public void insertEdgeInOrder(MolBond e, MolBond[] order) {
        this.insertBondInOrder(e, order);
    }

    public void replaceEdge(MolBond olde, MolBond newe) {
        this.replaceBond(olde, newe);
    }

    public void removeEdge(MolBond edge) {
        this.removeBond(edge);
    }

    public void removeEdge(int i) {
        this.removeBond(i);
    }

    public MolBond[] getEdgeArray() {
        return this.getBondArray();
    }

    public Vector<MolBond> getEdgeVector() {
        Vector<MolBond> v = new Vector<MolBond>(this.getBondCount());
        v.addAll(Arrays.asList(this.getBondArray()));
        return v;
    }

    public void removeAllEdges() {
        this.removeAllBonds();
    }

    public void regenEdges() {
        this.regenBonds();
    }

    public void sortEdgesAccordingTo(MolBond[] order) {
        this.sortBondsAccordingTo(order);
    }

    public void mergeNodes(MolAtom that, MolAtom a) {
        this.mergeAtoms(that, a);
    }

    protected MoleculeGraphGearch createGearch() {
        return new MoleculeGraphGearch(this);
    }

    public int getMaxRgroupAttachmentPointOrder() {
        int order = 0;
        for (int i = 0; i < this.getAtomCount(); ++i) {
            MolAtom a = this.getAtom(i);
            if (a.getRgroupAttachmentPointOrder() <= order) continue;
            order = a.getRgroupAttachmentPointOrder();
        }
        return order;
    }

    @Deprecated
    public int mergeFrags(int id1, int id2) {
        return this.mergeFrags(id1, id2, 1);
    }

    public int mergeFrags(int id1, int id2, int fragmentationType) {
        return this.gearch.mergeFrags(id1, id2, fragmentationType);
    }

    protected void setFlags(int f, int mask) {
        this.flags = this.flags & ~mask | f & mask;
    }

    void update(MolAtom atom) {
    }

    void update(MolBond bond) {
    }

    public void setValenceCheckEnabled(boolean b) {
        this.setFlags(b ? 32 : 0, 32);
    }

    public boolean isValenceCheckEnabled() {
        return (this.getFlags() & 0x20) != 0;
    }

    public void setValenceCheckState(ValenceCheckState state) {
        switch (state) {
            case OFF: {
                this.setFlags(0, 32);
                break;
            }
            case AMBIGUOUS_AROMATIC_ATOMS_IGNORED: {
                this.setFlags(32, 32);
                this.setFlags(0, 64);
                break;
            }
            default: {
                this.setFlags(32, 32);
                this.setFlags(64, 64);
            }
        }
    }

    public ValenceCheckState getValenceCheckState() {
        if ((this.getFlags() & 0x20) == 0) {
            return ValenceCheckState.OFF;
        }
        if ((this.getFlags() & 0x40) == 0) {
            return ValenceCheckState.AMBIGUOUS_AROMATIC_ATOMS_IGNORED;
        }
        return ValenceCheckState.FULL;
    }

    public boolean isLargeMolecule() {
        return this.getGraphUnion().getAtomCount() > 1000;
    }

    public static enum ValenceCheckState {
        OFF,
        AMBIGUOUS_AROMATIC_ATOMS_IGNORED,
        FULL;

    }

    private final class MySmolecule
    implements Smolecule {
        private MySmolecule() {
        }

        @Override
        public String getName() {
            return MoleculeGraph.this.getName();
        }

        @Override
        public int getAtomCount() {
            return MoleculeGraph.this.getAtomCount();
        }

        @Override
        public int getBondCount() {
            return MoleculeGraph.this.getBondCount();
        }

        @Override
        public MPropertyContainer properties() {
            return MoleculeGraph.this.properties();
        }

        @Override
        public int getArrayFlags() {
            return 4095;
        }

        @Override
        public int getAtomType(int k) {
            return MoleculeGraph.this.getAtom(k).getAtno();
        }

        @Override
        public int getCharge(int k) {
            return MoleculeGraph.this.getAtom(k).getCharge();
        }

        @Override
        public int getRadical(int k) {
            return MoleculeGraph.this.getAtom(k).getRadical();
        }

        @Override
        public int getMassno(int k) {
            return MoleculeGraph.this.getAtom(k).getMassno();
        }

        @Override
        public int getHybridizationState(int k) {
            return MoleculeGraph.this.getAtom(k).getHybridizationState();
        }

        @Override
        public int getQPropAsInt(int k, String name) {
            return MoleculeGraph.this.getAtom(k).getQPropAsInt(name);
        }

        @Override
        public boolean inAtomList(int k, int atno) {
            int[] list = MoleculeGraph.this.getAtom(k).getList();
            for (int i = 0; i < list.length; ++i) {
                if (list[i] != atno) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getImplicitHcount(int k) {
            return MoleculeGraph.this.getAtom(k).getImplicitHcount();
        }

        @Override
        public int getImplicitHcount() {
            int n = this.getAtomCount();
            int sum = 0;
            for (int i = 0; i < n; ++i) {
                sum += MoleculeGraph.this.getAtom(i).getImplicitHcount();
            }
            return sum;
        }

        @Override
        public int getExplicitHcount(int k) {
            return MoleculeGraph.this.getAtom(k).getExplicitHcount();
        }

        @Override
        public int getHcount(int k) {
            MolAtom a = MoleculeGraph.this.getAtom(k);
            return a.getImplicitHcount() + a.getExplicitHcount();
        }

        @Override
        public int getValence(int k) {
            return MoleculeGraph.this.getAtom(k).getValence();
        }

        @Override
        public int getAtomMap(int k) {
            return MoleculeGraph.this.getAtom(k).getAtomMap();
        }

        @Override
        public int getRgroupId(int k) {
            return MoleculeGraph.this.getAtom(k).getRgroup();
        }

        @Override
        public final int getParity(int atom) {
            return MoleculeGraph.this.getParity(atom);
        }

        @Override
        public final int getChirality(int atom) {
            return MoleculeGraph.this.getChirality(atom);
        }

        @Override
        public final int getAtomStereo(int atom) {
            int parity = MoleculeGraph.this.getParity(atom);
            int chirality = MoleculeGraph.this.getChirality(atom);
            return parity | chirality;
        }

        @Override
        public int getNeighborCount(int k) {
            return MoleculeGraph.this.getCtab()[k].length;
        }

        @Override
        public int getNeighbor(int k, int i) {
            return MoleculeGraph.this.getCtab()[k][i];
        }

        @Override
        public boolean areNeighbors(int k, int l) {
            return MoleculeGraph.this.getAtom(k).isBoundTo(MoleculeGraph.this.getAtom(l));
        }

        @Override
        public int getAtom1(int i) {
            return MoleculeGraph.this.indexOf(MoleculeGraph.this.getBond(i).getAtom1());
        }

        @Override
        public int getAtom2(int i) {
            return MoleculeGraph.this.indexOf(MoleculeGraph.this.getBond(i).getAtom2());
        }

        @Override
        public Gearch gearch() {
            if (MoleculeGraph.this.gearch == null) {
                MoleculeGraph.this.regenGearch();
            }
            return MoleculeGraph.this.gearch;
        }

        @Override
        public int getBondIndex(int k, int l) {
            return MoleculeGraph.this.getBondTable().getBondIndex(k, l);
        }

        @Override
        public int getBondType(int i) {
            return MoleculeGraph.this.getBond(i).getType();
        }

        @Override
        public int getBondType(int k, int l) {
            int i = this.getBondIndex(k, l);
            if (i >= 0) {
                return MoleculeGraph.this.getBond(i).getType();
            }
            throw new IllegalArgumentException("no " + k + "-" + l + " bond exists");
        }

        @Override
        public int getBondFlags(int i) {
            return MoleculeGraph.this.getBond(i).getFlags();
        }
    }
}

